use v6.d;
use lib $*PROGRAM.parent(2).add( 'lib' ).absolute;

use Test;
use FindBin;

%*ENV< PERL6LIB > = Bin.add( '../lib' );

# use alt regex to test for method via '~' or something 
# similar. allows symlinking "dd-<madness>~<method>.t" to 
# quickly iterate whether there is, obviously, any method
# in your madness.

( $*PROGRAM-NAME.IO.basename ~~ m{^ (\d+ '-')? (.+) '.'t $} )
or bail-out 'Unable to parse test name: ' ~ $*PROGRAM-NAME;

my $madness = $1.subst( '-', '::', :g );

note "# Madness: '$madness' ($0)" ;

use-ok $madness;

lives-ok 
{
    require ::( $madness );

    my $found   = ::( $madness ).^name;

    is $found, $madness, "Package '$found' installed ($madness).";
},
"require '$madness' survives.";

# by this point it should be out of scope.

is ::( $madness ).^name, 'Failure', "Package '$madness' block scoped.";

done-testing;

