;; Quail package `chinese-py-b5
;;   Generated by the command `titdic-convert'
;;	Original TIT dictionary file: PY-b5.tit

;; # Header added for Emacs -*- coding: cn-big5 -*-
;; #
;; # This file is included in the directory contrib/clients/cxterm of the
;; # distribution of X11R6.  As the file itself doesn't contain copyright
;; # and license notices, the following statements in the section 6 of
;; # the file .../cxterm/README covers it.
;; #
;; # X11R6 CXTERM (C) 1994 BY YONGGUANG ZHANG.
;; # X11R5 CXTERM (C) 1991 BY YONGGUANG ZHANG AND MAN-CHI PONG.
;; #
;; # Permission to use, copy, modify, and distribute this software and
;; # its documentation for any purpose is hereby granted without fee,
;; # provided that this entire copyright and permission notice appear
;; # in all such copies, and that the name of the authors may not be
;; # used to endorse or promote products derived from this material
;; # without specific prior written permission.  The authors make no
;; # representations about the suitability of this software for any
;; # purpose.  It is provided "as is" without express or implied warranty.
;; #
;; # End of header added for Emacs
;; # HANZI input table for cxterm
;; # To be used by cxterm, convert me to .cit format first
;; # .cit version 2
;; ENCODE:	BIG5
;; AUTOSELECT:	NO
;; PROMPT:	漢字輸入::拼音::\040
;; #
;; COMMENT	漢語拼音輸入方案介紹   (注音符號對照)
;; COMMENT	
;; COMMENT				聲母 (CONSONANT)
;; COMMENT	
;; COMMENT	ㄅ ㄆ ㄇ ㄈ  ㄉ ㄊ ㄋ ㄌ  ㄍ ㄎ ㄏ  ㄐ ㄑ ㄒ  ㄓ ㄔ ㄕ ㄖ  ㄗ ㄘ ㄙ
;; COMMENT	b  p  m  f   d  t  n  l   g  k  h   j  q  x   zh ch sh r   z  c  s
;; COMMENT	玻 坡 摸 佛  得 特 訥 勒  哥 科 喝  基 欺 希  知 蚩 詩 日  資 雌 思
;; COMMENT	
;; COMMENT				韻母 (VOWEL)
;; COMMENT	
;; COMMENT		ㄚ  ㄛ  ㄜ  ㄝ  ㄞ  ㄟ  ㄠ  ㄡ  ㄢ  ㄣ  ㄤ  ㄥ  ㄦ
;; COMMENT		a   o   e   e   ai  ei  ao  ou  an  en  ang eng er
;; COMMENT		啊  喔  鵝 (耶) 哀  欸  熬  歐  安  恩  昂 (亨) 兒
;; COMMENT	
;; COMMENT	    ㄧ  ㄧㄚ ㄧㄛ ㄧㄜ ㄧㄝ ㄧㄞ ㄧㄟ ㄧㄠ ㄧㄡ ㄧㄢ ㄧㄣ ㄧㄤ ㄧㄥ
;; COMMENT	C+   i   ia   io   --   ie   --   --   iao  iu   ian  in  iang  ing
;; COMMENT	 +  yi   ya   yo   --   ye   ai   --   yao  you  yan  yin yang ying
;; COMMENT	    衣   呀   唷        耶   崖        腰   憂   煙   因   央   英
;; COMMENT	
;; COMMENT	    ㄨ  ㄨㄚ ㄨㄛ ㄨㄜ ㄨㄝ ㄨㄞ ㄨㄟ ㄨㄠ ㄨㄡ ㄨㄢ ㄨㄣ ㄨㄤ ㄨㄥ
;; COMMENT	C+  u    ua   uo   --   --   uai  ui   --   --   uan  un  uang  ong
;; COMMENT	 +  wu   wa   wo   --   --   wai  wei  --   --   wan  wen wang weng
;; COMMENT	    屋   蛙   窩             歪   威             彎   溫   汪   翁
;; COMMENT	
;; COMMENT	    ㄩ  ㄩㄚ ㄩㄛ ㄩㄜ ㄩㄝ ㄩㄞ ㄩㄟ ㄩㄠ ㄩㄡ ㄩㄢ ㄩㄣ ㄩㄤ ㄩㄥ
;; COMMENT	j+   u   --   --   --   ue   --   --   --   --   uan  un   --  iong
;; COMMENT	l+  u:   --   --   --  u:e   --   --   --   --  u:an  u:n  --   --
;; COMMENT	 +  yu   --   --   --  yue   --   --   --   --  yuan  yun  --  yong
;; COMMENT	    迂                  約                       冤   暈        雍
;; COMMENT	
;; COMMENT	C+ -> 前面帶有聲母的時候,       + -> 前面沒有聲母的時候,
;; COMMENT	j+ -> 跟聲母 j,q,x 拼的時候,   l+ -> 跟聲母 l,n 拼的時候
;; COMMENT
;; # define keys
;; VALIDINPUTKEY:	12345:abcdefghijklmnopqrstuvwxyz
;; WILDCARDKEY:	*
;; WILDCHARKEY:	?
;; SELECTKEY:	1\040
;; SELECTKEY:	2
;; SELECTKEY:	3
;; SELECTKEY:	4
;; SELECTKEY:	5
;; SELECTKEY:	6
;; SELECTKEY:	7
;; SELECTKEY:	8
;; SELECTKEY:	9
;; SELECTKEY:	0
;; BACKSPACE:	\010\177
;; DELETEALL:	\015\025
;; MOVERIGHT:	.>
;; MOVELEFT:	,<
;; REPEATKEY:	\020\022
;; # the following line must not be removed
;; BEGINDICTIONARY

;;; End of the header of original TIT dictionary.

;;; Code:

(require 'quail)

(quail-define-package "chinese-py-b5" "Chinese-BIG5" "拼B"
 t
"漢字輸入::拼音::

	漢語拼音輸入方案介紹   (注音符號對照)
	
				聲母 (CONSONANT)
	
	ㄅ ㄆ ㄇ ㄈ  ㄉ ㄊ ㄋ ㄌ  ㄍ ㄎ ㄏ  ㄐ ㄑ ㄒ  ㄓ ㄔ ㄕ ㄖ  ㄗ ㄘ ㄙ
	b  p  m  f   d  t  n  l   g  k  h   j  q  x   zh ch sh r   z  c  s
	玻 坡 摸 佛  得 特 訥 勒  哥 科 喝  基 欺 希  知 蚩 詩 日  資 雌 思
	
				韻母 (VOWEL)
	
		ㄚ  ㄛ  ㄜ  ㄝ  ㄞ  ㄟ  ㄠ  ㄡ  ㄢ  ㄣ  ㄤ  ㄥ  ㄦ
		a   o   e   e   ai  ei  ao  ou  an  en  ang eng er
		啊  喔  鵝 (耶) 哀  欸  熬  歐  安  恩  昂 (亨) 兒
	
	    ㄧ  ㄧㄚ ㄧㄛ ㄧㄜ ㄧㄝ ㄧㄞ ㄧㄟ ㄧㄠ ㄧㄡ ㄧㄢ ㄧㄣ ㄧㄤ ㄧㄥ
	C+   i   ia   io   --   ie   --   --   iao  iu   ian  in  iang  ing
	 +  yi   ya   yo   --   ye   ai   --   yao  you  yan  yin yang ying
	    衣   呀   唷        耶   崖        腰   憂   煙   因   央   英
	
	    ㄨ  ㄨㄚ ㄨㄛ ㄨㄜ ㄨㄝ ㄨㄞ ㄨㄟ ㄨㄠ ㄨㄡ ㄨㄢ ㄨㄣ ㄨㄤ ㄨㄥ
	C+  u    ua   uo   --   --   uai  ui   --   --   uan  un  uang  ong
	 +  wu   wa   wo   --   --   wai  wei  --   --   wan  wen wang weng
	    屋   蛙   窩             歪   威             彎   溫   汪   翁
	
	    ㄩ  ㄩㄚ ㄩㄛ ㄩㄜ ㄩㄝ ㄩㄞ ㄩㄟ ㄩㄠ ㄩㄡ ㄩㄢ ㄩㄣ ㄩㄤ ㄩㄥ
	j+   u   --   --   --   ue   --   --   --   --   uan  un   --  iong
	l+  u:   --   --   --  u:e   --   --   --   --  u:an  u:n  --   --
	 +  yu   --   --   --  yue   --   --   --   --  yuan  yun  --  yong
	    迂                  約                       冤   暈        雍
	
	C+ -> 前面帶有聲母的時候,       + -> 前面沒有聲母的時候,
	j+ -> 跟聲母 j,q,x 拼的時候,   l+ -> 跟聲母 l,n 拼的時候


Pinyin base input method for Chinese Big5 characters
(`chinese-big5-1', `chinese-big5-2').

This input method works almost the same way as `chinese-py' (which
see).

This input method supports only Han characters.  The more convenient
method is `chinese-py-punct-b5', which is the combination of this
method and `chinese-punct-b5' and which supports both Han characters
and punctuation/symbols.

For double-width Big5 characters corresponding to ASCII, use the input
method `chinese-qj-b5'.

The input method `chinese-py' and `chinese-tonepy' are also Pinyin
based, but for the character set GB2312 (`chinese-gb2312').
"
 '(("\C-?" . quail-delete-last-char)
   
   ("." . quail-next-translation)
   (">" . quail-next-translation)
   ("," . quail-prev-translation)
   ("<" . quail-prev-translation))
 nil nil nil nil)

(quail-define-rules
("a1" "阿ㄚ")
("a2" "啊阿")
("a4" "阿")
("ai1" "挨哀埃唉哎ㄞ誒")
("ai2" "捱皚騃敳崖睚啀娾")
("ai3" "矮藹靄欸毐昹佁")
("ai4" "愛礙艾曖璦隘噯乂靉僾堨嬡鑀賹濭鴱譪誒薆")
("an1" "安鞍庵諳氨銨ㄢ鵪媕侒盦峖痷腤萻韽垵")
("an2" "雸玵啽")
("an3" "俺唵晻堷")
("an4" "暗案岸按黯菴闇犴豻匼桉洝荌錌匎婩儑")
("ang1" "骯腌ㄤ")
("ang2" "昂卬")
("ang3" "軮")
("ang4" "盎醠")
("ao1" "凹ㄠ坳柪")
("ao2" "熬敖遨翱嗷螯鰲鼇鏖驁廒獒璈聱鏊滶磝隞摮蔜簢謷爊")
("ao3" "襖媼芺镺")
("ao4" "傲澳奧懊墺奡扷擙詏嶴")
("b" "ㄅ")
("ba1" "八捌巴疤芭笆粑叭扒豝吧仈朳")
("ba2" "拔跋鈸魃茇鼥軷犮菝胈詙")
("ba3" "把靶鈀")
("ba4" "罷爸霸壩耙弝灞伯猈")
("ba5" "吧罷琶杷")
("bai1" "掰")
("bai2" "白")
("bai3" "百擺佰襬粨捭矲絔")
("bai4" "敗拜唄粺椑矲庍")
("ban1" "班般搬斑頒扳瘢虨斒攽褩")
("ban3" "板版闆阪舨昄鈑粄蝂")
("ban4" "半辦伴扮拌絆姅瓣爿怑湴鉡靽")
("bang1" "幫邦傍梆鞤縍垹")
("bang3" "榜綁牓膀氆")
("bang4" "棒磅謗蚌傍鎊旁甏塝艕")
("bao1" "包胞苞褒枹笣蕔孢")
("bao2" "雹窇瓝")
("bao3" "保寶飽堡褓葆鴇怉駂鳵媬")
("bao4" "報抱暴爆豹鮑刨趵鉋虣鑤儤菢煲袌嚗犦忁")
("bei1" "背杯悲卑碑俾揹偝盃裨萆桮椑伓綼鵯藣")
("bei3" "北")
("bei4" "被備背貝輩倍臂狽憊悖孛焙蓓褙邶琲誖鋇哱糒梖珼鄁牬郥犕奰")
("ben1" "奔賁錛泍渀")
("ben3" "本畚苯")
("ben4" "笨体坌")
("beng1" "崩繃伻弸祊閍塴絣")
("beng2" "甭")
("beng3" "菶玤琫埲誁")
("beng4" "蹦搒洴迸跰")
("bi1" "逼屄偪稫豍")
("bi2" "鼻")
("bi3" "比筆彼鄙匕沘秕屄蚍妣疕潷柀朼貏")
("bi4" "必敝畢壁避璧閉鄙臂幣弊婢斃碧泌俾蔽庇嗶愎辟弼裨陛埤箄篦畀比嬖睥賁贔襞毖蓽蹕髀怭庳愊楅湢狴獘篳苾薜觱詖躄邲閟柲梐珌痺飶馝駜鎞鷩皕堛鉍痹腷骳坒滭熚疪妼鏎鷝柫佖蜌彃箅蓖鄪罼鮅襒鵖襣驆鼊芘粊稗嫳獙廦鄨縪")
("bian1" "邊編鞭蝙砭籩箯稨猵甂柉楄煸")
("bian3" "扁貶匾褊窆萹惼碥")
("bian4" "便變遍辨辯汴辮忭弁釆抃緶艑卞揙汳鴘閞")
("biao1" "標彪鑣鏢飆膘熛麃羆嘌杓滮瀌猋瘭穮颮驫摽儦臕颩髟謤墂贆蔈爂藨")
("biao3" "表錶婊裱俵褾檦諘")
("biao4" "鰾")
("bie1" "憋鱉虌")
("bie2" "別蹩咇徶襒蟞")
("bie3" "癟蛂")
("bie4" "彆縪")
("bin1" "賓濱彬檳儐斌繽豳瀕邠璸蠙鑌豩汃椕霦矉驞")
("bin4" "殯鬢儐擯臏髕鶣")
("bing1" "兵冰掤栟")
("bing3" "餅丙稟柄秉炳昺邴怲鞞鉼蛃陃苪窉屏庰")
("bing4" "並病併并摒寎鵧偋")
("bo1" "波玻撥剝菠缽嶓砵碆袚襏鱍啵柭蹳岥")
("bo2" "伯博柏泊勃搏渤駁薄脖帛舶箔荸蔔膊鈸餑鉑欂鵓踣浡襮踄鎛駮僰餺髆桲謈檗馞胉挬猼葧鋍懪簙礡鑮郣鸔糪")
("bo3" "跛簸蚾")
("bo4" "播擘簸亳薜譒薄檗蘗繴挀")
("bu1" "逋晡餔峬鵏")
("bu2" "不")
("bu3" "補捕埔哺卜鳪獛")
("bu4" "不部布步怖佈簿埠鈽蔀篰捗咘")
("c" "ㄘ")
("ca1" "擦搽嚓")
("ca3" "礤")
("ca4" "囃")
("cai1" "猜")
("cai2" "才財材裁纔")
("cai3" "採彩采睬踩綵跴寀棌婇")
("cai4" "蔡菜埰采縩")
("can1" "參餐驂")
("can2" "殘蠶慚嬠")
("can3" "慘憯朁噆黲")
("can4" "燦孱璨粲澯")
("cang1" "蒼倉滄艙傖鶬凔嵢")
("cang2" "藏鑶")
("cao1" "操糙鄵喿")
("cao2" "曹槽嘈漕螬艚嶆")
("cao3" "草懆騲艸")
("cao4" "糙操肏襙")
("ce4" "冊策測側廁惻筴畟茦粣拺矠憡蓛")
("cen1" "參嵾梫")
("cen2" "岑涔梣笒埁")
("ceng1" "噌")
("ceng2" "曾層嶒鄫碀")
("ceng4" "蹭")
("ch" "ㄔ")
("cha1" "差插叉喳艖嗏扠杈偛疀鎈")
("cha2" "查察茶搽槎鍤碴臿垞秅")
("cha3" "蹅")
("cha4" "詫岔剎差汊衩蜡侘奼紁")
("chai1" "拆釵差偨")
("chai2" "柴豺儕祡喍")
("chai4" "蠆袃囆")
("chan1" "攙梴襜辿鋓惉嬓欃")
("chan2" "纏蟬禪饞讒潺蟾巉嬋單澶廛孱劖毚瀍瀺躔鑱磛艬僝棎湹鋋煘獑繵嚵酁")
("chan3" "產鏟闡剷蕆嘽囅丳嵼燀諂驏幝繟滻簅灛旵譂")
("chan4" "懺羼儳")
("chang1" "昌倡猖娼閶菖鯧倀鼚錩淐琩裮")
("chang2" "長常場嘗裳償腸嫦鱨徜嚐萇鋿粻")
("chang3" "場廠敞氅昶鋹")
("chang4" "唱倡暢悵鬯韔")
("chao1" "抄鈔超勦弨怊訬剿罺")
("chao2" "朝潮巢嘲晁樔轈鄛")
("chao3" "吵炒眧")
("chao4" "耖")
("che1" "車硨莗")
("che3" "扯撦奲")
("che4" "徹澈轍撤掣坼屮迠硩")
("chen1" "嗔琛瞋郴賝棽謓諃搷堔")
("chen2" "陳沉晨臣塵辰娠忱宸諶煁茞蔯樄莐愖鈂螴麎鷐伔敶")
("chen3" "捵磣鍖裖墋踸贂")
("chen4" "趁稱襯櫬讖疢齔嚫藽儭")
("cheng1" "稱撐瞠蟶偁檉赬琤橕鏿浾埥棦牚竀崝饓")
("cheng2" "成程承盛乘誠呈城懲澄橙丞澂棖酲宬晟裎郕埕掁湞珵荿騬脀脭揨峸鋮塍")
("cheng3" "逞騁悜庱塣")
("cheng4" "稱秤偁牚")
("chi1" "吃蚩癡痴嗤喫ㄔ郗魑笞絺鴟媸摛瓻螭眵齝离貾誺瞝齹黐麶")
("chi2" "持池遲馳匙弛墀坻踟箎茬蚳篪蚔茌痄忯汦荎栘歭耛貾趍箈徲謘徥")
("chi3" "尺齒恥呎侈褫欼搋蚇恀拸姼傂誃鉹伬鶒")
("chi4" "赤翅斥飭叱熾啻傺敕眙抶饎栻遫彳跮踅鷘乿瘛鉓哧淔痸懘戠摰")
("chong1" "充衝沖舂忡憧珫茺浺蹖祌")
("chong2" "重崇虫蟲种翀蝩隀茧痋")
("chong3" "寵")
("chong4" "衝銃揰")
("chou1" "抽瘳搊篘犨婤")
("chou2" "愁仇籌綢酬稠紬躊疇惆裯儔讎幬鯈薵嬦椆絒菗懤詶雔燽栦")
("chou3" "丑醜瞅杻杽吜莥")
("chou4" "臭簉溴殠憱")
("chu1" "出初齣貙")
("chu2" "除儲廚鋤櫥雛芻躇滁躕篨耡蜍鉏蒢跦鶵幮貙趎犓")
("chu3" "處楚儲礎杵褚楮濋檚")
("chu4" "處觸畜絀矗黜俶怵搐歜詘鄐斶亍豖泏琡踀滀儊臅敊")
("chua1" "欻")
("chuai2" "膗")
("chuai3" "揣")
("chuai4" "踹嘬")
("chuan1" "穿川鐉氚瑏")
("chuan2" "傳船遄椽歂諯暷輲")
("chuan3" "喘舛荈")
("chuan4" "串釧玔汌賗")
("chuang1" "窗創瘡囪憃戧摐")
("chuang2" "床幢撞橦")
("chuang3" "闖搶漺")
("chuang4" "創闖愴刱獊")
("chui1" "吹炊")
("chui2" "垂鎚槌搥椎陲錘捶棰箠圌湷倕菙綞娷腄甀")
("chui4" "吹炊諈")
("chun1" "春椿杶輴焞鰆媋暙鶞")
("chun2" "純唇醇淳蓴鶉漘錞脣憌鯙")
("chun3" "蠢惷踳偆萶")
("chuo1" "戳")
("chuo4" "綽輟齪婼啜惙歠醊婥畷逴娖吷珿磭腏趠擉嚽")
("ci1" "疵庛雌ㄘ差趀骴")
("ci2" "詞辭慈磁瓷雌祠疵茨粢餈柌嬨濨呲飺薋")
("ci3" "此佌泚玼跐皉")
("ci4" "次刺賜廁伺佽蛓莿朿栨蚝絘")
("cong1" "匆聰從囪璁瑽樅驄蓯鏦熜棇暰蔥瞛蟌鍐")
("cong2" "從叢淙琮悰潀漎賨錝婃孮徖慒")
("cong4" "欉藂謥")
("cou4" "湊輳腠楱")
("cu1" "粗麤觕")
("cu2" "殂徂")
("cu4" "促醋簇蹴蔟蹙猝卒錯趣趨鏃瘯踧槭梀噈窣殧鼀")
("cuan1" "攛躥鋑")
("cuan2" "攢巑劗")
("cuan4" "竄篡爨篹")
("cui1" "摧催崔嗺墔磪鏙榱衰")
("cui2" "凗慛")
("cui3" "璀趡漼")
("cui4" "翠脆粹悴瘁萃啐淬倅毳橇焠竁膬綷膵脺濢")
("cun1" "村皴")
("cun2" "存袸")
("cun3" "忖刌")
("cun4" "寸吋籿")
("cuo1" "搓撮磋蹉蒫遳髊")
("cuo2" "瘥矬鹺痤醝嵯蔖")
("cuo3" "瑳脞縒硰")
("cuo4" "錯措挫銼撮剉厝莝侳剒齰蓌")
("d" "ㄉ")
("da1" "搭褡答撘咑耷")
("da2" "答達韃靼瘩怛繨噠妲笪荅薘褟鐽匒呾畣炟鎝")
("da3" "打")
("da4" "大")
("dai1" "呆獃")
("dai3" "歹逮")
("dai4" "代帶待袋戴怠殆黛貸迨大玳岱逮襶埭靆紿廗汏忕瀻軩跢艜蹛柋酨")
("dan1" "單擔丹耽簞鄲眈聃酖砃甔襌匰聸勯嚪")
("dan3" "膽疸撢亶紞刐撣玬衴黵丼澸")
("dan4" "但旦淡蛋誕擔彈憚氮啖澹憺儋啗噉石癉窞僤幨霮髧萏鉭暺柦帎潬沊狚觛啿舕蜑嘾鴠癚殫灗泹")
("dang1" "當噹鐺襠璫簹儅蟷澢艡嵣")
("dang3" "檔黨擋讜攩欓党")
("dang4" "當蕩擋盪碭宕菪逿璗愓瓽礑簜闣")
("dao1" "刀叨忉舠氘幍魛")
("dao3" "倒島導禱搗擣捯壔禂")
("dao4" "到道倒稻盜蹈悼導纛翿檤菿瓙")
("de2" "得德淂")
("de5" "的得")
("dei3" "得")
("deng1" "登燈鐙簦豋璒嬁")
("deng3" "等戥")
("deng4" "鄧瞪蹬凳嶝磴墱邆霯")
("di1" "低滴氐羝鞮彽磾鍉袛菂墑熵")
("di2" "的敵迪狄笛滌翟荻嫡嘀鏑蹢芽犒糴覿篴蔋靮梑潪苖嚁鸐藋藡")
("di3" "底抵邸詆牴砥氐坻柢弤觝呧阺聜菧軧扺")
("di4" "地第弟帝遞蒂的締諦娣睇棣杕玓禘蔕螮踶楴渧碲虳釱樀旳軑梊焍馰墆嵽珶甋")
("dia1" "嗲")
("dian1" "顛巔癲滇掂傎瘨敁蹎槙齻厧")
("dian3" "點典碘錪婰琠蕇")
("dian4" "電店殿甸奠墊澱惦靛佃淀玷鈿簟坫痁癜磹阽扂婝踮壂")
("diao1" "雕凋刁貂鵰碉叼彫瞗琱鯛扚蛁鳭虭殦")
("diao3" "屌")
("diao4" "調掉釣吊弔窵蓧誂伄魡")
("die1" "爹")
("die2" "跌蝶諜碟疊迭牒喋瓞耋絰咥垤堞蜨蹀鰈跕昳峌挕胅苵眣聑臷詄镻艓褋惵楪嶀")
("ding1" "丁釘叮疔酊盯仃玎帄靪虰")
("ding3" "頂鼎酊嵿濎薡")
("ding4" "定訂釘錠碇飣娗椗掟碠顁萣啶")
("diu1" "丟銩")
("dong1" "東冬咚鼕苳蝀埬崠氡炵涷菄鶇")
("dong3" "懂董嬞墥")
("dong4" "動洞凍棟恫胴挏戙駧霘")
("dou1" "都兜郖")
("dou3" "斗抖陡蚪枓唗敨")
("dou4" "鬥豆逗痘竇荳脰餖鋀梪浢讀")
("du1" "都督嘟闍醏")
("du2" "讀獨毒牘纛瀆犢髑讟黷櫝儥碡殰蝳贕韇韥皾")
("du3" "賭堵睹篤肚錖裻帾")
("du4" "度渡肚妒鍍杜蠹秺喥")
("duan1" "端耑偳剬媏")
("duan3" "短")
("duan4" "段斷緞鍛毈腶籪椴葮碫躖")
("dui1" "堆頧痽")
("dui4" "對隊兌碓懟譈濧薱轛濻瀩憝")
("dun1" "敦蹲墩惇礅驐蜳撉鐓")
("dun3" "盹躉")
("dun4" "頓噸盾鈍遁盹燉沌囤遯炖坉扽伅庉潡崸鶨腞")
("duo1" "多哆柁茤")
("duo2" "奪鐸掇裰剟敪椯剫敓莌毲腏鮵襗")
("duo3" "躲朵埵垛嚲鬌痑趓")
("duo4" "惰墮舵跺剁咄踱馱垛墯嶞柮陏陊度袉貀鵽")
("e1" "阿婀痾ㄜ屙峉錒ㄝ")
("e2" "額訛鵝娥哦蛾峨莪俄囮吪硪蚵鋨迗珴涐皒睋魤")
("e3" "誒")
("e4" "惡餓俄鄂厄遏鍔扼鱷顎呃愕噩軛阨鶚堊諤萼咢啞崿搤詻閼頞堨齶枙胺堮岋鑩櫮砐砨蚅豟軶圔搹蝁嶭餩蘁")
("ei1" "ㄟ")
("en1" "恩嗯ㄣ")
("en4" "摁")
("eng1" "鞥ㄥ")
("er1" "ㄦ兒")
("er2" "兒而洏耏胹輀侕栭陑鮞檽聏荋唲鴯")
("er3" "爾耳洱餌邇珥駬薾鉺峏尒栮")
("er4" "二貳佴刵咡樲聏毦眲衈")
("f" "ㄈ")
("fa1" "發伐瞂")
("fa2" "乏伐罰閥筏砝茷疺藅")
("fa3" "法髮")
("fa4" "法琺")
("fan1" "番翻蕃繙幡帆旛籓僠嬏轓鱕")
("fan2" "凡煩繁帆蕃礬藩樊蘩璠籵墦燔膰蠜蹯颿笲釩瀿鐇勫橎薠羳鷭杋柉瀪")
("fan3" "反返魬")
("fan4" "範范犯氾汎飯販泛梵畈笵鄤奿軓軬滼嬔")
("fang1" "方芳坊枋邡淓鈁匚汸")
("fang2" "房防妨肪坊魴")
("fang3" "訪彷仿紡倣舫昉瓬髣鶭")
("fang4" "放")
("fei1" "非飛菲扉啡妃緋霏馡騑鯡騛婓裶")
("fei2" "肥淝腓萉蜰")
("fei3" "匪翡斐蜚誹悱菲朏棐榧篚奜餥")
("fei4" "廢費肺沸吠痱怫疿芾屝剕狒砩濷癈昲胇俷厞曊鼣櫠蟦鐨")
("fen1" "分紛芬氛吩棻玢酚雰昐鈖砏翂衯饙梤鳻")
("fen2" "墳焚汾枌棼蚡豶鼖幩濆轒鼢妢炃羒蒶黂弅蕡鐼")
("fen3" "粉黺")
("fen4" "份忿奮憤分糞僨瀵坋秎魵橨膹羵")
("feng1" "風蜂封豐瘋峰鋒丰烽楓諷酆葑灃犎捀桻妦檒偑崶蘴飌麷猦")
("feng2" "逢縫馮夆渢堸艂摓")
("feng3" "唪覂")
("feng4" "奉鳳俸諷縫賵焨")
("fiao4" "覅")
("fo2" "佛坲")
("fong4" "甮")
("fou2" "罘芣紑剻")
("fou3" "否缶殕缹鴀")
("fu1" "夫膚敷孵伕麩跗趺柎砆鄜鈇箙罦衭稃邞泭怤尃荴綒鳺姇糐璷紨")
("fu2" "服福扶浮符伏彿縛幅俘拂苻弗孚袱芙輻蝠匐蜉罘涪夫郛莩怫蚨桴紼茯菔紱咈洑綍艴芾茀艀刜帗笰葍袚氟棴澓烰枹玸岪枎垘昲柫琈虙踾鳧巿沷祓翇韍諨鴔黻鵩鶝")
("fu3" "府腐撫輔甫斧俯釜脯腑莆滏嘸拊黼簠頫郙弣鯆暊冹蜅蚥軵父")
("fu4" "父負婦付附富復副傅覆複腹咐赴賦駙阜訃馥賻蝮鮒祔偩輹鰒鍑榑复胕蚹萯蝜褔姇峊蛗緮蕧")
("g" "ㄍ")
("ga1" "嘎旮")
("ga2" "軋噶釓")
("ga4" "尬")
("gai1" "該垓陔賅荄侅峐胲祴絯豥賌隑")
("gai3" "改")
("gai4" "概蓋丐鈣溉戤摡瓂")
("gan1" "乾甘干竿肝尷柑坩泔咁疳玕杆矸虷筸蜬鳱嵅")
("gan3" "敢感趕桿橄稈澉皯盰赶")
("gan4" "幹贛淦紺旰骭詌榦灨涻簳嵅")
("gang1" "剛鋼缸崗綱岡肛扛杠罡疘舡釭堽碙棡笐堈犅")
("gang3" "港崗")
("gang4" "槓")
("gao1" "高糕膏篙羔皋櫜睪鼛槔睾滜韟")
("gao3" "稿攪搞槁縞杲暠檺筶")
("gao4" "告誥郜鋯祰煰")
("ge1" "哥歌割鴿擱胳戈肐疙渮牁菏滒麧")
("ge2" "格革隔閣葛骼蛤咯膈轕嗝搿郃韐塥觡鬲閤挌佮輵鮯敆茖愅獦鎘齃")
("ge3" "葛哿舸擖魺騔笴")
("ge4" "個各鉻虼箇")
("ge5" "個")
("gei3" "給")
("gen1" "跟根")
("gen2" "哏")
("gen3" "艮")
("gen4" "亙艮茛")
("geng1" "更耕庚粳羹賡浭緪鶊菮揯")
("geng3" "梗耿哽綆鯁埂骾郠挭")
("geng4" "更亙堩")
("gong1" "工公功供攻宮恭躬弓蚣紅龔肱觥疘釭篢塨愩匑共幊")
("gong3" "鞏拱汞共珙礦栱廾拲蛬穬")
("gong4" "共供貢羾摃")
("gou1" "句溝勾鉤枸泃篝緱构芶耩")
("gou3" "狗茍岣枸苟笱耇茩蚼")
("gou4" "夠購垢構媾彀搆詬遘覯冓姤雊傋瞉簼韝唦")
("gu1" "姑孤辜咕沽估菇菰呱蛄痼箍鴣觚酤泒罛箛鈷鮕夃柧鈲軱家嫴橭")
("gu2" "骨鶻")
("gu3" "股古鼓骨谷穀賈凸蠱汩牯滑罟嘏詁轂鵠瞽臌盬羖蛌扢鈷杚淈狜唃尳榖蓇濲瀔愲縎薣")
("gu4" "故固顧雇僱錮告估痼梏榾牿堌崮凅棝稒")
("gua1" "瓜括刮蝸颳聒鴰栝适騧胍腡筈葀劀瘑緺懖趏膼")
("gua3" "寡剮")
("gua4" "掛卦褂罫罣絓詿挂髺")
("guai1" "乖")
("guai3" "拐柺枴")
("guai4" "怪旝夬廥癐")
("guan1" "官關觀冠棺矜鰥綸倌莞瘝毌鱞")
("guan3" "管館莞琯筦脘痯錧")
("guan4" "慣貫灌罐摜盥鸛冠觀丱爟瓘祼矔鑵涫悺悹雚鱹")
("guang1" "光胱洸桄珖炚茪銧垙烡")
("guang3" "廣獷")
("guang4" "逛桄臩臦矌")
("gui1" "歸規龜瑰閨圭珪皈傀媯槻鮭槼邽窐溈嫢摫")
("gui3" "鬼軌詭癸匭晷宄簋佹垝氿姽蟡庪祪蛫觤厬")
("gui4" "貴桂櫃跪劌溎鱖昋炔筀柜嶡襘暩")
("gun3" "滾袞鯀緄輥掍蔉")
("gun4" "棍璭")
("guo1" "郭鍋蟈堝嘓崞埻墎濄")
("guo2" "國幗虢馘摑聝膕漍慖簂")
("guo3" "果裹槨蜾輠粿猓淉惈鐹錁")
("guo4" "過")
("h" "ㄏ")
("ha1" "哈")
("ha2" "蛤")
("ha3" "哈")
("hai1" "咳嗨咍")
("hai2" "還孩骸頦")
("hai3" "海醢烸")
("hai4" "害亥駭嗨氦嗐絯餀")
("han1" "酣鼾蚶憨頇魽唅甝谽嫨")
("han2" "寒含函涵韓邯汗邗榦琀梒鋡焓")
("han3" "喊罕厂蔊豃嚂")
("han4" "和漢汗旱焊憾翰撼悍頷扞瀚閈捍暵熯晥犴睅菡豻銲釬駻哻涆淊馯蜭頜螒顄雗攌譀鋎鶾")
("hang1" "夯")
("hang2" "行航杭吭頏桁迒苀肮蚢斻貥雽魧")
("hang3" "酐")
("hang4" "行沆")
("hao1" "蒿嚆薅")
("hao2" "號毫豪壕濠蠔貉嚎鶴蚵嗥籇諕勂譹")
("hao3" "好郝")
("hao4" "號耗浩皓鎬涸昊好灝澔皜顥鄗秏淏滈皞哠悎鰝昦薃")
("he1" "喝呵訶峆")
("he2" "何合和河荷核盒禾褐劾闔閤曷龢涸盍覈蓋貉閡紇滆翮蝎嗑齕郃餲鶡鉌魺鞨菏姀毼熆蒚篕螛礉盉廅楁澕趷")
("he4" "賀和鶴喝荷嚇赫郝暍嗃熇猲翯佫煂")
("he5" "和")
("hei1" "黑嘿潶")
("hei3" "黑")
("hen2" "痕拫鞎")
("hen3" "很狠")
("hen4" "恨")
("heng1" "亨哼脝諻")
("heng2" "橫恆衡珩蘅桁姮鑅楻誙諻揘佷")
("heng4" "橫啈澋絎")
("hong1" "轟哄烘薨訇吽揈渹哅輷谾鍧焢魟")
("hong2" "紅洪宏鴻虹弘泓訌鋐閎黌竑紘翃浤鞃灴葒耾仜汯竤鈜霟妅玒谹渱舼触谼篊彋瓨苰")
("hong3" "哄嗊")
("hong4" "鬨汞澒蕻鍙")
("hou1" "齁")
("hou2" "猴侯喉篌鍭餱瘊銗翭鯸葔")
("hou3" "吼")
("hou4" "後候厚后逅鱟垕堠郈鄇缿洉")
("hu1" "忽呼乎惚滹戲猢欻膴虖吰虍幠寣昒歑烼垀曶啒峘淴謼匢淲")
("hu2" "胡湖壺蝴糊狐弧葫鬍瑚餬斛鵠囫縠衚觳醐猢搰鶘槲媩抇鰗焀魱螜瀫楜嘝鶦")
("hu3" "虎琥滸唬許汻")
("hu4" "護戶互滬扈瓠怙祜笏冱戽楛沍岵鄠臛頀枑槴昈嫭婟嫮熩豰綔謢蔰")
("hua1" "花華嘩鷨錵")
("hua2" "華滑划猾譁嘩樺驊鏵豁劃崋釫螖")
("hua4" "話化畫劃樺華嫿摦崋嬅杹觟槬繣澅")
("huai2" "懷淮徊槐踝佪怀褢褱櫰瀤")
("huai4" "壞坏諙孬咶蘹蘾")
("huan1" "歡驩讙獾犿懽酄鴅")
("huan2" "還環桓繯鬟鍰鐶寰闤梡洹瓛貆澴荁萑肒捖羦懁豲嬛狟雈")
("huan3" "緩皖澣睆輐")
("huan4" "換喚宦患幻煥奐渙瘓豢梡逭擐漶垸轘瑍觨嚾瞣")
("huang1" "荒慌肓衁巟嚝")
("huang2" "黃徨惶簧璜磺蝗煌皇凰湟遑隍潢篁喤艎鍠熿韹鰉堭蟥偟穔鷬媓騜崲葟餭撗獚趪")
("huang3" "謊恍晃幌洸怳榥熀鎤滉皝")
("huang4" "晃軦")
("hui1" "灰揮輝恢詼暉麾徽墮褌撝隳煇翬豗褘洃隓顪鰴拻噅禈")
("hui2" "回迴蛔茴蚘洄痐恛藱")
("hui3" "會悔誨毀燬賄虺虫烠毇檓譭")
("hui4" "會惠匯繪慧彙穢誨賄晦彗諱潰卉蕙濊燴喙恚薈翽闠嘒槥篲繢繐蟪璯嬇憓潓瞺譓譿鏸橞廆詴圚蔧獩餯鐬饖芔禬襘")
("hun1" "婚昏葷閽惛睯殙棔涽敯睧")
("hun2" "魂渾餛混琿楎餫棞顐鼲繉轋")
("hun3" "混睔")
("hun4" "混渾溷諢圂慁輥倱梡")
("huo1" "豁")
("huo2" "活佸鈥萿")
("huo3" "火伙夥鈥")
("huo4" "或穫獲和惑禍霍貨豁壑蠖嚄藿鑊矱檴濩砉雘硅擭湱騞謋捇沎眓掝嗀瓁臒攉瀖曤矐韄靃")
("huo5" "和")
("i" "ㄧㄟ")
("ie" "ㄝ")
("j" "ㄐ")
("ji1" "機基積績蹟激跡姬雞饑肌稽飢奇畸箕磯譏羈几机乩屐躋璣幾嘰畿嵇犄齎其期居唧勣禨欚癘羇虀觭霙蛣銈枅丌尐簊虮鐖櫅稘毄樍諅齍鞿鑇鰿齏笄剞隮鸄癪")
("ji2" "及級極即集急擊疾籍吉寂輯脊圾唧嫉汲亟吃棘藉瘠楫岌笈鶺戢殛蹐伋蒺耤芨蕺踖鈒佶堲姞濈襋墼潗鴶嶯洁忣湒极銡狤鏶蝍衱偮庴莋塉槉漃膌蓻橶蕀轚霵彶揤楖秸鞊螏觙")
("ji3" "幾給己擠脊戟濟几麂庋蟣剞掎泲踦魕丮穖妀撠")
("ji4" "計記既紀際繼季寄技妓濟劑繫悸祭忌暨冀騎鯽稷躋薺驥霽薊髻罽覬伎洎瘈跽嚌塈惎漈穧芰蔇痵癠穄鮆鱭鯚鰶旡刉臮裚穊誋鬾瞡檕璾鵋齌懻瀱鱀蘮蘻")
("jia1" "家加嘉佳傢迦枷袈痂笳珈跏茄葭豭耞麚泇毠鎵鴐猳幏犌貑夾")
("jia2" "夾挾頰蛺莢浹戛郟恝袷筴裌鋏梜跲舺唊鉿硈扴鞂鞈鵊")
("jia3" "假甲賈鉀岬胛斝榎瘕檟婽玾徦椵夏")
("jia4" "價假架駕嫁賈稼价")
("jian1" "間監堅尖兼肩艱奸姦煎緘濺漸箋殲菅戔鞬牋椷縑湔熸蒹鶼廌犍籛豜韉鬋鈃鑯鰹鰜櫼熞蕑揃搛幵菺靬葌鳽餰礛騝鵳瀸虃惤猏麉")
("jian3" "簡撿剪減檢揀繭儉鹼柬筧翦謇戩蹇譾趼堿囝鰔挸湕瞼寋藆襺暕瑐")
("jian4" "見建健漸件間監鍵鑑箭劍艦鑒賤踐諫毽薦餞腱濺僭檻閒洊俴牮栫楗珔瀳澗瞷荐諓榗糋鰎蔪鋻螹襉糮鑳")
("jiang1" "將江疆僵漿姜薑豇殭韁螿橿茳礓瓨翞")
("jiang3" "講獎蔣槳顜膙")
("jiang4" "降匠醬強將絳糨洚謽嵹彊弶袶")
("jiao1" "教交膠驕焦嬌郊跤澆蛟蕉礁椒茭姣鮫僬憍艽鷦燋詨鱎鐎鵁鷮嘄憿膲穚蟂鷍嶕蟭")
("jiao2" "嚼")
("jiao3" "腳角繳攪勦矯絞姣佼餃皎僥剿較鉸狡皦儌筊蟜摷撟捁灚曒漅劋譑煍")
("jiao4" "教叫校較覺轎窖皭醮徼噭嶠挍斠珓釂滘窌嘂潐譥")
("jie1" "街接皆階揭偕嗟喈幯結湝薢袺啑椄菨蝔鶛")
("jie2" "節潔傑捷竭劫截結杰頡詰桀睫訐咭拮羯櫛桔孑癤絜偈擷倢劼婕楬碣鮚岊榤犵袺嵑栨騔滐鉣鐑衱迼崨嵥楶趌踕擳瀄鍻蠽昅揤緁巀緳")
("jie3" "姐解姊檞媎")
("jie4" "界借介戒藉屆疥芥誡解唶喈玠蚧犗褯吤岕价砎悈紒祴躤繲")
("jin1" "今金禁津斤巾筋襟矜浸觔衿祲瑧菳珒埐紟嶜惍")
("jin3" "緊僅錦謹儘覲瑾饉槿墐殣堇慬菫巹")
("jin4" "進近盡禁晉儘浸勁覲燼廑噤靳縉僅藎妗贐寖搢肵璡賮嬧榗僸蓳瘽嚍濜璶伒溍")
("jing1" "經精京驚睛莖晶菁兢涇鯨荊旌粳黥箐鶄巠婛旍鵛鶁鼱麠仱惊")
("jing3" "景警井頸阱儆璟憬剄璥丼烴憼暻蟼燛")
("jing4" "敬竟鏡靜境淨競逕徑靖勁凊脛痙獍倞靚竫婧桱俓凈葝擏弳")
("jiong1" "扃坰駉")
("jiong3" "窘迥煚泂炅絅褧冏熲囧皛炯幜顈")
("jiu1" "糾揪啾鳩轇湫樛揫勼朻牞觓揂萛鬮")
("jiu3" "九久酒玖赳灸韭糾")
("jiu4" "就究救舊舅臼柩疚咎僦鷲廄捄慦鯦麔")
("ju1" "居拘駒沮疽蛆狙俱車鋸裾苴趄罝菹娵椐腒崌痀琚雎涺葅鮈鶋斪揟蜛踙輋")
("ju2" "局鞠菊橘掬跼桔挶鞫侷匊踘鋦鵙鶪椈焗淗驧狊梮郹犑輂箤趜鵴蘜鼳陱駶")
("ju3" "舉矩咀莒沮齟櫸筥踽蒟椇柜竘袓跙蝺")
("ju4" "據句具巨劇聚俱拒距鋸懼鉅炬詎遽倨瞿踞颶泃苣窶醵屨秬虡寠鐻佢据粔姖怚絇足耟岠埧蚷駏澽貗躆洰焣壉犋")
("juan1" "捐娟鵑涓鐫圈蠲朘身脧裐")
("juan3" "捲卷埢菤臇")
("juan4" "倦卷眷絹雋悁狷圈獧睊睠罥鄄帣錈腃韏鬳")
("jue1" "噘嗟撅")
("jue2" "決覺絕爵掘嚼訣厥獗蹶蕨崛攫倔抉噱矍觖角孓玨劂橛爝譎屩觼玦腳臄蕝躩戄桷潏鴃貜趹鱖傕嵑瘚蠼鐍钁玃捔芵焆鈌蚗谻赽僪憰蟨彏鱊鷢堀殌穱")
("jue3" "蹶")
("jue4" "倔")
("jun1" "軍君均鈞皸囷麇莙鮶桾蚐袀頵龜碅")
("jun3" "窘蜠")
("jun4" "俊菌郡峻竣雋濬駿蕈浚珺畯焌捃餕箘寯晙呁鵘葰蔨")
("k" "ㄎ")
("ka1" "咖喀哈鉲")
("ka3" "卡咳佧")
("ka4" "喀髂")
("kai1" "開揩痎侅")
("kai3" "凱慨楷愷剴豈鎧塏闓鍇颽暟輆")
("kai4" "慨愾愒咳欬烗勓壒")
("kan1" "刊堪勘戡看龕嵁")
("kan3" "砍侃坎崁檻欿轗歁歞埳凵顑")
("kan4" "看瞰勘闞矙磡衎墈鬫竷")
("kang1" "康慷糠鏮漮嫝")
("kang2" "扛")
("kang3" "慷")
("kang4" "亢抗炕伉匟囥犺閌邟鈧")
("kao1" "尻")
("kao3" "考烤拷栲攷薧洘")
("kao4" "靠銬犒")
("ke1" "科柯刻棵顆苛瞌磕蚵蝌軻稞窠珂砢簻薖峇鈳樖犐嵙")
("ke2" "咳殼")
("ke3" "可渴哿坷岢堁敤嶱閜")
("ke4" "客課刻克剋喀溘恪嗑榼緙髁氪騍搕厒勀")
("ken3" "肯啃墾懇齦齗豤錹")
("ken4" "掯硍裉")
("keng1" "坑硜鏗牼吭阬硻銵娙挳鍞")
("keng3" "挳")
("kong1" "空崆倥箜悾硿涳錓")
("kong3" "恐孔倥")
("kong4" "空控鞚")
("kou1" "摳彄芤袧鏂")
("kou3" "口")
("kou4" "扣寇叩蔻釦鷇筘佝怐滱瞉簆")
("ku1" "哭枯窟骷跍挎桍刳顝胐橭")
("ku3" "苦楛")
("ku4" "庫褲酷嚳矻瘔趶")
("kua1" "誇夸姱荂晇侉")
("kua3" "垮侉銙")
("kua4" "跨胯骻")
("kuai1" "咼喎")
("kuai3" "蒯")
("kuai4" "快塊會筷檜劊鄶澮膾噲獪儈鱠駃鬠欳")
("kuan1" "寬髖臗")
("kuan3" "款窾梡")
("kuang1" "匡框筐誆劻恇洭")
("kuang2" "狂誑鵟")
("kuang3" "俇")
("kuang4" "況礦曠框眶鄺貺壙纊絖懭爌彉")
("kui1" "虧窺盔闚刲悝鞹鍷茥藈噅巋蘬")
("kui2" "魁睽奎揆葵逵戣夔騤暌鄈頯聧楏櫆湀馗楑犪躨")
("kui3" "傀跬頍煃蹞峞")
("kui4" "愧潰匱饋餽喟簣媿聵憒簀蕢瞶槶樻鐀嘳撌騩硊蔮")
("kun1" "昆崑坤琨錕焜褌晜鯤菎騉髡惃猑")
("kun3" "捆綑悃梱閫壼稛硱裍齫")
("kun4" "困睏涃")
("kuo3" "擃")
("kuo4" "括擴闊廓鞹漷蛞姡霩籗")
("l" "ㄌ")
("la1" "拉啦喇柆鞡翋菈")
("la2" "剌邋旯")
("la3" "喇藞")
("la4" "臘蠟鑞辣剌腊落鬎瘌揧楋")
("la5" "啦")
("lai2" "來萊徠淶騋箂崍郲錸鯠棶庲鶆唻")
("lai4" "賴癩瀨籟睞賚藾娕")
("lan2" "蘭籃藍欄攔瀾襤婪嵐闌襴讕斕籣欗糷灆灡譋躝")
("lan3" "覽懶攬欖纜壈爦灠醂嬾顲浨")
("lan4" "爛濫纜鑭爁壏")
("lang1" "啷")
("lang2" "郎狼廊螂瑯琅榔稂莨蜋桹筤鋃俍崀欴")
("lang3" "朗閬硠峎悢誏烺塱")
("lang4" "浪埌蒗")
("lao1" "撈")
("lao2" "勞牢癆澇嘮醪浶鐒簩蟧嶗")
("lao3" "老姥佬栳狫轑咾橑銠恅荖")
("lao4" "勞絡烙酪嫪軂橯僗")
("le4" "樂垃勒肋泐埒叻仂捋扐阞砳鰳氻哷竻")
("le5" "了")
("lei1" "勒")
("lei2" "雷纍擂嫘鐳羸縲罍檑畾櫑瓃蠝轠壨欙")
("lei3" "累壘儡漯耒磊蕾誄藟樏癗礌絫磥鑸瘣櫑櫐礨灅讄鸓頛礧蘲虆")
("lei4" "類淚累擂纇酹銇儽蘱禷")
("leng2" "稜崚棱薐蔆倰楞")
("leng3" "冷")
("leng4" "愣踜楞")
("li1" "哩")
("li2" "離璃黎梨籬釐犛罹貍驪犁漓灕狸藜蜊蠡鸝嫠褵黧梩漦縭蔾氂厘蘺剺喱篱醨鱺劙孋廲騹孷樆謧鯬鵹攡麗菞鑗黐粍麶")
("li3" "李里裡理禮哩浬鯉娌俚澧邐醴蠡鱧鋰粴豊峛欚")
("li4" "力立利麗歷壢例曆莉厲勵礪粒蒞靂瀝儷隸礫吏荔栗慄俐痢癘笠戾唳酈琍詈嚦溧蠣櫪沴糲櫟轢瓅鬁猁盭篥苙唎屴躒釙鬲皪秝瑮轣岦朸欐禲赲鴗砅濿砬悷蚸厤筣綟蜧磿斄犡藶蠫鷅麜攦觻鷑攭鱳靋栵浰塛搮蝷儮曞讈瓥鱱娳")
("lia3" "倆")
("lian2" "連聯憐廉蓮漣簾鐮鰱奩璉帘褳嗹鎌鬑溓蠊槤縺謰覝磏濂翴薕蹥譧奱嬚")
("lian3" "臉鄻膦摙僆羷")
("lian4" "練鍊戀煉鏈殮斂瀲楝襝湅澰蘞歛薟萰堜")
("liang2" "良梁量糧涼粱樑椋綡輬駺")
("liang3" "兩倆魎緉裲")
("liang4" "量亮諒輛喨晾涼啢踉湸悢")
("liao1" "撩")
("liao2" "聊寮遼療寥撩僚潦嘹繚鐐嫽獠鷯屪鷚膋漻摎豂嵺憀嶚敹窷膫簝镽飂飉顟")
("liao3" "了瞭蓼憭釕暸鄝蟟")
("liao4" "廖料瞭燎尥撂炓蟉窲")
("lie1" "咧")
("lie4" "列烈劣裂獵捩冽鬣躐洌茢睙擸趔姴迾脟蛚蛶颲儠鮤鴷犣")
("lin2" "林臨鄰淋鱗麟霖磷琳遴嶙燐璘粼轔潾痳疄瞵惏暽罧驎碄箖甐繗僯翷蹸壣鏻")
("lin3" "凜懍廩檁菻亃綝")
("lin4" "吝躪藺賃橉閵焛")
("ling1" "拎")
("ling2" "零玲靈鈴齡陵凌菱聆羚苓伶綾淩翎鴒囹蛉瓴泠舲酃軨錂櫺柃欞睖砱詅輘霝鯪醽岭昤澪呬坽夌姈狑皊呤琌笭裬蘦怜婈駖蕶爧堎")
("ling3" "領嶺彾")
("ling4" "令另炩")
("liu1" "溜")
("liu2" "劉流留硫琉榴瀏瘤遛旒騮鏐飀鶹懰鎏泵鎦媹嬼嵧藰裗麍鷎蓅鰡巰")
("liu3" "柳綹罶鉚飹珋")
("liu4" "六陸溜餾霤坴翏雡廇塯蹓")
("long2" "龍隆籠嚨聾瓏朧窿瀧癃櫳礱曨巃矓蘢躘豅鏧鑨靇蠪襱鸗儱龒蠬")
("long3" "隴攏壟")
("long4" "衖哢徿梇")
("lou1" "摟")
("lou2" "樓嘍婁螻髏僂蔞廔漊耬熡謱艛鞻鷜瞜")
("lou3" "簍摟塿嶁")
("lou4" "漏陋露鏤瘺")
("lu1" "嚕")
("lu2" "盧蘆廬臚爐顱瀘鱸轤壚鸕玈罏艫鑪籚櫨嚧攎蠦纑")
("lu3" "魯虜擄滷鹵櫓艣磠鐪鏀蓾擼氌")
("lu4" "路陸錄鹿露賂祿碌氯麓鷺戮轆逯漉輅僇潞籙璐甪稑穋簏醁騄淥琭盝磟彔菉蔍錴垏鏕鯥摝硉睩廘熝踛蕗螰簬鵱淕塶蹗")
("lu:2" "驢閭櫚藘慺氀膢")
("lu:3" "呂旅履侶鋁屢縷褸婁膂漊穭梠郘挔絽儢祣")
("lu:4" "律綠率慮濾嵂膟鑢菉葎勴")
("lu:an2" "攣孿")
("lu:an3" "孌")
("lu:e4" "略掠鋝撂擽")
("luan2" "巒鑾鸞灤臠圞欒曫羉癵")
("luan3" "卵")
("luan4" "亂薍")
("lun1" "掄")
("lun2" "倫論輪淪崙侖綸掄圇碖錀惀陯菕踚棆蜦")
("lun3" "稐")
("lun4" "論溣")
("luo1" "囉")
("luo2" "羅螺蘿鑼邏籮騾囉玀儸覶摞欏蔂鏍鸁剆")
("luo3" "裸瘰臝蠃蓏鎯")
("luo4" "落駱洛絡雒烙酪濼犖咯珞纙袼硌鮥鵅峈")
("m" "ㄇ")
("ma1" "媽嗎嬤")
("ma2" "麻痲嘛麼蟆犘")
("ma3" "馬螞碼瑪溤嗎鎷鷌嘜")
("ma4" "罵禡傌榪")
("ma5" "嘛嗎蟆")
("mai2" "埋霾薶")
("mai3" "買嘪鷶")
("mai4" "賣麥邁脈勱蝐")
("man2" "蠻饅瞞蹣漫顢謾鰻璊悗慲槾鬘鬗")
("man3" "滿屘矕")
("man4" "慢漫曼蔓幔嫚鏝縵墁熳澫僈獌")
("mang2" "忙芒茫盲氓尨硭邙哤奀杗盳鋩娏牻痝蛖駹蘉鼆笀")
("mang3" "莽蟒漭汒庬硥茻壾")
("mao1" "貓")
("mao2" "毛茅矛髦錨旄蟊芼蝥髳媌堥罞酕嫹鶜枆軞渵")
("mao3" "卯昴泖茆")
("mao4" "帽冒貌貿茂瑁懋旄耄媢楙眊瞀芼袤毷艒萺鄮")
("mei2" "沒煤眉枚梅媒莓霉玫黴楣湄嵋苺禖郿堳瑂脢鋂呅腜塺徾攗")
("mei3" "美每鎂浼媺渼媄挴燘")
("mei4" "妹媚寐昧眛魅瑁沬袂痗韎煝蝞")
("men1" "悶")
("men2" "門們捫樠鍆穈菛虋")
("men3" "暪")
("men4" "悶燜懣")
("meng2" "蒙盟萌矇朦濛檬懵幪甍瞢艨虻曚甿礞氋雺莔儚蕄鄳鄸饛鸏")
("meng3" "猛蜢艋錳懵蠓懞瓾")
("meng4" "夢孟霿霥")
("mi1" "咪瞇")
("mi2" "迷彌謎瀰靡糜麋縻獼蘼冞麛醚醾檷蘪攠瓕爢麊鸍")
("mi3" "米靡弭敉眯銤渳葞蔝濔灖")
("mi4" "密蜜秘祕覓泌汨謐宓冪塓幦鼏羃幎漞糸峚榓滵蔤蠠嘧")
("mian2" "棉綿眠媔婂蝒櫋矊矏")
("mian3" "免勉緬冕娩靦湎沔偭眄絻丏俛愐喕鮸")
("mian4" "面麵")
("miao1" "喵")
("miao2" "苗描瞄鱙")
("miao3" "秒渺藐邈緲杳眇淼杪篎")
("miao4" "妙廟繆玅")
("mie1" "咩乜羋")
("mie4" "滅蔑衊篾蠛幭覕搣薎懱瀎礣鱴")
("min2" "民岷玟緡痻苠忞旻鈱旼錉罠閺怋崏暋")
("min3" "敏憫閔閩抿泯皿湣愍黽澠笢敃刡僶簢敯潣")
("ming2" "明名鳴銘螟冥瞑暝茗酩溟蓂鄍洺榠嫇覭詺熐")
("ming3" "眳姳慏")
("ming4" "命暝")
("miu1" "唒")
("miu4" "謬")
("mo1" "摸")
("mo2" "模磨摩膜糢魔摹謨蘑劘嫫藦髍")
("mo3" "抹")
("mo4" "末莫默漠沒膜寞陌歿脈沫秣茉驀墨貊磨瘼靺歾饃鄚纆霢嚜眽瞙藦暯枺爅妺万銆鏌貘粖蛨袹嗼塻慔蟔鬕莈覛縸嘜")
("mo5" "麼")
("mou2" "謀眸繆牟侔蝥鍪蛑麰洠鉾鴾呣哞")
("mou3" "某冇踇")
("mu2" "模氁")
("mu3" "母畝牡姆拇牳鉧姥峔砪")
("mu4" "木目幕牧慕墓募穆睦暮沐苜鶩楘霂鉬炑坶毣蚞幙鞪莯")
("n" "ㄋㄣ")
("na2" "拿挐拏誽")
("na3" "那哪")
("na4" "那納吶訥鈉捺娜肭衲軜妠豽魶笝")
("nai2" "孻摨")
("nai3" "乃奶迺氖嬭奈氝釢艿")
("nai4" "耐奈褦鼐柰倷螚渿錼")
("nan1" "囝囡")
("nan2" "南男難喃楠柟暔諵奻萳莮")
("nan3" "赧戁蝻湳腩揇")
("nan4" "難婻")
("nang1" "囔")
("nang2" "囊")
("nang3" "曩攮灢")
("nang4" "齉")
("nao1" "峱")
("nao2" "撓鐃橈呶猱怓譊髐嶩獶繷獿夒")
("nao3" "腦惱瑙")
("nao4" "鬧淖")
("ne1" "呢")
("ne5" "呢")
("nei3" "餒哪腇")
("nei4" "內")
("nen4" "嫩")
("neng2" "能薴儜")
("neng4" "濘")
("ng1" "ㄥ")
("ni2" "泥尼妮倪霓怩猊蜺輗郳麑鯓鯢齯臡秜狋觬婗淣呢狔屔跜鈮鶂")
("ni3" "你妳擬禰儗旎昵坭柅薿檷抳苨馜隬譺")
("ni4" "逆溺匿膩泥睨暱惄鷁鷊嫟縌迡堄")
("nian2" "年黏粘姩")
("nian3" "捻撚攆拈輦碾涊簐跈躎鯰")
("nian4" "念唸淰齞廿鼰")
("niang2" "娘孃")
("niang4" "釀")
("niao3" "鳥裊嬲嬝嫋蔦褭")
("niao4" "尿")
("nie1" "捏踗鑈")
("nie2" "苶")
("nie4" "孽鎳躡聶鑷涅囁囓臬乜嚙臲闑隉齧敜顳糱蘗疌嵲踂篞櫱蠥钀巕")
("nin2" "您")
("nin3" "拰")
("ning2" "寧凝獰嚀檸甯擰鸋鑏寍聹嬣")
("ning3" "擰")
("ning4" "濘佞")
("niu1" "妞")
("niu2" "牛")
("niu3" "紐扭鈕忸狃炄莥")
("niu4" "拗")
("nong2" "農濃膿儂噥穠襛醲齈鬞")
("nong4" "弄")
("nou2" "羺獳")
("nou4" "耨鎒嗕譨")
("nu2" "奴駑孥笯蒘")
("nu3" "努弩砮")
("nu4" "怒")
("nu:3" "女籹釹")
("nu:4" "忸恧衄朒")
("nu:e4" "虐瘧謔")
("nuan3" "暖餪煖渜")
("nuo2" "挪娜儺捼梛")
("nuo3" "橠")
("nuo4" "諾懦糯搦挼逽懧糑")
("o1" "喔ㄛ")
("o2" "哦")
("ou1" "歐甌毆嘔謳鷗ㄡ慪區熰蓲櫙")
("ou2" "吽")
("ou3" "偶藕嘔耦吘湡腢蕅")
("ou4" "嘔漚噢")
("p" "ㄆ")
("pa1" "趴葩啪蚆舥")
("pa2" "爬扒琶耙杷跁")
("pa4" "怕帕帊袙")
("pai1" "拍啪")
("pai2" "排牌徘俳簰棑")
("pai3" "矲俖")
("pai4" "派湃鎃蒎")
("pan1" "潘攀眅")
("pan2" "盤磐蟠般胖槃蹣磻踫鞶幋縏柈瀊蒰媻搫跘")
("pan3" "坢")
("pan4" "判叛盼畔拚袢泮襻詊頄溿沜牉頖")
("pang1" "乓磅滂")
("pang2" "旁龐膀螃徬蒡厖尨雱逄庬篣舽")
("pang3" "嗙耪")
("pang4" "胖")
("pao1" "拋脬")
("pao2" "袍咆刨匏庖麃炰齙鞄炮瓟")
("pao3" "跑")
("pao4" "泡砲炮皰奅麭髱")
("pei1" "胚呸坏醅柸岯垺衃")
("pei2" "培賠陪裴邳碚毰陫荖")
("pei3" "琣昢")
("pei4" "配佩沛珮霈帔旆浿轡姵翇伂")
("pen1" "噴歕")
("pen2" "盆湓葐")
("pen3" "呠翸翉")
("peng1" "砰烹抨怦漰澎匉閛恲軯駍磞")
("peng2" "朋彭澎蓬膨硼棚鵬篷蟛芃淜鬅痭錋倗輣傰韸髼憉樥鑝")
("peng3" "捧皏")
("peng4" "碰堋掽椪")
("pi1" "批披匹劈霹砒被丕坯坏伾狉紕秠鈹鴄怌翍釽憵銔駓髬")
("pi2" "皮疲脾琵枇裨啤毗埤沘貔陂羆罷紕郫陴鼙鈹膍毘阰蚽蜱玭笓鈚錍魾螷犤毞猈藣蠯")
("pi3" "否匹疋痞嚭苤仳庀圮崥諀")
("pi4" "譬闢僻媲屁辟癖甓擗澼濞淠揊潎鷿髲礔")
("pian1" "篇偏扁翩萹媥貵頨鶣")
("pian2" "便胼駢諞蹁楩骿")
("pian4" "片騙遍")
("piao1" "飄漂慓螵薸僄旚翲魒")
("piao2" "瓢嫖淲")
("piao3" "漂莩縹瞟殍皫摽醥犥鷅")
("piao4" "票漂剽驃彯篻顠蔈")
("pie1" "瞥撇氕")
("pie3" "撇")
("pin1" "拼姘礗涄")
("pin2" "貧瀕頻顰嬪嚬矉")
("pin3" "品")
("pin4" "聘牝")
("ping1" "乒娉砯頩覮")
("ping2" "平瓶憑評屏蘋萍坪枰泙帡洴缾軿俜玶甹苹郱呯竮艵蛢馮荓蓱炾")
("ping3" "絣")
("po1" "波潑坡陂鏺癹翍")
("po2" "婆鄱皤櫇")
("po3" "頗剖叵笸")
("po4" "破迫魄珀泊朴粕醱岶烞蒪")
("pou1" "剖吥")
("pou2" "掊裒抔捊")
("pou3" "剖瓿棓婄")
("pu1" "撲仆鋪噗扑痡醭抪瞨")
("pu2" "僕樸葡蒲菩朴蹼脯濮璞匍莆蒱襆酺釙鏷轐纀墣")
("pu3" "普浦埔譜圃溥烳氆鐠潽誧")
("pu4" "暴鋪瀑曝舖")
("q" "ㄑ")
("qi1" "七妻欺戚漆棲悽淒柒萋慼溪沏諆郪娸鸂嘁顣悊榿磎倛咠栖谿凄唭徛桼僛緀磩霋魌鶈攲")
("qi2" "其期齊奇旗騎祈棋祺祁崎琦岐歧琪麒鰭畦臍祇耆淇跂枝綦騏衹蘄圻錡旂萁蜞埼墘蠐頎懠艩蚔軝藄鄿鯕鬐蚑錤掑岓碕翗釮亓蚚稘鬿踑鮨鶀鵸玂麡濝")
("qi3" "起啟豈乞綺杞稽綮屺棨敧芑婍邔芞呇")
("qi4" "企氣器汽棄契砌泣迄訖汔憩緝亟葺磧栔愒妻蟿鏚盵蚑忔湆气諿湇甈鼜")
("qia1" "掐")
("qia3" "卡酠")
("qia4" "恰洽帢愘殎")
("qian1" "千鉛遷簽牽謙籤嵌仟阡韆騫愆僉慳搴褰粁岍汧縴芊掔扦檶鐱婜羥攐攓譣顩奷忏顅麉櫏")
("qian2" "前錢乾潛黔鉗虔箝鈐掮媊揵燂拑鬵灊黚忴扲岒漧葥鳹騚鰬仱姏蚙軡榩")
("qian3" "遣淺譴繾槏撖忏蜸")
("qian4" "欠歉倩慊茜塹芡傔嗛槧縴篟綪棈蒨輤")
("qiang1" "槍腔鎗羌嗆搶鏘鏹蜣蹌斨瑲椌蹡錆矼嶈將牄謒")
("qiang2" "強牆薔戕嬙檣爿漒蘠廧彊")
("qiang3" "強搶襁磢傸墏繈")
("qiang4" "嗆羻唴熗")
("qiao1" "敲鍬橇撬蹺磽蹻墝幧繑髜鐰鏒塙鄡墽骹庨郻頝")
("qiao2" "橋瞧僑喬樵翹憔蕎礄譙簥趫燆劁嘺嫶趬敿")
("qiao3" "巧悄愀鵲雀燋頝")
("qiao4" "翹竅俏峭鞘誚撬殼帩撽躈")
("qie1" "切沏")
("qie2" "茄伽癿")
("qie3" "且")
("qie4" "切竊妾怯愜挈篋鍥契朅踥鯜蛪緀藒洯")
("qin1" "親侵欽衾駸嶔綅瀙鋟")
("qin2" "勤琴秦禽擒芹檎懃噙芩螓鈙嫀斳耹靲澿庈肣蚙軡雂")
("qin3" "寢昑寑曋螼坅顉")
("qin4" "沁撳唚菣")
("qing1" "清青輕傾卿氫蜻頃鯖圊氰狅郬")
("qing2" "情晴擎傾檠勍殑樈殌")
("qing3" "請頃廎")
("qing4" "慶罄親凊綮謦磬漀汫鑋靘掅碃罊")
("qiong1" "芎穹銎")
("qiong2" "窮瓊芎穹跫蛩惸邛璚藭瞏煢筇輁藑桏赹笻橩蒆")
("qiu1" "秋邱丘蚯鞦鰍鶖楸坵萩偢緧媝蓲趥龜恘蝵蟗蠤")
("qiu2" "求球囚仇酋裘遒毬泅鰽逑俅厹璆絿艽虯蝤觩賕盚銶頄鼽訄犰朹梂釚煪苬紌脙莍崷僋蛷鮂鯄殏")
("qiu3" "糗")
("qu1" "區屈驅趨軀嶇曲蛆瞿袪敺蛐佉砠胠岨祛呿凵抾阹镼魼鶌鱋紶髷")
("qu2" "渠劬麴衢蟝瞿籧璩氍蘧磲蕖朐軥鴝翑葋豦懅螶鼩匷灈欋臞蠷躣胊斪淭菃翵")
("qu3" "取曲娶齲浀紶")
("qu4" "去趣娶漆覷闃湨麮刞鼁")
("quan1" "圈悛棬弮絟惓")
("quan2" "全權泉詮拳銓痊顴蜷筌卷荃鬈牷輇佺犬踡醛恮婘犈觠駩巏齤蠸姾瑔跧縓灥")
("quan3" "犬綣甽畎琄虇汱圈")
("quan4" "勸券牶烇絭")
("que1" "缺闕蒛")
("que2" "瘸")
("que4" "卻確鵲雀怯闕榷搉恪殼闋愨埆确碏碻礐硞皵毃礭")
("qun1" "逡踆峮")
("qun2" "群裙宭")
("r" "ㄖㄦ")
("ran2" "然燃髯蛅蚺袡")
("ran3" "染冉髯苒珃橪呥姌嫨")
("rang2" "攘禳穰勷瀼瓤儴獽蘘躟鬤蠰")
("rang3" "嚷壤攘爙")
("rang4" "讓懹")
("rao2" "饒蕘嬈橈蟯襓")
("rao3" "擾")
("rao4" "繞遶隢")
("re3" "惹喏若")
("re4" "熱渃")
("ren2" "人任仁壬紝儿芢銋")
("ren3" "忍稔荏腍棯栠荵")
("ren4" "任認刃飪賃軔衽紉妊恁仞訒韌牣鵀屻肕軠")
("reng1" "扔")
("reng2" "仍礽陾")
("reng3" "扔")
("ri4" "日衵馹鈤")
("rong2" "容榮融溶絨熔戎蓉鎔茸榕羢嶸瑢肜毧狨瀜茙烿蠑爃媶榵褣駥髶鰫鷛")
("rong3" "冗茸氄傇軵")
("rou2" "柔揉韖蹂輮楺禸葇鍒鞣騥鶔媃蝚鰇")
("rou3" "糅鍕粈煣")
("rou4" "肉")
("ru2" "如儒孺茹蠕嚅濡袽襦鴽筎臑醹挐薷銣曘燸帤蕠")
("ru3" "乳汝辱擩女侞")
("ru4" "入辱褥孺茹洳縟蓐溽鄏媷嗕")
("ruan2" "堧壖撋")
("ruan3" "軟阮蠕耎蝡瓀緛礝朊")
("rui2" "蕤緌婑")
("rui3" "蕊橤繠惢桵")
("rui4" "瑞銳芮睿蚋叡枘汭")
("run1" "犉")
("run4" "潤閏橍")
("ruo4" "若弱箬偌爇鄀篛蒻楉鶸")
("s" "ㄙ")
("sa1" "撒仨")
("sa3" "灑撒靸洒")
("sa4" "薩卅趿颯攃馺隡")
("sai1" "鰓腮毢揌")
("sai4" "賽塞僿")
("san1" "三參毿攕鬖")
("san3" "散傘繖糝鏾")
("san4" "散閐")
("sang1" "喪桑")
("sang3" "嗓顙搡磉鎟褬")
("sang4" "喪")
("sao1" "艘騷繅搔臊慅溞颾鱢")
("sao3" "掃嫂埽")
("sao4" "掃氉瘙")
("se4" "色塞瑟圾嗇澀穡濇轖譅銫璱翜犞飋濏")
("sen1" "森蔘槮罧襂幓篸")
("seng1" "僧鬙")
("sh" "ㄕ")
("sha1" "殺沙紗砂莎煞鯊裟杉痧鎩魦樧猀帴摋蔱硰")
("sha2" "啥")
("sha3" "傻")
("sha4" "煞霎廈嗄歃箑翣萐喢")
("shai1" "篩")
("shai3" "骰繺")
("shai4" "曬晒閷殺")
("shan1" "山扇衫杉刪珊羶舢煽潸跚姍芟苫搧摻縿穇挻烻狦笘剼")
("shan3" "閃陜睒晱覢")
("shan4" "善扇汕擅膳繕鄯煽訕單贍疝鱔騸墠嬗掞摲謆墡釤蟺赸儃")
("shang1" "商傷殤觴湯漡蔏螪謪鬺")
("shang3" "賞晌上")
("shang4" "上尚爙姠仩")
("shang5" "裳")
("shao1" "燒稍梢艄捎弰蛸莦筲旓髾輎鮹蕱")
("shao2" "杓韶芍勺玿圴牊")
("shao3" "少")
("shao4" "少紹哨邵召卲劭袑睄潲")
("she1" "奢賒奓檨譇")
("she2" "蛇舌甚佘什揲鉈")
("she3" "捨舍")
("she4" "社設射涉舍攝赦歙麝厙猞灄蔎韘騇拾葉捑蠂")
("shei2" "誰")
("shen1" "身深伸申紳呻信參娠莘甡侁籸葠詵駪燊砷柛氠屾珅胂阠妽峷眒")
("shen2" "神甚")
("shen3" "沈審嬸瀋諗讅矧哂寀瞫邥覾")
("shen4" "慎腎滲甚蜃沁葚椹脤抻侺鋠")
("sheng1" "生聲勝升牲昇甥笙陞泩鉎鼪呏狌湦焺鵿")
("sheng2" "繩澠憴譝鱦溗")
("sheng3" "省眚冼箵偗")
("sheng4" "勝盛聖剩嵊乘賸圣貹")
("shi1" "失施師詩濕溼獅屍ㄕ蝨噓虱尸蓍葹鳲邿湤絁鰤溮鶳箷褷襹螄")
("shi2" "十什石時實食拾蝕碩射提蒔湜鰣塒祏鼫鉐榯湁溡鼭寔")
("shi3" "使始史駛矢屎豕")
("shi4" "市是事世士勢識室示試視式氏適釋飾侍誓逝嗜恃仕柿使螫弒噬拭豉媞筮舐軾諡貰奭戺澨諟襫鈰揓鉽唑翨銴謚遾簭鯷齛跩烒崼徥詍戠褆衋")
("shi5" "匙")
("shou1" "收荍")
("shou2" "熟")
("shou3" "手首守掱艏")
("shou4" "受售壽獸授瘦狩綬")
("shu1" "書輸殊舒梳疏蔬樞紓抒攄姝樗摴殳杸陎綀橾祋軗鵨藲")
("shu2" "叔熟淑塾贖孰菽秫襡埱焂跾鸀虪")
("shu3" "數鼠屬暑署薯蜀黍癙潻藷钃婌襩糬韣")
("shu4" "術數樹束述署豎疏恕庶曙墅漱倏戍澍翛沭裋鉥尌儵鏣鶐")
("shua1" "刷唰鮛")
("shua3" "耍")
("shuai1" "摔衰縗孈")
("shuai3" "甩")
("shuai4" "率帥蟀咰繂")
("shuan1" "栓閂拴")
("shuan4" "涮")
("shuang1" "雙霜孀艭驦鷞孇礵")
("shuang3" "爽塽樉漺慡縔")
("shuang4" "灀")
("shui2" "誰脽")
("shui3" "水")
("shui4" "說睡稅蛻帨涗裞")
("shun3" "盾楯吮揗賰")
("shun4" "順舜瞬蕣鬊瞚")
("shuo1" "說")
("shuo4" "朔碩爍數鑠嗍率蟀帥搠妁槊箾蒴勺欶揱獡鎙")
("si1" "司思斯絲私撕廝鷥嘶ㄙ澌緦偲罳颸禠虒楒鍶凘泀蕬鉰俬覗榹禗蜤磃謕蟴鷈鼶")
("si3" "死")
("si4" "四似賜嗣飼寺肆祀俟伺泗巳耜儩姒笥駟兕涘柶汜肂貄蕼洍")
("song1" "松鬆淞嵩忪菘娀崧濍倯硹蜙")
("song3" "聳慫悚竦傱愯嵷駷")
("song4" "送宋頌訟誦")
("sou1" "搜颼鄋蒐廋溲餿獀醙嗖鎪騪")
("sou3" "叟嗾藪擻瞍謏籔")
("sou4" "嗽")
("su1" "蘇甦酥穌囌櫯")
("su2" "俗")
("su4" "訴速素肅宿塑夙粟溯餗愬蓿觫愫膆謖嗉橚泝涑潚簌蔌樕遫驌鱐鷫嫊玊榡洬栜傃溹憟鋉縤藗僳")
("suan1" "酸痠狻")
("suan3" "匴")
("suan4" "算蒜筭")
("sui1" "雖綏濉睢荽毸眭浽哸娞荾滖")
("sui2" "隨隋雟")
("sui3" "髓嶲瀡巂靃")
("sui4" "歲遂碎穗隧祟燧誶睟穟璲檖襚鐩邃埣賥檅繀禭旞繸鐆")
("sun1" "孫飧蓀猻搎槂薞蕵")
("sun3" "損筍榫簨鎨")
("sun4" "潠愻")
("suo1" "縮梭莎唆娑簑嗦傞挲蓑桫蹜莏趖摍")
("suo3" "所索鎖瑣璅嗩摵鎍鏼")
("suo4" "逤")
("t" "ㄊ")
("ta1" "它他她牠塌褟祂禢")
("ta3" "塔榙鎝")
("ta4" "踏榻蹋獺搨遢嚃躂沓嗒撻遝闥鎉闒錔鞜鞳鰨羍涾傝毾誻鑉漯迖濌龘")
("tai1" "胎苔")
("tai2" "台臺抬颱苔邰跆檯薹炱駘鮐儓嬯籉旲秮")
("tai4" "太態泰汰鈦燤溙呔傣")
("tan1" "貪灘攤癱坍怹抩舑緂探")
("tan2" "談彈痰潭譚檀壇曇罈覃郯錟餤驔鐔倓醰貚婒憛藫橝黮鷤")
("tan3" "坦毯袒襢忐禫菼贉嗿膻憳醓裧")
("tan4" "探嘆歎碳炭賧埮湠羰")
("tang1" "湯鏜鼞蹚蝪")
("tang2" "堂糖唐塘膛螳棠醣搪鏜溏螗瑭赯榶樘漟煻鎕闛橖蓎磄踼薚鶶")
("tang3" "倘躺儻淌帑惝钂鎲戃曭爣矘")
("tang4" "趟燙鐋摥")
("tao1" "掏濤滔饕韜弢絛縚搯慆槄幍翢嫍蜪")
("tao2" "逃桃陶萄淘濤啕洮燾檮匋咷綯鞀醄騊錭駣祹鋾")
("tao3" "討")
("tao4" "套")
("te4" "特慝忒忑鋱貣蟘")
("teng2" "疼騰藤籐謄滕螣縢")
("ti1" "梯踢剔焍")
("ti2" "題提啼堤蹄醍禔稊緹荑騠隄鶗惿厗鍗偍趧謕鶙崹睼蝭蕛鷤")
("ti3" "體体綈")
("ti4" "替惕涕屜悌剃銻嚏倜薙殢裼揥籊鬄悐褅逖鵜")
("tian1" "天添倎屇酟婖")
("tian2" "田甜填恬闐畋窴沺盷湉菾磌")
("tian3" "舔忝殄腆靦淟餂賟悿蚕晪痶")
("tian4" "掭煔瑱")
("tiao1" "挑祧恌庣鮡")
("tiao2" "條調笤佻迢蜩髫岧苕齠鰷鞗芀鎥趒祒")
("tiao3" "挑窕誂宨嬥")
("tiao4" "跳眺糶朓覜頫絩窱脁")
("tie1" "貼帖怗")
("tie3" "鐵帖驖僣")
("tie4" "帖餮蛈")
("ting1" "聽廳汀桯艼耵")
("ting2" "停庭廷亭蜓霆婷渟莛朾筳蝏聤葶鼮楟榳閮嵉綎")
("ting3" "挺艇町梃頲珽脡鋌烶圢侹")
("ting4" "聽")
("tong1" "通恫蓪痌炵熥狪")
("tong2" "同童銅桐潼瞳彤佟僮峒侗艟曈膧穜罿硐橦氃獞茼烔浵鉖餇仝酮迵粡絧朣犝蕫鮦鼨爞哃詷")
("tong3" "統筒桶捅垌筩姛")
("tong4" "痛衕慟蘳")
("tou1" "偷媮")
("tou2" "頭投牏酘")
("tou3" "黈妵紏鈄蘣")
("tou4" "透斢")
("tou5" "頭")
("tu1" "禿鵚涋捸嶀")
("tu2" "圖途突徒塗屠凸荼涂余酴瘏稌腯峹葖鵚捈怢鍎跿梌湥筡蒤瑹駼鶟鷋鼵嵞廜潳鷵")
("tu3" "土吐釷芏唋")
("tu4" "兔吐菟鵵堍")
("tuan1" "湍煓貒")
("tuan2" "團摶糰漙剸慱鏄鷻槫")
("tuan4" "彖褖")
("tui1" "推蓷藬")
("tui2" "頹穨隤魋橔僓蹪弚")
("tui3" "腿俀")
("tui4" "退蛻駾螁")
("tun1" "吞暾啍涒旽")
("tun2" "屯囤豚飩臀軘魨忳芚吨拵")
("tun3" "汆吨畽")
("tun4" "褪螁")
("tuo1" "脫拖托託堶侂挩扥矺沰馲侻詑魠")
("tuo2" "駝陀馱沱佗鴕跎橐坨紽酡砣阤鮀岮碢鞁驒鼉鉈袉飥")
("tuo3" "妥橢撱庹嫷")
("tuo4" "拓唾柝籜蘀跅毻毤")
("u" "ㄡㄨㄩ")
("u:" "ㄩ")
("w" "ㄨ")
("wa1" "哇蛙挖窪呱媧洼穵溛窊窐漥")
("wa2" "娃")
("wa3" "瓦佤")
("wa4" "襪嗢膃")
("wai1" "歪")
("wai3" "舀")
("wai4" "外")
("wan1" "灣彎豌剜莞蜿刓潫")
("wan2" "完玩頑丸汍紈芄烷婠岏抏")
("wan3" "晚碗挽宛婉娩皖輓莞浣蜿畹菀琬鞔綰晼綩鯇倇脕睕鋄睌葂")
("wan4" "萬玩腕惋卍翫忨仴綄万蟃捥踠")
("wang1" "汪尪尢")
("wang2" "王亡")
("wang3" "往網枉罔惘魍輞瀇网暀菵臦")
("wang4" "忘妄望旺王朢迋莣")
("wei1" "威崴偎煨葳隈逶烓椳渨碨愄揋葨隇溾詴蝛覣燰")
("wei2" "為圍微危唯維惟違韋薇巍桅闈濰帷嵬幃囗湋溦鄬鍏鮠潿洈覹醀霺瀢濻癓欈")
("wei3" "委尾偉緯萎諉葦痿猥煒亹隗娓韙寪洧瑋薳蘤韡鮪磈蒍頠暐痏骫椲浘艉芛鍡峗壝喡徫腲蜲儰蓶崣硊踓斖")
("wei4" "為位未魏衛味偽謂胃喂慰餵尉渭畏蔚蘶蝟犩遺亹霨磑罻褽薉媦蜼藯鏏菋犚餧贀讆躗穌鮇徻")
("wen1" "溫瘟轀塭馧瞃豱殟")
("wen2" "文聞紋蚊玟雯閿炆芠琝閺闅鼤駇魰鳼")
("wen3" "穩吻刎呡桽")
("wen4" "問聞紊文汶抆免搵璺妏")
("weng1" "翁嗡螉鶲霐")
("weng3" "蓊滃暡浻瞈聬塕")
("weng4" "甕瓮齆罋")
("wo1" "窩倭渦萵猧踒")
("wo3" "我婐捰")
("wo4" "握臥沃渥斡齷幄涴偓濣焥")
("wu1" "屋烏污汙圬誣嗚巫鎢鄔洿歍ㄨ惡於杇陓剭窏腛鴮螐")
("wu2" "無吳吾梧巫蕪唔蜈誣毋亡牾膴麌鼯郚鋘鋙峿浯珸俉鯃莁鷡洖瞴譕")
("wu3" "五午武舞侮伍鵡憮嫵潕廡仵忤碔甒摀啎捂嵨玝倵橆躌")
("wu4" "勿物務惡誤悟晤霧戊鎢塢兀騖寤軏杌婺鶩堊沕迕遻鋈屼扤煟卼焐靰阢粅矹芴埡逜痦齀蘁岉噁蓩")
("x" "ㄒ")
("xi1" "西希吸攜嘻犧稀悉溪析蟋熙禧膝棲釐嬉兮犀晰羲畦曦僖蜥扱熹奚盻觿譆晞欷蹊樨巇淅皙唏烯傒徯恓窸粞豨醯鼷氥浠潝燨瓗疧酅媐巂悕睎硒蠵鑴榽歖爔琋螇俙徆怷娭屖谿莃菥僁橀螝豯貕鵗騱驨郋桸惁凞闟誒礂")
("xi2" "習昔息席惜媳錫襲熄蓆褶檄覡隰裼嶍螅鰼腊槢焟謵鎴欯棤蒠瘜獥薂霫飁騽蝷")
("xi3" "喜洗徙璽鰓屣蓰囍枲蟢縰纚蹝釃匚狶諰簁葸漇敼")
("xi4" "細戲係系繫夕汐隙歙鬩翕穸咥屭綌肸鄎醯餼滊褉酅潟舄矽鑴卌怬釸鎎釳赩郤熂覤蕮黖謑虩忥恄摡禊齂")
("xia1" "瞎蝦岈颬鍜")
("xia2" "暇峽轄霞俠狹挾匣呷遐硤狎瑕斜黠柙祫洽舝碬騢搳烚冾笚縖珨陝磍赮魻蕸")
("xia4" "下夏嚇廈暇罅芐欱鏬鶷")
("xian1" "先仙掀鮮纖暹姍孅憸躚銛秈韱枮氙馦嬐仚屳奾杴忺澖灦祆僊嘕蓒褼廯襳珗")
("xian2" "賢閒嫌咸鹹弦銜絃嫻涎啣舷閑癇諴蚿憪鷴娹葴胘蛝羬燅礥鷳唌")
("xian3" "險顯鮮癬蘚銑燹跣嶮蜆姺尟幰獫獮玁筅韅毨烍鍌搟鼸齴赻攇禒")
("xian4" "縣現線限憲獻羨陷腺餡蜆莧霰俔僩峴晛睍豏轞鋧涀瀗粯娊撊錎姭")
("xiang1" "鄉相香箱湘襄鑲廂驤緗薌瓖纕欀葙忀")
("xiang2" "詳祥降翔庠")
("xiang3" "想響享餉饗鯗饟晑")
("xiang4" "巷向相像項象橡嚮曏蠁萫闀蟓襐鐌鄉恦潒鱌")
("xiao1" "消銷蕭瀟宵逍囂簫硝霄哮驍梟蠨枵魈鴞嘵綃嘐歊潚烋獢虓蛸痚憢灱呺穘洨涍痟萷踃膮藃櫹髇毊虈庨啋窙顤謼")
("xiao2" "學洨笅郩")
("xiao3" "小曉筱篠謏")
("xiao4" "校笑孝效酵嘯肖傚恔熽踍")
("xie1" "些歇蠍蝎猲褉嗋")
("xie2" "協鞋斜脅諧邪偕頡挾絜攜擷勰纈襭脥慀劦蝢垥拹籺奊龤愶搚瑎熁燲")
("xie3" "寫血")
("xie4" "謝械洩屑瀉懈卸泄蟹解屜褻榭契駭廨渫邂燮楔絏薤紲媟嶰澥瀣獬躞灺疶鞢骱駴偰檞齘伳妎祄榍韰屧焎揳齥躠")
("xin1" "心新辛薪欣鋅馨鑫莘炘歆芯昕訢鈊盺兟廞忻妡噷")
("xin2" "尋鄩杺攳襑")
("xin3" "伈")
("xin4" "信釁芯焮舋膷囟妡煡阠")
("xing1" "興星猩腥馨惺騂煋瑆胜垶蛵觲馫")
("xing2" "行形型刑邢陘硎鉶餳侀烆洐胻鋞濴")
("xing3" "省醒擤渻")
("xing4" "行興性幸姓杏倖悻荇婞莕涬")
("xiong1" "兄兇胸凶匈洶忷哅恟")
("xiong2" "雄熊赨")
("xiong4" "敻詗")
("xiu1" "修休羞脩咻庥貅髹饈鵂滫樇臹茠銝蓨鎀潃")
("xiu3" "朽宿糔")
("xiu4" "秀繡鏽袖嗅宿臭琇溴岫珛玊殠褎螑")
("xu1" "須需虛鬚噓墟戌胥訏吁歔盱嬃繻殈旴呴楈嬬鑐欨倠稰縃蝑蕦驉魖晇幁揟糈")
("xu2" "徐")
("xu3" "許栩煦咻詡冔姁湑諝醑鄦珝喣")
("xu4" "序續蓄緒敘絮旭恤卹酗婿畜洫旮侐慉漵藚頊芧藇魆勖勗訹鱮烅怴垿窢瞲銊沀昫瞁")
("xuan1" "宣軒喧瑄萱暄壎儇諼塤嬛揎翾諠愃晅鍹鶱梋煖萲愋佡昍鋗媗禤蝖蠉矎")
("xuan2" "玄旋懸漩璇璿伭妶琁玹嫙誸還縣蜁")
("xuan3" "選咺烜")
("xuan4" "炫絢漩眩泫渲旋眴楦敻鉉衒蔙駽鞙鏇昡楥袨縼讂贙")
("xue1" "薛靴噱嶨吙")
("xue2" "學穴鷽觷踅燢澩壆")
("xue3" "雪鱈")
("xue4" "血雪穴削趐泬謞岤袕")
("xun1" "勳薰燻熏醺峋曛焄獯纁臐蔒勛矄")
("xun2" "尋巡詢循旬馴潯珣蟳洵荀徇恂峋栒燖璿紃郇鱘槆撏枔咰璕橁蕁噚")
("xun4" "訊訓迅遜殉馴徇巽汛蕈噀侚潠韗迿鵔")
("ya1" "呀壓鴉鴨押丫椏煆孲")
("ya2" "牙芽涯衙蚜押枒犽齖伢堐")
("ya3" "亞啞雅掗厊庌蕥雃疋")
("ya4" "亞訝迓砑氬婭揠錏聐軋圠襾玡猰窫齾")
("yan1" "煙焉淹殷醃咽胭奄湮菸嫣燕蔫閹厭崦臙鄢漹猒珚偣嬮酀腌")
("yan2" "研言顏嚴延沿炎癌鹽岩筵簷閻妍蜒檐埏喦揅碞綖郔巖孍楌礹閰娮鈆狿虤顃壛麙壧莚嵒")
("yan3" "眼演掩衍郾偃兗甗儼魘剡弇罨沇巘扊揜渰蝘黶姶戭棪嬿鰋鼴琰匽厴椼抁龑酓嵃愝萒隒裺褗鶠黤曮惔躽馣黭")
("yan4" "驗燕厭晏雁宴淹豔燄彥堰硯咽嚥唁饜研讌諺沿讞焱釅贗喭灩爓閆鷃嬿鴳醼焰牪姲鷰椻曣懨婩傿鴈噞騴觾艷驠莚敥")
("yang1" "央秧殃鴦鞅泱坱胦柍佒姎紻鉠雵")
("yang2" "楊陽揚洋羊佯烊瘍鍚徉颺暘煬垟昜禓蛘瑒珜鐊崵鸉眻婸")
("yang3" "養仰氧癢鞅卬攁岟炴抰痒懩蝆")
("yang4" "樣養恙漾怏煬瀁羕")
("yao1" "要腰夭妖邀么吆喲喓祅葽訞")
("yao2" "搖謠堯遙姚洮瑤僥淆餚颻傜繇嶢徭殽猺軺爻垚崤銚珧柼猇鰩肴媱烑窯嗂愮榣顤")
("yao3" "咬窈舀夭殀杳窅窔鷕宎抭苭眑偠溔榚騕岆嫍蓔")
("yao4" "要藥耀曜鑰鷂拗燿袎靿艞覞穾筄葯獟趭")
("ye1" "耶噎蠮ㄝ")
("ye2" "爺耶椰琊揶擨")
("ye3" "也野冶埜漜")
("ye4" "業葉頁夜咽謁拽靨鄴燁瞱擫射曄饁煠鍱鐷澲鎑偞殗嶪擛")
("yi1" "一壹衣依醫伊揖噫漪猗咿ㄧ禕繄黟曀銥泆鷖欹郼圪溰稦燚洢陭蛜嫛瑿檹毉黳嶬")
("yi2" "遺疑移宜怡姨儀夷誼胰貽飴咦詒沂頤彝椸痍圯嶷笫桋匜宧洟簃訑貤迻杝柂袲酏峓眱羠鈶寲侇珆衪銕呲恞萓沶栘瓵袘羡蛦暆跠歋熪箷螔顊謻觺鸃")
("yi3" "以已乙倚椅矣蟻艤迤苡偯扆旖螘扡酏鳦釔齮顗檥鉯迆胣礒掜陭崺晲轙")
("yi4" "意義易議亦益異藝億憶譯液役翼疫毅逸邑抑肄繹溢縊軼詣屹佚翌羿驛掖懿裔臆曳奕蜴腋衣刈翳挹鎰囈弈佾乂弋艾懌劓圛斁薏悒瘞仡勩埸嶧帟曀杙枻殪浥熠艗襼饐黓亄唈燡藙豷寱阣熤劮檍嗌廙鐿鞥醳醷翊肊异枍伿浂澺芅熼玴抴蘙俋焲燱晹垼釴捙欭埶羛隿殔跇裛嫕緆膉靾槷潩蓺墿瘱謚繶瀷帠槸霬鷾齸")
("yin1" "因音陰姻殷茵慇氤瘖喑堙愔禋絪裀闉駰銦蒑諲垔韾洇凐歅噾霠韽黫摿")
("yin2" "銀吟寅淫鄞齦檐霪垠夤狺嚚崟誾蟫婬冘苂釿圁烎凐荶殥蔩檭鷣鏔")
("yin3" "引飲隱尹癮蚓听靷紖縯讔趛螾馻鈏檃濦蘟粌")
("yin4" "印飲隱蔭胤廕窨憖湚垽猌朄酳")
("ying1" "應英鷹嬰鶯櫻膺瑛鸚嚶罌纓攖瓔嫈甖罃煐韺甇霙碤礯朠蝧渶褮偀霒蘡譻蠳鶧")
("ying2" "營迎蠅螢贏盈瑩縈瀛滎嬴塋熒楹瀅瀠籯瀯謍攍巆廮藀")
("ying3" "影景穎潁癭郢瀴矨梬浧")
("ying4" "應硬映媵瀅鎣摬賏")
("yo1" "唷")
("yong1" "傭庸雍擁壅癰臃墉鏞慵饔邕廱雝嗈灉鄘噰澭蕹滽郺")
("yong2" "傭喁顒傛槦嫆嵱嫞")
("yong3" "永泳詠勇擁踴湧蛹甬壅恿臃俑踊埇塎禜涌悀銢")
("yong4" "用佣醟")
("you1" "優憂幽悠呦攸耰麀櫌鄾懮怮嚘瀀纋蚴")
("you2" "由游遊尤油郵猶猷鈾輶疣蚰蕕斿蝣訧逌楢魷优沋浟偤秞莤")
("you3" "有友酉莠牖黝羑泑銪岰庮苃聈槱")
("you4" "又右幼誘佑柚釉祐有宥侑囿鼬卣姷狖峟貁鴢扰牰迶")
("yu1" "淤迂瘀紆ㄩ毹箊扜穻盓")
("yu2" "於愉魚娛餘于漁予愚余竽榆逾虞俞輿瑜渝隅臾腴盂諛踰舁圩歟覦畬萸嵎窬妤揄歈禺轝隃雩杅楰玗緰羭蝓褕瘐艅狳邘璵硢籅釪崳湡鄃腧睮雓澞蕍螸謣鮽鵌蘛鸆鸒衧唹堣堬雽歶旟鰅齵")
("yu3" "與語雨予羽嶼宇禹庾齬噢圄圉窳傴俁敔噳楀瑀与萭貐偊祤斞鄅寙篽蘌斔螤")
("yu4" "育遇預玉欲域喻愈譽獄慾浴裕煜寓禦與鈺豫御鬱籲諭癒郁馭昱毓芋尉熨俞峪聿嫗彧飫鬻谷鷸燠蜮堉語瘉棫澦矞禺罭蕷遹閾隩鵒棜淢燏獝繘魊薁驈悆鴥鋊淯黦栯砡礜欥軉輍悇稢蒮噊鳿醧饇爩灪戫袬緎蓹錥")
("yuan1" "冤淵鴛鳶宛眢蜎鵷肙鋺惌棩蒬裷鼘葾蜵裫駌嬽灁")
("yuan2" "原元員園圓緣源援媛袁猿垣沅轅爰圜黿嫄櫞芫湲騵笎羱蝯邧蝝妧萲螈蚖杬榞溒媴猭獂榬蒝鎱邍鶢")
("yuan3" "遠妴")
("yuan4" "院願怨苑遠媛瑗愿掾褑夗謜禐噮")
("yue1" "約曰噦箹焥")
("yue4" "月越樂悅閱粵躍岳嶽耀鑰曜藥鉞說刖瀹籥樾爚礿禴趯軏鸑龠狘玥戉泧鈅抈蚎蘥鸙")
("yun1" "暈氳縕贇奫蝹")
("yun2" "雲云勻昀耘芸紜熅筠溳澐畇篔沄熉鋆蕓妘伝縜荺鄖枃眃")
("yun3" "允隕殞狁霣褞抎賱輑鈗阭")
("yun4" "運韻孕熨蘊慍醞惲暈韞鄆薀枟緷鶤員")
("z" "ㄗ")
("za1" "紮匝咂唼嘁抸鉔")
("za2" "雜咱砸偺雥磼")
("zai1" "災栽哉渽賳")
("zai3" "仔宰崽載縡")
("zai4" "在再載")
("zan1" "簪鐕")
("zan2" "咱偺糌")
("zan3" "拶攢寁昝禶喒儹揝礸")
("zan4" "贊暫讚鏨瓚欑酇饡灒囋趲")
("zang1" "髒贓臢牂臧")
("zang3" "駔")
("zang4" "藏臟葬奘")
("zao1" "遭糟蹧傮")
("zao2" "鑿")
("zao3" "早棗澡藻蚤璪繰")
("zao4" "造皂燥噪慥譟灶躁皁趮矂")
("ze2" "則責擇澤嘖窄舴咋幘笮賾迮崱萴謮蠌賊蠈")
("ze3" "怎")
("ze4" "仄側昃庂稄")
("zei2" "賊")
("zen3" "怎")
("zen4" "譖")
("zeng1" "曾增憎罾繒矰橧磳驓璔")
("zeng4" "贈甑")
("zh" "ㄓ")
("zha1" "渣扎喳楂查齇柤皻抯挓樝謯")
("zha2" "扎札紮閘炸霅鍘哳劄蚻譗蠿")
("zha3" "眨渣鮓厏苲")
("zha4" "榨柵炸詐乍搾蚱咋蜡吒溠砟醡鮓痄簎")
("zhai1" "摘齋齊捚")
("zhai2" "宅翟")
("zhai3" "窄岝")
("zhai4" "債寨祭責瘵砦")
("zhan1" "詹沾瞻氈霑旃譫鱣覘邅栴鸇驙占呫饘鉆詀薝譠")
("zhan3" "展斬盞輾搌嶄琖魙醆颭樿皽蹍嫸榐橏")
("zhan4" "佔戰站暫占棧顫湛綻蹔蘸虥轏輚偡")
("zhang1" "張章彰漳樟璋獐嫜暲鄣蟑鱆慞傽墇騿遧")
("zhang3" "長掌漲仉鞝")
("zhang4" "丈仗帳障賬脹杖漲幛瘴嶂扙瞕粀")
("zhao1" "朝招昭召著嘲釗駋鉊晁盄鍣妱")
("zhao2" "著")
("zhao3" "找沼爪菬瑵")
("zhao4" "照趙召罩兆肇詔晁笊櫂炤雿狣棹箌鵫垗旐曌")
("zhe1" "遮螫晢嫬")
("zhe2" "折哲摺懾褶謫輒摘轍慴蜇磔乇讋晢鮿耴悊砓謺虴鸅讘瓋")
("zhe3" "者赭鍺")
("zhe4" "這浙蔗鷓柘宅檡烢蟅")
("zhe5" "著遮晢嫬")
("zhen1" "真針珍貞偵禎斟箴砧甄臻楨榛診蓁獉溱碪胗鍼鱵媜駗薽禛樼潧瑊遉寊蒧轃籈鷏堻")
("zhen3" "診枕疹軫畛袗縝稹紾鬒眕黰辴抮抌笉絼祳晸縥黕")
("zhen4" "鎮陣振震賑朕枕鴆揕酖眹娠侲挋栚蜄桭誫敶")
("zheng1" "爭征蒸睜徵掙箏正怔猙錚崢諍癥鉦烝篜姃炡埩聇丁眐")
("zheng3" "整拯氶撜糽")
("zheng4" "鄭正證政証症掙幀")
("zhi1" "之知隻織支枝汁只吱芝脂肢蜘祇梔祗氏枳ㄓ胝鴟卮搘秖跖泜鳷汥秪榰胑衼椥")
("zhi2" "直職質值植執殖擲姪侄蹠蟄躑桎埴稙摭縶柣犆秷擿馽慹樴膱懫蟙褁瓡嬂蘵")
("zhi3" "只指紙止旨址徵祇趾祉咫枳酯恉沚阯芷黹軹疻晊厎坁藢栺淽滍")
("zhi4" "至制治志製致置智秩誌稚質峙緻幟滯摯窒炙痔雉識懥痣輊騭帙陟知寘忮桎躓蛭贄鷙厔鑕豸庤彘猘畤疐紩觶郅銍偫跱遰鋕櫍袟騺淛狾礩胵膣螲挃洷覟庢鴙迣翐臸駤祑觢鴩")
("zhong1" "中鐘終忠鍾衷忪盅螽伀妐蔠柊煄彸舯炂籦")
("zhong3" "種腫塚踵冢")
("zhong4" "中種重仲眾尰湩狆衶偅堹緟")
("zhou1" "周週州洲舟粥賙啁盩譸輈喌騆鵃洀淍銂珘徟輖侜婤")
("zhou2" "軸妯")
("zhou3" "帚肘睭鯞")
("zhou4" "晝皺宙紂縐冑咒繇甃籀咮酎僽怞胄噣駎")
("zhu1" "珠朱諸株豬蛛茱硃誅銖侏洙瀦邾櫫櫧祩藷絑袾觰鴸蠩蝫鮢藸")
("zhu2" "竹築逐燭蠋筑竺朮躅舳軸窋蓫笁趉鱁灟蠾茿篫")
("zhu3" "主屬煮囑貯渚矚著麈拄瘃斸砫陼孎壴罜欘泞眝")
("zhu4" "住著助注祝駐註柱蛀鑄炷苧佇箸杼紵翥宁柷羜馵疰莇鉒紸嵀跓軴樦麆櫡殶諔")
("zhua1" "抓撾髽檛")
("zhua3" "爪")
("zhuai1" "拽")
("zhuai3" "跩")
("zhuai4" "拽")
("zhuan1" "專磚耑顓塼鄟鱄剸嫥瑼篿鷒膞蟤")
("zhuan3" "轉囀")
("zhuan4" "傳賺篆撰譔饌僎瑑縳腞")
("zhuang1" "裝莊樁妝庄梉")
("zhuang3" "奘")
("zhuang4" "狀壯撞戇焋")
("zhui1" "追錐椎隹騅鵻腄鴭")
("zhui3" "沝")
("zhui4" "綴墜贅縋惴餟硾膇鑆")
("zhun1" "諄屯肫窀迍宒訰")
("zhun3" "準准隼埻綧")
("zhun4" "稕")
("zhuo1" "捉桌涿棹穛")
("zhuo2" "卓茁濁拙濯酌灼著啄鐲擢琢諑倬斲斮梲椓焯蝃踔鷟彴汋斫禚篧浞棳謶錣啅罬斀蠗圴剢灂")
("zi1" "資茲滋吱姿咨孜諮貲玆ㄗ輜淄齜緇孳粢髭嵫菑鎡鶿鼒孖澬甾鄑鯔錙趑椔鈭鶅齍栥紎崰秶蠀")
("zi2" "子")
("zi3" "子仔紫梓籽滓耔訾笫秭胏茈吇杍芓呰矷釨訿")
("zi4" "自字恣漬眥孳剚胔胾扻倳牸")
("zong1" "宗蹤縱綜棕鬃豵騣鬷翪熧倧惾猣稯艐嵕蝬")
("zong3" "總摠傯熜朡蓗")
("zong4" "縱粽綜從瘲昮")
("zou1" "鄒謅鄹諏啁掫菆陬騶鯫棸緅棷郰媰黀齱齺")
("zou3" "走")
("zou4" "奏驟揍")
("zu1" "租蒩")
("zu2" "足族卒嗾捽崒踿哫傶踤")
("zu3" "組祖阻俎詛珇靻")
("zuan1" "鑽躦")
("zuan3" "纂鑽纘籫儹")
("zuan4" "賺鑽攥饡")
("zui1" "堆厜羧嶉纗")
("zui3" "嘴璻觜嶊噿濢")
("zui4" "最罪醉檇蕞晬檌絊祽鋷墬嶵")
("zun1" "尊遵樽墫鐏嶟繜鷷壿")
("zun3" "撙噂墫僔譐")
("zun4" "俊圳捘鱒銌燇")
("zuo2" "昨作砟椊筰稓葃")
("zuo3" "左佐繓")
("zuo4" "做作坐座酢祚鑿柞怍胙阼葄夎")
)
;; Local Variables:
;; version-control: never
;; no-update-autoloads: t
;; End:
