/*
 * Copyright (c) 1993,1995
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
#include <sys/types.h>
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
#include "chario.h"
#include "macros.h"
#include "services.h"
#include "groups.h"

extern int parse_error;

struct group_list *group_names = (struct group_list *)0;

void
init_groups(void)
{
     group_names = (struct group_list *)0;
}

void
make_group(char *grp)
{
     struct group_list *rove;

     for(rove = group_names;rove;rove=rove->next){
	  if(!strcmp(grp, rove->name)){
	       fprintf(stderr, "\"%s\", line %d: class %s already defined.\n",
		       getfilename(), getlinenum(), grp);
	       parse_error = 1;
	       break;
	  }
     }

     if(!rove){
	  struct group_list *new;

	  new = NEW(struct group_list);
	  if(!new){
	       fprintf(stderr, "%s, line %d: malloc failed\n",
		       __FILE__, __LINE__);
	       exit(1);
	  }

	  new->name = strdup(grp);
	  new->next = group_names;
	  new->fp = fp_head;
	  fp_head = 0;

	  group_names = new;
     }
}

struct group_list *
locate_group(char *grp)
{
     struct group_list *rove;

     for(rove = group_names;rove;rove=rove->next){
	  if(!strcmp(grp, rove->name))
	       break;
     }

     return rove;
}

void
push_group(char *grp)
{
     struct group_list *rove;

     rove = locate_group(grp);
     

     if(rove){
	  struct filt_protocols *fp_rove;
	  struct port_range *pr_rove;
	  struct service srv;
	  inout io;
	  srcdst sd;
	  accrej ar;
	  
	  for(fp_rove = rove->fp;fp_rove;fp_rove = fp_rove->fp_next){
	       FORBOTH(ar, FP_ACC, FP_REJ){
		    FORBOTH(io, FP_IN, FP_OUT){
			 FORBOTH(sd, FP_SRC, FP_DST){
			      pr_rove=fp_rove->fp_pr[ar][io][sd];
			      for(;pr_rove;pr_rove=pr_rove->pr_next){
				   srv.start = pr_rove->pr_start;
				   srv.end = pr_rove->pr_end;
				   srv.protocol = fp_rove->fp_id;
				   push_service(srv, io, sd, ar);
			      }
			 }
		    }
	       }
	  }
     }
     else {
	  fprintf(stderr, "\"%s\", line %d: undeclared group: %s\n",
		  getfilename(), getlinenum(), grp);
	  parse_error = 1;
     }
}
