#!perl -T

# Binary bitwise operators

BEGIN { require './t/test.pl' }

use Test::More tests => 2670;
use strict;
use utf8;

# Test 1: See if the module loads
BEGIN { use_ok('JE') };


my $j = new JE;


# Tests 2-3: Bind the ok and is functions
isa_ok( $j->new_function( ok  => \&ok   ), 'JE::Object::Function' );
isa_ok( $j->new_function( is  => \&is   ), 'JE::Object::Function' );


# JS tests
defined $j->eval( <<'--end--' ) or die;

// ===================================================
// &
// ===================================================

/* Tests 4-51: type convernsion */

ok(( void 0  &  void 0           ) === 0,     "undefined & undefined")
ok(( void 0  &  null             ) === 0,     "undefined & null")
ok(( void 0  &  true             ) === 0,     "undefined & boolean")
ok(( void 0  & "string"          ) === 0,     "undefined & string")
ok(( void 0  &  73               ) === 0,     "undefined & number")
ok(( void 0  &  {}               ) === 0,     "undefined & object")
ok(( void 0  &  new Number(34.2) ) === 0,     "undefined & number object")
ok(( null    &  void 0           ) === 0,     "null & undefined")
ok(( null    &  null             ) === 0,     "null & null")
ok(( null    &  true             ) === 0,     "null & boolean")
ok(( null    & "string"          ) === 0,     "null & string")
ok(( null    &  73               ) === 0,     "null & number")
ok(( null    &  {}               ) === 0,     "null & object")
ok(( null    &  new Number(34.2) ) === 0,     "null & number object")
ok(( true    &  void 0           ) === 0,     "boolean & undefined")
ok(( true    &  null             ) === 0,     "boolean & null")
ok(( true    &  true             ) === 1,     "boolean & boolean")
ok(( true    & "string"          ) === 0,     "boolean & string")
ok(( true    &  73               ) === 1,     "boolean & number")
ok(( true    &  {}               ) === 0,     "boolean & object")
ok(( true    &  new Number(34.2) ) === 0,     "boolean & number object")
ok(("string" &  void 0           ) === 0,     "string & undefined")
ok(("string" &  null             ) === 0,     "string & null")
ok(("string" &  true             ) === 0,     "string & boolean")
ok(("string" & "string"          ) === 0,     "string & string")
ok(("string" &  73               ) === 0,     "string & number")
ok(("string" &  {}               ) === 0,     "string & object")
ok(("string" &  new Number(34.2) ) === 0,     "string & number object")
ok(( 73      &  void 0           ) === 0,     "number & undefined")
ok(( 73      &  null             ) === 0,     "number & null")
ok(( 73      &  true             ) === 1,     "number & boolean")
ok(( 73      & "string"          ) === 0,     "number & string")
ok(( 73      &  {}               ) === 0,     "number & object")
ok(( 73      &  new Number(34.2) ) === 0,     "number & number object")
ok(( {}      &  void 0           ) === 0,     "object & undefined")
ok(( {}      &  null             ) === 0,     "object & null")
ok(( {}      &  true             ) === 0,     "object & boolean")
ok(( {}      & "string"          ) === 0,     "object & string")
ok(( {}      &  73               ) === 0,     "object & number")
ok(( {}      &  {}               ) === 0,     "object & object")
ok(( {}      &  new Number(34.2) ) === 0,     "object & number object")
ok(( new Number(34.2) &  void 0  ) === 0,     "number object & undefined")
ok(( new Number(34.2) &  null    ) === 0,     "number object & null")
ok(( new Number(34.2) &  true    ) === 0,     "number object & boolean")
ok(( new Number(34.2) & "string" ) === 0,     "number object & string")
ok(( new Number(34.2) &  73      ) === 0,     "number object & number")
ok(( new Number(34.2) &  {}      ) === 0,     "number object & object")
ok(( new Number(34.2) &  new Number(34.2) ) === 34,
	"number object & number object")

/* Tests 52-892: number & number */

n2n = [
	[NaN, NaN, 0],
	[NaN, 0, 0],
	[NaN, 0, 0],
	[NaN, Infinity, 0],
	[NaN, -Infinity, 0],
	[NaN, 1, 0],
	[NaN, 32.5, 0],
	[NaN, 2147483648, 0],
	[NaN, 3000000000, 0],
	[NaN, 4000000000.23, 0],
	[NaN, 5000000000, 0],
	[NaN, 4294967296, 0],
	[NaN, 4294967298.479, 0],
	[NaN, 6442450942, 0],
	[NaN, 6442450943.674, 0],
	[NaN, 6442450944, 0],
	[NaN, 6442450945, 0],
	[NaN, 6442450946.74, 0],
	[NaN, -1, 0],
	[NaN, -32.5, 0],
	[NaN, -3000000000, 0],
	[NaN, -4000000000.23, 0],
	[NaN, -5000000000, 0],
	[NaN, -4294967298.479, 0],
	[NaN, -6442450942, 0],
	[NaN, -6442450943.674, 0],
	[NaN, -6442450944, 0],
	[NaN, -6442450945, 0],
	[NaN, -6442450946.74, 0],
	[0, NaN, 0],
	[0, 0, 0],
	[0, 0, 0],
	[0, Infinity, 0],
	[0, -Infinity, 0],
	[0, 1, 0],
	[0, 32.5, 0],
	[0, 2147483648, 0],
	[0, 3000000000, 0],
	[0, 4000000000.23, 0],
	[0, 5000000000, 0],
	[0, 4294967296, 0],
	[0, 4294967298.479, 0],
	[0, 6442450942, 0],
	[0, 6442450943.674, 0],
	[0, 6442450944, 0],
	[0, 6442450945, 0],
	[0, 6442450946.74, 0],
	[0, -1, 0],
	[0, -32.5, 0],
	[0, -3000000000, 0],
	[0, -4000000000.23, 0],
	[0, -5000000000, 0],
	[0, -4294967298.479, 0],
	[0, -6442450942, 0],
	[0, -6442450943.674, 0],
	[0, -6442450944, 0],
	[0, -6442450945, 0],
	[0, -6442450946.74, 0],
	[0, NaN, 0],
	[0, 0, 0],
	[0, 0, 0],
	[0, Infinity, 0],
	[0, -Infinity, 0],
	[0, 1, 0],
	[0, 32.5, 0],
	[0, 2147483648, 0],
	[0, 3000000000, 0],
	[0, 4000000000.23, 0],
	[0, 5000000000, 0],
	[0, 4294967296, 0],
	[0, 4294967298.479, 0],
	[0, 6442450942, 0],
	[0, 6442450943.674, 0],
	[0, 6442450944, 0],
	[0, 6442450945, 0],
	[0, 6442450946.74, 0],
	[0, -1, 0],
	[0, -32.5, 0],
	[0, -3000000000, 0],
	[0, -4000000000.23, 0],
	[0, -5000000000, 0],
	[0, -4294967298.479, 0],
	[0, -6442450942, 0],
	[0, -6442450943.674, 0],
	[0, -6442450944, 0],
	[0, -6442450945, 0],
	[0, -6442450946.74, 0],
	[Infinity, NaN, 0],
	[Infinity, 0, 0],
	[Infinity, 0, 0],
	[Infinity, Infinity, 0],
	[Infinity, -Infinity, 0],
	[Infinity, 1, 0],
	[Infinity, 32.5, 0],
	[Infinity, 2147483648, 0],
	[Infinity, 3000000000, 0],
	[Infinity, 4000000000.23, 0],
	[Infinity, 5000000000, 0],
	[Infinity, 4294967296, 0],
	[Infinity, 4294967298.479, 0],
	[Infinity, 6442450942, 0],
	[Infinity, 6442450943.674, 0],
	[Infinity, 6442450944, 0],
	[Infinity, 6442450945, 0],
	[Infinity, 6442450946.74, 0],
	[Infinity, -1, 0],
	[Infinity, -32.5, 0],
	[Infinity, -3000000000, 0],
	[Infinity, -4000000000.23, 0],
	[Infinity, -5000000000, 0],
	[Infinity, -4294967298.479, 0],
	[Infinity, -6442450942, 0],
	[Infinity, -6442450943.674, 0],
	[Infinity, -6442450944, 0],
	[Infinity, -6442450945, 0],
	[Infinity, -6442450946.74, 0],
	[-Infinity, NaN, 0],
	[-Infinity, 0, 0],
	[-Infinity, 0, 0],
	[-Infinity, Infinity, 0],
	[-Infinity, -Infinity, 0],
	[-Infinity, 1, 0],
	[-Infinity, 32.5, 0],
	[-Infinity, 2147483648, 0],
	[-Infinity, 3000000000, 0],
	[-Infinity, 4000000000.23, 0],
	[-Infinity, 5000000000, 0],
	[-Infinity, 4294967296, 0],
	[-Infinity, 4294967298.479, 0],
	[-Infinity, 6442450942, 0],
	[-Infinity, 6442450943.674, 0],
	[-Infinity, 6442450944, 0],
	[-Infinity, 6442450945, 0],
	[-Infinity, 6442450946.74, 0],
	[-Infinity, -1, 0],
	[-Infinity, -32.5, 0],
	[-Infinity, -3000000000, 0],
	[-Infinity, -4000000000.23, 0],
	[-Infinity, -5000000000, 0],
	[-Infinity, -4294967298.479, 0],
	[-Infinity, -6442450942, 0],
	[-Infinity, -6442450943.674, 0],
	[-Infinity, -6442450944, 0],
	[-Infinity, -6442450945, 0],
	[-Infinity, -6442450946.74, 0],
	[1, NaN, 0],
	[1, 0, 0],
	[1, 0, 0],
	[1, Infinity, 0],
	[1, -Infinity, 0],
	[1, 1, 1],
	[1, 32.5, 0],
	[1, 2147483648, 0],
	[1, 3000000000, 0],
	[1, 4000000000.23, 0],
	[1, 5000000000, 0],
	[1, 4294967296, 0],
	[1, 4294967298.479, 0],
	[1, 6442450942, 0],
	[1, 6442450943.674, 1],
	[1, 6442450944, 0],
	[1, 6442450945, 1],
	[1, 6442450946.74, 0],
	[1, -1, 1],
	[1, -32.5, 0],
	[1, -3000000000, 0],
	[1, -4000000000.23, 0],
	[1, -5000000000, 0],
	[1, -4294967298.479, 0],
	[1, -6442450942, 0],
	[1, -6442450943.674, 1],
	[1, -6442450944, 0],
	[1, -6442450945, 1],
	[1, -6442450946.74, 0],
	[32.5, NaN, 0],
	[32.5, 0, 0],
	[32.5, 0, 0],
	[32.5, Infinity, 0],
	[32.5, -Infinity, 0],
	[32.5, 1, 0],
	[32.5, 32.5, 32],
	[32.5, 2147483648, 0],
	[32.5, 3000000000, 0],
	[32.5, 4000000000.23, 0],
	[32.5, 5000000000, 0],
	[32.5, 4294967296, 0],
	[32.5, 4294967298.479, 0],
	[32.5, 6442450942, 32],
	[32.5, 6442450943.674, 32],
	[32.5, 6442450944, 0],
	[32.5, 6442450945, 0],
	[32.5, 6442450946.74, 0],
	[32.5, -1, 32],
	[32.5, -32.5, 32],
	[32.5, -3000000000, 0],
	[32.5, -4000000000.23, 0],
	[32.5, -5000000000, 0],
	[32.5, -4294967298.479, 32],
	[32.5, -6442450942, 0],
	[32.5, -6442450943.674, 0],
	[32.5, -6442450944, 0],
	[32.5, -6442450945, 32],
	[32.5, -6442450946.74, 32],
	[2147483648, NaN, 0],
	[2147483648, 0, 0],
	[2147483648, 0, 0],
	[2147483648, Infinity, 0],
	[2147483648, -Infinity, 0],
	[2147483648, 1, 0],
	[2147483648, 32.5, 0],
	[2147483648, 2147483648, -2147483648],
	[2147483648, 3000000000, -2147483648],
	[2147483648, 4000000000.23, -2147483648],
	[2147483648, 5000000000, 0],
	[2147483648, 4294967296, 0],
	[2147483648, 4294967298.479, 0],
	[2147483648, 6442450942, 0],
	[2147483648, 6442450943.674, 0],
	[2147483648, 6442450944, -2147483648],
	[2147483648, 6442450945, -2147483648],
	[2147483648, 6442450946.74, -2147483648],
	[2147483648, -1, -2147483648],
	[2147483648, -32.5, -2147483648],
	[2147483648, -3000000000, 0],
	[2147483648, -4000000000.23, 0],
	[2147483648, -5000000000, -2147483648],
	[2147483648, -4294967298.479, -2147483648],
	[2147483648, -6442450942, -2147483648],
	[2147483648, -6442450943.674, -2147483648],
	[2147483648, -6442450944, -2147483648],
	[2147483648, -6442450945, 0],
	[2147483648, -6442450946.74, 0],
	[3000000000, NaN, 0],
	[3000000000, 0, 0],
	[3000000000, 0, 0],
	[3000000000, Infinity, 0],
	[3000000000, -Infinity, 0],
	[3000000000, 1, 0],
	[3000000000, 32.5, 0],
	[3000000000, 2147483648, -2147483648],
	[3000000000, 3000000000, -1294967296],
	[3000000000, 4000000000.23, -1572861952],
	[3000000000, 5000000000, 570446336],
	[3000000000, 4294967296, 0],
	[3000000000, 4294967298.479, 0],
	[3000000000, 6442450942, 852516352],
	[3000000000, 6442450943.674, 852516352],
	[3000000000, 6442450944, -2147483648],
	[3000000000, 6442450945, -2147483648],
	[3000000000, 6442450946.74, -2147483648],
	[3000000000, -1, -1294967296],
	[3000000000, -32.5, -1294967296],
	[3000000000, -3000000000, 512],
	[3000000000, -4000000000.23, 277895168],
	[3000000000, -5000000000, -1865413120],
	[3000000000, -4294967298.479, -1294967296],
	[3000000000, -6442450942, -2147483648],
	[3000000000, -6442450943.674, -2147483648],
	[3000000000, -6442450944, -2147483648],
	[3000000000, -6442450945, 852516352],
	[3000000000, -6442450946.74, 852516352],
	[4000000000.23, NaN, 0],
	[4000000000.23, 0, 0],
	[4000000000.23, 0, 0],
	[4000000000.23, Infinity, 0],
	[4000000000.23, -Infinity, 0],
	[4000000000.23, 1, 0],
	[4000000000.23, 32.5, 0],
	[4000000000.23, 2147483648, -2147483648],
	[4000000000.23, 3000000000, -1572861952],
	[4000000000.23, 4000000000.23, -294967296],
	[4000000000.23, 5000000000, 704716800],
	[4000000000.23, 4294967296, 0],
	[4000000000.23, 4294967298.479, 0],
	[4000000000.23, 6442450942, 1852516352],
	[4000000000.23, 6442450943.674, 1852516352],
	[4000000000.23, 6442450944, -2147483648],
	[4000000000.23, 6442450945, -2147483648],
	[4000000000.23, 6442450946.74, -2147483648],
	[4000000000.23, -1, -294967296],
	[4000000000.23, -32.5, -294967296],
	[4000000000.23, -3000000000, 1277894656],
	[4000000000.23, -4000000000.23, 2048],
	[4000000000.23, -5000000000, -999684096],
	[4000000000.23, -4294967298.479, -294967296],
	[4000000000.23, -6442450942, -2147483648],
	[4000000000.23, -6442450943.674, -2147483648],
	[4000000000.23, -6442450944, -2147483648],
	[4000000000.23, -6442450945, 1852516352],
	[4000000000.23, -6442450946.74, 1852516352],
	[5000000000, NaN, 0],
	[5000000000, 0, 0],
	[5000000000, 0, 0],
	[5000000000, Infinity, 0],
	[5000000000, -Infinity, 0],
	[5000000000, 1, 0],
	[5000000000, 32.5, 0],
	[5000000000, 2147483648, 0],
	[5000000000, 3000000000, 570446336],
	[5000000000, 4000000000.23, 704716800],
	[5000000000, 5000000000, 705032704],
	[5000000000, 4294967296, 0],
	[5000000000, 4294967298.479, 0],
	[5000000000, 6442450942, 705032704],
	[5000000000, 6442450943.674, 705032704],
	[5000000000, 6442450944, 0],
	[5000000000, 6442450945, 0],
	[5000000000, 6442450946.74, 0],
	[5000000000, -1, 705032704],
	[5000000000, -32.5, 705032704],
	[5000000000, -3000000000, 134586880],
	[5000000000, -4000000000.23, 315392],
	[5000000000, -5000000000, 512],
	[5000000000, -4294967298.479, 705032704],
	[5000000000, -6442450942, 0],
	[5000000000, -6442450943.674, 0],
	[5000000000, -6442450944, 0],
	[5000000000, -6442450945, 705032704],
	[5000000000, -6442450946.74, 705032704],
	[4294967296, NaN, 0],
	[4294967296, 0, 0],
	[4294967296, 0, 0],
	[4294967296, Infinity, 0],
	[4294967296, -Infinity, 0],
	[4294967296, 1, 0],
	[4294967296, 32.5, 0],
	[4294967296, 2147483648, 0],
	[4294967296, 3000000000, 0],
	[4294967296, 4000000000.23, 0],
	[4294967296, 5000000000, 0],
	[4294967296, 4294967296, 0],
	[4294967296, 4294967298.479, 0],
	[4294967296, 6442450942, 0],
	[4294967296, 6442450943.674, 0],
	[4294967296, 6442450944, 0],
	[4294967296, 6442450945, 0],
	[4294967296, 6442450946.74, 0],
	[4294967296, -1, 0],
	[4294967296, -32.5, 0],
	[4294967296, -3000000000, 0],
	[4294967296, -4000000000.23, 0],
	[4294967296, -5000000000, 0],
	[4294967296, -4294967298.479, 0],
	[4294967296, -6442450942, 0],
	[4294967296, -6442450943.674, 0],
	[4294967296, -6442450944, 0],
	[4294967296, -6442450945, 0],
	[4294967296, -6442450946.74, 0],
	[4294967298.479, NaN, 0],
	[4294967298.479, 0, 0],
	[4294967298.479, 0, 0],
	[4294967298.479, Infinity, 0],
	[4294967298.479, -Infinity, 0],
	[4294967298.479, 1, 0],
	[4294967298.479, 32.5, 0],
	[4294967298.479, 2147483648, 0],
	[4294967298.479, 3000000000, 0],
	[4294967298.479, 4000000000.23, 0],
	[4294967298.479, 5000000000, 0],
	[4294967298.479, 4294967296, 0],
	[4294967298.479, 4294967298.479, 2],
	[4294967298.479, 6442450942, 2],
	[4294967298.479, 6442450943.674, 2],
	[4294967298.479, 6442450944, 0],
	[4294967298.479, 6442450945, 0],
	[4294967298.479, 6442450946.74, 2],
	[4294967298.479, -1, 2],
	[4294967298.479, -32.5, 0],
	[4294967298.479, -3000000000, 0],
	[4294967298.479, -4000000000.23, 0],
	[4294967298.479, -5000000000, 0],
	[4294967298.479, -4294967298.479, 2],
	[4294967298.479, -6442450942, 2],
	[4294967298.479, -6442450943.674, 0],
	[4294967298.479, -6442450944, 0],
	[4294967298.479, -6442450945, 2],
	[4294967298.479, -6442450946.74, 2],
	[6442450942, NaN, 0],
	[6442450942, 0, 0],
	[6442450942, 0, 0],
	[6442450942, Infinity, 0],
	[6442450942, -Infinity, 0],
	[6442450942, 1, 0],
	[6442450942, 32.5, 32],
	[6442450942, 2147483648, 0],
	[6442450942, 3000000000, 852516352],
	[6442450942, 4000000000.23, 1852516352],
	[6442450942, 5000000000, 705032704],
	[6442450942, 4294967296, 0],
	[6442450942, 4294967298.479, 2],
	[6442450942, 6442450942, 2147483646],
	[6442450942, 6442450943.674, 2147483646],
	[6442450942, 6442450944, 0],
	[6442450942, 6442450945, 0],
	[6442450942, 6442450946.74, 2],
	[6442450942, -1, 2147483646],
	[6442450942, -32.5, 2147483616],
	[6442450942, -3000000000, 1294967296],
	[6442450942, -4000000000.23, 294967296],
	[6442450942, -5000000000, 1442450944],
	[6442450942, -4294967298.479, 2147483646],
	[6442450942, -6442450942, 2],
	[6442450942, -6442450943.674, 0],
	[6442450942, -6442450944, 0],
	[6442450942, -6442450945, 2147483646],
	[6442450942, -6442450946.74, 2147483646],
	[6442450943.674, NaN, 0],
	[6442450943.674, 0, 0],
	[6442450943.674, 0, 0],
	[6442450943.674, Infinity, 0],
	[6442450943.674, -Infinity, 0],
	[6442450943.674, 1, 1],
	[6442450943.674, 32.5, 32],
	[6442450943.674, 2147483648, 0],
	[6442450943.674, 3000000000, 852516352],
	[6442450943.674, 4000000000.23, 1852516352],
	[6442450943.674, 5000000000, 705032704],
	[6442450943.674, 4294967296, 0],
	[6442450943.674, 4294967298.479, 2],
	[6442450943.674, 6442450942, 2147483646],
	[6442450943.674, 6442450943.674, 2147483647],
	[6442450943.674, 6442450944, 0],
	[6442450943.674, 6442450945, 1],
	[6442450943.674, 6442450946.74, 2],
	[6442450943.674, -1, 2147483647],
	[6442450943.674, -32.5, 2147483616],
	[6442450943.674, -3000000000, 1294967296],
	[6442450943.674, -4000000000.23, 294967296],
	[6442450943.674, -5000000000, 1442450944],
	[6442450943.674, -4294967298.479, 2147483646],
	[6442450943.674, -6442450942, 2],
	[6442450943.674, -6442450943.674, 1],
	[6442450943.674, -6442450944, 0],
	[6442450943.674, -6442450945, 2147483647],
	[6442450943.674, -6442450946.74, 2147483646],
	[6442450944, NaN, 0],
	[6442450944, 0, 0],
	[6442450944, 0, 0],
	[6442450944, Infinity, 0],
	[6442450944, -Infinity, 0],
	[6442450944, 1, 0],
	[6442450944, 32.5, 0],
	[6442450944, 2147483648, -2147483648],
	[6442450944, 3000000000, -2147483648],
	[6442450944, 4000000000.23, -2147483648],
	[6442450944, 5000000000, 0],
	[6442450944, 4294967296, 0],
	[6442450944, 4294967298.479, 0],
	[6442450944, 6442450942, 0],
	[6442450944, 6442450943.674, 0],
	[6442450944, 6442450944, -2147483648],
	[6442450944, 6442450945, -2147483648],
	[6442450944, 6442450946.74, -2147483648],
	[6442450944, -1, -2147483648],
	[6442450944, -32.5, -2147483648],
	[6442450944, -3000000000, 0],
	[6442450944, -4000000000.23, 0],
	[6442450944, -5000000000, -2147483648],
	[6442450944, -4294967298.479, -2147483648],
	[6442450944, -6442450942, -2147483648],
	[6442450944, -6442450943.674, -2147483648],
	[6442450944, -6442450944, -2147483648],
	[6442450944, -6442450945, 0],
	[6442450944, -6442450946.74, 0],
	[6442450945, NaN, 0],
	[6442450945, 0, 0],
	[6442450945, 0, 0],
	[6442450945, Infinity, 0],
	[6442450945, -Infinity, 0],
	[6442450945, 1, 1],
	[6442450945, 32.5, 0],
	[6442450945, 2147483648, -2147483648],
	[6442450945, 3000000000, -2147483648],
	[6442450945, 4000000000.23, -2147483648],
	[6442450945, 5000000000, 0],
	[6442450945, 4294967296, 0],
	[6442450945, 4294967298.479, 0],
	[6442450945, 6442450942, 0],
	[6442450945, 6442450943.674, 1],
	[6442450945, 6442450944, -2147483648],
	[6442450945, 6442450945, -2147483647],
	[6442450945, 6442450946.74, -2147483648],
	[6442450945, -1, -2147483647],
	[6442450945, -32.5, -2147483648],
	[6442450945, -3000000000, 0],
	[6442450945, -4000000000.23, 0],
	[6442450945, -5000000000, -2147483648],
	[6442450945, -4294967298.479, -2147483648],
	[6442450945, -6442450942, -2147483648],
	[6442450945, -6442450943.674, -2147483647],
	[6442450945, -6442450944, -2147483648],
	[6442450945, -6442450945, 1],
	[6442450945, -6442450946.74, 0],
	[6442450946.74, NaN, 0],
	[6442450946.74, 0, 0],
	[6442450946.74, 0, 0],
	[6442450946.74, Infinity, 0],
	[6442450946.74, -Infinity, 0],
	[6442450946.74, 1, 0],
	[6442450946.74, 32.5, 0],
	[6442450946.74, 2147483648, -2147483648],
	[6442450946.74, 3000000000, -2147483648],
	[6442450946.74, 4000000000.23, -2147483648],
	[6442450946.74, 5000000000, 0],
	[6442450946.74, 4294967296, 0],
	[6442450946.74, 4294967298.479, 2],
	[6442450946.74, 6442450942, 2],
	[6442450946.74, 6442450943.674, 2],
	[6442450946.74, 6442450944, -2147483648],
	[6442450946.74, 6442450945, -2147483648],
	[6442450946.74, 6442450946.74, -2147483646],
	[6442450946.74, -1, -2147483646],
	[6442450946.74, -32.5, -2147483648],
	[6442450946.74, -3000000000, 0],
	[6442450946.74, -4000000000.23, 0],
	[6442450946.74, -5000000000, -2147483648],
	[6442450946.74, -4294967298.479, -2147483646],
	[6442450946.74, -6442450942, -2147483646],
	[6442450946.74, -6442450943.674, -2147483648],
	[6442450946.74, -6442450944, -2147483648],
	[6442450946.74, -6442450945, 2],
	[6442450946.74, -6442450946.74, 2],
	[-1, NaN, 0],
	[-1, 0, 0],
	[-1, 0, 0],
	[-1, Infinity, 0],
	[-1, -Infinity, 0],
	[-1, 1, 1],
	[-1, 32.5, 32],
	[-1, 2147483648, -2147483648],
	[-1, 3000000000, -1294967296],
	[-1, 4000000000.23, -294967296],
	[-1, 5000000000, 705032704],
	[-1, 4294967296, 0],
	[-1, 4294967298.479, 2],
	[-1, 6442450942, 2147483646],
	[-1, 6442450943.674, 2147483647],
	[-1, 6442450944, -2147483648],
	[-1, 6442450945, -2147483647],
	[-1, 6442450946.74, -2147483646],
	[-1, -1, -1],
	[-1, -32.5, -32],
	[-1, -3000000000, 1294967296],
	[-1, -4000000000.23, 294967296],
	[-1, -5000000000, -705032704],
	[-1, -4294967298.479, -2],
	[-1, -6442450942, -2147483646],
	[-1, -6442450943.674, -2147483647],
	[-1, -6442450944, -2147483648],
	[-1, -6442450945, 2147483647],
	[-1, -6442450946.74, 2147483646],
	[-32.5, NaN, 0],
	[-32.5, 0, 0],
	[-32.5, 0, 0],
	[-32.5, Infinity, 0],
	[-32.5, -Infinity, 0],
	[-32.5, 1, 0],
	[-32.5, 32.5, 32],
	[-32.5, 2147483648, -2147483648],
	[-32.5, 3000000000, -1294967296],
	[-32.5, 4000000000.23, -294967296],
	[-32.5, 5000000000, 705032704],
	[-32.5, 4294967296, 0],
	[-32.5, 4294967298.479, 0],
	[-32.5, 6442450942, 2147483616],
	[-32.5, 6442450943.674, 2147483616],
	[-32.5, 6442450944, -2147483648],
	[-32.5, 6442450945, -2147483648],
	[-32.5, 6442450946.74, -2147483648],
	[-32.5, -1, -32],
	[-32.5, -32.5, -32],
	[-32.5, -3000000000, 1294967296],
	[-32.5, -4000000000.23, 294967296],
	[-32.5, -5000000000, -705032704],
	[-32.5, -4294967298.479, -32],
	[-32.5, -6442450942, -2147483648],
	[-32.5, -6442450943.674, -2147483648],
	[-32.5, -6442450944, -2147483648],
	[-32.5, -6442450945, 2147483616],
	[-32.5, -6442450946.74, 2147483616],
	[-3000000000, NaN, 0],
	[-3000000000, 0, 0],
	[-3000000000, 0, 0],
	[-3000000000, Infinity, 0],
	[-3000000000, -Infinity, 0],
	[-3000000000, 1, 0],
	[-3000000000, 32.5, 0],
	[-3000000000, 2147483648, 0],
	[-3000000000, 3000000000, 512],
	[-3000000000, 4000000000.23, 1277894656],
	[-3000000000, 5000000000, 134586880],
	[-3000000000, 4294967296, 0],
	[-3000000000, 4294967298.479, 0],
	[-3000000000, 6442450942, 1294967296],
	[-3000000000, 6442450943.674, 1294967296],
	[-3000000000, 6442450944, 0],
	[-3000000000, 6442450945, 0],
	[-3000000000, 6442450946.74, 0],
	[-3000000000, -1, 1294967296],
	[-3000000000, -32.5, 1294967296],
	[-3000000000, -3000000000, 1294967296],
	[-3000000000, -4000000000.23, 17072128],
	[-3000000000, -5000000000, 1160380928],
	[-3000000000, -4294967298.479, 1294967296],
	[-3000000000, -6442450942, 0],
	[-3000000000, -6442450943.674, 0],
	[-3000000000, -6442450944, 0],
	[-3000000000, -6442450945, 1294967296],
	[-3000000000, -6442450946.74, 1294967296],
	[-4000000000.23, NaN, 0],
	[-4000000000.23, 0, 0],
	[-4000000000.23, 0, 0],
	[-4000000000.23, Infinity, 0],
	[-4000000000.23, -Infinity, 0],
	[-4000000000.23, 1, 0],
	[-4000000000.23, 32.5, 0],
	[-4000000000.23, 2147483648, 0],
	[-4000000000.23, 3000000000, 277895168],
	[-4000000000.23, 4000000000.23, 2048],
	[-4000000000.23, 5000000000, 315392],
	[-4000000000.23, 4294967296, 0],
	[-4000000000.23, 4294967298.479, 0],
	[-4000000000.23, 6442450942, 294967296],
	[-4000000000.23, 6442450943.674, 294967296],
	[-4000000000.23, 6442450944, 0],
	[-4000000000.23, 6442450945, 0],
	[-4000000000.23, 6442450946.74, 0],
	[-4000000000.23, -1, 294967296],
	[-4000000000.23, -32.5, 294967296],
	[-4000000000.23, -3000000000, 17072128],
	[-4000000000.23, -4000000000.23, 294967296],
	[-4000000000.23, -5000000000, 294651904],
	[-4000000000.23, -4294967298.479, 294967296],
	[-4000000000.23, -6442450942, 0],
	[-4000000000.23, -6442450943.674, 0],
	[-4000000000.23, -6442450944, 0],
	[-4000000000.23, -6442450945, 294967296],
	[-4000000000.23, -6442450946.74, 294967296],
	[-5000000000, NaN, 0],
	[-5000000000, 0, 0],
	[-5000000000, 0, 0],
	[-5000000000, Infinity, 0],
	[-5000000000, -Infinity, 0],
	[-5000000000, 1, 0],
	[-5000000000, 32.5, 0],
	[-5000000000, 2147483648, -2147483648],
	[-5000000000, 3000000000, -1865413120],
	[-5000000000, 4000000000.23, -999684096],
	[-5000000000, 5000000000, 512],
	[-5000000000, 4294967296, 0],
	[-5000000000, 4294967298.479, 0],
	[-5000000000, 6442450942, 1442450944],
	[-5000000000, 6442450943.674, 1442450944],
	[-5000000000, 6442450944, -2147483648],
	[-5000000000, 6442450945, -2147483648],
	[-5000000000, 6442450946.74, -2147483648],
	[-5000000000, -1, -705032704],
	[-5000000000, -32.5, -705032704],
	[-5000000000, -3000000000, 1160380928],
	[-5000000000, -4000000000.23, 294651904],
	[-5000000000, -5000000000, -705032704],
	[-5000000000, -4294967298.479, -705032704],
	[-5000000000, -6442450942, -2147483648],
	[-5000000000, -6442450943.674, -2147483648],
	[-5000000000, -6442450944, -2147483648],
	[-5000000000, -6442450945, 1442450944],
	[-5000000000, -6442450946.74, 1442450944],
	[-4294967298.479, NaN, 0],
	[-4294967298.479, 0, 0],
	[-4294967298.479, 0, 0],
	[-4294967298.479, Infinity, 0],
	[-4294967298.479, -Infinity, 0],
	[-4294967298.479, 1, 0],
	[-4294967298.479, 32.5, 32],
	[-4294967298.479, 2147483648, -2147483648],
	[-4294967298.479, 3000000000, -1294967296],
	[-4294967298.479, 4000000000.23, -294967296],
	[-4294967298.479, 5000000000, 705032704],
	[-4294967298.479, 4294967296, 0],
	[-4294967298.479, 4294967298.479, 2],
	[-4294967298.479, 6442450942, 2147483646],
	[-4294967298.479, 6442450943.674, 2147483646],
	[-4294967298.479, 6442450944, -2147483648],
	[-4294967298.479, 6442450945, -2147483648],
	[-4294967298.479, 6442450946.74, -2147483646],
	[-4294967298.479, -1, -2],
	[-4294967298.479, -32.5, -32],
	[-4294967298.479, -3000000000, 1294967296],
	[-4294967298.479, -4000000000.23, 294967296],
	[-4294967298.479, -5000000000, -705032704],
	[-4294967298.479, -4294967298.479, -2],
	[-4294967298.479, -6442450942, -2147483646],
	[-4294967298.479, -6442450943.674, -2147483648],
	[-4294967298.479, -6442450944, -2147483648],
	[-4294967298.479, -6442450945, 2147483646],
	[-4294967298.479, -6442450946.74, 2147483646],
	[-6442450942, NaN, 0],
	[-6442450942, 0, 0],
	[-6442450942, 0, 0],
	[-6442450942, Infinity, 0],
	[-6442450942, -Infinity, 0],
	[-6442450942, 1, 0],
	[-6442450942, 32.5, 0],
	[-6442450942, 2147483648, -2147483648],
	[-6442450942, 3000000000, -2147483648],
	[-6442450942, 4000000000.23, -2147483648],
	[-6442450942, 5000000000, 0],
	[-6442450942, 4294967296, 0],
	[-6442450942, 4294967298.479, 2],
	[-6442450942, 6442450942, 2],
	[-6442450942, 6442450943.674, 2],
	[-6442450942, 6442450944, -2147483648],
	[-6442450942, 6442450945, -2147483648],
	[-6442450942, 6442450946.74, -2147483646],
	[-6442450942, -1, -2147483646],
	[-6442450942, -32.5, -2147483648],
	[-6442450942, -3000000000, 0],
	[-6442450942, -4000000000.23, 0],
	[-6442450942, -5000000000, -2147483648],
	[-6442450942, -4294967298.479, -2147483646],
	[-6442450942, -6442450942, -2147483646],
	[-6442450942, -6442450943.674, -2147483648],
	[-6442450942, -6442450944, -2147483648],
	[-6442450942, -6442450945, 2],
	[-6442450942, -6442450946.74, 2],
	[-6442450943.674, NaN, 0],
	[-6442450943.674, 0, 0],
	[-6442450943.674, 0, 0],
	[-6442450943.674, Infinity, 0],
	[-6442450943.674, -Infinity, 0],
	[-6442450943.674, 1, 1],
	[-6442450943.674, 32.5, 0],
	[-6442450943.674, 2147483648, -2147483648],
	[-6442450943.674, 3000000000, -2147483648],
	[-6442450943.674, 4000000000.23, -2147483648],
	[-6442450943.674, 5000000000, 0],
	[-6442450943.674, 4294967296, 0],
	[-6442450943.674, 4294967298.479, 0],
	[-6442450943.674, 6442450942, 0],
	[-6442450943.674, 6442450943.674, 1],
	[-6442450943.674, 6442450944, -2147483648],
	[-6442450943.674, 6442450945, -2147483647],
	[-6442450943.674, 6442450946.74, -2147483648],
	[-6442450943.674, -1, -2147483647],
	[-6442450943.674, -32.5, -2147483648],
	[-6442450943.674, -3000000000, 0],
	[-6442450943.674, -4000000000.23, 0],
	[-6442450943.674, -5000000000, -2147483648],
	[-6442450943.674, -4294967298.479, -2147483648],
	[-6442450943.674, -6442450942, -2147483648],
	[-6442450943.674, -6442450943.674, -2147483647],
	[-6442450943.674, -6442450944, -2147483648],
	[-6442450943.674, -6442450945, 1],
	[-6442450943.674, -6442450946.74, 0],
	[-6442450944, NaN, 0],
	[-6442450944, 0, 0],
	[-6442450944, 0, 0],
	[-6442450944, Infinity, 0],
	[-6442450944, -Infinity, 0],
	[-6442450944, 1, 0],
	[-6442450944, 32.5, 0],
	[-6442450944, 2147483648, -2147483648],
	[-6442450944, 3000000000, -2147483648],
	[-6442450944, 4000000000.23, -2147483648],
	[-6442450944, 5000000000, 0],
	[-6442450944, 4294967296, 0],
	[-6442450944, 4294967298.479, 0],
	[-6442450944, 6442450942, 0],
	[-6442450944, 6442450943.674, 0],
	[-6442450944, 6442450944, -2147483648],
	[-6442450944, 6442450945, -2147483648],
	[-6442450944, 6442450946.74, -2147483648],
	[-6442450944, -1, -2147483648],
	[-6442450944, -32.5, -2147483648],
	[-6442450944, -3000000000, 0],
	[-6442450944, -4000000000.23, 0],
	[-6442450944, -5000000000, -2147483648],
	[-6442450944, -4294967298.479, -2147483648],
	[-6442450944, -6442450942, -2147483648],
	[-6442450944, -6442450943.674, -2147483648],
	[-6442450944, -6442450944, -2147483648],
	[-6442450944, -6442450945, 0],
	[-6442450944, -6442450946.74, 0],
	[-6442450945, NaN, 0],
	[-6442450945, 0, 0],
	[-6442450945, 0, 0],
	[-6442450945, Infinity, 0],
	[-6442450945, -Infinity, 0],
	[-6442450945, 1, 1],
	[-6442450945, 32.5, 32],
	[-6442450945, 2147483648, 0],
	[-6442450945, 3000000000, 852516352],
	[-6442450945, 4000000000.23, 1852516352],
	[-6442450945, 5000000000, 705032704],
	[-6442450945, 4294967296, 0],
	[-6442450945, 4294967298.479, 2],
	[-6442450945, 6442450942, 2147483646],
	[-6442450945, 6442450943.674, 2147483647],
	[-6442450945, 6442450944, 0],
	[-6442450945, 6442450945, 1],
	[-6442450945, 6442450946.74, 2],
	[-6442450945, -1, 2147483647],
	[-6442450945, -32.5, 2147483616],
	[-6442450945, -3000000000, 1294967296],
	[-6442450945, -4000000000.23, 294967296],
	[-6442450945, -5000000000, 1442450944],
	[-6442450945, -4294967298.479, 2147483646],
	[-6442450945, -6442450942, 2],
	[-6442450945, -6442450943.674, 1],
	[-6442450945, -6442450944, 0],
	[-6442450945, -6442450945, 2147483647],
	[-6442450945, -6442450946.74, 2147483646],
	[-6442450946.74, NaN, 0],
	[-6442450946.74, 0, 0],
	[-6442450946.74, 0, 0],
	[-6442450946.74, Infinity, 0],
	[-6442450946.74, -Infinity, 0],
	[-6442450946.74, 1, 0],
	[-6442450946.74, 32.5, 32],
	[-6442450946.74, 2147483648, 0],
	[-6442450946.74, 3000000000, 852516352],
	[-6442450946.74, 4000000000.23, 1852516352],
	[-6442450946.74, 5000000000, 705032704],
	[-6442450946.74, 4294967296, 0],
	[-6442450946.74, 4294967298.479, 2],
	[-6442450946.74, 6442450942, 2147483646],
	[-6442450946.74, 6442450943.674, 2147483646],
	[-6442450946.74, 6442450944, 0],
	[-6442450946.74, 6442450945, 0],
	[-6442450946.74, 6442450946.74, 2],
	[-6442450946.74, -1, 2147483646],
	[-6442450946.74, -32.5, 2147483616],
	[-6442450946.74, -3000000000, 1294967296],
	[-6442450946.74, -4000000000.23, 294967296],
	[-6442450946.74, -5000000000, 1442450944],
	[-6442450946.74, -4294967298.479, 2147483646],
	[-6442450946.74, -6442450942, 2],
	[-6442450946.74, -6442450943.674, 0],
	[-6442450946.74, -6442450944, 0],
	[-6442450946.74, -6442450945, 2147483646],
	[-6442450946.74, -6442450946.74, 2147483646],
];

for(var i in n2n) {
	item = n2n[i]
	ok((item[0] & item[1]) === item[2], item[0] + ' & ' + item[1])
}

// my place!

// ===================================================
// ^
// ===================================================

/* Tests 893-940: type conversion (48 tests) */

ok(( void 0  ^  void 0           ) === 0,     "undefined ^ undefined")
ok(( void 0  ^  null             ) === 0,     "undefined ^ null")
ok(( void 0  ^  true             ) === 1,     "undefined ^ boolean")
ok(( void 0  ^ "string"          ) === 0,     "undefined ^ string")
ok(( void 0  ^  73               ) === 73,    "undefined ^ number")
ok(( void 0  ^  {}               ) === 0,     "undefined ^ object")
ok(( void 0  ^  new Number(34.2) ) === 34,    "undefined ^ number object")
ok(( null    ^  void 0           ) === 0,     "null ^ undefined")
ok(( null    ^  null             ) === 0,     "null ^ null")
ok(( null    ^  true             ) === 1,     "null ^ boolean")
ok(( null    ^ "string"          ) === 0,     "null ^ string")
ok(( null    ^  73               ) === 73,     "null ^ number")
ok(( null    ^  {}               ) === 0,     "null ^ object")
ok(( null    ^  new Number(34.2) ) === 34,    "null ^ number object")
ok(( true    ^  void 0           ) === 1,     "boolean ^ undefined")
ok(( true    ^  null             ) === 1,     "boolean ^ null")
ok(( true    ^  true             ) === 0,     "boolean ^ boolean")
ok(( true    ^ "string"          ) === 1,     "boolean ^ string")
ok(( true    ^  73               ) === 72,    "boolean ^ number")
ok(( true    ^  {}               ) === 1,     "boolean ^ object")
ok(( true    ^  new Number(34.2) ) === 35,    "boolean ^ number object")
ok(("string" ^  void 0           ) === 0,     "string ^ undefined")
ok(("string" ^  null             ) === 0,     "string ^ null")
ok(("string" ^  true             ) === 1,     "string ^ boolean")
ok(("string" ^ "string"          ) === 0,     "string ^ string")
ok(("string" ^  73               ) === 73,    "string ^ number")
ok(("string" ^  {}               ) === 0,     "string ^ object")
ok(("string" ^  new Number(34.2) ) === 34,    "string ^ number object")
ok(( 73      ^  void 0           ) === 73,    "number ^ undefined")
ok(( 73      ^  null             ) === 73,    "number ^ null")
ok(( 73      ^  true             ) === 72,    "number ^ boolean")
ok(( 73      ^ "string"          ) === 73,    "number ^ string")
ok(( 73      ^  {}               ) === 73,    "number ^ object")
ok(( 73      ^  new Number(34.2) ) === 107,   "number ^ number object")
ok(( {}      ^  void 0           ) === 0,     "object ^ undefined")
ok(( {}      ^  null             ) === 0,     "object ^ null")
ok(( {}      ^  true             ) === 1,     "object ^ boolean")
ok(( {}      ^ "string"          ) === 0,     "object ^ string")
ok(( {}      ^  73               ) === 73,    "object ^ number")
ok(( {}      ^  {}               ) === 0,     "object ^ object")
ok(( {}      ^  new Number(34.2) ) === 34,    "object ^ number object")
ok(( new Number(34.2) ^  void 0  ) === 34,    "number object ^ undefined")
ok(( new Number(34.2) ^  null    ) === 34,    "number object ^ null")
ok(( new Number(34.2) ^  true    ) === 35,    "number object ^ boolean")
ok(( new Number(34.2) ^ "string" ) === 34,    "number object ^ string")
ok(( new Number(34.2) ^  73      ) === 107,   "number object ^ number")
ok(( new Number(34.2) ^  {}      ) === 34,    "number object ^ object")
ok(( new Number(34.2) ^  new Number(34.2) ) === 0,
	"number object ^ number object")

/* Tests 941-1781: numebr ^ number */

n2n = [
	[NaN, NaN, 0],
	[NaN, 0, 0],
	[NaN, 0, 0],
	[NaN, Infinity, 0],
	[NaN, -Infinity, 0],
	[NaN, 1, 1],
	[NaN, 32.5, 32],
	[NaN, 2147483648, -2147483648],
	[NaN, 3000000000, -1294967296],
	[NaN, 4000000000.23, -294967296],
	[NaN, 5000000000, 705032704],
	[NaN, 4294967296, 0],
	[NaN, 4294967298.479, 2],
	[NaN, 6442450942, 2147483646],
	[NaN, 6442450943.674, 2147483647],
	[NaN, 6442450944, -2147483648],
	[NaN, 6442450945, -2147483647],
	[NaN, 6442450946.74, -2147483646],
	[NaN, -1, -1],
	[NaN, -32.5, -32],
	[NaN, -3000000000, 1294967296],
	[NaN, -4000000000.23, 294967296],
	[NaN, -5000000000, -705032704],
	[NaN, -4294967298.479, -2],
	[NaN, -6442450942, -2147483646],
	[NaN, -6442450943.674, -2147483647],
	[NaN, -6442450944, -2147483648],
	[NaN, -6442450945, 2147483647],
	[NaN, -6442450946.74, 2147483646],
	[0, NaN, 0],
	[0, 0, 0],
	[0, 0, 0],
	[0, Infinity, 0],
	[0, -Infinity, 0],
	[0, 1, 1],
	[0, 32.5, 32],
	[0, 2147483648, -2147483648],
	[0, 3000000000, -1294967296],
	[0, 4000000000.23, -294967296],
	[0, 5000000000, 705032704],
	[0, 4294967296, 0],
	[0, 4294967298.479, 2],
	[0, 6442450942, 2147483646],
	[0, 6442450943.674, 2147483647],
	[0, 6442450944, -2147483648],
	[0, 6442450945, -2147483647],
	[0, 6442450946.74, -2147483646],
	[0, -1, -1],
	[0, -32.5, -32],
	[0, -3000000000, 1294967296],
	[0, -4000000000.23, 294967296],
	[0, -5000000000, -705032704],
	[0, -4294967298.479, -2],
	[0, -6442450942, -2147483646],
	[0, -6442450943.674, -2147483647],
	[0, -6442450944, -2147483648],
	[0, -6442450945, 2147483647],
	[0, -6442450946.74, 2147483646],
	[0, NaN, 0],
	[0, 0, 0],
	[0, 0, 0],
	[0, Infinity, 0],
	[0, -Infinity, 0],
	[0, 1, 1],
	[0, 32.5, 32],
	[0, 2147483648, -2147483648],
	[0, 3000000000, -1294967296],
	[0, 4000000000.23, -294967296],
	[0, 5000000000, 705032704],
	[0, 4294967296, 0],
	[0, 4294967298.479, 2],
	[0, 6442450942, 2147483646],
	[0, 6442450943.674, 2147483647],
	[0, 6442450944, -2147483648],
	[0, 6442450945, -2147483647],
	[0, 6442450946.74, -2147483646],
	[0, -1, -1],
	[0, -32.5, -32],
	[0, -3000000000, 1294967296],
	[0, -4000000000.23, 294967296],
	[0, -5000000000, -705032704],
	[0, -4294967298.479, -2],
	[0, -6442450942, -2147483646],
	[0, -6442450943.674, -2147483647],
	[0, -6442450944, -2147483648],
	[0, -6442450945, 2147483647],
	[0, -6442450946.74, 2147483646],
	[Infinity, NaN, 0],
	[Infinity, 0, 0],
	[Infinity, 0, 0],
	[Infinity, Infinity, 0],
	[Infinity, -Infinity, 0],
	[Infinity, 1, 1],
	[Infinity, 32.5, 32],
	[Infinity, 2147483648, -2147483648],
	[Infinity, 3000000000, -1294967296],
	[Infinity, 4000000000.23, -294967296],
	[Infinity, 5000000000, 705032704],
	[Infinity, 4294967296, 0],
	[Infinity, 4294967298.479, 2],
	[Infinity, 6442450942, 2147483646],
	[Infinity, 6442450943.674, 2147483647],
	[Infinity, 6442450944, -2147483648],
	[Infinity, 6442450945, -2147483647],
	[Infinity, 6442450946.74, -2147483646],
	[Infinity, -1, -1],
	[Infinity, -32.5, -32],
	[Infinity, -3000000000, 1294967296],
	[Infinity, -4000000000.23, 294967296],
	[Infinity, -5000000000, -705032704],
	[Infinity, -4294967298.479, -2],
	[Infinity, -6442450942, -2147483646],
	[Infinity, -6442450943.674, -2147483647],
	[Infinity, -6442450944, -2147483648],
	[Infinity, -6442450945, 2147483647],
	[Infinity, -6442450946.74, 2147483646],
	[-Infinity, NaN, 0],
	[-Infinity, 0, 0],
	[-Infinity, 0, 0],
	[-Infinity, Infinity, 0],
	[-Infinity, -Infinity, 0],
	[-Infinity, 1, 1],
	[-Infinity, 32.5, 32],
	[-Infinity, 2147483648, -2147483648],
	[-Infinity, 3000000000, -1294967296],
	[-Infinity, 4000000000.23, -294967296],
	[-Infinity, 5000000000, 705032704],
	[-Infinity, 4294967296, 0],
	[-Infinity, 4294967298.479, 2],
	[-Infinity, 6442450942, 2147483646],
	[-Infinity, 6442450943.674, 2147483647],
	[-Infinity, 6442450944, -2147483648],
	[-Infinity, 6442450945, -2147483647],
	[-Infinity, 6442450946.74, -2147483646],
	[-Infinity, -1, -1],
	[-Infinity, -32.5, -32],
	[-Infinity, -3000000000, 1294967296],
	[-Infinity, -4000000000.23, 294967296],
	[-Infinity, -5000000000, -705032704],
	[-Infinity, -4294967298.479, -2],
	[-Infinity, -6442450942, -2147483646],
	[-Infinity, -6442450943.674, -2147483647],
	[-Infinity, -6442450944, -2147483648],
	[-Infinity, -6442450945, 2147483647],
	[-Infinity, -6442450946.74, 2147483646],
	[1, NaN, 1],
	[1, 0, 1],
	[1, 0, 1],
	[1, Infinity, 1],
	[1, -Infinity, 1],
	[1, 1, 0],
	[1, 32.5, 33],
	[1, 2147483648, -2147483647],
	[1, 3000000000, -1294967295],
	[1, 4000000000.23, -294967295],
	[1, 5000000000, 705032705],
	[1, 4294967296, 1],
	[1, 4294967298.479, 3],
	[1, 6442450942, 2147483647],
	[1, 6442450943.674, 2147483646],
	[1, 6442450944, -2147483647],
	[1, 6442450945, -2147483648],
	[1, 6442450946.74, -2147483645],
	[1, -1, -2],
	[1, -32.5, -31],
	[1, -3000000000, 1294967297],
	[1, -4000000000.23, 294967297],
	[1, -5000000000, -705032703],
	[1, -4294967298.479, -1],
	[1, -6442450942, -2147483645],
	[1, -6442450943.674, -2147483648],
	[1, -6442450944, -2147483647],
	[1, -6442450945, 2147483646],
	[1, -6442450946.74, 2147483647],
	[32.5, NaN, 32],
	[32.5, 0, 32],
	[32.5, 0, 32],
	[32.5, Infinity, 32],
	[32.5, -Infinity, 32],
	[32.5, 1, 33],
	[32.5, 32.5, 0],
	[32.5, 2147483648, -2147483616],
	[32.5, 3000000000, -1294967264],
	[32.5, 4000000000.23, -294967264],
	[32.5, 5000000000, 705032736],
	[32.5, 4294967296, 32],
	[32.5, 4294967298.479, 34],
	[32.5, 6442450942, 2147483614],
	[32.5, 6442450943.674, 2147483615],
	[32.5, 6442450944, -2147483616],
	[32.5, 6442450945, -2147483615],
	[32.5, 6442450946.74, -2147483614],
	[32.5, -1, -33],
	[32.5, -32.5, -64],
	[32.5, -3000000000, 1294967328],
	[32.5, -4000000000.23, 294967328],
	[32.5, -5000000000, -705032672],
	[32.5, -4294967298.479, -34],
	[32.5, -6442450942, -2147483614],
	[32.5, -6442450943.674, -2147483615],
	[32.5, -6442450944, -2147483616],
	[32.5, -6442450945, 2147483615],
	[32.5, -6442450946.74, 2147483614],
	[2147483648, NaN, -2147483648],
	[2147483648, 0, -2147483648],
	[2147483648, 0, -2147483648],
	[2147483648, Infinity, -2147483648],
	[2147483648, -Infinity, -2147483648],
	[2147483648, 1, -2147483647],
	[2147483648, 32.5, -2147483616],
	[2147483648, 2147483648, 0],
	[2147483648, 3000000000, 852516352],
	[2147483648, 4000000000.23, 1852516352],
	[2147483648, 5000000000, -1442450944],
	[2147483648, 4294967296, -2147483648],
	[2147483648, 4294967298.479, -2147483646],
	[2147483648, 6442450942, -2],
	[2147483648, 6442450943.674, -1],
	[2147483648, 6442450944, 0],
	[2147483648, 6442450945, 1],
	[2147483648, 6442450946.74, 2],
	[2147483648, -1, 2147483647],
	[2147483648, -32.5, 2147483616],
	[2147483648, -3000000000, -852516352],
	[2147483648, -4000000000.23, -1852516352],
	[2147483648, -5000000000, 1442450944],
	[2147483648, -4294967298.479, 2147483646],
	[2147483648, -6442450942, 2],
	[2147483648, -6442450943.674, 1],
	[2147483648, -6442450944, 0],
	[2147483648, -6442450945, -1],
	[2147483648, -6442450946.74, -2],
	[3000000000, NaN, -1294967296],
	[3000000000, 0, -1294967296],
	[3000000000, 0, -1294967296],
	[3000000000, Infinity, -1294967296],
	[3000000000, -Infinity, -1294967296],
	[3000000000, 1, -1294967295],
	[3000000000, 32.5, -1294967264],
	[3000000000, 2147483648, 852516352],
	[3000000000, 3000000000, 0],
	[3000000000, 4000000000.23, 1555789312],
	[3000000000, 5000000000, -1730827264],
	[3000000000, 4294967296, -1294967296],
	[3000000000, 4294967298.479, -1294967294],
	[3000000000, 6442450942, -852516354],
	[3000000000, 6442450943.674, -852516353],
	[3000000000, 6442450944, 852516352],
	[3000000000, 6442450945, 852516353],
	[3000000000, 6442450946.74, 852516354],
	[3000000000, -1, 1294967295],
	[3000000000, -32.5, 1294967264],
	[3000000000, -3000000000, -1024],
	[3000000000, -4000000000.23, -1555790336],
	[3000000000, -5000000000, 1730826240],
	[3000000000, -4294967298.479, 1294967294],
	[3000000000, -6442450942, 852516354],
	[3000000000, -6442450943.674, 852516353],
	[3000000000, -6442450944, 852516352],
	[3000000000, -6442450945, -852516353],
	[3000000000, -6442450946.74, -852516354],
	[4000000000.23, NaN, -294967296],
	[4000000000.23, 0, -294967296],
	[4000000000.23, 0, -294967296],
	[4000000000.23, Infinity, -294967296],
	[4000000000.23, -Infinity, -294967296],
	[4000000000.23, 1, -294967295],
	[4000000000.23, 32.5, -294967264],
	[4000000000.23, 2147483648, 1852516352],
	[4000000000.23, 3000000000, 1555789312],
	[4000000000.23, 4000000000.23, 0],
	[4000000000.23, 5000000000, -999368192],
	[4000000000.23, 4294967296, -294967296],
	[4000000000.23, 4294967298.479, -294967294],
	[4000000000.23, 6442450942, -1852516354],
	[4000000000.23, 6442450943.674, -1852516353],
	[4000000000.23, 6442450944, 1852516352],
	[4000000000.23, 6442450945, 1852516353],
	[4000000000.23, 6442450946.74, 1852516354],
	[4000000000.23, -1, 294967295],
	[4000000000.23, -32.5, 294967264],
	[4000000000.23, -3000000000, -1555789312],
	[4000000000.23, -4000000000.23, -4096],
	[4000000000.23, -5000000000, 999368192],
	[4000000000.23, -4294967298.479, 294967294],
	[4000000000.23, -6442450942, 1852516354],
	[4000000000.23, -6442450943.674, 1852516353],
	[4000000000.23, -6442450944, 1852516352],
	[4000000000.23, -6442450945, -1852516353],
	[4000000000.23, -6442450946.74, -1852516354],
	[5000000000, NaN, 705032704],
	[5000000000, 0, 705032704],
	[5000000000, 0, 705032704],
	[5000000000, Infinity, 705032704],
	[5000000000, -Infinity, 705032704],
	[5000000000, 1, 705032705],
	[5000000000, 32.5, 705032736],
	[5000000000, 2147483648, -1442450944],
	[5000000000, 3000000000, -1730827264],
	[5000000000, 4000000000.23, -999368192],
	[5000000000, 5000000000, 0],
	[5000000000, 4294967296, 705032704],
	[5000000000, 4294967298.479, 705032706],
	[5000000000, 6442450942, 1442450942],
	[5000000000, 6442450943.674, 1442450943],
	[5000000000, 6442450944, -1442450944],
	[5000000000, 6442450945, -1442450943],
	[5000000000, 6442450946.74, -1442450942],
	[5000000000, -1, -705032705],
	[5000000000, -32.5, -705032736],
	[5000000000, -3000000000, 1730826240],
	[5000000000, -4000000000.23, 999369216],
	[5000000000, -5000000000, -1024],
	[5000000000, -4294967298.479, -705032706],
	[5000000000, -6442450942, -1442450942],
	[5000000000, -6442450943.674, -1442450943],
	[5000000000, -6442450944, -1442450944],
	[5000000000, -6442450945, 1442450943],
	[5000000000, -6442450946.74, 1442450942],
	[4294967296, NaN, 0],
	[4294967296, 0, 0],
	[4294967296, 0, 0],
	[4294967296, Infinity, 0],
	[4294967296, -Infinity, 0],
	[4294967296, 1, 1],
	[4294967296, 32.5, 32],
	[4294967296, 2147483648, -2147483648],
	[4294967296, 3000000000, -1294967296],
	[4294967296, 4000000000.23, -294967296],
	[4294967296, 5000000000, 705032704],
	[4294967296, 4294967296, 0],
	[4294967296, 4294967298.479, 2],
	[4294967296, 6442450942, 2147483646],
	[4294967296, 6442450943.674, 2147483647],
	[4294967296, 6442450944, -2147483648],
	[4294967296, 6442450945, -2147483647],
	[4294967296, 6442450946.74, -2147483646],
	[4294967296, -1, -1],
	[4294967296, -32.5, -32],
	[4294967296, -3000000000, 1294967296],
	[4294967296, -4000000000.23, 294967296],
	[4294967296, -5000000000, -705032704],
	[4294967296, -4294967298.479, -2],
	[4294967296, -6442450942, -2147483646],
	[4294967296, -6442450943.674, -2147483647],
	[4294967296, -6442450944, -2147483648],
	[4294967296, -6442450945, 2147483647],
	[4294967296, -6442450946.74, 2147483646],
	[4294967298.479, NaN, 2],
	[4294967298.479, 0, 2],
	[4294967298.479, 0, 2],
	[4294967298.479, Infinity, 2],
	[4294967298.479, -Infinity, 2],
	[4294967298.479, 1, 3],
	[4294967298.479, 32.5, 34],
	[4294967298.479, 2147483648, -2147483646],
	[4294967298.479, 3000000000, -1294967294],
	[4294967298.479, 4000000000.23, -294967294],
	[4294967298.479, 5000000000, 705032706],
	[4294967298.479, 4294967296, 2],
	[4294967298.479, 4294967298.479, 0],
	[4294967298.479, 6442450942, 2147483644],
	[4294967298.479, 6442450943.674, 2147483645],
	[4294967298.479, 6442450944, -2147483646],
	[4294967298.479, 6442450945, -2147483645],
	[4294967298.479, 6442450946.74, -2147483648],
	[4294967298.479, -1, -3],
	[4294967298.479, -32.5, -30],
	[4294967298.479, -3000000000, 1294967298],
	[4294967298.479, -4000000000.23, 294967298],
	[4294967298.479, -5000000000, -705032702],
	[4294967298.479, -4294967298.479, -4],
	[4294967298.479, -6442450942, -2147483648],
	[4294967298.479, -6442450943.674, -2147483645],
	[4294967298.479, -6442450944, -2147483646],
	[4294967298.479, -6442450945, 2147483645],
	[4294967298.479, -6442450946.74, 2147483644],
	[6442450942, NaN, 2147483646],
	[6442450942, 0, 2147483646],
	[6442450942, 0, 2147483646],
	[6442450942, Infinity, 2147483646],
	[6442450942, -Infinity, 2147483646],
	[6442450942, 1, 2147483647],
	[6442450942, 32.5, 2147483614],
	[6442450942, 2147483648, -2],
	[6442450942, 3000000000, -852516354],
	[6442450942, 4000000000.23, -1852516354],
	[6442450942, 5000000000, 1442450942],
	[6442450942, 4294967296, 2147483646],
	[6442450942, 4294967298.479, 2147483644],
	[6442450942, 6442450942, 0],
	[6442450942, 6442450943.674, 1],
	[6442450942, 6442450944, -2],
	[6442450942, 6442450945, -1],
	[6442450942, 6442450946.74, -4],
	[6442450942, -1, -2147483647],
	[6442450942, -32.5, -2147483618],
	[6442450942, -3000000000, 852516350],
	[6442450942, -4000000000.23, 1852516350],
	[6442450942, -5000000000, -1442450946],
	[6442450942, -4294967298.479, -2147483648],
	[6442450942, -6442450942, -4],
	[6442450942, -6442450943.674, -1],
	[6442450942, -6442450944, -2],
	[6442450942, -6442450945, 1],
	[6442450942, -6442450946.74, 0],
	[6442450943.674, NaN, 2147483647],
	[6442450943.674, 0, 2147483647],
	[6442450943.674, 0, 2147483647],
	[6442450943.674, Infinity, 2147483647],
	[6442450943.674, -Infinity, 2147483647],
	[6442450943.674, 1, 2147483646],
	[6442450943.674, 32.5, 2147483615],
	[6442450943.674, 2147483648, -1],
	[6442450943.674, 3000000000, -852516353],
	[6442450943.674, 4000000000.23, -1852516353],
	[6442450943.674, 5000000000, 1442450943],
	[6442450943.674, 4294967296, 2147483647],
	[6442450943.674, 4294967298.479, 2147483645],
	[6442450943.674, 6442450942, 1],
	[6442450943.674, 6442450943.674, 0],
	[6442450943.674, 6442450944, -1],
	[6442450943.674, 6442450945, -2],
	[6442450943.674, 6442450946.74, -3],
	[6442450943.674, -1, -2147483648],
	[6442450943.674, -32.5, -2147483617],
	[6442450943.674, -3000000000, 852516351],
	[6442450943.674, -4000000000.23, 1852516351],
	[6442450943.674, -5000000000, -1442450945],
	[6442450943.674, -4294967298.479, -2147483647],
	[6442450943.674, -6442450942, -3],
	[6442450943.674, -6442450943.674, -2],
	[6442450943.674, -6442450944, -1],
	[6442450943.674, -6442450945, 0],
	[6442450943.674, -6442450946.74, 1],
	[6442450944, NaN, -2147483648],
	[6442450944, 0, -2147483648],
	[6442450944, 0, -2147483648],
	[6442450944, Infinity, -2147483648],
	[6442450944, -Infinity, -2147483648],
	[6442450944, 1, -2147483647],
	[6442450944, 32.5, -2147483616],
	[6442450944, 2147483648, 0],
	[6442450944, 3000000000, 852516352],
	[6442450944, 4000000000.23, 1852516352],
	[6442450944, 5000000000, -1442450944],
	[6442450944, 4294967296, -2147483648],
	[6442450944, 4294967298.479, -2147483646],
	[6442450944, 6442450942, -2],
	[6442450944, 6442450943.674, -1],
	[6442450944, 6442450944, 0],
	[6442450944, 6442450945, 1],
	[6442450944, 6442450946.74, 2],
	[6442450944, -1, 2147483647],
	[6442450944, -32.5, 2147483616],
	[6442450944, -3000000000, -852516352],
	[6442450944, -4000000000.23, -1852516352],
	[6442450944, -5000000000, 1442450944],
	[6442450944, -4294967298.479, 2147483646],
	[6442450944, -6442450942, 2],
	[6442450944, -6442450943.674, 1],
	[6442450944, -6442450944, 0],
	[6442450944, -6442450945, -1],
	[6442450944, -6442450946.74, -2],
	[6442450945, NaN, -2147483647],
	[6442450945, 0, -2147483647],
	[6442450945, 0, -2147483647],
	[6442450945, Infinity, -2147483647],
	[6442450945, -Infinity, -2147483647],
	[6442450945, 1, -2147483648],
	[6442450945, 32.5, -2147483615],
	[6442450945, 2147483648, 1],
	[6442450945, 3000000000, 852516353],
	[6442450945, 4000000000.23, 1852516353],
	[6442450945, 5000000000, -1442450943],
	[6442450945, 4294967296, -2147483647],
	[6442450945, 4294967298.479, -2147483645],
	[6442450945, 6442450942, -1],
	[6442450945, 6442450943.674, -2],
	[6442450945, 6442450944, 1],
	[6442450945, 6442450945, 0],
	[6442450945, 6442450946.74, 3],
	[6442450945, -1, 2147483646],
	[6442450945, -32.5, 2147483617],
	[6442450945, -3000000000, -852516351],
	[6442450945, -4000000000.23, -1852516351],
	[6442450945, -5000000000, 1442450945],
	[6442450945, -4294967298.479, 2147483647],
	[6442450945, -6442450942, 3],
	[6442450945, -6442450943.674, 0],
	[6442450945, -6442450944, 1],
	[6442450945, -6442450945, -2],
	[6442450945, -6442450946.74, -1],
	[6442450946.74, NaN, -2147483646],
	[6442450946.74, 0, -2147483646],
	[6442450946.74, 0, -2147483646],
	[6442450946.74, Infinity, -2147483646],
	[6442450946.74, -Infinity, -2147483646],
	[6442450946.74, 1, -2147483645],
	[6442450946.74, 32.5, -2147483614],
	[6442450946.74, 2147483648, 2],
	[6442450946.74, 3000000000, 852516354],
	[6442450946.74, 4000000000.23, 1852516354],
	[6442450946.74, 5000000000, -1442450942],
	[6442450946.74, 4294967296, -2147483646],
	[6442450946.74, 4294967298.479, -2147483648],
	[6442450946.74, 6442450942, -4],
	[6442450946.74, 6442450943.674, -3],
	[6442450946.74, 6442450944, 2],
	[6442450946.74, 6442450945, 3],
	[6442450946.74, 6442450946.74, 0],
	[6442450946.74, -1, 2147483645],
	[6442450946.74, -32.5, 2147483618],
	[6442450946.74, -3000000000, -852516350],
	[6442450946.74, -4000000000.23, -1852516350],
	[6442450946.74, -5000000000, 1442450946],
	[6442450946.74, -4294967298.479, 2147483644],
	[6442450946.74, -6442450942, 0],
	[6442450946.74, -6442450943.674, 3],
	[6442450946.74, -6442450944, 2],
	[6442450946.74, -6442450945, -3],
	[6442450946.74, -6442450946.74, -4],
	[-1, NaN, -1],
	[-1, 0, -1],
	[-1, 0, -1],
	[-1, Infinity, -1],
	[-1, -Infinity, -1],
	[-1, 1, -2],
	[-1, 32.5, -33],
	[-1, 2147483648, 2147483647],
	[-1, 3000000000, 1294967295],
	[-1, 4000000000.23, 294967295],
	[-1, 5000000000, -705032705],
	[-1, 4294967296, -1],
	[-1, 4294967298.479, -3],
	[-1, 6442450942, -2147483647],
	[-1, 6442450943.674, -2147483648],
	[-1, 6442450944, 2147483647],
	[-1, 6442450945, 2147483646],
	[-1, 6442450946.74, 2147483645],
	[-1, -1, 0],
	[-1, -32.5, 31],
	[-1, -3000000000, -1294967297],
	[-1, -4000000000.23, -294967297],
	[-1, -5000000000, 705032703],
	[-1, -4294967298.479, 1],
	[-1, -6442450942, 2147483645],
	[-1, -6442450943.674, 2147483646],
	[-1, -6442450944, 2147483647],
	[-1, -6442450945, -2147483648],
	[-1, -6442450946.74, -2147483647],
	[-32.5, NaN, -32],
	[-32.5, 0, -32],
	[-32.5, 0, -32],
	[-32.5, Infinity, -32],
	[-32.5, -Infinity, -32],
	[-32.5, 1, -31],
	[-32.5, 32.5, -64],
	[-32.5, 2147483648, 2147483616],
	[-32.5, 3000000000, 1294967264],
	[-32.5, 4000000000.23, 294967264],
	[-32.5, 5000000000, -705032736],
	[-32.5, 4294967296, -32],
	[-32.5, 4294967298.479, -30],
	[-32.5, 6442450942, -2147483618],
	[-32.5, 6442450943.674, -2147483617],
	[-32.5, 6442450944, 2147483616],
	[-32.5, 6442450945, 2147483617],
	[-32.5, 6442450946.74, 2147483618],
	[-32.5, -1, 31],
	[-32.5, -32.5, 0],
	[-32.5, -3000000000, -1294967328],
	[-32.5, -4000000000.23, -294967328],
	[-32.5, -5000000000, 705032672],
	[-32.5, -4294967298.479, 30],
	[-32.5, -6442450942, 2147483618],
	[-32.5, -6442450943.674, 2147483617],
	[-32.5, -6442450944, 2147483616],
	[-32.5, -6442450945, -2147483617],
	[-32.5, -6442450946.74, -2147483618],
	[-3000000000, NaN, 1294967296],
	[-3000000000, 0, 1294967296],
	[-3000000000, 0, 1294967296],
	[-3000000000, Infinity, 1294967296],
	[-3000000000, -Infinity, 1294967296],
	[-3000000000, 1, 1294967297],
	[-3000000000, 32.5, 1294967328],
	[-3000000000, 2147483648, -852516352],
	[-3000000000, 3000000000, -1024],
	[-3000000000, 4000000000.23, -1555789312],
	[-3000000000, 5000000000, 1730826240],
	[-3000000000, 4294967296, 1294967296],
	[-3000000000, 4294967298.479, 1294967298],
	[-3000000000, 6442450942, 852516350],
	[-3000000000, 6442450943.674, 852516351],
	[-3000000000, 6442450944, -852516352],
	[-3000000000, 6442450945, -852516351],
	[-3000000000, 6442450946.74, -852516350],
	[-3000000000, -1, -1294967297],
	[-3000000000, -32.5, -1294967328],
	[-3000000000, -3000000000, 0],
	[-3000000000, -4000000000.23, 1555790336],
	[-3000000000, -5000000000, -1730827264],
	[-3000000000, -4294967298.479, -1294967298],
	[-3000000000, -6442450942, -852516350],
	[-3000000000, -6442450943.674, -852516351],
	[-3000000000, -6442450944, -852516352],
	[-3000000000, -6442450945, 852516351],
	[-3000000000, -6442450946.74, 852516350],
	[-4000000000.23, NaN, 294967296],
	[-4000000000.23, 0, 294967296],
	[-4000000000.23, 0, 294967296],
	[-4000000000.23, Infinity, 294967296],
	[-4000000000.23, -Infinity, 294967296],
	[-4000000000.23, 1, 294967297],
	[-4000000000.23, 32.5, 294967328],
	[-4000000000.23, 2147483648, -1852516352],
	[-4000000000.23, 3000000000, -1555790336],
	[-4000000000.23, 4000000000.23, -4096],
	[-4000000000.23, 5000000000, 999369216],
	[-4000000000.23, 4294967296, 294967296],
	[-4000000000.23, 4294967298.479, 294967298],
	[-4000000000.23, 6442450942, 1852516350],
	[-4000000000.23, 6442450943.674, 1852516351],
	[-4000000000.23, 6442450944, -1852516352],
	[-4000000000.23, 6442450945, -1852516351],
	[-4000000000.23, 6442450946.74, -1852516350],
	[-4000000000.23, -1, -294967297],
	[-4000000000.23, -32.5, -294967328],
	[-4000000000.23, -3000000000, 1555790336],
	[-4000000000.23, -4000000000.23, 0],
	[-4000000000.23, -5000000000, -999369216],
	[-4000000000.23, -4294967298.479, -294967298],
	[-4000000000.23, -6442450942, -1852516350],
	[-4000000000.23, -6442450943.674, -1852516351],
	[-4000000000.23, -6442450944, -1852516352],
	[-4000000000.23, -6442450945, 1852516351],
	[-4000000000.23, -6442450946.74, 1852516350],
	[-5000000000, NaN, -705032704],
	[-5000000000, 0, -705032704],
	[-5000000000, 0, -705032704],
	[-5000000000, Infinity, -705032704],
	[-5000000000, -Infinity, -705032704],
	[-5000000000, 1, -705032703],
	[-5000000000, 32.5, -705032672],
	[-5000000000, 2147483648, 1442450944],
	[-5000000000, 3000000000, 1730826240],
	[-5000000000, 4000000000.23, 999368192],
	[-5000000000, 5000000000, -1024],
	[-5000000000, 4294967296, -705032704],
	[-5000000000, 4294967298.479, -705032702],
	[-5000000000, 6442450942, -1442450946],
	[-5000000000, 6442450943.674, -1442450945],
	[-5000000000, 6442450944, 1442450944],
	[-5000000000, 6442450945, 1442450945],
	[-5000000000, 6442450946.74, 1442450946],
	[-5000000000, -1, 705032703],
	[-5000000000, -32.5, 705032672],
	[-5000000000, -3000000000, -1730827264],
	[-5000000000, -4000000000.23, -999369216],
	[-5000000000, -5000000000, 0],
	[-5000000000, -4294967298.479, 705032702],
	[-5000000000, -6442450942, 1442450946],
	[-5000000000, -6442450943.674, 1442450945],
	[-5000000000, -6442450944, 1442450944],
	[-5000000000, -6442450945, -1442450945],
	[-5000000000, -6442450946.74, -1442450946],
	[-4294967298.479, NaN, -2],
	[-4294967298.479, 0, -2],
	[-4294967298.479, 0, -2],
	[-4294967298.479, Infinity, -2],
	[-4294967298.479, -Infinity, -2],
	[-4294967298.479, 1, -1],
	[-4294967298.479, 32.5, -34],
	[-4294967298.479, 2147483648, 2147483646],
	[-4294967298.479, 3000000000, 1294967294],
	[-4294967298.479, 4000000000.23, 294967294],
	[-4294967298.479, 5000000000, -705032706],
	[-4294967298.479, 4294967296, -2],
	[-4294967298.479, 4294967298.479, -4],
	[-4294967298.479, 6442450942, -2147483648],
	[-4294967298.479, 6442450943.674, -2147483647],
	[-4294967298.479, 6442450944, 2147483646],
	[-4294967298.479, 6442450945, 2147483647],
	[-4294967298.479, 6442450946.74, 2147483644],
	[-4294967298.479, -1, 1],
	[-4294967298.479, -32.5, 30],
	[-4294967298.479, -3000000000, -1294967298],
	[-4294967298.479, -4000000000.23, -294967298],
	[-4294967298.479, -5000000000, 705032702],
	[-4294967298.479, -4294967298.479, 0],
	[-4294967298.479, -6442450942, 2147483644],
	[-4294967298.479, -6442450943.674, 2147483647],
	[-4294967298.479, -6442450944, 2147483646],
	[-4294967298.479, -6442450945, -2147483647],
	[-4294967298.479, -6442450946.74, -2147483648],
	[-6442450942, NaN, -2147483646],
	[-6442450942, 0, -2147483646],
	[-6442450942, 0, -2147483646],
	[-6442450942, Infinity, -2147483646],
	[-6442450942, -Infinity, -2147483646],
	[-6442450942, 1, -2147483645],
	[-6442450942, 32.5, -2147483614],
	[-6442450942, 2147483648, 2],
	[-6442450942, 3000000000, 852516354],
	[-6442450942, 4000000000.23, 1852516354],
	[-6442450942, 5000000000, -1442450942],
	[-6442450942, 4294967296, -2147483646],
	[-6442450942, 4294967298.479, -2147483648],
	[-6442450942, 6442450942, -4],
	[-6442450942, 6442450943.674, -3],
	[-6442450942, 6442450944, 2],
	[-6442450942, 6442450945, 3],
	[-6442450942, 6442450946.74, 0],
	[-6442450942, -1, 2147483645],
	[-6442450942, -32.5, 2147483618],
	[-6442450942, -3000000000, -852516350],
	[-6442450942, -4000000000.23, -1852516350],
	[-6442450942, -5000000000, 1442450946],
	[-6442450942, -4294967298.479, 2147483644],
	[-6442450942, -6442450942, 0],
	[-6442450942, -6442450943.674, 3],
	[-6442450942, -6442450944, 2],
	[-6442450942, -6442450945, -3],
	[-6442450942, -6442450946.74, -4],
	[-6442450943.674, NaN, -2147483647],
	[-6442450943.674, 0, -2147483647],
	[-6442450943.674, 0, -2147483647],
	[-6442450943.674, Infinity, -2147483647],
	[-6442450943.674, -Infinity, -2147483647],
	[-6442450943.674, 1, -2147483648],
	[-6442450943.674, 32.5, -2147483615],
	[-6442450943.674, 2147483648, 1],
	[-6442450943.674, 3000000000, 852516353],
	[-6442450943.674, 4000000000.23, 1852516353],
	[-6442450943.674, 5000000000, -1442450943],
	[-6442450943.674, 4294967296, -2147483647],
	[-6442450943.674, 4294967298.479, -2147483645],
	[-6442450943.674, 6442450942, -1],
	[-6442450943.674, 6442450943.674, -2],
	[-6442450943.674, 6442450944, 1],
	[-6442450943.674, 6442450945, 0],
	[-6442450943.674, 6442450946.74, 3],
	[-6442450943.674, -1, 2147483646],
	[-6442450943.674, -32.5, 2147483617],
	[-6442450943.674, -3000000000, -852516351],
	[-6442450943.674, -4000000000.23, -1852516351],
	[-6442450943.674, -5000000000, 1442450945],
	[-6442450943.674, -4294967298.479, 2147483647],
	[-6442450943.674, -6442450942, 3],
	[-6442450943.674, -6442450943.674, 0],
	[-6442450943.674, -6442450944, 1],
	[-6442450943.674, -6442450945, -2],
	[-6442450943.674, -6442450946.74, -1],
	[-6442450944, NaN, -2147483648],
	[-6442450944, 0, -2147483648],
	[-6442450944, 0, -2147483648],
	[-6442450944, Infinity, -2147483648],
	[-6442450944, -Infinity, -2147483648],
	[-6442450944, 1, -2147483647],
	[-6442450944, 32.5, -2147483616],
	[-6442450944, 2147483648, 0],
	[-6442450944, 3000000000, 852516352],
	[-6442450944, 4000000000.23, 1852516352],
	[-6442450944, 5000000000, -1442450944],
	[-6442450944, 4294967296, -2147483648],
	[-6442450944, 4294967298.479, -2147483646],
	[-6442450944, 6442450942, -2],
	[-6442450944, 6442450943.674, -1],
	[-6442450944, 6442450944, 0],
	[-6442450944, 6442450945, 1],
	[-6442450944, 6442450946.74, 2],
	[-6442450944, -1, 2147483647],
	[-6442450944, -32.5, 2147483616],
	[-6442450944, -3000000000, -852516352],
	[-6442450944, -4000000000.23, -1852516352],
	[-6442450944, -5000000000, 1442450944],
	[-6442450944, -4294967298.479, 2147483646],
	[-6442450944, -6442450942, 2],
	[-6442450944, -6442450943.674, 1],
	[-6442450944, -6442450944, 0],
	[-6442450944, -6442450945, -1],
	[-6442450944, -6442450946.74, -2],
	[-6442450945, NaN, 2147483647],
	[-6442450945, 0, 2147483647],
	[-6442450945, 0, 2147483647],
	[-6442450945, Infinity, 2147483647],
	[-6442450945, -Infinity, 2147483647],
	[-6442450945, 1, 2147483646],
	[-6442450945, 32.5, 2147483615],
	[-6442450945, 2147483648, -1],
	[-6442450945, 3000000000, -852516353],
	[-6442450945, 4000000000.23, -1852516353],
	[-6442450945, 5000000000, 1442450943],
	[-6442450945, 4294967296, 2147483647],
	[-6442450945, 4294967298.479, 2147483645],
	[-6442450945, 6442450942, 1],
	[-6442450945, 6442450943.674, 0],
	[-6442450945, 6442450944, -1],
	[-6442450945, 6442450945, -2],
	[-6442450945, 6442450946.74, -3],
	[-6442450945, -1, -2147483648],
	[-6442450945, -32.5, -2147483617],
	[-6442450945, -3000000000, 852516351],
	[-6442450945, -4000000000.23, 1852516351],
	[-6442450945, -5000000000, -1442450945],
	[-6442450945, -4294967298.479, -2147483647],
	[-6442450945, -6442450942, -3],
	[-6442450945, -6442450943.674, -2],
	[-6442450945, -6442450944, -1],
	[-6442450945, -6442450945, 0],
	[-6442450945, -6442450946.74, 1],
	[-6442450946.74, NaN, 2147483646],
	[-6442450946.74, 0, 2147483646],
	[-6442450946.74, 0, 2147483646],
	[-6442450946.74, Infinity, 2147483646],
	[-6442450946.74, -Infinity, 2147483646],
	[-6442450946.74, 1, 2147483647],
	[-6442450946.74, 32.5, 2147483614],
	[-6442450946.74, 2147483648, -2],
	[-6442450946.74, 3000000000, -852516354],
	[-6442450946.74, 4000000000.23, -1852516354],
	[-6442450946.74, 5000000000, 1442450942],
	[-6442450946.74, 4294967296, 2147483646],
	[-6442450946.74, 4294967298.479, 2147483644],
	[-6442450946.74, 6442450942, 0],
	[-6442450946.74, 6442450943.674, 1],
	[-6442450946.74, 6442450944, -2],
	[-6442450946.74, 6442450945, -1],
	[-6442450946.74, 6442450946.74, -4],
	[-6442450946.74, -1, -2147483647],
	[-6442450946.74, -32.5, -2147483618],
	[-6442450946.74, -3000000000, 852516350],
	[-6442450946.74, -4000000000.23, 1852516350],
	[-6442450946.74, -5000000000, -1442450946],
	[-6442450946.74, -4294967298.479, -2147483648],
	[-6442450946.74, -6442450942, -4],
	[-6442450946.74, -6442450943.674, -1],
	[-6442450946.74, -6442450944, -2],
	[-6442450946.74, -6442450945, 1],
	[-6442450946.74, -6442450946.74, 0],
];

for(var i in n2n) {
	item = n2n[i]
	ok((item[0] ^ item[1]) === item[2], item[0] + ' ^ ' + item[1])
}

// ===================================================
// |
// ===================================================

/* Tests 1782-1829: type conversion (48 tests) */

ok(( void 0  |  void 0           ) === 0,     "undefined | undefined")
ok(( void 0  |  null             ) === 0,     "undefined | null")
ok(( void 0  |  true             ) === 1,     "undefined | boolean")
ok(( void 0  | "string"          ) === 0,     "undefined | string")
ok(( void 0  |  73               ) === 73,    "undefined | number")
ok(( void 0  |  {}               ) === 0,     "undefined | object")
ok(( void 0  |  new Number(34.2) ) === 34,    "undefined | number object")
ok(( null    |  void 0           ) === 0,     "null | undefined")
ok(( null    |  null             ) === 0,     "null | null")
ok(( null    |  true             ) === 1,     "null | boolean")
ok(( null    | "string"          ) === 0,     "null | string")
ok(( null    |  73               ) === 73,     "null | number")
ok(( null    |  {}               ) === 0,     "null | object")
ok(( null    |  new Number(34.2) ) === 34,    "null | number object")
ok(( true    |  void 0           ) === 1,     "boolean | undefined")
ok(( true    |  null             ) === 1,     "boolean | null")
ok(( true    |  true             ) === 1,     "boolean | boolean")
ok(( true    | "string"          ) === 1,     "boolean | string")
ok(( true    |  73               ) === 73,    "boolean | number")
ok(( true    |  {}               ) === 1,     "boolean | object")
ok(( true    |  new Number(34.2) ) === 35,    "boolean | number object")
ok(("string" |  void 0           ) === 0,     "string | undefined")
ok(("string" |  null             ) === 0,     "string | null")
ok(("string" |  true             ) === 1,     "string | boolean")
ok(("string" | "string"          ) === 0,     "string | string")
ok(("string" |  73               ) === 73,    "string | number")
ok(("string" |  {}               ) === 0,     "string | object")
ok(("string" |  new Number(34.2) ) === 34,    "string | number object")
ok(( 73      |  void 0           ) === 73,    "number | undefined")
ok(( 73      |  null             ) === 73,    "number | null")
ok(( 73      |  true             ) === 73,    "number | boolean")
ok(( 73      | "string"          ) === 73,    "number | string")
ok(( 73      |  {}               ) === 73,    "number | object")
ok(( 73      |  new Number(34.2) ) === 107,   "number | number object")
ok(( {}      |  void 0           ) === 0,     "object | undefined")
ok(( {}      |  null             ) === 0,     "object | null")
ok(( {}      |  true             ) === 1,     "object | boolean")
ok(( {}      | "string"          ) === 0,     "object | string")
ok(( {}      |  73               ) === 73,    "object | number")
ok(( {}      |  {}               ) === 0,     "object | object")
ok(( {}      |  new Number(34.2) ) === 34,    "object | number object")
ok(( new Number(34.2) |  void 0  ) === 34,    "number object | undefined")
ok(( new Number(34.2) |  null    ) === 34,    "number object | null")
ok(( new Number(34.2) |  true    ) === 35,    "number object | boolean")
ok(( new Number(34.2) | "string" ) === 34,    "number object | string")
ok(( new Number(34.2) |  73      ) === 107,   "number object | number")
ok(( new Number(34.2) |  {}      ) === 34,    "number object | object")
ok(( new Number(34.2) |  new Number(34.2) ) === 34,
	"number object | number object")


/* Tests 1330-2170 */

n2n = [
	[NaN, NaN, 0],
	[NaN, 0, 0],
	[NaN, 0, 0],
	[NaN, Infinity, 0],
	[NaN, -Infinity, 0],
	[NaN, 1, 1],
	[NaN, 32.5, 32],
	[NaN, 2147483648, -2147483648],
	[NaN, 3000000000, -1294967296],
	[NaN, 4000000000.23, -294967296],
	[NaN, 5000000000, 705032704],
	[NaN, 4294967296, 0],
	[NaN, 4294967298.479, 2],
	[NaN, 6442450942, 2147483646],
	[NaN, 6442450943.674, 2147483647],
	[NaN, 6442450944, -2147483648],
	[NaN, 6442450945, -2147483647],
	[NaN, 6442450946.74, -2147483646],
	[NaN, -1, -1],
	[NaN, -32.5, -32],
	[NaN, -3000000000, 1294967296],
	[NaN, -4000000000.23, 294967296],
	[NaN, -5000000000, -705032704],
	[NaN, -4294967298.479, -2],
	[NaN, -6442450942, -2147483646],
	[NaN, -6442450943.674, -2147483647],
	[NaN, -6442450944, -2147483648],
	[NaN, -6442450945, 2147483647],
	[NaN, -6442450946.74, 2147483646],
	[0, NaN, 0],
	[0, 0, 0],
	[0, 0, 0],
	[0, Infinity, 0],
	[0, -Infinity, 0],
	[0, 1, 1],
	[0, 32.5, 32],
	[0, 2147483648, -2147483648],
	[0, 3000000000, -1294967296],
	[0, 4000000000.23, -294967296],
	[0, 5000000000, 705032704],
	[0, 4294967296, 0],
	[0, 4294967298.479, 2],
	[0, 6442450942, 2147483646],
	[0, 6442450943.674, 2147483647],
	[0, 6442450944, -2147483648],
	[0, 6442450945, -2147483647],
	[0, 6442450946.74, -2147483646],
	[0, -1, -1],
	[0, -32.5, -32],
	[0, -3000000000, 1294967296],
	[0, -4000000000.23, 294967296],
	[0, -5000000000, -705032704],
	[0, -4294967298.479, -2],
	[0, -6442450942, -2147483646],
	[0, -6442450943.674, -2147483647],
	[0, -6442450944, -2147483648],
	[0, -6442450945, 2147483647],
	[0, -6442450946.74, 2147483646],
	[0, NaN, 0],
	[0, 0, 0],
	[0, 0, 0],
	[0, Infinity, 0],
	[0, -Infinity, 0],
	[0, 1, 1],
	[0, 32.5, 32],
	[0, 2147483648, -2147483648],
	[0, 3000000000, -1294967296],
	[0, 4000000000.23, -294967296],
	[0, 5000000000, 705032704],
	[0, 4294967296, 0],
	[0, 4294967298.479, 2],
	[0, 6442450942, 2147483646],
	[0, 6442450943.674, 2147483647],
	[0, 6442450944, -2147483648],
	[0, 6442450945, -2147483647],
	[0, 6442450946.74, -2147483646],
	[0, -1, -1],
	[0, -32.5, -32],
	[0, -3000000000, 1294967296],
	[0, -4000000000.23, 294967296],
	[0, -5000000000, -705032704],
	[0, -4294967298.479, -2],
	[0, -6442450942, -2147483646],
	[0, -6442450943.674, -2147483647],
	[0, -6442450944, -2147483648],
	[0, -6442450945, 2147483647],
	[0, -6442450946.74, 2147483646],
	[Infinity, NaN, 0],
	[Infinity, 0, 0],
	[Infinity, 0, 0],
	[Infinity, Infinity, 0],
	[Infinity, -Infinity, 0],
	[Infinity, 1, 1],
	[Infinity, 32.5, 32],
	[Infinity, 2147483648, -2147483648],
	[Infinity, 3000000000, -1294967296],
	[Infinity, 4000000000.23, -294967296],
	[Infinity, 5000000000, 705032704],
	[Infinity, 4294967296, 0],
	[Infinity, 4294967298.479, 2],
	[Infinity, 6442450942, 2147483646],
	[Infinity, 6442450943.674, 2147483647],
	[Infinity, 6442450944, -2147483648],
	[Infinity, 6442450945, -2147483647],
	[Infinity, 6442450946.74, -2147483646],
	[Infinity, -1, -1],
	[Infinity, -32.5, -32],
	[Infinity, -3000000000, 1294967296],
	[Infinity, -4000000000.23, 294967296],
	[Infinity, -5000000000, -705032704],
	[Infinity, -4294967298.479, -2],
	[Infinity, -6442450942, -2147483646],
	[Infinity, -6442450943.674, -2147483647],
	[Infinity, -6442450944, -2147483648],
	[Infinity, -6442450945, 2147483647],
	[Infinity, -6442450946.74, 2147483646],
	[-Infinity, NaN, 0],
	[-Infinity, 0, 0],
	[-Infinity, 0, 0],
	[-Infinity, Infinity, 0],
	[-Infinity, -Infinity, 0],
	[-Infinity, 1, 1],
	[-Infinity, 32.5, 32],
	[-Infinity, 2147483648, -2147483648],
	[-Infinity, 3000000000, -1294967296],
	[-Infinity, 4000000000.23, -294967296],
	[-Infinity, 5000000000, 705032704],
	[-Infinity, 4294967296, 0],
	[-Infinity, 4294967298.479, 2],
	[-Infinity, 6442450942, 2147483646],
	[-Infinity, 6442450943.674, 2147483647],
	[-Infinity, 6442450944, -2147483648],
	[-Infinity, 6442450945, -2147483647],
	[-Infinity, 6442450946.74, -2147483646],
	[-Infinity, -1, -1],
	[-Infinity, -32.5, -32],
	[-Infinity, -3000000000, 1294967296],
	[-Infinity, -4000000000.23, 294967296],
	[-Infinity, -5000000000, -705032704],
	[-Infinity, -4294967298.479, -2],
	[-Infinity, -6442450942, -2147483646],
	[-Infinity, -6442450943.674, -2147483647],
	[-Infinity, -6442450944, -2147483648],
	[-Infinity, -6442450945, 2147483647],
	[-Infinity, -6442450946.74, 2147483646],
	[1, NaN, 1],
	[1, 0, 1],
	[1, 0, 1],
	[1, Infinity, 1],
	[1, -Infinity, 1],
	[1, 1, 1],
	[1, 32.5, 33],
	[1, 2147483648, -2147483647],
	[1, 3000000000, -1294967295],
	[1, 4000000000.23, -294967295],
	[1, 5000000000, 705032705],
	[1, 4294967296, 1],
	[1, 4294967298.479, 3],
	[1, 6442450942, 2147483647],
	[1, 6442450943.674, 2147483647],
	[1, 6442450944, -2147483647],
	[1, 6442450945, -2147483647],
	[1, 6442450946.74, -2147483645],
	[1, -1, -1],
	[1, -32.5, -31],
	[1, -3000000000, 1294967297],
	[1, -4000000000.23, 294967297],
	[1, -5000000000, -705032703],
	[1, -4294967298.479, -1],
	[1, -6442450942, -2147483645],
	[1, -6442450943.674, -2147483647],
	[1, -6442450944, -2147483647],
	[1, -6442450945, 2147483647],
	[1, -6442450946.74, 2147483647],
	[32.5, NaN, 32],
	[32.5, 0, 32],
	[32.5, 0, 32],
	[32.5, Infinity, 32],
	[32.5, -Infinity, 32],
	[32.5, 1, 33],
	[32.5, 32.5, 32],
	[32.5, 2147483648, -2147483616],
	[32.5, 3000000000, -1294967264],
	[32.5, 4000000000.23, -294967264],
	[32.5, 5000000000, 705032736],
	[32.5, 4294967296, 32],
	[32.5, 4294967298.479, 34],
	[32.5, 6442450942, 2147483646],
	[32.5, 6442450943.674, 2147483647],
	[32.5, 6442450944, -2147483616],
	[32.5, 6442450945, -2147483615],
	[32.5, 6442450946.74, -2147483614],
	[32.5, -1, -1],
	[32.5, -32.5, -32],
	[32.5, -3000000000, 1294967328],
	[32.5, -4000000000.23, 294967328],
	[32.5, -5000000000, -705032672],
	[32.5, -4294967298.479, -2],
	[32.5, -6442450942, -2147483614],
	[32.5, -6442450943.674, -2147483615],
	[32.5, -6442450944, -2147483616],
	[32.5, -6442450945, 2147483647],
	[32.5, -6442450946.74, 2147483646],
	[2147483648, NaN, -2147483648],
	[2147483648, 0, -2147483648],
	[2147483648, 0, -2147483648],
	[2147483648, Infinity, -2147483648],
	[2147483648, -Infinity, -2147483648],
	[2147483648, 1, -2147483647],
	[2147483648, 32.5, -2147483616],
	[2147483648, 2147483648, -2147483648],
	[2147483648, 3000000000, -1294967296],
	[2147483648, 4000000000.23, -294967296],
	[2147483648, 5000000000, -1442450944],
	[2147483648, 4294967296, -2147483648],
	[2147483648, 4294967298.479, -2147483646],
	[2147483648, 6442450942, -2],
	[2147483648, 6442450943.674, -1],
	[2147483648, 6442450944, -2147483648],
	[2147483648, 6442450945, -2147483647],
	[2147483648, 6442450946.74, -2147483646],
	[2147483648, -1, -1],
	[2147483648, -32.5, -32],
	[2147483648, -3000000000, -852516352],
	[2147483648, -4000000000.23, -1852516352],
	[2147483648, -5000000000, -705032704],
	[2147483648, -4294967298.479, -2],
	[2147483648, -6442450942, -2147483646],
	[2147483648, -6442450943.674, -2147483647],
	[2147483648, -6442450944, -2147483648],
	[2147483648, -6442450945, -1],
	[2147483648, -6442450946.74, -2],
	[3000000000, NaN, -1294967296],
	[3000000000, 0, -1294967296],
	[3000000000, 0, -1294967296],
	[3000000000, Infinity, -1294967296],
	[3000000000, -Infinity, -1294967296],
	[3000000000, 1, -1294967295],
	[3000000000, 32.5, -1294967264],
	[3000000000, 2147483648, -1294967296],
	[3000000000, 3000000000, -1294967296],
	[3000000000, 4000000000.23, -17072640],
	[3000000000, 5000000000, -1160380928],
	[3000000000, 4294967296, -1294967296],
	[3000000000, 4294967298.479, -1294967294],
	[3000000000, 6442450942, -2],
	[3000000000, 6442450943.674, -1],
	[3000000000, 6442450944, -1294967296],
	[3000000000, 6442450945, -1294967295],
	[3000000000, 6442450946.74, -1294967294],
	[3000000000, -1, -1],
	[3000000000, -32.5, -32],
	[3000000000, -3000000000, -512],
	[3000000000, -4000000000.23, -1277895168],
	[3000000000, -5000000000, -134586880],
	[3000000000, -4294967298.479, -2],
	[3000000000, -6442450942, -1294967294],
	[3000000000, -6442450943.674, -1294967295],
	[3000000000, -6442450944, -1294967296],
	[3000000000, -6442450945, -1],
	[3000000000, -6442450946.74, -2],
	[4000000000.23, NaN, -294967296],
	[4000000000.23, 0, -294967296],
	[4000000000.23, 0, -294967296],
	[4000000000.23, Infinity, -294967296],
	[4000000000.23, -Infinity, -294967296],
	[4000000000.23, 1, -294967295],
	[4000000000.23, 32.5, -294967264],
	[4000000000.23, 2147483648, -294967296],
	[4000000000.23, 3000000000, -17072640],
	[4000000000.23, 4000000000.23, -294967296],
	[4000000000.23, 5000000000, -294651392],
	[4000000000.23, 4294967296, -294967296],
	[4000000000.23, 4294967298.479, -294967294],
	[4000000000.23, 6442450942, -2],
	[4000000000.23, 6442450943.674, -1],
	[4000000000.23, 6442450944, -294967296],
	[4000000000.23, 6442450945, -294967295],
	[4000000000.23, 6442450946.74, -294967294],
	[4000000000.23, -1, -1],
	[4000000000.23, -32.5, -32],
	[4000000000.23, -3000000000, -277894656],
	[4000000000.23, -4000000000.23, -2048],
	[4000000000.23, -5000000000, -315904],
	[4000000000.23, -4294967298.479, -2],
	[4000000000.23, -6442450942, -294967294],
	[4000000000.23, -6442450943.674, -294967295],
	[4000000000.23, -6442450944, -294967296],
	[4000000000.23, -6442450945, -1],
	[4000000000.23, -6442450946.74, -2],
	[5000000000, NaN, 705032704],
	[5000000000, 0, 705032704],
	[5000000000, 0, 705032704],
	[5000000000, Infinity, 705032704],
	[5000000000, -Infinity, 705032704],
	[5000000000, 1, 705032705],
	[5000000000, 32.5, 705032736],
	[5000000000, 2147483648, -1442450944],
	[5000000000, 3000000000, -1160380928],
	[5000000000, 4000000000.23, -294651392],
	[5000000000, 5000000000, 705032704],
	[5000000000, 4294967296, 705032704],
	[5000000000, 4294967298.479, 705032706],
	[5000000000, 6442450942, 2147483646],
	[5000000000, 6442450943.674, 2147483647],
	[5000000000, 6442450944, -1442450944],
	[5000000000, 6442450945, -1442450943],
	[5000000000, 6442450946.74, -1442450942],
	[5000000000, -1, -1],
	[5000000000, -32.5, -32],
	[5000000000, -3000000000, 1865413120],
	[5000000000, -4000000000.23, 999684608],
	[5000000000, -5000000000, -512],
	[5000000000, -4294967298.479, -2],
	[5000000000, -6442450942, -1442450942],
	[5000000000, -6442450943.674, -1442450943],
	[5000000000, -6442450944, -1442450944],
	[5000000000, -6442450945, 2147483647],
	[5000000000, -6442450946.74, 2147483646],
	[4294967296, NaN, 0],
	[4294967296, 0, 0],
	[4294967296, 0, 0],
	[4294967296, Infinity, 0],
	[4294967296, -Infinity, 0],
	[4294967296, 1, 1],
	[4294967296, 32.5, 32],
	[4294967296, 2147483648, -2147483648],
	[4294967296, 3000000000, -1294967296],
	[4294967296, 4000000000.23, -294967296],
	[4294967296, 5000000000, 705032704],
	[4294967296, 4294967296, 0],
	[4294967296, 4294967298.479, 2],
	[4294967296, 6442450942, 2147483646],
	[4294967296, 6442450943.674, 2147483647],
	[4294967296, 6442450944, -2147483648],
	[4294967296, 6442450945, -2147483647],
	[4294967296, 6442450946.74, -2147483646],
	[4294967296, -1, -1],
	[4294967296, -32.5, -32],
	[4294967296, -3000000000, 1294967296],
	[4294967296, -4000000000.23, 294967296],
	[4294967296, -5000000000, -705032704],
	[4294967296, -4294967298.479, -2],
	[4294967296, -6442450942, -2147483646],
	[4294967296, -6442450943.674, -2147483647],
	[4294967296, -6442450944, -2147483648],
	[4294967296, -6442450945, 2147483647],
	[4294967296, -6442450946.74, 2147483646],
	[4294967298.479, NaN, 2],
	[4294967298.479, 0, 2],
	[4294967298.479, 0, 2],
	[4294967298.479, Infinity, 2],
	[4294967298.479, -Infinity, 2],
	[4294967298.479, 1, 3],
	[4294967298.479, 32.5, 34],
	[4294967298.479, 2147483648, -2147483646],
	[4294967298.479, 3000000000, -1294967294],
	[4294967298.479, 4000000000.23, -294967294],
	[4294967298.479, 5000000000, 705032706],
	[4294967298.479, 4294967296, 2],
	[4294967298.479, 4294967298.479, 2],
	[4294967298.479, 6442450942, 2147483646],
	[4294967298.479, 6442450943.674, 2147483647],
	[4294967298.479, 6442450944, -2147483646],
	[4294967298.479, 6442450945, -2147483645],
	[4294967298.479, 6442450946.74, -2147483646],
	[4294967298.479, -1, -1],
	[4294967298.479, -32.5, -30],
	[4294967298.479, -3000000000, 1294967298],
	[4294967298.479, -4000000000.23, 294967298],
	[4294967298.479, -5000000000, -705032702],
	[4294967298.479, -4294967298.479, -2],
	[4294967298.479, -6442450942, -2147483646],
	[4294967298.479, -6442450943.674, -2147483645],
	[4294967298.479, -6442450944, -2147483646],
	[4294967298.479, -6442450945, 2147483647],
	[4294967298.479, -6442450946.74, 2147483646],
	[6442450942, NaN, 2147483646],
	[6442450942, 0, 2147483646],
	[6442450942, 0, 2147483646],
	[6442450942, Infinity, 2147483646],
	[6442450942, -Infinity, 2147483646],
	[6442450942, 1, 2147483647],
	[6442450942, 32.5, 2147483646],
	[6442450942, 2147483648, -2],
	[6442450942, 3000000000, -2],
	[6442450942, 4000000000.23, -2],
	[6442450942, 5000000000, 2147483646],
	[6442450942, 4294967296, 2147483646],
	[6442450942, 4294967298.479, 2147483646],
	[6442450942, 6442450942, 2147483646],
	[6442450942, 6442450943.674, 2147483647],
	[6442450942, 6442450944, -2],
	[6442450942, 6442450945, -1],
	[6442450942, 6442450946.74, -2],
	[6442450942, -1, -1],
	[6442450942, -32.5, -2],
	[6442450942, -3000000000, 2147483646],
	[6442450942, -4000000000.23, 2147483646],
	[6442450942, -5000000000, -2],
	[6442450942, -4294967298.479, -2],
	[6442450942, -6442450942, -2],
	[6442450942, -6442450943.674, -1],
	[6442450942, -6442450944, -2],
	[6442450942, -6442450945, 2147483647],
	[6442450942, -6442450946.74, 2147483646],
	[6442450943.674, NaN, 2147483647],
	[6442450943.674, 0, 2147483647],
	[6442450943.674, 0, 2147483647],
	[6442450943.674, Infinity, 2147483647],
	[6442450943.674, -Infinity, 2147483647],
	[6442450943.674, 1, 2147483647],
	[6442450943.674, 32.5, 2147483647],
	[6442450943.674, 2147483648, -1],
	[6442450943.674, 3000000000, -1],
	[6442450943.674, 4000000000.23, -1],
	[6442450943.674, 5000000000, 2147483647],
	[6442450943.674, 4294967296, 2147483647],
	[6442450943.674, 4294967298.479, 2147483647],
	[6442450943.674, 6442450942, 2147483647],
	[6442450943.674, 6442450943.674, 2147483647],
	[6442450943.674, 6442450944, -1],
	[6442450943.674, 6442450945, -1],
	[6442450943.674, 6442450946.74, -1],
	[6442450943.674, -1, -1],
	[6442450943.674, -32.5, -1],
	[6442450943.674, -3000000000, 2147483647],
	[6442450943.674, -4000000000.23, 2147483647],
	[6442450943.674, -5000000000, -1],
	[6442450943.674, -4294967298.479, -1],
	[6442450943.674, -6442450942, -1],
	[6442450943.674, -6442450943.674, -1],
	[6442450943.674, -6442450944, -1],
	[6442450943.674, -6442450945, 2147483647],
	[6442450943.674, -6442450946.74, 2147483647],
	[6442450944, NaN, -2147483648],
	[6442450944, 0, -2147483648],
	[6442450944, 0, -2147483648],
	[6442450944, Infinity, -2147483648],
	[6442450944, -Infinity, -2147483648],
	[6442450944, 1, -2147483647],
	[6442450944, 32.5, -2147483616],
	[6442450944, 2147483648, -2147483648],
	[6442450944, 3000000000, -1294967296],
	[6442450944, 4000000000.23, -294967296],
	[6442450944, 5000000000, -1442450944],
	[6442450944, 4294967296, -2147483648],
	[6442450944, 4294967298.479, -2147483646],
	[6442450944, 6442450942, -2],
	[6442450944, 6442450943.674, -1],
	[6442450944, 6442450944, -2147483648],
	[6442450944, 6442450945, -2147483647],
	[6442450944, 6442450946.74, -2147483646],
	[6442450944, -1, -1],
	[6442450944, -32.5, -32],
	[6442450944, -3000000000, -852516352],
	[6442450944, -4000000000.23, -1852516352],
	[6442450944, -5000000000, -705032704],
	[6442450944, -4294967298.479, -2],
	[6442450944, -6442450942, -2147483646],
	[6442450944, -6442450943.674, -2147483647],
	[6442450944, -6442450944, -2147483648],
	[6442450944, -6442450945, -1],
	[6442450944, -6442450946.74, -2],
	[6442450945, NaN, -2147483647],
	[6442450945, 0, -2147483647],
	[6442450945, 0, -2147483647],
	[6442450945, Infinity, -2147483647],
	[6442450945, -Infinity, -2147483647],
	[6442450945, 1, -2147483647],
	[6442450945, 32.5, -2147483615],
	[6442450945, 2147483648, -2147483647],
	[6442450945, 3000000000, -1294967295],
	[6442450945, 4000000000.23, -294967295],
	[6442450945, 5000000000, -1442450943],
	[6442450945, 4294967296, -2147483647],
	[6442450945, 4294967298.479, -2147483645],
	[6442450945, 6442450942, -1],
	[6442450945, 6442450943.674, -1],
	[6442450945, 6442450944, -2147483647],
	[6442450945, 6442450945, -2147483647],
	[6442450945, 6442450946.74, -2147483645],
	[6442450945, -1, -1],
	[6442450945, -32.5, -31],
	[6442450945, -3000000000, -852516351],
	[6442450945, -4000000000.23, -1852516351],
	[6442450945, -5000000000, -705032703],
	[6442450945, -4294967298.479, -1],
	[6442450945, -6442450942, -2147483645],
	[6442450945, -6442450943.674, -2147483647],
	[6442450945, -6442450944, -2147483647],
	[6442450945, -6442450945, -1],
	[6442450945, -6442450946.74, -1],
	[6442450946.74, NaN, -2147483646],
	[6442450946.74, 0, -2147483646],
	[6442450946.74, 0, -2147483646],
	[6442450946.74, Infinity, -2147483646],
	[6442450946.74, -Infinity, -2147483646],
	[6442450946.74, 1, -2147483645],
	[6442450946.74, 32.5, -2147483614],
	[6442450946.74, 2147483648, -2147483646],
	[6442450946.74, 3000000000, -1294967294],
	[6442450946.74, 4000000000.23, -294967294],
	[6442450946.74, 5000000000, -1442450942],
	[6442450946.74, 4294967296, -2147483646],
	[6442450946.74, 4294967298.479, -2147483646],
	[6442450946.74, 6442450942, -2],
	[6442450946.74, 6442450943.674, -1],
	[6442450946.74, 6442450944, -2147483646],
	[6442450946.74, 6442450945, -2147483645],
	[6442450946.74, 6442450946.74, -2147483646],
	[6442450946.74, -1, -1],
	[6442450946.74, -32.5, -30],
	[6442450946.74, -3000000000, -852516350],
	[6442450946.74, -4000000000.23, -1852516350],
	[6442450946.74, -5000000000, -705032702],
	[6442450946.74, -4294967298.479, -2],
	[6442450946.74, -6442450942, -2147483646],
	[6442450946.74, -6442450943.674, -2147483645],
	[6442450946.74, -6442450944, -2147483646],
	[6442450946.74, -6442450945, -1],
	[6442450946.74, -6442450946.74, -2],
	[-1, NaN, -1],
	[-1, 0, -1],
	[-1, 0, -1],
	[-1, Infinity, -1],
	[-1, -Infinity, -1],
	[-1, 1, -1],
	[-1, 32.5, -1],
	[-1, 2147483648, -1],
	[-1, 3000000000, -1],
	[-1, 4000000000.23, -1],
	[-1, 5000000000, -1],
	[-1, 4294967296, -1],
	[-1, 4294967298.479, -1],
	[-1, 6442450942, -1],
	[-1, 6442450943.674, -1],
	[-1, 6442450944, -1],
	[-1, 6442450945, -1],
	[-1, 6442450946.74, -1],
	[-1, -1, -1],
	[-1, -32.5, -1],
	[-1, -3000000000, -1],
	[-1, -4000000000.23, -1],
	[-1, -5000000000, -1],
	[-1, -4294967298.479, -1],
	[-1, -6442450942, -1],
	[-1, -6442450943.674, -1],
	[-1, -6442450944, -1],
	[-1, -6442450945, -1],
	[-1, -6442450946.74, -1],
	[-32.5, NaN, -32],
	[-32.5, 0, -32],
	[-32.5, 0, -32],
	[-32.5, Infinity, -32],
	[-32.5, -Infinity, -32],
	[-32.5, 1, -31],
	[-32.5, 32.5, -32],
	[-32.5, 2147483648, -32],
	[-32.5, 3000000000, -32],
	[-32.5, 4000000000.23, -32],
	[-32.5, 5000000000, -32],
	[-32.5, 4294967296, -32],
	[-32.5, 4294967298.479, -30],
	[-32.5, 6442450942, -2],
	[-32.5, 6442450943.674, -1],
	[-32.5, 6442450944, -32],
	[-32.5, 6442450945, -31],
	[-32.5, 6442450946.74, -30],
	[-32.5, -1, -1],
	[-32.5, -32.5, -32],
	[-32.5, -3000000000, -32],
	[-32.5, -4000000000.23, -32],
	[-32.5, -5000000000, -32],
	[-32.5, -4294967298.479, -2],
	[-32.5, -6442450942, -30],
	[-32.5, -6442450943.674, -31],
	[-32.5, -6442450944, -32],
	[-32.5, -6442450945, -1],
	[-32.5, -6442450946.74, -2],
	[-3000000000, NaN, 1294967296],
	[-3000000000, 0, 1294967296],
	[-3000000000, 0, 1294967296],
	[-3000000000, Infinity, 1294967296],
	[-3000000000, -Infinity, 1294967296],
	[-3000000000, 1, 1294967297],
	[-3000000000, 32.5, 1294967328],
	[-3000000000, 2147483648, -852516352],
	[-3000000000, 3000000000, -512],
	[-3000000000, 4000000000.23, -277894656],
	[-3000000000, 5000000000, 1865413120],
	[-3000000000, 4294967296, 1294967296],
	[-3000000000, 4294967298.479, 1294967298],
	[-3000000000, 6442450942, 2147483646],
	[-3000000000, 6442450943.674, 2147483647],
	[-3000000000, 6442450944, -852516352],
	[-3000000000, 6442450945, -852516351],
	[-3000000000, 6442450946.74, -852516350],
	[-3000000000, -1, -1],
	[-3000000000, -32.5, -32],
	[-3000000000, -3000000000, 1294967296],
	[-3000000000, -4000000000.23, 1572862464],
	[-3000000000, -5000000000, -570446336],
	[-3000000000, -4294967298.479, -2],
	[-3000000000, -6442450942, -852516350],
	[-3000000000, -6442450943.674, -852516351],
	[-3000000000, -6442450944, -852516352],
	[-3000000000, -6442450945, 2147483647],
	[-3000000000, -6442450946.74, 2147483646],
	[-4000000000.23, NaN, 294967296],
	[-4000000000.23, 0, 294967296],
	[-4000000000.23, 0, 294967296],
	[-4000000000.23, Infinity, 294967296],
	[-4000000000.23, -Infinity, 294967296],
	[-4000000000.23, 1, 294967297],
	[-4000000000.23, 32.5, 294967328],
	[-4000000000.23, 2147483648, -1852516352],
	[-4000000000.23, 3000000000, -1277895168],
	[-4000000000.23, 4000000000.23, -2048],
	[-4000000000.23, 5000000000, 999684608],
	[-4000000000.23, 4294967296, 294967296],
	[-4000000000.23, 4294967298.479, 294967298],
	[-4000000000.23, 6442450942, 2147483646],
	[-4000000000.23, 6442450943.674, 2147483647],
	[-4000000000.23, 6442450944, -1852516352],
	[-4000000000.23, 6442450945, -1852516351],
	[-4000000000.23, 6442450946.74, -1852516350],
	[-4000000000.23, -1, -1],
	[-4000000000.23, -32.5, -32],
	[-4000000000.23, -3000000000, 1572862464],
	[-4000000000.23, -4000000000.23, 294967296],
	[-4000000000.23, -5000000000, -704717312],
	[-4000000000.23, -4294967298.479, -2],
	[-4000000000.23, -6442450942, -1852516350],
	[-4000000000.23, -6442450943.674, -1852516351],
	[-4000000000.23, -6442450944, -1852516352],
	[-4000000000.23, -6442450945, 2147483647],
	[-4000000000.23, -6442450946.74, 2147483646],
	[-5000000000, NaN, -705032704],
	[-5000000000, 0, -705032704],
	[-5000000000, 0, -705032704],
	[-5000000000, Infinity, -705032704],
	[-5000000000, -Infinity, -705032704],
	[-5000000000, 1, -705032703],
	[-5000000000, 32.5, -705032672],
	[-5000000000, 2147483648, -705032704],
	[-5000000000, 3000000000, -134586880],
	[-5000000000, 4000000000.23, -315904],
	[-5000000000, 5000000000, -512],
	[-5000000000, 4294967296, -705032704],
	[-5000000000, 4294967298.479, -705032702],
	[-5000000000, 6442450942, -2],
	[-5000000000, 6442450943.674, -1],
	[-5000000000, 6442450944, -705032704],
	[-5000000000, 6442450945, -705032703],
	[-5000000000, 6442450946.74, -705032702],
	[-5000000000, -1, -1],
	[-5000000000, -32.5, -32],
	[-5000000000, -3000000000, -570446336],
	[-5000000000, -4000000000.23, -704717312],
	[-5000000000, -5000000000, -705032704],
	[-5000000000, -4294967298.479, -2],
	[-5000000000, -6442450942, -705032702],
	[-5000000000, -6442450943.674, -705032703],
	[-5000000000, -6442450944, -705032704],
	[-5000000000, -6442450945, -1],
	[-5000000000, -6442450946.74, -2],
	[-4294967298.479, NaN, -2],
	[-4294967298.479, 0, -2],
	[-4294967298.479, 0, -2],
	[-4294967298.479, Infinity, -2],
	[-4294967298.479, -Infinity, -2],
	[-4294967298.479, 1, -1],
	[-4294967298.479, 32.5, -2],
	[-4294967298.479, 2147483648, -2],
	[-4294967298.479, 3000000000, -2],
	[-4294967298.479, 4000000000.23, -2],
	[-4294967298.479, 5000000000, -2],
	[-4294967298.479, 4294967296, -2],
	[-4294967298.479, 4294967298.479, -2],
	[-4294967298.479, 6442450942, -2],
	[-4294967298.479, 6442450943.674, -1],
	[-4294967298.479, 6442450944, -2],
	[-4294967298.479, 6442450945, -1],
	[-4294967298.479, 6442450946.74, -2],
	[-4294967298.479, -1, -1],
	[-4294967298.479, -32.5, -2],
	[-4294967298.479, -3000000000, -2],
	[-4294967298.479, -4000000000.23, -2],
	[-4294967298.479, -5000000000, -2],
	[-4294967298.479, -4294967298.479, -2],
	[-4294967298.479, -6442450942, -2],
	[-4294967298.479, -6442450943.674, -1],
	[-4294967298.479, -6442450944, -2],
	[-4294967298.479, -6442450945, -1],
	[-4294967298.479, -6442450946.74, -2],
	[-6442450942, NaN, -2147483646],
	[-6442450942, 0, -2147483646],
	[-6442450942, 0, -2147483646],
	[-6442450942, Infinity, -2147483646],
	[-6442450942, -Infinity, -2147483646],
	[-6442450942, 1, -2147483645],
	[-6442450942, 32.5, -2147483614],
	[-6442450942, 2147483648, -2147483646],
	[-6442450942, 3000000000, -1294967294],
	[-6442450942, 4000000000.23, -294967294],
	[-6442450942, 5000000000, -1442450942],
	[-6442450942, 4294967296, -2147483646],
	[-6442450942, 4294967298.479, -2147483646],
	[-6442450942, 6442450942, -2],
	[-6442450942, 6442450943.674, -1],
	[-6442450942, 6442450944, -2147483646],
	[-6442450942, 6442450945, -2147483645],
	[-6442450942, 6442450946.74, -2147483646],
	[-6442450942, -1, -1],
	[-6442450942, -32.5, -30],
	[-6442450942, -3000000000, -852516350],
	[-6442450942, -4000000000.23, -1852516350],
	[-6442450942, -5000000000, -705032702],
	[-6442450942, -4294967298.479, -2],
	[-6442450942, -6442450942, -2147483646],
	[-6442450942, -6442450943.674, -2147483645],
	[-6442450942, -6442450944, -2147483646],
	[-6442450942, -6442450945, -1],
	[-6442450942, -6442450946.74, -2],
	[-6442450943.674, NaN, -2147483647],
	[-6442450943.674, 0, -2147483647],
	[-6442450943.674, 0, -2147483647],
	[-6442450943.674, Infinity, -2147483647],
	[-6442450943.674, -Infinity, -2147483647],
	[-6442450943.674, 1, -2147483647],
	[-6442450943.674, 32.5, -2147483615],
	[-6442450943.674, 2147483648, -2147483647],
	[-6442450943.674, 3000000000, -1294967295],
	[-6442450943.674, 4000000000.23, -294967295],
	[-6442450943.674, 5000000000, -1442450943],
	[-6442450943.674, 4294967296, -2147483647],
	[-6442450943.674, 4294967298.479, -2147483645],
	[-6442450943.674, 6442450942, -1],
	[-6442450943.674, 6442450943.674, -1],
	[-6442450943.674, 6442450944, -2147483647],
	[-6442450943.674, 6442450945, -2147483647],
	[-6442450943.674, 6442450946.74, -2147483645],
	[-6442450943.674, -1, -1],
	[-6442450943.674, -32.5, -31],
	[-6442450943.674, -3000000000, -852516351],
	[-6442450943.674, -4000000000.23, -1852516351],
	[-6442450943.674, -5000000000, -705032703],
	[-6442450943.674, -4294967298.479, -1],
	[-6442450943.674, -6442450942, -2147483645],
	[-6442450943.674, -6442450943.674, -2147483647],
	[-6442450943.674, -6442450944, -2147483647],
	[-6442450943.674, -6442450945, -1],
	[-6442450943.674, -6442450946.74, -1],
	[-6442450944, NaN, -2147483648],
	[-6442450944, 0, -2147483648],
	[-6442450944, 0, -2147483648],
	[-6442450944, Infinity, -2147483648],
	[-6442450944, -Infinity, -2147483648],
	[-6442450944, 1, -2147483647],
	[-6442450944, 32.5, -2147483616],
	[-6442450944, 2147483648, -2147483648],
	[-6442450944, 3000000000, -1294967296],
	[-6442450944, 4000000000.23, -294967296],
	[-6442450944, 5000000000, -1442450944],
	[-6442450944, 4294967296, -2147483648],
	[-6442450944, 4294967298.479, -2147483646],
	[-6442450944, 6442450942, -2],
	[-6442450944, 6442450943.674, -1],
	[-6442450944, 6442450944, -2147483648],
	[-6442450944, 6442450945, -2147483647],
	[-6442450944, 6442450946.74, -2147483646],
	[-6442450944, -1, -1],
	[-6442450944, -32.5, -32],
	[-6442450944, -3000000000, -852516352],
	[-6442450944, -4000000000.23, -1852516352],
	[-6442450944, -5000000000, -705032704],
	[-6442450944, -4294967298.479, -2],
	[-6442450944, -6442450942, -2147483646],
	[-6442450944, -6442450943.674, -2147483647],
	[-6442450944, -6442450944, -2147483648],
	[-6442450944, -6442450945, -1],
	[-6442450944, -6442450946.74, -2],
	[-6442450945, NaN, 2147483647],
	[-6442450945, 0, 2147483647],
	[-6442450945, 0, 2147483647],
	[-6442450945, Infinity, 2147483647],
	[-6442450945, -Infinity, 2147483647],
	[-6442450945, 1, 2147483647],
	[-6442450945, 32.5, 2147483647],
	[-6442450945, 2147483648, -1],
	[-6442450945, 3000000000, -1],
	[-6442450945, 4000000000.23, -1],
	[-6442450945, 5000000000, 2147483647],
	[-6442450945, 4294967296, 2147483647],
	[-6442450945, 4294967298.479, 2147483647],
	[-6442450945, 6442450942, 2147483647],
	[-6442450945, 6442450943.674, 2147483647],
	[-6442450945, 6442450944, -1],
	[-6442450945, 6442450945, -1],
	[-6442450945, 6442450946.74, -1],
	[-6442450945, -1, -1],
	[-6442450945, -32.5, -1],
	[-6442450945, -3000000000, 2147483647],
	[-6442450945, -4000000000.23, 2147483647],
	[-6442450945, -5000000000, -1],
	[-6442450945, -4294967298.479, -1],
	[-6442450945, -6442450942, -1],
	[-6442450945, -6442450943.674, -1],
	[-6442450945, -6442450944, -1],
	[-6442450945, -6442450945, 2147483647],
	[-6442450945, -6442450946.74, 2147483647],
	[-6442450946.74, NaN, 2147483646],
	[-6442450946.74, 0, 2147483646],
	[-6442450946.74, 0, 2147483646],
	[-6442450946.74, Infinity, 2147483646],
	[-6442450946.74, -Infinity, 2147483646],
	[-6442450946.74, 1, 2147483647],
	[-6442450946.74, 32.5, 2147483646],
	[-6442450946.74, 2147483648, -2],
	[-6442450946.74, 3000000000, -2],
	[-6442450946.74, 4000000000.23, -2],
	[-6442450946.74, 5000000000, 2147483646],
	[-6442450946.74, 4294967296, 2147483646],
	[-6442450946.74, 4294967298.479, 2147483646],
	[-6442450946.74, 6442450942, 2147483646],
	[-6442450946.74, 6442450943.674, 2147483647],
	[-6442450946.74, 6442450944, -2],
	[-6442450946.74, 6442450945, -1],
	[-6442450946.74, 6442450946.74, -2],
	[-6442450946.74, -1, -1],
	[-6442450946.74, -32.5, -2],
	[-6442450946.74, -3000000000, 2147483646],
	[-6442450946.74, -4000000000.23, 2147483646],
	[-6442450946.74, -5000000000, -2],
	[-6442450946.74, -4294967298.479, -2],
	[-6442450946.74, -6442450942, -2],
	[-6442450946.74, -6442450943.674, -1],
	[-6442450946.74, -6442450944, -2],
	[-6442450946.74, -6442450945, 2147483647],
	[-6442450946.74, -6442450946.74, 2147483646],
];

for(var i in n2n) {
	item = n2n[i]
	ok((item[0] | item[1]) === item[2], item[0] + ' | ' + item[1])
}


--end--
