use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    isa_ok exception { bif(qw/work/) }, 'Bif::Error::UserRepoNotFound';
    bif(qw/init/);

    isa_ok bif(qw/work/), 'Bif::OK::NoWork';
    isa_ok exception { bif(qw/work 999/) }, 'Bif::Error::TopicNotFound';
    isa_ok bif(qw/work 1 --at 01:00/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work/),              'Bif::OK::Working';
    isa_ok exception { bif(qw/work 1/) }, 'Bif::Error::WorkOther';
    isa_ok bif(qw/work 1 --force --at 01:30/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work - --at 01:59/),         'Bif::OK::StopWork';
    isa_ok bif(qw/work/),                      'Bif::OK::NoWork';

    isa_ok bif(qw/work 1 start_comment --at 02:00/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work - stop_comment --at 02:59/),  'Bif::OK::StopWork';

    isa_ok bif(qw/work 1 --at 03:00:00/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work - --at 04:00:00/), 'Bif::OK::StopWork';

    # Using "yesterday"
    isa_ok bif( qw/work 1 --at /, 'yesterday 04:00' ),    'Bif::OK::StartWork';
    isa_ok bif( qw/work - --at /, 'yesterday 04:00:01' ), 'Bif::OK::StopWork';

    my $p1 = bif(qw/ new project todo --message m1 title /);
    isa_ok bif(qw/work todo --at 05:00/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work - --at 05:01/),    'Bif::OK::StopWork';

    # TODO: Have to test at the end because once the first work
    # succeeds we have an entry in bifkv that will always cause an
    # overlap - the repo is then stuffed for normal work use.
    ok exception {
        bif(qw/work 1 --at 03:59:59/);
        bif(qw/work - --at 04:20:00/);
    }, 'Cannot overlap work';
};

done_testing();
