package Net::OpenVPN::Manager::Plugin::CAS;

use namespace::autoclean;
use Moose;
use Net::OpenVPN::Manager::Plugin;

with 'Net::OpenVPN::Manager::Startable';
with 'Net::OpenVPN::Manager::Authenticable';

has 'loginurl' => (
    is => 'ro',
    isa => 'Str',
    required => 1,
);

has 'states' => (
    is => 'ro',
    isa => 'ArrayRef',
    traits => ['Array'],
    default => sub { [] },
    handles => {
        add_state => 'push',
        get_state => 'get',
    }
);

my $TMPL = qq|
<html>
  <head>
    <title>UPPA</title>
    <script>
      window.addEventListener('load', () => {
        document.getElementById("go").addEventListener('click', () => {
            if (window.appEvent) {
              appEvent.postMessage({"type": "CONNECT_SUCCESS"});
            } else {
              window.parent.postMessage({"type": "CONNECT_SUCCESS"});
            }
        });
      });
    </script>
  </head>
  <body>
    <h1>Hello CAS</h1>
    <button id="go">Connect</button>
  </body>
</html>
|;

sub start {
    my $self = shift;
    
    $self->manager->add_dispatcher(sub {
        my $env = shift;

        '/cas/...' => sub {
            '/validate' => sub {
                #$self->get_state(0)->();
                [200, ['Content-type' => 'text/html'], [$TMPL]];
            },
        },
    });
}

sub authenticate {
    my ($self, $client) = @_;

    my $cv = AE::cv;

    $self->log("send pending auth");
    $self->manager->handler->client_pending($client, "WEB_AUTH:internal:https://vpn-otp.univ-pau.fr/cas/validate", 30);

    $self->add_state(sub {
        $cv->send(PLUG_OK);
    });

    # return a pending auth state.
    return [$cv];
}

1;
