package [% this.get_namespace %]::Control::Flow::[% this.get_service %]::[% name %];

use strict;
use warnings;

use Class::Std::Storable;
use base qw(Hyper::Control::Flow);

[% FOREACH attribute = data.attributes %]
my %[% attribute %] :ATTR(:default<()> :get<[% attribute %]> :set<[% attribute %]>);
[% END; FOREACH step = data.step_data; IF step.value.action %]
sub _action_of_[% step.key %] :RESTRICTED {
    my $self = shift;
    [% step.value.action %]
}
[% END; IF step.value.control %]
sub _work_control_of_[% step.key %] :RESTRICTED {
    my $self = shift;

    for my $control ( qw([% FOREACH control = step.value.control; control; END %]) ) {
        $self->get_object($control)->work();
    }

    return;
}
[% END; IF step.value.transitions %]
sub _get_destination_of_[% step.key %] :RESTRICTED {
    my $self = shift;
[% PERL %]
    my @transitions = @{$stash->get('step.value.transitions')};

    print join "\n", map {
        my ($destination, $condition) = splice @transitions, 0, 2;
        defined $condition && length $condition
            ? "    return '$destination' if $condition;"
            : defined $destination
                  ? "    return '$destination';"
                  : "    return;";
        } 0..$#transitions/2;[% END %]
}
[% END; END %]
1;

__END__

=pod

=head1 NAME

[% this.get_namespace %]::Control::Flow::[% this.get_service %]::[% name %] - auto-generated by Hyper Framework

=head1 CAVEATS

Don't touch this module - your changes will be lost on the next generator run.

[%- basename = name;
    basename = basename.replace('_', '') -%]

Edit [% this.get_namespace %]::Control::Flow::[% this.get_service %]::[% basename %] instead.

=head1 COPYING


=head1 AUTHOR

 Generated by Hyper::Generator::Flow

=cut
