package Tsk::Iterator::FileImg;
use 5.012005;
use strict;
use warnings;
use Tsk;
use Tsk::Stack;
use Tsk::Fs::File;
use Tsk::Fs::Dir;
use Tsk::Fs::Info;
use Tsk::Img::Info;
use Tsk::Vs::Info;

use Tsk::Iterator::Fs;
use Tsk::Iterator::FsFile;
#use Tsk::Vs::PartInfo;
use Carp;

our $VERSION = '0.051';
$Carp::Verbose = 1;

=head1 NAME

Tsk::Iterator::FileImg - File iterator for all the files in every partition on the disk image

=head1 DESCRIPTION

This module iterates over all files on the disk image

=cut

sub new {
    my ($class,$image) = @_;
    my $obj = {
        "image"           => undef,
        "tsk_iter_fsfile" => undef,
        "tsk_iter_fs"     => undef,
    };
    $obj->{image} = $image;
    return bless $obj,$class;
}

sub next {
    my ($self) = @_;
    my $next_file = undef;
    if(!defined($self->{tsk_iter_fs})) {
        ## if the filesystem iterator is not there, make one
        ## and get the first offset
        $self->{tsk_iter_fs} = Tsk::Iterator::Fs->new($self->{image});
        my $next_offset = $self->{tsk_iter_fs}->next_offset();
        ## if there's no file there, just return undef
        return undef if !defined($next_offset);
        ## make a file iterator for the filesystem
        $self->{tsk_iter_fsfile} = Tsk::Iterator::FsFile->new($self->{image},$next_offset);
        ## get the next file
        $next_file = $self->{tsk_iter_fsfile}->next;
        return $next_file;
    } else {
        ## there's already a filesystem iterator. get the first file
        $next_file = $self->{tsk_iter_fsfile}->next();
        if(!defined($next_file)) {
            ## the returned file was undefined, get the next filesystem
            my $next_offset = $self->{tsk_iter_fs}->next_offset();
            ## there's no next filesystem, we're done
            return undef if !defined($next_offset);
            ## use the next filesystem
            $self->{tsk_iter_fsfile} = Tsk::Iterator::FsFile->new($self->{image},$next_offset);
            ## get the next file
            $next_file = $self->{tsk_iter_fsfile}->next();
            ## return it
            return $next_file;
        };
        return $next_file;
    };
}

1;
