package Task::Catalyst;

use strict;

our $VERSION = '1.60';

=head1 NAME

Task::Catalyst - All you need to start with Catalyst

=head1 SYNOPSIS

C<perl -MCPAN -e 'install Task::Catalyst'>

=head1 DESCRIPTION

Installs everything you need to write serious Catalyst applications.

L<Catalyst>

L<Catalyst::Log::Log4perl>

L<Catalyst::Plugin::HTML::Widget>

L<Catalyst::Plugin::StackTrace>

L<Catalyst::Plugin::Prototype>

L<Catalyst::Plugin::Singleton>

L<Catalyst::Plugin::DefaultEnd>

L<Catalyst::Plugin::SubRequest>

L<Catalyst::Plugin::Session>

L<Catalyst::Plugin::Session::Store::File>

L<Catalyst::Plugin::Session::State::Cookie>

L<Catalyst::Plugin::Session::State::URI>

L<Catalyst::Plugin::Authentication>

L<Catalyst::Plugin::Authentication::Store::DBIC>

L<Catalyst::Plugin::Authentication::Store::Htpasswd>

L<Catalyst::Plugin::Authorization::ACL>

L<Catalyst::Plugin::Authorization::Roles>

L<Catalyst::Plugin::I18N>

L<Catalyst::Plugin::XMLRPC>

L<Catalyst::Plugin::Pluggable>

L<Catalyst::Model::DBIC::Plain>

L<Catalyst::Model::DBIC>

L<Catalyst::View::TT>

L<Test::WWW::Mechanize::Catalyst>

L<DBD::SQLite>

=head1 AUTHOR

Sebastian Riedel, C<sri@oook.de>

=head1 LICENSE

This library is free software, you can redistribute it and/or modify it under
the same terms as Perl itself.

=cut

1;
