#! /usr/bin/perl
# vim: sw=4 et nowrap

my $GENERATE;

use lib 't/lib';
use Test::NetHack::FOV::Compare 'compare';

BEGIN {
    $GENERATE = (@ARGV == 1 && $ARGV[0] eq '-regenerate') ? 1 : 0;

    if ($GENERATE) {
        require Test::NetHack::FOV::Real;
        Test::NetHack::FOV::Real->import('calculate_fov');
    } else {
        require NetHack::FOV;
        NetHack::FOV->import('calculate_fov');
        require Test::More;
        Test::More->import(tests => 352);
    }
}


my @textmap =
('                                                                                '
,'                                                                                '
,'                                                     ###########                '
,'             ##############                        #############                '
,'             ################      #########     ###        #                   '
,'             ############## ################     #          #####               '
,'                     #  #   #      ###############              #               '
,'              ########  # ##################                    ###             '
,'              #       ### # #      #########                      #             '
,'            ###       # #####          #                          ##            '
,'            #       ### # # #         ##                           #            '
,'          ###       # ##### #         #                    ##############       '
,'          #  ######## # #   #  ########                    ##############       '
,'          #  #      #####   #  #                           ##############       '
,'          ########  # #     ########                       ##############       '
,'          ########### #       ######                                            '
,'          ########            ######                                            '
,'          ########                                                              '
,'          ########                                                              '
,'                                                                                '
,'                                                                                '
);

my @map;

for my $y (0 .. 20) {
    for my $x (0 .. 79) {
        $map[$x][$y] = substr($textmap[$y], $x, 1) eq '#' ? 0 : 1;
    }
}

sub cb {
    my ($x,$y) = @_;

    return $x >= 0 && $y >= 0 && $x < 80 && $y < 21 && !$map[$x][$y];
}

my @floor;
my @maybevis;

for my $y (0 .. 20) {
    TILE:for my $x (0 .. 79) {
        push @floor, [$x,$y] if !$map[$x][$y];

        my $couldsee;
        for ([-1,-1],[-1,0],[-1,1],[0,-1],[0,0],[0,1],[1,-1],[1,0],[1,1]) {
            $couldsee ||= !$map[$_->[0]+$x][$_->[1]+$y];
        }

        push @maybevis, [$x,$y] if $couldsee;
    }
}

for my $xy (@floor) {
    my $mp;
    my $AoA = calculate_fov(@$xy, \&cb);

    if ($GENERATE) {

        for my $i (0 .. (@maybevis - 1)) {
            vec($mp, $i, 1) = $AoA->[$maybevis[$i][0]][$maybevis[$i][1]];
        }
        print $mp;

    } else {

        read DATA, $mp, (@maybevis + 7) / 8;
        my $AoAr = [];
        for my $i (0 .. (@maybevis - 1)) {
            $AoAr->[$maybevis[$i][0]][$maybevis[$i][1]] = vec($mp, $i, 1);
        }

        compare(\@map, $xy->[0], $xy->[1], $AoA, $AoAr);

    }
}

close DATA unless $GENERATE;

__DATA__
              x           `                                                                              x                                                                                                                                                                                     (                                                                                          (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   =         F                                                                         =         g                                                                                 c                8     `     p                                            d     #       @                                                                    `                                                                                          `                                                                              x                                                                                          (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    c                                                                                   `                8     `     p                                             `                                                                               }                                                                                     >                                                                                   [                                                                                                                                                                        ?                                                                                 ?                                                                                 ?                                                                                                                                                                                                                                                                                                                                                                                                                    @                                                    {                                                                                         ?                `                                                                     x   ~                                                                                                  >                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     @                                                                                   `                8     `     p                                             `                                                                                                                                                            x                                                                         |                                                                                 ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ?                                                                                                                                                               ?       @                                                                            @                                                   x   |         x      8                                                                                                 _                                                                                            _                                                                                      @          _                                                                                      @                                                                                              @                                                                                                                                                                                >     p          `                8     `     p                                         <                                                                                     /                                                                               /                                                                               /                                                                             /                                                                             /                                                                            /                                                                             /                                                                          /            @                                                                  /      @    @                                                           ?       /      @                                                                        /      @?   |                                                                       /      @   <                                                                         /      @                                                                         0   ?     ? @                                                                           ?      @                                                                                   x     p         |                                                                                            `                                                                                           0                                                                                                                                                                                                                                                                                                                                                                                                                                                          p                                                                                                                   @                                                                          p          x               8     `     p                                                  /         @       0                                                                /       `                                                                        /      @                                                                  /      @                                                                            /      @                                                                               /      @  @                                                                           /      @  `                                                               |          /      @  p                                                                       /      @  x                                                                       /      @  |                                                                       /      @                                                                       /      @                                                                       /      @                                                                           @                                                                       ?    @                                                                          @    @                                                                     @                                                                              @  |                                                                             `         >    \                                                                                 0         >    |            0               0                                                         >    |   `                                                                              |     x         x                                                                                        |      `                                                                   `          |          (     `                                                   @           p          |    z       $     8     `     p                                                                                                                                                                                                                                |                                                                                  |                                                                                  |                                                                                                                                                                                                                                                                                                                         |                                                                                 |                                                                                |                                                                                      <    p           0     `          8                                                                |                                                                             8     0         |      `                                                                                     |                                                                                 @          <       x            	                                 p   @     @           p          x              8     `     p                                                          p             6                                                                                    @    0                                                                           
         @         `                                                                        @     @                                                                       |                                                                                     0               0                                                                                           p     p                                                     0               <                @                                                                                 |                                                                             0           |        =    Q     0                                                            0           |         >     H                                 p   @     @           p           x                 d     t                                                      
    	              <                                                                                                                                     x                       0                                                                           8     p                                                                                                          |                                                                                                          8                                                                         @                                                                                                                                                                     <                                                                            0           x   ?                                                                              D   7      ?          l     d                               p   @     @           p          `         ?          `     p                                                            0              ?          0     0                                                                 @   @   ?                                                                                                                                          |          8     `     `     0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     p                                                                                                                                                                                                                                                                                                                                                                                                                               x                   8      x                                                        `                           >                                                                                p      8                                                                                                                                                                                                                                                                                                                                                                 =     t                                                                                                                                                                                                                                            0     L    .                >                                p   @     @           p          `              8     x     |                                                                                                                                                                                          >                                                                                    0    `                                                                                                                                                                                                                                                                                                                                                                                                                 x          0     `          0                                                                                              `   `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              `                                                                     @         0   @                                                                                                                                                                                                                                                                                                                                        8                         ?                                                                                                                                                     +          w                                                                         D    |    /              `                                                    0            `        .          }                                                                          
     >          }                            p   @     @           p          `                :          u                                                                                                                                                                        <          >                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @                                                                              p                                                                                    @                                                                                 @                                                                                                                                                                    8                                                                                           `                                                                                      @                                                                                 @                                                                   @              @                                                                                    @                                                                                    @                                                                                    @        ?                                                          L                                                                            0            `   	    ?     >                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         @                                                                              `                                                                     @         0   @                                                                                 @                                                                                 @                                                                                  8                                                                                        `                                                                                                                                                                                                                                                     @                                                                                  @                                                                                  @                                                                                   @                                                                                   @{                                                                                    @;          x                                                                     @                                                       0            `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 8                                                                                       `                                                                                `                                                                                                                                                                                                                                          @                                                                                                 @                                                                                   @       ?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        8                                                                                       `                                                                                `                                                                                            ?                                                                                  ?                                                                                  ?                                                                                                                                                                                                                                    8                   ?                                                                    `           ?                                                                     `           ?                                                                     `           ?                                                                                                                                                                                                                                  @                                                                                                                        