#!perl

use 5.010;
use strict;
use warnings;

use PDL::Core qw(pdl);

use Test2::V0;
use Test2::Tools::PDL;

use Math::LOESS;

$Test2::Tools::PDL::TOLERANCE_REL = 1e-4;

my $one_two = pdl(
    -0.957581198938384,     -2.80954937859791,
    -0.696510845605909,     3.45100038854536,
    0.509259838818042,      0.557854035598286,
    0.0525817201002309,     -2.05064423770094,
    -1.11567547099143,      -1.18366549451658,
    0.511958575232253,      0.334364244817592,
    -2.05706205756846,      -0.121896645718402,
    0.54423804521097,       0.600501641888935,
    0.531074442421607,      0.495400347786053,
    -1.60860176347294,      0.277370954937718,
    0.290464363258084,      0.579894254111128,
    -0.290441177117614,     1.30622601704777,
    -0.482897816720494,     -0.716423394441349,
    0.742412540254878,      -0.91161346344296,
    1.27943556865527,       -0.189153217811851,
    0.592292730243945,      0.952415888511291,
    0.491436176457309,      -0.30568088056691,
    -0.363871357644093,     -0.285424162901343,
    -0.0372094292657342,    -0.923529247741133,
    1.13805430719146,       -1.33122338081553,
    0.55123448290722,       -0.852726057929887,
    1.19687530878469,       0.498781686408254,
    0.320179856418398,      0.21244678210441,
    1.00935803951191,       -0.900989007058962,
    1.13216444413294,       0.0188670824356362,
    0.424169515300288,      -0.19862121711326,
    0.955170163539181,      0.948320512371124,
    0.473848149342783,      -0.699121305560135,
    -0.612853026250685,     0.580431200426044,
    1.27799640925722,       0.806797458367235,
    -1.03855925707748,      1.00866312622584,
    -0.578256568822387,     -0.323244575961333,
    -0.756301997657156,     1.38635211208482,
    0.722419488760045,      -1.2160777034384,
    -0.498279906600592,     0.726247405185,
    -0.260119271608589,     -0.741134528045221,
    -0.184110574491516,     0.307761674659839,
    0.464568227698959,      -0.25253136951752,
    -0.486503680414154,     0.426634057655542,
    -1.30396915580526,      0.0671486396913438,
    1.77117635735777,       0.907249468179712,
    0.432349548721498,      1.41989705188111,
    -0.413389471016361,     2.44202481656431,
    0.0411377482323225,     0.509505377681864,
    -0.282743502058313,     0.179881630718384,
    -1.18808328118875,      0.98265314676344,
    -1.04288590077335,      1.18136543233696,
    -0.398339818481707,     -1.33556478800344,
    -0.502789555455575,     0.484761653956289,
    -0.806445812279308,     1.41207651978306,
    -0.878873945799123,     -0.935197083131863,
    -0.33925477332393439,   0.16449721487453731,
    1.3700178698345999,     -1.4946841727166,
    1.3805047732704381,     0.88508389905048512,
    0.83560940141892148,    0.89623509727336315,
    -1.289541425794579,     0.2332028995229195,
    1.183197522953588,      -0.85793361589157902,
    -1.33423445483833,      -0.9233512315474407,
    0.76914556896670361,    -0.37794794349382183,
    0.059114341211622581,   -1.8706153553475069,
    -0.67786838062170507,   0.038184754648735768,
    0.37530087746353391,    0.96471695952212921,
    0.69505105492152874,    -0.34214020737803602,
    -1.1454631827640021,    -0.99324551114161375,
    -0.13057284978088679,   1.213711380869505,
    0.29124075688915307,    1.106890512068581,
    0.94957063346615733,    0.46367541051066768,
    0.45572327290248621,    0.39878553409592049,
    -0.015849431703916221,  -1.3973725035064171,
    0.7700624622976332,     0.083291190129894818,
    0.53179773252409901,    0.049727349788233177,
    -0.73414037626738005,   -0.96348659055127073,
    0.57356064323574374,    -0.28194211032947131,
    -0.59450289683584279,   0.77026173196827941,
    1.0739830028467161,     -0.61570603602075391,
    -0.084794357704615464,  -0.49163022652120109,
    -1.526968705617602,     -0.19688130817103111,
    0.1656534453607213,     0.19835657518696179,
    0.97492977599052544,    -0.95484796495550817,
    0.58847390467129868,    -0.42688317000127768,
    0.1771186872105201,     -0.91644209647809238,
    -1.8851386926119349,    0.086893856222760746,
    0.45630642515021741,    0.17428542070878469,
    -0.0013077214871275221, -0.00058541929918550742,
    0.28402285608099398,    -0.36567881757010029,
    -0.54886653165173238,   0.8578476816688223,
    0.69909448655308448,    -0.14002628501260239,
    1.332454137144605,      1.6017946938719501,
    0.01241549637061686,    0.24342918633361621,
    1.0773689561938919,     1.8592463357601141,
    0.18590984985424869,    0.033342258305766252,
    0.6130082357970067,     1.068594886375418,
    -0.68330464261374424,   -0.12882583544682871,
    -1.6555248021907429,    0.013086014377651681,
    0.062454455755349927,   0.77304176654886514,
    0.12704646649909671,    0.40865153244567209,
    1.195437623807228,      -0.18555786800092541,
    -1.299714084101439,     0.89967540292281434,
    -0.033647925669371137,  -1.5446015243088369,
    0.65520298400478949,    -0.71393501757996425
);
my $response = pdl(
    14.4535533874191, 6.62282520910778, 13.6714139876233, 14.1975175236874,
    12.8605301149348, 12.5228556826206, 14.2146384581959, 7.9242642010286,
    12.5069380013745, 13.7342047122325, 14.7108554131065, 13.5962229304995,
    5.89001909002711, 13.5586535685782, 14.0431671811957, 13.9313910018427,
    13.2189198447833, 17.0905598230825, 15.1993220372035, 13.2616669404325,
    15.7606359467964, 12.0838552528602, 14.344906985408,  12.6094936116173,
    11.9329594317628, 13.4086741328164, 13.7007653532941, 13.0133656112894,
    15.794998892751,  14.600198458049,  16.2757508936254, 11.5643493993645,
    14.8090225170414, 12.9823612913134, 15.003502495484,  14.7373366435951,
    15.7476765061616, 11.6745084114309, 14.047278212178,  14.6669170934119,
    13.8062403198314, 13.6111487435938, 13.3471486192318, 14.2251519152709,
    14.7188461068404, 14.2172164843947, 14.4180584862351, 14.7196335400403,
    12.799715984732,  13.9330377247579, 15.2646032349699, 14.6603872891079,
    9.73869078623634, 14.4434243169553, 14.4172837909381, 15.1845379738711,
    13.3449384473427, 15.3729427547467, 13.8115544407009, 15.103777322749,
    15.3838341258708, 14.368611819712,  12.525202176137,  14.3250330647389,
    15.2596577477861, 13.0045474727206, 14.515987797507,  15.176981889542,
    14.9241874861469, 13.872430121229,  15.3953655496863, 13.4280761187509,
    15.2034304536162, 14.1866308929129, 13.3058326261246, 14.0746238485616,
    14.1030921763152, 13.49966901054,   11.5846746059002, 14.2648911116312,
    14.88561614061,   13.9672969505607, 16.604679813678,  10.3676055239145,
    14.7434725924834, 16.3088265042892, 14.1086733681544, 13.5909878288487,
    14.6745463058857, 15.2940472804827, 14.6867226502357, 13.6114224063955,
    11.9702698734486, 13.8841573398,    15.0717757159234, 12.5898155750775,
    13.8187450898422, 14.2453171289186, 14.4065299197652, 14.3479407847109
);

my $fitted1 = pdl(
    13.898675, 5.225583,  14.265096, 14.237045, 13.366442, 13.157273,
    14.189032, 7.971348,  13.215581, 12.835208, 13.967757, 14.457845,
    6.039091,  14.722007, 13.758002, 14.654508, 14.243303, 14.733353,
    13.696778, 12.510036, 15.026972, 14.346972, 14.547927, 11.702517,
    14.222303, 14.288345, 13.755227, 13.742749, 14.250887, 14.188543,
    14.388616, 12.552611, 14.100045, 14.552719, 14.514971, 14.556744,
    14.496872, 12.868609, 12.871890, 14.427522, 14.410413, 14.598345,
    13.415146, 14.731999, 14.657565, 14.778805, 13.988940, 13.723749,
    11.932352, 14.908485, 14.457978, 14.616147, 11.100703, 14.254687,
    14.411890, 14.519007, 13.734456, 14.634786, 13.080897, 14.415189,
    14.623631, 13.340049, 12.584224, 14.510466, 14.293842, 13.954341,
    14.281046, 14.643596, 14.492646, 14.497077, 14.497688, 13.732467,
    14.573564, 14.548255, 13.560984, 13.917026, 14.496924, 14.452028,
    11.687567, 13.865395, 13.908958, 14.184016, 14.514209, 10.835782,
    14.203921, 15.273614, 13.702645, 14.383224, 14.506619, 14.707063,
    14.595778, 13.877506, 12.326903, 14.236236, 13.962165, 12.281695,
    14.477443, 13.192765, 13.985441, 13.206705
);

my $fitted2 = pdl(
    12.874079, 10.889912, 14.072472, 14.688408, 13.581655, 13.741506,
    12.966195, 11.778153, 12.623840, 12.391277, 13.915575, 14.549806,
    10.648311, 13.714716, 13.908051, 14.338239, 13.839956, 14.661187,
    14.500423, 12.892713, 14.344422, 14.557473, 14.294094, 14.258892,
    13.410545, 14.058327, 14.340850, 12.675257, 14.839750, 12.706903,
    14.551439, 14.002773, 13.589104, 14.094192, 14.098484, 14.246415,
    14.548803, 11.925623, 14.212327, 14.501013, 14.199258, 14.517379,
    15.151176, 14.202325, 14.044125, 14.549456, 15.030205, 12.957176,
    14.170346, 14.166684, 14.617600, 14.160491, 14.230993, 14.821136,
    14.547624, 14.489024, 12.630700, 14.292239, 14.381246, 14.834949,
    14.480650, 14.747398, 11.611371, 14.519760, 13.997474, 14.591257,
    14.591759, 14.478131, 14.427821, 14.785485, 14.034793, 12.821834,
    13.556879, 14.606041, 13.505266, 12.561710, 14.525273, 14.555914,
    11.728344, 13.296039, 14.621341, 14.570526, 14.015254, 14.451527,
    13.670446, 15.113971, 12.849321, 14.570355, 14.526773, 13.616773,
    14.493652, 14.496696, 11.739043, 14.886699, 12.740301, 12.265455,
    14.504240, 13.584999, 13.370259, 15.378514
);

my $fitted3 = pdl(
    13.853372, 13.076392, 14.410502, 14.317606, 13.530344, 13.909561,
    13.483542, 13.661465, 13.738437, 13.662424, 14.078653, 14.471725,
    13.362504, 14.161261, 14.056621, 14.370400, 13.827138, 14.543779,
    14.563051, 13.263340, 14.405462, 14.511807, 14.391442, 13.655949,
    13.919863, 14.406599, 14.307597, 13.717301, 14.561751, 13.479815,
    14.423533, 13.588048, 13.644027, 14.268385, 14.283955, 14.361030,
    14.528760, 13.151054, 13.826620, 14.570806, 14.120641, 14.538117,
    14.640103, 14.309962, 14.069715, 14.527437, 14.606612, 13.824681,
    13.607361, 14.370144, 14.535820, 14.399329, 14.122194, 14.580712,
    14.478250, 14.541334, 13.593458, 14.346338, 14.016117, 14.580121,
    14.566098, 14.522580, 12.578184, 14.528995, 14.305679, 14.422916,
    14.523434, 14.533691, 14.490958, 14.574831, 14.352653, 13.714577,
    13.911857, 14.540189, 13.522831, 13.495538, 14.528432, 14.462617,
    13.481391, 13.705501, 14.399779, 14.509204, 14.010568, 13.623165,
    14.211318, 14.586042, 13.392231, 14.520972, 14.525897, 13.822231,
    14.577431, 14.267078, 13.423198, 14.589490, 13.573646, 13.655627,
    14.531561, 13.811793, 13.979165, 14.705119
);

my $fitted4 = $fitted3;

my $newdata1 = pdl( -2.5, 0.,  2.5, 0., 0., 0. );
my $newdata2 = pdl( -0.5, 0.5, 0.,  0. );
my $coverage = 0.99;

subtest madeup => sub {
    my $loess = Math::LOESS->new(
        x    => $one_two,    # 2 predictors
        y    => $response,
        span => 0.5
    );
    ok( $loess, 'Math::LOESS->new()' );

    $loess->fit();

    pdl_is( $loess->outputs->fitted_values, $fitted1,
        'outputs->fitted_values' );
    is( $loess->outputs->enp, float( 14.9, tolerance => 1e-1 ),
        'outputs->enp' );
    is(
        $loess->outputs->residual_scale,
        float( 0.9693, tolerance => 1e-4 ),
        'outputs->residual_scale'
    );
};

subtest madeup_modflags => sub {
    my $loess = Math::LOESS->new(
        x    => $one_two,
        y    => $response,
        span => 0.8
    );
    ok( $loess, 'Math::LOESS->new()' );

    #$loess->model->drop_square;
    #$loess->model->parametric;

    $loess->model->drop_square( [ 1, 0 ] );
    $loess->model->parametric( [ 1, 0 ] );

    is( $loess->model->drop_square, [ 1, (0) x 7 ], 'model->drop_square' );
    is( $loess->model->parametric,  [ 1, (0) x 7 ], 'model->parametric' );

    $loess->fit();

    pdl_is( $loess->outputs->fitted_values, $fitted2,
        'outputs->fitted_values' );
    is( $loess->outputs->enp, float( 6.9, tolerance => 1e-1 ), 'outputs->enp' );
    is(
        $loess->outputs->residual_scale,
        float( 1.4804, tolerance => 1e-4 ),
        'outputs->residual_scale'
    );
};

subtest madeup_modfamily => sub {
    my $loess = Math::LOESS->new(
        x      => $one_two,
        y      => $response,
        span   => 0.8,
        family => 'symmetric',
    );
    ok( $loess, 'Math::LOESS->new()' );

    $loess->model->drop_square( [ 1, 0 ] );
    $loess->model->parametric( [ 1, 0 ] );

    is( $loess->model->family, 'symmetric', 'model->family' );

    $loess->fit();

    pdl_is( $loess->outputs->fitted_values, $fitted3,
        'outputs->fitted_values' );
    is( $loess->outputs->enp, float( 6.9, tolerance => 1e-1 ), 'outputs->enp' );
    is(
        $loess->outputs->residual_scale,
        float( 1.0868, tolerance => 1e-4 ),
        'outputs->residual_scale'
    );
};

subtest madeup_modnormalize => sub {
    my $loess = Math::LOESS->new(
        x      => $one_two,
        y      => $response,
        span   => 0.8,
        family => 'symmetric',
    );
    ok( $loess, 'Math::LOESS->new()' );

    $loess->model->drop_square( [ 1, 0 ] );
    $loess->model->parametric( [ 1, 0 ] );

    $loess->model->normalize(0);
    ok( !$loess->model->normalize, 'model->normalize' );

    $loess->fit();

    pdl_is( $loess->outputs->fitted_values, $fitted4,
        'outputs->fitted_values' );
    is( $loess->outputs->enp, float( 6.9, tolerance => 1e-1 ), 'outputs->enp' );
    is(
        $loess->outputs->residual_scale,
        float( 1.0868, tolerance => 1e-4 ),
        'outputs->residual_scale'
    );
};

subtest madeup_pred_nostderr => sub {
    my $loess = Math::LOESS->new(
        x    => $one_two,
        y    => $response,
        span => 0.5
    );
    ok( $loess, 'Math::LOESS->new()' );

    my $pred = $loess->predict( $newdata1, 0 );
    pdl_is( $pred->values, pdl( 8.156780, 14.493587, 14.854142 ),
        'predict(stderr=false)' );
};

subtest madeup_pred_stderr => sub {
    my $loess = Math::LOESS->new(
        x    => $one_two,
        y    => $response,
        span => 0.5
    );
    ok( $loess, 'Math::LOESS->new()' );

    my $pred = $loess->predict( $newdata2, 1 );
    pdl_is( $pred->values, pdl( 14.491811, 14.389726 ),
        'predict(stderr=true)' );
    pdl_is( $pred->stderr, pdl( 0.276746, 0.278009 ), '$pred->stderr' );
    is( $pred->residual_scale, float( 0.969302, tolerance => 1e-6 ),
        '$pred->residual_scale' );
    is( $pred->df, float( 81.2319, tolerance => 1e-4 ), '$pred->df' );
};

subtest madeup_pred_confinv => sub {
    my $loess = Math::LOESS->new(
        x    => $one_two,
        y    => $response,
        span => 0.5
    );
    ok( $loess, 'Math::LOESS->new()' );

    my $pred = $loess->predict( $newdata2, 1 );
    my $ci   = $pred->confidence(0.01);
    pdl_is( $ci->{lower}, pdl( 13.761833, 13.656419 ), 'confinv lower' );
    pdl_is( $ci->{fit},   pdl( 14.491811, 14.389726 ), 'confinv fit' );
    pdl_is( $ci->{upper}, pdl( 15.221789, 15.123034 ), 'confinv upper' );
};

done_testing;
