package Crypt::LE::Challenge::Simple;
use strict;
use warnings;

our $VERSION = '0.06';

=head1 NAME

Crypt::LE::Challenge::Simple - A boilerplate for extending Crypt::LE and Crypt::LE client
application (le.pl) with challenge handlers.

=head1 SYNOPSIS

 use Crypt::LE;
 use Crypt::LE::Challenge::Simple;
 ...
 my $le = Crypt::LE->new();
 my $simple_challenge = Crypt::LE::Challenge::Simple->new();
 ..
 $le->accept_challenge($simple_challenge);

=head1 DESCRIPTION

Crypt::LE provides the functionality necessary to use Let's Encrypt API and generate free SSL certificates for your domains.
This Crypt::LE plugin is an example of how challenge handling can be done by an external module.

B<This module can also be used with the provided Crypt::LE client application - le.pl:>

 le.pl ... --handle-with Crypt::LE::Challenge::Simple --handle-params '{"key1": 1, "key2": 2, "key3": "something"}'

=cut

sub new { bless {}, shift }
 
sub handle_challenge_http {
    my $self = shift;
    my ($challenge, $params) = @_;
    print "Domain: $challenge->{domain} expects '$challenge->{token}.$challenge->{fingerprint}' text in '$challenge->{token}' file\n";
    print "Press <Enter>";
    <STDIN>;
    return 1;
};

sub handle_challenge_tls {
    # Return 0 to indicate an error
    return 0;
}

sub handle_challenge_dns {
    # Critical error will be treated as a failure too
    die "Oh, this challenge is not supported!\n";
}

=head1 AUTHOR

Alexander Yezhov, C<< <leader at cpan.org> >>
Domain Knowledge Ltd.
L<https://do-know.com/>

=cut

1;
