use strict;
use warnings;
use lib 'lib';
use Test::More qw(no_plan);
use aliased 'Javonet::Core::Exception::SdkExceptionHelper' => 'SdkExceptionHelper';
use threads;



# Define the test case
sub test_send_exception_to_app_insights {
    my $e = "Test Exception for Perl SDK";
    my $license_key = "testLicenseKey";

    # Call the send_exception_to_app_insights function on a separate thread
    my $thr = threads->create(sub {
        return SdkExceptionHelper->send_exception_to_app_insights($e, $license_key);
    });

    # Wait for the thread to complete and get its return value
    my $response_code = $thr->join();

    return $response_code;
}

cmp_ok(test_send_exception_to_app_insights(), '==', "200", "Test send_exception_to_app_insights");
