/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.RuntimeContext;
import com.javonet.sdk.internal.AbstractConfigRuntimeFactory;
import com.javonet.sdk.tools.JsonFileResolver;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.RuntimeNameHandler;
import com.javonet.utils.TcpConnectionData;
import java.net.UnknownHostException;

public class ConfigRuntimeFactory
implements AbstractConfigRuntimeFactory {
    private final String path_;

    public ConfigRuntimeFactory(String path) {
        this.path_ = path;
    }

    @Override
    public RuntimeContext clr(String configName) {
        return this.getRuntimeContext(RuntimeName.Clr, configName);
    }

    @Override
    public RuntimeContext jvm(String configName) {
        return this.getRuntimeContext(RuntimeName.Jvm, configName);
    }

    @Override
    public RuntimeContext netcore(String configName) {
        return this.getRuntimeContext(RuntimeName.Netcore, configName);
    }

    @Override
    public RuntimeContext perl(String configName) {
        return this.getRuntimeContext(RuntimeName.Perl, configName);
    }

    @Override
    public RuntimeContext ruby(String configName) {
        return this.getRuntimeContext(RuntimeName.Ruby, configName);
    }

    @Override
    public RuntimeContext nodejs(String configName) {
        return this.getRuntimeContext(RuntimeName.Nodejs, configName);
    }

    @Override
    public RuntimeContext python(String configName) {
        return this.getRuntimeContext(RuntimeName.Python, configName);
    }

    private RuntimeContext getRuntimeContext(RuntimeName runtime, String configName) {
        JsonFileResolver jfr = new JsonFileResolver(this.path_);
        try {
            String licenseKey = jfr.getLicenseKey();
            Transmitter.activateWithCredentials(licenseKey);
        }
        catch (Exception licenseKey) {
            // empty catch block
        }
        String connType = jfr.getChannelType(RuntimeNameHandler.getName(runtime), configName);
        if ("tcp".equals(connType)) {
            TcpConnectionData connData = null;
            try {
                connData = new TcpConnectionData(jfr.getChannelHost(RuntimeNameHandler.getName(runtime), configName), jfr.getChannelPort(RuntimeNameHandler.getName(runtime), configName));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            return RuntimeContext.getInstance(runtime, ConnectionType.TCP, connData);
        }
        if ("inMemory".equals(connType)) {
            return RuntimeContext.getInstance(runtime, ConnectionType.IN_MEMORY, null);
        }
        throw new RuntimeException("Invalid connection type");
    }
}

