/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeDeserializer;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.StringEcodingMode;
import com.javonet.utils.Type;
import java.util.Arrays;

public class CommandDeserializer {
    private final byte[] buffer;
    private int position;
    private Command command;

    public CommandDeserializer(byte[] buffer) {
        this.buffer = buffer;
        this.command = new Command(RuntimeName.values()[buffer[0]], CommandType.values()[buffer[10]], new Object[0]);
        this.position = 11;
    }

    private boolean isAtEnd() {
        return this.position >= this.buffer.length;
    }

    public Command deserialize() {
        while (!this.isAtEnd()) {
            this.command = this.command.addArgToPayload(this.readObject(this.buffer[this.position]));
        }
        return this.command;
    }

    private byte[] copyFrom(byte[] bytes, int elementsToSkip) {
        int size = bytes.length - elementsToSkip;
        byte[] newByteArray = new byte[size];
        System.arraycopy(bytes, elementsToSkip, newByteArray, 0, size);
        return newByteArray;
    }

    private Object readObject(int typeNum) {
        Type type = Type.values()[typeNum];
        switch (type) {
            case COMMAND: {
                return this.readCommand();
            }
            case STRING: {
                return this.readString();
            }
            case INTEGER: {
                return this.readInt();
            }
            case BOOLEAN: {
                return this.readBool();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case BYTE: {
                return this.readByte();
            }
            case CHAR: {
                return Character.valueOf(this.readChar());
            }
            case LONG: {
                return this.readLong();
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case UNSIGNED_LONG_LONG: {
                return this.readUnsignedLongLong();
            }
            case UNSIGNED_INTEGER: {
                return this.readUnsignedInteger();
            }
        }
        throw new RuntimeException("Type not supported: " + typeNum);
    }

    protected Command readCommand() {
        int p = this.position;
        int numberOfElementsInPayload = TypeDeserializer.deserializeInt(Arrays.copyOfRange(this.buffer, p + 1, p + 5));
        byte runtime = this.buffer[p + 5];
        byte type = this.buffer[p + 6];
        this.position += 7;
        Command command = new Command(RuntimeName.values()[runtime], CommandType.values()[type], new Object[0]);
        return this.readCommandRecursively(numberOfElementsInPayload, command);
    }

    private Command readCommandRecursively(int numberOfElementsInPayloadLeft, Command command) {
        if (numberOfElementsInPayloadLeft == 0) {
            return command;
        }
        int p = this.position;
        command = command.addArgToPayload(this.readObject(this.buffer[p]));
        return this.readCommandRecursively(numberOfElementsInPayloadLeft - 1, command);
    }

    private String readString() {
        int p = this.position;
        StringEcodingMode stringEncodingMode = StringEcodingMode.values()[this.buffer[p + 1]];
        int size = TypeDeserializer.deserializeInt(Arrays.copyOfRange(this.buffer, p + 2, p + 6));
        this.position += 6;
        p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeString(stringEncodingMode, Arrays.copyOfRange(this.buffer, p, p + size));
    }

    private int readInt() {
        int size = 4;
        this.position += 2;
        int p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeInt(Arrays.copyOfRange(this.buffer, p, p + size));
    }

    private boolean readBool() {
        int size = 1;
        this.position += 2;
        int p = this.position;
        this.position += size;
        byte byteVal = this.buffer[p];
        return byteVal == 1;
    }

    private float readFloat() {
        int size = 4;
        this.position += 2;
        int p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeFloat(Arrays.copyOfRange(this.buffer, p, p + size));
    }

    private byte readByte() {
        int size = 1;
        this.position += 2;
        int p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeByte(this.buffer[p]);
    }

    private char readChar() {
        int size = 1;
        this.position += 2;
        int p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeChar(this.buffer[p]);
    }

    private long readLong() {
        int size = 8;
        this.position += 2;
        int p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeLongLong(Arrays.copyOfRange(this.buffer, p, p + size));
    }

    private double readDouble() {
        int size = 8;
        this.position += 2;
        int p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeDouble(Arrays.copyOfRange(this.buffer, p, p + size));
    }

    private long readUnsignedLongLong() {
        int size = 8;
        this.position += 2;
        int p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeLongLong(Arrays.copyOfRange(this.buffer, p, p + size));
    }

    private long readUnsignedInteger() {
        int size = 4;
        this.position += 2;
        int p = this.position;
        this.position += size;
        return TypeDeserializer.deserializeInt(Arrays.copyOfRange(this.buffer, p, p + size));
    }
}

