/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.interpreter;

import com.javonet.core.handler.Handler;
import com.javonet.core.protocol.CommandDeserializer;
import com.javonet.core.protocol.CommandSerializer;
import com.javonet.core.receiver.Receiver;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.utils.Command;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import java.util.Optional;

public class Interpreter {
    private final Handler handler = new Handler();
    private CommandSerializer commandSerializer;
    private byte[] response = new byte[0];

    public Command execute(Command command, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress) {
        this.commandSerializer = new CommandSerializer();
        byte[] messageByteArray = this.commandSerializer.encode(command, connectionType, tcpAddress);
        this.response = command.getRuntimeName() == RuntimeName.Jvm ? new Receiver().sendCommand(messageByteArray) : Transmitter.sendCommand(messageByteArray);
        Command responseCommand = new CommandDeserializer(this.response).deserialize();
        return responseCommand;
    }

    public Command process(byte[] byteArray) {
        Command receivedCommand = new CommandDeserializer(byteArray).deserialize();
        return this.handler.handleCommand(receivedCommand);
    }
}

