package Locales::DB::Language::se;

# Auto generated from CLDR

$Locales::DB::Language::se::VERSION = '0.01';

$Locales::DB::Language::se::cldr_version = '1.7.1';

%Locales::DB::Language::se::misc_info = (
    'cldr_formats' => {
        'decimal' => {
            'content' => "\#\,\#\#0\.\#\#\#",
            'draft'   => 'unconfirmed'
        },
        'language' => "Language\:\ \{0\}",
        'locale'   => "\{0\}\ \(\{1\}\)",
        'percent'  => {
            'content' => "\#\,\#\#0 \%",
            'draft'   => 'unconfirmed'
        },
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [ "nb\ sv\ en" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => 'ii',
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => 'jo',
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::se::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'acehgiella',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'afrikánsagiella',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amharic',
    'an'    => 'aragoniagiella',
    'ang'   => "boares\ eaŋgalasgiella",
    'anp'   => 'Angika',
    'apa'   => "apacheš\ giella",
    'ar'    => 'arábagiella',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'ast'   => 'asturiagiella',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azeri',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => "vilges\-ruoššagiella",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'bulgáriagiella',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'bengalgiella',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'bretonagiella',
    'bra'   => 'Braj',
    'bs'    => 'bosniagiella',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'katalánagiella',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "kelttalaš\ gielat",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'marigiella',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'corsicagiella',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'čeahkagiella',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Welsh',
    'da'    => 'dánskkagiella',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'duiskkagiella',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'greikkagiella',
    'elx'   => 'Elamite',
    'en'    => 'eaŋgalsgiella',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'spánskkagiella',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'esttegiella',
    'eu'    => 'Basque',
    'ewo'   => 'Ewondo',
    'fa'    => 'persijagiella',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'suomagiella',
    'fil'   => 'Filipino',
    'fiu'   => "fenno\-ugrálaš\ giella",
    'fj'    => 'Fijian',
    'fo'    => 'fearagiella',
    'fon'   => 'Fon',
    'fr'    => 'fránskkagiella',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'oarjifriisagiella',
    'ga'    => 'iirragiella',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scottish\ Gaelic",
    'gem'   => "germánalaš\ gielat",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galician',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'gujaratagiella',
    'gv'    => 'manksgiella',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'Hebrew',
    'hi'    => 'hindigiella',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'kroátiagiella',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Hungarian',
    'hup'   => 'Hupa',
    'hy'    => 'armeenagiella',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesian',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'islánddagiella',
    'it'    => 'itáliagiella',
    'iu'    => 'Inuktitut',
    'ja'    => 'japánagiella',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Javanese',
    'ka'    => 'Georgian',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korean',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'gárjilgiella',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdish',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'komigiella',
    'kw'    => 'kornagiella',
    'ky'    => 'Kirghiz',
    'la'    => 'láhtengiella',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'luxemburggagiella',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'liettuvagiella',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'látviagiella',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'mokšagiella',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'makedoniagiella',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolian',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malay',
    'mt'    => 'Maltese',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'ersagiella',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => 'girjedárogiella',
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Nepali',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'hollánddagiella',
    'nl_be' => 'Flemish',
    'nn'    => 'ođđadárogiella',
    'no'    => 'dárogiella',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'oksitánagiella',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Punjabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'polskkagiella',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pushto',
    'pt'    => 'portugálagiella',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'retorománagiella',
    'rn'    => 'Rundi',
    'ro'    => 'romániagiella',
    'roa'   => "románalaš\ gielat",
    'rom'   => 'Romany',
    'ru'    => 'ruoššagiella',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'sardigiella',
    'scn'   => 'sisiliagiella',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => 'davvisámegiella',
    'sel'   => 'selkupagiella',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'Shan',
    'si'    => 'Sinhala',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'slovákiagiella',
    'sl'    => 'slovenagiella',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => 'lullisámegiella',
    'smi'   => 'sámegielat',
    'smj'   => 'julevsámegiella',
    'smn'   => 'anárašgiella',
    'sms'   => 'nuortalašgiella',
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'albánagiella',
    'sr'    => 'serbiagiella',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "Southern\ Sotho",
    'su'    => 'Sundanese',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ruoŧagiella',
    'sw'    => 'Swahili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ Language",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'Thai',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turkish',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'udmurtagiella',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'ukrainagiella',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => 'Urdu',
    'uz'    => 'Uzbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnamese',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'vallonagiella',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => 'sorbigiella',
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'kiinnágiella',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::se::name_to_code = (
    'abkhazian'                     => 'ab',
    'acehgiella'                    => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afrikánsagiella'              => 'af',
    'afroasiaticlanguage'           => 'afa',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albánagiella'                 => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'amharic'                       => 'am',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'anárašgiella'                => 'smn',
    'apachešgiella'                => 'apa',
    'aragoniagiella'                => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armeenagiella'                 => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'arábagiella'                  => 'ar',
    'assamese'                      => 'as',
    'asturiagiella'                 => 'ast',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'azeri'                         => 'az',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basa'                          => 'bas',
    'bashkir'                       => 'ba',
    'basque'                        => 'eu',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bengalgiella'                  => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bihari'                        => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'boareseaŋgalasgiella'         => 'ang',
    'bosniagiella'                  => 'bs',
    'braj'                          => 'bra',
    'brazilianportuguese'           => 'pt_br',
    'bretonagiella'                 => 'br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'bulgáriagiella'               => 'bg',
    'buriat'                        => 'bua',
    'burmese'                       => 'my',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cebuano'                       => 'ceb',
    'centralamericanindianlanguage' => 'cai',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'coptic'                        => 'cop',
    'corsicagiella'                 => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'davvisámegiella'              => 'se',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'duiskkagiella'                 => 'de',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'dánskkagiella'                => 'da',
    'dárogiella'                   => 'no',
    'easternfrisian'                => 'frs',
    'eaŋgalsgiella'                => 'en',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'ersagiella'                    => 'myv',
    'esperanto'                     => 'eo',
    'esttegiella'                   => 'et',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'fearagiella'                   => 'fo',
    'fennougrálašgiella'          => 'fiu',
    'fijian'                        => 'fj',
    'filipino'                      => 'fil',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fránskkagiella'               => 'fr',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'galician'                      => 'gl',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'georgian'                      => 'ka',
    'germánalašgielat'            => 'gem',
    'gilbertese'                    => 'gil',
    'girjedárogiella'              => 'nb',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'greikkagiella'                 => 'el',
    'guarani'                       => 'gn',
    'gujaratagiella'                => 'gu',
    "gwich\Ê\¼in"                 => 'gwi',
    'gárjilgiella'                 => 'krl',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hausa'                         => 'ha',
    'hawaiian'                      => 'haw',
    'hebrew'                        => 'he',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindigiella'                   => 'hi',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hollánddagiella'              => 'nl',
    'hungarian'                     => 'hu',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianportuguese'             => 'pt_pt',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'iirragiella'                   => 'ga',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'indonesian'                    => 'id',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'islánddagiella'               => 'is',
    'itáliagiella'                 => 'it',
    'japánagiella'                 => 'ja',
    'javanese'                      => 'jv',
    'jju'                           => 'kaj',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'julevsámegiella'              => 'smj',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kannada'                       => 'kn',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'katalánagiella'               => 'ca',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'kelttalašgielat'              => 'cel',
    'khasi'                         => 'kha',
    'khmer'                         => 'km',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kiinnágiella'                 => 'zh',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kinyarwanda'                   => 'rw',
    'kirghiz'                       => 'ky',
    'klingon'                       => 'tlh',
    'komigiella'                    => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'korean'                        => 'ko',
    'kornagiella'                   => 'kw',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'kpelle'                        => 'kpe',
    'kroátiagiella'                => 'hr',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdish'                       => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'lao'                           => 'lo',
    'lezghian'                      => 'lez',
    'liettuvagiella'                => 'lt',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lullisámegiella'              => 'sma',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxemburggagiella'             => 'lb',
    'láhtengiella'                 => 'la',
    'látviagiella'                 => 'lv',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makedoniagiella'               => 'mk',
    'malagasy'                      => 'mg',
    'malay'                         => 'ms',
    'malayalam'                     => 'ml',
    'maltese'                       => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manksgiella'                   => 'gv',
    'manobolanguage'                => 'mno',
    'maori'                         => 'mi',
    'marathi'                       => 'mr',
    'marigiella'                    => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'mokšagiella'                  => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongolian'                     => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'nahuatl'                       => 'nah',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nepali'                        => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    'nubianlanguage'                => 'nub',
    'nuortalašgiella'              => 'sms',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'oarjifriisagiella'             => 'fy',
    'ojibwa'                        => 'oj',
    'oksitánagiella'               => 'oc',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'ođđadárogiella'             => 'nn',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'persijagiella'                 => 'fa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'polskkagiella'                 => 'pl',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'portugálagiella'              => 'pt',
    'prakritlanguage'               => 'pra',
    'punjabi'                       => 'pa',
    'pushto'                        => 'ps',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'retorománagiella'             => 'rm',
    'romany'                        => 'rom',
    'románalašgielat'             => 'roa',
    'romániagiella'                => 'ro',
    'rundi'                         => 'rn',
    'ruoššagiella'                => 'ru',
    'ruoŧagiella'                  => 'sv',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardigiella'                   => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'scottishgaelic'                => 'gd',
    'selkupagiella'                 => 'sel',
    'semiticlanguage'               => 'sem',
    'serbiagiella'                  => 'sr',
    'serbocroatian'                 => 'sh',
    'serer'                         => 'srr',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinhala'                       => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'sisiliagiella'                 => 'scn',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'slovenagiella'                 => 'sl',
    'slovákiagiella'               => 'sk',
    'sogdien'                       => 'sog',
    'somali'                        => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbigiella'                   => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsotho'                 => 'st',
    'southndebele'                  => 'nr',
    'spánskkagiella'               => 'es',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'sundanese'                     => 'su',
    'suomagiella'                   => 'fi',
    'susu'                          => 'sus',
    'swahili'                       => 'sw',
    'swati'                         => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'sámegielat'                   => 'smi',
    'tagalog'                       => 'tl',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'tajik'                         => 'tg',
    'tamashek'                      => 'tmh',
    'tamil'                         => 'ta',
    'taroko'                        => 'trv',
    'tatar'                         => 'tt',
    'telugu'                        => 'te',
    'tereno'                        => 'ter',
    'tetum'                         => 'tet',
    'thai'                          => 'th',
    'tibetan'                       => 'bo',
    'tigre'                         => 'tig',
    'tigrinya'                      => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turkish'                       => 'tr',
    'turkmen'                       => 'tk',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'udmurtagiella'                 => 'udm',
    'ugaritic'                      => 'uga',
    'ukrainagiella'                 => 'uk',
    'umbundu'                       => 'umb',
    'unknownorinvalidlanguage'      => 'und',
    'uppersorbian'                  => 'hsb',
    'urdu'                          => 'ur',
    'uyghur'                        => 'ug',
    'uzbek'                         => 'uz',
    'vai'                           => 'vai',
    'vallonagiella'                 => 'wa',
    'venda'                         => 've',
    'vietnamese'                    => 'vi',
    'vilgesruoššagiella'          => 'be',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'welsh'                         => 'cy',
    'wolof'                         => 'wo',
    'xhosa'                         => 'xh',
    'yakut'                         => 'sah',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yiddish'                       => 'yi',
    'yoruba'                        => 'yo',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zulu'                          => 'zu',
    'zuni'                          => 'zun',
    'čeahkagiella'                 => 'cs',
);

1;
