package Locales::DB::Language::ru;

# Auto generated from CLDR

$Locales::DB::Language::ru::VERSION = '0.01';

$Locales::DB::Language::ru::cldr_version = '1.7.1';

%Locales::DB::Language::ru::misc_info = (
    'cldr_formats' => {
        'decimal'  => "\#\,\#\#0\.\#\#\#",
        'language' => "Язык\:\ \{0\}",
        'locale'   => {
            'content' => "\{0\}\ \(\{1\}\)",
            'draft'   => 'contributed'
        },
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Регион\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "нет\:н",
        'yesstr' => "да\:д"
    },
);

%Locales::DB::Language::ru::code_to_name = (
    'aa'    => 'афар',
    'ab'    => 'абхазский',
    'ace'   => 'ачехский',
    'ach'   => 'ачоли',
    'ada'   => 'адангме',
    'ady'   => 'адыгейский',
    'ae'    => 'авестийский',
    'af'    => 'африкаанс',
    'afa'   => "афразийский\ язык",
    'afh'   => 'африхили',
    'ain'   => 'айну',
    'ak'    => 'акан',
    'akk'   => 'аккадский',
    'ale'   => 'алеутский',
    'alg'   => "алгонкинские\ языки",
    'alt'   => 'южноалтайский',
    'am'    => 'амхарский',
    'an'    => 'арагонский',
    'ang'   => 'староанглийский',
    'anp'   => 'ангика',
    'apa'   => "апачские\ языки",
    'ar'    => 'арабский',
    'arc'   => 'арамейский',
    'arn'   => 'арауканский',
    'arp'   => 'арапахо',
    'art'   => "искусственный\ язык",
    'arw'   => 'аравакский',
    'as'    => 'ассамский',
    'ast'   => 'астурийский',
    'ath'   => "атапачские\ языки",
    'aus'   => "австралийский\ язык",
    'av'    => 'аварский',
    'awa'   => 'авадхи',
    'ay'    => 'аймара',
    'az'    => 'азербайджанский',
    'ba'    => 'башкирский',
    'bad'   => 'банда',
    'bai'   => "бамилеке\ языки",
    'bal'   => 'белуджский',
    'ban'   => 'балийский',
    'bas'   => 'баса',
    'bat'   => "балтийский\ язык",
    'be'    => 'белорусский',
    'bej'   => 'беджа',
    'bem'   => 'бемба',
    'ber'   => 'берберский',
    'bg'    => 'болгарский',
    'bh'    => 'бихари',
    'bho'   => 'бходжпури',
    'bi'    => 'бислама',
    'bik'   => 'бикольский',
    'bin'   => 'бини',
    'bla'   => 'сиксика',
    'bm'    => 'бамбарийский',
    'bn'    => 'бенгальский',
    'bnt'   => 'банту',
    'bo'    => 'тибетский',
    'br'    => 'бретонский',
    'bra'   => 'брауи',
    'bs'    => 'боснийский',
    'btk'   => 'батакский',
    'bua'   => 'бурятский',
    'bug'   => 'бугийский',
    'byn'   => "билин\ \(блин\)",
    'ca'    => 'каталанский',
    'cad'   => 'каддо',
    'cai'   => "язык\ индейцев\ Центральной\ Америки",
    'car'   => 'кариб',
    'cau'   => "кавказский\ язык",
    'cch'   => 'атсам',
    'ce'    => 'чеченский',
    'ceb'   => 'кебуано',
    'cel'   => "кельтские\ другие",
    'ch'    => 'чаморро',
    'chb'   => 'чибча',
    'chg'   => 'чагатайский',
    'chk'   => 'чукотский',
    'chm'   => "марийский\ \(черемисский\)",
    'chn'   => "чинук\ жаргон",
    'cho'   => 'чоктав',
    'chp'   => 'чипевайян',
    'chr'   => 'чероки',
    'chy'   => 'чейенн',
    'cmc'   => "чамский\ язык",
    'co'    => 'корсиканский',
    'cop'   => 'коптский',
    'cpe'   => "англо\-креольские\ и\ пиджин",
    'cpf'   => "франко\-креольские\ и\ пиджины",
    'cpp'   => "португало\-креольские\ и\ пиджины",
    'cr'    => 'криийский',
    'crh'   => "крымско\-татарский",
    'crp'   => "креольские\ и\ пиджины",
    'cs'    => 'чешский',
    'csb'   => 'кашубианский',
    'cu'    => 'церковнославянский',
    'cus'   => "кушитский\ язык",
    'cv'    => 'чувашский',
    'cy'    => 'валлийский',
    'da'    => 'датский',
    'dak'   => 'дакота',
    'dar'   => 'даргва',
    'day'   => 'даяк',
    'de'    => 'немецкий',
    'de_at' => "австрийский\ немецкий",
    'de_ch' => "Швейцарский\ верхненемецкий",
    'del'   => 'делаварский',
    'den'   => 'славянский',
    'dgr'   => 'догриб',
    'din'   => 'динка',
    'doi'   => 'догри',
    'dra'   => "дравидийский\ язык",
    'dsb'   => 'нижнелужицкий',
    'dua'   => 'дуала',
    'dum'   => 'средненидерландский',
    'dv'    => 'мальдивский',
    'dyu'   => "диула\ \(дьюла\)",
    'dz'    => "дзонг\-кэ",
    'ee'    => 'эве',
    'efi'   => 'эфик',
    'egy'   => 'древнеегипетский',
    'eka'   => 'экаджук',
    'el'    => 'греческий',
    'elx'   => 'эламский',
    'en'    => 'английский',
    'en_au' => "австралийский\ английский",
    'en_ca' => "Канадский\ английский",
    'en_gb' => "британский\ английский",
    'en_us' => "американский\ английский",
    'enm'   => 'среднеанглийский',
    'eo'    => 'эсперанто',
    'es'    => 'испанский',
    'es_es' => "Испанский\ иберийский",
    'et'    => 'эстонский',
    'eu'    => 'баскский',
    'ewo'   => 'эвондо',
    'fa'    => 'персидский',
    'fan'   => 'фанг',
    'fat'   => 'фанти',
    'ff'    => 'фулах',
    'fi'    => 'финский',
    'fil'   => 'филиппинский',
    'fiu'   => "финно\-угорский\ язык",
    'fj'    => 'фиджи',
    'fo'    => 'фарерский',
    'fon'   => 'фон',
    'fr'    => 'французский',
    'fr_ca' => "Канадский\ французский",
    'fr_ch' => "Швейцарский\ французский",
    'frm'   => 'среднефранцузский',
    'fro'   => 'старофранцузский',
    'frr'   => "фризский\ северный",
    'frs'   => "восточный\ фризский",
    'fur'   => 'фриульский',
    'fy'    => 'фризский',
    'ga'    => 'ирландский',
    'gaa'   => 'га',
    'gay'   => 'гайо',
    'gba'   => 'гбая',
    'gd'    => 'гэльский',
    'gem'   => "германский\ язык",
    'gez'   => 'геэз',
    'gil'   => 'гильбертский',
    'gl'    => 'галисийский',
    'gmh'   => 'средневерхненемецкий',
    'gn'    => 'гуарани',
    'goh'   => 'древневерхненемецкий',
    'gon'   => 'гонди',
    'gor'   => 'горонтало',
    'got'   => 'готский',
    'grb'   => 'гребо',
    'grc'   => 'древнегреческий',
    'gsw'   => "Швейцарский\ немецкий",
    'gu'    => 'гуджарати',
    'gv'    => 'мэнский',
    'gwi'   => 'гвичин',
    'ha'    => 'хауса',
    'hai'   => 'хайда',
    'haw'   => 'гавайский',
    'he'    => 'иврит',
    'hi'    => 'хинди',
    'hil'   => 'хилигайнон',
    'him'   => 'химачали',
    'hit'   => 'хеттский',
    'hmn'   => 'хмонг',
    'ho'    => 'хиримоту',
    'hr'    => 'хорватский',
    'hsb'   => 'верхнелужицкий',
    'ht'    => 'гаитянский',
    'hu'    => 'венгерский',
    'hup'   => 'хупа',
    'hy'    => 'армянский',
    'hz'    => 'гереро',
    'ia'    => 'интерлингва',
    'iba'   => 'ибанский',
    'id'    => 'индонезийский',
    'ie'    => 'интерлингве',
    'ig'    => 'игбо',
    'ii'    => 'сычуань',
    'ijo'   => 'иджо',
    'ik'    => 'инупиак',
    'ilo'   => 'илоко',
    'inc'   => "индийский\ язык",
    'ine'   => "индоевропейский\ язык",
    'inh'   => 'ингушский',
    'io'    => 'идо',
    'ira'   => "иранский\ язык",
    'iro'   => "ирокезские\ языки",
    'is'    => 'исландский',
    'it'    => 'итальянский',
    'iu'    => 'инуктитут',
    'ja'    => 'японский',
    'jbo'   => 'ложбан',
    'jpr'   => "еврейско\-персидский",
    'jrb'   => "еврейско\-арабский",
    'jv'    => 'яванский',
    'ka'    => 'грузинский',
    'kaa'   => 'каракалпакский',
    'kab'   => 'кабильский',
    'kac'   => 'качинский',
    'kaj'   => 'каджи',
    'kam'   => 'камба',
    'kar'   => 'каренский',
    'kaw'   => 'кави',
    'kbd'   => 'кабардинский',
    'kcg'   => 'тьяп',
    'kfo'   => 'коро',
    'kg'    => 'конго',
    'kha'   => 'кхаси',
    'khi'   => "койсанский\ язык",
    'kho'   => 'хотанский',
    'ki'    => 'кикуйю',
    'kj'    => 'кунама',
    'kk'    => 'казахский',
    'kl'    => "эскимосский\ \(гренландский\)",
    'km'    => 'кхмерский',
    'kmb'   => 'кимбундийский',
    'kn'    => 'каннада',
    'ko'    => 'корейский',
    'kok'   => 'конкани',
    'kos'   => 'косраенский',
    'kpe'   => 'кпелле',
    'kr'    => 'канури',
    'krc'   => "карачаево\-балкарский",
    'krl'   => 'карельский',
    'kro'   => 'кру',
    'kru'   => 'курух',
    'ks'    => 'кашмири',
    'ku'    => 'курдский',
    'kum'   => 'кумыкский',
    'kut'   => 'кутенаи',
    'kv'    => 'коми',
    'kw'    => 'корнийский',
    'ky'    => 'киргизский',
    'la'    => 'латинский',
    'lad'   => 'ладино',
    'lah'   => 'лахнда',
    'lam'   => 'ламба',
    'lb'    => 'люксембургский',
    'lez'   => 'лезгинский',
    'lg'    => 'ганда',
    'li'    => 'лимбургский',
    'ln'    => 'лингала',
    'lo'    => 'лаосский',
    'lol'   => 'монго',
    'loz'   => 'лози',
    'lt'    => 'литовский',
    'lu'    => "луба\-катанга",
    'lua'   => "луба\-лулуа",
    'lui'   => 'луисеньо',
    'lun'   => 'лунда',
    'luo'   => "луо\ \(Кения\ и\ Танзания\)",
    'lus'   => 'лушай',
    'lv'    => 'латышский',
    'mad'   => 'мадурский',
    'mag'   => 'магахи',
    'mai'   => 'майтхили',
    'mak'   => 'макассарский',
    'man'   => 'мандинго',
    'map'   => 'австронезийский',
    'mas'   => 'масаи',
    'mdf'   => 'мокшанский',
    'mdr'   => 'мандарский',
    'men'   => 'менде',
    'mfe'   => 'Morisyen',
    'mg'    => 'малагасийский',
    'mga'   => 'среднеирландский',
    'mh'    => 'маршалльский',
    'mi'    => 'маори',
    'mic'   => 'микмак',
    'min'   => 'минангкабау',
    'mis'   => "смешанные\ языки",
    'mk'    => 'македонский',
    'mkh'   => "монкхмерский\ язык",
    'ml'    => 'малаялам',
    'mn'    => 'монгольский',
    'mnc'   => 'маньчжурский',
    'mni'   => 'манипурский',
    'mno'   => "манобо\ языки",
    'mo'    => 'молдавский',
    'moh'   => 'мохаук',
    'mos'   => 'моси',
    'mr'    => 'маратхи',
    'ms'    => 'малайский',
    'mt'    => 'мальтийский',
    'mul'   => "несколько\ языков",
    'mun'   => "мунда\ языки",
    'mus'   => 'крик',
    'mwl'   => 'мирандийский',
    'mwr'   => 'марвари',
    'my'    => 'бирманский',
    'myn'   => "майя\ языки",
    'myv'   => 'эрзя',
    'na'    => 'науру',
    'nah'   => 'ацтекский',
    'nai'   => "язык\ индейцев\ Северной\ Америки",
    'nap'   => 'неаполитанский',
    'nb'    => "норвежский\ букмол",
    'nd'    => "ндебели\ \(северный\)",
    'nds'   => 'нижнегерманский',
    'ne'    => 'непальский',
    'new'   => 'неварский',
    'ng'    => 'ндонга',
    'nia'   => 'ниас',
    'nic'   => "нигер\-кордофанский\ язык",
    'niu'   => 'ниуэ',
    'nl'    => 'голландский',
    'nl_be' => "Бельгийский\ фламандский",
    'nn'    => "норвежский\ нюнорск",
    'no'    => 'норвежский',
    'nog'   => 'ногайский',
    'non'   => 'старонорвежский',
    'nqo'   => 'нко',
    'nr'    => "ндебели\ южный",
    'nso'   => "сото\ северный",
    'nub'   => "нубийские\ языки",
    'nv'    => 'навахо',
    'nwc'   => "невари\ \(классический\)",
    'ny'    => 'ньянджа',
    'nym'   => 'ньямвези',
    'nyn'   => 'ньянколе',
    'nyo'   => 'ньоро',
    'nzi'   => 'нзима',
    'oc'    => 'окситанский',
    'oj'    => 'оджибва',
    'om'    => 'оромо',
    'or'    => 'ория',
    'os'    => 'осетинский',
    'osa'   => 'оседжи',
    'ota'   => 'старотурецкий',
    'oto'   => "отомангские\ языки",
    'pa'    => "панджаби\ \(пенджаби\)",
    'paa'   => "папуасский\ язык",
    'pag'   => 'пангасинан',
    'pal'   => 'пехлевийский',
    'pam'   => 'пампанга',
    'pap'   => 'папьяменто',
    'pau'   => 'палау',
    'peo'   => 'староперсидский',
    'phi'   => "филиппинский\ язык",
    'phn'   => 'финикийский',
    'pi'    => 'пали',
    'pl'    => 'польский',
    'pon'   => 'понапе',
    'pra'   => "пракриты\ языки",
    'pro'   => 'старопровансальский',
    'ps'    => "пашто\ \(пушту\)",
    'pt'    => 'португальский',
    'pt_br' => "бразильский\ португальский",
    'pt_pt' => "Португальский\ иберийский",
    'qu'    => 'кечуа',
    'raj'   => 'раджастхани',
    'rap'   => 'рапануи',
    'rar'   => 'раротонганский',
    'rm'    => 'ретороманский',
    'rn'    => 'рунди',
    'ro'    => 'румынский',
    'roa'   => "романский\ язык",
    'rom'   => 'цыганский',
    'ru'    => 'русский',
    'rup'   => 'арумынский',
    'rw'    => 'киньяруанда',
    'sa'    => 'санскрит',
    'sad'   => 'сандаве',
    'sah'   => 'якутский',
    'sai'   => "язык\ индейцев\ Южной\ Америки",
    'sal'   => "салишские\ языки",
    'sam'   => "самаритянский\ арамейский",
    'sas'   => 'сасаки',
    'sat'   => 'сантали',
    'sc'    => 'сардинский',
    'scn'   => 'сицилийский',
    'sco'   => 'шотландский',
    'sd'    => 'синдхи',
    'se'    => "саамский\ \(северный\)",
    'sel'   => 'селькупский',
    'sem'   => "семитский\ язык",
    'sg'    => 'санго',
    'sga'   => 'староирландский',
    'sgn'   => "язык\ глухонемых",
    'sh'    => 'сербскохорватский',
    'shn'   => 'шанский',
    'si'    => 'сингальский',
    'sid'   => 'сидама',
    'sio'   => "сиу\ языки",
    'sit'   => "синотибетский\ язык",
    'sk'    => 'словацкий',
    'sl'    => 'словенский',
    'sla'   => "славянский\ язык",
    'sm'    => 'самоанский',
    'sma'   => "саамский\ \(южный\)",
    'smi'   => "саамские\ языки",
    'smj'   => "луле\-саамский",
    'smn'   => "инари\-саамский",
    'sms'   => "скольт\-саамский",
    'sn'    => 'шона',
    'snk'   => 'сонинке',
    'so'    => 'сомали',
    'sog'   => 'согдийский',
    'son'   => 'cонгаи',
    'sq'    => 'албанский',
    'sr'    => 'сербский',
    'srn'   => "сранан\ тонго",
    'srr'   => 'серер',
    'ss'    => 'свази',
    'ssa'   => "нило\-сахарский\ язык",
    'st'    => "сото\ южный",
    'su'    => 'сунданский',
    'suk'   => 'сукума',
    'sus'   => 'сусу',
    'sux'   => 'шумерский',
    'sv'    => 'шведский',
    'sw'    => 'суахили',
    'syc'   => "классический\ сирийский",
    'syr'   => 'сирийский',
    'ta'    => 'тамильский',
    'tai'   => "тайский\ язык",
    'te'    => 'телугу',
    'tem'   => 'темне',
    'ter'   => 'терено',
    'tet'   => 'тетум',
    'tg'    => 'таджикский',
    'th'    => 'тайский',
    'ti'    => 'тигринья',
    'tig'   => 'тигре',
    'tiv'   => 'тиви',
    'tk'    => 'туркменский',
    'tkl'   => 'токелайский',
    'tl'    => 'тагалог',
    'tlh'   => 'клингонский',
    'tli'   => 'тлингит',
    'tmh'   => 'тамашек',
    'tn'    => 'тсвана',
    'to'    => 'тонга',
    'tog'   => "ньяса\ \(тонга\)",
    'tpi'   => "ток\-писин",
    'tr'    => 'турецкий',
    'trv'   => 'Taroko',
    'ts'    => 'тсонга',
    'tsi'   => 'цимшиан',
    'tt'    => 'татарский',
    'tum'   => 'тумбука',
    'tup'   => 'тупи',
    'tut'   => "алтайский\ язык",
    'tvl'   => 'тувалу',
    'tw'    => 'тви',
    'ty'    => 'таитянский',
    'tyv'   => 'тувинский',
    'udm'   => 'удмуртский',
    'ug'    => 'уйгурский',
    'uga'   => 'угаритский',
    'uk'    => 'украинский',
    'umb'   => 'умбунду',
    'und'   => "неизвестный\ или\ недействительный\ язык",
    'ur'    => 'урду',
    'uz'    => 'узбекский',
    'vai'   => 'ваи',
    've'    => 'венда',
    'vi'    => 'вьетнамский',
    'vo'    => 'волапюк',
    'vot'   => 'водский',
    'wa'    => 'валлонский',
    'wak'   => "вакашские\ языки",
    'wal'   => 'воламо',
    'war'   => 'варай',
    'was'   => 'вашо',
    'wen'   => "лужицкие\ языки",
    'wo'    => 'волоф',
    'xal'   => 'калмыцкий',
    'xh'    => 'ксоза',
    'yao'   => 'яо',
    'yap'   => 'яп',
    'yi'    => 'идиш',
    'yo'    => 'йоруба',
    'ypk'   => "юпикский\ язык",
    'za'    => 'чжуань',
    'zap'   => 'сапотекский',
    'zbl'   => 'блиссимволика',
    'zen'   => 'зенагский',
    'zh'    => 'китайский',
    'znd'   => 'занде',
    'zu'    => 'зулу',
    'zun'   => 'зуньи',
    'zxx'   => "без\ языкового\ содержания",
    'zza'   => 'заза',
);

%Locales::DB::Language::ru::name_to_code = (
    'cонгаи'                                                          => 'son',
    'morisyen'                                                             => 'mfe',
    'taroko'                                                               => 'trv',
    'Бельгийскийфламандский'                         => 'nl_be',
    'Испанскийиберийский'                               => 'es_es',
    'Канадскийанглийский'                               => 'en_ca',
    'Канадскийфранцузский'                             => 'fr_ca',
    'Португальскийиберийский'                       => 'pt_pt',
    'Швейцарскийверхненемецкий'                   => 'de_ch',
    'Швейцарскийнемецкий'                               => 'gsw',
    'Швейцарскийфранцузский'                         => 'fr_ch',
    'абхазский'                                                   => 'ab',
    'авадхи'                                                         => 'awa',
    'аварский'                                                     => 'av',
    'авестийский'                                               => 'ae',
    'австралийскийанглийский'                       => 'en_au',
    'австралийскийязык'                                   => 'aus',
    'австрийскийнемецкий'                               => 'de_at',
    'австронезийский'                                       => 'map',
    'адангме'                                                       => 'ada',
    'адыгейский'                                                 => 'ady',
    'азербайджанский'                                       => 'az',
    'аймара'                                                         => 'ay',
    'айну'                                                             => 'ain',
    'акан'                                                             => 'ak',
    'аккадский'                                                   => 'akk',
    'албанский'                                                   => 'sq',
    'алгонкинскиеязыки'                                   => 'alg',
    'алеутский'                                                   => 'ale',
    'алтайскийязык'                                           => 'tut',
    'американскийанглийский'                         => 'en_us',
    'амхарский'                                                   => 'am',
    'ангика'                                                         => 'anp',
    'английский'                                                 => 'en',
    'англокреольскиеипиджин'                         => 'cpe',
    'апачскиеязыки'                                           => 'apa',
    'арабский'                                                     => 'ar',
    'аравакский'                                                 => 'arw',
    'арагонский'                                                 => 'an',
    'арамейский'                                                 => 'arc',
    'арапахо'                                                       => 'arp',
    'арауканский'                                               => 'arn',
    'армянский'                                                   => 'hy',
    'арумынский'                                                 => 'rup',
    'ассамский'                                                   => 'as',
    'астурийский'                                               => 'ast',
    'атапачскиеязыки'                                       => 'ath',
    'атсам'                                                           => 'cch',
    'афар'                                                             => 'aa',
    'афразийскийязык'                                       => 'afa',
    'африкаанс'                                                   => 'af',
    'африхили'                                                     => 'afh',
    'ацтекский'                                                   => 'nah',
    'ачехский'                                                     => 'ace',
    'ачоли'                                                           => 'ach',
    'балийский'                                                   => 'ban',
    'балтийскийязык'                                         => 'bat',
    'бамбарийский'                                             => 'bm',
    'бамилекеязыки'                                           => 'bai',
    'банда'                                                           => 'bad',
    'банту'                                                           => 'bnt',
    'баса'                                                             => 'bas',
    'баскский'                                                     => 'eu',
    'батакский'                                                   => 'btk',
    'башкирский'                                                 => 'ba',
    'беджа'                                                           => 'bej',
    'безязыковогосодержания'                         => 'zxx',
    'белорусский'                                               => 'be',
    'белуджский'                                                 => 'bal',
    'бемба'                                                           => 'bem',
    'бенгальский'                                               => 'bn',
    'берберский'                                                 => 'ber',
    'бикольский'                                                 => 'bik',
    'билинблин'                                                   => 'byn',
    'бини'                                                             => 'bin',
    'бирманский'                                                 => 'my',
    'бислама'                                                       => 'bi',
    'бихари'                                                         => 'bh',
    'блиссимволика'                                           => 'zbl',
    'болгарский'                                                 => 'bg',
    'боснийский'                                                 => 'bs',
    'бразильскийпортугальский'                     => 'pt_br',
    'брауи'                                                           => 'bra',
    'бретонский'                                                 => 'br',
    'британскийанглийский'                             => 'en_gb',
    'бугийский'                                                   => 'bug',
    'бурятский'                                                   => 'bua',
    'бходжпури'                                                   => 'bho',
    'ваи'                                                               => 'vai',
    'вакашскиеязыки'                                         => 'wak',
    'валлийский'                                                 => 'cy',
    'валлонский'                                                 => 'wa',
    'варай'                                                           => 'war',
    'вашо'                                                             => 'was',
    'венгерский'                                                 => 'hu',
    'венда'                                                           => 've',
    'верхнелужицкий'                                         => 'hsb',
    'водский'                                                       => 'vot',
    'воламо'                                                         => 'wal',
    'волапюк'                                                       => 'vo',
    'волоф'                                                           => 'wo',
    'восточныйфризский'                                   => 'frs',
    'вьетнамский'                                               => 'vi',
    'га'                                                                 => 'gaa',
    'гавайский'                                                   => 'haw',
    'гаитянский'                                                 => 'ht',
    'гайо'                                                             => 'gay',
    'галисийский'                                               => 'gl',
    'ганда'                                                           => 'lg',
    'гбая'                                                             => 'gba',
    'гвичин'                                                         => 'gwi',
    'гереро'                                                         => 'hz',
    'германскийязык'                                         => 'gem',
    'геэз'                                                             => 'gez',
    'гильбертский'                                             => 'gil',
    'голландский'                                               => 'nl',
    'гонди'                                                           => 'gon',
    'горонтало'                                                   => 'gor',
    'готский'                                                       => 'got',
    'гребо'                                                           => 'grb',
    'греческий'                                                   => 'el',
    'грузинский'                                                 => 'ka',
    'гуарани'                                                       => 'gn',
    'гуджарати'                                                   => 'gu',
    'гэльский'                                                     => 'gd',
    'дакота'                                                         => 'dak',
    'даргва'                                                         => 'dar',
    'датский'                                                       => 'da',
    'даяк'                                                             => 'day',
    'делаварский'                                               => 'del',
    'дзонгкэ'                                                       => 'dz',
    'динка'                                                           => 'din',
    'диуладьюла'                                                 => 'dyu',
    'догри'                                                           => 'doi',
    'догриб'                                                         => 'dgr',
    'дравидийскийязык'                                     => 'dra',
    'древневерхненемецкий'                             => 'goh',
    'древнегреческий'                                       => 'grc',
    'древнеегипетский'                                     => 'egy',
    'дуала'                                                           => 'dua',
    'еврейскоарабский'                                     => 'jrb',
    'еврейскоперсидский'                                 => 'jpr',
    'заза'                                                             => 'zza',
    'занде'                                                           => 'znd',
    'зенагский'                                                   => 'zen',
    'зулу'                                                             => 'zu',
    'зуньи'                                                           => 'zun',
    'ибанский'                                                     => 'iba',
    'иврит'                                                           => 'he',
    'игбо'                                                             => 'ig',
    'иджо'                                                             => 'ijo',
    'идиш'                                                             => 'yi',
    'идо'                                                               => 'io',
    'илоко'                                                           => 'ilo',
    'инарисаамский'                                           => 'smn',
    'ингушский'                                                   => 'inh',
    'индийскийязык'                                           => 'inc',
    'индоевропейскийязык'                               => 'ine',
    'индонезийский'                                           => 'id',
    'интерлингва'                                               => 'ia',
    'интерлингве'                                               => 'ie',
    'инуктитут'                                                   => 'iu',
    'инупиак'                                                       => 'ik',
    'иранскийязык'                                             => 'ira',
    'ирландский'                                                 => 'ga',
    'ирокезскиеязыки'                                       => 'iro',
    'искусственныйязык'                                   => 'art',
    'исландский'                                                 => 'is',
    'испанский'                                                   => 'es',
    'итальянский'                                               => 'it',
    'йоруба'                                                         => 'yo',
    'кабардинский'                                             => 'kbd',
    'кабильский'                                                 => 'kab',
    'кави'                                                             => 'kaw',
    'кавказскийязык'                                         => 'cau',
    'каддо'                                                           => 'cad',
    'каджи'                                                           => 'kaj',
    'казахский'                                                   => 'kk',
    'калмыцкий'                                                   => 'xal',
    'камба'                                                           => 'kam',
    'каннада'                                                       => 'kn',
    'канури'                                                         => 'kr',
    'каракалпакский'                                         => 'kaa',
    'карачаевобалкарский'                               => 'krc',
    'карельский'                                                 => 'krl',
    'каренский'                                                   => 'kar',
    'кариб'                                                           => 'car',
    'каталанский'                                               => 'ca',
    'качинский'                                                   => 'kac',
    'кашмири'                                                       => 'ks',
    'кашубианский'                                             => 'csb',
    'кебуано'                                                       => 'ceb',
    'кельтскиедругие'                                       => 'cel',
    'кечуа'                                                           => 'qu',
    'кикуйю'                                                         => 'ki',
    'кимбундийский'                                           => 'kmb',
    'киньяруанда'                                               => 'rw',
    'киргизский'                                                 => 'ky',
    'китайский'                                                   => 'zh',
    'классическийсирийский'                           => 'syc',
    'клингонский'                                               => 'tlh',
    'койсанскийязык'                                         => 'khi',
    'коми'                                                             => 'kv',
    'конго'                                                           => 'kg',
    'конкани'                                                       => 'kok',
    'коптский'                                                     => 'cop',
    'корейский'                                                   => 'ko',
    'корнийский'                                                 => 'kw',
    'коро'                                                             => 'kfo',
    'корсиканский'                                             => 'co',
    'косраенский'                                               => 'kos',
    'кпелле'                                                         => 'kpe',
    'креольскиеипиджины'                                 => 'crp',
    'криийский'                                                   => 'cr',
    'крик'                                                             => 'mus',
    'кру'                                                               => 'kro',
    'крымскотатарский'                                     => 'crh',
    'ксоза'                                                           => 'xh',
    'кумыкский'                                                   => 'kum',
    'кунама'                                                         => 'kj',
    'курдский'                                                     => 'ku',
    'курух'                                                           => 'kru',
    'кутенаи'                                                       => 'kut',
    'кушитскийязык'                                           => 'cus',
    'кхаси'                                                           => 'kha',
    'кхмерский'                                                   => 'km',
    'ладино'                                                         => 'lad',
    'ламба'                                                           => 'lam',
    'лаосский'                                                     => 'lo',
    'латинский'                                                   => 'la',
    'латышский'                                                   => 'lv',
    'лахнда'                                                         => 'lah',
    'лезгинский'                                                 => 'lez',
    'лимбургский'                                               => 'li',
    'лингала'                                                       => 'ln',
    'литовский'                                                   => 'lt',
    'ложбан'                                                         => 'jbo',
    'лози'                                                             => 'loz',
    'лубакатанга'                                               => 'lu',
    'лубалулуа'                                                   => 'lua',
    'лужицкиеязыки'                                           => 'wen',
    'луисеньо'                                                     => 'lui',
    'лулесаамский'                                             => 'smj',
    'лунда'                                                           => 'lun',
    'луоКенияиТанзания'                                   => 'luo',
    'лушай'                                                           => 'lus',
    'люксембургский'                                         => 'lb',
    'магахи'                                                         => 'mag',
    'мадурский'                                                   => 'mad',
    'майтхили'                                                     => 'mai',
    'майяязыки'                                                   => 'myn',
    'макассарский'                                             => 'mak',
    'македонский'                                               => 'mk',
    'малагасийский'                                           => 'mg',
    'малайский'                                                   => 'ms',
    'малаялам'                                                     => 'ml',
    'мальдивский'                                               => 'dv',
    'мальтийский'                                               => 'mt',
    'мандарский'                                                 => 'mdr',
    'мандинго'                                                     => 'man',
    'манипурский'                                               => 'mni',
    'манобоязыки'                                               => 'mno',
    'маньчжурский'                                             => 'mnc',
    'маори'                                                           => 'mi',
    'маратхи'                                                       => 'mr',
    'марвари'                                                       => 'mwr',
    'марийскийчеремисский'                             => 'chm',
    'маршалльский'                                             => 'mh',
    'масаи'                                                           => 'mas',
    'менде'                                                           => 'men',
    'микмак'                                                         => 'mic',
    'минангкабау'                                               => 'min',
    'мирандийский'                                             => 'mwl',
    'мокшанский'                                                 => 'mdf',
    'молдавский'                                                 => 'mo',
    'монго'                                                           => 'lol',
    'монгольский'                                               => 'mn',
    'монкхмерскийязык'                                     => 'mkh',
    'моси'                                                             => 'mos',
    'мохаук'                                                         => 'moh',
    'мундаязыки'                                                 => 'mun',
    'мэнский'                                                       => 'gv',
    'навахо'                                                         => 'nv',
    'науру'                                                           => 'na',
    'ндебелисеверный'                                       => 'nd',
    'ндебелиюжный'                                             => 'nr',
    'ндонга'                                                         => 'ng',
    'неаполитанский'                                         => 'nap',
    'невариклассический'                                 => 'nwc',
    'неварский'                                                   => 'new',
    'неизвестныйилинедействительныйязык' => 'und',
    'немецкий'                                                     => 'de',
    'непальский'                                                 => 'ne',
    'несколькоязыков'                                       => 'mul',
    'нзима'                                                           => 'nzi',
    'ниас'                                                             => 'nia',
    'нигеркордофанскийязык'                           => 'nic',
    'нижнегерманский'                                       => 'nds',
    'нижнелужицкий'                                           => 'dsb',
    'нилосахарскийязык'                                   => 'ssa',
    'ниуэ'                                                             => 'niu',
    'нко'                                                               => 'nqo',
    'ногайский'                                                   => 'nog',
    'норвежский'                                                 => 'no',
    'норвежскийбукмол'                                     => 'nb',
    'норвежскийнюнорск'                                   => 'nn',
    'нубийскиеязыки'                                         => 'nub',
    'ньоро'                                                           => 'nyo',
    'ньямвези'                                                     => 'nym',
    'ньянджа'                                                       => 'ny',
    'ньянколе'                                                     => 'nyn',
    'ньясатонга'                                                 => 'tog',
    'оджибва'                                                       => 'oj',
    'окситанский'                                               => 'oc',
    'ория'                                                             => 'or',
    'оромо'                                                           => 'om',
    'оседжи'                                                         => 'osa',
    'осетинский'                                                 => 'os',
    'отомангскиеязыки'                                     => 'oto',
    'палау'                                                           => 'pau',
    'пали'                                                             => 'pi',
    'пампанга'                                                     => 'pam',
    'пангасинан'                                                 => 'pag',
    'панджабипенджаби'                                     => 'pa',
    'папуасскийязык'                                         => 'paa',
    'папьяменто'                                                 => 'pap',
    'паштопушту'                                                 => 'ps',
    'персидский'                                                 => 'fa',
    'пехлевийский'                                             => 'pal',
    'польский'                                                     => 'pl',
    'понапе'                                                         => 'pon',
    'португалокреольскиеипиджины'               => 'cpp',
    'португальский'                                           => 'pt',
    'пракритыязыки'                                           => 'pra',
    'раджастхани'                                               => 'raj',
    'рапануи'                                                       => 'rap',
    'раротонганский'                                         => 'rar',
    'ретороманский'                                           => 'rm',
    'романскийязык'                                           => 'roa',
    'румынский'                                                   => 'ro',
    'рунди'                                                           => 'rn',
    'русский'                                                       => 'ru',
    'саамскиеязыки'                                           => 'smi',
    'саамскийсеверный'                                     => 'se',
    'саамскийюжный'                                           => 'sma',
    'салишскиеязыки'                                         => 'sal',
    'самаритянскийарамейский'                       => 'sam',
    'самоанский'                                                 => 'sm',
    'санго'                                                           => 'sg',
    'сандаве'                                                       => 'sad',
    'санскрит'                                                     => 'sa',
    'сантали'                                                       => 'sat',
    'сапотекский'                                               => 'zap',
    'сардинский'                                                 => 'sc',
    'сасаки'                                                         => 'sas',
    'свази'                                                           => 'ss',
    'селькупский'                                               => 'sel',
    'семитскийязык'                                           => 'sem',
    'сербский'                                                     => 'sr',
    'сербскохорватский'                                   => 'sh',
    'серер'                                                           => 'srr',
    'сидама'                                                         => 'sid',
    'сиксика'                                                       => 'bla',
    'сингальский'                                               => 'si',
    'синдхи'                                                         => 'sd',
    'синотибетскийязык'                                   => 'sit',
    'сирийский'                                                   => 'syr',
    'сиуязыки'                                                     => 'sio',
    'сицилийский'                                               => 'scn',
    'скольтсаамский'                                         => 'sms',
    'славянский'                                                 => 'den',
    'славянскийязык'                                         => 'sla',
    'словацкий'                                                   => 'sk',
    'словенский'                                                 => 'sl',
    'смешанныеязыки'                                         => 'mis',
    'согдийский'                                                 => 'sog',
    'сомали'                                                         => 'so',
    'сонинке'                                                       => 'snk',
    'сотосеверный'                                             => 'nso',
    'сотоюжный'                                                   => 'st',
    'сранантонго'                                               => 'srn',
    'среднеанглийский'                                     => 'enm',
    'средневерхненемецкий'                             => 'gmh',
    'среднеирландский'                                     => 'mga',
    'средненидерландский'                               => 'dum',
    'среднефранцузский'                                   => 'frm',
    'староанглийский'                                       => 'ang',
    'староирландский'                                       => 'sga',
    'старонорвежский'                                       => 'non',
    'староперсидский'                                       => 'peo',
    'старопровансальский'                               => 'pro',
    'старотурецкий'                                           => 'ota',
    'старофранцузский'                                     => 'fro',
    'суахили'                                                       => 'sw',
    'сукума'                                                         => 'suk',
    'сунданский'                                                 => 'su',
    'сусу'                                                             => 'sus',
    'сычуань'                                                       => 'ii',
    'тагалог'                                                       => 'tl',
    'таджикский'                                                 => 'tg',
    'таитянский'                                                 => 'ty',
    'тайский'                                                       => 'th',
    'тайскийязык'                                               => 'tai',
    'тамашек'                                                       => 'tmh',
    'тамильский'                                                 => 'ta',
    'татарский'                                                   => 'tt',
    'тви'                                                               => 'tw',
    'телугу'                                                         => 'te',
    'темне'                                                           => 'tem',
    'терено'                                                         => 'ter',
    'тетум'                                                           => 'tet',
    'тибетский'                                                   => 'bo',
    'тиви'                                                             => 'tiv',
    'тигре'                                                           => 'tig',
    'тигринья'                                                     => 'ti',
    'тлингит'                                                       => 'tli',
    'токелайский'                                               => 'tkl',
    'токписин'                                                     => 'tpi',
    'тонга'                                                           => 'to',
    'тсвана'                                                         => 'tn',
    'тсонга'                                                         => 'ts',
    'тувалу'                                                         => 'tvl',
    'тувинский'                                                   => 'tyv',
    'тумбука'                                                       => 'tum',
    'тупи'                                                             => 'tup',
    'турецкий'                                                     => 'tr',
    'туркменский'                                               => 'tk',
    'тьяп'                                                             => 'kcg',
    'угаритский'                                                 => 'uga',
    'удмуртский'                                                 => 'udm',
    'узбекский'                                                   => 'uz',
    'уйгурский'                                                   => 'ug',
    'украинский'                                                 => 'uk',
    'умбунду'                                                       => 'umb',
    'урду'                                                             => 'ur',
    'фанг'                                                             => 'fan',
    'фанти'                                                           => 'fat',
    'фарерский'                                                   => 'fo',
    'фиджи'                                                           => 'fj',
    'филиппинский'                                             => 'fil',
    'филиппинскийязык'                                     => 'phi',
    'финикийский'                                               => 'phn',
    'финноугорскийязык'                                   => 'fiu',
    'финский'                                                       => 'fi',
    'фон'                                                               => 'fon',
    'франкокреольскиеипиджины'                     => 'cpf',
    'французский'                                               => 'fr',
    'фризский'                                                     => 'fy',
    'фризскийсеверный'                                     => 'frr',
    'фриульский'                                                 => 'fur',
    'фулах'                                                           => 'ff',
    'хайда'                                                           => 'hai',
    'хауса'                                                           => 'ha',
    'хеттский'                                                     => 'hit',
    'хилигайнон'                                                 => 'hil',
    'химачали'                                                     => 'him',
    'хинди'                                                           => 'hi',
    'хиримоту'                                                     => 'ho',
    'хмонг'                                                           => 'hmn',
    'хорватский'                                                 => 'hr',
    'хотанский'                                                   => 'kho',
    'хупа'                                                             => 'hup',
    'церковнославянский'                                 => 'cu',
    'цимшиан'                                                       => 'tsi',
    'цыганский'                                                   => 'rom',
    'чагатайский'                                               => 'chg',
    'чаморро'                                                       => 'ch',
    'чамскийязык'                                               => 'cmc',
    'чейенн'                                                         => 'chy',
    'чероки'                                                         => 'chr',
    'чеченский'                                                   => 'ce',
    'чешский'                                                       => 'cs',
    'чжуань'                                                         => 'za',
    'чибча'                                                           => 'chb',
    'чинукжаргон'                                               => 'chn',
    'чипевайян'                                                   => 'chp',
    'чоктав'                                                         => 'cho',
    'чувашский'                                                   => 'cv',
    'чукотский'                                                   => 'chk',
    'шанский'                                                       => 'shn',
    'шведский'                                                     => 'sv',
    'шона'                                                             => 'sn',
    'шотландский'                                               => 'sco',
    'шумерский'                                                   => 'sux',
    'эве'                                                               => 'ee',
    'эвондо'                                                         => 'ewo',
    'экаджук'                                                       => 'eka',
    'эламский'                                                     => 'elx',
    'эрзя'                                                             => 'myv',
    'эскимосскийгренландский'                       => 'kl',
    'эсперанто'                                                   => 'eo',
    'эстонский'                                                   => 'et',
    'эфик'                                                             => 'efi',
    'южноалтайский'                                           => 'alt',
    'юпикскийязык'                                             => 'ypk',
    'яванский'                                                     => 'jv',
    'языкглухонемых'                                         => 'sgn',
    'языкиндейцевСевернойАмерики'               => 'nai',
    'языкиндейцевЦентральнойАмерики'         => 'cai',
    'языкиндейцевЮжнойАмерики'                     => 'sai',
    'якутский'                                                     => 'sah',
    'яо'                                                                 => 'yao',
    'яп'                                                                 => 'yap',
    'японский'                                                     => 'ja',
);

1;
