package Catan::Asset::Road;
$Catan::Asset::Road::VERSION = '0.02';
use strict;
use warnings;
use Catan::Resource::Brick;
use Catan::Resource::Lumber;

sub new
{
  my ($class, $path) = @_;
  die "$class new require a path argument"
    unless $path && $path->isa('Catan::Map::Path');

  return bless {
    location => $path,
    code     => 'R',
  }, $class;
}

sub code     { $_[0]->{code} }
sub location { $_[0]->{location} }

sub cost
{
  return [
    Catan::Resource::Brick->new(-1),
    Catan::Resource::Lumber->new(-1),
  ];
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Catan::Asset::Road

=head1 VERSION

version 0.02

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
