#!perl

# Copyright (C) 2006, The Perl Foundation.
# $Id: /mirror/trunk/languages/cardinal/t/00_arithmetic.t 21233 2007-09-12T19:33:22.686325Z paultcochrane  $

use strict;
use warnings;
use lib qw(t . lib ../lib ../../lib ../../../lib);
use Parrot::Test tests => 11;

language_output_is( 'cardinal', <<'CODE', <<'OUT', 'simple addition test' );
puts(1+2)
CODE
3
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'simple subtraction test' );
puts(4-2)
CODE
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'simple division test' );
puts(4/2)
CODE
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'simple multiplication test' );
puts(4*2)
CODE
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'simple modulo test' );
puts(3%2)
CODE
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'compound statement test' );
puts((4*3)%7)
CODE
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'float addition test (sum is a whole number)' );
puts(3.1+6.9)
CODE
OUT
language_output_is( 'cardinal',
    <<'CODE', <<'OUT', 'float addition test (sum is a decimal fraction)' );
puts(3.1+6.7)
CODE
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'float subtraction test' );
puts(4.2-0.2)
CODE
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'float multiplication test' );
puts(4.2*3)
CODE
OUT
language_output_is( 'cardinal', <<'CODE', <<'OUT', 'float division test' );
puts(4.2/2.1)
CODE
OUT

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
