# *** DO NOT EDIT *** generated file *** DO NOT EDIT ***
#
# generated by lib/Net/IDN/UTS46/GenTests.PL from data/IdnaTest.txt
# see repository at http://github.com/cfaerber/Net-IDN-Encode for source files
#
use strict;
use utf8;
use warnings;

BEGIN {
  binmode STDOUT, ':utf8';
  binmode STDERR, ':utf8';
}

use Test::More tests => 5038 + 1;
use Test::NoWarnings;

use Net::IDN::UTS46 (':all');

no warnings 'utf8';

my %p = ("TransitionalProcessing" => "0");

is(eval{uts46_to_unicode("fass.de", %p)},	"fass.de",	"to_unicode\(\'fass\.de\'\)\ \[data\/IdnaTest\.txt\:60\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("faß.de", %p)},	"faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:61\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("faß.de", %p)},	"faß.de",	"to_unicode\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:62\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Faß.de", %p)},	"faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:63\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Faß.de", %p)},	"faß.de",	"to_unicode\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:64\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--fa-hia.de", %p)},	"faß.de",	"to_unicode\(\'xn\-\-fa\-hia\.de\'\)\ \[data\/IdnaTest\.txt\:65\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à\x{05D0}", %p)},	undef,	"to_unicode\(\'à\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:69\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:70\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u0300\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:71\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À\x{05D0}", %p)},	undef,	"to_unicode\(\'À\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:72\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0à.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0à\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:73\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0a\x{0300}.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0a\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:74\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A\x{0300}.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0A\\u0300\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:75\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0À.\x{05D0}", %p)},	"0à.\x{05D0}",	"to_unicode\(\'0À\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:76\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0-sfa.xn--4db", %p)},	"0à.\x{05D0}",	"to_unicode\(\'xn\-\-0\-sfa\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:77\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'à\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:78\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'a\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:79\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'A\\u0300\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:80\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}\x{0308}", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'À\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:81\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca.xn--ssa73l", %p)},	"à.\x{05D0}\x{0308}",	"to_unicode\(\'xn\-\-0ca\.xn\-\-ssa73l\'\)\ \[data\/IdnaTest\.txt\:82\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'à\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:83\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:84\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u0300\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:85\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_unicode\(\'À\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:86\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}.\x{05D0}", %p)},	undef,	"to_unicode\(\'\\u0308\.\\u05D0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:87\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'à\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:88\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'a\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:89\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'A\\u0300\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:90\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À.\x{05D0}0\x{0660}", %p)},	undef,	"to_unicode\(\'À\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:91\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("àˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:92\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}ˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'a\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:93\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}ˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'A\\u0300ˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:94\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Àˇ.\x{05D0}", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'Àˇ\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:95\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca88g.xn--4db", %p)},	"àˇ.\x{05D0}",	"to_unicode\(\'xn\-\-0ca88g\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:96\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("à\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'à\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:97\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0300}\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'a\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:98\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0300}\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'A\\u0300\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:99\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("À\x{0308}.\x{05D0}", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'À\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0ca81i.xn--4db", %p)},	"à\x{0308}.\x{05D0}",	"to_unicode\(\'xn\-\-0ca81i\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200C}b", %p)},	undef,	"to_unicode\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200C}b", %p)},	undef,	"to_unicode\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}B", %p)},	undef,	"to_unicode\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}B", %p)},	undef,	"to_unicode\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}b", %p)},	undef,	"to_unicode\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200C}b", %p)},	undef,	"to_unicode\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ab", %p)},	"ab",	"to_unicode\(\'ab\'\)\ \[data\/IdnaTest\.txt\:111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}B", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}B", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200C}b", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf", %p)},	"a\x{094D}b",	"to_unicode\(\'xn\-\-ab\-fsf\'\)\ \[data\/IdnaTest\.txt\:118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}b", %p)},	"a\x{094D}b",	"to_unicode\(\'a\\u094Db\'\)\ \[data\/IdnaTest\.txt\:119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}B", %p)},	"a\x{094D}b",	"to_unicode\(\'A\\u094DB\'\)\ \[data\/IdnaTest\.txt\:120\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}b", %p)},	"a\x{094D}b",	"to_unicode\(\'A\\u094Db\'\)\ \[data\/IdnaTest\.txt\:121\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf604u", %p)},	"a\x{094D}\x{200C}b",	"to_unicode\(\'xn\-\-ab\-fsf604u\'\)\ \[data\/IdnaTest\.txt\:122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:129\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:130\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:131\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:132\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:133\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200D}b", %p)},	undef,	"to_unicode\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{200D}b", %p)},	undef,	"to_unicode\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}B", %p)},	undef,	"to_unicode\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}B", %p)},	undef,	"to_unicode\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}b", %p)},	undef,	"to_unicode\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{200D}b", %p)},	undef,	"to_unicode\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:139\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:140\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:141\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}B", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}B", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{094D}\x{200D}b", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ab-fsf014u", %p)},	"a\x{094D}\x{200D}b",	"to_unicode\(\'xn\-\-ab\-fsf014u\'\)\ \[data\/IdnaTest\.txt\:146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:149\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:150\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_unicode\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("¡", %p)},	"¡",	"to_unicode\(\'¡\'\)\ \[data\/IdnaTest\.txt\:164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--7a", %p)},	"¡",	"to_unicode\(\'xn\-\-7a\'\)\ \[data\/IdnaTest\.txt\:165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。", %p)},	undef,	"to_unicode\(\'。\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:166\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890ä1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:167\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890a\x{0308}1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890a\\u03081234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:168\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890A\x{0308}1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890A\\u03081234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:169\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1234567890Ä1234567890123456789012345678901234567890123456", %p)},	"1234567890ä1234567890123456789012345678901234567890123456",	"to_unicode\(\'1234567890Ä1234567890123456789012345678901234567890123456\'\)\ \[data\/IdnaTest\.txt\:170\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.eXample.cOm", %p)},	"www.example.com",	"to_unicode\(\'www\.eXample\.cOm\'\)\ \[data\/IdnaTest\.txt\:171\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Bücher.de", %p)},	"bücher.de",	"to_unicode\(\'Bücher\.de\'\)\ \[data\/IdnaTest\.txt\:172\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Bu\x{0308}cher.de", %p)},	"bücher.de",	"to_unicode\(\'Bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:173\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("bu\x{0308}cher.de", %p)},	"bücher.de",	"to_unicode\(\'bu\\u0308cher\.de\'\)\ \[data\/IdnaTest\.txt\:174\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("bücher.de", %p)},	"bücher.de",	"to_unicode\(\'bücher\.de\'\)\ \[data\/IdnaTest\.txt\:175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("BÜCHER.DE", %p)},	"bücher.de",	"to_unicode\(\'BÜCHER\.DE\'\)\ \[data\/IdnaTest\.txt\:176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("BU\x{0308}CHER.DE", %p)},	"bücher.de",	"to_unicode\(\'BU\\u0308CHER\.DE\'\)\ \[data\/IdnaTest\.txt\:177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bcher-kva.de", %p)},	"bücher.de",	"to_unicode\(\'xn\-\-bcher\-kva\.de\'\)\ \[data\/IdnaTest\.txt\:178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ÖBB", %p)},	"öbb",	"to_unicode\(\'ÖBB\'\)\ \[data\/IdnaTest\.txt\:179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("O\x{0308}BB", %p)},	"öbb",	"to_unicode\(\'O\\u0308BB\'\)\ \[data\/IdnaTest\.txt\:180\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("o\x{0308}bb", %p)},	"öbb",	"to_unicode\(\'o\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:181\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("öbb", %p)},	"öbb",	"to_unicode\(\'öbb\'\)\ \[data\/IdnaTest\.txt\:182\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Öbb", %p)},	"öbb",	"to_unicode\(\'Öbb\'\)\ \[data\/IdnaTest\.txt\:183\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("O\x{0308}bb", %p)},	"öbb",	"to_unicode\(\'O\\u0308bb\'\)\ \[data\/IdnaTest\.txt\:184\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bb-eka", %p)},	"öbb",	"to_unicode\(\'xn\-\-bb\-eka\'\)\ \[data\/IdnaTest\.txt\:185\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:186\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:187\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:188\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΟ\x{0301}ΛΟΣ.COM", %p)},	"βόλοσ.com",	"to_unicode\(\'ΒΟ\\u0301ΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΌΛΟΣ.COM", %p)},	"βόλοσ.com",	"to_unicode\(\'ΒΌΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'Βο\\u0301λοσ\.com\'\)\ \[data\/IdnaTest\.txt\:194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλοσ.com", %p)},	"βόλοσ.com",	"to_unicode\(\'Βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmq6b.com", %p)},	"βόλοσ.com",	"to_unicode\(\'xn\-\-nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:196\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:197\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βο\\u0301λος\.com\'\)\ \[data\/IdnaTest\.txt\:198\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:199\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος.com", %p)},	"βόλος.com",	"to_unicode\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:200\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmm1c.com", %p)},	"βόλος.com",	"to_unicode\(\'xn\-\-nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:201\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmm1c", %p)},	"βόλος",	"to_unicode\(\'xn\-\-nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:202\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος", %p)},	"βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:203\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλος", %p)},	"βόλος",	"to_unicode\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:204\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:205\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:206\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΟ\x{0301}ΛΟΣ", %p)},	"βόλοσ",	"to_unicode\(\'ΒΟ\\u0301ΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ΒΌΛΟΣ", %p)},	"βόλοσ",	"to_unicode\(\'ΒΌΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βόλοσ", %p)},	"βόλοσ",	"to_unicode\(\'βόλοσ\'\)\ \[data\/IdnaTest\.txt\:209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("βο\x{0301}λοσ", %p)},	"βόλοσ",	"to_unicode\(\'βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:210\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λοσ", %p)},	"βόλοσ",	"to_unicode\(\'Βο\\u0301λοσ\'\)\ \[data\/IdnaTest\.txt\:211\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλοσ", %p)},	"βόλοσ",	"to_unicode\(\'Βόλοσ\'\)\ \[data\/IdnaTest\.txt\:212\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nxasmq6b", %p)},	"βόλοσ",	"to_unicode\(\'xn\-\-nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:213\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος", %p)},	"βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:214\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βόλος", %p)},	"βόλος",	"to_unicode\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Βο\x{0301}λος", %p)},	"βόλος",	"to_unicode\(\'Βο\\u0301λος\'\)\ \[data\/IdnaTest\.txt\:217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.xn--10cl1a0b.com", %p)},	"www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.ශ\x{0DCA}ර\x{0DD3}.com",	"to_unicode\(\'www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("www.xn--10cl1a0b660p.com", %p)},	"www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com",	"to_unicode\(\'www\.xn\-\-10cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:222\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f060k", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}",	"to_unicode\(\'xn\-\-mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f060k.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--mgba3gch31f.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'xn\-\-mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com", %p)},	"\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com",	"to_unicode\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b．c。d｡", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b．c。d｡\'\)\ \[data\/IdnaTest\.txt\:233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.c。d。", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b\.c。d。\'\)\ \[data\/IdnaTest\.txt\:234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.c.d.", %p)},	"a.b.c.d.",	"to_unicode\(\'a\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'Ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ü.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("u\x{0308}.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'u\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--tda.xn--tda", %p)},	"ü.ü",	"to_unicode\(\'xn\-\-tda\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ü.ü", %p)},	"ü.ü",	"to_unicode\(\'ü\.ü\'\)\ \[data\/IdnaTest\.txt\:241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("u\x{0308}.u\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'u\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.U\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.U\\u0308\'\)\ \[data\/IdnaTest\.txt\:243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.Ü", %p)},	"ü.ü",	"to_unicode\(\'Ü\.Ü\'\)\ \[data\/IdnaTest\.txt\:244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ü.ü", %p)},	"ü.ü",	"to_unicode\(\'Ü\.ü\'\)\ \[data\/IdnaTest\.txt\:245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("U\x{0308}.u\x{0308}", %p)},	"ü.ü",	"to_unicode\(\'U\\u0308\.u\\u0308\'\)\ \[data\/IdnaTest\.txt\:246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--u-ccb", %p)},	undef,	"to_unicode\(\'xn\-\-u\-ccb\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a⒈com", %p)},	undef,	"to_unicode\(\'a⒈com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a1.com", %p)},	"a1.com",	"to_unicode\(\'a1\.com\'\)\ \[data\/IdnaTest\.txt\:249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A⒈COM", %p)},	undef,	"to_unicode\(\'A⒈COM\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A⒈Com", %p)},	undef,	"to_unicode\(\'A⒈Com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-ecp.ru", %p)},	undef,	"to_unicode\(\'xn\-\-a\-ecp\.ru\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0.pt", %p)},	undef,	"to_unicode\(\'xn\-\-0\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\.pt\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-Ä.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-A\x{0308}.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-a\x{0308}.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-a\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--a-ä.pt", %p)},	undef,	"to_unicode\(\'xn\-\-a\-ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:258\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("XN--A-Ä.PT", %p)},	undef,	"to_unicode\(\'XN\-\-A\-Ä\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:259\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("XN--A-A\x{0308}.PT", %p)},	undef,	"to_unicode\(\'XN\-\-A\-A\\u0308\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Xn--A-A\x{0308}.pt", %p)},	undef,	"to_unicode\(\'Xn\-\-A\-A\\u0308\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Xn--A-Ä.pt", %p)},	undef,	"to_unicode\(\'Xn\-\-A\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。ＪＰ", %p)},	"日本語.jp",	"to_unicode\(\'日本語。ＪＰ\'\)\ \[data\/IdnaTest\.txt\:263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。JP", %p)},	"日本語.jp",	"to_unicode\(\'日本語。JP\'\)\ \[data\/IdnaTest\.txt\:264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--wgv71a119e.jp", %p)},	"日本語.jp",	"to_unicode\(\'xn\-\-wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語.jp", %p)},	"日本語.jp",	"to_unicode\(\'日本語\.jp\'\)\ \[data\/IdnaTest\.txt\:266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。ｊｐ", %p)},	"日本語.jp",	"to_unicode\(\'日本語。ｊｐ\'\)\ \[data\/IdnaTest\.txt\:267\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("日本語。Ｊｐ", %p)},	"日本語.jp",	"to_unicode\(\'日本語。Ｊｐ\'\)\ \[data\/IdnaTest\.txt\:268\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("☕", %p)},	"☕",	"to_unicode\(\'☕\'\)\ \[data\/IdnaTest\.txt\:269\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--53h", %p)},	"☕",	"to_unicode\(\'xn\-\-53h\'\)\ \[data\/IdnaTest\.txt\:270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:274\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:275\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_unicode\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_unicode\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_unicode\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_unicode\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bss", %p)},	"夙",	"to_unicode\(\'xn\-\-bss\'\)\ \[data\/IdnaTest\.txt\:295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("夙", %p)},	"夙",	"to_unicode\(\'夙\'\)\ \[data\/IdnaTest\.txt\:296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_unicode\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}ſ\x{2064}𝔰\x{E01EF}ﬄ", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00ſ\\u2064𝔰\\uDB40\\uDDEFﬄ\'\)\ \[data\/IdnaTest\.txt\:299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s\x{E01EF}ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("x\x{034F}n\x{200B}-\x{00AD}-\x{180C}b\x{FE00}s\x{2064}s\x{E01EF}ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034Fn\\u200B\-\\u00AD\-\\u180Cb\\uFE00s\\u2064s\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("X\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}S\x{E01EF}FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'X\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064S\\uDB40\\uDDEFFFL\'\)\ \[data\/IdnaTest\.txt\:302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("X\x{034F}n\x{200B}-\x{00AD}-\x{180C}B\x{FE00}s\x{2064}s\x{E01EF}ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'X\\u034Fn\\u200B\-\\u00AD\-\\u180CB\\uFE00s\\u2064s\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--bssffl", %p)},	"夡夞夜夙",	"to_unicode\(\'xn\-\-bssffl\'\)\ \[data\/IdnaTest\.txt\:304\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("夡夞夜夙", %p)},	"夡夞夜夙",	"to_unicode\(\'夡夞夜夙\'\)\ \[data\/IdnaTest\.txt\:305\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}S\x{2064}𝔰\x{E01EF}FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00S\\u2064𝔰\\uDB40\\uDDEFFFL\'\)\ \[data\/IdnaTest\.txt\:306\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("x\x{034F}N\x{200B}-\x{00AD}-\x{180C}B\x{FE00}S\x{2064}s\x{E01EF}FFL", %p)},	"夡夞夜夙",	"to_unicode\(\'x\\u034FN\\u200B\-\\u00AD\-\\u180CB\\uFE00S\\u2064s\\uDB40\\uDDEFFFL\'\)\ \[data\/IdnaTest\.txt\:307\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}s\x{2064}𝔰\x{E01EF}ffl", %p)},	"夡夞夜夙",	"to_unicode\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00s\\u2064𝔰\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:308\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:309\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:310\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:315\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'a\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:316\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'A\\u03081234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:317\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä1234567890123456789012345678901234567890123456789012345", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'Ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:318\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--1234567890123456789012345678901234567890123456789012345-9te", %p)},	"ä1234567890123456789012345678901234567890123456789012345",	"to_unicode\(\'xn\-\-1234567890123456789012345678901234567890123456789012345\-9te\'\)\ \[data\/IdnaTest\.txt\:319\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:321\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:322\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:323\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:324\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:325\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:326\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:327\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u0308123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:332\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ \[data\/IdnaTest\.txt\:333\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:334\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:335\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:336\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ \[data\/IdnaTest\.txt\:337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ \[data\/IdnaTest\.txt\:341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890a\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890a\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890A\x{0308}1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890A\\u03081234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_unicode\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--a-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--ä-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-ä\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..-q--a\x{0308}-.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.\-q\-\-a\\u0308\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B..-Q--A\x{0308}-.E", %p)},	undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-A\\u0308\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B..-Q--Ä-.E", %p)},	undef,	"to_unicode\(\'A\.B\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b..xn---q----jra.e", %p)},	undef,	"to_unicode\(\'a\.b\.\.xn\-\-\-q\-\-\-\-jra\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a..c", %p)},	undef,	"to_unicode\(\'a\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.-b.", %p)},	undef,	"to_unicode\(\'a\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b-.c", %p)},	undef,	"to_unicode\(\'a\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.-.c", %p)},	undef,	"to_unicode\(\'a\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.bc--de.f", %p)},	undef,	"to_unicode\(\'a\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.\x{00AD}.c", %p)},	undef,	"to_unicode\(\'ä\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.\x{00AD}.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.\x{00AD}.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.\x{00AD}.C", %p)},	undef,	"to_unicode\(\'Ä\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.-b.", %p)},	undef,	"to_unicode\(\'ä\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.-b.", %p)},	undef,	"to_unicode\(\'a\\u0308\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.-B.", %p)},	undef,	"to_unicode\(\'A\\u0308\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.-B.", %p)},	undef,	"to_unicode\(\'Ä\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.b-.c", %p)},	undef,	"to_unicode\(\'ä\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.b-.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.B-.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.B-.C", %p)},	undef,	"to_unicode\(\'Ä\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.-.c", %p)},	undef,	"to_unicode\(\'ä\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.-.c", %p)},	undef,	"to_unicode\(\'a\\u0308\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.-.C", %p)},	undef,	"to_unicode\(\'A\\u0308\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.-.C", %p)},	undef,	"to_unicode\(\'Ä\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ä.bc--de.f", %p)},	undef,	"to_unicode\(\'ä\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{0308}.bc--de.f", %p)},	undef,	"to_unicode\(\'a\\u0308\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{0308}.BC--DE.F", %p)},	undef,	"to_unicode\(\'A\\u0308\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ä.BC--DE.F", %p)},	undef,	"to_unicode\(\'Ä\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.\x{0308}c.d", %p)},	undef,	"to_unicode\(\'a\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A.B.\x{0308}C.D", %p)},	undef,	"to_unicode\(\'A\.B\.\\u0308C\.D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a.b.xn--c-bcb.d", %p)},	undef,	"to_unicode\(\'a\.b\.xn\-\-c\-bcb\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A0", %p)},	"a0",	"to_unicode\(\'A0\'\)\ \[data\/IdnaTest\.txt\:380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A", %p)},	"0a",	"to_unicode\(\'0A\'\)\ \[data\/IdnaTest\.txt\:381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0A.\x{05D0}", %p)},	"0a.\x{05D0}",	"to_unicode\(\'0A\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:382\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0a.xn--4db", %p)},	"0a.\x{05D0}",	"to_unicode\(\'0a\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:383\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.xn--0-eha.xn--4db", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.xn\-\-0\-eha\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:384\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.0ü.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.0ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("c.0u\x{0308}.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'c\.0u\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("C.0U\x{0308}.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'C\.0U\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("C.0Ü.\x{05D0}", %p)},	"c.0ü.\x{05D0}",	"to_unicode\(\'C\.0Ü\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("b-.\x{05D0}", %p)},	undef,	"to_unicode\(\'b\-\.\\u05D0\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("d.xn----dha.xn--4db", %p)},	undef,	"to_unicode\(\'d\.xn\-\-\-\-dha\.xn\-\-4db\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}", %p)},	undef,	"to_unicode\(\'a\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}", %p)},	undef,	"to_unicode\(\'A\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05C7}", %p)},	"\x{05D0}\x{05C7}",	"to_unicode\(\'\\u05D0\\u05C7\'\)\ \[data\/IdnaTest\.txt\:393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--vdbr", %p)},	"\x{05D0}\x{05C7}",	"to_unicode\(\'xn\-\-vdbr\'\)\ \[data\/IdnaTest\.txt\:394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}9\x{05C7}", %p)},	"\x{05D0}9\x{05C7}",	"to_unicode\(\'\\u05D09\\u05C7\'\)\ \[data\/IdnaTest\.txt\:395\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--9-ihcz", %p)},	"\x{05D0}9\x{05C7}",	"to_unicode\(\'xn\-\-9\-ihcz\'\)\ \[data\/IdnaTest\.txt\:396\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}a\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u05D0a\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:397\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}A\x{05C7}", %p)},	undef,	"to_unicode\(\'\\u05D0A\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:398\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05EA}", %p)},	"\x{05D0}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05EA\'\)\ \[data\/IdnaTest\.txt\:399\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c", %p)},	"\x{05D0}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c\'\)\ \[data\/IdnaTest\.txt\:400\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{05F3}\x{05EA}", %p)},	"\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'\\u05D0\\u05F3\\u05EA\'\)\ \[data\/IdnaTest\.txt\:401\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c0a", %p)},	"\x{05D0}\x{05F3}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c0a\'\)\ \[data\/IdnaTest\.txt\:402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}Tz", %p)},	undef,	"to_unicode\(\'a\\u05D0Tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{05D0}tz", %p)},	undef,	"to_unicode\(\'a\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}TZ", %p)},	undef,	"to_unicode\(\'A\\u05D0TZ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{05D0}tz", %p)},	undef,	"to_unicode\(\'A\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}T\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D0T\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}t\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D0t\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}7\x{05EA}", %p)},	"\x{05D0}7\x{05EA}",	"to_unicode\(\'\\u05D07\\u05EA\'\)\ \[data\/IdnaTest\.txt\:409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--7-zhc3f", %p)},	"\x{05D0}7\x{05EA}",	"to_unicode\(\'xn\-\-7\-zhc3f\'\)\ \[data\/IdnaTest\.txt\:410\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}\x{0667}\x{05EA}", %p)},	"\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'\\u05D0\\u0667\\u05EA\'\)\ \[data\/IdnaTest\.txt\:411\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4db6c6t", %p)},	"\x{05D0}\x{0667}\x{05EA}",	"to_unicode\(\'xn\-\-4db6c6t\'\)\ \[data\/IdnaTest\.txt\:412\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a7\x{0667}z", %p)},	undef,	"to_unicode\(\'a7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:413\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A7\x{0667}Z", %p)},	undef,	"to_unicode\(\'A7\\u0667Z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:414\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A7\x{0667}z", %p)},	undef,	"to_unicode\(\'A7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:415\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{05D0}7\x{0667}\x{05EA}", %p)},	undef,	"to_unicode\(\'\\u05D07\\u0667\\u05EA\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:416\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200D}", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:417\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200D}", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:418\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4b", %p)},	"ஹ\x{0BCD}",	"to_unicode\(\'xn\-\-dmc4b\'\)\ \[data\/IdnaTest\.txt\:419\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}", %p)},	"ஹ\x{0BCD}",	"to_unicode\(\'ஹ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:420\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4b194h", %p)},	"ஹ\x{0BCD}\x{200D}",	"to_unicode\(\'xn\-\-dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:421\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200D}", %p)},	undef,	"to_unicode\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200D}", %p)},	undef,	"to_unicode\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc", %p)},	"ஹ",	"to_unicode\(\'xn\-\-dmc\'\)\ \[data\/IdnaTest\.txt\:424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ", %p)},	"ஹ",	"to_unicode\(\'ஹ\'\)\ \[data\/IdnaTest\.txt\:425\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:426\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200C}", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{0BCD}\x{200C}", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--dmc4by94h", %p)},	"ஹ\x{0BCD}\x{200C}",	"to_unicode\(\'xn\-\-dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200C}", %p)},	undef,	"to_unicode\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ஹ\x{200C}", %p)},	undef,	"to_unicode\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxqia", %p)},	"\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:438\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxqia7523a", %p)},	"\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:439\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2g3q", %p)},	"\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06EF}", %p)},	"\x{0644}\x{0670}\x{06EF}",	"to_unicode\(\'\\u0644\\u0670\\u06EF\'\)\ \[data\/IdnaTest\.txt\:443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2g3qq34f", %p)},	"\x{0644}\x{0670}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb25aga", %p)},	"\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga\'\)\ \[data\/IdnaTest\.txt\:447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{06ED}\x{06EF}", %p)},	"\x{0644}\x{06ED}\x{06EF}",	"to_unicode\(\'\\u0644\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb25aga828w", %p)},	"\x{0644}\x{200C}\x{06ED}\x{06EF}",	"to_unicode\(\'xn\-\-ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:449\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:450\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}\x{06EF}", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:451\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb65a", %p)},	"\x{0644}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a\'\)\ \[data\/IdnaTest\.txt\:452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{06EF}", %p)},	"\x{0644}\x{06EF}",	"to_unicode\(\'\\u0644\\u06EF\'\)\ \[data\/IdnaTest\.txt\:453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb65a953d", %p)},	"\x{0644}\x{200C}\x{06EF}",	"to_unicode\(\'xn\-\-ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:455\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_unicode\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb2gxq", %p)},	"\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'xn\-\-ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{0670}\x{06ED}", %p)},	"\x{0644}\x{0670}\x{06ED}",	"to_unicode\(\'\\u0644\\u0670\\u06ED\'\)\ \[data\/IdnaTest\.txt\:458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_unicode\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--cmba", %p)},	"\x{06EF}\x{06EF}",	"to_unicode\(\'xn\-\-cmba\'\)\ \[data\/IdnaTest\.txt\:461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06EF}\x{06EF}", %p)},	"\x{06EF}\x{06EF}",	"to_unicode\(\'\\u06EF\\u06EF\'\)\ \[data\/IdnaTest\.txt\:462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ghb", %p)},	"\x{0644}",	"to_unicode\(\'xn\-\-ghb\'\)\ \[data\/IdnaTest\.txt\:465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0644}", %p)},	"\x{0644}",	"to_unicode\(\'\\u0644\'\)\ \[data\/IdnaTest\.txt\:466\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⁷∝\x{A8EC}\x{E2410}．-\x{E01D1}", %p)},	undef,	"to_unicode\(\'⁷∝\\uA8EC\\uDB49\\uDC10．\-\\uDB40\\uDDD1\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:470\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("7∝\x{A8EC}\x{E2410}.-\x{E01D1}", %p)},	undef,	"to_unicode\(\'7∝\\uA8EC\\uDB49\\uDC10\.\-\\uDB40\\uDDD1\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:471\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0769}.ꡰ", %p)},	"\x{0769}.ꡰ",	"to_unicode\(\'\\u0769\.ꡰ\'\)\ \[data\/IdnaTest\.txt\:472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--tpb.xn--md9a", %p)},	"\x{0769}.ꡰ",	"to_unicode\(\'xn\-\-tpb\.xn\-\-md9a\'\)\ \[data\/IdnaTest\.txt\:473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{066B}｡-", %p)},	undef,	"to_unicode\(\'≯\\u066B｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:474\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{066B}｡-", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u066B｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:475\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{066B}。-", %p)},	undef,	"to_unicode\(\'≯\\u066B。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:476\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{066B}。-", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u066B。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:477\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{066B}⾕.\x{115F}⚙ςႭ", %p)},	undef,	"to_unicode\(\'⾛\\u066B⾕\.\\u115F⚙ςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:478\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{066B}谷.\x{115F}⚙ςႭ", %p)},	undef,	"to_unicode\(\'走\\u066B谷\.\\u115F⚙ςႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:479\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{066B}谷.\x{115F}⚙ςⴍ", %p)},	undef,	"to_unicode\(\'走\\u066B谷\.\\u115F⚙ςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:480\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{066B}谷.\x{115F}⚙ΣႭ", %p)},	undef,	"to_unicode\(\'走\\u066B谷\.\\u115F⚙ΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:481\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{066B}谷.\x{115F}⚙σⴍ", %p)},	undef,	"to_unicode\(\'走\\u066B谷\.\\u115F⚙σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("走\x{066B}谷.\x{115F}⚙Σⴍ", %p)},	undef,	"to_unicode\(\'走\\u066B谷\.\\u115F⚙Σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{066B}⾕.\x{115F}⚙ςⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u066B⾕\.\\u115F⚙ςⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{066B}⾕.\x{115F}⚙ΣႭ", %p)},	undef,	"to_unicode\(\'⾛\\u066B⾕\.\\u115F⚙ΣႭ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{066B}⾕.\x{115F}⚙σⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u066B⾕\.\\u115F⚙σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾛\x{066B}⾕.\x{115F}⚙Σⴍ", %p)},	undef,	"to_unicode\(\'⾛\\u066B⾕\.\\u115F⚙Σⴍ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:487\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᡈ≯.솣-\x{0646}Ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D≠ᡈ≯\.솣\-\\u0646Ⴀ\'\)\ throws\ error\ P1\ V6\ C2\ B5\ \[data\/IdnaTest\.txt\:488\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᡈ≯.솣-\x{0646}Ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D≠ᡈ≯\.솣\-\\u0646Ⴀ\'\)\ throws\ error\ P1\ V6\ C2\ B5\ \[data\/IdnaTest\.txt\:489\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᡈ>\x{0338}.솣-\x{0646}Ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᡈ\>\\u0338\.솣\-\\u0646Ⴀ\'\)\ throws\ error\ P1\ V6\ C2\ B5\ \[data\/IdnaTest\.txt\:490\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᡈ>\x{0338}.솣-\x{0646}Ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᡈ\>\\u0338\.솣\-\\u0646Ⴀ\'\)\ throws\ error\ P1\ V6\ C2\ B5\ \[data\/IdnaTest\.txt\:491\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᡈ>\x{0338}.솣-\x{0646}ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᡈ\>\\u0338\.솣\-\\u0646ⴀ\'\)\ throws\ error\ P1\ V6\ C2\ B5\ \[data\/IdnaTest\.txt\:492\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}=\x{0338}ᡈ>\x{0338}.솣-\x{0646}ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D\=\\u0338ᡈ\>\\u0338\.솣\-\\u0646ⴀ\'\)\ throws\ error\ P1\ V6\ C2\ B5\ \[data\/IdnaTest\.txt\:493\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᡈ≯.솣-\x{0646}ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D≠ᡈ≯\.솣\-\\u0646ⴀ\'\)\ throws\ error\ P1\ V6\ C2\ B5\ \[data\/IdnaTest\.txt\:494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}≠ᡈ≯.솣-\x{0646}ⴀ", %p)},	undef,	"to_unicode\(\'\\u200D≠ᡈ≯\.솣\-\\u0646ⴀ\'\)\ throws\ error\ P1\ V6\ C2\ B5\ \[data\/IdnaTest\.txt\:495\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E8204}．\x{FD05}\x{032F}\x{072E}\x{10E7C}", %p)},	undef,	"to_unicode\(\'\\uDB60\\uDE04．\\uFD05\\u032F\\u072E\\uD803\\uDE7C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:496\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E8204}.\x{0635}\x{0649}\x{032F}\x{072E}\x{10E7C}", %p)},	undef,	"to_unicode\(\'\\uDB60\\uDE04\.\\u0635\\u0649\\u032F\\u072E\\uD803\\uDE7C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:497\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{B5606}\x{1039}.\x{AAF6}", %p)},	undef,	"to_unicode\(\'\\uDA95\\uDE06\\u1039\.\\uAAF6\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:498\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠼ\x{0FB3}\x{BCBAD}。\x{1D177}Ⴣ\x{07E4}", %p)},	undef,	"to_unicode\(\'ᠼ\\u0FB3\\uDAB2\\uDFAD。\\uD834\\uDD77Ⴣ\\u07E4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:499\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠼ\x{0FB3}\x{BCBAD}。\x{1D177}ⴣ\x{07E4}", %p)},	undef,	"to_unicode\(\'ᠼ\\u0FB3\\uDAB2\\uDFAD。\\uD834\\uDD77ⴣ\\u07E4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:500\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6A}\x{09CD}ς🃌。\x{1A76}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6A\\u09CDς🃌。\\u1A76렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:501\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6A}\x{09CD}ς🃌。\x{1A76}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6A\\u09CDς🃌。\\u1A76렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:502\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6A}\x{09CD}Σ🃌。\x{1A76}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6A\\u09CDΣ🃌。\\u1A76렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:503\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6A}\x{09CD}Σ🃌。\x{1A76}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6A\\u09CDΣ🃌。\\u1A76렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:504\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6A}\x{09CD}σ🃌。\x{1A76}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6A\\u09CDσ🃌。\\u1A76렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:505\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6A}\x{09CD}σ🃌。\x{1A76}렧", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6A\\u09CDσ🃌。\\u1A76렧\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:506\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{200D}。\x{0755}\x{200C}\x{200D}⒈", %p)},	undef,	"to_unicode\(\'\-\\u200D。\\u0755\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。\x{0755}\x{200C}\x{200D}⒈", %p)},	undef,	"to_unicode\(\'\-\\u200D。\\u0755\\u200C\\u200D⒈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。\x{0755}\x{200C}\x{200D}1.", %p)},	undef,	"to_unicode\(\'\-\\u200D。\\u0755\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200D}。\x{0755}\x{200C}\x{200D}1.", %p)},	undef,	"to_unicode\(\'\-\\u200D。\\u0755\\u200C\\u200D1\.\'\)\ throws\ error\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:510\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{D4ADD}.Ⴒ\x{111C0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDB12\\uDEDD\.Ⴒ\\uD804\\uDDC0\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:511\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{D4ADD}.Ⴒ\x{111C0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDB12\\uDEDD\.Ⴒ\\uD804\\uDDC0\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:512\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{D4ADD}.ⴒ\x{111C0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDB12\\uDEDD\.ⴒ\\uD804\\uDDC0\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:513\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{D4ADD}.ⴒ\x{111C0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDB12\\uDEDD\.ⴒ\\uD804\\uDDC0\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:514\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("繱\x{0E3A}\x{200D}.９︒", %p)},	undef,	"to_unicode\(\'繱\\u0E3A\\u200D\.９︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:515\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0E3A}\x{200D}.9。", %p)},	"繱\x{0E3A}\x{200D}.9.",	"to_unicode\(\'繱\\u0E3A\\u200D\.9。\'\)\ \[data\/IdnaTest\.txt\:516\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0E3A}\x{200D}.9。", %p)},	"繱\x{0E3A}\x{200D}.9.",	"to_unicode\(\'繱\\u0E3A\\u200D\.9。\'\)\ \[data\/IdnaTest\.txt\:517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--o4c7658c.9.", %p)},	"繱\x{0E3A}.9.",	"to_unicode\(\'xn\-\-o4c7658c\.9\.\'\)\ \[data\/IdnaTest\.txt\:518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0E3A}.9.", %p)},	"繱\x{0E3A}.9.",	"to_unicode\(\'繱\\u0E3A\.9\.\'\)\ \[data\/IdnaTest\.txt\:519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--o4c042gf52e.9.", %p)},	"繱\x{0E3A}\x{200D}.9.",	"to_unicode\(\'xn\-\-o4c042gf52e\.9\.\'\)\ \[data\/IdnaTest\.txt\:520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0E3A}\x{200D}.9.", %p)},	"繱\x{0E3A}\x{200D}.9.",	"to_unicode\(\'繱\\u0E3A\\u200D\.9\.\'\)\ \[data\/IdnaTest\.txt\:521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("繱\x{0E3A}\x{200D}.9.", %p)},	"繱\x{0E3A}\x{200D}.9.",	"to_unicode\(\'繱\\u0E3A\\u200D\.9\.\'\)\ \[data\/IdnaTest\.txt\:522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01DF}．\x{E016C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDDF．\\uDB40\\uDD6C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01DF}.\x{E016C}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDDF\.\\uDB40\\uDD6C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{20D8}。\x{200D}", %p)},	undef,	"to_unicode\(\'ß\\u20D8。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{20D8}。\x{200D}", %p)},	undef,	"to_unicode\(\'ß\\u20D8。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{20D8}。\x{200D}", %p)},	undef,	"to_unicode\(\'SS\\u20D8。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{20D8}。\x{200D}", %p)},	undef,	"to_unicode\(\'SS\\u20D8。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{20D8}。\x{200D}", %p)},	undef,	"to_unicode\(\'ss\\u20D8。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{20D8}。\x{200D}", %p)},	undef,	"to_unicode\(\'ss\\u20D8。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{20D8}。\x{200D}", %p)},	undef,	"to_unicode\(\'Ss\\u20D8。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{20D8}。\x{200D}", %p)},	undef,	"to_unicode\(\'Ss\\u20D8。\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ss-1ju.", %p)},	"ss\x{20D8}.",	"to_unicode\(\'xn\-\-ss\-1ju\.\'\)\ \[data\/IdnaTest\.txt\:533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{20D8}.", %p)},	"ss\x{20D8}.",	"to_unicode\(\'ss\\u20D8\.\'\)\ \[data\/IdnaTest\.txt\:534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{20D8}.", %p)},	"ss\x{20D8}.",	"to_unicode\(\'SS\\u20D8\.\'\)\ \[data\/IdnaTest\.txt\:535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{20D8}.", %p)},	"ss\x{20D8}.",	"to_unicode\(\'Ss\\u20D8\.\'\)\ \[data\/IdnaTest\.txt\:536\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DD7}\x{200C}⒈．\x{E0387}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDD7\\u200C⒈．\\uDB40\\uDF87\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:537\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DD7}\x{200C}⒈．\x{E0387}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDD7\\u200C⒈．\\uDB40\\uDF87\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:538\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DD7}\x{200C}1..\x{E0387}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDD7\\u200C1\.\.\\uDB40\\uDF87\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:539\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DD7}\x{200C}1..\x{E0387}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDD7\\u200C1\.\.\\uDB40\\uDF87\'\)\ throws\ error\ P1\ V6\ C1\ A4_2\ \[data\/IdnaTest\.txt\:540\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{F6C8F}\x{1D242}\x{1CF4}ß。\x{B373C}", %p)},	undef,	"to_unicode\(\'\\uDB9B\\uDC8F\\uD834\\uDE42\\u1CF4ß。\\uDA8D\\uDF3C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:541\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{F6C8F}\x{1D242}\x{1CF4}SS。\x{B373C}", %p)},	undef,	"to_unicode\(\'\\uDB9B\\uDC8F\\uD834\\uDE42\\u1CF4SS。\\uDA8D\\uDF3C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:542\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{F6C8F}\x{1D242}\x{1CF4}ss。\x{B373C}", %p)},	undef,	"to_unicode\(\'\\uDB9B\\uDC8F\\uD834\\uDE42\\u1CF4ss。\\uDA8D\\uDF3C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:543\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{F6C8F}\x{1D242}\x{1CF4}Ss。\x{B373C}", %p)},	undef,	"to_unicode\(\'\\uDB9B\\uDC8F\\uD834\\uDE42\\u1CF4Ss。\\uDA8D\\uDF3C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:544\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡊ\x{200C}\x{062F}。\x{60C9A}䉜\x{200D}\x{3E9BB}", %p)},	undef,	"to_unicode\(\'ᡊ\\u200C\\u062F。\\uD943\\uDC9A䉜\\u200D\\uD8BA\\uDDBB\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:545\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡊ\x{200C}\x{062F}。\x{60C9A}䉜\x{200D}\x{3E9BB}", %p)},	undef,	"to_unicode\(\'ᡊ\\u200C\\u062F。\\uD943\\uDC9A䉜\\u200D\\uD8BA\\uDDBB\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:546\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}ς\x{084A}⒈.≮\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAς\\u084A⒈\.≮\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:547\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}ς\x{084A}⒈.<\x{0338}\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAς\\u084A⒈\.\<\\u0338\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:548\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}ς\x{084A}1..≮\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAς\\u084A1\.\.≮\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:549\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}ς\x{084A}1..<\x{0338}\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAς\\u084A1\.\.\<\\u0338\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:550\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}Σ\x{084A}1..<\x{0338}\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAΣ\\u084A1\.\.\<\\u0338\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:551\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}Σ\x{084A}1..≮\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAΣ\\u084A1\.\.≮\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:552\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}σ\x{084A}1..≮\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAσ\\u084A1\.\.≮\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:553\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}σ\x{084A}1..<\x{0338}\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAσ\\u084A1\.\.\<\\u0338\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ A4_2\ B1\ \[data\/IdnaTest\.txt\:554\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}Σ\x{084A}⒈.<\x{0338}\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAΣ\\u084A⒈\.\<\\u0338\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:555\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}Σ\x{084A}⒈.≮\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAΣ\\u084A⒈\.≮\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:556\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}σ\x{084A}⒈.≮\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAσ\\u084A⒈\.≮\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:557\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{469FA}σ\x{084A}⒈.<\x{0338}\x{1BF2}\x{200D}\x{06A6}", %p)},	undef,	"to_unicode\(\'\\uD8DA\\uDDFAσ\\u084A⒈\.\<\\u0338\\u1BF2\\u200D\\u06A6\'\)\ throws\ error\ P1\ V6\ B5\ B1\ \[data\/IdnaTest\.txt\:558\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{3164}\x{0ACD}Ⴀ\x{0942}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u3164\\u0ACDႠ\\u0942\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}\x{0ACD}Ⴀ\x{0942}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u1160\\u0ACDႠ\\u0942\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1160}\x{0ACD}ⴀ\x{0942}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u1160\\u0ACDⴀ\\u0942\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{3164}\x{0ACD}ⴀ\x{0942}.\x{180B}", %p)},	undef,	"to_unicode\(\'\\u3164\\u0ACDⴀ\\u0942\.\\u180B\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:562\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🎲\x{200D}．\x{116B6}\x{1A77}\x{1032}\x{E0153}", %p)},	undef,	"to_unicode\(\'🎲\\u200D．\\uD805\\uDEB6\\u1A77\\u1032\\uDB40\\uDD53\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:563\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🎲\x{200D}．\x{116B6}\x{1A77}\x{1032}\x{E0153}", %p)},	undef,	"to_unicode\(\'🎲\\u200D．\\uD805\\uDEB6\\u1A77\\u1032\\uDB40\\uDD53\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:564\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🎲\x{200D}.\x{116B6}\x{1A77}\x{1032}\x{E0153}", %p)},	undef,	"to_unicode\(\'🎲\\u200D\.\\uD805\\uDEB6\\u1A77\\u1032\\uDB40\\uDD53\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:565\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🎲\x{200D}.\x{116B6}\x{1A77}\x{1032}\x{E0153}", %p)},	undef,	"to_unicode\(\'🎲\\u200D\.\\uD805\\uDEB6\\u1A77\\u1032\\uDB40\\uDD53\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:566\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≮\x{10811}\x{1E8A1}.≯\x{7F4ED}ᠴ", %p)},	undef,	"to_unicode\(\'≮\\uD802\\uDC11\\uD83A\\uDCA1\.≯\\uD9BD\\uDCEDᠴ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:567\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("<\x{0338}\x{10811}\x{1E8A1}.>\x{0338}\x{7F4ED}ᠴ", %p)},	undef,	"to_unicode\(\'\<\\u0338\\uD802\\uDC11\\uD83A\\uDCA1\.\>\\u0338\\uD9BD\\uDCEDᠴ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:568\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE05}\x{1EEFE}\x{10F6E}٪｡\x{A953}ꡏ", %p)},	undef,	"to_unicode\(\'\\uFE05\\uD83B\\uDEFE\\uD803\\uDF6E٪｡\\uA953ꡏ\'\)\ throws\ error\ P1\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:569\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE05}\x{1EEFE}\x{10F6E}٪。\x{A953}ꡏ", %p)},	undef,	"to_unicode\(\'\\uFE05\\uD83B\\uDEFE\\uD803\\uDF6E٪。\\uA953ꡏ\'\)\ throws\ error\ P1\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:570\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06D7}。\x{1091DF}", %p)},	undef,	"to_unicode\(\'\\u06D7。\\uDBE4\\uDDDF\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:571\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0ACD}\x{1103A}．\x{1160}", %p)},	undef,	"to_unicode\(\'\\u0ACD\\uD804\\uDC3A．\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:572\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0ACD}\x{1103A}.\x{1160}", %p)},	undef,	"to_unicode\(\'\\u0ACD\\uD804\\uDC3A\.\\u1160\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:573\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{068A}\x{200D}。\x{D8C20}\x{109CB}", %p)},	undef,	"to_unicode\(\'\-\\u068A\\u200D。\\uDB23\\uDC20\\uD802\\uDDCB\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:574\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{068A}\x{200D}。\x{D8C20}\x{109CB}", %p)},	undef,	"to_unicode\(\'\-\\u068A\\u200D。\\uDB23\\uDC20\\uD802\\uDDCB\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:575\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06AA}゜≯\x{73334}。\x{E01B5}⾇滸\x{0669}", %p)},	undef,	"to_unicode\(\'\\u06AA゜≯\\uD98C\\uDF34。\\uDB40\\uDDB5⾇滸\\u0669\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:576\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06AA}゜>\x{0338}\x{73334}。\x{E01B5}⾇滸\x{0669}", %p)},	undef,	"to_unicode\(\'\\u06AA゜\>\\u0338\\uD98C\\uDF34。\\uDB40\\uDDB5⾇滸\\u0669\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:577\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06AA}\x{0020}\x{309A}≯\x{73334}。\x{E01B5}舛滸\x{0669}", %p)},	undef,	"to_unicode\(\'\\u06AA\\u0020\\u309A≯\\uD98C\\uDF34。\\uDB40\\uDDB5舛滸\\u0669\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:578\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06AA}\x{0020}\x{309A}>\x{0338}\x{73334}。\x{E01B5}舛滸\x{0669}", %p)},	undef,	"to_unicode\(\'\\u06AA\\u0020\\u309A\>\\u0338\\uD98C\\uDF34。\\uDB40\\uDDB5舛滸\\u0669\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:579\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("蔏｡\x{1BAB}", %p)},	undef,	"to_unicode\(\'蔏｡\\u1BAB\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:580\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("蔏。\x{1BAB}", %p)},	undef,	"to_unicode\(\'蔏。\\u1BAB\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:581\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🄁\x{0712}。\x{E0107}", %p)},	undef,	"to_unicode\(\'🄁\\u0712。\\uDB40\\uDD07\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0,\x{0712}。\x{E0107}", %p)},	undef,	"to_unicode\(\'0\,\\u0712。\\uDB40\\uDD07\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:583\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A005C}-䟖F。\x{0855}⒈\x{10E67}", %p)},	undef,	"to_unicode\(\'\\uDA40\\uDC5C\-䟖F。\\u0855⒈\\uD803\\uDE67\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:584\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A005C}-䟖F。\x{0855}1.\x{10E67}", %p)},	undef,	"to_unicode\(\'\\uDA40\\uDC5C\-䟖F。\\u08551\.\\uD803\\uDE67\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:585\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A005C}-䟖f。\x{0855}1.\x{10E67}", %p)},	undef,	"to_unicode\(\'\\uDA40\\uDC5C\-䟖f。\\u08551\.\\uD803\\uDE67\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:586\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A005C}-䟖f。\x{0855}⒈\x{10E67}", %p)},	undef,	"to_unicode\(\'\\uDA40\\uDC5C\-䟖f。\\u0855⒈\\uD803\\uDE67\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:587\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}｡\x{10E7D}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\uD803\\uDE7D\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡\x{10E7D}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\uD803\\uDE7D\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{10E7D}", %p)},	undef,	"to_unicode\(\'\\u200C。\\uD803\\uDE7D\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{10E7D}", %p)},	undef,	"to_unicode\(\'\\u200C。\\uD803\\uDE7D\'\)\ throws\ error\ C1\ B1\ \[data\/IdnaTest\.txt\:591\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EA6A}.≯\x{200C}-\x{07DE}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE6A\.≯\\u200C\-\\u07DE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:592\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EA6A}.≯\x{200C}-\x{07DE}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE6A\.≯\\u200C\-\\u07DE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:593\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EA6A}.>\x{0338}\x{200C}-\x{07DE}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE6A\.\>\\u0338\\u200C\-\\u07DE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:594\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EA6A}.>\x{0338}\x{200C}-\x{07DE}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE6A\.\>\\u0338\\u200C\-\\u07DE\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:595\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08FB}-。≠\x{1096E}", %p)},	undef,	"to_unicode\(\'\\u08FB\-。≠\\uD802\\uDD6E\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:596\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08FB}-。=\x{0338}\x{1096E}", %p)},	undef,	"to_unicode\(\'\\u08FB\-。\=\\u0338\\uD802\\uDD6E\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:597\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A5DB4}\x{1A60}。\x{200D}\x{1EA86}", %p)},	undef,	"to_unicode\(\'\\uDA57\\uDDB4\\u1A60。\\u200D\\uD83A\\uDE86\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:598\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A5DB4}\x{1A60}。\x{200D}\x{1EA86}", %p)},	undef,	"to_unicode\(\'\\uDA57\\uDDB4\\u1A60。\\u200D\\uD83A\\uDE86\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:599\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A38}\x{0D4D}🄉｡㧉\x{3FB78}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE38\\u0D4D🄉｡㧉\\uD8BE\\uDF78\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:600\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0D4D}\x{10A38}🄉｡㧉\x{3FB78}", %p)},	undef,	"to_unicode\(\'\\u0D4D\\uD802\\uDE38🄉｡㧉\\uD8BE\\uDF78\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:601\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0D4D}\x{10A38}8,。㧉\x{3FB78}", %p)},	undef,	"to_unicode\(\'\\u0D4D\\uD802\\uDE388\,。㧉\\uD8BE\\uDF78\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:602\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{8E039}\x{10E66}\x{108C1}。≯⒙", %p)},	undef,	"to_unicode\(\'\\u200C\\uD9F8\\uDC39\\uD803\\uDE66\\uD802\\uDCC1。≯⒙\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:603\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{8E039}\x{10E66}\x{108C1}。≯⒙", %p)},	undef,	"to_unicode\(\'\\u200C\\uD9F8\\uDC39\\uD803\\uDE66\\uD802\\uDCC1。≯⒙\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:604\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{8E039}\x{10E66}\x{108C1}。>\x{0338}⒙", %p)},	undef,	"to_unicode\(\'\\u200C\\uD9F8\\uDC39\\uD803\\uDE66\\uD802\\uDCC1。\>\\u0338⒙\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:605\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{8E039}\x{10E66}\x{108C1}。>\x{0338}⒙", %p)},	undef,	"to_unicode\(\'\\u200C\\uD9F8\\uDC39\\uD803\\uDE66\\uD802\\uDCC1。\>\\u0338⒙\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:606\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{8E039}\x{10E66}\x{108C1}。≯18.", %p)},	undef,	"to_unicode\(\'\\u200C\\uD9F8\\uDC39\\uD803\\uDE66\\uD802\\uDCC1。≯18\.\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:607\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{8E039}\x{10E66}\x{108C1}。≯18.", %p)},	undef,	"to_unicode\(\'\\u200C\\uD9F8\\uDC39\\uD803\\uDE66\\uD802\\uDCC1。≯18\.\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:608\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{8E039}\x{10E66}\x{108C1}。>\x{0338}18.", %p)},	undef,	"to_unicode\(\'\\u200C\\uD9F8\\uDC39\\uD803\\uDE66\\uD802\\uDCC1。\>\\u033818\.\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:609\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{8E039}\x{10E66}\x{108C1}。>\x{0338}18.", %p)},	undef,	"to_unicode\(\'\\u200C\\uD9F8\\uDC39\\uD803\\uDE66\\uD802\\uDCC1。\>\\u033818\.\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:610\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A60}．\x{0665}\x{173D0}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1A60．\\u0665\\uD81C\\uDFD0\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:611\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A60}．\x{0665}\x{173D0}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1A60．\\u0665\\uD81C\\uDFD0\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:612\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A60}.\x{0665}\x{173D0}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1A60\.\\u0665\\uD81C\\uDFD0\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:613\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A60}.\x{0665}\x{173D0}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\u1A60\.\\u0665\\uD81C\\uDFD0\-\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:614\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0CA6}ς\x{E5CA6}｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCA6ς\\uDB57\\uDCA6｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:615\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0CA6}ς\x{E5CA6}。\x{1160}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCA6ς\\uDB57\\uDCA6。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:616\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0CA6}Σ\x{E5CA6}。\x{1160}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCA6Σ\\uDB57\\uDCA6。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:617\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0CA6}σ\x{E5CA6}。\x{1160}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCA6σ\\uDB57\\uDCA6。\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:618\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0CA6}Σ\x{E5CA6}｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCA6Σ\\uDB57\\uDCA6｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:619\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0CA6}σ\x{E5CA6}｡\x{FFA0}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCA6σ\\uDB57\\uDCA6｡\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:620\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0684}\x{A8E1}ꡢ\x{06C9}.\x{1EAE1}\x{A806}Ⴃ", %p)},	undef,	"to_unicode\(\'\\u0684\\uA8E1ꡢ\\u06C9\.\\uD83A\\uDEE1\\uA806Ⴃ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:621\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0684}\x{A8E1}ꡢ\x{06C9}.\x{1EAE1}\x{A806}ⴃ", %p)},	undef,	"to_unicode\(\'\\u0684\\uA8E1ꡢ\\u06C9\.\\uD83A\\uDEE1\\uA806ⴃ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:622\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E75}\x{094D}-킼.\x{0C4D}\x{0F79}\x{10E7E}≯", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE75\\u094D\-킼\.\\u0C4D\\u0F79\\uD803\\uDE7E≯\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:623\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E75}\x{094D}-킼.\x{0C4D}\x{0F79}\x{10E7E}>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE75\\u094D\-킼\.\\u0C4D\\u0F79\\uD803\\uDE7E\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:624\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E75}\x{094D}-킼.\x{0C4D}\x{0FB3}\x{0F71}\x{0F80}\x{10E7E}≯", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE75\\u094D\-킼\.\\u0C4D\\u0FB3\\u0F71\\u0F80\\uD803\\uDE7E≯\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:625\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E75}\x{094D}-킼.\x{0C4D}\x{0FB3}\x{0F71}\x{0F80}\x{10E7E}>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE75\\u094D\-킼\.\\u0C4D\\u0FB3\\u0F71\\u0F80\\uD803\\uDE7E\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:626\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-。ᠯ\x{0600}\x{AB323}\x{0A4D}", %p)},	undef,	"to_unicode\(\'\-。ᠯ\\u0600\\uDA6C\\uDF23\\u0A4D\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:627\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}㼣\x{A679}．\x{FE23}\x{E819}ᢗ🄉", %p)},	undef,	"to_unicode\(\'\\u200D㼣\\uA679．\\uFE23\\uE819ᢗ🄉\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:628\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}㼣\x{A679}．\x{FE23}\x{E819}ᢗ🄉", %p)},	undef,	"to_unicode\(\'\\u200D㼣\\uA679．\\uFE23\\uE819ᢗ🄉\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:629\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}㼣\x{A679}.\x{FE23}\x{E819}ᢗ8,", %p)},	undef,	"to_unicode\(\'\\u200D㼣\\uA679\.\\uFE23\\uE819ᢗ8\,\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:630\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}㼣\x{A679}.\x{FE23}\x{E819}ᢗ8,", %p)},	undef,	"to_unicode\(\'\\u200D㼣\\uA679\.\\uFE23\\uE819ᢗ8\,\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:631\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︒\x{B9953}ς\x{97D30}｡\x{076A}", %p)},	undef,	"to_unicode\(\'︒\\uDAA6\\uDD53ς\\uDA1F\\uDD30｡\\u076A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:632\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("。\x{B9953}ς\x{97D30}。\x{076A}", %p)},	undef,	"to_unicode\(\'。\\uDAA6\\uDD53ς\\uDA1F\\uDD30。\\u076A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:633\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("。\x{B9953}Σ\x{97D30}。\x{076A}", %p)},	undef,	"to_unicode\(\'。\\uDAA6\\uDD53Σ\\uDA1F\\uDD30。\\u076A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:634\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("。\x{B9953}σ\x{97D30}。\x{076A}", %p)},	undef,	"to_unicode\(\'。\\uDAA6\\uDD53σ\\uDA1F\\uDD30。\\u076A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:635\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︒\x{B9953}Σ\x{97D30}｡\x{076A}", %p)},	undef,	"to_unicode\(\'︒\\uDAA6\\uDD53Σ\\uDA1F\\uDD30｡\\u076A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:636\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︒\x{B9953}σ\x{97D30}｡\x{076A}", %p)},	undef,	"to_unicode\(\'︒\\uDAA6\\uDD53σ\\uDA1F\\uDD30｡\\u076A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:637\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E88E}．\x{FC20}\x{914D9}≯\x{1A7F}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDC8E．\\uFC20\\uDA05\\uDCD9≯\\u1A7F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:638\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E88E}．\x{FC20}\x{914D9}>\x{0338}\x{1A7F}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDC8E．\\uFC20\\uDA05\\uDCD9\>\\u0338\\u1A7F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:639\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E88E}.\x{0635}\x{062D}\x{914D9}≯\x{1A7F}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDC8E\.\\u0635\\u062D\\uDA05\\uDCD9≯\\u1A7F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:640\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E88E}.\x{0635}\x{062D}\x{914D9}>\x{0338}\x{1A7F}", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDC8E\.\\u0635\\u062D\\uDA05\\uDCD9\>\\u0338\\u1A7F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:641\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08FE}\x{5DD8C}.\x{1EFC6}", %p)},	undef,	"to_unicode\(\'\\u08FE\\uD937\\uDD8C\.\\uD83B\\uDFC6\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:642\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("۸\x{0355}≠｡Ⴟ\x{2DE3}Ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355≠｡Ⴟ\\u2DE3Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}=\x{0338}｡Ⴟ\x{2DE3}Ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355\=\\u0338｡Ⴟ\\u2DE3Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}≠。Ⴟ\x{2DE3}Ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355≠。Ⴟ\\u2DE3Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}=\x{0338}。Ⴟ\x{2DE3}Ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355\=\\u0338。Ⴟ\\u2DE3Ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}=\x{0338}。ⴟ\x{2DE3}ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355\=\\u0338。ⴟ\\u2DE3ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}≠。ⴟ\x{2DE3}ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355≠。ⴟ\\u2DE3ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:648\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}≠。Ⴟ\x{2DE3}ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355≠。Ⴟ\\u2DE3ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:649\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}=\x{0338}。Ⴟ\x{2DE3}ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355\=\\u0338。Ⴟ\\u2DE3ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:650\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}=\x{0338}｡ⴟ\x{2DE3}ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355\=\\u0338｡ⴟ\\u2DE3ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:651\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}≠｡ⴟ\x{2DE3}ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355≠｡ⴟ\\u2DE3ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:652\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}≠｡Ⴟ\x{2DE3}ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355≠｡Ⴟ\\u2DE3ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:653\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("۸\x{0355}=\x{0338}｡Ⴟ\x{2DE3}ⴈ", %p)},	undef,	"to_unicode\(\'۸\\u0355\=\\u0338｡Ⴟ\\u2DE3ⴈ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:654\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{E0271}\x{E016B}Ⴥ。-\x{066C}ᡳ\x{08ED}", %p)},	undef,	"to_unicode\(\'\-\\uDB40\\uDE71\\uDB40\\uDD6BჅ。\-\\u066Cᡳ\\u08ED\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:655\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{E0271}\x{E016B}ⴥ。-\x{066C}ᡳ\x{08ED}", %p)},	undef,	"to_unicode\(\'\-\\uDB40\\uDE71\\uDB40\\uDD6Bⴥ。\-\\u066Cᡳ\\u08ED\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:656\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E012B}。\x{0A4D}︒ᢖᢔ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD2B。\\u0A4D︒ᢖᢔ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:657\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E012B}。\x{0A4D}。ᢖᢔ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD2B。\\u0A4D。ᢖᢔ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:658\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴙꡱ.\x{E015A}\x{200D}", %p)},	undef,	"to_unicode\(\'Ⴙꡱ\.\\uDB40\\uDD5A\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:659\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴙꡱ.\x{E015A}\x{200D}", %p)},	undef,	"to_unicode\(\'Ⴙꡱ\.\\uDB40\\uDD5A\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:660\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴙꡱ.\x{E015A}\x{200D}", %p)},	undef,	"to_unicode\(\'ⴙꡱ\.\\uDB40\\uDD5A\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:661\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴙꡱ.\x{E015A}\x{200D}", %p)},	undef,	"to_unicode\(\'ⴙꡱ\.\\uDB40\\uDD5A\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--hlj6950b.", %p)},	"ⴙꡱ.",	"to_unicode\(\'xn\-\-hlj6950b\.\'\)\ \[data\/IdnaTest\.txt\:663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴙꡱ.", %p)},	"ⴙꡱ.",	"to_unicode\(\'ⴙꡱ\.\'\)\ \[data\/IdnaTest\.txt\:664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴙꡱ.", %p)},	undef,	"to_unicode\(\'Ⴙꡱ\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:665\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B72}｡⒎⒋\x{10CD6}ꡙ", %p)},	undef,	"to_unicode\(\'\\u1B72｡⒎⒋\\uD803\\uDCD6ꡙ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:666\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B72}。7.4.\x{10CD6}ꡙ", %p)},	undef,	"to_unicode\(\'\\u1B72。7\.4\.\\uD803\\uDCD6ꡙ\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:667\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒋ᠬ｡-\x{0747}", %p)},	undef,	"to_unicode\(\'⒋ᠬ｡\-\\u0747\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.ᠬ。-\x{0747}", %p)},	undef,	"to_unicode\(\'4\.ᠬ。\-\\u0747\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:669\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}｡\x{AAF6}ς\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604｡\\uAAF6ς\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:670\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}｡\x{AAF6}ς\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604｡\\uAAF6ς\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:671\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}。\x{AAF6}ς\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604。\\uAAF6ς\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:672\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}。\x{AAF6}ς\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604。\\uAAF6ς\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:673\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}。\x{AAF6}Σ\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604。\\uAAF6Σ\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:674\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}。\x{AAF6}Σ\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604。\\uAAF6Σ\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:675\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}。\x{AAF6}σ\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604。\\uAAF6σ\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:676\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}。\x{AAF6}σ\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604。\\uAAF6σ\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:677\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}｡\x{AAF6}Σ\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604｡\\uAAF6Σ\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:678\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}｡\x{AAF6}Σ\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604｡\\uAAF6Σ\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:679\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}｡\x{AAF6}σ\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604｡\\uAAF6σ\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:680\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{37E15}\x{0604}｡\x{AAF6}σ\x{10D5F}\x{AA4C}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD89F\\uDE15\\u0604｡\\uAAF6σ\\uD803\\uDD5F\\uAA4C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:681\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{ECD8E}Ⴓ⒪．\x{1B42}\x{60C9C}\x{1EC97}\x{066C}", %p)},	undef,	"to_unicode\(\'⒈\\uDB73\\uDD8EႳ⒪．\\u1B42\\uD943\\uDC9C\\uD83B\\uDC97\\u066C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:682\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{ECD8E}Ⴓ(o).\x{1B42}\x{60C9C}\x{1EC97}\x{066C}", %p)},	undef,	"to_unicode\(\'1\.\\uDB73\\uDD8EႳ\(o\)\.\\u1B42\\uD943\\uDC9C\\uD83B\\uDC97\\u066C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:683\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{ECD8E}ⴓ(o).\x{1B42}\x{60C9C}\x{1EC97}\x{066C}", %p)},	undef,	"to_unicode\(\'1\.\\uDB73\\uDD8Eⴓ\(o\)\.\\u1B42\\uD943\\uDC9C\\uD83B\\uDC97\\u066C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:684\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{ECD8E}Ⴓ(O).\x{1B42}\x{60C9C}\x{1EC97}\x{066C}", %p)},	undef,	"to_unicode\(\'1\.\\uDB73\\uDD8EႳ\(O\)\.\\u1B42\\uD943\\uDC9C\\uD83B\\uDC97\\u066C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:685\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{ECD8E}ⴓ⒪．\x{1B42}\x{60C9C}\x{1EC97}\x{066C}", %p)},	undef,	"to_unicode\(\'⒈\\uDB73\\uDD8Eⴓ⒪．\\u1B42\\uD943\\uDC9C\\uD83B\\uDC97\\u066C\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:686\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07E7}.\x{0855}\x{109DE}\x{066C}\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u07E7\.\\u0855\\uD802\\uDDDE\\u066C\\u07DE\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:687\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC17}-｡\x{1BAB}獀", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC17\-｡\\u1BAB獀\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:688\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC17}-。\x{1BAB}獀", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC17\-。\\u1BAB獀\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:689\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-䷊ꡡ．\x{E0C24}\x{4A8EB}۸", %p)},	undef,	"to_unicode\(\'\-䷊ꡡ．\\uDB43\\uDC24\\uD8EA\\uDCEB۸\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:690\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-䷊ꡡ.\x{E0C24}\x{4A8EB}۸", %p)},	undef,	"to_unicode\(\'\-䷊ꡡ\.\\uDB43\\uDC24\\uD8EA\\uDCEB۸\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:691\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🁝˶𣾪\x{332DE}.\x{0850}9", %p)},	undef,	"to_unicode\(\'🁝˶𣾪\\uD88C\\uDEDE\.\\u08509\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:692\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮\x{0663}．\x{07A9}", %p)},	undef,	"to_unicode\(\'≮\\u0663．\\u07A9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0663}．\x{07A9}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0663．\\u07A9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮\x{0663}.\x{07A9}", %p)},	undef,	"to_unicode\(\'≮\\u0663\.\\u07A9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}\x{0663}.\x{07A9}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0663\.\\u07A9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:696\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E62}ᯛ\x{1BAA}｡脥", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE62ᯛ\\u1BAA｡脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:697\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E62}ᯛ\x{1BAA}。脥", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE62ᯛ\\u1BAA。脥\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:698\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0F84}\x{115F}\x{10E89}\x{9C047}.-", %p)},	undef,	"to_unicode\(\'\\u0F84\\u115F\\uD803\\uDE89\\uDA30\\uDC47\.\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:699\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}｡\x{E005D}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\uDB40\\uDC5D\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡\x{E005D}", %p)},	undef,	"to_unicode\(\'\\u200C｡\\uDB40\\uDC5D\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{E005D}", %p)},	undef,	"to_unicode\(\'\\u200C。\\uDB40\\uDC5D\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{E005D}", %p)},	undef,	"to_unicode\(\'\\u200C。\\uDB40\\uDC5D\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:703\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠤ\x{AA2C}．\x{06C7}Ⴎ", %p)},	undef,	"to_unicode\(\'ᠤ\\uAA2C．\\u06C7Ⴎ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:704\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠤ\x{AA2C}.\x{06C7}Ⴎ", %p)},	undef,	"to_unicode\(\'ᠤ\\uAA2C\.\\u06C7Ⴎ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:705\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠤ\x{AA2C}.\x{06C7}ⴎ", %p)},	undef,	"to_unicode\(\'ᠤ\\uAA2C\.\\u06C7ⴎ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:706\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠤ\x{AA2C}．\x{06C7}ⴎ", %p)},	undef,	"to_unicode\(\'ᠤ\\uAA2C．\\u06C7ⴎ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:707\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡅ\x{A949}Ξ．\x{68897}㛨∋", %p)},	undef,	"to_unicode\(\'ᡅ\\uA949Ξ．\\uD962\\uDC97㛨∋\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:708\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡅ\x{A949}Ξ.\x{68897}㛨∋", %p)},	undef,	"to_unicode\(\'ᡅ\\uA949Ξ\.\\uD962\\uDC97㛨∋\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:709\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡅ\x{A949}ξ.\x{68897}㛨∋", %p)},	undef,	"to_unicode\(\'ᡅ\\uA949ξ\.\\uD962\\uDC97㛨∋\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:710\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡅ\x{A949}ξ．\x{68897}㛨∋", %p)},	undef,	"to_unicode\(\'ᡅ\\uA949ξ．\\uD962\\uDC97㛨∋\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:711\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{0765}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u0765︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:712\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{0765}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u0765︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:713\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{0765}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u0765︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:714\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡Ⴛ\x{0765}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡Ⴛ\\u0765︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:715\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{0765}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-。Ⴛ\\u0765。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:716\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{0765}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-。Ⴛ\\u0765。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:717\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{0765}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-。Ⴛ\\u0765。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。Ⴛ\x{0765}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-。Ⴛ\\u0765。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{0765}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-。ⴛ\\u0765。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{0765}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-。ⴛ\\u0765。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{0765}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-。ⴛ\\u0765。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-。ⴛ\x{0765}。", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-。ⴛ\\u0765。\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:723\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{0765}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u0765︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:724\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{0765}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u0765︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{0765}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u0765︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("᠆몆\x{200C}-｡ⴛ\x{0765}︒", %p)},	undef,	"to_unicode\(\'᠆몆\\u200C\-｡ⴛ\\u0765︒\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⽖.︒⌄\x{200C}\x{10E62}", %p)},	undef,	"to_unicode\(\'⽖\.︒⌄\\u200C\\uD803\\uDE62\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⽖.︒⌄\x{200C}\x{10E62}", %p)},	undef,	"to_unicode\(\'⽖\.︒⌄\\u200C\\uD803\\uDE62\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("爪.。⌄\x{200C}\x{10E62}", %p)},	undef,	"to_unicode\(\'爪\.。⌄\\u200C\\uD803\\uDE62\'\)\ throws\ error\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("爪.。⌄\x{200C}\x{10E62}", %p)},	undef,	"to_unicode\(\'爪\.。⌄\\u200C\\uD803\\uDE62\'\)\ throws\ error\ A4_2\ B1\ C1\ \[data\/IdnaTest\.txt\:731\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10B9E}.\x{10E72}Ⴑ\x{4D0E5}\x{0694}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF9E\.\\uD803\\uDE72Ⴑ\\uD8F4\\uDCE5\\u0694\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:732\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10B9E}.\x{10E72}ⴑ\x{4D0E5}\x{0694}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF9E\.\\uD803\\uDE72ⴑ\\uD8F4\\uDCE5\\u0694\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:733\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0362}\x{2B951}．🄈Ⴛ", %p)},	undef,	"to_unicode\(\'\\u0362\\uD86E\\uDD51．🄈Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:734\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0362}\x{2B951}.7,Ⴛ", %p)},	undef,	"to_unicode\(\'\\u0362\\uD86E\\uDD51\.7\,Ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:735\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0362}\x{2B951}.7,ⴛ", %p)},	undef,	"to_unicode\(\'\\u0362\\uD86E\\uDD51\.7\,ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:736\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0362}\x{2B951}．🄈ⴛ", %p)},	undef,	"to_unicode\(\'\\u0362\\uD86E\\uDD51．🄈ⴛ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:737\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{A69F}齀。릿\x{1EF8C}", %p)},	undef,	"to_unicode\(\'\-\\uA69F齀。릿\\uD83B\\uDF8C\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:738\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{A69F}齀。릿\x{1EF8C}", %p)},	undef,	"to_unicode\(\'\-\\uA69F齀。릿\\uD83B\\uDF8C\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:739\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2DFE}\x{0852}鹝꾗。\x{64262}\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\\u2DFE\\u0852鹝꾗。\\uD950\\uDE62\\u200D\\u200D⏃\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:740\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2DFE}\x{0852}鹝꾗。\x{64262}\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\\u2DFE\\u0852鹝꾗。\\uD950\\uDE62\\u200D\\u200D⏃\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:741\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2DFE}\x{0852}鹝꾗。\x{64262}\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\\u2DFE\\u0852鹝꾗。\\uD950\\uDE62\\u200D\\u200D⏃\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:742\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2DFE}\x{0852}鹝꾗。\x{64262}\x{200D}\x{200D}⏃", %p)},	undef,	"to_unicode\(\'\\u2DFE\\u0852鹝꾗。\\uD950\\uDE62\\u200D\\u200D⏃\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:743\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≮．-\x{1EACC}--", %p)},	undef,	"to_unicode\(\'≮．\-\\uD83A\\uDECC\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:744\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("<\x{0338}．-\x{1EACC}--", %p)},	undef,	"to_unicode\(\'\<\\u0338．\-\\uD83A\\uDECC\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:745\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≮.-\x{1EACC}--", %p)},	undef,	"to_unicode\(\'≮\.\-\\uD83A\\uDECC\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:746\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("<\x{0338}.-\x{1EACC}--", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\-\\uD83A\\uDECC\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ B1\ \[data\/IdnaTest\.txt\:747\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}ς３", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200Dς３\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:748\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}ς３", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200Dς３\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:749\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}ς3", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200Dς3\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:750\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}ς3", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200Dς3\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:751\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}Σ3", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200DΣ3\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:752\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}Σ3", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200DΣ3\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:753\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}σ3", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200Dσ3\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}σ3", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200Dσ3\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}Σ３", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200DΣ３\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}Σ３", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200DΣ３\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}σ３", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200Dσ３\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E68}؉。\x{200D}σ３", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE68؉。\\u200Dσ３\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:759\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς\x{DF8CA}₃.\x{10D7D}", %p)},	undef,	"to_unicode\(\'ς\\uDB3E\\uDCCA₃\.\\uD803\\uDD7D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:760\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς\x{DF8CA}3.\x{10D7D}", %p)},	undef,	"to_unicode\(\'ς\\uDB3E\\uDCCA3\.\\uD803\\uDD7D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:761\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ\x{DF8CA}3.\x{10D7D}", %p)},	undef,	"to_unicode\(\'Σ\\uDB3E\\uDCCA3\.\\uD803\\uDD7D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:762\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ\x{DF8CA}3.\x{10D7D}", %p)},	undef,	"to_unicode\(\'σ\\uDB3E\\uDCCA3\.\\uD803\\uDD7D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:763\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ\x{DF8CA}₃.\x{10D7D}", %p)},	undef,	"to_unicode\(\'Σ\\uDB3E\\uDCCA₃\.\\uD803\\uDD7D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:764\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ\x{DF8CA}₃.\x{10D7D}", %p)},	undef,	"to_unicode\(\'σ\\uDB3E\\uDCCA₃\.\\uD803\\uDD7D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:765\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{0760}⒉\x{077C}．-\x{07E6}\x{1B42}", %p)},	undef,	"to_unicode\(\'\\u200C\\u0760⒉\\u077C．\-\\u07E6\\u1B42\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:766\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0760}⒉\x{077C}．-\x{07E6}\x{1B42}", %p)},	undef,	"to_unicode\(\'\\u200C\\u0760⒉\\u077C．\-\\u07E6\\u1B42\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:767\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0760}2.\x{077C}.-\x{07E6}\x{1B42}", %p)},	undef,	"to_unicode\(\'\\u200C\\u07602\.\\u077C\.\-\\u07E6\\u1B42\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0760}2.\x{077C}.-\x{07E6}\x{1B42}", %p)},	undef,	"to_unicode\(\'\\u200C\\u07602\.\\u077C\.\-\\u07E6\\u1B42\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:769\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7C1E5}。\x{07A0}넯\x{E8610}", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDE5。\\u07A0넯\\uDB61\\uDE10\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:770\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7C1E5}。\x{07A0}넯\x{E8610}", %p)},	undef,	"to_unicode\(\'\\uD9B0\\uDDE5。\\u07A0넯\\uDB61\\uDE10\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:771\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{076E}Ⴘ。\x{0603}Ⴈ\x{FE03}", %p)},	undef,	"to_unicode\(\'\\u076EႸ。\\u0603Ⴈ\\uFE03\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{076E}ⴘ。\x{0603}ⴈ\x{FE03}", %p)},	undef,	"to_unicode\(\'\\u076Eⴘ。\\u0603ⴈ\\uFE03\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:773\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟑\x{E02D1}\x{071B}。牣\x{10E78}Ⴜᣥ", %p)},	undef,	"to_unicode\(\'𝟑\\uDB40\\uDED1\\u071B。牣\\uD803\\uDE78Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:774\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{E02D1}\x{071B}。牣\x{10E78}Ⴜᣥ", %p)},	undef,	"to_unicode\(\'3\\uDB40\\uDED1\\u071B。牣\\uD803\\uDE78Ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:775\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{E02D1}\x{071B}。牣\x{10E78}ⴜᣥ", %p)},	undef,	"to_unicode\(\'3\\uDB40\\uDED1\\u071B。牣\\uD803\\uDE78ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:776\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟑\x{E02D1}\x{071B}。牣\x{10E78}ⴜᣥ", %p)},	undef,	"to_unicode\(\'𝟑\\uDB40\\uDED1\\u071B。牣\\uD803\\uDE78ⴜᣥ\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:777\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-⒐\x{FB3C}⒈.Ⴓ", %p)},	undef,	"to_unicode\(\'\-⒐\\uFB3C⒈\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:778\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-⒐\x{05DC}\x{05BC}⒈.Ⴓ", %p)},	undef,	"to_unicode\(\'\-⒐\\u05DC\\u05BC⒈\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-9.\x{05DC}\x{05BC}1..Ⴓ", %p)},	undef,	"to_unicode\(\'\-9\.\\u05DC\\u05BC1\.\.Ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-9.\x{05DC}\x{05BC}1..ⴓ", %p)},	undef,	"to_unicode\(\'\-9\.\\u05DC\\u05BC1\.\.ⴓ\'\)\ throws\ error\ V3\ A4_2\ \[data\/IdnaTest\.txt\:781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-⒐\x{05DC}\x{05BC}⒈.ⴓ", %p)},	undef,	"to_unicode\(\'\-⒐\\u05DC\\u05BC⒈\.ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-⒐\x{FB3C}⒈.ⴓ", %p)},	undef,	"to_unicode\(\'\-⒐\\uFB3C⒈\.ⴓ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.𩃹-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.𩃹\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:784\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.𩃹-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.𩃹\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:785\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.𩃹-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.𩃹\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}긃.𩃹-", %p)},	undef,	"to_unicode\(\'\\u200C긃\.𩃹\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:787\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("뉓泓\x{8C224}.\x{11046}\x{200D}", %p)},	undef,	"to_unicode\(\'뉓泓\\uD9F0\\uDE24\.\\uD804\\uDC46\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:788\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("뉓泓\x{8C224}.\x{11046}\x{200D}", %p)},	undef,	"to_unicode\(\'뉓泓\\uD9F0\\uDE24\.\\uD804\\uDC46\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:789\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ß｡\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Eß｡\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:790\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ß｡\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Eß｡\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:791\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ß。\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Eß。\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:792\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ß。\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Eß。\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:793\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}SS。\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESS。\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:794\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}SS。\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESS。\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:795\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ss。\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Ess。\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:796\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ss。\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Ess。\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:797\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}Ss。\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESs。\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:798\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}Ss。\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESs。\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:799\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}SS｡\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESS｡\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:800\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}SS｡\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESS｡\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:801\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ss｡\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Ess｡\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:802\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}ss｡\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7Ess｡\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:803\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}Ss｡\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESs｡\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:804\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E7E}Ss｡\x{08F1}\x{2B75}\x{C8A18}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE7ESs｡\\u08F1\\u2B75\\uDAE2\\uDE18\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:805\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{11046}．\x{A8C4}-≮≠", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC46．\\uA8C4\-≮≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:806\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{11046}．\x{A8C4}-<\x{0338}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC46．\\uA8C4\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:807\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{11046}.\x{A8C4}-≮≠", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC46\.\\uA8C4\-≮≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:808\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{11046}.\x{A8C4}-<\x{0338}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDC46\.\\uA8C4\-\<\\u0338\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:809\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1039}Ⴑ\x{115F}．\x{A8C4}Ⅎ", %p)},	undef,	"to_unicode\(\'\\u1039Ⴑ\\u115F．\\uA8C4Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}Ⴑ\x{115F}.\x{A8C4}Ⅎ", %p)},	undef,	"to_unicode\(\'\\u1039Ⴑ\\u115F\.\\uA8C4Ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}ⴑ\x{115F}.\x{A8C4}ⅎ", %p)},	undef,	"to_unicode\(\'\\u1039ⴑ\\u115F\.\\uA8C4ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}Ⴑ\x{115F}.\x{A8C4}ⅎ", %p)},	undef,	"to_unicode\(\'\\u1039Ⴑ\\u115F\.\\uA8C4ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}ⴑ\x{115F}．\x{A8C4}ⅎ", %p)},	undef,	"to_unicode\(\'\\u1039ⴑ\\u115F．\\uA8C4ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}Ⴑ\x{115F}．\x{A8C4}ⅎ", %p)},	undef,	"to_unicode\(\'\\u1039Ⴑ\\u115F．\\uA8C4ⅎ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:815\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82222}。Ⴃ\x{1EEA8}\x{10E7E}똯", %p)},	undef,	"to_unicode\(\'\\uD9C8\\uDE22。Ⴃ\\uD83B\\uDEA8\\uD803\\uDE7E똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:816\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82222}。Ⴃ\x{1EEA8}\x{10E7E}똯", %p)},	undef,	"to_unicode\(\'\\uD9C8\\uDE22。Ⴃ\\uD83B\\uDEA8\\uD803\\uDE7E똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:817\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82222}。Ⴃ\x{0637}\x{10E7E}똯", %p)},	undef,	"to_unicode\(\'\\uD9C8\\uDE22。Ⴃ\\u0637\\uD803\\uDE7E똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:818\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82222}。Ⴃ\x{0637}\x{10E7E}똯", %p)},	undef,	"to_unicode\(\'\\uD9C8\\uDE22。Ⴃ\\u0637\\uD803\\uDE7E똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:819\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82222}。ⴃ\x{0637}\x{10E7E}똯", %p)},	undef,	"to_unicode\(\'\\uD9C8\\uDE22。ⴃ\\u0637\\uD803\\uDE7E똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:820\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82222}。ⴃ\x{0637}\x{10E7E}똯", %p)},	undef,	"to_unicode\(\'\\uD9C8\\uDE22。ⴃ\\u0637\\uD803\\uDE7E똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:821\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82222}。ⴃ\x{1EEA8}\x{10E7E}똯", %p)},	undef,	"to_unicode\(\'\\uD9C8\\uDE22。ⴃ\\uD83B\\uDEA8\\uD803\\uDE7E똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:822\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82222}。ⴃ\x{1EEA8}\x{10E7E}똯", %p)},	undef,	"to_unicode\(\'\\uD9C8\\uDE22。ⴃ\\uD83B\\uDEA8\\uD803\\uDE7E똯\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:823\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06AC}｡⳻\x{E01AD}\x{2D7F}\x{3164}", %p)},	undef,	"to_unicode\(\'\\u06AC｡⳻\\uDB40\\uDDAD\\u2D7F\\u3164\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:824\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06AC}。⳻\x{E01AD}\x{2D7F}\x{1160}", %p)},	undef,	"to_unicode\(\'\\u06AC。⳻\\uDB40\\uDDAD\\u2D7F\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:825\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10B1C}⾇．ᢣ-𝟢", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF1C⾇．ᢣ\-𝟢\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B1C}舛.ᢣ-0", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF1C舛\.ᢣ\-0\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:827\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴉ猕\x{4C0A1}≮．︒", %p)},	undef,	"to_unicode\(\'Ⴉ猕\\uD8F0\\uDCA1≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:828\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴉ猕\x{4C0A1}<\x{0338}．︒", %p)},	undef,	"to_unicode\(\'Ⴉ猕\\uD8F0\\uDCA1\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:829\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴉ猕\x{4C0A1}≮.。", %p)},	undef,	"to_unicode\(\'Ⴉ猕\\uD8F0\\uDCA1≮\.。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:830\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴉ猕\x{4C0A1}<\x{0338}.。", %p)},	undef,	"to_unicode\(\'Ⴉ猕\\uD8F0\\uDCA1\<\\u0338\.。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:831\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴉ猕\x{4C0A1}<\x{0338}.。", %p)},	undef,	"to_unicode\(\'ⴉ猕\\uD8F0\\uDCA1\<\\u0338\.。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:832\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴉ猕\x{4C0A1}≮.。", %p)},	undef,	"to_unicode\(\'ⴉ猕\\uD8F0\\uDCA1≮\.。\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:833\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴉ猕\x{4C0A1}<\x{0338}．︒", %p)},	undef,	"to_unicode\(\'ⴉ猕\\uD8F0\\uDCA1\<\\u0338．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:834\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴉ猕\x{4C0A1}≮．︒", %p)},	undef,	"to_unicode\(\'ⴉ猕\\uD8F0\\uDCA1≮．︒\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:835\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⳪｡ᢙ鳳\x{0682}\x{0F91}", %p)},	undef,	"to_unicode\(\'⳪｡ᢙ鳳\\u0682\\u0F91\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳪。ᢙ鳳\x{0682}\x{0F91}", %p)},	undef,	"to_unicode\(\'⳪。ᢙ鳳\\u0682\\u0F91\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0600}。ß", %p)},	undef,	"to_unicode\(\'\\u200D\\u0600。ß\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0600}。ß", %p)},	undef,	"to_unicode\(\'\\u200D\\u0600。ß\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0600}。SS", %p)},	undef,	"to_unicode\(\'\\u200D\\u0600。SS\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{0600}。SS", %p)},	undef,	"to_unicode\(\'\\u200D\\u0600。SS\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'Å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("A\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'A\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:850\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:851\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:852\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-.\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-\.\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:853\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:854\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("a\x{030A}둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'a\\u030A둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:855\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:856\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("å둄-．\x{200C}", %p)},	undef,	"to_unicode\(\'å둄\-．\\u200C\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:857\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E01E1}\x{11AFF}\x{065E}\x{068D}.\x{2C83D}-\x{0618}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDE1\\uD806\\uDEFF\\u065E\\u068D\.\\uD872\\uDC3D\-\\u0618\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:858\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς.ß\x{D722C}\x{10E72}\x{0BCD}", %p)},	undef,	"to_unicode\(\'ς\.ß\\uDB1C\\uDE2C\\uD803\\uDE72\\u0BCD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:859\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ.SS\x{D722C}\x{10E72}\x{0BCD}", %p)},	undef,	"to_unicode\(\'Σ\.SS\\uDB1C\\uDE2C\\uD803\\uDE72\\u0BCD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:860\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ.ss\x{D722C}\x{10E72}\x{0BCD}", %p)},	undef,	"to_unicode\(\'σ\.ss\\uDB1C\\uDE2C\\uD803\\uDE72\\u0BCD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:861\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ.ss\x{D722C}\x{10E72}\x{0BCD}", %p)},	undef,	"to_unicode\(\'Σ\.ss\\uDB1C\\uDE2C\\uD803\\uDE72\\u0BCD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:862\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ.ß\x{D722C}\x{10E72}\x{0BCD}", %p)},	undef,	"to_unicode\(\'Σ\.ß\\uDB1C\\uDE2C\\uD803\\uDE72\\u0BCD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:863\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ.ß\x{D722C}\x{10E72}\x{0BCD}", %p)},	undef,	"to_unicode\(\'σ\.ß\\uDB1C\\uDE2C\\uD803\\uDE72\\u0BCD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:864\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{067C}\x{E01D0}｡\x{10E65}\x{E01E3}", %p)},	undef,	"to_unicode\(\'\\u067C\\uDB40\\uDDD0｡\\uD803\\uDE65\\uDB40\\uDDE3\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067C}\x{E01D0}。\x{10E65}\x{E01E3}", %p)},	undef,	"to_unicode\(\'\\u067C\\uDB40\\uDDD0。\\uD803\\uDE65\\uDB40\\uDDE3\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:866\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("밬\x{200C}\x{1E9A9}｡\x{E0391}\x{9F04D}-\x{1ED1A}", %p)},	undef,	"to_unicode\(\'밬\\u200C\\uD83A\\uDDA9｡\\uDB40\\uDF91\\uDA3C\\uDC4D\-\\uD83B\\uDD1A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:867\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("밬\x{200C}\x{1E9A9}｡\x{E0391}\x{9F04D}-\x{1ED1A}", %p)},	undef,	"to_unicode\(\'밬\\u200C\\uD83A\\uDDA9｡\\uDB40\\uDF91\\uDA3C\\uDC4D\-\\uD83B\\uDD1A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:868\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("밬\x{200C}\x{1E9A9}｡\x{E0391}\x{9F04D}-\x{1ED1A}", %p)},	undef,	"to_unicode\(\'밬\\u200C\\uD83A\\uDDA9｡\\uDB40\\uDF91\\uDA3C\\uDC4D\-\\uD83B\\uDD1A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:869\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("밬\x{200C}\x{1E9A9}｡\x{E0391}\x{9F04D}-\x{1ED1A}", %p)},	undef,	"to_unicode\(\'밬\\u200C\\uD83A\\uDDA9｡\\uDB40\\uDF91\\uDA3C\\uDC4D\-\\uD83B\\uDD1A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:870\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("밬\x{200C}\x{1E9A9}。\x{E0391}\x{9F04D}-\x{1ED1A}", %p)},	undef,	"to_unicode\(\'밬\\u200C\\uD83A\\uDDA9。\\uDB40\\uDF91\\uDA3C\\uDC4D\-\\uD83B\\uDD1A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:871\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("밬\x{200C}\x{1E9A9}。\x{E0391}\x{9F04D}-\x{1ED1A}", %p)},	undef,	"to_unicode\(\'밬\\u200C\\uD83A\\uDDA9。\\uDB40\\uDF91\\uDA3C\\uDC4D\-\\uD83B\\uDD1A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:872\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("밬\x{200C}\x{1E9A9}。\x{E0391}\x{9F04D}-\x{1ED1A}", %p)},	undef,	"to_unicode\(\'밬\\u200C\\uD83A\\uDDA9。\\uDB40\\uDF91\\uDA3C\\uDC4D\-\\uD83B\\uDD1A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:873\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("밬\x{200C}\x{1E9A9}。\x{E0391}\x{9F04D}-\x{1ED1A}", %p)},	undef,	"to_unicode\(\'밬\\u200C\\uD83A\\uDDA9。\\uDB40\\uDF91\\uDA3C\\uDC4D\-\\uD83B\\uDD1A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:874\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("룱\x{200D}\x{BE542}\x{200C}。\x{E01A9}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDAB9\\uDD42\\u200C。\\uDB40\\uDDA9︒\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:875\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("룱\x{200D}\x{BE542}\x{200C}。\x{E01A9}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDAB9\\uDD42\\u200C。\\uDB40\\uDDA9︒\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:876\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("룱\x{200D}\x{BE542}\x{200C}。\x{E01A9}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDAB9\\uDD42\\u200C。\\uDB40\\uDDA9︒\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:877\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("룱\x{200D}\x{BE542}\x{200C}。\x{E01A9}︒", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDAB9\\uDD42\\u200C。\\uDB40\\uDDA9︒\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:878\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("룱\x{200D}\x{BE542}\x{200C}。\x{E01A9}。", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDAB9\\uDD42\\u200C。\\uDB40\\uDDA9。\'\)\ throws\ error\ P1\ V6\ C2\ C1\ A4_2\ \[data\/IdnaTest\.txt\:879\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("룱\x{200D}\x{BE542}\x{200C}。\x{E01A9}。", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDAB9\\uDD42\\u200C。\\uDB40\\uDDA9。\'\)\ throws\ error\ P1\ V6\ C2\ C1\ A4_2\ \[data\/IdnaTest\.txt\:880\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("룱\x{200D}\x{BE542}\x{200C}。\x{E01A9}。", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDAB9\\uDD42\\u200C。\\uDB40\\uDDA9。\'\)\ throws\ error\ P1\ V6\ C2\ C1\ A4_2\ \[data\/IdnaTest\.txt\:881\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("룱\x{200D}\x{BE542}\x{200C}。\x{E01A9}。", %p)},	undef,	"to_unicode\(\'룱\\u200D\\uDAB9\\uDD42\\u200C。\\uDB40\\uDDA9。\'\)\ throws\ error\ P1\ V6\ C2\ C1\ A4_2\ \[data\/IdnaTest\.txt\:882\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("₆．\x{FE07}⒈ß", %p)},	undef,	"to_unicode\(\'₆．\\uFE07⒈ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:883\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6.\x{FE07}1.ß", %p)},	"6.1.ß",	"to_unicode\(\'6\.\\uFE071\.ß\'\)\ \[data\/IdnaTest\.txt\:884\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6.\x{FE07}1.ß", %p)},	"6.1.ß",	"to_unicode\(\'6\.\\uFE071\.ß\'\)\ \[data\/IdnaTest\.txt\:885\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6.\x{FE07}1.SS", %p)},	"6.1.ss",	"to_unicode\(\'6\.\\uFE071\.SS\'\)\ \[data\/IdnaTest\.txt\:886\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6.1.ss", %p)},	"6.1.ss",	"to_unicode\(\'6\.1\.ss\'\)\ \[data\/IdnaTest\.txt\:887\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6.1.xn--zca", %p)},	"6.1.ß",	"to_unicode\(\'6\.1\.xn\-\-zca\'\)\ \[data\/IdnaTest\.txt\:888\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6.1.ß", %p)},	"6.1.ß",	"to_unicode\(\'6\.1\.ß\'\)\ \[data\/IdnaTest\.txt\:889\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6.1.ß", %p)},	"6.1.ß",	"to_unicode\(\'6\.1\.ß\'\)\ \[data\/IdnaTest\.txt\:890\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₆．\x{FE07}⒈SS", %p)},	undef,	"to_unicode\(\'₆．\\uFE07⒈SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:891\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₆．\x{FE07}⒈ss", %p)},	undef,	"to_unicode\(\'₆．\\uFE07⒈ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:892\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("₆．\x{FE07}⒈Ss", %p)},	undef,	"to_unicode\(\'₆．\\uFE07⒈Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:893\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82F0D}\x{17D2}｡\x{1EBE7}\x{A4D5C}\x{E0160}", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDF0D\\u17D2｡\\uD83A\\uDFE7\\uDA53\\uDD5C\\uDB40\\uDD60\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:894\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82F0D}\x{17D2}。\x{1EBE7}\x{A4D5C}\x{E0160}", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDF0D\\u17D2。\\uD83A\\uDFE7\\uDA53\\uDD5C\\uDB40\\uDD60\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:895\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{2CEF}\x{0CCD}\x{094D}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u2CEF\\u0CCD\\u094D．≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:896\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2CEF}\x{0CCD}\x{094D}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u2CEF\\u0CCD\\u094D．≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:897\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{094D}\x{2CEF}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u094D\\u2CEF．≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:898\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{094D}\x{2CEF}．≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u094D\\u2CEF．≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:899\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{094D}\x{2CEF}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u094D\\u2CEF．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:900\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{094D}\x{2CEF}．=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u094D\\u2CEF．\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:901\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{094D}\x{2CEF}.≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u094D\\u2CEF\.≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{094D}\x{2CEF}.≠\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u094D\\u2CEF\.≠\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{094D}\x{2CEF}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u094D\\u2CEF\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{094D}\x{2CEF}.=\x{0338}\x{200D}㇛", %p)},	undef,	"to_unicode\(\'\\u0CCD\\u094D\\u2CEF\.\=\\u0338\\u200D㇛\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:905\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ¹娤.\x{200D}\x{E0152}\x{0669}\x{E005F}", %p)},	undef,	"to_unicode\(\'Ⴁ¹娤\.\\u200D\\uDB40\\uDD52\\u0669\\uDB40\\uDC5F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:906\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ¹娤.\x{200D}\x{E0152}\x{0669}\x{E005F}", %p)},	undef,	"to_unicode\(\'Ⴁ¹娤\.\\u200D\\uDB40\\uDD52\\u0669\\uDB40\\uDC5F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:907\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ1娤.\x{200D}\x{E0152}\x{0669}\x{E005F}", %p)},	undef,	"to_unicode\(\'Ⴁ1娤\.\\u200D\\uDB40\\uDD52\\u0669\\uDB40\\uDC5F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:908\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴁ1娤.\x{200D}\x{E0152}\x{0669}\x{E005F}", %p)},	undef,	"to_unicode\(\'Ⴁ1娤\.\\u200D\\uDB40\\uDD52\\u0669\\uDB40\\uDC5F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:909\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴁ1娤.\x{200D}\x{E0152}\x{0669}\x{E005F}", %p)},	undef,	"to_unicode\(\'ⴁ1娤\.\\u200D\\uDB40\\uDD52\\u0669\\uDB40\\uDC5F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴁ1娤.\x{200D}\x{E0152}\x{0669}\x{E005F}", %p)},	undef,	"to_unicode\(\'ⴁ1娤\.\\u200D\\uDB40\\uDD52\\u0669\\uDB40\\uDC5F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴁ¹娤.\x{200D}\x{E0152}\x{0669}\x{E005F}", %p)},	undef,	"to_unicode\(\'ⴁ¹娤\.\\u200D\\uDB40\\uDD52\\u0669\\uDB40\\uDC5F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴁ¹娤.\x{200D}\x{E0152}\x{0669}\x{E005F}", %p)},	undef,	"to_unicode\(\'ⴁ¹娤\.\\u200D\\uDB40\\uDD52\\u0669\\uDB40\\uDC5F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚Ⴄ\x{0669}\x{E0065}。⒈\x{1D1AB}ß", %p)},	undef,	"to_unicode\(\'⒚Ⴄ\\u0669\\uDB40\\uDC65。⒈\\uD834\\uDDABß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.Ⴄ\x{0669}\x{E0065}。1.\x{1D1AB}ß", %p)},	undef,	"to_unicode\(\'19\.Ⴄ\\u0669\\uDB40\\uDC65。1\.\\uD834\\uDDABß\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.ⴄ\x{0669}\x{E0065}。1.\x{1D1AB}ß", %p)},	undef,	"to_unicode\(\'19\.ⴄ\\u0669\\uDB40\\uDC65。1\.\\uD834\\uDDABß\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.Ⴄ\x{0669}\x{E0065}。1.\x{1D1AB}SS", %p)},	undef,	"to_unicode\(\'19\.Ⴄ\\u0669\\uDB40\\uDC65。1\.\\uD834\\uDDABSS\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.ⴄ\x{0669}\x{E0065}。1.\x{1D1AB}ss", %p)},	undef,	"to_unicode\(\'19\.ⴄ\\u0669\\uDB40\\uDC65。1\.\\uD834\\uDDABss\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("19.Ⴄ\x{0669}\x{E0065}。1.\x{1D1AB}Ss", %p)},	undef,	"to_unicode\(\'19\.Ⴄ\\u0669\\uDB40\\uDC65。1\.\\uD834\\uDDABSs\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚ⴄ\x{0669}\x{E0065}。⒈\x{1D1AB}ß", %p)},	undef,	"to_unicode\(\'⒚ⴄ\\u0669\\uDB40\\uDC65。⒈\\uD834\\uDDABß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚Ⴄ\x{0669}\x{E0065}。⒈\x{1D1AB}SS", %p)},	undef,	"to_unicode\(\'⒚Ⴄ\\u0669\\uDB40\\uDC65。⒈\\uD834\\uDDABSS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚ⴄ\x{0669}\x{E0065}。⒈\x{1D1AB}ss", %p)},	undef,	"to_unicode\(\'⒚ⴄ\\u0669\\uDB40\\uDC65。⒈\\uD834\\uDDABss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒚Ⴄ\x{0669}\x{E0065}。⒈\x{1D1AB}Ss", %p)},	undef,	"to_unicode\(\'⒚Ⴄ\\u0669\\uDB40\\uDC65。⒈\\uD834\\uDDABSs\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200C}-\x{0662}", %p)},	undef,	"to_unicode\(\'≠\.\\u200C\-\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:924\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠.\x{200C}-\x{0662}", %p)},	undef,	"to_unicode\(\'≠\.\\u200C\-\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:925\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200C}-\x{0662}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200C\-\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:926\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{200C}-\x{0662}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u200C\-\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:927\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E78}𝟭｡\x{E0825}\x{10ACB}\x{10E6D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE78𝟭｡\\uDB42\\uDC25\\uD802\\uDECB\\uD803\\uDE6D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:928\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E78}1。\x{E0825}\x{10ACB}\x{10E6D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE781。\\uDB42\\uDC25\\uD802\\uDECB\\uD803\\uDE6D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:929\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{10E77}𝟓。\x{5E121}\x{EB555}\x{A8C4}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE77𝟓。\\uD938\\uDD21\\uDB6D\\uDD55\\uA8C4\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:930\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{10E77}𝟓。\x{5E121}\x{EB555}\x{A8C4}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE77𝟓。\\uD938\\uDD21\\uDB6D\\uDD55\\uA8C4\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:931\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{10E77}5。\x{5E121}\x{EB555}\x{A8C4}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE775。\\uD938\\uDD21\\uDB6D\\uDD55\\uA8C4\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:932\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{10E77}5。\x{5E121}\x{EB555}\x{A8C4}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE775。\\uD938\\uDD21\\uDB6D\\uDD55\\uA8C4\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:933\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{110B9}.-逋\x{8A281}\x{C017F}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDCB9\.\-逋\\uD9E8\\uDE81\\uDAC0\\uDD7F\'\)\ throws\ error\ P1\ V5\ V3\ V6\ \[data\/IdnaTest\.txt\:934\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0630}。\x{3164}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0630。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:935\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{3164}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0630。\\u3164\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:936\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{1160}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0630。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:937\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{1160}\x{200D}ς", %p)},	undef,	"to_unicode\(\'\\u0630。\\u1160\\u200Dς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:938\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0630。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:939\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{1160}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0630。\\u1160\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:940\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{1160}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0630。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:941\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{1160}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0630。\\u1160\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0630。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{3164}\x{200D}Σ", %p)},	undef,	"to_unicode\(\'\\u0630。\\u3164\\u200DΣ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{3164}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0630。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0630}。\x{3164}\x{200D}σ", %p)},	undef,	"to_unicode\(\'\\u0630。\\u3164\\u200Dσ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:946\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{077C}Ⴃ｡\x{E98A7}\x{309A}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u077CႣ｡\\uDB66\\uDCA7\\u309A\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:947\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{077C}Ⴃ｡\x{E98A7}\x{309A}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u077CႣ｡\\uDB66\\uDCA7\\u309A\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:948\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{077C}Ⴃ。\x{E98A7}\x{309A}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u077CႣ。\\uDB66\\uDCA7\\u309A\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:949\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{077C}Ⴃ。\x{E98A7}\x{309A}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u077CႣ。\\uDB66\\uDCA7\\u309A\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:950\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{077C}ⴃ。\x{E98A7}\x{309A}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u077Cⴃ。\\uDB66\\uDCA7\\u309A\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:951\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{077C}ⴃ。\x{E98A7}\x{309A}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u077Cⴃ。\\uDB66\\uDCA7\\u309A\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:952\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{077C}ⴃ｡\x{E98A7}\x{309A}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u077Cⴃ｡\\uDB66\\uDCA7\\u309A\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:953\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{077C}ⴃ｡\x{E98A7}\x{309A}\x{200D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u077Cⴃ｡\\uDB66\\uDCA7\\u309A\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:954\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺．ς\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺．ς\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺．ς\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺．ς\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺.ς\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺\.ς\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺.ς\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺\.ς\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺.Σ\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺\.Σ\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺.Σ\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺\.Σ\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺.σ\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺\.σ\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺.σ\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺\.σ\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺．Σ\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺．Σ\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺．Σ\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺．Σ\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺．σ\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺．σ\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:965\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("㭄\x{200D}ᡶ🁺．σ\x{063A}\x{200C}\x{200D}", %p)},	undef,	"to_unicode\(\'㭄\\u200Dᡶ🁺．σ\\u063A\\u200C\\u200D\'\)\ throws\ error\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:966\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{17B5}。\x{067F}\x{06EE}😽", %p)},	undef,	"to_unicode\(\'\\u17B5。\\u067F\\u06EE😽\'\)\ throws\ error\ P1\ V5\ V6\ B3\ \[data\/IdnaTest\.txt\:967\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E73}暑．⾑\x{0600}", %p)},	undef,	"to_unicode\(\'\\u0E73暑．⾑\\u0600\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:968\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E73}暑.襾\x{0600}", %p)},	undef,	"to_unicode\(\'\\u0E73暑\.襾\\u0600\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:969\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{2DF8}≯\x{07DE}。\x{FB28}\x{1B42}", %p)},	undef,	"to_unicode\(\'\\u2DF8≯\\u07DE。\\uFB28\\u1B42\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:970\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF8}>\x{0338}\x{07DE}。\x{FB28}\x{1B42}", %p)},	undef,	"to_unicode\(\'\\u2DF8\>\\u0338\\u07DE。\\uFB28\\u1B42\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:971\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF8}≯\x{07DE}。\x{05EA}\x{1B42}", %p)},	undef,	"to_unicode\(\'\\u2DF8≯\\u07DE。\\u05EA\\u1B42\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:972\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF8}>\x{0338}\x{07DE}。\x{05EA}\x{1B42}", %p)},	undef,	"to_unicode\(\'\\u2DF8\>\\u0338\\u07DE。\\u05EA\\u1B42\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:973\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{109AE}\x{5A632}\x{1039}\x{A9C0}.\x{65732}Ⴗ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDDAE\\uD929\\uDE32\\u1039\\uA9C0\.\\uD955\\uDF32Ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:974\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{109AE}\x{5A632}\x{1039}\x{A9C0}.\x{65732}ⴗ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDDAE\\uD929\\uDE32\\u1039\\uA9C0\.\\uD955\\uDF32ⴗ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:975\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0365}｡\x{0CCD}\x{436E9}\x{9992E}", %p)},	undef,	"to_unicode\(\'\\u0365｡\\u0CCD\\uD8CD\\uDEE9\\uDA26\\uDD2E\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:976\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0365}。\x{0CCD}\x{436E9}\x{9992E}", %p)},	undef,	"to_unicode\(\'\\u0365。\\u0CCD\\uD8CD\\uDEE9\\uDA26\\uDD2E\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:977\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DCD}\x{200C}．\x{069D}\x{200C}ꡘ", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDCD\\u200C．\\u069D\\u200Cꡘ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:978\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DCD}\x{200C}．\x{069D}\x{200C}ꡘ", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDCD\\u200C．\\u069D\\u200Cꡘ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:979\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DCD}\x{200C}.\x{069D}\x{200C}ꡘ", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDCD\\u200C\.\\u069D\\u200Cꡘ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:980\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DCD}\x{200C}.\x{069D}\x{200C}ꡘ", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDCD\\u200C\.\\u069D\\u200Cꡘ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:981\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07D9}\x{B49CE}ß.ጧ", %p)},	undef,	"to_unicode\(\'\\u07D9\\uDA92\\uDDCEß\.ጧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:982\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07D9}\x{B49CE}SS.ጧ", %p)},	undef,	"to_unicode\(\'\\u07D9\\uDA92\\uDDCESS\.ጧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:983\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07D9}\x{B49CE}ss.ጧ", %p)},	undef,	"to_unicode\(\'\\u07D9\\uDA92\\uDDCEss\.ጧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:984\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07D9}\x{B49CE}Ss.ጧ", %p)},	undef,	"to_unicode\(\'\\u07D9\\uDA92\\uDDCESs\.ጧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:985\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EFE}\x{200C}.\x{EDBBF}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEFE\\u200C\.\\uDB76\\uDFBF\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:986\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EFE}\x{200C}.\x{EDBBF}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEFE\\u200C\.\\uDB76\\uDFBF\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:987\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0710}\x{50DE4}\x{10E7D}。Ⴜ", %p)},	undef,	"to_unicode\(\'\\u0710\\uD903\\uDDE4\\uD803\\uDE7D。Ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:988\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0710}\x{50DE4}\x{10E7D}。ⴜ", %p)},	undef,	"to_unicode\(\'\\u0710\\uD903\\uDDE4\\uD803\\uDE7D。ⴜ\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:989\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0601}\x{2BA3}\x{200C}\x{05A6}｡\x{8BF30}\x{1EB89}", %p)},	undef,	"to_unicode\(\'\\u0601\\u2BA3\\u200C\\u05A6｡\\uD9EF\\uDF30\\uD83A\\uDF89\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:990\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0601}\x{2BA3}\x{200C}\x{05A6}｡\x{8BF30}\x{1EB89}", %p)},	undef,	"to_unicode\(\'\\u0601\\u2BA3\\u200C\\u05A6｡\\uD9EF\\uDF30\\uD83A\\uDF89\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:991\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0601}\x{2BA3}\x{200C}\x{05A6}。\x{8BF30}\x{1EB89}", %p)},	undef,	"to_unicode\(\'\\u0601\\u2BA3\\u200C\\u05A6。\\uD9EF\\uDF30\\uD83A\\uDF89\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:992\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0601}\x{2BA3}\x{200C}\x{05A6}。\x{8BF30}\x{1EB89}", %p)},	undef,	"to_unicode\(\'\\u0601\\u2BA3\\u200C\\u05A6。\\uD9EF\\uDF30\\uD83A\\uDF89\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:993\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴒ。デß\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'Ⴒ。デß\\u07E5\\u0DCA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}ß\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'Ⴒ。テ\\u3099ß\\u07E5\\u0DCA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ß\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'ⴒ。テ\\u3099ß\\u07E5\\u0DCA\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴒ。デß\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'ⴒ。デß\\u07E5\\u0DCA\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。デSS\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'Ⴒ。デSS\\u07E5\\u0DCA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}SS\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'Ⴒ。テ\\u3099SS\\u07E5\\u0DCA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴒ。テ\x{3099}ss\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'ⴒ。テ\\u3099ss\\u07E5\\u0DCA\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴒ。デss\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'ⴒ。デss\\u07E5\\u0DCA\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。デSs\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'Ⴒ。デSs\\u07E5\\u0DCA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴒ。テ\x{3099}Ss\x{07E5}\x{0DCA}", %p)},	undef,	"to_unicode\(\'Ⴒ。テ\\u3099Ss\\u07E5\\u0DCA\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{1714}．𝟠-\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u094D\\u1714．𝟠\-\\u07DE\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{094D}\x{1714}.8-\x{07DE}", %p)},	undef,	"to_unicode\(\'\\u094D\\u1714\.8\-\\u07DE\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0BCD}\x{0017}.\x{A806}𩬾\x{E012B}\x{077F}", %p)},	undef,	"to_unicode\(\'≯\\u0BCD\\u0017\.\\uA806𩬾\\uDB40\\uDD2B\\u077F\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0BCD}\x{0017}.\x{A806}𩬾\x{E012B}\x{077F}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0BCD\\u0017\.\\uA806𩬾\\uDB40\\uDD2B\\u077F\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1007\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0102}\x{C9AE1}Ⴗ쏔。\x{1EFC3}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD02\\uDAE6\\uDEE1Ⴗ쏔。\\uD83B\\uDFC3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1008\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0102}\x{C9AE1}Ⴗ쏔。\x{1EFC3}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD02\\uDAE6\\uDEE1Ⴗ쏔。\\uD83B\\uDFC3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1009\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0102}\x{C9AE1}ⴗ쏔。\x{1EFC3}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD02\\uDAE6\\uDEE1ⴗ쏔。\\uD83B\\uDFC3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1010\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0102}\x{C9AE1}ⴗ쏔。\x{1EFC3}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD02\\uDAE6\\uDEE1ⴗ쏔。\\uD83B\\uDFC3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1011\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ß｡🄃Ⴌ\x{0FC6}", %p)},	undef,	"to_unicode\(\'ß｡🄃Ⴌ\\u0FC6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß。2,Ⴌ\x{0FC6}", %p)},	undef,	"to_unicode\(\'ß。2\,Ⴌ\\u0FC6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß。2,ⴌ\x{0FC6}", %p)},	undef,	"to_unicode\(\'ß。2\,ⴌ\\u0FC6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1014\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS。2,Ⴌ\x{0FC6}", %p)},	undef,	"to_unicode\(\'SS。2\,Ⴌ\\u0FC6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1015\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss。2,ⴌ\x{0FC6}", %p)},	undef,	"to_unicode\(\'ss。2\,ⴌ\\u0FC6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1016\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß｡🄃ⴌ\x{0FC6}", %p)},	undef,	"to_unicode\(\'ß｡🄃ⴌ\\u0FC6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1017\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS｡🄃Ⴌ\x{0FC6}", %p)},	undef,	"to_unicode\(\'SS｡🄃Ⴌ\\u0FC6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1018\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss｡🄃ⴌ\x{0FC6}", %p)},	undef,	"to_unicode\(\'ss｡🄃ⴌ\\u0FC6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1019\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{07E0}\x{1E8C4}.\x{200C}∖\x{A953}", %p)},	undef,	"to_unicode\(\'\-\\u07E0\\uD83A\\uDCC4\.\\u200C∖\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1020\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{07E0}\x{1E8C4}.\x{200C}∖\x{A953}", %p)},	undef,	"to_unicode\(\'\-\\u07E0\\uD83A\\uDCC4\.\\u200C∖\\uA953\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1021\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏨ᠣ\x{1BF1}\x{111C0}.☠\x{200D}", %p)},	undef,	"to_unicode\(\'🏨ᠣ\\u1BF1\\uD804\\uDDC0\.☠\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1022\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏨ᠣ\x{1BF1}\x{111C0}.☠\x{200D}", %p)},	undef,	"to_unicode\(\'🏨ᠣ\\u1BF1\\uD804\\uDDC0\.☠\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1023\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--56e26q0321avb7g.xn--h4h", %p)},	"🏨ᠣ\x{1BF1}\x{111C0}.☠",	"to_unicode\(\'xn\-\-56e26q0321avb7g\.xn\-\-h4h\'\)\ \[data\/IdnaTest\.txt\:1024\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏨ᠣ\x{1BF1}\x{111C0}.☠", %p)},	"🏨ᠣ\x{1BF1}\x{111C0}.☠",	"to_unicode\(\'🏨ᠣ\\u1BF1\\uD804\\uDDC0\.☠\'\)\ \[data\/IdnaTest\.txt\:1025\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FAD}\x{200D}\x{08FB}\x{077A}.\x{0853}\x{200C}\x{E0344}", %p)},	undef,	"to_unicode\(\'\\u0FAD\\u200D\\u08FB\\u077A\.\\u0853\\u200C\\uDB40\\uDF44\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1026\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FAD}\x{200D}\x{08FB}\x{077A}.\x{0853}\x{200C}\x{E0344}", %p)},	undef,	"to_unicode\(\'\\u0FAD\\u200D\\u08FB\\u077A\.\\u0853\\u200C\\uDB40\\uDF44\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1027\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴑ．\x{062E}\x{10AC5}\x{0758}", %p)},	undef,	"to_unicode\(\'Ⴑ．\\u062E\\uD802\\uDEC5\\u0758\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1028\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴑ.\x{062E}\x{10AC5}\x{0758}", %p)},	undef,	"to_unicode\(\'Ⴑ\.\\u062E\\uD802\\uDEC5\\u0758\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1029\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴑ.\x{062E}\x{10AC5}\x{0758}", %p)},	undef,	"to_unicode\(\'ⴑ\.\\u062E\\uD802\\uDEC5\\u0758\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1030\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴑ．\x{062E}\x{10AC5}\x{0758}", %p)},	undef,	"to_unicode\(\'ⴑ．\\u062E\\uD802\\uDEC5\\u0758\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1031\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0954}\x{AD48F}\x{0DCA}。\x{10B96E}𝟻", %p)},	undef,	"to_unicode\(\'\\u0954\\uDA75\\uDC8F\\u0DCA。\\uDBEE\\uDD6E𝟻\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1032\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0954}\x{AD48F}\x{0DCA}。\x{10B96E}5", %p)},	undef,	"to_unicode\(\'\\u0954\\uDA75\\uDC8F\\u0DCA。\\uDBEE\\uDD6E5\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1033\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{062E}\x{3730B}２｡Ⴣ\x{07F1}\x{1EFFA}\x{79880}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062E\\uD89C\\uDF0B２｡Ⴣ\\u07F1\\uD83B\\uDFFA\\uD9A6\\uDC80\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1034\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{062E}\x{3730B}２｡Ⴣ\x{07F1}\x{1EFFA}\x{79880}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062E\\uD89C\\uDF0B２｡Ⴣ\\u07F1\\uD83B\\uDFFA\\uD9A6\\uDC80\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1035\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{062E}\x{3730B}2。Ⴣ\x{07F1}\x{1EFFA}\x{79880}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062E\\uD89C\\uDF0B2。Ⴣ\\u07F1\\uD83B\\uDFFA\\uD9A6\\uDC80\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1036\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{062E}\x{3730B}2。Ⴣ\x{07F1}\x{1EFFA}\x{79880}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062E\\uD89C\\uDF0B2。Ⴣ\\u07F1\\uD83B\\uDFFA\\uD9A6\\uDC80\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1037\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{062E}\x{3730B}2。ⴣ\x{07F1}\x{1EFFA}\x{79880}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062E\\uD89C\\uDF0B2。ⴣ\\u07F1\\uD83B\\uDFFA\\uD9A6\\uDC80\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1038\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{062E}\x{3730B}2。ⴣ\x{07F1}\x{1EFFA}\x{79880}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062E\\uD89C\\uDF0B2。ⴣ\\u07F1\\uD83B\\uDFFA\\uD9A6\\uDC80\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1039\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{062E}\x{3730B}２｡ⴣ\x{07F1}\x{1EFFA}\x{79880}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062E\\uD89C\\uDF0B２｡ⴣ\\u07F1\\uD83B\\uDFFA\\uD9A6\\uDC80\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1040\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{062E}\x{3730B}２｡ⴣ\x{07F1}\x{1EFFA}\x{79880}", %p)},	undef,	"to_unicode\(\'\\u200C\\u062E\\uD89C\\uDF0B２｡ⴣ\\u07F1\\uD83B\\uDFFA\\uD9A6\\uDC80\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ \[data\/IdnaTest\.txt\:1041\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BE}｡\x{116B5}\x{8ED6C}\x{E0001}-", %p)},	undef,	"to_unicode\(\'\\u06BE｡\\uD805\\uDEB5\\uD9FB\\uDD6C\\uDB40\\uDC01\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1042\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BE}。\x{116B5}\x{8ED6C}\x{E0001}-", %p)},	undef,	"to_unicode\(\'\\u06BE。\\uD805\\uDEB5\\uD9FB\\uDD6C\\uDB40\\uDC01\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1043\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10D4B}\x{106843}。絧\x{0953}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDD4B\\uDBDA\\uDC43。絧\\u0953\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1044\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0DCA}Ⴋ．5≯︒\x{E0195}", %p)},	undef,	"to_unicode\(\'\\u0DCAႫ．5≯︒\\uDB40\\uDD95\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1045\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}Ⴋ．5>\x{0338}︒\x{E0195}", %p)},	undef,	"to_unicode\(\'\\u0DCAႫ．5\>\\u0338︒\\uDB40\\uDD95\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1046\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}Ⴋ.5≯。\x{E0195}", %p)},	undef,	"to_unicode\(\'\\u0DCAႫ\.5≯。\\uDB40\\uDD95\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}Ⴋ.5>\x{0338}。\x{E0195}", %p)},	undef,	"to_unicode\(\'\\u0DCAႫ\.5\>\\u0338。\\uDB40\\uDD95\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}ⴋ.5>\x{0338}。\x{E0195}", %p)},	undef,	"to_unicode\(\'\\u0DCAⴋ\.5\>\\u0338。\\uDB40\\uDD95\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}ⴋ.5≯。\x{E0195}", %p)},	undef,	"to_unicode\(\'\\u0DCAⴋ\.5≯。\\uDB40\\uDD95\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}ⴋ．5>\x{0338}︒\x{E0195}", %p)},	undef,	"to_unicode\(\'\\u0DCAⴋ．5\>\\u0338︒\\uDB40\\uDD95\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}ⴋ．5≯︒\x{E0195}", %p)},	undef,	"to_unicode\(\'\\u0DCAⴋ．5≯︒\\uDB40\\uDD95\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F\x{A806}。\x{2DFA}︒\x{07E6}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u200DF\\uA806。\\u2DFA︒\\u07E6\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F\x{A806}。\x{2DFA}︒\x{07E6}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u200DF\\uA806。\\u2DFA︒\\u07E6\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F\x{A806}。\x{2DFA}。\x{07E6}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u200DF\\uA806。\\u2DFA。\\u07E6\\uD803\\uDE75\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}F\x{A806}。\x{2DFA}。\x{07E6}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u200DF\\uA806。\\u2DFA。\\u07E6\\uD803\\uDE75\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f\x{A806}。\x{2DFA}。\x{07E6}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u200Df\\uA806。\\u2DFA。\\u07E6\\uD803\\uDE75\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f\x{A806}。\x{2DFA}。\x{07E6}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u200Df\\uA806。\\u2DFA。\\u07E6\\uD803\\uDE75\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f\x{A806}。\x{2DFA}︒\x{07E6}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u200Df\\uA806。\\u2DFA︒\\u07E6\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}f\x{A806}。\x{2DFA}︒\x{07E6}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u200Df\\uA806。\\u2DFA︒\\u07E6\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1060\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068C}𝟖\x{FC29}︒｡\x{10E77}\x{17D2}", %p)},	undef,	"to_unicode\(\'\\u068C𝟖\\uFC29︒｡\\uD803\\uDE77\\u17D2\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:1061\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{068C}8\x{0639}\x{062C}。。\x{10E77}\x{17D2}", %p)},	undef,	"to_unicode\(\'\\u068C8\\u0639\\u062C。。\\uD803\\uDE77\\u17D2\'\)\ throws\ error\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1062\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FCDF}.\x{E01B6}\x{0650}\x{08BB}", %p)},	undef,	"to_unicode\(\'\\uFCDF\.\\uDB40\\uDDB6\\u0650\\u08BB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1063\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0626}\x{0645}.\x{E01B6}\x{0650}\x{08BB}", %p)},	undef,	"to_unicode\(\'\\u0626\\u0645\.\\uDB40\\uDDB6\\u0650\\u08BB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1064\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{064A}\x{0654}\x{0645}.\x{E01B6}\x{0650}\x{08BB}", %p)},	undef,	"to_unicode\(\'\\u064A\\u0654\\u0645\.\\uDB40\\uDDB6\\u0650\\u08BB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1065\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴂ䠺。\x{0683}\x{DB798}\x{5A942}\x{084A}", %p)},	undef,	"to_unicode\(\'Ⴂ䠺。\\u0683\\uDB2D\\uDF98\\uD92A\\uDD42\\u084A\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1066\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴂ䠺。\x{0683}\x{DB798}\x{5A942}\x{084A}", %p)},	undef,	"to_unicode\(\'ⴂ䠺。\\u0683\\uDB2D\\uDF98\\uD92A\\uDD42\\u084A\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1067\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟚伐︒.\x{85C24}\x{0A4D}", %p)},	undef,	"to_unicode\(\'𝟚伐︒\.\\uD9D7\\uDC24\\u0A4D\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1068\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("2伐。.\x{85C24}\x{0A4D}", %p)},	undef,	"to_unicode\(\'2伐。\.\\uD9D7\\uDC24\\u0A4D\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1069\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E79}\x{0B4D}\x{E001B}。\x{200D}\x{07DC}Ⴚ\x{1039}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE79\\u0B4D\\uDB40\\uDC1B。\\u200D\\u07DCႺ\\u1039\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1070\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E79}\x{0B4D}\x{E001B}。\x{200D}\x{07DC}Ⴚ\x{1039}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE79\\u0B4D\\uDB40\\uDC1B。\\u200D\\u07DCႺ\\u1039\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1071\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E79}\x{0B4D}\x{E001B}。\x{200D}\x{07DC}ⴚ\x{1039}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE79\\u0B4D\\uDB40\\uDC1B。\\u200D\\u07DCⴚ\\u1039\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1072\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{10E79}\x{0B4D}\x{E001B}。\x{200D}\x{07DC}ⴚ\x{1039}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD803\\uDE79\\u0B4D\\uDB40\\uDC1B。\\u200D\\u07DCⴚ\\u1039\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1073\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0A70}．\x{1AAC0}\x{666A4}", %p)},	undef,	"to_unicode\(\'\\u0A70．\\uD82A\\uDEC0\\uD959\\uDEA4\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1074\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0A70}.\x{1AAC0}\x{666A4}", %p)},	undef,	"to_unicode\(\'\\u0A70\.\\uD82A\\uDEC0\\uD959\\uDEA4\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1075\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡰ\x{200C}Ⴆ.≠\x{10F03}", %p)},	undef,	"to_unicode\(\'ꡰ\\u200CႦ\.≠\\uD803\\uDF03\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1076\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡰ\x{200C}Ⴆ.≠\x{10F03}", %p)},	undef,	"to_unicode\(\'ꡰ\\u200CႦ\.≠\\uD803\\uDF03\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1077\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡰ\x{200C}Ⴆ.=\x{0338}\x{10F03}", %p)},	undef,	"to_unicode\(\'ꡰ\\u200CႦ\.\=\\u0338\\uD803\\uDF03\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1078\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡰ\x{200C}Ⴆ.=\x{0338}\x{10F03}", %p)},	undef,	"to_unicode\(\'ꡰ\\u200CႦ\.\=\\u0338\\uD803\\uDF03\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1079\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡰ\x{200C}ⴆ.=\x{0338}\x{10F03}", %p)},	undef,	"to_unicode\(\'ꡰ\\u200Cⴆ\.\=\\u0338\\uD803\\uDF03\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1080\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡰ\x{200C}ⴆ.=\x{0338}\x{10F03}", %p)},	undef,	"to_unicode\(\'ꡰ\\u200Cⴆ\.\=\\u0338\\uD803\\uDF03\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1081\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡰ\x{200C}ⴆ.≠\x{10F03}", %p)},	undef,	"to_unicode\(\'ꡰ\\u200Cⴆ\.≠\\uD803\\uDF03\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1082\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡰ\x{200C}ⴆ.≠\x{10F03}", %p)},	undef,	"to_unicode\(\'ꡰ\\u200Cⴆ\.≠\\uD803\\uDF03\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1083\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1030}\x{14A04}₀ꘌ．\x{067F}", %p)},	undef,	"to_unicode\(\'\\u1030\\uD812\\uDE04₀ꘌ．\\u067F\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1084\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1030}\x{14A04}0ꘌ.\x{067F}", %p)},	undef,	"to_unicode\(\'\\u1030\\uD812\\uDE040ꘌ\.\\u067F\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1085\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.\x{07F0}\x{BC92C}-", %p)},	undef,	"to_unicode\(\'\-\.\\u07F0\\uDAB2\\uDD2C\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:1086\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}｡\x{200C}\x{1EC50}ς", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C｡\\u200C\\uD83B\\uDC50ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1087\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}｡\x{200C}\x{1EC50}ς", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C｡\\u200C\\uD83B\\uDC50ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1088\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}。\x{200C}\x{1EC50}ς", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C。\\u200C\\uD83B\\uDC50ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1089\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}。\x{200C}\x{1EC50}ς", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C。\\u200C\\uD83B\\uDC50ς\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1090\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}。\x{200C}\x{1EC50}Σ", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C。\\u200C\\uD83B\\uDC50Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1091\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}。\x{200C}\x{1EC50}Σ", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C。\\u200C\\uD83B\\uDC50Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1092\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}。\x{200C}\x{1EC50}σ", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C。\\u200C\\uD83B\\uDC50σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1093\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}。\x{200C}\x{1EC50}σ", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C。\\u200C\\uD83B\\uDC50σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1094\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}｡\x{200C}\x{1EC50}Σ", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C｡\\u200C\\uD83B\\uDC50Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1095\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}｡\x{200C}\x{1EC50}Σ", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C｡\\u200C\\uD83B\\uDC50Σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1096\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}｡\x{200C}\x{1EC50}σ", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C｡\\u200C\\uD83B\\uDC50σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1097\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7227F}\x{200C}｡\x{200C}\x{1EC50}σ", %p)},	undef,	"to_unicode\(\'\\uD988\\uDE7F\\u200C｡\\u200C\\uD83B\\uDC50σ\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1098\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("堕\x{094D}\x{E0A2D}。\x{07D8}\x{0722}\x{200C}-", %p)},	undef,	"to_unicode\(\'堕\\u094D\\uDB42\\uDE2D。\\u07D8\\u0722\\u200C\-\'\)\ throws\ error\ P1\ V6\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1099\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("堕\x{094D}\x{E0A2D}。\x{07D8}\x{0722}\x{200C}-", %p)},	undef,	"to_unicode\(\'堕\\u094D\\uDB42\\uDE2D。\\u07D8\\u0722\\u200C\-\'\)\ throws\ error\ P1\ V6\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1100\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}｡\x{07E9}ς\x{0847}ς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726｡\\u07E9ς\\u0847ς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1101\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}。\x{07E9}ς\x{0847}ς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726。\\u07E9ς\\u0847ς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1102\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}。\x{07E9}Σ\x{0847}Σ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726。\\u07E9Σ\\u0847Σ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1103\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}。\x{07E9}σ\x{0847}σ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726。\\u07E9σ\\u0847σ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1104\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}。\x{07E9}Σ\x{0847}σ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726。\\u07E9Σ\\u0847σ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1105\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}。\x{07E9}Σ\x{0847}ς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726。\\u07E9Σ\\u0847ς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1106\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}。\x{07E9}σ\x{0847}ς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726。\\u07E9σ\\u0847ς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1107\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}｡\x{07E9}Σ\x{0847}Σ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726｡\\u07E9Σ\\u0847Σ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1108\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}｡\x{07E9}σ\x{0847}σ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726｡\\u07E9σ\\u0847σ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1109\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}｡\x{07E9}Σ\x{0847}σ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726｡\\u07E9Σ\\u0847σ\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1110\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}｡\x{07E9}Σ\x{0847}ς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726｡\\u07E9Σ\\u0847ς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1111\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{AAF6}ᢤ\x{0726}｡\x{07E9}σ\x{0847}ς", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\uAAF6ᢤ\\u0726｡\\u07E9σ\\u0847ς\'\)\ throws\ error\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:1112\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{BBB8C}．-5ß", %p)},	undef,	"to_unicode\(\'\\uDAAE\\uDF8C．\-5ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1113\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{BBB8C}.-5ß", %p)},	undef,	"to_unicode\(\'\\uDAAE\\uDF8C\.\-5ß\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1114\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{BBB8C}.-5SS", %p)},	undef,	"to_unicode\(\'\\uDAAE\\uDF8C\.\-5SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1115\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{BBB8C}．-5SS", %p)},	undef,	"to_unicode\(\'\\uDAAE\\uDF8C．\-5SS\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1116\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{A806}.\x{0FA6}Ⴥ\x{15445}", %p)},	undef,	"to_unicode\(\'\\u200D\\uA806\.\\u0FA6Ⴥ\\uD815\\uDC45\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1117\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{A806}.\x{0FA6}Ⴥ\x{15445}", %p)},	undef,	"to_unicode\(\'\\u200D\\uA806\.\\u0FA6Ⴥ\\uD815\\uDC45\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1118\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{A806}.\x{0FA6}ⴥ\x{15445}", %p)},	undef,	"to_unicode\(\'\\u200D\\uA806\.\\u0FA6ⴥ\\uD815\\uDC45\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1119\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{A806}.\x{0FA6}ⴥ\x{15445}", %p)},	undef,	"to_unicode\(\'\\u200D\\uA806\.\\u0FA6ⴥ\\uD815\\uDC45\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1120\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DEA33}。ß樲\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB3A\\uDE33。ß樲\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1121\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DEA33}。ß樲\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB3A\\uDE33。ß樲\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1122\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DEA33}。SS樲\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB3A\\uDE33。SS樲\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1123\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DEA33}。SS樲\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB3A\\uDE33。SS樲\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1124\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DEA33}。ss樲\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB3A\\uDE33。ss樲\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1125\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DEA33}。ss樲\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB3A\\uDE33。ss樲\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1126\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DEA33}。Ss樲\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB3A\\uDE33。Ss樲\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1127\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DEA33}。Ss樲\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB3A\\uDE33。Ss樲\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1128\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1413C}。\x{FE24}\x{E0BE1}\x{10CD0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD810\\uDD3C。\\uFE24\\uDB42\\uDFE1\\uD803\\uDCD0\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:1129\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1413C}。\x{FE24}\x{E0BE1}\x{10CD0}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD810\\uDD3C。\\uFE24\\uDB42\\uDFE1\\uD803\\uDCD0\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:1130\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{109FD}\x{200C}\x{0735}。\x{0602}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDDFD\\u200C\\u0735。\\u0602\'\)\ throws\ error\ P1\ V6\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1131\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{109FD}\x{200C}\x{0735}。\x{0602}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDDFD\\u200C\\u0735。\\u0602\'\)\ throws\ error\ P1\ V6\ B3\ C1\ B1\ \[data\/IdnaTest\.txt\:1132\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}ς≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4ς≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1133\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}ς≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4ς≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1134\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4ς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1135\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4ς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1136\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}ς≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4ς≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1137\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}ς≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4ς≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1138\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4ς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1139\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}ς=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4ς\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1140\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4Σ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1141\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4Σ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1142\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}Σ≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4Σ≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1143\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}Σ≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4Σ≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1144\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}σ≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4σ≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1145\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}σ≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4σ≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1146\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4σ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1147\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}。\x{111C0}\x{0FB4}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7。\\uD804\\uDDC0\\u0FB4σ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1148\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4Σ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1149\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}Σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4Σ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1150\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}Σ≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4Σ≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1151\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}Σ≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4Σ≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1152\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}σ≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4σ≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1153\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}σ≠", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4σ≠\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1154\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4σ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1155\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{202B}\x{90739}\x{200C}\x{E0CD7}｡\x{111C0}\x{0FB4}σ=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u202B\\uDA01\\uDF39\\u200C\\uDB43\\uDCD7｡\\uD804\\uDDC0\\u0FB4σ\=\\u0338\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1156\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("６｡⒈\x{200D}\x{1B4F1}", %p)},	undef,	"to_unicode\(\'６｡⒈\\u200D\\uD82D\\uDCF1\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1157\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("６｡⒈\x{200D}\x{1B4F1}", %p)},	undef,	"to_unicode\(\'６｡⒈\\u200D\\uD82D\\uDCF1\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1158\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("6。1.\x{200D}\x{1B4F1}", %p)},	undef,	"to_unicode\(\'6。1\.\\u200D\\uD82D\\uDCF1\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1159\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("6。1.\x{200D}\x{1B4F1}", %p)},	undef,	"to_unicode\(\'6。1\.\\u200D\\uD82D\\uDCF1\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1160\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠬß｡\x{1773}\x{0B4D}\x{50852}\x{06A0}", %p)},	undef,	"to_unicode\(\'ᠬß｡\\u1773\\u0B4D\\uD902\\uDC52\\u06A0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1161\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠬß。\x{1773}\x{0B4D}\x{50852}\x{06A0}", %p)},	undef,	"to_unicode\(\'ᠬß。\\u1773\\u0B4D\\uD902\\uDC52\\u06A0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1162\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠬSS。\x{1773}\x{0B4D}\x{50852}\x{06A0}", %p)},	undef,	"to_unicode\(\'ᠬSS。\\u1773\\u0B4D\\uD902\\uDC52\\u06A0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1163\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠬss。\x{1773}\x{0B4D}\x{50852}\x{06A0}", %p)},	undef,	"to_unicode\(\'ᠬss。\\u1773\\u0B4D\\uD902\\uDC52\\u06A0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1164\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠬSs。\x{1773}\x{0B4D}\x{50852}\x{06A0}", %p)},	undef,	"to_unicode\(\'ᠬSs。\\u1773\\u0B4D\\uD902\\uDC52\\u06A0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1165\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠬSS｡\x{1773}\x{0B4D}\x{50852}\x{06A0}", %p)},	undef,	"to_unicode\(\'ᠬSS｡\\u1773\\u0B4D\\uD902\\uDC52\\u06A0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1166\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠬss｡\x{1773}\x{0B4D}\x{50852}\x{06A0}", %p)},	undef,	"to_unicode\(\'ᠬss｡\\u1773\\u0B4D\\uD902\\uDC52\\u06A0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1167\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠬSs｡\x{1773}\x{0B4D}\x{50852}\x{06A0}", %p)},	undef,	"to_unicode\(\'ᠬSs｡\\u1773\\u0B4D\\uD902\\uDC52\\u06A0\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1168\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0666}\x{17D2}\x{593A5}.\x{0AE2}\x{0F93}\x{1A60}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u0666\\u17D2\\uD924\\uDFA5\.\\u0AE2\\u0F93\\u1A60\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1169\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0666}\x{17D2}\x{593A5}.\x{0AE2}\x{0F92}\x{0FB7}\x{1A60}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u0666\\u17D2\\uD924\\uDFA5\.\\u0AE2\\u0F92\\u0FB7\\u1A60\\u0D4D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1170\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴓ\x{ABED}\x{200D}\x{34F17}．ᠹ\x{E0077}", %p)},	undef,	"to_unicode\(\'Ⴓ\\uABED\\u200D\\uD893\\uDF17．ᠹ\\uDB40\\uDC77\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1171\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴓ\x{ABED}\x{200D}\x{34F17}.ᠹ\x{E0077}", %p)},	undef,	"to_unicode\(\'Ⴓ\\uABED\\u200D\\uD893\\uDF17\.ᠹ\\uDB40\\uDC77\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1172\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴓ\x{ABED}\x{200D}\x{34F17}.ᠹ\x{E0077}", %p)},	undef,	"to_unicode\(\'ⴓ\\uABED\\u200D\\uD893\\uDF17\.ᠹ\\uDB40\\uDC77\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1173\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴓ\x{ABED}\x{200D}\x{34F17}．ᠹ\x{E0077}", %p)},	undef,	"to_unicode\(\'ⴓ\\uABED\\u200D\\uD893\\uDF17．ᠹ\\uDB40\\uDC77\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1174\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A9C0}.𝟕\x{E0126}", %p)},	undef,	"to_unicode\(\'\\uA9C0\.𝟕\\uDB40\\uDD26\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1175\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}.7\x{E0126}", %p)},	undef,	"to_unicode\(\'\\uA9C0\.7\\uDB40\\uDD26\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1176\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{539F1}\x{FCF44}𝟗。\x{206E}-", %p)},	undef,	"to_unicode\(\'\\uD90E\\uDDF1\\uDBB3\\uDF44𝟗。\\u206E\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1177\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{539F1}\x{FCF44}9。\x{206E}-", %p)},	undef,	"to_unicode\(\'\\uD90E\\uDDF1\\uDBB3\\uDF449。\\u206E\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1178\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1AE33}ᠩ\x{10E69}。\x{10E79}\x{0631}\x{0684}", %p)},	undef,	"to_unicode\(\'\\uD82B\\uDE33ᠩ\\uD803\\uDE69。\\uD803\\uDE79\\u0631\\u0684\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:1179\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}ᡒႾ₈.⤴\x{06B0}\x{A9053}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DᡒႾ₈\.⤴\\u06B0\\uDA64\\uDC53\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1180\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}ᡒႾ₈.⤴\x{06B0}\x{A9053}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DᡒႾ₈\.⤴\\u06B0\\uDA64\\uDC53\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1181\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}ᡒႾ8.⤴\x{06B0}\x{A9053}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DᡒႾ8\.⤴\\u06B0\\uDA64\\uDC53\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1182\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}ᡒႾ8.⤴\x{06B0}\x{A9053}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200DᡒႾ8\.⤴\\u06B0\\uDA64\\uDC53\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1183\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}ᡒⴞ8.⤴\x{06B0}\x{A9053}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dᡒⴞ8\.⤴\\u06B0\\uDA64\\uDC53\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1184\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}ᡒⴞ8.⤴\x{06B0}\x{A9053}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dᡒⴞ8\.⤴\\u06B0\\uDA64\\uDC53\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1185\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}ᡒⴞ₈.⤴\x{06B0}\x{A9053}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dᡒⴞ₈\.⤴\\u06B0\\uDA64\\uDC53\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1186\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}ᡒⴞ₈.⤴\x{06B0}\x{A9053}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200Dᡒⴞ₈\.⤴\\u06B0\\uDA64\\uDC53\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B1\ C1\ \[data\/IdnaTest\.txt\:1187\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6A}ᠮ．\x{0E3A}\x{7BCB7}⾆", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Aᠮ．\\u0E3A\\uD9AF\\uDCB7⾆\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1188\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6A}ᠮ.\x{0E3A}\x{7BCB7}舌", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6Aᠮ\.\\u0E3A\\uD9AF\\uDCB7舌\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1189\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE06}⌆\x{8DF53}.\x{76578}", %p)},	undef,	"to_unicode\(\'\\uFE06⌆\\uD9F7\\uDF53\.\\uD999\\uDD78\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1190\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0735}\x{8B6EA}-죀.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0735\\uD9ED\\uDEEA\-죀\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1191\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0735}\x{8B6EA}-죀.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0735\\uD9ED\\uDEEA\-죀\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1192\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0735}\x{8B6EA}-죀.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0735\\uD9ED\\uDEEA\-죀\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1193\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0735}\x{8B6EA}-죀.4Ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0735\\uD9ED\\uDEEA\-죀\.4Ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1194\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0735}\x{8B6EA}-죀.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0735\\uD9ED\\uDEEA\-죀\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1195\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0735}\x{8B6EA}-죀.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0735\\uD9ED\\uDEEA\-죀\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1196\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0735}\x{8B6EA}-죀.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0735\\uD9ED\\uDEEA\-죀\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1197\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0735}\x{8B6EA}-죀.4ⴄ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0735\\uD9ED\\uDEEA\-죀\.4ⴄ\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:1198\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᚭ｡\x{E0BBD}ß\x{1D1AA}", %p)},	undef,	"to_unicode\(\'ᚭ｡\\uDB42\\uDFBDß\\uD834\\uDDAA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1199\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᚭ。\x{E0BBD}ß\x{1D1AA}", %p)},	undef,	"to_unicode\(\'ᚭ。\\uDB42\\uDFBDß\\uD834\\uDDAA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1200\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᚭ。\x{E0BBD}SS\x{1D1AA}", %p)},	undef,	"to_unicode\(\'ᚭ。\\uDB42\\uDFBDSS\\uD834\\uDDAA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1201\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᚭ。\x{E0BBD}ss\x{1D1AA}", %p)},	undef,	"to_unicode\(\'ᚭ。\\uDB42\\uDFBDss\\uD834\\uDDAA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1202\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᚭ。\x{E0BBD}Ss\x{1D1AA}", %p)},	undef,	"to_unicode\(\'ᚭ。\\uDB42\\uDFBDSs\\uD834\\uDDAA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1203\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᚭ｡\x{E0BBD}SS\x{1D1AA}", %p)},	undef,	"to_unicode\(\'ᚭ｡\\uDB42\\uDFBDSS\\uD834\\uDDAA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1204\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᚭ｡\x{E0BBD}ss\x{1D1AA}", %p)},	undef,	"to_unicode\(\'ᚭ｡\\uDB42\\uDFBDss\\uD834\\uDDAA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1205\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᚭ｡\x{E0BBD}Ss\x{1D1AA}", %p)},	undef,	"to_unicode\(\'ᚭ｡\\uDB42\\uDFBDSs\\uD834\\uDDAA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1206\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("０｡\x{08A4}ꡞ", %p)},	undef,	"to_unicode\(\'０｡\\u08A4ꡞ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1207\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("0。\x{08A4}ꡞ", %p)},	undef,	"to_unicode\(\'0。\\u08A4ꡞ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1208\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{144FD}\x{200C}.\x{087F}麷\x{E8D37}", %p)},	undef,	"to_unicode\(\'\\uD811\\uDCFD\\u200C\.\\u087F麷\\uDB63\\uDD37\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1209\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{144FD}\x{200C}.\x{087F}麷\x{E8D37}", %p)},	undef,	"to_unicode\(\'\\uD811\\uDCFD\\u200C\.\\u087F麷\\uDB63\\uDD37\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1210\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{035B}≯｡\x{E061D}", %p)},	undef,	"to_unicode\(\'\\u035B≯｡\\uDB41\\uDE1D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1211\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{035B}>\x{0338}｡\x{E061D}", %p)},	undef,	"to_unicode\(\'\\u035B\>\\u0338｡\\uDB41\\uDE1D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1212\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{035B}≯。\x{E061D}", %p)},	undef,	"to_unicode\(\'\\u035B≯。\\uDB41\\uDE1D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1213\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{035B}>\x{0338}。\x{E061D}", %p)},	undef,	"to_unicode\(\'\\u035B\>\\u0338。\\uDB41\\uDE1D\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1214\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴋ≮\x{104620}。\x{200D}\x{E016B}۹", %p)},	undef,	"to_unicode\(\'Ⴋ≮\\uDBD1\\uDE20。\\u200D\\uDB40\\uDD6B۹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1215\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ≮\x{104620}。\x{200D}\x{E016B}۹", %p)},	undef,	"to_unicode\(\'Ⴋ≮\\uDBD1\\uDE20。\\u200D\\uDB40\\uDD6B۹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1216\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ<\x{0338}\x{104620}。\x{200D}\x{E016B}۹", %p)},	undef,	"to_unicode\(\'Ⴋ\<\\u0338\\uDBD1\\uDE20。\\u200D\\uDB40\\uDD6B۹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1217\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴋ<\x{0338}\x{104620}。\x{200D}\x{E016B}۹", %p)},	undef,	"to_unicode\(\'Ⴋ\<\\u0338\\uDBD1\\uDE20。\\u200D\\uDB40\\uDD6B۹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1218\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ<\x{0338}\x{104620}。\x{200D}\x{E016B}۹", %p)},	undef,	"to_unicode\(\'ⴋ\<\\u0338\\uDBD1\\uDE20。\\u200D\\uDB40\\uDD6B۹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1219\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ<\x{0338}\x{104620}。\x{200D}\x{E016B}۹", %p)},	undef,	"to_unicode\(\'ⴋ\<\\u0338\\uDBD1\\uDE20。\\u200D\\uDB40\\uDD6B۹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1220\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ≮\x{104620}。\x{200D}\x{E016B}۹", %p)},	undef,	"to_unicode\(\'ⴋ≮\\uDBD1\\uDE20。\\u200D\\uDB40\\uDD6B۹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1221\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴋ≮\x{104620}。\x{200D}\x{E016B}۹", %p)},	undef,	"to_unicode\(\'ⴋ≮\\uDBD1\\uDE20。\\u200D\\uDB40\\uDD6B۹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1222\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0B4D}.\x{72EEA}≯", %p)},	undef,	"to_unicode\(\'\\u0B4D\.\\uD98B\\uDEEA≯\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1223\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0B4D}.\x{72EEA}>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0B4D\.\\uD98B\\uDEEA\>\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1224\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0BF9}\x{1BF3}．\x{1921}É\x{1D168}\x{1BAB}", %p)},	undef,	"to_unicode\(\'\\uDAC2\\uDFF9\\u1BF3．\\u1921É\\uD834\\uDD68\\u1BAB\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1225\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0BF9}\x{1BF3}．\x{1921}E\x{1D168}\x{1BAB}\x{0301}", %p)},	undef,	"to_unicode\(\'\\uDAC2\\uDFF9\\u1BF3．\\u1921E\\uD834\\uDD68\\u1BAB\\u0301\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1226\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0BF9}\x{1BF3}.\x{1921}É\x{1D168}\x{1BAB}", %p)},	undef,	"to_unicode\(\'\\uDAC2\\uDFF9\\u1BF3\.\\u1921É\\uD834\\uDD68\\u1BAB\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1227\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0BF9}\x{1BF3}.\x{1921}E\x{1D168}\x{1BAB}\x{0301}", %p)},	undef,	"to_unicode\(\'\\uDAC2\\uDFF9\\u1BF3\.\\u1921E\\uD834\\uDD68\\u1BAB\\u0301\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1228\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0BF9}\x{1BF3}.\x{1921}e\x{1D168}\x{1BAB}\x{0301}", %p)},	undef,	"to_unicode\(\'\\uDAC2\\uDFF9\\u1BF3\.\\u1921e\\uD834\\uDD68\\u1BAB\\u0301\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1229\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0BF9}\x{1BF3}.\x{1921}é\x{1D168}\x{1BAB}", %p)},	undef,	"to_unicode\(\'\\uDAC2\\uDFF9\\u1BF3\.\\u1921é\\uD834\\uDD68\\u1BAB\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1230\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0BF9}\x{1BF3}．\x{1921}e\x{1D168}\x{1BAB}\x{0301}", %p)},	undef,	"to_unicode\(\'\\uDAC2\\uDFF9\\u1BF3．\\u1921e\\uD834\\uDD68\\u1BAB\\u0301\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1231\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0BF9}\x{1BF3}．\x{1921}é\x{1D168}\x{1BAB}", %p)},	undef,	"to_unicode\(\'\\uDAC2\\uDFF9\\u1BF3．\\u1921é\\uD834\\uDD68\\u1BAB\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1232\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡔ\x{200D}\x{0E3A}｡︒\x{08A0}", %p)},	undef,	"to_unicode\(\'ᡔ\\u200D\\u0E3A｡︒\\u08A0\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1233\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡔ\x{200D}\x{0E3A}｡︒\x{08A0}", %p)},	undef,	"to_unicode\(\'ᡔ\\u200D\\u0E3A｡︒\\u08A0\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:1234\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡔ\x{200D}\x{0E3A}。。\x{08A0}", %p)},	undef,	"to_unicode\(\'ᡔ\\u200D\\u0E3A。。\\u08A0\'\)\ throws\ error\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1235\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡔ\x{200D}\x{0E3A}。。\x{08A0}", %p)},	undef,	"to_unicode\(\'ᡔ\\u200D\\u0E3A。。\\u08A0\'\)\ throws\ error\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1236\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{069B}\x{84E75}\x{AAF6}\x{200C}｡ᢟ\x{E01A6}≮", %p)},	undef,	"to_unicode\(\'\\u069B\\uD9D3\\uDE75\\uAAF6\\u200C｡ᢟ\\uDB40\\uDDA6≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1237\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{069B}\x{84E75}\x{AAF6}\x{200C}｡ᢟ\x{E01A6}<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u069B\\uD9D3\\uDE75\\uAAF6\\u200C｡ᢟ\\uDB40\\uDDA6\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1238\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{069B}\x{84E75}\x{AAF6}\x{200C}。ᢟ\x{E01A6}≮", %p)},	undef,	"to_unicode\(\'\\u069B\\uD9D3\\uDE75\\uAAF6\\u200C。ᢟ\\uDB40\\uDDA6≮\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1239\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{069B}\x{84E75}\x{AAF6}\x{200C}。ᢟ\x{E01A6}<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u069B\\uD9D3\\uDE75\\uAAF6\\u200C。ᢟ\\uDB40\\uDDA6\<\\u0338\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1240\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴣ．\x{1DC5}\x{0693}", %p)},	undef,	"to_unicode\(\'Ⴣ．\\u1DC5\\u0693\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ.\x{1DC5}\x{0693}", %p)},	undef,	"to_unicode\(\'Ⴣ\.\\u1DC5\\u0693\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ.\x{1DC5}\x{0693}", %p)},	undef,	"to_unicode\(\'ⴣ\.\\u1DC5\\u0693\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ．\x{1DC5}\x{0693}", %p)},	undef,	"to_unicode\(\'ⴣ．\\u1DC5\\u0693\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:1244\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🀽\x{FD4D}．\x{10B5F2}\x{6B40F}Ⴤ\x{E9058}", %p)},	undef,	"to_unicode\(\'🀽\\uFD4D．\\uDBED\\uDDF2\\uD96D\\uDC0FჄ\\uDB64\\uDC58\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1245\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🀽\x{FD4D}.\x{10B5F2}\x{6B40F}Ⴤ\x{E9058}", %p)},	undef,	"to_unicode\(\'🀽\\uFD4D\.\\uDBED\\uDDF2\\uD96D\\uDC0FჄ\\uDB64\\uDC58\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1246\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🀽\x{FD4D}.\x{10B5F2}\x{6B40F}ⴤ\x{E9058}", %p)},	undef,	"to_unicode\(\'🀽\\uFD4D\.\\uDBED\\uDDF2\\uD96D\\uDC0Fⴤ\\uDB64\\uDC58\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1247\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🀽\x{FD4D}．\x{10B5F2}\x{6B40F}ⴤ\x{E9058}", %p)},	undef,	"to_unicode\(\'🀽\\uFD4D．\\uDBED\\uDDF2\\uD96D\\uDC0Fⴤ\\uDB64\\uDC58\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1248\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE0C}\x{E01EB}≮．\x{E0C70}", %p)},	undef,	"to_unicode\(\'\\uFE0C\\uDB40\\uDDEB≮．\\uDB43\\uDC70\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1249\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE0C}\x{E01EB}<\x{0338}．\x{E0C70}", %p)},	undef,	"to_unicode\(\'\\uFE0C\\uDB40\\uDDEB\<\\u0338．\\uDB43\\uDC70\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1250\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE0C}\x{E01EB}≮.\x{E0C70}", %p)},	undef,	"to_unicode\(\'\\uFE0C\\uDB40\\uDDEB≮\.\\uDB43\\uDC70\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1251\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE0C}\x{E01EB}<\x{0338}.\x{E0C70}", %p)},	undef,	"to_unicode\(\'\\uFE0C\\uDB40\\uDDEB\<\\u0338\.\\uDB43\\uDC70\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1252\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}≮Ⴢ．Ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC≮Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1253\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}<\x{0338}Ⴢ．Ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC\<\\u0338Ⴢ．Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1254\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}≮Ⴢ.Ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC≮Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1255\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}<\x{0338}Ⴢ.Ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC\<\\u0338Ⴢ\.Ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1256\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}<\x{0338}ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC\<\\u0338ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1257\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}≮ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC≮ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1258\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}≮Ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC≮Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1259\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}<\x{0338}Ⴢ.ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC\<\\u0338Ⴢ\.ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1260\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}<\x{0338}ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC\<\\u0338ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1261\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}≮ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC≮ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1262\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}≮Ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC≮Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1263\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E77}\x{1ECCC}<\x{0338}Ⴢ．ⴃ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE77\\uD83B\\uDCCC\<\\u0338Ⴢ．ⴃ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1264\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0DD3}。-", %p)},	undef,	"to_unicode\(\'\\u0DD3。\-\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1265\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A8C4}\x{7F225}\x{E0520}｡饈≠\x{10E6A}", %p)},	undef,	"to_unicode\(\'\\uA8C4\\uD9BC\\uDE25\\uDB41\\uDD20｡饈≠\\uD803\\uDE6A\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1266\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A8C4}\x{7F225}\x{E0520}｡饈=\x{0338}\x{10E6A}", %p)},	undef,	"to_unicode\(\'\\uA8C4\\uD9BC\\uDE25\\uDB41\\uDD20｡饈\=\\u0338\\uD803\\uDE6A\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1267\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A8C4}\x{7F225}\x{E0520}。饈≠\x{10E6A}", %p)},	undef,	"to_unicode\(\'\\uA8C4\\uD9BC\\uDE25\\uDB41\\uDD20。饈≠\\uD803\\uDE6A\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1268\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A8C4}\x{7F225}\x{E0520}。饈=\x{0338}\x{10E6A}", %p)},	undef,	"to_unicode\(\'\\uA8C4\\uD9BC\\uDE25\\uDB41\\uDD20。饈\=\\u0338\\uD803\\uDE6A\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1269\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0719}ᡊ４｡≯邅\x{E0036}4", %p)},	undef,	"to_unicode\(\'\\u0719ᡊ４｡≯邅\\uDB40\\uDC364\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1270\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0719}ᡊ４｡>\x{0338}邅\x{E0036}4", %p)},	undef,	"to_unicode\(\'\\u0719ᡊ４｡\>\\u0338邅\\uDB40\\uDC364\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0719}ᡊ4。≯邅\x{E0036}4", %p)},	undef,	"to_unicode\(\'\\u0719ᡊ4。≯邅\\uDB40\\uDC364\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0719}ᡊ4。>\x{0338}邅\x{E0036}4", %p)},	undef,	"to_unicode\(\'\\u0719ᡊ4。\>\\u0338邅\\uDB40\\uDC364\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:1273\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7FE19}ᡳ-\x{07EF}.\x{0667}⒚\x{10E7D}\x{3018B}", %p)},	undef,	"to_unicode\(\'\\uD9BF\\uDE19ᡳ\-\\u07EF\.\\u0667⒚\\uD803\\uDE7D\\uD880\\uDD8B\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1274\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7FE19}ᡳ-\x{07EF}.\x{0667}19.\x{10E7D}\x{3018B}", %p)},	undef,	"to_unicode\(\'\\uD9BF\\uDE19ᡳ\-\\u07EF\.\\u066719\.\\uD803\\uDE7D\\uD880\\uDD8B\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1275\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{B2908}ᠹ\x{1D189}.넨-\x{F51CC}", %p)},	undef,	"to_unicode\(\'\\uDA8A\\uDD08ᠹ\\uD834\\uDD89\.넨\-\\uDB94\\uDDCC\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1276\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{B2908}ᠹ\x{1D189}.넨-\x{F51CC}", %p)},	undef,	"to_unicode\(\'\\uDA8A\\uDD08ᠹ\\uD834\\uDD89\.넨\-\\uDB94\\uDDCC\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1277\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06AB}ᡣ\x{200D}⒈。𝟏-", %p)},	undef,	"to_unicode\(\'\\u06ABᡣ\\u200D⒈。𝟏\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ C2\ \[data\/IdnaTest\.txt\:1278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AB}ᡣ\x{200D}⒈。𝟏-", %p)},	undef,	"to_unicode\(\'\\u06ABᡣ\\u200D⒈。𝟏\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ C2\ \[data\/IdnaTest\.txt\:1279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AB}ᡣ\x{200D}1.。1-", %p)},	undef,	"to_unicode\(\'\\u06ABᡣ\\u200D1\.。1\-\'\)\ throws\ error\ V3\ B2\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06AB}ᡣ\x{200D}1.。1-", %p)},	undef,	"to_unicode\(\'\\u06ABᡣ\\u200D1\.。1\-\'\)\ throws\ error\ V3\ B2\ C2\ A4_2\ \[data\/IdnaTest\.txt\:1281\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴌ。\x{42924}\x{10C42}", %p)},	undef,	"to_unicode\(\'Ⴌ。\\uD8CA\\uDD24\\uD803\\uDC42\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1282\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴌ。\x{42924}\x{10C42}", %p)},	undef,	"to_unicode\(\'ⴌ。\\uD8CA\\uDD24\\uD803\\uDC42\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1283\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢜ\x{FC90}.\x{A806}\x{E01BB}-\x{128AD}", %p)},	undef,	"to_unicode\(\'ᢜ\\uFC90\.\\uA806\\uDB40\\uDDBB\-\\uD80A\\uDCAD\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1284\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢜ\x{0649}\x{0670}.\x{A806}\x{E01BB}-\x{128AD}", %p)},	undef,	"to_unicode\(\'ᢜ\\u0649\\u0670\.\\uA806\\uDB40\\uDDBB\-\\uD80A\\uDCAD\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1285\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{592AE}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈\\uD924\\uDEAE\\u200D\-。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1286\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{592AE}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈\\uD924\\uDEAE\\u200D\-。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1287\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{592AE}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈\\uD924\\uDEAE\\u200D\-。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1288\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{592AE}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'⒈\\uD924\\uDEAE\\u200D\-。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1289\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{592AE}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.\\uD924\\uDEAE\\u200D\-。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1290\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{592AE}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.\\uD924\\uDEAE\\u200D\-。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1291\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{592AE}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.\\uD924\\uDEAE\\u200D\-。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1292\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{592AE}\x{200D}-。웈", %p)},	undef,	"to_unicode\(\'1\.\\uD924\\uDEAE\\u200D\-。웈\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:1293\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("て。\x{200C}\x{07F0}\x{A8E1}", %p)},	undef,	"to_unicode\(\'て。\\u200C\\u07F0\\uA8E1\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:1294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("て。\x{200C}\x{07F0}\x{A8E1}", %p)},	undef,	"to_unicode\(\'て。\\u200C\\u07F0\\uA8E1\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:1295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς｡\x{0CCD}\x{0BC0}", %p)},	undef,	"to_unicode\(\'ς｡\\u0CCD\\u0BC0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς。\x{0CCD}\x{0BC0}", %p)},	undef,	"to_unicode\(\'ς。\\u0CCD\\u0BC0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ。\x{0CCD}\x{0BC0}", %p)},	undef,	"to_unicode\(\'Σ。\\u0CCD\\u0BC0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ。\x{0CCD}\x{0BC0}", %p)},	undef,	"to_unicode\(\'σ。\\u0CCD\\u0BC0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ｡\x{0CCD}\x{0BC0}", %p)},	undef,	"to_unicode\(\'Σ｡\\u0CCD\\u0BC0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ｡\x{0CCD}\x{0BC0}", %p)},	undef,	"to_unicode\(\'σ｡\\u0CCD\\u0BC0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1301\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A806}\x{C9B09}\x{A5208}.ႢႵ", %p)},	undef,	"to_unicode\(\'\\uA806\\uDAE6\\uDF09\\uDA54\\uDE08\.ႢႵ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1302\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A806}\x{C9B09}\x{A5208}.ⴂⴕ", %p)},	undef,	"to_unicode\(\'\\uA806\\uDAE6\\uDF09\\uDA54\\uDE08\.ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1303\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A806}\x{C9B09}\x{A5208}.Ⴂⴕ", %p)},	undef,	"to_unicode\(\'\\uA806\\uDAE6\\uDF09\\uDA54\\uDE08\.Ⴂⴕ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1304\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0A58}𝟖⾛\x{1BE9}．\x{200D}\x{67B78}\x{10CFE}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE58𝟖⾛\\u1BE9．\\u200D\\uD95E\\uDF78\\uD803\\uDCFE\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1305\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0A58}𝟖⾛\x{1BE9}．\x{200D}\x{67B78}\x{10CFE}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE58𝟖⾛\\u1BE9．\\u200D\\uD95E\\uDF78\\uD803\\uDCFE\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1306\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0A58}8走\x{1BE9}.\x{200D}\x{67B78}\x{10CFE}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE588走\\u1BE9\.\\u200D\\uD95E\\uDF78\\uD803\\uDCFE\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1307\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0A58}8走\x{1BE9}.\x{200D}\x{67B78}\x{10CFE}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDE588走\\u1BE9\.\\u200D\\uD95E\\uDF78\\uD803\\uDCFE\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1308\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{084E}｡Ӏ\x{712A9}", %p)},	undef,	"to_unicode\(\'\\u084E｡Ӏ\\uD984\\uDEA9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1309\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{084E}。Ӏ\x{712A9}", %p)},	undef,	"to_unicode\(\'\\u084E。Ӏ\\uD984\\uDEA9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1310\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{084E}。ӏ\x{712A9}", %p)},	undef,	"to_unicode\(\'\\u084E。ӏ\\uD984\\uDEA9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1311\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{084E}｡ӏ\x{712A9}", %p)},	undef,	"to_unicode\(\'\\u084E｡ӏ\\uD984\\uDEA9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1312\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7A}-。\x{C489F}\x{E034E}ᄾ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7A\-。\\uDAD2\\uDC9F\\uDB40\\uDF4Eᄾ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1313\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-₆\x{0F95}。\x{0B3F}", %p)},	undef,	"to_unicode\(\'\-₆\\u0F95。\\u0B3F\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-6\x{0F95}。\x{0B3F}", %p)},	undef,	"to_unicode\(\'\-6\\u0F95。\\u0B3F\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1315\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{10E71}\x{E0EC8}멈.\x{09CD}\x{718A4}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE71\\uDB43\\uDEC8멈\.\\u09CD\\uD986\\uDCA4\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:1316\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{10E71}\x{E0EC8}멈.\x{09CD}\x{718A4}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE71\\uDB43\\uDEC8멈\.\\u09CD\\uD986\\uDCA4\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:1317\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{10E71}\x{E0EC8}멈.\x{09CD}\x{718A4}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE71\\uDB43\\uDEC8멈\.\\u09CD\\uD986\\uDCA4\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:1318\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{10E71}\x{E0EC8}멈.\x{09CD}\x{718A4}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE71\\uDB43\\uDEC8멈\.\\u09CD\\uD986\\uDCA4\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:1319\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮.\x{06D3}\x{10E77}", %p)},	undef,	"to_unicode\(\'≮\.\\u06D3\\uD803\\uDE77\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1320\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.\x{06D2}\x{0654}\x{10E77}", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\\u06D2\\u0654\\uD803\\uDE77\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1321\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10C39}⾆｡\x{200C}\x{0ACD}\x{B9E17}\x{108DA}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC39⾆｡\\u200C\\u0ACD\\uDAA7\\uDE17\\uD802\\uDCDA\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1322\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10C39}⾆｡\x{200C}\x{0ACD}\x{B9E17}\x{108DA}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC39⾆｡\\u200C\\u0ACD\\uDAA7\\uDE17\\uD802\\uDCDA\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1323\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10C39}舌。\x{200C}\x{0ACD}\x{B9E17}\x{108DA}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC39舌。\\u200C\\u0ACD\\uDAA7\\uDE17\\uD802\\uDCDA\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1324\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10C39}舌。\x{200C}\x{0ACD}\x{B9E17}\x{108DA}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC39舌。\\u200C\\u0ACD\\uDAA7\\uDE17\\uD802\\uDCDA\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:1325\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}Ⴠ-.9ς\x{10F8C}ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.9ς\\uD803\\uDF8Cς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1326\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}Ⴠ-.9ς\x{10F8C}ς", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.9ς\\uD803\\uDF8Cς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1327\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ⴠ-.9ς\x{10F8C}ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.9ς\\uD803\\uDF8Cς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1328\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ⴠ-.9ς\x{10F8C}ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.9ς\\uD803\\uDF8Cς\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1329\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}Ⴠ-.9Σ\x{10F8C}Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.9Σ\\uD803\\uDF8CΣ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1330\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}Ⴠ-.9Σ\x{10F8C}Σ", %p)},	undef,	"to_unicode\(\'\\u200CჀ\-\.9Σ\\uD803\\uDF8CΣ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1331\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ⴠ-.9σ\x{10F8C}σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.9σ\\uD803\\uDF8Cσ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1332\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ⴠ-.9σ\x{10F8C}σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴠ\-\.9σ\\uD803\\uDF8Cσ\'\)\ throws\ error\ P1\ V3\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:1333\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0354}\x{E011B}\x{1E7F6}｡𝟮Ⴜ", %p)},	undef,	"to_unicode\(\'\\u0354\\uDB40\\uDD1B\\uD839\\uDFF6｡𝟮Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1334\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0354}\x{E011B}\x{1E7F6}。2Ⴜ", %p)},	undef,	"to_unicode\(\'\\u0354\\uDB40\\uDD1B\\uD839\\uDFF6。2Ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1335\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0354}\x{E011B}\x{1E7F6}。2ⴜ", %p)},	undef,	"to_unicode\(\'\\u0354\\uDB40\\uDD1B\\uD839\\uDFF6。2ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1336\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0354}\x{E011B}\x{1E7F6}｡𝟮ⴜ", %p)},	undef,	"to_unicode\(\'\\u0354\\uDB40\\uDD1B\\uD839\\uDFF6｡𝟮ⴜ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1337\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䪏\x{1ED87}\x{06AA}\x{2CEF}｡뭕\x{0633}\x{0DD4}", %p)},	undef,	"to_unicode\(\'䪏\\uD83B\\uDD87\\u06AA\\u2CEF｡뭕\\u0633\\u0DD4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1338\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䪏\x{1ED87}\x{06AA}\x{2CEF}｡뭕\x{0633}\x{0DD4}", %p)},	undef,	"to_unicode\(\'䪏\\uD83B\\uDD87\\u06AA\\u2CEF｡뭕\\u0633\\u0DD4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1339\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䪏\x{1ED87}\x{06AA}\x{2CEF}。뭕\x{0633}\x{0DD4}", %p)},	undef,	"to_unicode\(\'䪏\\uD83B\\uDD87\\u06AA\\u2CEF。뭕\\u0633\\u0DD4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1340\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䪏\x{1ED87}\x{06AA}\x{2CEF}。뭕\x{0633}\x{0DD4}", %p)},	undef,	"to_unicode\(\'䪏\\uD83B\\uDD87\\u06AA\\u2CEF。뭕\\u0633\\u0DD4\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1341\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}｡\x{E0391}\x{E0102}", %p)},	undef,	"to_unicode\(\'\\u0BCD｡\\uDB40\\uDF91\\uDB40\\uDD02\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1342\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}。\x{E0391}\x{E0102}", %p)},	undef,	"to_unicode\(\'\\u0BCD。\\uDB40\\uDF91\\uDB40\\uDD02\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1343\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9DD52}\x{E0180}。ς\x{200D}\x{10E78}\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\uDA37\\uDD52\\uDB40\\uDD80。ς\\u200D\\uD803\\uDE78\\u0ACD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1344\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9DD52}\x{E0180}。ς\x{200D}\x{10E78}\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\uDA37\\uDD52\\uDB40\\uDD80。ς\\u200D\\uD803\\uDE78\\u0ACD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1345\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9DD52}\x{E0180}。Σ\x{200D}\x{10E78}\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\uDA37\\uDD52\\uDB40\\uDD80。Σ\\u200D\\uD803\\uDE78\\u0ACD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1346\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9DD52}\x{E0180}。Σ\x{200D}\x{10E78}\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\uDA37\\uDD52\\uDB40\\uDD80。Σ\\u200D\\uD803\\uDE78\\u0ACD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1347\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9DD52}\x{E0180}。σ\x{200D}\x{10E78}\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\uDA37\\uDD52\\uDB40\\uDD80。σ\\u200D\\uD803\\uDE78\\u0ACD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1348\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9DD52}\x{E0180}。σ\x{200D}\x{10E78}\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\uDA37\\uDD52\\uDB40\\uDD80。σ\\u200D\\uD803\\uDE78\\u0ACD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:1349\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{07E1}ᡚ\x{1714}．\x{10A3F}", %p)},	undef,	"to_unicode\(\'\\u07E1ᡚ\\u1714．\\uD802\\uDE3F\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E1}ᡚ\x{1714}.\x{10A3F}", %p)},	undef,	"to_unicode\(\'\\u07E1ᡚ\\u1714\.\\uD802\\uDE3F\'\)\ throws\ error\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:1351\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𢶂籕\x{BED4C}-。\x{200C}", %p)},	undef,	"to_unicode\(\'𢶂籕\\uDABB\\uDD4C\-。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1352\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𢶂籕\x{BED4C}-。\x{200C}", %p)},	undef,	"to_unicode\(\'𢶂籕\\uDABB\\uDD4C\-。\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1353\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0601}．\x{FBFD}", %p)},	undef,	"to_unicode\(\'\\u0601．\\uFBFD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0601}.\x{06CC}", %p)},	undef,	"to_unicode\(\'\\u0601\.\\u06CC\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ᠱ｡Ↄ", %p)},	undef,	"to_unicode\(\'\-ᠱ｡Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ᠱ。Ↄ", %p)},	undef,	"to_unicode\(\'\-ᠱ。Ↄ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ᠱ。ↄ", %p)},	undef,	"to_unicode\(\'\-ᠱ。ↄ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ᠱ｡ↄ", %p)},	undef,	"to_unicode\(\'\-ᠱ｡ↄ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1359\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-︒\x{E019D}。ß哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\uDB40\\uDD9D。ß哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1360\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-︒\x{E019D}。ß哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\uDB40\\uDD9D。ß哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1361\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-。\x{E019D}。ß哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-。\\uDB40\\uDD9D。ß哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1362\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-。\x{E019D}。ß哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-。\\uDB40\\uDD9D。ß哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1363\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-。\x{E019D}。SS哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-。\\uDB40\\uDD9D。SS哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1364\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-。\x{E019D}。SS哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-。\\uDB40\\uDD9D。SS哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1365\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-。\x{E019D}。ss哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-。\\uDB40\\uDD9D。ss哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1366\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-。\x{E019D}。ss哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-。\\uDB40\\uDD9D。ss哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1367\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-。\x{E019D}。Ss哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-。\\uDB40\\uDD9D。Ss哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1368\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-。\x{E019D}。Ss哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-。\\uDB40\\uDD9D。Ss哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V3\ V6\ C2\ A4_2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1369\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-︒\x{E019D}。SS哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\uDB40\\uDD9D。SS哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1370\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-︒\x{E019D}。SS哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\uDB40\\uDD9D。SS哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1371\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-︒\x{E019D}。ss哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\uDB40\\uDD9D。ss哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1372\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-︒\x{E019D}。ss哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\uDB40\\uDD9D。ss哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1373\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-︒\x{E019D}。Ss哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\uDB40\\uDD9D。Ss哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1374\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-︒\x{E019D}。Ss哑\x{200C}\x{1E9CE}", %p)},	undef,	"to_unicode\(\'\\u200D\-︒\\uDB40\\uDD9D。Ss哑\\u200C\\uD83A\\uDDCE\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1375\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒．\x{1DC3}\x{ABED}", %p)},	undef,	"to_unicode\(\'︒．\\u1DC3\\uABED\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒．\x{ABED}\x{1DC3}", %p)},	undef,	"to_unicode\(\'︒．\\uABED\\u1DC3\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。.\x{ABED}\x{1DC3}", %p)},	undef,	"to_unicode\(\'。\.\\uABED\\u1DC3\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0670}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0670。\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0670}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0670。\\u200D\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:1380\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}🜼｡\x{10E38}", %p)},	undef,	"to_unicode\(\'\\u200D🜼｡\\uD803\\uDE38\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1381\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}🜼｡\x{10E38}", %p)},	undef,	"to_unicode\(\'\\u200D🜼｡\\uD803\\uDE38\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1382\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}🜼。\x{10E38}", %p)},	undef,	"to_unicode\(\'\\u200D🜼。\\uD803\\uDE38\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1383\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}🜼。\x{10E38}", %p)},	undef,	"to_unicode\(\'\\u200D🜼。\\uD803\\uDE38\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1384\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-Ⴄ𝟫\x{0602}．\x{1713}ς", %p)},	undef,	"to_unicode\(\'\-Ⴄ𝟫\\u0602．\\u1713ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴄ9\x{0602}.\x{1713}ς", %p)},	undef,	"to_unicode\(\'\-Ⴄ9\\u0602\.\\u1713ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ⴄ9\x{0602}.\x{1713}ς", %p)},	undef,	"to_unicode\(\'\-ⴄ9\\u0602\.\\u1713ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴄ9\x{0602}.\x{1713}Σ", %p)},	undef,	"to_unicode\(\'\-Ⴄ9\\u0602\.\\u1713Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ⴄ9\x{0602}.\x{1713}σ", %p)},	undef,	"to_unicode\(\'\-ⴄ9\\u0602\.\\u1713σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1389\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ⴄ𝟫\x{0602}．\x{1713}ς", %p)},	undef,	"to_unicode\(\'\-ⴄ𝟫\\u0602．\\u1713ς\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1390\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-Ⴄ𝟫\x{0602}．\x{1713}Σ", %p)},	undef,	"to_unicode\(\'\-Ⴄ𝟫\\u0602．\\u1713Σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1391\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-ⴄ𝟫\x{0602}．\x{1713}σ", %p)},	undef,	"to_unicode\(\'\-ⴄ𝟫\\u0602．\\u1713σ\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1392\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{38E5E}。-", %p)},	undef,	"to_unicode\(\'\\uD8A3\\uDE5E。\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:1393\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⋠🄊．\x{AF652}\x{A982}ß≯", %p)},	undef,	"to_unicode\(\'⋠🄊．\\uDA7D\\uDE52\\uA982ß≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1394\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≼\x{0338}🄊．\x{AF652}\x{A982}ß>\x{0338}", %p)},	undef,	"to_unicode\(\'≼\\u0338🄊．\\uDA7D\\uDE52\\uA982ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1395\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⋠9,.\x{AF652}\x{A982}ß≯", %p)},	undef,	"to_unicode\(\'⋠9\,\.\\uDA7D\\uDE52\\uA982ß≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1396\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≼\x{0338}9,.\x{AF652}\x{A982}ß>\x{0338}", %p)},	undef,	"to_unicode\(\'≼\\u03389\,\.\\uDA7D\\uDE52\\uA982ß\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1397\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≼\x{0338}9,.\x{AF652}\x{A982}SS>\x{0338}", %p)},	undef,	"to_unicode\(\'≼\\u03389\,\.\\uDA7D\\uDE52\\uA982SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1398\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⋠9,.\x{AF652}\x{A982}SS≯", %p)},	undef,	"to_unicode\(\'⋠9\,\.\\uDA7D\\uDE52\\uA982SS≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1399\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⋠9,.\x{AF652}\x{A982}ss≯", %p)},	undef,	"to_unicode\(\'⋠9\,\.\\uDA7D\\uDE52\\uA982ss≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1400\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≼\x{0338}9,.\x{AF652}\x{A982}ss>\x{0338}", %p)},	undef,	"to_unicode\(\'≼\\u03389\,\.\\uDA7D\\uDE52\\uA982ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1401\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≼\x{0338}9,.\x{AF652}\x{A982}Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'≼\\u03389\,\.\\uDA7D\\uDE52\\uA982Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1402\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⋠9,.\x{AF652}\x{A982}Ss≯", %p)},	undef,	"to_unicode\(\'⋠9\,\.\\uDA7D\\uDE52\\uA982Ss≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1403\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≼\x{0338}🄊．\x{AF652}\x{A982}SS>\x{0338}", %p)},	undef,	"to_unicode\(\'≼\\u0338🄊．\\uDA7D\\uDE52\\uA982SS\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1404\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⋠🄊．\x{AF652}\x{A982}SS≯", %p)},	undef,	"to_unicode\(\'⋠🄊．\\uDA7D\\uDE52\\uA982SS≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1405\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⋠🄊．\x{AF652}\x{A982}ss≯", %p)},	undef,	"to_unicode\(\'⋠🄊．\\uDA7D\\uDE52\\uA982ss≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1406\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≼\x{0338}🄊．\x{AF652}\x{A982}ss>\x{0338}", %p)},	undef,	"to_unicode\(\'≼\\u0338🄊．\\uDA7D\\uDE52\\uA982ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1407\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≼\x{0338}🄊．\x{AF652}\x{A982}Ss>\x{0338}", %p)},	undef,	"to_unicode\(\'≼\\u0338🄊．\\uDA7D\\uDE52\\uA982Ss\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1408\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⋠🄊．\x{AF652}\x{A982}Ss≯", %p)},	undef,	"to_unicode\(\'⋠🄊．\\uDA7D\\uDE52\\uA982Ss≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1409\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🄈₅\x{0669}｡\x{E03DD}\x{FB56}\x{EDACF}", %p)},	undef,	"to_unicode\(\'🄈₅\\u0669｡\\uDB40\\uDFDD\\uFB56\\uDB76\\uDECF\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1410\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("7,5\x{0669}。\x{E03DD}\x{067E}\x{EDACF}", %p)},	undef,	"to_unicode\(\'7\,5\\u0669。\\uDB40\\uDFDD\\u067E\\uDB76\\uDECF\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1411\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("儭-｡\x{10E62}Ⴢ\x{46253}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\uD803\\uDE62Ⴢ\\uD8D8\\uDE53\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1412\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("儭-｡\x{10E62}Ⴢ\x{46253}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\uD803\\uDE62Ⴢ\\uD8D8\\uDE53\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1413\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("儭-。\x{10E62}Ⴢ\x{46253}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-。\\uD803\\uDE62Ⴢ\\uD8D8\\uDE53\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1414\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("儭-。\x{10E62}Ⴢ\x{46253}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-。\\uD803\\uDE62Ⴢ\\uD8D8\\uDE53\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1415\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("儭-。\x{10E62}ⴢ\x{46253}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-。\\uD803\\uDE62ⴢ\\uD8D8\\uDE53\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1416\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("儭-。\x{10E62}ⴢ\x{46253}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-。\\uD803\\uDE62ⴢ\\uD8D8\\uDE53\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1417\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("儭-｡\x{10E62}ⴢ\x{46253}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\uD803\\uDE62ⴢ\\uD8D8\\uDE53\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1418\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("儭-｡\x{10E62}ⴢ\x{46253}\x{200C}", %p)},	undef,	"to_unicode\(\'儭\-｡\\uD803\\uDE62ⴢ\\uD8D8\\uDE53\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1419\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟓₅\x{072E}．ᢢ\x{A6CFA}", %p)},	undef,	"to_unicode\(\'𝟓₅\\u072E．ᢢ\\uDA5B\\uDCFA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1420\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("55\x{072E}.ᢢ\x{A6CFA}", %p)},	undef,	"to_unicode\(\'55\\u072E\.ᢢ\\uDA5B\\uDCFA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1421\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯-\x{06C4}\x{17BD}.⒈\x{0664}", %p)},	undef,	"to_unicode\(\'≯\-\\u06C4\\u17BD\.⒈\\u0664\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1422\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}-\x{06C4}\x{17BD}.⒈\x{0664}", %p)},	undef,	"to_unicode\(\'\>\\u0338\-\\u06C4\\u17BD\.⒈\\u0664\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1423\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯-\x{06C4}\x{17BD}.1.\x{0664}", %p)},	undef,	"to_unicode\(\'≯\-\\u06C4\\u17BD\.1\.\\u0664\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1424\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}-\x{06C4}\x{17BD}.1.\x{0664}", %p)},	undef,	"to_unicode\(\'\>\\u0338\-\\u06C4\\u17BD\.1\.\\u0664\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1425\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0117}．\x{6AA1B}蚀", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD17．\\uD96A\\uDE1B蚀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1426\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0117}.\x{6AA1B}蚀", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD17\.\\uD96A\\uDE1B蚀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1427\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0752}Ⴘ.\x{1EA34}\x{ABED}ß\x{0962}", %p)},	undef,	"to_unicode\(\'\\u0752Ⴘ\.\\uD83A\\uDE34\\uABEDß\\u0962\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1428\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0752}ⴘ.\x{1EA34}\x{ABED}ß\x{0962}", %p)},	undef,	"to_unicode\(\'\\u0752ⴘ\.\\uD83A\\uDE34\\uABEDß\\u0962\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1429\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0752}Ⴘ.\x{1EA34}\x{ABED}SS\x{0962}", %p)},	undef,	"to_unicode\(\'\\u0752Ⴘ\.\\uD83A\\uDE34\\uABEDSS\\u0962\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1430\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0752}ⴘ.\x{1EA34}\x{ABED}ss\x{0962}", %p)},	undef,	"to_unicode\(\'\\u0752ⴘ\.\\uD83A\\uDE34\\uABEDss\\u0962\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1431\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0752}Ⴘ.\x{1EA34}\x{ABED}Ss\x{0962}", %p)},	undef,	"to_unicode\(\'\\u0752Ⴘ\.\\uD83A\\uDE34\\uABEDSs\\u0962\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1432\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1034}\x{10E6B}\x{40BCC}｡凬", %p)},	undef,	"to_unicode\(\'\\u1034\\uD803\\uDE6B\\uD8C2\\uDFCC｡凬\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1433\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1034}\x{10E6B}\x{40BCC}。凬", %p)},	undef,	"to_unicode\(\'\\u1034\\uD803\\uDE6B\\uD8C2\\uDFCC。凬\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1434\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0927}𝟕\x{200D}ᡞ｡\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD27𝟕\\u200Dᡞ｡\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1435\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0927}𝟕\x{200D}ᡞ｡\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD27𝟕\\u200Dᡞ｡\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1436\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0927}7\x{200D}ᡞ。\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD277\\u200Dᡞ。\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1437\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0927}7\x{200D}ᡞ。\x{0B4D}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD277\\u200Dᡞ。\\u0B4D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1438\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A4}。\x{11046}ᠶ", %p)},	undef,	"to_unicode\(\'\\u08A4。\\uD804\\uDC46ᠶ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1439\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E019F}≮.\x{065A}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD9F≮\.\\u065A\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1440\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E019F}<\x{0338}.\x{065A}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD9F\<\\u0338\.\\u065A\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1441\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ≯褦．ᡚ\x{069F}Ⴞ\x{06B2}", %p)},	undef,	"to_unicode\(\'Ⴢ≯褦．ᡚ\\u069FႾ\\u06B2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ>\x{0338}褦．ᡚ\x{069F}Ⴞ\x{06B2}", %p)},	undef,	"to_unicode\(\'Ⴢ\>\\u0338褦．ᡚ\\u069FႾ\\u06B2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ≯褦.ᡚ\x{069F}Ⴞ\x{06B2}", %p)},	undef,	"to_unicode\(\'Ⴢ≯褦\.ᡚ\\u069FႾ\\u06B2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴢ>\x{0338}褦.ᡚ\x{069F}Ⴞ\x{06B2}", %p)},	undef,	"to_unicode\(\'Ⴢ\>\\u0338褦\.ᡚ\\u069FႾ\\u06B2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ>\x{0338}褦.ᡚ\x{069F}ⴞ\x{06B2}", %p)},	undef,	"to_unicode\(\'ⴢ\>\\u0338褦\.ᡚ\\u069Fⴞ\\u06B2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ≯褦.ᡚ\x{069F}ⴞ\x{06B2}", %p)},	undef,	"to_unicode\(\'ⴢ≯褦\.ᡚ\\u069Fⴞ\\u06B2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ>\x{0338}褦．ᡚ\x{069F}ⴞ\x{06B2}", %p)},	undef,	"to_unicode\(\'ⴢ\>\\u0338褦．ᡚ\\u069Fⴞ\\u06B2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴢ≯褦．ᡚ\x{069F}ⴞ\x{06B2}", %p)},	undef,	"to_unicode\(\'ⴢ≯褦．ᡚ\\u069Fⴞ\\u06B2\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1449\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{55CFB}\x{1DC1}\x{200C}\x{1734}。ꡚꡋ\x{0633}", %p)},	undef,	"to_unicode\(\'\\uD917\\uDCFB\\u1DC1\\u200C\\u1734。ꡚꡋ\\u0633\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:1450\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{55CFB}\x{1DC1}\x{200C}\x{1734}。ꡚꡋ\x{0633}", %p)},	undef,	"to_unicode\(\'\\uD917\\uDCFB\\u1DC1\\u200C\\u1734。ꡚꡋ\\u0633\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:1451\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}.≯", %p)},	undef,	"to_unicode\(\'\\u200C\.≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1452\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.≯", %p)},	undef,	"to_unicode\(\'\\u200C\.≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1453\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1454\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1455\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{EFA25}\x{B70CE}-．\x{094D}-悜", %p)},	undef,	"to_unicode\(\'\\uDB7E\\uDE25\\uDA9C\\uDCCE\-．\\u094D\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1456\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{EFA25}\x{B70CE}-.\x{094D}-悜", %p)},	undef,	"to_unicode\(\'\\uDB7E\\uDE25\\uDA9C\\uDCCE\-\.\\u094D\-悜\'\)\ throws\ error\ P1\ V3\ V6\ V5\ \[data\/IdnaTest\.txt\:1457\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BD}\x{E8BB0}\x{E09BB}\x{07D7}.-\x{200D}\x{E0128}\x{2DF9}", %p)},	undef,	"to_unicode\(\'\\u06BD\\uDB62\\uDFB0\\uDB42\\uDDBB\\u07D7\.\-\\u200D\\uDB40\\uDD28\\u2DF9\'\)\ throws\ error\ P1\ V6\ V3\ B2\ C2\ \[data\/IdnaTest\.txt\:1458\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BD}\x{E8BB0}\x{E09BB}\x{07D7}.-\x{200D}\x{E0128}\x{2DF9}", %p)},	undef,	"to_unicode\(\'\\u06BD\\uDB62\\uDFB0\\uDB42\\uDDBB\\u07D7\.\-\\u200D\\uDB40\\uDD28\\u2DF9\'\)\ throws\ error\ P1\ V6\ V3\ B2\ C2\ \[data\/IdnaTest\.txt\:1459\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟸\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_unicode\(\'𝟸\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟸\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_unicode\(\'𝟸\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_unicode\(\'2\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2\x{200C}衃Ⴝ.\x{0682}Ⴔ", %p)},	undef,	"to_unicode\(\'2\\u200C衃Ⴝ\.\\u0682Ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'2\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'2\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'2\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("2\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'2\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟸\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'𝟸\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟸\x{200C}衃ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'𝟸\\u200C衃ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟸\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'𝟸\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟸\x{200C}衃Ⴝ.\x{0682}ⴔ", %p)},	undef,	"to_unicode\(\'𝟸\\u200C衃Ⴝ\.\\u0682ⴔ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:1471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0638}\x{200C}。--⼼", %p)},	undef,	"to_unicode\(\'\\u0638\\u200C。\-\-⼼\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1472\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0638}\x{200C}。--⼼", %p)},	undef,	"to_unicode\(\'\\u0638\\u200C。\-\-⼼\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1473\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0638}\x{200C}。--心", %p)},	undef,	"to_unicode\(\'\\u0638\\u200C。\-\-心\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1474\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0638}\x{200C}。--心", %p)},	undef,	"to_unicode\(\'\\u0638\\u200C。\-\-心\'\)\ throws\ error\ V3\ B3\ C1\ \[data\/IdnaTest\.txt\:1475\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FBE3}．\x{08A5}", %p)},	"\x{06C9}.\x{08A5}",	"to_unicode\(\'\\uFBE3．\\u08A5\'\)\ \[data\/IdnaTest\.txt\:1476\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C9}.\x{08A5}", %p)},	"\x{06C9}.\x{08A5}",	"to_unicode\(\'\\u06C9\.\\u08A5\'\)\ \[data\/IdnaTest\.txt\:1477\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--8kb.xn--uyb", %p)},	"\x{06C9}.\x{08A5}",	"to_unicode\(\'xn\-\-8kb\.xn\-\-uyb\'\)\ \[data\/IdnaTest\.txt\:1478\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1037}-．-\x{116B6}", %p)},	undef,	"to_unicode\(\'\\u1037\-．\-\\uD805\\uDEB6\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1479\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1037}-.-\x{116B6}", %p)},	undef,	"to_unicode\(\'\\u1037\-\.\-\\uD805\\uDEB6\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:1480\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0B7F}ᡰ-.\x{1D173}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDF7Fᡰ\-\.\\uD834\\uDD73\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1481\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡒ\x{E068A}🔃\x{10E6C}.\x{1BF3}₇\x{3C3D0}", %p)},	undef,	"to_unicode\(\'ᡒ\\uDB41\\uDE8A🔃\\uD803\\uDE6C\.\\u1BF3₇\\uD8B0\\uDFD0\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1482\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡒ\x{E068A}🔃\x{10E6C}.\x{1BF3}7\x{3C3D0}", %p)},	undef,	"to_unicode\(\'ᡒ\\uDB41\\uDE8A🔃\\uD803\\uDE6C\.\\u1BF37\\uD8B0\\uDFD0\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1483\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E01BB}🄃。\x{0816}\x{200C}\x{10994}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDBB🄃。\\u0816\\u200C\\uD802\\uDD94\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1484\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E01BB}🄃。\x{0816}\x{200C}\x{10994}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDBB🄃。\\u0816\\u200C\\uD802\\uDD94\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1485\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E01BB}2,。\x{0816}\x{200C}\x{10994}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDBB2\,。\\u0816\\u200C\\uD802\\uDD94\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1486\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E01BB}2,。\x{0816}\x{200C}\x{10994}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDBB2\,。\\u0816\\u200C\\uD802\\uDD94\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1487\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴚ₄\x{FE0C}。４\x{30F75}\x{1BF3}", %p)},	undef,	"to_unicode\(\'Ⴚ₄\\uFE0C。４\\uD883\\uDF75\\u1BF3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1488\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴚ4\x{FE0C}。4\x{30F75}\x{1BF3}", %p)},	undef,	"to_unicode\(\'Ⴚ4\\uFE0C。4\\uD883\\uDF75\\u1BF3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1489\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴚ4\x{FE0C}。4\x{30F75}\x{1BF3}", %p)},	undef,	"to_unicode\(\'ⴚ4\\uFE0C。4\\uD883\\uDF75\\u1BF3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1490\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴚ₄\x{FE0C}。４\x{30F75}\x{1BF3}", %p)},	undef,	"to_unicode\(\'ⴚ₄\\uFE0C。４\\uD883\\uDF75\\u1BF3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1491\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-\x{07E3}🝦.\x{E015F}\x{0FA3}", %p)},	undef,	"to_unicode\(\'\\u200D\-\\u07E3🝦\.\\uDB40\\uDD5F\\u0FA3\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1492\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-\x{07E3}🝦.\x{E015F}\x{0FA3}", %p)},	undef,	"to_unicode\(\'\\u200D\-\\u07E3🝦\.\\uDB40\\uDD5F\\u0FA3\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1493\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≠.\x{0768}", %p)},	undef,	"to_unicode\(\'≠\.\\u0768\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1494\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}.\x{0768}", %p)},	undef,	"to_unicode\(\'\=\\u0338\.\\u0768\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1495\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D5}\x{064B}｡㌪", %p)},	"\x{07D5}\x{064B}.ハイツ",	"to_unicode\(\'\\u07D5\\u064B｡㌪\'\)\ \[data\/IdnaTest\.txt\:1496\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D5}\x{064B}。ハイツ", %p)},	"\x{07D5}\x{064B}.ハイツ",	"to_unicode\(\'\\u07D5\\u064B。ハイツ\'\)\ \[data\/IdnaTest\.txt\:1497\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--nhb10f.xn--eck4c5a", %p)},	"\x{07D5}\x{064B}.ハイツ",	"to_unicode\(\'xn\-\-nhb10f\.xn\-\-eck4c5a\'\)\ \[data\/IdnaTest\.txt\:1498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07D5}\x{064B}.ハイツ", %p)},	"\x{07D5}\x{064B}.ハイツ",	"to_unicode\(\'\\u07D5\\u064B\.ハイツ\'\)\ \[data\/IdnaTest\.txt\:1499\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E9EF}\x{05BA}≮.\x{ABED}-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDDEF\\u05BA≮\.\\uABED\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1500\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E9EF}\x{05BA}<\x{0338}.\x{ABED}-", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDDEF\\u05BA\<\\u0338\.\\uABED\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B3\ \[data\/IdnaTest\.txt\:1501\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟲榎\x{37B15}\x{110B9}｡ᡚ\x{1D189}\x{1E87E}\x{E0BA8}", %p)},	undef,	"to_unicode\(\'𝟲榎\\uD89E\\uDF15\\uD804\\uDCB9｡ᡚ\\uD834\\uDD89\\uD83A\\uDC7E\\uDB42\\uDFA8\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1502\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("6榎\x{37B15}\x{110B9}。ᡚ\x{1D189}\x{1E87E}\x{E0BA8}", %p)},	undef,	"to_unicode\(\'6榎\\uD89E\\uDF15\\uD804\\uDCB9。ᡚ\\uD834\\uDD89\\uD83A\\uDC7E\\uDB42\\uDFA8\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1503\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E90F3}．\x{5A710}", %p)},	undef,	"to_unicode\(\'\\uDB64\\uDCF3．\\uD929\\uDF10\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1504\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E90F3}.\x{5A710}", %p)},	undef,	"to_unicode\(\'\\uDB64\\uDCF3\.\\uD929\\uDF10\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1505\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}︒｡\x{069F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D︒｡\\u069F\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1506\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}︒｡\x{069F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D︒｡\\u069F\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ B3\ C1\ \[data\/IdnaTest\.txt\:1507\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。。\x{069F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D。。\\u069F\\u200C\'\)\ throws\ error\ C2\ A4_2\ B3\ C1\ \[data\/IdnaTest\.txt\:1508\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。。\x{069F}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D。。\\u069F\\u200C\'\)\ throws\ error\ C2\ A4_2\ B3\ C1\ \[data\/IdnaTest\.txt\:1509\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--1jb", %p)},	"\x{069F}",	"to_unicode\(\'xn\-\-1jb\'\)\ \[data\/IdnaTest\.txt\:1510\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{069F}", %p)},	"\x{069F}",	"to_unicode\(\'\\u069F\'\)\ \[data\/IdnaTest\.txt\:1511\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0669}\x{200C}\x{10E69}。\x{20CD}", %p)},	undef,	"to_unicode\(\'\\u0669\\u200C\\uD803\\uDE69。\\u20CD\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1512\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0669}\x{200C}\x{10E69}。\x{20CD}", %p)},	undef,	"to_unicode\(\'\\u0669\\u200C\\uD803\\uDE69。\\u20CD\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1513\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1BAA}\x{05A5}\x{1DC1}𝟼。-🂄", %p)},	undef,	"to_unicode\(\'\\u1BAA\\u05A5\\u1DC1𝟼。\-🂄\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1514\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAA}\x{05A5}\x{1DC1}6。-🂄", %p)},	undef,	"to_unicode\(\'\\u1BAA\\u05A5\\u1DC16。\-🂄\'\)\ throws\ error\ V5\ V3\ \[data\/IdnaTest\.txt\:1515\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{37EC1}。뙏", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDEC1。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1516\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{37EC1}。뙏", %p)},	undef,	"to_unicode\(\'\\uD89F\\uDEC1。뙏\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1517\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{32E54}\x{E0113}\x{92B14}\x{067E}.\x{076A}", %p)},	undef,	"to_unicode\(\'\\uD88B\\uDE54\\uDB40\\uDD13\\uDA0A\\uDF14\\u067E\.\\u076A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1518\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}｡\x{E10E7}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uDB44\\uDCE7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1519\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}｡\x{E10E7}", %p)},	undef,	"to_unicode\(\'\\u200D｡\\uDB44\\uDCE7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1520\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。\x{E10E7}", %p)},	undef,	"to_unicode\(\'\\u200D。\\uDB44\\uDCE7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1521\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。\x{E10E7}", %p)},	undef,	"to_unicode\(\'\\u200D。\\uDB44\\uDCE7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1522\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᡦ皥．-", %p)},	undef,	"to_unicode\(\'ᡦ皥．\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡦ皥.-", %p)},	undef,	"to_unicode\(\'ᡦ皥\.\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FB68}\x{E0128}ᠧ．⒈ᡕ", %p)},	undef,	"to_unicode\(\'\\uFB68\\uDB40\\uDD28ᠧ．⒈ᡕ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0679}\x{E0128}ᠧ.1.ᡕ", %p)},	undef,	"to_unicode\(\'\\u0679\\uDB40\\uDD28ᠧ\.1\.ᡕ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}ā\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}ā\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}a\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0a\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}a\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0a\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}ā\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}ā\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}a\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160a\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}a\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160a\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}a\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160a\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}a\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160a\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}ā\x{0663}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}ā\x{0663}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}Ā\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160Ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}Ā\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160Ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}A\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160A\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{1160}A\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\u1160A\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}a\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0a\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}a\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0a\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}ā\x{0663}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}ā\x{0663}", %p)},	undef,	"to_unicode\(\'ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}Ā\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0Ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}Ā\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0Ā\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}A\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0A\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1549\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴛ\x{200C}\x{E0141}\x{200D}。\x{FFA0}A\x{0304}\x{0663}", %p)},	undef,	"to_unicode\(\'Ⴛ\\u200C\\uDB40\\uDD41\\u200D。\\uFFA0A\\u0304\\u0663\'\)\ throws\ error\ P1\ V6\ C1\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳿\x{200C}｡曳⾑₁≯", %p)},	undef,	"to_unicode\(\'⳿\\u200C｡曳⾑₁≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳿\x{200C}｡曳⾑₁≯", %p)},	undef,	"to_unicode\(\'⳿\\u200C｡曳⾑₁≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳿\x{200C}｡曳⾑₁>\x{0338}", %p)},	undef,	"to_unicode\(\'⳿\\u200C｡曳⾑₁\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳿\x{200C}｡曳⾑₁>\x{0338}", %p)},	undef,	"to_unicode\(\'⳿\\u200C｡曳⾑₁\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳿\x{200C}。曳襾1≯", %p)},	undef,	"to_unicode\(\'⳿\\u200C。曳襾1≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳿\x{200C}。曳襾1≯", %p)},	undef,	"to_unicode\(\'⳿\\u200C。曳襾1≯\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳿\x{200C}。曳襾1>\x{0338}", %p)},	undef,	"to_unicode\(\'⳿\\u200C。曳襾1\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1557\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳿\x{200C}。曳襾1>\x{0338}", %p)},	undef,	"to_unicode\(\'⳿\\u200C。曳襾1\>\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1558\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯⒈。ß", %p)},	undef,	"to_unicode\(\'≯⒈。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}⒈。ß", %p)},	undef,	"to_unicode\(\'\>\\u0338⒈。ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯1.。ß", %p)},	undef,	"to_unicode\(\'≯1\.。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}1.。ß", %p)},	undef,	"to_unicode\(\'\>\\u03381\.。ß\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1562\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}1.。SS", %p)},	undef,	"to_unicode\(\'\>\\u03381\.。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1563\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯1.。SS", %p)},	undef,	"to_unicode\(\'≯1\.。SS\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1564\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}⒈。SS", %p)},	undef,	"to_unicode\(\'\>\\u0338⒈。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1565\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯⒈。SS", %p)},	undef,	"to_unicode\(\'≯⒈。SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1566\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7D}\x{200D}\x{1E986}｡\x{077E}-1Ⴙ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7D\\u200D\\uD83A\\uDD86｡\\u077E\-1Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1567\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7D}\x{200D}\x{1E986}｡\x{077E}-1Ⴙ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7D\\u200D\\uD83A\\uDD86｡\\u077E\-1Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1568\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7D}\x{200D}\x{1E986}。\x{077E}-1Ⴙ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7D\\u200D\\uD83A\\uDD86。\\u077E\-1Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1569\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7D}\x{200D}\x{1E986}。\x{077E}-1Ⴙ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7D\\u200D\\uD83A\\uDD86。\\u077E\-1Ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1570\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7D}\x{200D}\x{1E986}。\x{077E}-1ⴙ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7D\\u200D\\uD83A\\uDD86。\\u077E\-1ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1571\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7D}\x{200D}\x{1E986}。\x{077E}-1ⴙ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7D\\u200D\\uD83A\\uDD86。\\u077E\-1ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1572\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7D}\x{200D}\x{1E986}｡\x{077E}-1ⴙ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7D\\u200D\\uD83A\\uDD86｡\\u077E\-1ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1573\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7D}\x{200D}\x{1E986}｡\x{077E}-1ⴙ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7D\\u200D\\uD83A\\uDD86｡\\u077E\-1ⴙ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:1574\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}｡≠", %p)},	undef,	"to_unicode\(\'\\u200C｡≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡≠", %p)},	undef,	"to_unicode\(\'\\u200C｡≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C｡\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1578\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。≠", %p)},	undef,	"to_unicode\(\'\\u200C。≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1579\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。≠", %p)},	undef,	"to_unicode\(\'\\u200C。≠\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1580\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C。\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1581\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200C。\=\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1582\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}\x{E0111}.\x{0721}\x{0C4D}\x{A94E}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0A4D\\uDB40\\uDD11\.\\u0721\\u0C4D\\uA94E\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:1583\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0A4D}\x{E0111}.\x{0721}\x{0C4D}\x{A94E}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0A4D\\uDB40\\uDD11\.\\u0721\\u0C4D\\uA94E\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:1584\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{794E7}\x{200D}\x{8CA2E}.\x{1A5D}Ↄ≠-", %p)},	undef,	"to_unicode\(\'\\uD9A5\\uDCE7\\u200D\\uD9F2\\uDE2E\.\\u1A5DↃ≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1585\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{794E7}\x{200D}\x{8CA2E}.\x{1A5D}Ↄ≠-", %p)},	undef,	"to_unicode\(\'\\uD9A5\\uDCE7\\u200D\\uD9F2\\uDE2E\.\\u1A5DↃ≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1586\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{794E7}\x{200D}\x{8CA2E}.\x{1A5D}Ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\\uD9A5\\uDCE7\\u200D\\uD9F2\\uDE2E\.\\u1A5DↃ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1587\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{794E7}\x{200D}\x{8CA2E}.\x{1A5D}Ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\\uD9A5\\uDCE7\\u200D\\uD9F2\\uDE2E\.\\u1A5DↃ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1588\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{794E7}\x{200D}\x{8CA2E}.\x{1A5D}ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\\uD9A5\\uDCE7\\u200D\\uD9F2\\uDE2E\.\\u1A5Dↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1589\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{794E7}\x{200D}\x{8CA2E}.\x{1A5D}ↄ=\x{0338}-", %p)},	undef,	"to_unicode\(\'\\uD9A5\\uDCE7\\u200D\\uD9F2\\uDE2E\.\\u1A5Dↄ\=\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1590\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{794E7}\x{200D}\x{8CA2E}.\x{1A5D}ↄ≠-", %p)},	undef,	"to_unicode\(\'\\uD9A5\\uDCE7\\u200D\\uD9F2\\uDE2E\.\\u1A5Dↄ≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1591\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{794E7}\x{200D}\x{8CA2E}.\x{1A5D}ↄ≠-", %p)},	undef,	"to_unicode\(\'\\uD9A5\\uDCE7\\u200D\\uD9F2\\uDE2E\.\\u1A5Dↄ≠\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ C2\ \[data\/IdnaTest\.txt\:1592\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡏς\x{200D}۴。蔑\x{CEDEE}", %p)},	undef,	"to_unicode\(\'ꡏς\\u200D۴。蔑\\uDAFB\\uDDEE\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1593\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡏς\x{200D}۴。蔑\x{CEDEE}", %p)},	undef,	"to_unicode\(\'ꡏς\\u200D۴。蔑\\uDAFB\\uDDEE\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1594\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡏΣ\x{200D}۴。蔑\x{CEDEE}", %p)},	undef,	"to_unicode\(\'ꡏΣ\\u200D۴。蔑\\uDAFB\\uDDEE\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1595\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡏΣ\x{200D}۴。蔑\x{CEDEE}", %p)},	undef,	"to_unicode\(\'ꡏΣ\\u200D۴。蔑\\uDAFB\\uDDEE\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1596\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡏσ\x{200D}۴。蔑\x{CEDEE}", %p)},	undef,	"to_unicode\(\'ꡏσ\\u200D۴。蔑\\uDAFB\\uDDEE\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1597\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡏσ\x{200D}۴。蔑\x{CEDEE}", %p)},	undef,	"to_unicode\(\'ꡏσ\\u200D۴。蔑\\uDAFB\\uDDEE\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1598\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06DD}.\x{10E62}", %p)},	undef,	"to_unicode\(\'\\u06DD\.\\uD803\\uDE62\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1599\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-ᡂ.\x{63FCE}", %p)},	undef,	"to_unicode\(\'\-ᡂ\.\\uD94F\\uDFCE\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1600\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≯\x{FDC4}\x{FE0C}。誆⒈", %p)},	undef,	"to_unicode\(\'≯\\uFDC4\\uFE0C。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1601\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{FDC4}\x{FE0C}。誆⒈", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uFDC4\\uFE0C。誆⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯\x{0639}\x{062C}\x{0645}\x{FE0C}。誆1.", %p)},	undef,	"to_unicode\(\'≯\\u0639\\u062C\\u0645\\uFE0C。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1603\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}\x{0639}\x{062C}\x{0645}\x{FE0C}。誆1.", %p)},	undef,	"to_unicode\(\'\>\\u0338\\u0639\\u062C\\u0645\\uFE0C。誆1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1604\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0F99}\x{1EE41}䐊\x{2DF6}．︒\x{07E2}㉼\x{06AB}", %p)},	undef,	"to_unicode\(\'\\u0F99\\uD83B\\uDE41䐊\\u2DF6．︒\\u07E2㉼\\u06AB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1605\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0F99}\x{1EE41}䐊\x{2DF6}.。\x{07E2}참고\x{06AB}", %p)},	undef,	"to_unicode\(\'\\u0F99\\uD83B\\uDE41䐊\\u2DF6\.。\\u07E2참고\\u06AB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ A4_2\ B2\ \[data\/IdnaTest\.txt\:1606\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0F99}\x{1EE41}䐊\x{2DF6}.。\x{07E2}참고\x{06AB}", %p)},	undef,	"to_unicode\(\'\\u0F99\\uD83B\\uDE41䐊\\u2DF6\.。\\u07E2참고\\u06AB\'\)\ throws\ error\ P1\ V5\ V6\ B1\ A4_2\ B2\ \[data\/IdnaTest\.txt\:1607\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{7E510}.\x{200C}\x{E015A}\x{69297}𝟤", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uD9B9\\uDD10\.\\u200C\\uDB40\\uDD5A\\uD964\\uDE97𝟤\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1608\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{7E510}.\x{200C}\x{E015A}\x{69297}𝟤", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uD9B9\\uDD10\.\\u200C\\uDB40\\uDD5A\\uD964\\uDE97𝟤\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1609\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{7E510}.\x{200C}\x{E015A}\x{69297}𝟤", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uD9B9\\uDD10\.\\u200C\\uDB40\\uDD5A\\uD964\\uDE97𝟤\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1610\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{7E510}.\x{200C}\x{E015A}\x{69297}𝟤", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uD9B9\\uDD10\.\\u200C\\uDB40\\uDD5A\\uD964\\uDE97𝟤\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1611\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{7E510}.\x{200C}\x{E015A}\x{69297}2", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uD9B9\\uDD10\.\\u200C\\uDB40\\uDD5A\\uD964\\uDE972\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1612\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{7E510}.\x{200C}\x{E015A}\x{69297}2", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uD9B9\\uDD10\.\\u200C\\uDB40\\uDD5A\\uD964\\uDE972\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1613\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{7E510}.\x{200C}\x{E015A}\x{69297}2", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uD9B9\\uDD10\.\\u200C\\uDB40\\uDD5A\\uD964\\uDE972\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1614\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("퀬-\x{DF7E}\x{7E510}.\x{200C}\x{E015A}\x{69297}2", %p)},	undef,	"to_unicode\(\'퀬\-\\uDF7E\\uD9B9\\uDD10\.\\u200C\\uDB40\\uDD5A\\uD964\\uDE972\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1615\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("퀬", %p)},	"퀬",	"to_unicode\(\'퀬\'\)\ \[data\/IdnaTest\.txt\:1616\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("퀬", %p)},	"퀬",	"to_unicode\(\'퀬\'\)\ \[data\/IdnaTest\.txt\:1617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--8n7b", %p)},	"퀬",	"to_unicode\(\'xn\-\-8n7b\'\)\ \[data\/IdnaTest\.txt\:1618\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴌ.\x{0600}︒\x{09CD}\x{1E9F4}", %p)},	undef,	"to_unicode\(\'Ⴌ\.\\u0600︒\\u09CD\\uD83A\\uDDF4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1619\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴌ.\x{0600}。\x{09CD}\x{1E9F4}", %p)},	undef,	"to_unicode\(\'Ⴌ\.\\u0600。\\u09CD\\uD83A\\uDDF4\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1620\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴌ.\x{0600}。\x{09CD}\x{1E9F4}", %p)},	undef,	"to_unicode\(\'ⴌ\.\\u0600。\\u09CD\\uD83A\\uDDF4\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:1621\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴌ.\x{0600}︒\x{09CD}\x{1E9F4}", %p)},	undef,	"to_unicode\(\'ⴌ\.\\u0600︒\\u09CD\\uD83A\\uDDF4\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1622\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{6E836}\x{193A}。\x{10BAA}\x{1CD1}", %p)},	undef,	"to_unicode\(\'\\uD97A\\uDC36\\u193A。\\uD802\\uDFAA\\u1CD1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1623\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{E04CC}\x{082A}．\x{0A48}\x{0A02}\x{AAF6}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDB41\\uDCCC\\u082A．\\u0A48\\u0A02\\uAAF6\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1624\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{E04CC}\x{082A}．\x{0A48}\x{0A02}\x{AAF6}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDB41\\uDCCC\\u082A．\\u0A48\\u0A02\\uAAF6\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1625\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{E04CC}\x{082A}.\x{0A48}\x{0A02}\x{AAF6}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDB41\\uDCCC\\u082A\.\\u0A48\\u0A02\\uAAF6\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1626\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{E04CC}\x{082A}.\x{0A48}\x{0A02}\x{AAF6}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDB41\\uDCCC\\u082A\.\\u0A48\\u0A02\\uAAF6\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:1627\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{18135}｡۹", %p)},	undef,	"to_unicode\(\'\\uD820\\uDD35｡۹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1628\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{18135}。۹", %p)},	undef,	"to_unicode\(\'\\uD820\\uDD35。۹\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1629\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1A68}刍.⋁", %p)},	undef,	"to_unicode\(\'\\u1A68刍\.⋁\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1630\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E07E0}５｡\x{AABE}🄈", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDFE0５｡\\uAABE🄈\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1631\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E07E0}5。\x{AABE}7,", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDFE05。\\uAABE7\,\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1632\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}𝟳Ⴔ辘.\x{1EC88}ꡬ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0721𝟳Ⴔ辘\.\\uD83B\\uDC88ꡬ\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1633\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}𝟳Ⴔ辘.\x{1EC88}ꡬ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0721𝟳Ⴔ辘\.\\uD83B\\uDC88ꡬ\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1634\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}7Ⴔ辘.\x{1EC88}ꡬ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07217Ⴔ辘\.\\uD83B\\uDC88ꡬ\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1635\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}7Ⴔ辘.\x{1EC88}ꡬ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07217Ⴔ辘\.\\uD83B\\uDC88ꡬ\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1636\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}7ⴔ辘.\x{1EC88}ꡬ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07217ⴔ辘\.\\uD83B\\uDC88ꡬ\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1637\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}7ⴔ辘.\x{1EC88}ꡬ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u07217ⴔ辘\.\\uD83B\\uDC88ꡬ\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1638\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}𝟳ⴔ辘.\x{1EC88}ꡬ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0721𝟳ⴔ辘\.\\uD83B\\uDC88ꡬ\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1639\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}𝟳ⴔ辘.\x{1EC88}ꡬ\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0721𝟳ⴔ辘\.\\uD83B\\uDC88ꡬ\\u200C\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1640\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0981}.ᠨ\x{10A88}\x{96CD6}𝟝", %p)},	undef,	"to_unicode\(\'\\u0981\.ᠨ\\uD802\\uDE88\\uDA1B\\uDCD6𝟝\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1641\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0981}.ᠨ\x{10A88}\x{96CD6}5", %p)},	undef,	"to_unicode\(\'\\u0981\.ᠨ\\uD802\\uDE88\\uDA1B\\uDCD65\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1642\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A87D}≯．\x{91B8E}\x{900A9}", %p)},	undef,	"to_unicode\(\'\\uA87D≯．\\uDA06\\uDF8E\\uDA00\\uDCA9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1643\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A87D}>\x{0338}．\x{91B8E}\x{900A9}", %p)},	undef,	"to_unicode\(\'\\uA87D\>\\u0338．\\uDA06\\uDF8E\\uDA00\\uDCA9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1644\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A87D}≯.\x{91B8E}\x{900A9}", %p)},	undef,	"to_unicode\(\'\\uA87D≯\.\\uDA06\\uDF8E\\uDA00\\uDCA9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1645\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A87D}>\x{0338}.\x{91B8E}\x{900A9}", %p)},	undef,	"to_unicode\(\'\\uA87D\>\\u0338\.\\uDA06\\uDF8E\\uDA00\\uDCA9\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1646\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ςოꡢ.ς\x{084A}", %p)},	undef,	"to_unicode\(\'ςოꡢ\.ς\\u084A\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1647\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σოꡢ.Σ\x{084A}", %p)},	undef,	"to_unicode\(\'Σოꡢ\.Σ\\u084A\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1648\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σოꡢ.σ\x{084A}", %p)},	undef,	"to_unicode\(\'σოꡢ\.σ\\u084A\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1649\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σოꡢ.σ\x{084A}", %p)},	undef,	"to_unicode\(\'Σოꡢ\.σ\\u084A\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1650\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σოꡢ.ς\x{084A}", %p)},	undef,	"to_unicode\(\'Σოꡢ\.ς\\u084A\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1651\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σოꡢ.ς\x{084A}", %p)},	undef,	"to_unicode\(\'σოꡢ\.ς\\u084A\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1652\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{6F521}\x{0316}\x{BA57D}ꡱ｡㇟", %p)},	undef,	"to_unicode\(\'\\uD97D\\uDD21\\u0316\\uDAA9\\uDD7Dꡱ｡㇟\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1653\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{6F521}\x{0316}\x{BA57D}ꡱ。㇟", %p)},	undef,	"to_unicode\(\'\\uD97D\\uDD21\\u0316\\uDAA9\\uDD7Dꡱ。㇟\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1654\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A．\\u200D䤫≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1655\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}．\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A．\\u200D䤫≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1656\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1657\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}．\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A．\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1658\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A\.\\u200D䤫≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1659\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}.\x{200D}䤫≠Ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A\.\\u200D䤫≠Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1660\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1661\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}.\x{200D}䤫=\x{0338}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A\.\\u200D䤫\=\\u0338Ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1662\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1663\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}.\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A\.\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1664\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A\.\\u200D䤫≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1665\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}.\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A\.\\u200D䤫≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1666\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1667\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}．\x{200D}䤫=\x{0338}ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A．\\u200D䤫\=\\u0338ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1668\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A．\\u200D䤫≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1669\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E080A}．\x{200D}䤫≠ⴞ", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC0A．\\u200D䤫≠ⴞ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1670\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10F30}\x{1B44}．\x{0667}\x{20E0}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDF30\\u1B44．\\u0667\\u20E0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1671\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10F30}\x{1B44}.\x{0667}\x{20E0}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDF30\\u1B44\.\\u0667\\u20E0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1672\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🄉⒈\x{E01C0}。𝟷", %p)},	undef,	"to_unicode\(\'🄉⒈\\uDB40\\uDDC0。𝟷\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8,1.\x{E01C0}。1", %p)},	undef,	"to_unicode\(\'8\,1\.\\uDB40\\uDDC0。1\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1674\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{200C}\x{070F}≮．\x{06DD}\x{5D709}4𝟤", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u070F≮．\\u06DD\\uD935\\uDF094𝟤\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1675\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{200C}\x{070F}≮．\x{06DD}\x{5D709}4𝟤", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u070F≮．\\u06DD\\uD935\\uDF094𝟤\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1676\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{200C}\x{070F}<\x{0338}．\x{06DD}\x{5D709}4𝟤", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u070F\<\\u0338．\\u06DD\\uD935\\uDF094𝟤\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1677\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{200C}\x{070F}<\x{0338}．\x{06DD}\x{5D709}4𝟤", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u070F\<\\u0338．\\u06DD\\uD935\\uDF094𝟤\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1678\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{200C}\x{070F}≮.\x{06DD}\x{5D709}42", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u070F≮\.\\u06DD\\uD935\\uDF0942\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1679\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{200C}\x{070F}≮.\x{06DD}\x{5D709}42", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u070F≮\.\\u06DD\\uD935\\uDF0942\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1680\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{200C}\x{070F}<\x{0338}.\x{06DD}\x{5D709}42", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u070F\<\\u0338\.\\u06DD\\uD935\\uDF0942\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1681\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{200C}\x{070F}<\x{0338}.\x{06DD}\x{5D709}42", %p)},	undef,	"to_unicode\(\'\-\\u200C\\u070F\<\\u0338\.\\u06DD\\uD935\\uDF0942\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1682\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-≯딾｡\x{0842}", %p)},	undef,	"to_unicode\(\'\-≯딾｡\\u0842\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1683\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("->\x{0338}딾｡\x{0842}", %p)},	undef,	"to_unicode\(\'\-\>\\u0338딾｡\\u0842\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1684\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-≯딾。\x{0842}", %p)},	undef,	"to_unicode\(\'\-≯딾。\\u0842\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1685\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("->\x{0338}딾。\x{0842}", %p)},	undef,	"to_unicode\(\'\-\>\\u0338딾。\\u0842\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1686\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⽉⒈\x{10E70}-｡🀴\x{200C}", %p)},	undef,	"to_unicode\(\'⽉⒈\\uD803\\uDE70\-｡🀴\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⽉⒈\x{10E70}-｡🀴\x{200C}", %p)},	undef,	"to_unicode\(\'⽉⒈\\uD803\\uDE70\-｡🀴\\u200C\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:1688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("月1.\x{10E70}-。🀴\x{200C}", %p)},	undef,	"to_unicode\(\'月1\.\\uD803\\uDE70\-。🀴\\u200C\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:1689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("月1.\x{10E70}-。🀴\x{200C}", %p)},	undef,	"to_unicode\(\'月1\.\\uD803\\uDE70\-。🀴\\u200C\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:1690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB0}．\x{033E}", %p)},	undef,	"to_unicode\(\'\\u0FB0．\\u033E\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FB0}.\x{033E}", %p)},	undef,	"to_unicode\(\'\\u0FB0\.\\u033E\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉≮｡\x{031B}", %p)},	undef,	"to_unicode\(\'훉≮｡\\u031B\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉<\x{0338}｡\x{031B}", %p)},	undef,	"to_unicode\(\'훉\<\\u0338｡\\u031B\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉≮。\x{031B}", %p)},	undef,	"to_unicode\(\'훉≮。\\u031B\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("훉<\x{0338}。\x{031B}", %p)},	undef,	"to_unicode\(\'훉\<\\u0338。\\u031B\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1696\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE20}\x{40209}\x{E03D0}．\x{B6627}۰\x{08EC}ᡁ", %p)},	undef,	"to_unicode\(\'\\uFE20\\uD8C0\\uDE09\\uDB40\\uDFD0．\\uDA99\\uDE27۰\\u08ECᡁ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1697\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE20}\x{40209}\x{E03D0}.\x{B6627}۰\x{08EC}ᡁ", %p)},	undef,	"to_unicode\(\'\\uFE20\\uD8C0\\uDE09\\uDB40\\uDFD0\.\\uDA99\\uDE27۰\\u08ECᡁ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1698\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A216}ß\x{0620}\x{200C}。\x{10E7A}\x{10C0A}\x{1E9E0}-", %p)},	undef,	"to_unicode\(\'\\uD828\\uDE16ß\\u0620\\u200C。\\uD803\\uDE7A\\uD803\\uDC0A\\uD83A\\uDDE0\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1699\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A216}ß\x{0620}\x{200C}。\x{10E7A}\x{10C0A}\x{1E9E0}-", %p)},	undef,	"to_unicode\(\'\\uD828\\uDE16ß\\u0620\\u200C。\\uD803\\uDE7A\\uD803\\uDC0A\\uD83A\\uDDE0\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1700\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A216}SS\x{0620}\x{200C}。\x{10E7A}\x{10C0A}\x{1E9E0}-", %p)},	undef,	"to_unicode\(\'\\uD828\\uDE16SS\\u0620\\u200C。\\uD803\\uDE7A\\uD803\\uDC0A\\uD83A\\uDDE0\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1701\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A216}SS\x{0620}\x{200C}。\x{10E7A}\x{10C0A}\x{1E9E0}-", %p)},	undef,	"to_unicode\(\'\\uD828\\uDE16SS\\u0620\\u200C。\\uD803\\uDE7A\\uD803\\uDC0A\\uD83A\\uDDE0\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1702\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A216}ss\x{0620}\x{200C}。\x{10E7A}\x{10C0A}\x{1E9E0}-", %p)},	undef,	"to_unicode\(\'\\uD828\\uDE16ss\\u0620\\u200C。\\uD803\\uDE7A\\uD803\\uDC0A\\uD83A\\uDDE0\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1703\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A216}ss\x{0620}\x{200C}。\x{10E7A}\x{10C0A}\x{1E9E0}-", %p)},	undef,	"to_unicode\(\'\\uD828\\uDE16ss\\u0620\\u200C。\\uD803\\uDE7A\\uD803\\uDC0A\\uD83A\\uDDE0\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1704\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A216}Ss\x{0620}\x{200C}。\x{10E7A}\x{10C0A}\x{1E9E0}-", %p)},	undef,	"to_unicode\(\'\\uD828\\uDE16Ss\\u0620\\u200C。\\uD803\\uDE7A\\uD803\\uDC0A\\uD83A\\uDDE0\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1705\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1A216}Ss\x{0620}\x{200C}。\x{10E7A}\x{10C0A}\x{1E9E0}-", %p)},	undef,	"to_unicode\(\'\\uD828\\uDE16Ss\\u0620\\u200C。\\uD803\\uDE7A\\uD803\\uDC0A\\uD83A\\uDDE0\-\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ B1\ \[data\/IdnaTest\.txt\:1706\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0729}。Ↄ\x{E048B}놮-", %p)},	undef,	"to_unicode\(\'\\u0729。Ↄ\\uDB41\\uDC8B놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1707\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0729}。Ↄ\x{E048B}놮-", %p)},	undef,	"to_unicode\(\'\\u0729。Ↄ\\uDB41\\uDC8B놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1708\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0729}。ↄ\x{E048B}놮-", %p)},	undef,	"to_unicode\(\'\\u0729。ↄ\\uDB41\\uDC8B놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1709\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0729}。ↄ\x{E048B}놮-", %p)},	undef,	"to_unicode\(\'\\u0729。ↄ\\uDB41\\uDC8B놮\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:1710\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC01}\x{200D}.\x{99A6A}\x{06A3}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC01\\u200D\.\\uDA26\\uDE6A\\u06A3\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1711\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC01}\x{200D}.\x{99A6A}\x{06A3}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC01\\u200D\.\\uDA26\\uDE6A\\u06A3\'\)\ throws\ error\ P1\ V6\ B3\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1712\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴜ\x{E01CA}\x{07BB}≯。\x{0743}\x{E04C3}\x{1073}", %p)},	undef,	"to_unicode\(\'Ⴜ\\uDB40\\uDDCA\\u07BB≯。\\u0743\\uDB41\\uDCC3\\u1073\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1713\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴜ\x{E01CA}\x{07BB}>\x{0338}。\x{0743}\x{E04C3}\x{1073}", %p)},	undef,	"to_unicode\(\'Ⴜ\\uDB40\\uDDCA\\u07BB\>\\u0338。\\u0743\\uDB41\\uDCC3\\u1073\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1714\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴜ\x{E01CA}\x{07BB}>\x{0338}。\x{0743}\x{E04C3}\x{1073}", %p)},	undef,	"to_unicode\(\'ⴜ\\uDB40\\uDDCA\\u07BB\>\\u0338。\\u0743\\uDB41\\uDCC3\\u1073\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1715\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴜ\x{E01CA}\x{07BB}≯。\x{0743}\x{E04C3}\x{1073}", %p)},	undef,	"to_unicode\(\'ⴜ\\uDB40\\uDDCA\\u07BB≯。\\u0743\\uDB41\\uDCC3\\u1073\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:1716\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟺。\x{FCEA}", %p)},	"4.\x{0634}\x{0647}",	"to_unicode\(\'𝟺。\\uFCEA\'\)\ \[data\/IdnaTest\.txt\:1717\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4。\x{0634}\x{0647}", %p)},	"4.\x{0634}\x{0647}",	"to_unicode\(\'4。\\u0634\\u0647\'\)\ \[data\/IdnaTest\.txt\:1718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.xn--zgb2b", %p)},	"4.\x{0634}\x{0647}",	"to_unicode\(\'4\.xn\-\-zgb2b\'\)\ \[data\/IdnaTest\.txt\:1719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4.\x{0634}\x{0647}", %p)},	"4.\x{0634}\x{0647}",	"to_unicode\(\'4\.\\u0634\\u0647\'\)\ \[data\/IdnaTest\.txt\:1720\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≮\x{0A42}．\x{DD212}\x{09C3}\x{2E48}\x{DE331}", %p)},	undef,	"to_unicode\(\'≮\\u0A42．\\uDB34\\uDE12\\u09C3\\u2E48\\uDB38\\uDF31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1721\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("<\x{0338}\x{0A42}．\x{DD212}\x{09C3}\x{2E48}\x{DE331}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0A42．\\uDB34\\uDE12\\u09C3\\u2E48\\uDB38\\uDF31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1722\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≮\x{0A42}.\x{DD212}\x{09C3}\x{2E48}\x{DE331}", %p)},	undef,	"to_unicode\(\'≮\\u0A42\.\\uDB34\\uDE12\\u09C3\\u2E48\\uDB38\\uDF31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1723\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("<\x{0338}\x{0A42}.\x{DD212}\x{09C3}\x{2E48}\x{DE331}", %p)},	undef,	"to_unicode\(\'\<\\u0338\\u0A42\.\\uDB34\\uDE12\\u09C3\\u2E48\\uDB38\\uDF31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1724\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B6D}\x{05BA}ᢕ．\x{E016D}\x{10E72}\x{E0D0D}", %p)},	undef,	"to_unicode\(\'\\u1B6D\\u05BAᢕ．\\uDB40\\uDD6D\\uD803\\uDE72\\uDB43\\uDD0D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1725\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{05BA}\x{1B6D}ᢕ．\x{E016D}\x{10E72}\x{E0D0D}", %p)},	undef,	"to_unicode\(\'\\u05BA\\u1B6Dᢕ．\\uDB40\\uDD6D\\uD803\\uDE72\\uDB43\\uDD0D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1726\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{05BA}\x{1B6D}ᢕ.\x{E016D}\x{10E72}\x{E0D0D}", %p)},	undef,	"to_unicode\(\'\\u05BA\\u1B6Dᢕ\.\\uDB40\\uDD6D\\uD803\\uDE72\\uDB43\\uDD0D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1727\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10EB5}\x{08A5}\x{200C}\x{0842}．\x{110B9}\x{E01A9}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDEB5\\u08A5\\u200C\\u0842．\\uD804\\uDCB9\\uDB40\\uDDA9\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1728\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10EB5}\x{08A5}\x{200C}\x{0842}.\x{110B9}\x{E01A9}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDEB5\\u08A5\\u200C\\u0842\.\\uD804\\uDCB9\\uDB40\\uDDA9\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:1729\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{ABED}｡\x{200D}\x{9F82E}\x{E0391}\x{8D875}", %p)},	undef,	"to_unicode\(\'\\uABED｡\\u200D\\uDA3E\\uDC2E\\uDB40\\uDF91\\uD9F6\\uDC75\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1730\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{ABED}｡\x{200D}\x{9F82E}\x{E0391}\x{8D875}", %p)},	undef,	"to_unicode\(\'\\uABED｡\\u200D\\uDA3E\\uDC2E\\uDB40\\uDF91\\uD9F6\\uDC75\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1731\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{ABED}。\x{200D}\x{9F82E}\x{E0391}\x{8D875}", %p)},	undef,	"to_unicode\(\'\\uABED。\\u200D\\uDA3E\\uDC2E\\uDB40\\uDF91\\uD9F6\\uDC75\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1732\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{ABED}。\x{200D}\x{9F82E}\x{E0391}\x{8D875}", %p)},	undef,	"to_unicode\(\'\\uABED。\\u200D\\uDA3E\\uDC2E\\uDB40\\uDF91\\uD9F6\\uDC75\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:1733\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{FB58}。𝟪", %p)},	undef,	"to_unicode\(\'\-\\uFB58。𝟪\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{067E}。8", %p)},	undef,	"to_unicode\(\'\-\\u067E。8\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1735\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E5ABF}\x{07D7}\x{200C}｡ꡲ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDEBF\\u07D7\\u200C｡ꡲ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1736\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E5ABF}\x{07D7}\x{200C}｡ꡲ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDEBF\\u07D7\\u200C｡ꡲ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1737\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E5ABF}\x{07D7}\x{200C}。ꡲ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDEBF\\u07D7\\u200C。ꡲ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1738\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E5ABF}\x{07D7}\x{200C}。ꡲ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uDB56\\uDEBF\\u07D7\\u200C。ꡲ\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:1739\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ß\x{0C4C}\x{0827}。ᡨ8🄆", %p)},	undef,	"to_unicode\(\'ß\\u0C4C\\u0827。ᡨ8🄆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{0C4C}\x{0827}。ᡨ85,", %p)},	undef,	"to_unicode\(\'ß\\u0C4C\\u0827。ᡨ85\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{0C4C}\x{0827}。ᡨ85,", %p)},	undef,	"to_unicode\(\'SS\\u0C4C\\u0827。ᡨ85\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{0C4C}\x{0827}。ᡨ85,", %p)},	undef,	"to_unicode\(\'ss\\u0C4C\\u0827。ᡨ85\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{0C4C}\x{0827}。ᡨ85,", %p)},	undef,	"to_unicode\(\'Ss\\u0C4C\\u0827。ᡨ85\,\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{0C4C}\x{0827}。ᡨ8🄆", %p)},	undef,	"to_unicode\(\'SS\\u0C4C\\u0827。ᡨ8🄆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{0C4C}\x{0827}。ᡨ8🄆", %p)},	undef,	"to_unicode\(\'ss\\u0C4C\\u0827。ᡨ8🄆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1746\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{0C4C}\x{0827}。ᡨ8🄆", %p)},	undef,	"to_unicode\(\'Ss\\u0C4C\\u0827。ᡨ8🄆\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1747\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}\x{0B3C}魅⒔．₉\x{0600}ß", %p)},	undef,	"to_unicode\(\'\\u1A60\\u0B3C魅⒔．₉\\u0600ß\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1748\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B3C}\x{1A60}魅⒔．₉\x{0600}ß", %p)},	undef,	"to_unicode\(\'\\u0B3C\\u1A60魅⒔．₉\\u0600ß\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1749\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B3C}\x{1A60}魅13..9\x{0600}ß", %p)},	undef,	"to_unicode\(\'\\u0B3C\\u1A60魅13\.\.9\\u0600ß\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1750\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B3C}\x{1A60}魅13..9\x{0600}SS", %p)},	undef,	"to_unicode\(\'\\u0B3C\\u1A60魅13\.\.9\\u0600SS\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1751\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B3C}\x{1A60}魅13..9\x{0600}ss", %p)},	undef,	"to_unicode\(\'\\u0B3C\\u1A60魅13\.\.9\\u0600ss\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1752\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B3C}\x{1A60}魅13..9\x{0600}Ss", %p)},	undef,	"to_unicode\(\'\\u0B3C\\u1A60魅13\.\.9\\u0600Ss\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:1753\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B3C}\x{1A60}魅⒔．₉\x{0600}SS", %p)},	undef,	"to_unicode\(\'\\u0B3C\\u1A60魅⒔．₉\\u0600SS\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1754\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B3C}\x{1A60}魅⒔．₉\x{0600}ss", %p)},	undef,	"to_unicode\(\'\\u0B3C\\u1A60魅⒔．₉\\u0600ss\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1755\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0B3C}\x{1A60}魅⒔．₉\x{0600}Ss", %p)},	undef,	"to_unicode\(\'\\u0B3C\\u1A60魅⒔．₉\\u0600Ss\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}\x{0B3C}魅⒔．₉\x{0600}SS", %p)},	undef,	"to_unicode\(\'\\u1A60\\u0B3C魅⒔．₉\\u0600SS\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}\x{0B3C}魅⒔．₉\x{0600}ss", %p)},	undef,	"to_unicode\(\'\\u1A60\\u0B3C魅⒔．₉\\u0600ss\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A60}\x{0B3C}魅⒔．₉\x{0600}Ss", %p)},	undef,	"to_unicode\(\'\\u1A60\\u0B3C魅⒔．₉\\u0600Ss\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1759\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07E7}｡\x{AAF6}⒈\x{0CCD}⾞", %p)},	undef,	"to_unicode\(\'\\u07E7｡\\uAAF6⒈\\u0CCD⾞\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1760\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07E7}。\x{AAF6}1.\x{0CCD}車", %p)},	undef,	"to_unicode\(\'\\u07E7。\\uAAF61\.\\u0CCD車\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1761\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0C4B}છ。嵨", %p)},	undef,	"to_unicode\(\'\\u0C4Bછ。嵨\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1762\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ≠Ⴀ.\x{0666}\x{0662}", %p)},	undef,	"to_unicode\(\'Ⴔ≠Ⴀ\.\\u0666\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1763\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ=\x{0338}Ⴀ.\x{0666}\x{0662}", %p)},	undef,	"to_unicode\(\'Ⴔ\=\\u0338Ⴀ\.\\u0666\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1764\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ=\x{0338}ⴀ.\x{0666}\x{0662}", %p)},	undef,	"to_unicode\(\'ⴔ\=\\u0338ⴀ\.\\u0666\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1765\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ≠ⴀ.\x{0666}\x{0662}", %p)},	undef,	"to_unicode\(\'ⴔ≠ⴀ\.\\u0666\\u0662\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1766\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}⒙\x{E01BA}｡\x{20EA}", %p)},	undef,	"to_unicode\(\'\-\\u200C⒙\\uDB40\\uDDBA｡\\u20EA\'\)\ throws\ error\ P1\ V3\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1767\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}⒙\x{E01BA}｡\x{20EA}", %p)},	undef,	"to_unicode\(\'\-\\u200C⒙\\uDB40\\uDDBA｡\\u20EA\'\)\ throws\ error\ P1\ V3\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:1768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}18.\x{E01BA}。\x{20EA}", %p)},	undef,	"to_unicode\(\'\-\\u200C18\.\\uDB40\\uDDBA。\\u20EA\'\)\ throws\ error\ V3\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:1769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{200C}18.\x{E01BA}。\x{20EA}", %p)},	undef,	"to_unicode\(\'\-\\u200C18\.\\uDB40\\uDDBA。\\u20EA\'\)\ throws\ error\ V3\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:1770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒.ʌ\x{0635}-\x{0669}", %p)},	undef,	"to_unicode\(\'︒\.ʌ\\u0635\-\\u0669\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。.ʌ\x{0635}-\x{0669}", %p)},	undef,	"to_unicode\(\'。\.ʌ\\u0635\-\\u0669\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。.Ʌ\x{0635}-\x{0669}", %p)},	undef,	"to_unicode\(\'。\.Ʌ\\u0635\-\\u0669\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:1773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒.Ʌ\x{0635}-\x{0669}", %p)},	undef,	"to_unicode\(\'︒\.Ʌ\\u0635\-\\u0669\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1774\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0347}︒。\x{37450}\x{1CD6}", %p)},	undef,	"to_unicode\(\'\\u0347︒。\\uD89D\\uDC50\\u1CD6\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1775\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0347}。。\x{37450}\x{1CD6}", %p)},	undef,	"to_unicode\(\'\\u0347。。\\uD89D\\uDC50\\u1CD6\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:1776\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E8DD}ß\x{E3676}。ᠯ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDCDDß\\uDB4D\\uDE76。ᠯ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1777\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E8DD}SS\x{E3676}。ᠯ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDCDDSS\\uDB4D\\uDE76。ᠯ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1778\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E8DD}ss\x{E3676}。ᠯ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDCDDss\\uDB4D\\uDE76。ᠯ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1779\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1E8DD}Ss\x{E3676}。ᠯ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDCDDSs\\uDB4D\\uDE76。ᠯ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1780\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0C4D}\x{200D}ꡂ\x{10E7E}。\x{79186}\x{9A953}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'\\u0C4D\\u200Dꡂ\\uD803\\uDE7E。\\uD9A4\\uDD86\\uDA2A\\uDD53\\u200C\\u0308\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1781\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0C4D}\x{200D}ꡂ\x{10E7E}。\x{79186}\x{9A953}\x{200C}\x{0308}", %p)},	undef,	"to_unicode\(\'\\u0C4D\\u200Dꡂ\\uD803\\uDE7E。\\uD9A4\\uDD86\\uDA2A\\uDD53\\u200C\\u0308\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1782\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-ß\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1783\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-ß\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1784\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1785\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1786\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-ß\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1787\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-ß\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-ß\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1788\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1789\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-ß\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-ß\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1790\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1791\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1792\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-SS\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1793\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-SS\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1794\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-ss\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1795\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-ss\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1796\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1797\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1798\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1799\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1800\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-Ss\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1801\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}.-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1\.\-Ss\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1802\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1803\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-SS\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-SS\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1804\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-SS\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1805\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-SS\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-SS\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1806\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-ss\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1807\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-ss\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1808\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1809\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1810\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1811\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-Ss\x{200C}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-Ss\\u200C\=\\u0338\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1812\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-Ss\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1813\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0EF1}．-Ss\x{200C}≠", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDEF1．\-Ss\\u200C≠\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:1814\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0641}\x{200C}｡≯𝟡≠", %p)},	undef,	"to_unicode\(\'\\u0641\\u200C｡≯𝟡≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1815\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}\x{200C}｡≯𝟡≠", %p)},	undef,	"to_unicode\(\'\\u0641\\u200C｡≯𝟡≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1816\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}\x{200C}｡>\x{0338}𝟡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\\u200C｡\>\\u0338𝟡\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1817\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}\x{200C}｡>\x{0338}𝟡=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\\u200C｡\>\\u0338𝟡\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1818\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}\x{200C}。≯9≠", %p)},	undef,	"to_unicode\(\'\\u0641\\u200C。≯9≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1819\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}\x{200C}。≯9≠", %p)},	undef,	"to_unicode\(\'\\u0641\\u200C。≯9≠\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1820\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}\x{200C}。>\x{0338}9=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\\u200C。\>\\u03389\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1821\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}\x{200C}。>\x{0338}9=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\\u200C。\>\\u03389\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:1822\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E74}\x{1E84A}\x{1CDC}\x{8F885}。\x{E0063}⁴", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE74\\uD83A\\uDC4A\\u1CDC\\uD9FE\\uDC85。\\uDB40\\uDC63⁴\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1823\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E74}\x{1E84A}\x{1CDC}\x{8F885}。\x{E0063}4", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE74\\uD83A\\uDC4A\\u1CDC\\uD9FE\\uDC85。\\uDB40\\uDC634\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1824\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴄ．\x{200D}ᡇ𦥍ς", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200Dᡇ𦥍ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}ᡇ𦥍ς", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200Dᡇ𦥍ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}ᡇ𦥍ς", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200Dᡇ𦥍ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}ᡇ𦥍ς", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200Dᡇ𦥍ς\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}ᡇ𦥍ς", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200Dᡇ𦥍ς\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}ᡇ𦥍ς", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200Dᡇ𦥍ς\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}ᡇ𦥍Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200Dᡇ𦥍Σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.\x{200D}ᡇ𦥍Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.\\u200Dᡇ𦥍Σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}ᡇ𦥍σ", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200Dᡇ𦥍σ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1833\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.\x{200D}ᡇ𦥍σ", %p)},	undef,	"to_unicode\(\'ⴄ\.\\u200Dᡇ𦥍σ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1834\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--vkj.xn--4xa716hww74b", %p)},	"ⴄ.ᡇ𦥍σ",	"to_unicode\(\'xn\-\-vkj\.xn\-\-4xa716hww74b\'\)\ \[data\/IdnaTest\.txt\:1835\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ.ᡇ𦥍σ", %p)},	"ⴄ.ᡇ𦥍σ",	"to_unicode\(\'ⴄ\.ᡇ𦥍σ\'\)\ \[data\/IdnaTest\.txt\:1836\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ.ᡇ𦥍Σ", %p)},	undef,	"to_unicode\(\'Ⴄ\.ᡇ𦥍Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1837\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}ᡇ𦥍ς", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200Dᡇ𦥍ς\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1838\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}ᡇ𦥍ς", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200Dᡇ𦥍ς\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1839\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}ᡇ𦥍Σ", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200Dᡇ𦥍Σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1840\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴄ．\x{200D}ᡇ𦥍Σ", %p)},	undef,	"to_unicode\(\'Ⴄ．\\u200Dᡇ𦥍Σ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1841\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}ᡇ𦥍σ", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200Dᡇ𦥍σ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1842\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴄ．\x{200D}ᡇ𦥍σ", %p)},	undef,	"to_unicode\(\'ⴄ．\\u200Dᡇ𦥍σ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:1843\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{946D2}\x{E01B7}.Ⴕ", %p)},	undef,	"to_unicode\(\'\\uDA11\\uDED2\\uDB40\\uDDB7\.Ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1844\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{946D2}\x{E01B7}.ⴕ", %p)},	undef,	"to_unicode\(\'\\uDA11\\uDED2\\uDB40\\uDDB7\.ⴕ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1845\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≯\x{E0070}\x{1E98E}。\x{200C}\x{1B44}⻱\x{200D}", %p)},	undef,	"to_unicode\(\'≯\\uDB40\\uDC70\\uD83A\\uDD8E。\\u200C\\u1B44⻱\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1846\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≯\x{E0070}\x{1E98E}。\x{200C}\x{1B44}⻱\x{200D}", %p)},	undef,	"to_unicode\(\'≯\\uDB40\\uDC70\\uD83A\\uDD8E。\\u200C\\u1B44⻱\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1847\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(">\x{0338}\x{E0070}\x{1E98E}。\x{200C}\x{1B44}⻱\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uDB40\\uDC70\\uD83A\\uDD8E。\\u200C\\u1B44⻱\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1848\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(">\x{0338}\x{E0070}\x{1E98E}。\x{200C}\x{1B44}⻱\x{200D}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uDB40\\uDC70\\uD83A\\uDD8E。\\u200C\\u1B44⻱\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:1849\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{05B0}｡\x{E6583}", %p)},	undef,	"to_unicode\(\'\\u200C\\u05B0｡\\uDB59\\uDD83\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1850\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{05B0}｡\x{E6583}", %p)},	undef,	"to_unicode\(\'\\u200C\\u05B0｡\\uDB59\\uDD83\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1851\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{05B0}。\x{E6583}", %p)},	undef,	"to_unicode\(\'\\u200C\\u05B0。\\uDB59\\uDD83\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1852\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{05B0}。\x{E6583}", %p)},	undef,	"to_unicode\(\'\\u200C\\u05B0。\\uDB59\\uDD83\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:1853\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{E01C1}焅.\x{583E9}\x{200D}ꡑ", %p)},	undef,	"to_unicode\(\'⒈\\uDB40\\uDDC1焅\.\\uD920\\uDFE9\\u200Dꡑ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1854\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{E01C1}焅.\x{583E9}\x{200D}ꡑ", %p)},	undef,	"to_unicode\(\'⒈\\uDB40\\uDDC1焅\.\\uD920\\uDFE9\\u200Dꡑ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1855\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{E01C1}焅.\x{583E9}\x{200D}ꡑ", %p)},	undef,	"to_unicode\(\'1\.\\uDB40\\uDDC1焅\.\\uD920\\uDFE9\\u200Dꡑ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1856\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{E01C1}焅.\x{583E9}\x{200D}ꡑ", %p)},	undef,	"to_unicode\(\'1\.\\uDB40\\uDDC1焅\.\\uD920\\uDFE9\\u200Dꡑ\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:1857\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1DDA}ς≮.ς\x{E0184}\x{0762}𝟽", %p)},	undef,	"to_unicode\(\'\\u1DDAς≮\.ς\\uDB40\\uDD84\\u0762𝟽\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1858\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}ς<\x{0338}.ς\x{E0184}\x{0762}𝟽", %p)},	undef,	"to_unicode\(\'\\u1DDAς\<\\u0338\.ς\\uDB40\\uDD84\\u0762𝟽\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1859\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}ς≮.ς\x{E0184}\x{0762}7", %p)},	undef,	"to_unicode\(\'\\u1DDAς≮\.ς\\uDB40\\uDD84\\u07627\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1860\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}ς<\x{0338}.ς\x{E0184}\x{0762}7", %p)},	undef,	"to_unicode\(\'\\u1DDAς\<\\u0338\.ς\\uDB40\\uDD84\\u07627\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}Σ<\x{0338}.Σ\x{E0184}\x{0762}7", %p)},	undef,	"to_unicode\(\'\\u1DDAΣ\<\\u0338\.Σ\\uDB40\\uDD84\\u07627\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}Σ≮.Σ\x{E0184}\x{0762}7", %p)},	undef,	"to_unicode\(\'\\u1DDAΣ≮\.Σ\\uDB40\\uDD84\\u07627\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}σ≮.σ\x{E0184}\x{0762}7", %p)},	undef,	"to_unicode\(\'\\u1DDAσ≮\.σ\\uDB40\\uDD84\\u07627\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}σ<\x{0338}.σ\x{E0184}\x{0762}7", %p)},	undef,	"to_unicode\(\'\\u1DDAσ\<\\u0338\.σ\\uDB40\\uDD84\\u07627\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}Σ<\x{0338}.Σ\x{E0184}\x{0762}𝟽", %p)},	undef,	"to_unicode\(\'\\u1DDAΣ\<\\u0338\.Σ\\uDB40\\uDD84\\u0762𝟽\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}Σ≮.Σ\x{E0184}\x{0762}𝟽", %p)},	undef,	"to_unicode\(\'\\u1DDAΣ≮\.Σ\\uDB40\\uDD84\\u0762𝟽\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1867\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}σ≮.σ\x{E0184}\x{0762}𝟽", %p)},	undef,	"to_unicode\(\'\\u1DDAσ≮\.σ\\uDB40\\uDD84\\u0762𝟽\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1868\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDA}σ<\x{0338}.σ\x{E0184}\x{0762}𝟽", %p)},	undef,	"to_unicode\(\'\\u1DDAσ\<\\u0338\.σ\\uDB40\\uDD84\\u0762𝟽\'\)\ throws\ error\ P1\ V5\ V6\ B5\ \[data\/IdnaTest\.txt\:1869\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D69D1}ß\x{033D}\x{0767}.\x{E014E}\x{0755}", %p)},	undef,	"to_unicode\(\'\\uDB1A\\uDDD1ß\\u033D\\u0767\.\\uDB40\\uDD4E\\u0755\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1870\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D69D1}SS\x{033D}\x{0767}.\x{E014E}\x{0755}", %p)},	undef,	"to_unicode\(\'\\uDB1A\\uDDD1SS\\u033D\\u0767\.\\uDB40\\uDD4E\\u0755\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1871\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D69D1}ss\x{033D}\x{0767}.\x{E014E}\x{0755}", %p)},	undef,	"to_unicode\(\'\\uDB1A\\uDDD1ss\\u033D\\u0767\.\\uDB40\\uDD4E\\u0755\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1872\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D69D1}Ss\x{033D}\x{0767}.\x{E014E}\x{0755}", %p)},	undef,	"to_unicode\(\'\\uDB1A\\uDDD1Ss\\u033D\\u0767\.\\uDB40\\uDD4E\\u0755\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1873\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-\x{FC12}｡⒈", %p)},	undef,	"to_unicode\(\'\-\\uFC12｡⒈\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:1874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-\x{062B}\x{0645}。1.", %p)},	undef,	"to_unicode\(\'\-\\u062B\\u0645。1\.\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:1875\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{87A26}\x{0682}𝟲。\x{06EF}\x{1734}", %p)},	undef,	"to_unicode\(\'\\uD9DE\\uDE26\\u0682𝟲。\\u06EF\\u1734\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1876\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{87A26}\x{0682}6。\x{06EF}\x{1734}", %p)},	undef,	"to_unicode\(\'\\uD9DE\\uDE26\\u06826。\\u06EF\\u1734\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1877\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E64}\x{10F90}\x{0666}\x{0EB9}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE64\\uD803\\uDF90\\u0666\\u0EB9\.\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1878\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E64}\x{10F90}\x{0666}\x{0EB9}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE64\\uD803\\uDF90\\u0666\\u0EB9\.\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1879\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("₅．Ⴇ\x{32E8C}\x{10D51}\x{ECE9B}", %p)},	undef,	"to_unicode\(\'₅．Ⴇ\\uD88B\\uDE8C\\uD803\\uDD51\\uDB73\\uDE9B\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1880\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("5.Ⴇ\x{32E8C}\x{10D51}\x{ECE9B}", %p)},	undef,	"to_unicode\(\'5\.Ⴇ\\uD88B\\uDE8C\\uD803\\uDD51\\uDB73\\uDE9B\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1881\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("5.ⴇ\x{32E8C}\x{10D51}\x{ECE9B}", %p)},	undef,	"to_unicode\(\'5\.ⴇ\\uD88B\\uDE8C\\uD803\\uDD51\\uDB73\\uDE9B\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1882\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("₅．ⴇ\x{32E8C}\x{10D51}\x{ECE9B}", %p)},	undef,	"to_unicode\(\'₅．ⴇ\\uD88B\\uDE8C\\uD803\\uDD51\\uDB73\\uDE9B\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:1883\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0F84}\x{E052B}.\x{E0169}ꡇ", %p)},	undef,	"to_unicode\(\'\\u0F84\\uDB41\\uDD2B\.\\uDB40\\uDD69ꡇ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:1884\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-\x{075F}.\x{67A96}", %p)},	undef,	"to_unicode\(\'\\u200D\-\\u075F\.\\uD95E\\uDE96\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1885\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}-\x{075F}.\x{67A96}", %p)},	undef,	"to_unicode\(\'\\u200D\-\\u075F\.\\uD95E\\uDE96\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:1886\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BA}ꡛ\x{074E}寐｡\x{200C}≯\x{E01FF}", %p)},	undef,	"to_unicode\(\'\\u06BAꡛ\\u074E寐｡\\u200C≯\\uDB40\\uDDFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1887\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BA}ꡛ\x{074E}寐｡\x{200C}≯\x{E01FF}", %p)},	undef,	"to_unicode\(\'\\u06BAꡛ\\u074E寐｡\\u200C≯\\uDB40\\uDDFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1888\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BA}ꡛ\x{074E}寐｡\x{200C}>\x{0338}\x{E01FF}", %p)},	undef,	"to_unicode\(\'\\u06BAꡛ\\u074E寐｡\\u200C\>\\u0338\\uDB40\\uDDFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1889\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BA}ꡛ\x{074E}寐｡\x{200C}>\x{0338}\x{E01FF}", %p)},	undef,	"to_unicode\(\'\\u06BAꡛ\\u074E寐｡\\u200C\>\\u0338\\uDB40\\uDDFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1890\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BA}ꡛ\x{074E}寐。\x{200C}≯\x{E01FF}", %p)},	undef,	"to_unicode\(\'\\u06BAꡛ\\u074E寐。\\u200C≯\\uDB40\\uDDFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1891\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BA}ꡛ\x{074E}寐。\x{200C}≯\x{E01FF}", %p)},	undef,	"to_unicode\(\'\\u06BAꡛ\\u074E寐。\\u200C≯\\uDB40\\uDDFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1892\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BA}ꡛ\x{074E}寐。\x{200C}>\x{0338}\x{E01FF}", %p)},	undef,	"to_unicode\(\'\\u06BAꡛ\\u074E寐。\\u200C\>\\u0338\\uDB40\\uDDFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1893\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BA}ꡛ\x{074E}寐。\x{200C}>\x{0338}\x{E01FF}", %p)},	undef,	"to_unicode\(\'\\u06BAꡛ\\u074E寐。\\u200C\>\\u0338\\uDB40\\uDDFF\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:1894\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}｡穛ႺႴ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D｡穛ႺႴ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1895\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}｡穛ႺႴ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D｡穛ႺႴ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1896\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。穛ႺႴ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D。穛ႺႴ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1897\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。穛ႺႴ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D。穛ႺႴ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1898\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。穛ⴚⴔ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D。穛ⴚⴔ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1899\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。穛ⴚⴔ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D。穛ⴚⴔ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1900\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。穛Ⴚⴔ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D。穛Ⴚⴔ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1901\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。穛Ⴚⴔ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D。穛Ⴚⴔ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1902\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}｡穛ⴚⴔ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D｡穛ⴚⴔ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1903\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}｡穛ⴚⴔ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D｡穛ⴚⴔ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1904\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}｡穛Ⴚⴔ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D｡穛Ⴚⴔ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1905\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}｡穛Ⴚⴔ\x{1ECBF}", %p)},	undef,	"to_unicode\(\'\\u200D｡穛Ⴚⴔ\\uD83B\\uDCBF\'\)\ throws\ error\ P1\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:1906\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-４.\x{200D}ヌ\x{08AC}", %p)},	undef,	"to_unicode\(\'\-４\.\\u200Dヌ\\u08AC\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1907\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-４.\x{200D}ヌ\x{08AC}", %p)},	undef,	"to_unicode\(\'\-４\.\\u200Dヌ\\u08AC\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1908\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-4.\x{200D}ヌ\x{08AC}", %p)},	undef,	"to_unicode\(\'\-4\.\\u200Dヌ\\u08AC\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1909\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-4.\x{200D}ヌ\x{08AC}", %p)},	undef,	"to_unicode\(\'\-4\.\\u200Dヌ\\u08AC\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1910\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︐\x{10E64}ß\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'︐\\uD803\\uDE64ß\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1911\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︐\x{10E64}ß\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'︐\\uD803\\uDE64ß\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1912\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(",\x{10E64}ß\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'\,\\uD803\\uDE64ß\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1913\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(",\x{10E64}ß\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'\,\\uD803\\uDE64ß\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1914\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(",\x{10E64}SS\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'\,\\uD803\\uDE64SS\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1915\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(",\x{10E64}SS\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'\,\\uD803\\uDE64SS\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1916\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(",\x{10E64}ss\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'\,\\uD803\\uDE64ss\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1917\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(",\x{10E64}ss\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'\,\\uD803\\uDE64ss\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1918\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(",\x{10E64}Ss\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'\,\\uD803\\uDE64Ss\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1919\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(",\x{10E64}Ss\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'\,\\uD803\\uDE64Ss\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1920\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︐\x{10E64}SS\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'︐\\uD803\\uDE64SS\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1921\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︐\x{10E64}SS\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'︐\\uD803\\uDE64SS\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1922\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︐\x{10E64}ss\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'︐\\uD803\\uDE64ss\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1923\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︐\x{10E64}ss\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'︐\\uD803\\uDE64ss\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1924\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︐\x{10E64}Ss\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'︐\\uD803\\uDE64Ss\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1925\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︐\x{10E64}Ss\x{200D}。⦭\x{105DD5}\x{10E3F}-", %p)},	undef,	"to_unicode\(\'︐\\uD803\\uDE64Ss\\u200D。⦭\\uDBD7\\uDDD5\\uD803\\uDE3F\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:1926\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꇟ-\x{FC06}ᡉ。\x{B357A}\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\\uFC06ᡉ。\\uDA8D\\uDD7A\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1927\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꇟ-\x{FC06}ᡉ。\x{B357A}\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\\uFC06ᡉ。\\uDA8D\\uDD7A\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1928\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꇟ-\x{0628}\x{062D}ᡉ。\x{B357A}\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\\u0628\\u062Dᡉ。\\uDA8D\\uDD7A\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1929\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꇟ-\x{0628}\x{062D}ᡉ。\x{B357A}\x{200C}", %p)},	undef,	"to_unicode\(\'ꇟ\-\\u0628\\u062Dᡉ。\\uDA8D\\uDD7A\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:1930\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7C}.\x{11001}\x{FD09}\x{07AA}\x{35A0B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7C\.\\uD804\\uDC01\\uFD09\\u07AA\\uD896\\uDE0B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1931\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E7C}.\x{11001}\x{0634}\x{062C}\x{07AA}\x{35A0B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7C\.\\uD804\\uDC01\\u0634\\u062C\\u07AA\\uD896\\uDE0B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:1932\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.\x{3F861}\x{0756}\x{0B4D}", %p)},	undef,	"to_unicode\(\'\-\.\\uD8BE\\uDC61\\u0756\\u0B4D\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1933\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AB69E}ς.\x{10C84}녫ß", %p)},	undef,	"to_unicode\(\'\\uDA6D\\uDE9Eς\.\\uD803\\uDC84녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1934\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AB69E}ς.\x{10C84}녫ß", %p)},	undef,	"to_unicode\(\'\\uDA6D\\uDE9Eς\.\\uD803\\uDC84녫ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1935\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AB69E}Σ.\x{10C84}녫SS", %p)},	undef,	"to_unicode\(\'\\uDA6D\\uDE9EΣ\.\\uD803\\uDC84녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1936\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AB69E}Σ.\x{10C84}녫SS", %p)},	undef,	"to_unicode\(\'\\uDA6D\\uDE9EΣ\.\\uD803\\uDC84녫SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1937\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AB69E}σ.\x{10C84}녫ss", %p)},	undef,	"to_unicode\(\'\\uDA6D\\uDE9Eσ\.\\uD803\\uDC84녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1938\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AB69E}σ.\x{10C84}녫ss", %p)},	undef,	"to_unicode\(\'\\uDA6D\\uDE9Eσ\.\\uD803\\uDC84녫ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1939\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AB69E}Σ.\x{10C84}녫Ss", %p)},	undef,	"to_unicode\(\'\\uDA6D\\uDE9EΣ\.\\uD803\\uDC84녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1940\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AB69E}Σ.\x{10C84}녫Ss", %p)},	undef,	"to_unicode\(\'\\uDA6D\\uDE9EΣ\.\\uD803\\uDC84녫Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:1941\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⅎ\x{1BAA}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u1BAA\\u200D｡≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1942\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{1BAA}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u1BAA\\u200D｡≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1943\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{1BAA}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u1BAA\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1944\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{1BAA}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u1BAA\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1945\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{1BAA}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u1BAA\\u200D。≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1946\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{1BAA}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u1BAA\\u200D。≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1947\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{1BAA}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u1BAA\\u200D。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1948\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⅎ\x{1BAA}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⅎ\\u1BAA\\u200D。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1949\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{1BAA}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u1BAA\\u200D。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{1BAA}\x{200D}。=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u1BAA\\u200D。\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{1BAA}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u1BAA\\u200D。≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{1BAA}\x{200D}。≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u1BAA\\u200D。≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{1BAA}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u1BAA\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{1BAA}\x{200D}｡=\x{0338}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u1BAA\\u200D｡\=\\u0338\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{1BAA}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u1BAA\\u200D｡≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⅎ\x{1BAA}\x{200D}｡≠\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ⅎ\\u1BAA\\u200D｡≠\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ C2\ C1\ \[data\/IdnaTest\.txt\:1957\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⁹\x{11133}\x{1734}\x{EEA81}．\x{200C}\x{1734}\x{07E0}", %p)},	undef,	"to_unicode\(\'⁹\\uD804\\uDD33\\u1734\\uDB7A\\uDE81．\\u200C\\u1734\\u07E0\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1958\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⁹\x{11133}\x{1734}\x{EEA81}．\x{200C}\x{1734}\x{07E0}", %p)},	undef,	"to_unicode\(\'⁹\\uD804\\uDD33\\u1734\\uDB7A\\uDE81．\\u200C\\u1734\\u07E0\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1959\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("9\x{11133}\x{1734}\x{EEA81}.\x{200C}\x{1734}\x{07E0}", %p)},	undef,	"to_unicode\(\'9\\uD804\\uDD33\\u1734\\uDB7A\\uDE81\.\\u200C\\u1734\\u07E0\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1960\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("9\x{11133}\x{1734}\x{EEA81}.\x{200C}\x{1734}\x{07E0}", %p)},	undef,	"to_unicode\(\'9\\uD804\\uDD33\\u1734\\uDB7A\\uDE81\.\\u200C\\u1734\\u07E0\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:1961\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7182B}\x{E0066}．≯", %p)},	undef,	"to_unicode\(\'\\uD986\\uDC2B\\uDB40\\uDC66．≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1962\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7182B}\x{E0066}．>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD986\\uDC2B\\uDB40\\uDC66．\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1963\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7182B}\x{E0066}.≯", %p)},	undef,	"to_unicode\(\'\\uD986\\uDC2B\\uDB40\\uDC66\.≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1964\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7182B}\x{E0066}.>\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD986\\uDC2B\\uDB40\\uDC66\.\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:1965\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{1EFE4}Ⴓ．\x{0324}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD83B\\uDFE4Ⴓ．\\u0324\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1966\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{1EFE4}Ⴓ．\x{0324}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD83B\\uDFE4Ⴓ．\\u0324\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1967\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{1EFE4}Ⴓ.\x{0324}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD83B\\uDFE4Ⴓ\.\\u0324\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1968\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{1EFE4}Ⴓ.\x{0324}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD83B\\uDFE4Ⴓ\.\\u0324\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1969\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{1EFE4}ⴓ.\x{0324}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD83B\\uDFE4ⴓ\.\\u0324\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1970\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{1EFE4}ⴓ.\x{0324}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD83B\\uDFE4ⴓ\.\\u0324\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1971\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{1EFE4}ⴓ．\x{0324}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD83B\\uDFE4ⴓ．\\u0324\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1972\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{1EFE4}ⴓ．\x{0324}", %p)},	undef,	"to_unicode\(\'\\u200D\\uD83B\\uDFE4ⴓ．\\u0324\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:1973\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FED3}ß\x{0333}．\x{0766}", %p)},	undef,	"to_unicode\(\'\\uFED3ß\\u0333．\\u0766\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1974\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}ß\x{0333}.\x{0766}", %p)},	undef,	"to_unicode\(\'\\u0641ß\\u0333\.\\u0766\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1975\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}SS\x{0333}.\x{0766}", %p)},	undef,	"to_unicode\(\'\\u0641SS\\u0333\.\\u0766\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1976\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}ss\x{0333}.\x{0766}", %p)},	undef,	"to_unicode\(\'\\u0641ss\\u0333\.\\u0766\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1977\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}Ss\x{0333}.\x{0766}", %p)},	undef,	"to_unicode\(\'\\u0641Ss\\u0333\.\\u0766\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1978\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FED3}SS\x{0333}．\x{0766}", %p)},	undef,	"to_unicode\(\'\\uFED3SS\\u0333．\\u0766\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1979\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FED3}ss\x{0333}．\x{0766}", %p)},	undef,	"to_unicode\(\'\\uFED3ss\\u0333．\\u0766\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1980\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FED3}Ss\x{0333}．\x{0766}", %p)},	undef,	"to_unicode\(\'\\uFED3Ss\\u0333．\\u0766\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:1981\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{E01AD}鸮\x{1039}.ς", %p)},	undef,	"to_unicode\(\'\\u0CCD\\uDB40\\uDDAD鸮\\u1039\.ς\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1982\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{E01AD}鸮\x{1039}.Σ", %p)},	undef,	"to_unicode\(\'\\u0CCD\\uDB40\\uDDAD鸮\\u1039\.Σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0CCD}\x{E01AD}鸮\x{1039}.σ", %p)},	undef,	"to_unicode\(\'\\u0CCD\\uDB40\\uDDAD鸮\\u1039\.σ\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:1984\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟐ꡩ。-\x{11134}", %p)},	undef,	"to_unicode\(\'𝟐ꡩ。\-\\uD804\\uDD34\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1985\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("2ꡩ。-\x{11134}", %p)},	undef,	"to_unicode\(\'2ꡩ。\-\\uD804\\uDD34\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:1986\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0779}ᡲ⟙｡\x{10E6D}\x{0775}⒈", %p)},	undef,	"to_unicode\(\'\\u0779ᡲ⟙｡\\uD803\\uDE6D\\u0775⒈\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0779}ᡲ⟙。\x{10E6D}\x{0775}1.", %p)},	undef,	"to_unicode\(\'\\u0779ᡲ⟙。\\uD803\\uDE6D\\u07751\.\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:1988\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2433}\x{109409}𝟣\x{10E78}.ᢉ8\x{05AC}\x{06DD}", %p)},	undef,	"to_unicode\(\'\\u2433\\uDBE5\\uDC09𝟣\\uD803\\uDE78\.ᢉ8\\u05AC\\u06DD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1989\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2433}\x{109409}1\x{10E78}.ᢉ8\x{05AC}\x{06DD}", %p)},	undef,	"to_unicode\(\'\\u2433\\uDBE5\\uDC091\\uD803\\uDE78\.ᢉ8\\u05AC\\u06DD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:1990\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0603}.𝟤𝟶-\x{CCEF0}", %p)},	undef,	"to_unicode\(\'\\u0603\.𝟤𝟶\-\\uDAF3\\uDEF0\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1991\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0603}.20-\x{CCEF0}", %p)},	undef,	"to_unicode\(\'\\u0603\.20\-\\uDAF3\\uDEF0\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:1992\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς-。\x{200C}⒚-", %p)},	undef,	"to_unicode\(\'ς\-。\\u200C⒚\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1993\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}⒚-", %p)},	undef,	"to_unicode\(\'ς\-。\\u200C⒚\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:1994\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}19.-", %p)},	undef,	"to_unicode\(\'ς\-。\\u200C19\.\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1995\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς-。\x{200C}19.-", %p)},	undef,	"to_unicode\(\'ς\-。\\u200C19\.\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1996\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}19.-", %p)},	undef,	"to_unicode\(\'Σ\-。\\u200C19\.\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1997\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}19.-", %p)},	undef,	"to_unicode\(\'Σ\-。\\u200C19\.\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1998\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}19.-", %p)},	undef,	"to_unicode\(\'σ\-。\\u200C19\.\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:1999\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}19.-", %p)},	undef,	"to_unicode\(\'σ\-。\\u200C19\.\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2000\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}⒚-", %p)},	undef,	"to_unicode\(\'Σ\-。\\u200C⒚\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:2001\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ-。\x{200C}⒚-", %p)},	undef,	"to_unicode\(\'Σ\-。\\u200C⒚\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:2002\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}⒚-", %p)},	undef,	"to_unicode\(\'σ\-。\\u200C⒚\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:2003\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ-。\x{200C}⒚-", %p)},	undef,	"to_unicode\(\'σ\-。\\u200C⒚\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:2004\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}-\x{E0079}．\x{0AC5}Ⴄ", %p)},	undef,	"to_unicode\(\'\\u0DCA\-\\uDB40\\uDC79．\\u0AC5Ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2005\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}-\x{E0079}.\x{0AC5}Ⴄ", %p)},	undef,	"to_unicode\(\'\\u0DCA\-\\uDB40\\uDC79\.\\u0AC5Ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2006\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}-\x{E0079}.\x{0AC5}ⴄ", %p)},	undef,	"to_unicode\(\'\\u0DCA\-\\uDB40\\uDC79\.\\u0AC5ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2007\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0DCA}-\x{E0079}．\x{0AC5}ⴄ", %p)},	undef,	"to_unicode\(\'\\u0DCA\-\\uDB40\\uDC79．\\u0AC5ⴄ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2008\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{ECD27}\x{E05E9}\x{06AF}\x{109AF}｡⏆⒈", %p)},	undef,	"to_unicode\(\'\\uDB73\\uDD27\\uDB41\\uDDE9\\u06AF\\uD802\\uDDAF｡⏆⒈\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2009\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{ECD27}\x{E05E9}\x{06AF}\x{109AF}。⏆1.", %p)},	undef,	"to_unicode\(\'\\uDB73\\uDD27\\uDB41\\uDDE9\\u06AF\\uD802\\uDDAF。⏆1\.\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2010\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0C4D}．\x{0646}\x{0ECA}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0C4D．\\u0646\\u0ECA\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:2011\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C4D}．\x{0646}\x{0ECA}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0C4D．\\u0646\\u0ECA\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:2012\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C4D}.\x{0646}\x{0ECA}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0C4D\.\\u0646\\u0ECA\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:2013\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0C4D}.\x{0646}\x{0ECA}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0C4D\.\\u0646\\u0ECA\\u200C\'\)\ throws\ error\ V5\ B3\ C1\ \[data\/IdnaTest\.txt\:2014\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3CA91}\x{06D1}≮\x{1BAA}．\x{FEA3}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDE91\\u06D1≮\\u1BAA．\\uFEA3\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2015\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3CA91}\x{06D1}<\x{0338}\x{1BAA}．\x{FEA3}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDE91\\u06D1\<\\u0338\\u1BAA．\\uFEA3\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2016\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3CA91}\x{06D1}≮\x{1BAA}.\x{062D}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDE91\\u06D1≮\\u1BAA\.\\u062D\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2017\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3CA91}\x{06D1}<\x{0338}\x{1BAA}.\x{062D}", %p)},	undef,	"to_unicode\(\'\\uD8B2\\uDE91\\u06D1\<\\u0338\\u1BAA\.\\u062D\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2018\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}。\x{0FA9}⒈ꡍ\x{108614}", %p)},	undef,	"to_unicode\(\'\\u200D。\\u0FA9⒈ꡍ\\uDBE1\\uDE14\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2019\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{0FA9}⒈ꡍ\x{108614}", %p)},	undef,	"to_unicode\(\'\\u200D。\\u0FA9⒈ꡍ\\uDBE1\\uDE14\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2020\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{0FA9}1.ꡍ\x{108614}", %p)},	undef,	"to_unicode\(\'\\u200D。\\u0FA91\.ꡍ\\uDBE1\\uDE14\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2021\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{0FA9}1.ꡍ\x{108614}", %p)},	undef,	"to_unicode\(\'\\u200D。\\u0FA91\.ꡍ\\uDBE1\\uDE14\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2022\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷ᠤ．\x{1EC84}≠", %p)},	undef,	"to_unicode\(\'۷ᠤ．\\uD83B\\uDC84≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2023\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷ᠤ．\x{1EC84}=\x{0338}", %p)},	undef,	"to_unicode\(\'۷ᠤ．\\uD83B\\uDC84\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2024\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷ᠤ.\x{1EC84}≠", %p)},	undef,	"to_unicode\(\'۷ᠤ\.\\uD83B\\uDC84≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2025\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷ᠤ.\x{1EC84}=\x{0338}", %p)},	undef,	"to_unicode\(\'۷ᠤ\.\\uD83B\\uDC84\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2026\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}\x{0776}\x{B8EEB}.𝟘\x{0680}\x{1086}", %p)},	undef,	"to_unicode\(\'\\u06C5\\u0776\\uDAA3\\uDEEB\.𝟘\\u0680\\u1086\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2027\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}\x{0776}\x{B8EEB}.0\x{0680}\x{1086}", %p)},	undef,	"to_unicode\(\'\\u06C5\\u0776\\uDAA3\\uDEEB\.0\\u0680\\u1086\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2028\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0AC3}-\x{10E66}۶.⤝\x{0825}4", %p)},	undef,	"to_unicode\(\'\\u0AC3\-\\uD803\\uDE66۶\.⤝\\u08254\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2029\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⫐｡Ⴠ-\x{8642E}", %p)},	undef,	"to_unicode\(\'⫐｡Ⴠ\-\\uD9D9\\uDC2E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2030\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⫐。Ⴠ-\x{8642E}", %p)},	undef,	"to_unicode\(\'⫐。Ⴠ\-\\uD9D9\\uDC2E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2031\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⫐。ⴠ-\x{8642E}", %p)},	undef,	"to_unicode\(\'⫐。ⴠ\-\\uD9D9\\uDC2E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2032\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⫐｡ⴠ-\x{8642E}", %p)},	undef,	"to_unicode\(\'⫐｡ⴠ\-\\uD9D9\\uDC2E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2033\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1039}⺡．⦟\x{E0C37}", %p)},	undef,	"to_unicode\(\'\\u1039⺡．⦟\\uDB43\\uDC37\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2034\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1039}⺡.⦟\x{E0C37}", %p)},	undef,	"to_unicode\(\'\\u1039⺡\.⦟\\uDB43\\uDC37\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2035\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DC729}-\x{10E73}。\x{87F6D}\x{068D}", %p)},	undef,	"to_unicode\(\'\\uDB31\\uDF29\-\\uD803\\uDE73。\\uD9DF\\uDF6D\\u068D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2036\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡚ。⩨\x{FE0E}\x{1EE55}\x{10E73}", %p)},	undef,	"to_unicode\(\'ᡚ。⩨\\uFE0E\\uD83B\\uDE55\\uD803\\uDE73\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2037\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10D35}ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDD35ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2038\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10D35}ꌄ｡\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDD35ꌄ｡\\u200Dᣬ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2039\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10D35}ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDD35ꌄ。\\u200Dᣬ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2040\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10D35}ꌄ。\x{200D}ᣬ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDD35ꌄ。\\u200Dᣬ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2041\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🄃\x{066B}。\x{9564C}≯-", %p)},	undef,	"to_unicode\(\'🄃\\u066B。\\uDA15\\uDE4C≯\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2042\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🄃\x{066B}。\x{9564C}>\x{0338}-", %p)},	undef,	"to_unicode\(\'🄃\\u066B。\\uDA15\\uDE4C\>\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2043\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("2,\x{066B}。\x{9564C}≯-", %p)},	undef,	"to_unicode\(\'2\,\\u066B。\\uDA15\\uDE4C≯\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2044\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("2,\x{066B}。\x{9564C}>\x{0338}-", %p)},	undef,	"to_unicode\(\'2\,\\u066B。\\uDA15\\uDE4C\>\\u0338\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2045\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䷎\x{0669}-\x{10DA0}.۰ꡝ", %p)},	undef,	"to_unicode\(\'䷎\\u0669\-\\uD803\\uDDA0\.۰ꡝ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2046\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≠｡\x{05A5}\x{10E64}Ⴡ\x{110B9}", %p)},	undef,	"to_unicode\(\'≠｡\\u05A5\\uD803\\uDE64Ⴡ\\uD804\\uDCB9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2047\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}｡\x{05A5}\x{10E64}Ⴡ\x{110B9}", %p)},	undef,	"to_unicode\(\'\=\\u0338｡\\u05A5\\uD803\\uDE64Ⴡ\\uD804\\uDCB9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2048\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。\x{05A5}\x{10E64}Ⴡ\x{110B9}", %p)},	undef,	"to_unicode\(\'≠。\\u05A5\\uD803\\uDE64Ⴡ\\uD804\\uDCB9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2049\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。\x{05A5}\x{10E64}Ⴡ\x{110B9}", %p)},	undef,	"to_unicode\(\'\=\\u0338。\\u05A5\\uD803\\uDE64Ⴡ\\uD804\\uDCB9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2050\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}。\x{05A5}\x{10E64}ⴡ\x{110B9}", %p)},	undef,	"to_unicode\(\'\=\\u0338。\\u05A5\\uD803\\uDE64ⴡ\\uD804\\uDCB9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2051\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠。\x{05A5}\x{10E64}ⴡ\x{110B9}", %p)},	undef,	"to_unicode\(\'≠。\\u05A5\\uD803\\uDE64ⴡ\\uD804\\uDCB9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2052\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}｡\x{05A5}\x{10E64}ⴡ\x{110B9}", %p)},	undef,	"to_unicode\(\'\=\\u0338｡\\u05A5\\uD803\\uDE64ⴡ\\uD804\\uDCB9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2053\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠｡\x{05A5}\x{10E64}ⴡ\x{110B9}", %p)},	undef,	"to_unicode\(\'≠｡\\u05A5\\uD803\\uDE64ⴡ\\uD804\\uDCB9\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FA8}≠.Ⴀᠽ", %p)},	undef,	"to_unicode\(\'\\u0FA8≠\.Ⴀᠽ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FA8}=\x{0338}.Ⴀᠽ", %p)},	undef,	"to_unicode\(\'\\u0FA8\=\\u0338\.Ⴀᠽ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FA8}=\x{0338}.ⴀᠽ", %p)},	undef,	"to_unicode\(\'\\u0FA8\=\\u0338\.ⴀᠽ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2057\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FA8}≠.ⴀᠽ", %p)},	undef,	"to_unicode\(\'\\u0FA8≠\.ⴀᠽ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2058\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1DDD}\x{20D9}ᡀ．ᡥ閪\x{0664}꒶", %p)},	undef,	"to_unicode\(\'\\u1DDD\\u20D9ᡀ．ᡥ閪\\u0664꒶\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2059\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20D9}\x{1DDD}ᡀ．ᡥ閪\x{0664}꒶", %p)},	undef,	"to_unicode\(\'\\u20D9\\u1DDDᡀ．ᡥ閪\\u0664꒶\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2060\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{20D9}\x{1DDD}ᡀ.ᡥ閪\x{0664}꒶", %p)},	undef,	"to_unicode\(\'\\u20D9\\u1DDDᡀ\.ᡥ閪\\u0664꒶\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2061\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{1DDF}\x{FB20}\x{FE00}｡\x{0E38}\x{0FA6}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\\u1DDF\\uFB20\\uFE00｡\\u0E38\\u0FA6\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2062\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{1DDF}\x{FB20}\x{FE00}｡\x{0E38}\x{0FA6}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\\u1DDF\\uFB20\\uFE00｡\\u0E38\\u0FA6\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2063\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{1DDF}\x{05E2}\x{FE00}。\x{0E38}\x{0FA6}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\\u1DDF\\u05E2\\uFE00。\\u0E38\\u0FA6\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2064\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{1DDF}\x{05E2}\x{FE00}。\x{0E38}\x{0FA6}-ᛟ", %p)},	undef,	"to_unicode\(\'\\u200D\\u1DDF\\u05E2\\uFE00。\\u0E38\\u0FA6\-ᛟ\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:2065\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("헁\x{BDB25}\x{09CD}\x{3922F}。ᡉ3", %p)},	undef,	"to_unicode\(\'헁\\uDAB6\\uDF25\\u09CD\\uD8A4\\uDE2F。ᡉ3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2066\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("헁\x{BDB25}\x{09CD}\x{3922F}。ᡉ3", %p)},	undef,	"to_unicode\(\'헁\\uDAB6\\uDF25\\u09CD\\uD8A4\\uDE2F。ᡉ3\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2067\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E61}｡\x{D2A2F}\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61｡\\uDB0A\\uDE2F\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2068\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E61}｡\x{D2A2F}\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61｡\\uDB0A\\uDE2F\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2069\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E61}。\x{D2A2F}\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61。\\uDB0A\\uDE2F\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2070\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E61}。\x{D2A2F}\x{200C}Ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61。\\uDB0A\\uDE2F\\u200CႾ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2071\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E61}。\x{D2A2F}\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61。\\uDB0A\\uDE2F\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2072\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E61}。\x{D2A2F}\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61。\\uDB0A\\uDE2F\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2073\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E61}｡\x{D2A2F}\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61｡\\uDB0A\\uDE2F\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2074\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E61}｡\x{D2A2F}\x{200C}ⴞ", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE61｡\\uDB0A\\uDE2F\\u200Cⴞ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2075\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A953}.\x{A8EF}\x{E01C0}馋", %p)},	undef,	"to_unicode\(\'\\uA953\.\\uA8EF\\uDB40\\uDDC0馋\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2076\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{76898}𢁔\x{200D}｡\x{3F7F3}", %p)},	undef,	"to_unicode\(\'\\uD99A\\uDC98𢁔\\u200D｡\\uD8BD\\uDFF3\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2077\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{76898}𢁔\x{200D}｡\x{3F7F3}", %p)},	undef,	"to_unicode\(\'\\uD99A\\uDC98𢁔\\u200D｡\\uD8BD\\uDFF3\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2078\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{76898}𢁔\x{200D}。\x{3F7F3}", %p)},	undef,	"to_unicode\(\'\\uD99A\\uDC98𢁔\\u200D。\\uD8BD\\uDFF3\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2079\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{76898}𢁔\x{200D}。\x{3F7F3}", %p)},	undef,	"to_unicode\(\'\\uD99A\\uDC98𢁔\\u200D。\\uD8BD\\uDFF3\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2080\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꡖ⽬姶𝟏．⒍\x{200D}╅\x{200D}", %p)},	undef,	"to_unicode\(\'ꡖ⽬姶𝟏．⒍\\u200D╅\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2081\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡖ⽬姶𝟏．⒍\x{200D}╅\x{200D}", %p)},	undef,	"to_unicode\(\'ꡖ⽬姶𝟏．⒍\\u200D╅\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2082\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡖ目姶1.6.\x{200D}╅\x{200D}", %p)},	undef,	"to_unicode\(\'ꡖ目姶1\.6\.\\u200D╅\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2083\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡖ目姶1.6.\x{200D}╅\x{200D}", %p)},	undef,	"to_unicode\(\'ꡖ目姶1\.6\.\\u200D╅\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2084\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--1-yn1bw30gq07b.6.xn--7xh", %p)},	"ꡖ目姶1.6.╅",	"to_unicode\(\'xn\-\-1\-yn1bw30gq07b\.6\.xn\-\-7xh\'\)\ \[data\/IdnaTest\.txt\:2085\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡖ目姶1.6.╅", %p)},	"ꡖ目姶1.6.╅",	"to_unicode\(\'ꡖ目姶1\.6\.╅\'\)\ \[data\/IdnaTest\.txt\:2086\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10F7C}.\x{10E63}≾\x{0ACD}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDF7C\.\\uD803\\uDE63≾\\u0ACD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2087\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴔ\x{0715}｡\x{10E66}\x{AA36}۰", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0715｡\\uD803\\uDE66\\uAA36۰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2088\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴔ\x{0715}。\x{10E66}\x{AA36}۰", %p)},	undef,	"to_unicode\(\'Ⴔ\\u0715。\\uD803\\uDE66\\uAA36۰\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2089\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ\x{0715}。\x{10E66}\x{AA36}۰", %p)},	undef,	"to_unicode\(\'ⴔ\\u0715。\\uD803\\uDE66\\uAA36۰\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2090\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴔ\x{0715}｡\x{10E66}\x{AA36}۰", %p)},	undef,	"to_unicode\(\'ⴔ\\u0715｡\\uD803\\uDE66\\uAA36۰\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2091\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{110B5}\x{068D}\x{200C}．︒-\x{1773}-", %p)},	undef,	"to_unicode\(\'\\uD804\\uDCB5\\u068D\\u200C．︒\-\\u1773\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2092\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{110B5}\x{068D}\x{200C}．︒-\x{1773}-", %p)},	undef,	"to_unicode\(\'\\uD804\\uDCB5\\u068D\\u200C．︒\-\\u1773\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2093\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{110B5}\x{068D}\x{200C}.。-\x{1773}-", %p)},	undef,	"to_unicode\(\'\\uD804\\uDCB5\\u068D\\u200C\.。\-\\u1773\-\'\)\ throws\ error\ V5\ V3\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2094\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{110B5}\x{068D}\x{200C}.。-\x{1773}-", %p)},	undef,	"to_unicode\(\'\\uD804\\uDCB5\\u068D\\u200C\.。\-\\u1773\-\'\)\ throws\ error\ V5\ V3\ B1\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2095\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0602}🄆\x{200C}.\x{0829}\x{FC4E}", %p)},	undef,	"to_unicode\(\'⒈\\u0602🄆\\u200C\.\\u0829\\uFC4E\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2096\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{0602}🄆\x{200C}.\x{0829}\x{FC4E}", %p)},	undef,	"to_unicode\(\'⒈\\u0602🄆\\u200C\.\\u0829\\uFC4E\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2097\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{0602}5,\x{200C}.\x{0829}\x{0646}\x{0645}", %p)},	undef,	"to_unicode\(\'1\.\\u06025\,\\u200C\.\\u0829\\u0646\\u0645\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2098\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{0602}5,\x{200C}.\x{0829}\x{0646}\x{0645}", %p)},	undef,	"to_unicode\(\'1\.\\u06025\,\\u200C\.\\u0829\\u0646\\u0645\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:2099\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01A7}。-\x{1B44}Ⴋ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDA7。\-\\u1B44Ⴋ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2100\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01A7}。-\x{1B44}ⴋ", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDA7。\-\\u1B44ⴋ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2101\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ßჀ.\x{0642}刯Ⴝ", %p)},	undef,	"to_unicode\(\'ßჀ\.\\u0642刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2102\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ßⴠ.\x{0642}刯ⴝ", %p)},	undef,	"to_unicode\(\'ßⴠ\.\\u0642刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2103\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SSჀ.\x{0642}刯Ⴝ", %p)},	undef,	"to_unicode\(\'SSჀ\.\\u0642刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2104\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ssⴠ.\x{0642}刯ⴝ", %p)},	undef,	"to_unicode\(\'ssⴠ\.\\u0642刯ⴝ\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:2105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ssⴠ.\x{0642}刯Ⴝ", %p)},	undef,	"to_unicode\(\'Ssⴠ\.\\u0642刯Ⴝ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2106\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}ႣℲ｡ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3AႣℲ｡ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2107\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}ႣℲ｡ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3AႣℲ｡ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2108\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}ႣℲ。ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3AႣℲ。ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2109\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}ႣℲ。ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3AႣℲ。ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2110\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}ⴃⅎ。ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3Aⴃⅎ。ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2111\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}ⴃⅎ。ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3Aⴃⅎ。ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2112\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}Ⴃⅎ。ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3AႣⅎ。ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2113\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}Ⴃⅎ。ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3AႣⅎ。ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2114\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}ⴃⅎ｡ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3Aⴃⅎ｡ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2115\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}ⴃⅎ｡ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3Aⴃⅎ｡ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2116\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}Ⴃⅎ｡ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3AႣⅎ｡ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2117\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E3A}Ⴃⅎ｡ᡗ툻\x{1ED2D}", %p)},	undef,	"to_unicode\(\'\\u0E3AႣⅎ｡ᡗ툻\\uD83B\\uDD2D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2118\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0800}.\x{07CF}\x{0601}\x{06D1}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDC00\.\\u07CF\\u0601\\u06D1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2119\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢍ\x{06DF}。⒍\x{11133}", %p)},	undef,	"to_unicode\(\'ᢍ\\u06DF。⒍\\uD804\\uDD33\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2120\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢍ\x{06DF}。6.\x{11133}", %p)},	undef,	"to_unicode\(\'ᢍ\\u06DF。6\.\\uD804\\uDD33\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2121\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴣ\x{0600}.\x{200C}\x{E01B7}≮𝌶", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0600\.\\u200C\\uDB40\\uDDB7≮𝌶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2122\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0600}.\x{200C}\x{E01B7}≮𝌶", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0600\.\\u200C\\uDB40\\uDDB7≮𝌶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2123\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0600}.\x{200C}\x{E01B7}<\x{0338}𝌶", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0600\.\\u200C\\uDB40\\uDDB7\<\\u0338𝌶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2124\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴣ\x{0600}.\x{200C}\x{E01B7}<\x{0338}𝌶", %p)},	undef,	"to_unicode\(\'Ⴣ\\u0600\.\\u200C\\uDB40\\uDDB7\<\\u0338𝌶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2125\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0600}.\x{200C}\x{E01B7}<\x{0338}𝌶", %p)},	undef,	"to_unicode\(\'ⴣ\\u0600\.\\u200C\\uDB40\\uDDB7\<\\u0338𝌶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2126\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0600}.\x{200C}\x{E01B7}<\x{0338}𝌶", %p)},	undef,	"to_unicode\(\'ⴣ\\u0600\.\\u200C\\uDB40\\uDDB7\<\\u0338𝌶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2127\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0600}.\x{200C}\x{E01B7}≮𝌶", %p)},	undef,	"to_unicode\(\'ⴣ\\u0600\.\\u200C\\uDB40\\uDDB7≮𝌶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2128\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴣ\x{0600}.\x{200C}\x{E01B7}≮𝌶", %p)},	undef,	"to_unicode\(\'ⴣ\\u0600\.\\u200C\\uDB40\\uDDB7≮𝌶\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2129\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⁹隁\x{E0F3A}．\x{0341}\x{200C}", %p)},	undef,	"to_unicode\(\'⁹隁\\uDB43\\uDF3A．\\u0341\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2130\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⁹隁\x{E0F3A}．\x{0341}\x{200C}", %p)},	undef,	"to_unicode\(\'⁹隁\\uDB43\\uDF3A．\\u0341\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2131\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⁹隁\x{E0F3A}．\x{0301}\x{200C}", %p)},	undef,	"to_unicode\(\'⁹隁\\uDB43\\uDF3A．\\u0301\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2132\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⁹隁\x{E0F3A}．\x{0301}\x{200C}", %p)},	undef,	"to_unicode\(\'⁹隁\\uDB43\\uDF3A．\\u0301\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2133\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("9隁\x{E0F3A}.\x{0301}\x{200C}", %p)},	undef,	"to_unicode\(\'9隁\\uDB43\\uDF3A\.\\u0301\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2134\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("9隁\x{E0F3A}.\x{0301}\x{200C}", %p)},	undef,	"to_unicode\(\'9隁\\uDB43\\uDF3A\.\\u0301\\u200C\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2135\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒌\x{0662}｡Ⴣ\x{A9C0}彦", %p)},	undef,	"to_unicode\(\'⒌\\u0662｡Ⴣ\\uA9C0彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("5.\x{0662}。Ⴣ\x{A9C0}彦", %p)},	undef,	"to_unicode\(\'5\.\\u0662。Ⴣ\\uA9C0彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2137\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("5.\x{0662}。ⴣ\x{A9C0}彦", %p)},	undef,	"to_unicode\(\'5\.\\u0662。ⴣ\\uA9C0彦\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2138\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒌\x{0662}｡ⴣ\x{A9C0}彦", %p)},	undef,	"to_unicode\(\'⒌\\u0662｡ⴣ\\uA9C0彦\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2139\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-问\x{E072D}𝟷。\x{10E64}-\x{1C385}橬", %p)},	undef,	"to_unicode\(\'\-问\\uDB41\\uDF2D𝟷。\\uD803\\uDE64\-\\uD830\\uDF85橬\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2140\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-问\x{E072D}1。\x{10E64}-\x{1C385}橬", %p)},	undef,	"to_unicode\(\'\-问\\uDB41\\uDF2D1。\\uD803\\uDE64\-\\uD830\\uDF85橬\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2141\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{2DF3}Ⴌ\x{200C}\x{E0150}。𝟐", %p)},	undef,	"to_unicode\(\'\\u2DF3Ⴌ\\u200C\\uDB40\\uDD50。𝟐\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2142\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF3}Ⴌ\x{200C}\x{E0150}。𝟐", %p)},	undef,	"to_unicode\(\'\\u2DF3Ⴌ\\u200C\\uDB40\\uDD50。𝟐\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2143\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF3}Ⴌ\x{200C}\x{E0150}。2", %p)},	undef,	"to_unicode\(\'\\u2DF3Ⴌ\\u200C\\uDB40\\uDD50。2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2144\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF3}Ⴌ\x{200C}\x{E0150}。2", %p)},	undef,	"to_unicode\(\'\\u2DF3Ⴌ\\u200C\\uDB40\\uDD50。2\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2145\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF3}ⴌ\x{200C}\x{E0150}。2", %p)},	undef,	"to_unicode\(\'\\u2DF3ⴌ\\u200C\\uDB40\\uDD50。2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2146\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF3}ⴌ\x{200C}\x{E0150}。2", %p)},	undef,	"to_unicode\(\'\\u2DF3ⴌ\\u200C\\uDB40\\uDD50。2\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2147\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF3}ⴌ\x{200C}\x{E0150}。𝟐", %p)},	undef,	"to_unicode\(\'\\u2DF3ⴌ\\u200C\\uDB40\\uDD50。𝟐\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2148\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{2DF3}ⴌ\x{200C}\x{E0150}。𝟐", %p)},	undef,	"to_unicode\(\'\\u2DF3ⴌ\\u200C\\uDB40\\uDD50。𝟐\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2149\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DC5F}。\x{1B44}\x{0601}𑁡", %p)},	undef,	"to_unicode\(\'\\uDC5F。\\u1B44\\u0601𑁡\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2150\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0FAF}\x{E0146}⾶｡⒊︒눇≮", %p)},	undef,	"to_unicode\(\'\\u0FAF\\uDB40\\uDD46⾶｡⒊︒눇≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2151\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAF}\x{E0146}⾶｡⒊︒눇<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0FAF\\uDB40\\uDD46⾶｡⒊︒눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2152\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAF}\x{E0146}飛。3.。눇≮", %p)},	undef,	"to_unicode\(\'\\u0FAF\\uDB40\\uDD46飛。3\.。눇≮\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2153\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0FAF}\x{E0146}飛。3.。눇<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0FAF\\uDB40\\uDD46飛。3\.。눇\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0F96}\x{0601}\x{200D}．\x{200C}⿃", %p)},	undef,	"to_unicode\(\'\\u200C\\u0F96\\u0601\\u200D．\\u200C⿃\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0F96}\x{0601}\x{200D}．\x{200C}⿃", %p)},	undef,	"to_unicode\(\'\\u200C\\u0F96\\u0601\\u200D．\\u200C⿃\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0F96}\x{0601}\x{200D}.\x{200C}鳥", %p)},	undef,	"to_unicode\(\'\\u200C\\u0F96\\u0601\\u200D\.\\u200C鳥\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{0F96}\x{0601}\x{200D}.\x{200C}鳥", %p)},	undef,	"to_unicode\(\'\\u200C\\u0F96\\u0601\\u200D\.\\u200C鳥\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:2158\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0931}．\x{200D}🀶\x{1EF6C}\x{1A7B}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD31．\\u200D🀶\\uD83B\\uDF6C\\u1A7B\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2159\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0931}．\x{200D}🀶\x{1EF6C}\x{1A7B}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD31．\\u200D🀶\\uD83B\\uDF6C\\u1A7B\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2160\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0931}.\x{200D}🀶\x{1EF6C}\x{1A7B}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD31\.\\u200D🀶\\uD83B\\uDF6C\\u1A7B\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2161\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0931}.\x{200D}🀶\x{1EF6C}\x{1A7B}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD31\.\\u200D🀶\\uD83B\\uDF6C\\u1A7B\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2162\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᡵ\x{E015B}.ꡬ\x{200D}", %p)},	undef,	"to_unicode\(\'ᡵ\\uDB40\\uDD5B\.ꡬ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2163\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡵ\x{E015B}.ꡬ\x{200D}", %p)},	undef,	"to_unicode\(\'ᡵ\\uDB40\\uDD5B\.ꡬ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2164\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--i9e.xn--id9a", %p)},	"ᡵ.ꡬ",	"to_unicode\(\'xn\-\-i9e\.xn\-\-id9a\'\)\ \[data\/IdnaTest\.txt\:2165\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡵ.ꡬ", %p)},	"ᡵ.ꡬ",	"to_unicode\(\'ᡵ\.ꡬ\'\)\ \[data\/IdnaTest\.txt\:2166\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0600}\x{1B44}-．\x{C5109}\x{1BF2}\x{AC9E9}", %p)},	undef,	"to_unicode\(\'\\u0600\\u1B44\-．\\uDAD4\\uDD09\\u1BF2\\uDA72\\uDDE9\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2167\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0600}\x{1B44}-.\x{C5109}\x{1BF2}\x{AC9E9}", %p)},	undef,	"to_unicode\(\'\\u0600\\u1B44\-\.\\uDAD4\\uDD09\\u1BF2\\uDA72\\uDDE9\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2168\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{11046}-\x{10E63}｡\x{0E34}\x{200C}\x{10E64}≮", %p)},	undef,	"to_unicode\(\'4\\uD804\\uDC46\-\\uD803\\uDE63｡\\u0E34\\u200C\\uD803\\uDE64≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2169\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{11046}-\x{10E63}｡\x{0E34}\x{200C}\x{10E64}≮", %p)},	undef,	"to_unicode\(\'4\\uD804\\uDC46\-\\uD803\\uDE63｡\\u0E34\\u200C\\uD803\\uDE64≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2170\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{11046}-\x{10E63}｡\x{0E34}\x{200C}\x{10E64}<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\uD804\\uDC46\-\\uD803\\uDE63｡\\u0E34\\u200C\\uD803\\uDE64\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2171\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{11046}-\x{10E63}｡\x{0E34}\x{200C}\x{10E64}<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\uD804\\uDC46\-\\uD803\\uDE63｡\\u0E34\\u200C\\uD803\\uDE64\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2172\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{11046}-\x{10E63}。\x{0E34}\x{200C}\x{10E64}≮", %p)},	undef,	"to_unicode\(\'4\\uD804\\uDC46\-\\uD803\\uDE63。\\u0E34\\u200C\\uD803\\uDE64≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2173\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{11046}-\x{10E63}。\x{0E34}\x{200C}\x{10E64}≮", %p)},	undef,	"to_unicode\(\'4\\uD804\\uDC46\-\\uD803\\uDE63。\\u0E34\\u200C\\uD803\\uDE64≮\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2174\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{11046}-\x{10E63}。\x{0E34}\x{200C}\x{10E64}<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\uD804\\uDC46\-\\uD803\\uDE63。\\u0E34\\u200C\\uD803\\uDE64\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2175\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{11046}-\x{10E63}。\x{0E34}\x{200C}\x{10E64}<\x{0338}", %p)},	undef,	"to_unicode\(\'4\\uD804\\uDC46\-\\uD803\\uDE63。\\u0E34\\u200C\\uD803\\uDE64\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2176\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}。\x{FFA0}\x{A953}\x{030C}", %p)},	undef,	"to_unicode\(\'\\u200C。\\uFFA0\\uA953\\u030C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{FFA0}\x{A953}\x{030C}", %p)},	undef,	"to_unicode\(\'\\u200C。\\uFFA0\\uA953\\u030C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{1160}\x{A953}\x{030C}", %p)},	undef,	"to_unicode\(\'\\u200C。\\u1160\\uA953\\u030C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2179\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。\x{1160}\x{A953}\x{030C}", %p)},	undef,	"to_unicode\(\'\\u200C。\\u1160\\uA953\\u030C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2180\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≯\x{8FE71}．\x{200D}𝈲\x{9A2B8}", %p)},	undef,	"to_unicode\(\'≯\\uD9FF\\uDE71．\\u200D𝈲\\uDA28\\uDEB8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2181\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≯\x{8FE71}．\x{200D}𝈲\x{9A2B8}", %p)},	undef,	"to_unicode\(\'≯\\uD9FF\\uDE71．\\u200D𝈲\\uDA28\\uDEB8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2182\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(">\x{0338}\x{8FE71}．\x{200D}𝈲\x{9A2B8}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD9FF\\uDE71．\\u200D𝈲\\uDA28\\uDEB8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2183\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(">\x{0338}\x{8FE71}．\x{200D}𝈲\x{9A2B8}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD9FF\\uDE71．\\u200D𝈲\\uDA28\\uDEB8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2184\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≯\x{8FE71}.\x{200D}𝈲\x{9A2B8}", %p)},	undef,	"to_unicode\(\'≯\\uD9FF\\uDE71\.\\u200D𝈲\\uDA28\\uDEB8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2185\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≯\x{8FE71}.\x{200D}𝈲\x{9A2B8}", %p)},	undef,	"to_unicode\(\'≯\\uD9FF\\uDE71\.\\u200D𝈲\\uDA28\\uDEB8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2186\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(">\x{0338}\x{8FE71}.\x{200D}𝈲\x{9A2B8}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD9FF\\uDE71\.\\u200D𝈲\\uDA28\\uDEB8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2187\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(">\x{0338}\x{8FE71}.\x{200D}𝈲\x{9A2B8}", %p)},	undef,	"to_unicode\(\'\>\\u0338\\uD9FF\\uDE71\.\\u200D𝈲\\uDA28\\uDEB8\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2188\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ꡞß\x{07DE}｡⁶\x{071F}", %p)},	undef,	"to_unicode\(\'ꡞß\\u07DE｡⁶\\u071F\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2189\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡞß\x{07DE}。6\x{071F}", %p)},	undef,	"to_unicode\(\'ꡞß\\u07DE。6\\u071F\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2190\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡞSS\x{07DE}。6\x{071F}", %p)},	undef,	"to_unicode\(\'ꡞSS\\u07DE。6\\u071F\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2191\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡞss\x{07DE}。6\x{071F}", %p)},	undef,	"to_unicode\(\'ꡞss\\u07DE。6\\u071F\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2192\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡞSs\x{07DE}。6\x{071F}", %p)},	undef,	"to_unicode\(\'ꡞSs\\u07DE。6\\u071F\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2193\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡞSS\x{07DE}｡⁶\x{071F}", %p)},	undef,	"to_unicode\(\'ꡞSS\\u07DE｡⁶\\u071F\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2194\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡞss\x{07DE}｡⁶\x{071F}", %p)},	undef,	"to_unicode\(\'ꡞss\\u07DE｡⁶\\u071F\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2195\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡞSs\x{07DE}｡⁶\x{071F}", %p)},	undef,	"to_unicode\(\'ꡞSs\\u07DE｡⁶\\u071F\'\)\ throws\ error\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:2196\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{E005D}\x{1A5A}\x{1EF97}。\x{10C99}\x{126EE}\x{0666}", %p)},	undef,	"to_unicode\(\'ß\\uDB40\\uDC5D\\u1A5A\\uD83B\\uDF97。\\uD803\\uDC99\\uD809\\uDEEE\\u0666\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2197\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{E005D}\x{1A5A}\x{1EF97}。\x{10C99}\x{126EE}\x{0666}", %p)},	undef,	"to_unicode\(\'SS\\uDB40\\uDC5D\\u1A5A\\uD83B\\uDF97。\\uD803\\uDC99\\uD809\\uDEEE\\u0666\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2198\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{E005D}\x{1A5A}\x{1EF97}。\x{10C99}\x{126EE}\x{0666}", %p)},	undef,	"to_unicode\(\'ss\\uDB40\\uDC5D\\u1A5A\\uD83B\\uDF97。\\uD803\\uDC99\\uD809\\uDEEE\\u0666\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2199\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{E005D}\x{1A5A}\x{1EF97}。\x{10C99}\x{126EE}\x{0666}", %p)},	undef,	"to_unicode\(\'Ss\\uDB40\\uDC5D\\u1A5A\\uD83B\\uDF97。\\uD803\\uDC99\\uD809\\uDEEE\\u0666\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ \[data\/IdnaTest\.txt\:2200\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-｡\x{0319}𝟖\x{1E96B}", %p)},	undef,	"to_unicode\(\'\-｡\\u0319𝟖\\uD83A\\uDD6B\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2201\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-。\x{0319}8\x{1E96B}", %p)},	undef,	"to_unicode\(\'\-。\\u03198\\uD83A\\uDD6B\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2202\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}ς．-≮\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05ς．\-≮\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2203\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}ς．-<\x{0338}\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05ς．\-\<\\u0338\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2204\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}ς.-≮\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05ς\.\-≮\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2205\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}ς.-<\x{0338}\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05ς\.\-\<\\u0338\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2206\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}Σ.-<\x{0338}\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05Σ\.\-\<\\u0338\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2207\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}Σ.-≮\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05Σ\.\-≮\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2208\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}σ.-≮\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05σ\.\-≮\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2209\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}σ.-<\x{0338}\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05σ\.\-\<\\u0338\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2210\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}Σ．-<\x{0338}\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05Σ．\-\<\\u0338\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2211\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}Σ．-≮\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05Σ．\-≮\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2212\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}σ．-≮\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05σ．\-≮\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2213\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4E605}σ．-<\x{0338}\x{109F0}", %p)},	undef,	"to_unicode\(\'\\uD8F9\\uDE05σ．\-\<\\u0338\\uD802\\uDDF0\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2214\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0772}\x{0685}\x{071A}．\x{D0158}🍼\x{A8C4}\x{1ED96}", %p)},	undef,	"to_unicode\(\'\\u0772\\u0685\\u071A．\\uDB00\\uDD58🍼\\uA8C4\\uD83B\\uDD96\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2215\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0772}\x{0685}\x{071A}.\x{D0158}🍼\x{A8C4}\x{1ED96}", %p)},	undef,	"to_unicode\(\'\\u0772\\u0685\\u071A\.\\uDB00\\uDD58🍼\\uA8C4\\uD83B\\uDD96\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2216\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FD2E}\x{06B0}ᢦ\x{063A}。🄅\x{08ED}\x{A949}", %p)},	undef,	"to_unicode\(\'\\uFD2E\\u06B0ᢦ\\u063A。🄅\\u08ED\\uA949\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:2217\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0634}\x{062D}\x{06B0}ᢦ\x{063A}。4,\x{08ED}\x{A949}", %p)},	undef,	"to_unicode\(\'\\u0634\\u062D\\u06B0ᢦ\\u063A。4\,\\u08ED\\uA949\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:2218\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("₇\x{B4228}--。\x{0755}\x{200C}\x{FC9A}\x{1BAA}", %p)},	undef,	"to_unicode\(\'₇\\uDA90\\uDE28\-\-。\\u0755\\u200C\\uFC9A\\u1BAA\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2219\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("7\x{B4228}--。\x{0755}\x{200C}\x{0626}\x{0645}\x{1BAA}", %p)},	undef,	"to_unicode\(\'7\\uDA90\\uDE28\-\-。\\u0755\\u200C\\u0626\\u0645\\u1BAA\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2220\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("7\x{B4228}--。\x{0755}\x{200C}\x{064A}\x{0654}\x{0645}\x{1BAA}", %p)},	undef,	"to_unicode\(\'7\\uDA90\\uDE28\-\-。\\u0755\\u200C\\u064A\\u0654\\u0645\\u1BAA\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2221\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{5BE73}．\x{076D}ꡕ-", %p)},	undef,	"to_unicode\(\'\-\\uD92F\\uDE73．\\u076Dꡕ\-\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2222\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{5BE73}.\x{076D}ꡕ-", %p)},	undef,	"to_unicode\(\'\-\\uD92F\\uDE73\.\\u076Dꡕ\-\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2223\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}-ß｡ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß｡ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-ß｡ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß｡ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-ß。ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß。ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-ß。ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ß。ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-SS。ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS。ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-SS。ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS。ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-ss。ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss。ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-ss。ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss。ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-Ss。ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss。ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-Ss。ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss。ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-SS｡ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS｡ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-SS｡ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-SS｡ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-ss｡ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss｡ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-ss｡ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-ss｡ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-Ss｡ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss｡ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}-Ss｡ᢢ\x{0667}\x{06EE}", %p)},	undef,	"to_unicode\(\'\\u200C\-Ss｡ᢢ\\u0667\\u06EE\'\)\ throws\ error\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{09CD}\x{0A01}．눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u09CD\\u0A01．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{09CD}\x{0A01}．눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u09CD\\u0A01．눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{09CD}\x{0A01}.눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u09CD\\u0A01\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2242\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐Ӏ\x{09CD}\x{0A01}.눵", %p)},	undef,	"to_unicode\(\'꧐Ӏ\\u09CD\\u0A01\.눵\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2243\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐ӏ\x{09CD}\x{0A01}.눵", %p)},	"꧐ӏ\x{09CD}\x{0A01}.눵",	"to_unicode\(\'꧐ӏ\\u09CD\\u0A01\.눵\'\)\ \[data\/IdnaTest\.txt\:2244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐ӏ\x{09CD}\x{0A01}.눵", %p)},	"꧐ӏ\x{09CD}\x{0A01}.눵",	"to_unicode\(\'꧐ӏ\\u09CD\\u0A01\.눵\'\)\ \[data\/IdnaTest\.txt\:2245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--s5a07wqex704d.xn--2e1b", %p)},	"꧐ӏ\x{09CD}\x{0A01}.눵",	"to_unicode\(\'xn\-\-s5a07wqex704d\.xn\-\-2e1b\'\)\ \[data\/IdnaTest\.txt\:2246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐ӏ\x{09CD}\x{0A01}．눵", %p)},	"꧐ӏ\x{09CD}\x{0A01}.눵",	"to_unicode\(\'꧐ӏ\\u09CD\\u0A01．눵\'\)\ \[data\/IdnaTest\.txt\:2247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("꧐ӏ\x{09CD}\x{0A01}．눵", %p)},	"꧐ӏ\x{09CD}\x{0A01}.눵",	"to_unicode\(\'꧐ӏ\\u09CD\\u0A01．눵\'\)\ \[data\/IdnaTest\.txt\:2248\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E007E}｡\x{D8EF7}\x{0348}\x{1B72}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDC7E｡\\uDB23\\uDEF7\\u0348\\u1B72\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2249\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E007E}。\x{D8EF7}\x{0348}\x{1B72}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDC7E。\\uDB23\\uDEF7\\u0348\\u1B72\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2250\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4230F}🁸。\x{53771}≯⾇", %p)},	undef,	"to_unicode\(\'\\uD8C8\\uDF0F🁸。\\uD90D\\uDF71≯⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2251\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4230F}🁸。\x{53771}>\x{0338}⾇", %p)},	undef,	"to_unicode\(\'\\uD8C8\\uDF0F🁸。\\uD90D\\uDF71\>\\u0338⾇\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2252\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4230F}🁸。\x{53771}≯舛", %p)},	undef,	"to_unicode\(\'\\uD8C8\\uDF0F🁸。\\uD90D\\uDF71≯舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2253\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4230F}🁸。\x{53771}>\x{0338}舛", %p)},	undef,	"to_unicode\(\'\\uD8C8\\uDF0F🁸。\\uD90D\\uDF71\>\\u0338舛\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2254\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06CD}\x{0602}\x{200C}．\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06CD\\u0602\\u200C．\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2255\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}\x{0602}\x{200C}．\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06CD\\u0602\\u200C．\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2256\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}\x{0602}\x{200C}.\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06CD\\u0602\\u200C\.\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2257\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}\x{0602}\x{200C}.\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u06CD\\u0602\\u200C\.\\u200D\\u200C\'\)\ throws\ error\ P1\ V6\ B3\ C1\ C2\ \[data\/IdnaTest\.txt\:2258\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB266}砪≯\x{0639}｡≯\x{1A74}\x{B5208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDBAC\\uDE66砪≯\\u0639｡≯\\u1A74\\uDA94\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2259\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB266}砪≯\x{0639}｡≯\x{1A74}\x{B5208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDBAC\\uDE66砪≯\\u0639｡≯\\u1A74\\uDA94\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2260\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB266}砪>\x{0338}\x{0639}｡>\x{0338}\x{1A74}\x{B5208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDBAC\\uDE66砪\>\\u0338\\u0639｡\>\\u0338\\u1A74\\uDA94\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2261\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB266}砪>\x{0338}\x{0639}｡>\x{0338}\x{1A74}\x{B5208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDBAC\\uDE66砪\>\\u0338\\u0639｡\>\\u0338\\u1A74\\uDA94\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2262\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB266}砪≯\x{0639}。≯\x{1A74}\x{B5208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDBAC\\uDE66砪≯\\u0639。≯\\u1A74\\uDA94\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2263\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB266}砪≯\x{0639}。≯\x{1A74}\x{B5208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDBAC\\uDE66砪≯\\u0639。≯\\u1A74\\uDA94\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2264\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB266}砪>\x{0338}\x{0639}。>\x{0338}\x{1A74}\x{B5208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDBAC\\uDE66砪\>\\u0338\\u0639。\>\\u0338\\u1A74\\uDA94\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2265\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB266}砪>\x{0338}\x{0639}。>\x{0338}\x{1A74}\x{B5208}\x{200C}", %p)},	undef,	"to_unicode\(\'\\uDBAC\\uDE66砪\>\\u0338\\u0639。\>\\u0338\\u1A74\\uDA94\\uDE08\\u200C\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:2266\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴥ.\x{11134}㊸", %p)},	undef,	"to_unicode\(\'Ⴥ\.\\uD804\\uDD34㊸\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2267\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴥ.\x{11134}43", %p)},	undef,	"to_unicode\(\'Ⴥ\.\\uD804\\uDD3443\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2268\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴥ.\x{11134}43", %p)},	undef,	"to_unicode\(\'ⴥ\.\\uD804\\uDD3443\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2269\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴥ.\x{11134}㊸", %p)},	undef,	"to_unicode\(\'ⴥ\.\\uD804\\uDD34㊸\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2270\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𝟒\x{0663}。Ⴒᡷ\x{FE09}\x{10E64}", %p)},	undef,	"to_unicode\(\'𝟒\\u0663。Ⴒᡷ\\uFE09\\uD803\\uDE64\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2271\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{0663}。Ⴒᡷ\x{FE09}\x{10E64}", %p)},	undef,	"to_unicode\(\'4\\u0663。Ⴒᡷ\\uFE09\\uD803\\uDE64\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2272\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("4\x{0663}。ⴒᡷ\x{FE09}\x{10E64}", %p)},	undef,	"to_unicode\(\'4\\u0663。ⴒᡷ\\uFE09\\uD803\\uDE64\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2273\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟒\x{0663}。ⴒᡷ\x{FE09}\x{10E64}", %p)},	undef,	"to_unicode\(\'𝟒\\u0663。ⴒᡷ\\uFE09\\uD803\\uDE64\'\)\ throws\ error\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2274\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{8A366}\x{1DD8}\x{FFA0}\x{059B}.\x{93F50}\x{2D7F}", %p)},	undef,	"to_unicode\(\'\\uD9E8\\uDF66\\u1DD8\\uFFA0\\u059B\.\\uDA0F\\uDF50\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2275\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{8A366}\x{1DD8}\x{1160}\x{059B}.\x{93F50}\x{2D7F}", %p)},	undef,	"to_unicode\(\'\\uD9E8\\uDF66\\u1DD8\\u1160\\u059B\.\\uDA0F\\uDF50\\u2D7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2276\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{FE08}.𝟠\x{200C}\x{103A}", %p)},	undef,	"to_unicode\(\'\\uFE08\.𝟠\\u200C\\u103A\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE08}.𝟠\x{200C}\x{103A}", %p)},	undef,	"to_unicode\(\'\\uFE08\.𝟠\\u200C\\u103A\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE08}.8\x{200C}\x{103A}", %p)},	undef,	"to_unicode\(\'\\uFE08\.8\\u200C\\u103A\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE08}.8\x{200C}\x{103A}", %p)},	undef,	"to_unicode\(\'\\uFE08\.8\\u200C\\u103A\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--8-dug", %p)},	"8\x{103A}",	"to_unicode\(\'xn\-\-8\-dug\'\)\ \[data\/IdnaTest\.txt\:2281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8\x{103A}", %p)},	"8\x{103A}",	"to_unicode\(\'8\\u103A\'\)\ \[data\/IdnaTest\.txt\:2282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063F}．︒ꡅ", %p)},	undef,	"to_unicode\(\'\\u063F．︒ꡅ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{063F}.。ꡅ", %p)},	undef,	"to_unicode\(\'\\u063F\.。ꡅ\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:2284\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF3}\x{0349}｡\x{FC71}", %p)},	undef,	"to_unicode\(\'\\u1BF3\\u0349｡\\uFC71\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2285\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF3}\x{0349}。\x{062A}\x{0632}", %p)},	undef,	"to_unicode\(\'\\u1BF3\\u0349。\\u062A\\u0632\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2286\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FCB3}。ꡋ\x{57A89}", %p)},	undef,	"to_unicode\(\'\\uFCB3。ꡋ\\uD91E\\uDE89\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2287\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0635}\x{0645}。ꡋ\x{57A89}", %p)},	undef,	"to_unicode\(\'\\u0635\\u0645。ꡋ\\uD91E\\uDE89\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2288\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF2}㴼．\x{200C}\x{10E78}\x{E01E9}\x{921E3}", %p)},	undef,	"to_unicode\(\'\\u1BF2㴼．\\u200C\\uD803\\uDE78\\uDB40\\uDDE9\\uDA08\\uDDE3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2289\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF2}㴼．\x{200C}\x{10E78}\x{E01E9}\x{921E3}", %p)},	undef,	"to_unicode\(\'\\u1BF2㴼．\\u200C\\uD803\\uDE78\\uDB40\\uDDE9\\uDA08\\uDDE3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2290\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF2}㴼.\x{200C}\x{10E78}\x{E01E9}\x{921E3}", %p)},	undef,	"to_unicode\(\'\\u1BF2㴼\.\\u200C\\uD803\\uDE78\\uDB40\\uDDE9\\uDA08\\uDDE3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2291\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF2}㴼.\x{200C}\x{10E78}\x{E01E9}\x{921E3}", %p)},	undef,	"to_unicode\(\'\\u1BF2㴼\.\\u200C\\uD803\\uDE78\\uDB40\\uDDE9\\uDA08\\uDDE3\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2292\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("𠨧\x{0665}\x{200B}｡\x{0737}", %p)},	undef,	"to_unicode\(\'𠨧\\u0665\\u200B｡\\u0737\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𠨧\x{0665}\x{200B}。\x{0737}", %p)},	undef,	"to_unicode\(\'𠨧\\u0665\\u200B。\\u0737\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2294\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0855}뾜⊙\x{AAF6}。\x{089D}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u0855뾜⊙\\uAAF6。\\u089D\\uD803\\uDE75\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2295\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0855}뾜⊙\x{AAF6}。\x{089D}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\u0855뾜⊙\\uAAF6。\\u089D\\uD803\\uDE75\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2296\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E73}≠｡⒖⸃\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73≠｡⒖⸃\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2297\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E73}≠｡⒖⸃\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73≠｡⒖⸃\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2298\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E73}=\x{0338}｡⒖⸃\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73\=\\u0338｡⒖⸃\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2299\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E73}=\x{0338}｡⒖⸃\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73\=\\u0338｡⒖⸃\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2300\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E73}≠。15.⸃\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73≠。15\.⸃\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2301\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E73}≠。15.⸃\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73≠。15\.⸃\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2302\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E73}=\x{0338}。15.⸃\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73\=\\u0338。15\.⸃\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2303\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E73}=\x{0338}。15.⸃\x{200C}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE73\=\\u0338。15\.⸃\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2304\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{115F}\x{8845A}\x{103A}．\x{200D}\x{11046}\x{1E9A2}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD9E1\\uDC5A\\u103A．\\u200D\\uD804\\uDC46\\uD83A\\uDDA2\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2305\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{115F}\x{8845A}\x{103A}．\x{200D}\x{11046}\x{1E9A2}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD9E1\\uDC5A\\u103A．\\u200D\\uD804\\uDC46\\uD83A\\uDDA2\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2306\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{115F}\x{8845A}\x{103A}.\x{200D}\x{11046}\x{1E9A2}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD9E1\\uDC5A\\u103A\.\\u200D\\uD804\\uDC46\\uD83A\\uDDA2\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2307\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{115F}\x{8845A}\x{103A}.\x{200D}\x{11046}\x{1E9A2}", %p)},	undef,	"to_unicode\(\'\\u115F\\uD9E1\\uDC5A\\u103A\.\\u200D\\uD804\\uDC46\\uD83A\\uDDA2\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2308\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AD20D}\x{0AC5}\x{05C5}\x{05AD}。≮", %p)},	undef,	"to_unicode\(\'\\uDA74\\uDE0D\\u0AC5\\u05C5\\u05AD。≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2309\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AD20D}\x{0AC5}\x{05C5}\x{05AD}。<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDA74\\uDE0D\\u0AC5\\u05C5\\u05AD。\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2310\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0F9B}.\x{1032}暀≠", %p)},	undef,	"to_unicode\(\'\\u0F9B\.\\u1032暀≠\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F9B}.\x{1032}暀=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0F9B\.\\u1032暀\=\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2312\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10C23}\x{A806}｡\x{10DFB}\x{C0AAC}\x{11081}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC23\\uA806｡\\uD803\\uDDFB\\uDAC2\\uDEAC\\uD804\\uDC81\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2313\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10C23}\x{A806}。\x{10DFB}\x{C0AAC}\x{11081}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDC23\\uA806。\\uD803\\uDDFB\\uDAC2\\uDEAC\\uD804\\uDC81\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2314\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1D17E}\x{200D}⒈｡Ⴌ\x{1ED9D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD7E\\u200D⒈｡Ⴌ\\uD83B\\uDD9D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2315\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1D17E}\x{200D}⒈｡Ⴌ\x{1ED9D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD7E\\u200D⒈｡Ⴌ\\uD83B\\uDD9D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2316\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1D17E}\x{200D}1.。Ⴌ\x{1ED9D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD7E\\u200D1\.。Ⴌ\\uD83B\\uDD9D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2317\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1D17E}\x{200D}1.。Ⴌ\x{1ED9D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD7E\\u200D1\.。Ⴌ\\uD83B\\uDD9D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2318\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1D17E}\x{200D}1.。ⴌ\x{1ED9D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD7E\\u200D1\.。ⴌ\\uD83B\\uDD9D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2319\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1D17E}\x{200D}1.。ⴌ\x{1ED9D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD7E\\u200D1\.。ⴌ\\uD83B\\uDD9D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ A4_2\ B5\ B6\ \[data\/IdnaTest\.txt\:2320\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1D17E}\x{200D}⒈｡ⴌ\x{1ED9D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD7E\\u200D⒈｡ⴌ\\uD83B\\uDD9D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2321\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1D17E}\x{200D}⒈｡ⴌ\x{1ED9D}", %p)},	undef,	"to_unicode\(\'\\uD834\\uDD7E\\u200D⒈｡ⴌ\\uD83B\\uDD9D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B5\ B6\ \[data\/IdnaTest\.txt\:2322\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DAA}\x{0BCD}\x{151AB}\x{076B}.ς\x{78786}\x{90BAA}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDAA\\u0BCD\\uD814\\uDDAB\\u076B\.ς\\uD9A1\\uDF86\\uDA02\\uDFAA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2323\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DAA}\x{0BCD}\x{151AB}\x{076B}.Σ\x{78786}\x{90BAA}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDAA\\u0BCD\\uD814\\uDDAB\\u076B\.Σ\\uD9A1\\uDF86\\uDA02\\uDFAA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2324\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DAA}\x{0BCD}\x{151AB}\x{076B}.σ\x{78786}\x{90BAA}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDAA\\u0BCD\\uD814\\uDDAB\\u076B\.σ\\uD9A1\\uDF86\\uDA02\\uDFAA\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2325\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0844}。\x{200C}\x{06BE}\x{5D389}", %p)},	undef,	"to_unicode\(\'\\u0844。\\u200C\\u06BE\\uD934\\uDF89\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2326\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0844}。\x{200C}\x{06BE}\x{5D389}", %p)},	undef,	"to_unicode\(\'\\u0844。\\u200C\\u06BE\\uD934\\uDF89\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2327\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1A78}\x{E0196}.\x{0AC3}\x{06AF}\x{06BF}\x{1A18}", %p)},	undef,	"to_unicode\(\'\\u1A78\\uDB40\\uDD96\.\\u0AC3\\u06AF\\u06BF\\u1A18\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2328\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹\x{10D5DB}6．\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\\uDBF5\\uDDDB6．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2329\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹\x{10D5DB}6．\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\\uDBF5\\uDDDB6．\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2330\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹\x{10D5DB}6.\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\\uDBF5\\uDDDB6\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2331\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䂹\x{10D5DB}6.\x{200D}", %p)},	undef,	"to_unicode\(\'䂹\\uDBF5\\uDDDB6\.\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2332\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}\x{200C}\x{10E6B}\x{200C}｡\x{1ECE5}۰", %p)},	undef,	"to_unicode\(\'\\u0BCD\\u200C\\uD803\\uDE6B\\u200C｡\\uD83B\\uDCE5۰\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2333\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}\x{200C}\x{10E6B}\x{200C}｡\x{1ECE5}۰", %p)},	undef,	"to_unicode\(\'\\u0BCD\\u200C\\uD803\\uDE6B\\u200C｡\\uD83B\\uDCE5۰\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2334\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}\x{200C}\x{10E6B}\x{200C}。\x{1ECE5}۰", %p)},	undef,	"to_unicode\(\'\\u0BCD\\u200C\\uD803\\uDE6B\\u200C。\\uD83B\\uDCE5۰\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2335\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}\x{200C}\x{10E6B}\x{200C}。\x{1ECE5}۰", %p)},	undef,	"to_unicode\(\'\\u0BCD\\u200C\\uD803\\uDE6B\\u200C。\\uD83B\\uDCE5۰\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2336\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒｡Ⴃ≯", %p)},	undef,	"to_unicode\(\'︒｡Ⴃ≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2337\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡Ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'︒｡Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2338\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。Ⴃ≯", %p)},	undef,	"to_unicode\(\'。。Ⴃ≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2339\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。Ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'。。Ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2340\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'。。ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2341\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。。ⴃ≯", %p)},	undef,	"to_unicode\(\'。。ⴃ≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2342\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡ⴃ>\x{0338}", %p)},	undef,	"to_unicode\(\'︒｡ⴃ\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2343\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒｡ⴃ≯", %p)},	undef,	"to_unicode\(\'︒｡ⴃ≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2344\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E79}｡\x{E0D8D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE79｡\\uDB43\\uDD8D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2345\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E79}｡\x{E0D8D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE79｡\\uDB43\\uDD8D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2346\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E79}。\x{E0D8D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE79。\\uDB43\\uDD8D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2347\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E79}。\x{E0D8D}\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE79。\\uDB43\\uDD8D\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2348\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴞ\x{0600}｡︒ꡠ\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ\\u0600｡︒ꡠ\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:2349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{0600}｡︒ꡠ\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ\\u0600｡︒ꡠ\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:2350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{0600}。。ꡠ\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ\\u0600。。ꡠ\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:2351\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴞ\x{0600}。。ꡠ\x{200D}Ⴏ", %p)},	undef,	"to_unicode\(\'Ⴞ\\u0600。。ꡠ\\u200DႯ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:2352\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{0600}。。ꡠ\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ\\u0600。。ꡠ\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:2353\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{0600}。。ꡠ\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ\\u0600。。ꡠ\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ A4_2\ C2\ \[data\/IdnaTest\.txt\:2354\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{0600}｡︒ꡠ\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ\\u0600｡︒ꡠ\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:2355\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴞ\x{0600}｡︒ꡠ\x{200D}ⴏ", %p)},	undef,	"to_unicode\(\'ⴞ\\u0600｡︒ꡠ\\u200Dⴏ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:2356\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ⒈。-\x{E0158}-\x{07D2}", %p)},	undef,	"to_unicode\(\'\\u200CႦ⒈。\-\\uDB40\\uDD58\-\\u07D2\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2357\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ⒈。-\x{E0158}-\x{07D2}", %p)},	undef,	"to_unicode\(\'\\u200CႦ⒈。\-\\uDB40\\uDD58\-\\u07D2\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ1.。-\x{E0158}-\x{07D2}", %p)},	undef,	"to_unicode\(\'\\u200CႦ1\.。\-\\uDB40\\uDD58\-\\u07D2\'\)\ throws\ error\ P1\ V6\ V3\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴆ1.。-\x{E0158}-\x{07D2}", %p)},	undef,	"to_unicode\(\'\\u200CႦ1\.。\-\\uDB40\\uDD58\-\\u07D2\'\)\ throws\ error\ P1\ V6\ V3\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴆ1.。-\x{E0158}-\x{07D2}", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ1\.。\-\\uDB40\\uDD58\-\\u07D2\'\)\ throws\ error\ V3\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴆ1.。-\x{E0158}-\x{07D2}", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ1\.。\-\\uDB40\\uDD58\-\\u07D2\'\)\ throws\ error\ V3\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:2362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴆ⒈。-\x{E0158}-\x{07D2}", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ⒈。\-\\uDB40\\uDD58\-\\u07D2\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴆ⒈。-\x{E0158}-\x{07D2}", %p)},	undef,	"to_unicode\(\'\\u200Cⴆ⒈。\-\\uDB40\\uDD58\-\\u07D2\'\)\ throws\ error\ P1\ V6\ V3\ C1\ B1\ \[data\/IdnaTest\.txt\:2364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{E005A}｡≠-𐆓", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\uDB40\\uDC5A｡≠\-𐆓\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{E005A}｡=\x{0338}-𐆓", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\uDB40\\uDC5A｡\=\\u0338\-𐆓\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{E005A}。≠-𐆓", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\uDB40\\uDC5A。≠\-𐆓\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃Ⴡ-\x{E005A}。=\x{0338}-𐆓", %p)},	undef,	"to_unicode\(\'箃Ⴡ\-\\uDB40\\uDC5A。\=\\u0338\-𐆓\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{E005A}。=\x{0338}-𐆓", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\uDB40\\uDC5A。\=\\u0338\-𐆓\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{E005A}。≠-𐆓", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\uDB40\\uDC5A。≠\-𐆓\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{E005A}｡=\x{0338}-𐆓", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\uDB40\\uDC5A｡\=\\u0338\-𐆓\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("箃ⴡ-\x{E005A}｡≠-𐆓", %p)},	undef,	"to_unicode\(\'箃ⴡ\-\\uDB40\\uDC5A｡≠\-𐆓\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡫ.\x{07DF}", %p)},	"ᡫ.\x{07DF}",	"to_unicode\(\'ᡫ\.\\u07DF\'\)\ \[data\/IdnaTest\.txt\:2373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--78e.xn--6sb", %p)},	"ᡫ.\x{07DF}",	"to_unicode\(\'xn\-\-78e\.xn\-\-6sb\'\)\ \[data\/IdnaTest\.txt\:2374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}.ꡑ", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\.ꡑ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200D}.ꡑ", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\.ꡑ\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:2376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--qc9a", %p)},	"ꡑ",	"to_unicode\(\'xn\-\-qc9a\'\)\ \[data\/IdnaTest\.txt\:2377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡑ", %p)},	"ꡑ",	"to_unicode\(\'ꡑ\'\)\ \[data\/IdnaTest\.txt\:2378\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E07EA}\x{10E7A}\x{06C5}.ς\x{1039}蜹", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDFEA\\uD803\\uDE7A\\u06C5\.ς\\u1039蜹\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2379\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E07EA}\x{10E7A}\x{06C5}.Σ\x{1039}蜹", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDFEA\\uD803\\uDE7A\\u06C5\.Σ\\u1039蜹\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2380\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E07EA}\x{10E7A}\x{06C5}.σ\x{1039}蜹", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDFEA\\uD803\\uDE7A\\u06C5\.σ\\u1039蜹\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2381\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9D1CE}ス\x{101FF0}\x{10E75}．\x{C819F}", %p)},	undef,	"to_unicode\(\'\\uDA34\\uDDCEス\\uDBC7\\uDFF0\\uD803\\uDE75．\\uDAE0\\uDD9F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2382\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9D1CE}ス\x{101FF0}\x{10E75}.\x{C819F}", %p)},	undef,	"to_unicode\(\'\\uDA34\\uDDCEス\\uDBC7\\uDFF0\\uD803\\uDE75\.\\uDAE0\\uDD9F\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2383\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B81}\x{4B205}．\x{0F87}\x{D850}\x{0721}", %p)},	undef,	"to_unicode\(\'\\u1B81\\uD8EC\\uDE05．\\u0F87\\uD850\\u0721\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2384\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B81}\x{4B205}.\x{0F87}\x{D850}\x{0721}", %p)},	undef,	"to_unicode\(\'\\u1B81\\uD8EC\\uDE05\.\\u0F87\\uD850\\u0721\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2385\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0668}\x{C3F02}\x{200C}。\x{08A7}", %p)},	undef,	"to_unicode\(\'\\u0668\\uDACF\\uDF02\\u200C。\\u08A7\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2386\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0668}\x{C3F02}\x{200C}。\x{08A7}", %p)},	undef,	"to_unicode\(\'\\u0668\\uDACF\\uDF02\\u200C。\\u08A7\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2387\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1BAA}\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_unicode\(\'\\u1BAA\\u200D\\u200C。\-\\u200C\'\)\ throws\ error\ V5\ V3\ C1\ \[data\/IdnaTest\.txt\:2388\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1BAA}\x{200D}\x{200C}。-\x{200C}", %p)},	undef,	"to_unicode\(\'\\u1BAA\\u200D\\u200C。\-\\u200C\'\)\ throws\ error\ V5\ V3\ C1\ \[data\/IdnaTest\.txt\:2389\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︒｡\x{1BAB}\x{076E}", %p)},	undef,	"to_unicode\(\'︒｡\\u1BAB\\u076E\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2390\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("。。\x{1BAB}\x{076E}", %p)},	undef,	"to_unicode\(\'。。\\u1BAB\\u076E\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2391\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{067C}ß。ጫ\x{06B3}\x{0698}1", %p)},	undef,	"to_unicode\(\'\\u067Cß。ጫ\\u06B3\\u06981\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2392\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067C}SS。ጫ\x{06B3}\x{0698}1", %p)},	undef,	"to_unicode\(\'\\u067CSS。ጫ\\u06B3\\u06981\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2393\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067C}ss。ጫ\x{06B3}\x{0698}1", %p)},	undef,	"to_unicode\(\'\\u067Css。ጫ\\u06B3\\u06981\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2394\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{067C}Ss。ጫ\x{06B3}\x{0698}1", %p)},	undef,	"to_unicode\(\'\\u067CSs。ጫ\\u06B3\\u06981\'\)\ throws\ error\ B2\ B3\ B5\ \[data\/IdnaTest\.txt\:2395\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FB52}\x{1E9A7}ᚲ.\x{0B4D}꒕🄇\x{1714}", %p)},	undef,	"to_unicode\(\'\\uFB52\\uD83A\\uDDA7ᚲ\.\\u0B4D꒕🄇\\u1714\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2396\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{067B}\x{1E9A7}ᚲ.\x{0B4D}꒕6,\x{1714}", %p)},	undef,	"to_unicode\(\'\\u067B\\uD83A\\uDDA7ᚲ\.\\u0B4D꒕6\,\\u1714\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ \[data\/IdnaTest\.txt\:2397\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{0A4D}︒\x{200D}.\x{D2E58}簸", %p)},	undef,	"to_unicode\(\'\-\\u0A4D︒\\u200D\.\\uDB0B\\uDE58簸\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2398\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{0A4D}︒\x{200D}.\x{D2E58}簸", %p)},	undef,	"to_unicode\(\'\-\\u0A4D︒\\u200D\.\\uDB0B\\uDE58簸\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2399\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{0A4D}。\x{200D}.\x{D2E58}簸", %p)},	undef,	"to_unicode\(\'\-\\u0A4D。\\u200D\.\\uDB0B\\uDE58簸\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2400\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{0A4D}。\x{200D}.\x{D2E58}簸", %p)},	undef,	"to_unicode\(\'\-\\u0A4D。\\u200D\.\\uDB0B\\uDE58簸\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2401\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⳧.≯\x{05B7}", %p)},	undef,	"to_unicode\(\'⳧\.≯\\u05B7\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2402\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⳧.>\x{0338}\x{05B7}", %p)},	undef,	"to_unicode\(\'⳧\.\>\\u0338\\u05B7\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2403\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{0ACD}\x{0359}\x{0666}。\x{1EFB3}", %p)},	undef,	"to_unicode\(\'\-\\u0ACD\\u0359\\u0666。\\uD83B\\uDFB3\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2404\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᡢ．\x{06EE}\x{115F}", %p)},	undef,	"to_unicode\(\'ᡢ．\\u06EE\\u115F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡢ.\x{06EE}\x{115F}", %p)},	undef,	"to_unicode\(\'ᡢ\.\\u06EE\\u115F\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2406\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㨛\x{BA6B3}.︒𝟜\x{085A}", %p)},	undef,	"to_unicode\(\'㨛\\uDAA9\\uDEB3\.︒𝟜\\u085A\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2407\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㨛\x{BA6B3}.。4\x{085A}", %p)},	undef,	"to_unicode\(\'㨛\\uDAA9\\uDEB3\.。4\\u085A\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:2408\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0602}\x{60317}-｡\x{10E89}\x{E0024}\x{08A8}≮", %p)},	undef,	"to_unicode\(\'\\u0602\\uD940\\uDF17\-｡\\uD803\\uDE89\\uDB40\\uDC24\\u08A8≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2409\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0602}\x{60317}-｡\x{10E89}\x{E0024}\x{08A8}<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0602\\uD940\\uDF17\-｡\\uD803\\uDE89\\uDB40\\uDC24\\u08A8\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2410\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0602}\x{60317}-。\x{10E89}\x{E0024}\x{08A8}≮", %p)},	undef,	"to_unicode\(\'\\u0602\\uD940\\uDF17\-。\\uD803\\uDE89\\uDB40\\uDC24\\u08A8≮\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2411\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0602}\x{60317}-。\x{10E89}\x{E0024}\x{08A8}<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0602\\uD940\\uDF17\-。\\uD803\\uDE89\\uDB40\\uDC24\\u08A8\<\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B3\ \[data\/IdnaTest\.txt\:2412\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200C}\x{11101}ᡚ．\x{06EA}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uD804\\uDD01ᡚ．\\u06EAჁႶ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2413\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200C}\x{11101}ᡚ．\x{06EA}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uD804\\uDD01ᡚ．\\u06EAჁႶ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2414\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200C}\x{11101}ᡚ.\x{06EA}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uD804\\uDD01ᡚ\.\\u06EAჁႶ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2415\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200C}\x{11101}ᡚ.\x{06EA}ჁႶ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uD804\\uDD01ᡚ\.\\u06EAჁႶ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2416\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200C}\x{11101}ᡚ.\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uD804\\uDD01ᡚ\.\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2417\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200C}\x{11101}ᡚ.\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uD804\\uDD01ᡚ\.\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2418\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{200C}\x{11101}ᡚ.\x{06EA}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uD804\\uDD01ᡚ\.\\u06EAჁႶ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2419\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{200C}\x{11101}ᡚ.\x{06EA}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uD804\\uDD01ᡚ\.\\u06EAჁႶ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2420\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{200C}\x{11101}ᡚ.\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uD804\\uDD01ᡚ\.\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2421\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{200C}\x{11101}ᡚ.\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uD804\\uDD01ᡚ\.\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2422\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{200C}\x{11101}ᡚ.\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uD804\\uDD01ᡚ\.\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2423\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{200C}\x{11101}ᡚ.\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uD804\\uDD01ᡚ\.\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2424\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200C}\x{11101}ᡚ．\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uD804\\uDD01ᡚ．\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2425\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200C}\x{11101}ᡚ．\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ß\\u200C\\uD804\\uDD01ᡚ．\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2426\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{200C}\x{11101}ᡚ．\x{06EA}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uD804\\uDD01ᡚ．\\u06EAჁႶ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2427\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{200C}\x{11101}ᡚ．\x{06EA}ჁႶ", %p)},	undef,	"to_unicode\(\'SS\\u200C\\uD804\\uDD01ᡚ．\\u06EAჁႶ\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:2428\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{200C}\x{11101}ᡚ．\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uD804\\uDD01ᡚ．\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2429\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{200C}\x{11101}ᡚ．\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'ss\\u200C\\uD804\\uDD01ᡚ．\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2430\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{200C}\x{11101}ᡚ．\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uD804\\uDD01ᡚ．\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2431\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{200C}\x{11101}ᡚ．\x{06EA}ⴡⴖ", %p)},	undef,	"to_unicode\(\'Ss\\u200C\\uD804\\uDD01ᡚ．\\u06EAⴡⴖ\'\)\ throws\ error\ V5\ C1\ \[data\/IdnaTest\.txt\:2432\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。ς\x{11039}", %p)},	undef,	"to_unicode\(\'\\u200D。ς\\uD804\\uDC39\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2433\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。ς\x{11039}", %p)},	undef,	"to_unicode\(\'\\u200D。ς\\uD804\\uDC39\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2434\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。Σ\x{11039}", %p)},	undef,	"to_unicode\(\'\\u200D。Σ\\uD804\\uDC39\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2435\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。Σ\x{11039}", %p)},	undef,	"to_unicode\(\'\\u200D。Σ\\uD804\\uDC39\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2436\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。σ\x{11039}", %p)},	undef,	"to_unicode\(\'\\u200D。σ\\uD804\\uDC39\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2437\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}。σ\x{11039}", %p)},	undef,	"to_unicode\(\'\\u200D。σ\\uD804\\uDC39\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2438\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--4xa6658k", %p)},	"σ\x{11039}",	"to_unicode\(\'xn\-\-4xa6658k\'\)\ \[data\/IdnaTest\.txt\:2439\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ\x{11039}", %p)},	"σ\x{11039}",	"to_unicode\(\'σ\\uD804\\uDC39\'\)\ \[data\/IdnaTest\.txt\:2440\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ\x{11039}", %p)},	"σ\x{11039}",	"to_unicode\(\'Σ\\uD804\\uDC39\'\)\ \[data\/IdnaTest\.txt\:2441\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0721}ß.\x{0714}\x{200D}ᢊ-", %p)},	undef,	"to_unicode\(\'\\u0721ß\.\\u0714\\u200Dᢊ\-\'\)\ throws\ error\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2442\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0721}ß.\x{0714}\x{200D}ᢊ-", %p)},	undef,	"to_unicode\(\'\\u0721ß\.\\u0714\\u200Dᢊ\-\'\)\ throws\ error\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2443\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0721}SS.\x{0714}\x{200D}ᢊ-", %p)},	undef,	"to_unicode\(\'\\u0721SS\.\\u0714\\u200Dᢊ\-\'\)\ throws\ error\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2444\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0721}SS.\x{0714}\x{200D}ᢊ-", %p)},	undef,	"to_unicode\(\'\\u0721SS\.\\u0714\\u200Dᢊ\-\'\)\ throws\ error\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2445\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0721}ss.\x{0714}\x{200D}ᢊ-", %p)},	undef,	"to_unicode\(\'\\u0721ss\.\\u0714\\u200Dᢊ\-\'\)\ throws\ error\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2446\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0721}ss.\x{0714}\x{200D}ᢊ-", %p)},	undef,	"to_unicode\(\'\\u0721ss\.\\u0714\\u200Dᢊ\-\'\)\ throws\ error\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2447\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0721}Ss.\x{0714}\x{200D}ᢊ-", %p)},	undef,	"to_unicode\(\'\\u0721Ss\.\\u0714\\u200Dᢊ\-\'\)\ throws\ error\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2448\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0721}Ss.\x{0714}\x{200D}ᢊ-", %p)},	undef,	"to_unicode\(\'\\u0721Ss\.\\u0714\\u200Dᢊ\-\'\)\ throws\ error\ V3\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:2449\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{302A}\x{200D}ᡗ．\x{10E77}\x{97264}-", %p)},	undef,	"to_unicode\(\'\\u302A\\u200Dᡗ．\\uD803\\uDE77\\uDA1C\\uDE64\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:2450\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{302A}\x{200D}ᡗ．\x{10E77}\x{97264}-", %p)},	undef,	"to_unicode\(\'\\u302A\\u200Dᡗ．\\uD803\\uDE77\\uDA1C\\uDE64\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:2451\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{302A}\x{200D}ᡗ.\x{10E77}\x{97264}-", %p)},	undef,	"to_unicode\(\'\\u302A\\u200Dᡗ\.\\uD803\\uDE77\\uDA1C\\uDE64\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:2452\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{302A}\x{200D}ᡗ.\x{10E77}\x{97264}-", %p)},	undef,	"to_unicode\(\'\\u302A\\u200Dᡗ\.\\uD803\\uDE77\\uDA1C\\uDE64\-\'\)\ throws\ error\ P1\ V5\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:2453\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟢\x{81DED}\x{49122}\x{135F}.-\x{63ADF}", %p)},	undef,	"to_unicode\(\'𝟢\\uD9C7\\uDDED\\uD8E4\\uDD22\\u135F\.\-\\uD94E\\uDEDF\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2454\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("0\x{81DED}\x{49122}\x{135F}.-\x{63ADF}", %p)},	undef,	"to_unicode\(\'0\\uD9C7\\uDDED\\uD8E4\\uDD22\\u135F\.\-\\uD94E\\uDEDF\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2455\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡\x{200D}", %p)},	undef,	"to_unicode\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2456\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-｡\x{200D}", %p)},	undef,	"to_unicode\(\'\-｡\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2457\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{200D}", %p)},	undef,	"to_unicode\(\'\-。\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2458\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。\x{200D}", %p)},	undef,	"to_unicode\(\'\-。\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:2459\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᠪ．ς７-\x{DB09}", %p)},	undef,	"to_unicode\(\'≮ᠪ．ς７\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2460\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᠪ．ς７-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᠪ．ς７\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2461\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᠪ.ς7-\x{DB09}", %p)},	undef,	"to_unicode\(\'≮ᠪ\.ς7\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2462\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᠪ.ς7-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᠪ\.ς7\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2463\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᠪ.Σ7-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᠪ\.Σ7\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2464\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᠪ.Σ7-\x{DB09}", %p)},	undef,	"to_unicode\(\'≮ᠪ\.Σ7\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2465\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᠪ.σ7-\x{DB09}", %p)},	undef,	"to_unicode\(\'≮ᠪ\.σ7\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2466\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᠪ.σ7-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᠪ\.σ7\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2467\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᠪ．Σ７-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᠪ．Σ７\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2468\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᠪ．Σ７-\x{DB09}", %p)},	undef,	"to_unicode\(\'≮ᠪ．Σ７\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2469\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ᠪ．σ７-\x{DB09}", %p)},	undef,	"to_unicode\(\'≮ᠪ．σ７\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2470\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ᠪ．σ７-\x{DB09}", %p)},	undef,	"to_unicode\(\'\<\\u0338ᠪ．σ７\-\\uDB09\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2471\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ቬ\x{DA1A0}\x{6D893}｡\x{10856}𝟫", %p)},	undef,	"to_unicode\(\'ቬ\\uDB28\\uDDA0\\uD976\\uDC93｡\\uD802\\uDC56𝟫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2472\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ቬ\x{DA1A0}\x{6D893}。\x{10856}9", %p)},	undef,	"to_unicode\(\'ቬ\\uDB28\\uDDA0\\uD976\\uDC93。\\uD802\\uDC569\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2473\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1086F}。蔫ꡏ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC6F。蔫ꡏ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2474\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{127B3}３｡ꡂ\x{71F1B}\x{17CD}ᡁ", %p)},	undef,	"to_unicode\(\'\\uD809\\uDFB3３｡ꡂ\\uD987\\uDF1B\\u17CDᡁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2475\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{127B3}3。ꡂ\x{71F1B}\x{17CD}ᡁ", %p)},	undef,	"to_unicode\(\'\\uD809\\uDFB33。ꡂ\\uD987\\uDF1B\\u17CDᡁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2476\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4469F}ᡑ≠.ß", %p)},	undef,	"to_unicode\(\'\\uD8D1\\uDE9Fᡑ≠\.ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2477\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4469F}ᡑ=\x{0338}.ß", %p)},	undef,	"to_unicode\(\'\\uD8D1\\uDE9Fᡑ\=\\u0338\.ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2478\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4469F}ᡑ=\x{0338}.SS", %p)},	undef,	"to_unicode\(\'\\uD8D1\\uDE9Fᡑ\=\\u0338\.SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2479\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{4469F}ᡑ≠.SS", %p)},	undef,	"to_unicode\(\'\\uD8D1\\uDE9Fᡑ≠\.SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2480\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠧ\x{0842}\x{E0152}۱.\x{0664}\x{FB20}⼀\x{200C}", %p)},	undef,	"to_unicode\(\'ᠧ\\u0842\\uDB40\\uDD52۱\.\\u0664\\uFB20⼀\\u200C\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:2481\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠧ\x{0842}\x{E0152}۱.\x{0664}\x{FB20}⼀\x{200C}", %p)},	undef,	"to_unicode\(\'ᠧ\\u0842\\uDB40\\uDD52۱\.\\u0664\\uFB20⼀\\u200C\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:2482\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠧ\x{0842}\x{E0152}۱.\x{0664}\x{05E2}一\x{200C}", %p)},	undef,	"to_unicode\(\'ᠧ\\u0842\\uDB40\\uDD52۱\.\\u0664\\u05E2一\\u200C\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:2483\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᠧ\x{0842}\x{E0152}۱.\x{0664}\x{05E2}一\x{200C}", %p)},	undef,	"to_unicode\(\'ᠧ\\u0842\\uDB40\\uDD52۱\.\\u0664\\u05E2一\\u200C\'\)\ throws\ error\ B5\ B1\ C1\ \[data\/IdnaTest\.txt\:2484\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς\x{200D}-.Ⴣ\x{98733}", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.Ⴣ\\uDA21\\uDF33\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2485\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς\x{200D}-.Ⴣ\x{98733}", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.Ⴣ\\uDA21\\uDF33\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2486\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς\x{200D}-.ⴣ\x{98733}", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.ⴣ\\uDA21\\uDF33\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2487\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς\x{200D}-.ⴣ\x{98733}", %p)},	undef,	"to_unicode\(\'ς\\u200D\-\.ⴣ\\uDA21\\uDF33\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2488\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ\x{200D}-.Ⴣ\x{98733}", %p)},	undef,	"to_unicode\(\'Σ\\u200D\-\.Ⴣ\\uDA21\\uDF33\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2489\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ\x{200D}-.Ⴣ\x{98733}", %p)},	undef,	"to_unicode\(\'Σ\\u200D\-\.Ⴣ\\uDA21\\uDF33\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2490\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ\x{200D}-.ⴣ\x{98733}", %p)},	undef,	"to_unicode\(\'σ\\u200D\-\.ⴣ\\uDA21\\uDF33\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2491\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ\x{200D}-.ⴣ\x{98733}", %p)},	undef,	"to_unicode\(\'σ\\u200D\-\.ⴣ\\uDA21\\uDF33\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:2492\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≠。\x{E0880}𝟑", %p)},	undef,	"to_unicode\(\'≠。\\uDB42\\uDC80𝟑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2493\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("=\x{0338}。\x{E0880}𝟑", %p)},	undef,	"to_unicode\(\'\=\\u0338。\\uDB42\\uDC80𝟑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2494\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≠。\x{E0880}3", %p)},	undef,	"to_unicode\(\'≠。\\uDB42\\uDC803\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2495\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("=\x{0338}。\x{E0880}3", %p)},	undef,	"to_unicode\(\'\=\\u0338。\\uDB42\\uDC803\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2496\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5223B}.蠔", %p)},	undef,	"to_unicode\(\'\\uD908\\uDE3B\.蠔\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2497\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{302C}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u302C\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2498\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{302C}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u302C\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2499\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{302C}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u302C\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2500\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{302C}\x{200D}．뼽", %p)},	undef,	"to_unicode\(\'\\u302C\\u200D．뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2501\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{302C}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u302C\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2502\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{302C}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u302C\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2503\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{302C}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u302C\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{302C}\x{200D}.뼽", %p)},	undef,	"to_unicode\(\'\\u302C\\u200D\.뼽\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2505\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟛\x{094D}Ⱉ\x{FEF9}。\x{E0077}\x{06EF}-\x{0874}", %p)},	undef,	"to_unicode\(\'𝟛\\u094DⰙ\\uFEF9。\\uDB40\\uDC77\\u06EF\-\\u0874\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2506\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{094D}Ⱉ\x{0644}\x{0625}。\x{E0077}\x{06EF}-\x{0874}", %p)},	undef,	"to_unicode\(\'3\\u094DⰙ\\u0644\\u0625。\\uDB40\\uDC77\\u06EF\-\\u0874\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2507\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{094D}Ⱉ\x{0644}\x{0627}\x{0655}。\x{E0077}\x{06EF}-\x{0874}", %p)},	undef,	"to_unicode\(\'3\\u094DⰙ\\u0644\\u0627\\u0655。\\uDB40\\uDC77\\u06EF\-\\u0874\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2508\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{094D}ⱉ\x{0644}\x{0627}\x{0655}。\x{E0077}\x{06EF}-\x{0874}", %p)},	undef,	"to_unicode\(\'3\\u094Dⱉ\\u0644\\u0627\\u0655。\\uDB40\\uDC77\\u06EF\-\\u0874\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2509\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{094D}ⱉ\x{0644}\x{0625}。\x{E0077}\x{06EF}-\x{0874}", %p)},	undef,	"to_unicode\(\'3\\u094Dⱉ\\u0644\\u0625。\\uDB40\\uDC77\\u06EF\-\\u0874\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2510\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟛\x{094D}ⱉ\x{FEF9}。\x{E0077}\x{06EF}-\x{0874}", %p)},	undef,	"to_unicode\(\'𝟛\\u094Dⱉ\\uFEF9。\\uDB40\\uDC77\\u06EF\-\\u0874\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2511\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡ᡯ", %p)},	undef,	"to_unicode\(\'\-｡ᡯ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2512\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。ᡯ", %p)},	undef,	"to_unicode\(\'\-。ᡯ\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2513\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0F93}\x{AEDEF}｡-⒈\x{07CA}\x{07E1}", %p)},	undef,	"to_unicode\(\'\\u0F93\\uDA7B\\uDDEF｡\-⒈\\u07CA\\u07E1\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2514\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0F92}\x{0FB7}\x{AEDEF}｡-⒈\x{07CA}\x{07E1}", %p)},	undef,	"to_unicode\(\'\\u0F92\\u0FB7\\uDA7B\\uDDEF｡\-⒈\\u07CA\\u07E1\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:2515\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0F92}\x{0FB7}\x{AEDEF}。-1.\x{07CA}\x{07E1}", %p)},	undef,	"to_unicode\(\'\\u0F92\\u0FB7\\uDA7B\\uDDEF。\-1\.\\u07CA\\u07E1\'\)\ throws\ error\ P1\ V5\ V6\ V3\ \[data\/IdnaTest\.txt\:2516\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("璛\x{0DCA}ᠨ.-", %p)},	undef,	"to_unicode\(\'璛\\u0DCAᠨ\.\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2517\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE0D}\x{07DF}\x{0C4D}샕．\x{10E6B}휁", %p)},	undef,	"to_unicode\(\'\\uFE0D\\u07DF\\u0C4D샕．\\uD803\\uDE6B휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE0D}\x{07DF}\x{0C4D}샕．\x{10E6B}휁", %p)},	undef,	"to_unicode\(\'\\uFE0D\\u07DF\\u0C4D샕．\\uD803\\uDE6B휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE0D}\x{07DF}\x{0C4D}샕.\x{10E6B}휁", %p)},	undef,	"to_unicode\(\'\\uFE0D\\u07DF\\u0C4D샕\.\\uD803\\uDE6B휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{FE0D}\x{07DF}\x{0C4D}샕.\x{10E6B}휁", %p)},	undef,	"to_unicode\(\'\\uFE0D\\u07DF\\u0C4D샕\.\\uD803\\uDE6B휁\'\)\ throws\ error\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2521\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{8C670}．\x{873D7}", %p)},	undef,	"to_unicode\(\'\\uD9F1\\uDE70．\\uD9DC\\uDFD7\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2522\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{8C670}.\x{873D7}", %p)},	undef,	"to_unicode\(\'\\uD9F1\\uDE70\.\\uD9DC\\uDFD7\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2523\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢊ\x{077A}｡\x{111C0}ᡁႭ-", %p)},	undef,	"to_unicode\(\'ᢊ\\u077A｡\\uD804\\uDDC0ᡁႭ\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2524\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢊ\x{077A}。\x{111C0}ᡁႭ-", %p)},	undef,	"to_unicode\(\'ᢊ\\u077A。\\uD804\\uDDC0ᡁႭ\-\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2525\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢊ\x{077A}。\x{111C0}ᡁⴍ-", %p)},	undef,	"to_unicode\(\'ᢊ\\u077A。\\uD804\\uDDC0ᡁⴍ\-\'\)\ throws\ error\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2526\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢊ\x{077A}｡\x{111C0}ᡁⴍ-", %p)},	undef,	"to_unicode\(\'ᢊ\\u077A｡\\uD804\\uDDC0ᡁⴍ\-\'\)\ throws\ error\ V3\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:2527\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EDDD}\x{1EA62}\x{1E96B}。\x{69DDF}𝟸Ⴋ\x{10957F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDDD\\uD83A\\uDE62\\uD83A\\uDD6B。\\uD967\\uDDDF𝟸Ⴋ\\uDBE5\\uDD7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2528\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EDDD}\x{1EA62}\x{1E96B}。\x{69DDF}2Ⴋ\x{10957F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDDD\\uD83A\\uDE62\\uD83A\\uDD6B。\\uD967\\uDDDF2Ⴋ\\uDBE5\\uDD7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2529\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EDDD}\x{1EA62}\x{1E96B}。\x{69DDF}2ⴋ\x{10957F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDDD\\uD83A\\uDE62\\uD83A\\uDD6B。\\uD967\\uDDDF2ⴋ\\uDBE5\\uDD7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2530\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EDDD}\x{1EA62}\x{1E96B}。\x{69DDF}𝟸ⴋ\x{10957F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDDD\\uD83A\\uDE62\\uD83A\\uDD6B。\\uD967\\uDDDF𝟸ⴋ\\uDBE5\\uDD7F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2531\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{07D0}︒🜢.≠", %p)},	undef,	"to_unicode\(\'4\\u07D0︒🜢\.≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2532\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{07D0}︒🜢.=\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u07D0︒🜢\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2533\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{07D0}。🜢.≠", %p)},	undef,	"to_unicode\(\'4\\u07D0。🜢\.≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2534\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4\x{07D0}。🜢.=\x{0338}", %p)},	undef,	"to_unicode\(\'4\\u07D0。🜢\.\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2535\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("🄀。\x{0340}", %p)},	undef,	"to_unicode\(\'🄀。\\u0340\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("🄀。\x{0300}", %p)},	undef,	"to_unicode\(\'🄀。\\u0300\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0.。\x{0300}", %p)},	undef,	"to_unicode\(\'0\.。\\u0300\'\)\ throws\ error\ V5\ A4_2\ \[data\/IdnaTest\.txt\:2538\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{CDCDB}.⾕", %p)},	undef,	"to_unicode\(\'\\u200C\\uDAF7\\uDCDB\.⾕\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2539\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{CDCDB}.⾕", %p)},	undef,	"to_unicode\(\'\\u200C\\uDAF7\\uDCDB\.⾕\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2540\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{CDCDB}.谷", %p)},	undef,	"to_unicode\(\'\\u200C\\uDAF7\\uDCDB\.谷\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2541\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{CDCDB}.谷", %p)},	undef,	"to_unicode\(\'\\u200C\\uDAF7\\uDCDB\.谷\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2542\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︒\x{75929}\x{200D}.-\x{0B44}\x{200C}", %p)},	undef,	"to_unicode\(\'︒\\uD996\\uDD29\\u200D\.\-\\u0B44\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2543\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︒\x{75929}\x{200D}.-\x{0B44}\x{200C}", %p)},	undef,	"to_unicode\(\'︒\\uD996\\uDD29\\u200D\.\-\\u0B44\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2544\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("。\x{75929}\x{200D}.-\x{0B44}\x{200C}", %p)},	undef,	"to_unicode\(\'。\\uD996\\uDD29\\u200D\.\-\\u0B44\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2545\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("。\x{75929}\x{200D}.-\x{0B44}\x{200C}", %p)},	undef,	"to_unicode\(\'。\\uD996\\uDD29\\u200D\.\-\\u0B44\\u200C\'\)\ throws\ error\ P1\ V6\ V3\ C2\ C1\ \[data\/IdnaTest\.txt\:2546\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≯ꡠ。\x{08A5}", %p)},	undef,	"to_unicode\(\'≯ꡠ。\\u08A5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2547\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode(">\x{0338}ꡠ。\x{08A5}", %p)},	undef,	"to_unicode\(\'\>\\u0338ꡠ。\\u08A5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2548\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2DE6}\x{A7D64}\x{E0BFD}。\x{06C7}\x{10E6E}", %p)},	undef,	"to_unicode\(\'\\u2DE6\\uDA5F\\uDD64\\uDB42\\uDFFD。\\u06C7\\uD803\\uDE6E\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2549\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0101}\x{07CF}𝟻𝟲｡۷", %p)},	"\x{07CF}56.۷",	"to_unicode\(\'\\uDB40\\uDD01\\u07CF𝟻𝟲｡۷\'\)\ \[data\/IdnaTest\.txt\:2550\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0101}\x{07CF}56。۷", %p)},	"\x{07CF}56.۷",	"to_unicode\(\'\\uDB40\\uDD01\\u07CF56。۷\'\)\ \[data\/IdnaTest\.txt\:2551\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--56-nue.xn--kmb", %p)},	"\x{07CF}56.۷",	"to_unicode\(\'xn\-\-56\-nue\.xn\-\-kmb\'\)\ \[data\/IdnaTest\.txt\:2552\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07CF}56.۷", %p)},	"\x{07CF}56.۷",	"to_unicode\(\'\\u07CF56\.۷\'\)\ \[data\/IdnaTest\.txt\:2553\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．🄃", %p)},	undef,	"to_unicode\(\'\\u200D．🄃\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2554\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}．🄃", %p)},	undef,	"to_unicode\(\'\\u200D．🄃\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2555\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.2,", %p)},	undef,	"to_unicode\(\'\\u200D\.2\,\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2556\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}.2,", %p)},	undef,	"to_unicode\(\'\\u200D\.2\,\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2557\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0776}\x{0647}\x{B59BE}。\x{063B}\x{2DE0}", %p)},	undef,	"to_unicode\(\'\\u0776\\u0647\\uDA96\\uDDBE。\\u063B\\u2DE0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2558\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0720}𝟵\x{06BE}겙。\x{1DD9}\x{FC55}", %p)},	undef,	"to_unicode\(\'\\u0720𝟵\\u06BE겙。\\u1DD9\\uFC55\'\)\ throws\ error\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2559\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}𝟵\x{06BE}겙。\x{1DD9}\x{FC55}", %p)},	undef,	"to_unicode\(\'\\u0720𝟵\\u06BE겙。\\u1DD9\\uFC55\'\)\ throws\ error\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2560\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}9\x{06BE}겙。\x{1DD9}\x{064A}\x{062C}", %p)},	undef,	"to_unicode\(\'\\u07209\\u06BE겙。\\u1DD9\\u064A\\u062C\'\)\ throws\ error\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2561\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0720}9\x{06BE}겙。\x{1DD9}\x{064A}\x{062C}", %p)},	undef,	"to_unicode\(\'\\u07209\\u06BE겙。\\u1DD9\\u064A\\u062C\'\)\ throws\ error\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2562\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴍ\x{4F9AF}ᠸ\x{1A7C}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\\uD8FE\\uDDAFᠸ\\u1A7C。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2563\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴍ\x{4F9AF}ᠸ\x{1A7C}。Ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴍ\\uD8FE\\uDDAFᠸ\\u1A7C。Ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2564\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴍ\x{4F9AF}ᠸ\x{1A7C}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\\uD8FE\\uDDAFᠸ\\u1A7C。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2565\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴍ\x{4F9AF}ᠸ\x{1A7C}。ⴞ\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴍ\\uD8FE\\uDDAFᠸ\\u1A7C。ⴞ\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2566\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("８。\x{4FF43}", %p)},	undef,	"to_unicode\(\'８。\\uD8FF\\uDF43\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2567\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("8。\x{4FF43}", %p)},	undef,	"to_unicode\(\'8。\\uD8FF\\uDF43\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2568\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{17F0D}\x{17B4}\x{0ACD}.\x{06DD}", %p)},	undef,	"to_unicode\(\'\\uD81F\\uDF0D\\u17B4\\u0ACD\.\\u06DD\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2569\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{09E2}Ⴋ\x{DC2F0}\x{10F765}．\x{545DB}₂휪\x{1A62}", %p)},	undef,	"to_unicode\(\'\\u09E2Ⴋ\\uDB30\\uDEF0\\uDBFD\\uDF65．\\uD911\\uDDDB₂휪\\u1A62\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2570\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{09E2}Ⴋ\x{DC2F0}\x{10F765}．\x{545DB}₂휪\x{1A62}", %p)},	undef,	"to_unicode\(\'\\u09E2Ⴋ\\uDB30\\uDEF0\\uDBFD\\uDF65．\\uD911\\uDDDB₂휪\\u1A62\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2571\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{09E2}Ⴋ\x{DC2F0}\x{10F765}.\x{545DB}2휪\x{1A62}", %p)},	undef,	"to_unicode\(\'\\u09E2Ⴋ\\uDB30\\uDEF0\\uDBFD\\uDF65\.\\uD911\\uDDDB2휪\\u1A62\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2572\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{09E2}Ⴋ\x{DC2F0}\x{10F765}.\x{545DB}2휪\x{1A62}", %p)},	undef,	"to_unicode\(\'\\u09E2Ⴋ\\uDB30\\uDEF0\\uDBFD\\uDF65\.\\uD911\\uDDDB2휪\\u1A62\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2573\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{09E2}ⴋ\x{DC2F0}\x{10F765}.\x{545DB}2휪\x{1A62}", %p)},	undef,	"to_unicode\(\'\\u09E2ⴋ\\uDB30\\uDEF0\\uDBFD\\uDF65\.\\uD911\\uDDDB2휪\\u1A62\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2574\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{09E2}ⴋ\x{DC2F0}\x{10F765}.\x{545DB}2휪\x{1A62}", %p)},	undef,	"to_unicode\(\'\\u09E2ⴋ\\uDB30\\uDEF0\\uDBFD\\uDF65\.\\uD911\\uDDDB2휪\\u1A62\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2575\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{09E2}ⴋ\x{DC2F0}\x{10F765}．\x{545DB}₂휪\x{1A62}", %p)},	undef,	"to_unicode\(\'\\u09E2ⴋ\\uDB30\\uDEF0\\uDBFD\\uDF65．\\uD911\\uDDDB₂휪\\u1A62\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2576\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{09E2}ⴋ\x{DC2F0}\x{10F765}．\x{545DB}₂휪\x{1A62}", %p)},	undef,	"to_unicode\(\'\\u09E2ⴋ\\uDB30\\uDEF0\\uDBFD\\uDF65．\\uD911\\uDDDB₂휪\\u1A62\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2577\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1ED62}．\x{FBE3}\x{10E60}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD62．\\uFBE3\\uD803\\uDE60\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2578\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1ED62}.\x{06C9}\x{10E60}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDD62\.\\u06C9\\uD803\\uDE60\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2579\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1714}２.8\x{0ACD}\x{200D}\x{E08AD}", %p)},	undef,	"to_unicode\(\'\\u1714２\.8\\u0ACD\\u200D\\uDB42\\uDCAD\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2580\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1714}2.8\x{0ACD}\x{200D}\x{E08AD}", %p)},	undef,	"to_unicode\(\'\\u17142\.8\\u0ACD\\u200D\\uDB42\\uDCAD\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2581\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E06B9}⩷\x{E0150}。\x{1ED73}\x{0A75}\x{E01CB}", %p)},	undef,	"to_unicode\(\'\\uDB41\\uDEB9⩷\\uDB40\\uDD50。\\uD83B\\uDD73\\u0A75\\uDB40\\uDDCB\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2582\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡞ≠\x{AA2B}\x{A5198}｡\x{FD34}\x{1B36}\x{FFA0}", %p)},	undef,	"to_unicode\(\'ꡞ≠\\uAA2B\\uDA54\\uDD98｡\\uFD34\\u1B36\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2583\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡞ=\x{0338}\x{AA2B}\x{A5198}｡\x{FD34}\x{1B36}\x{FFA0}", %p)},	undef,	"to_unicode\(\'ꡞ\=\\u0338\\uAA2B\\uDA54\\uDD98｡\\uFD34\\u1B36\\uFFA0\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2584\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡞ≠\x{AA2B}\x{A5198}。\x{0633}\x{062C}\x{1B36}\x{1160}", %p)},	undef,	"to_unicode\(\'ꡞ≠\\uAA2B\\uDA54\\uDD98。\\u0633\\u062C\\u1B36\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2585\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꡞ=\x{0338}\x{AA2B}\x{A5198}。\x{0633}\x{062C}\x{1B36}\x{1160}", %p)},	undef,	"to_unicode\(\'ꡞ\=\\u0338\\uAA2B\\uDA54\\uDD98。\\u0633\\u062C\\u1B36\\u1160\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2586\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("鱊。\x{200C}", %p)},	undef,	"to_unicode\(\'鱊。\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2587\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊。\x{200C}", %p)},	undef,	"to_unicode\(\'鱊。\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2588\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--rt6a.", %p)},	"鱊.",	"to_unicode\(\'xn\-\-rt6a\.\'\)\ \[data\/IdnaTest\.txt\:2589\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("鱊.", %p)},	"鱊.",	"to_unicode\(\'鱊\.\'\)\ \[data\/IdnaTest\.txt\:2590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8\x{10E73}．\x{034D}", %p)},	undef,	"to_unicode\(\'8\\uD803\\uDE73．\\u034D\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("8\x{10E73}.\x{034D}", %p)},	undef,	"to_unicode\(\'8\\uD803\\uDE73\.\\u034D\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2592\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DCA}\x{0864}．ᠹ", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDCA\\u0864．ᠹ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2593\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DCA}\x{0864}.ᠹ", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDCA\\u0864\.ᠹ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2594\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0754}\x{077C}4．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0754\\u077C4．\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2595\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0754}\x{077C}4．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0754\\u077C4．\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2596\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0754}\x{077C}4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0754\\u077C4\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2597\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0754}\x{077C}4.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0754\\u077C4\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:2598\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--4-53c4j.", %p)},	"\x{0754}\x{077C}4.",	"to_unicode\(\'xn\-\-4\-53c4j\.\'\)\ \[data\/IdnaTest\.txt\:2599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0754}\x{077C}4.", %p)},	"\x{0754}\x{077C}4.",	"to_unicode\(\'\\u0754\\u077C4\.\'\)\ \[data\/IdnaTest\.txt\:2600\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("5\x{0610}\x{082B}-.\x{0603}\x{E0FA7}", %p)},	undef,	"to_unicode\(\'5\\u0610\\u082B\-\.\\u0603\\uDB43\\uDFA7\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2601\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("-｡䏛", %p)},	undef,	"to_unicode\(\'\-｡䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2602\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("-。䏛", %p)},	undef,	"to_unicode\(\'\-。䏛\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:2603\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{9B8A0}．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA2E\\uDCA0．\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2604\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{9B8A0}．\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA2E\\uDCA0．\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2605\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{9B8A0}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA2E\\uDCA0\.\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2606\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{9B8A0}.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uDA2E\\uDCA0\.\\u200D\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2607\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{1059}\x{2CA0B}｡\x{10E66}\x{200D}\x{B2DBF}Ⴕ", %p)},	undef,	"to_unicode\(\'⒈\\u1059\\uD872\\uDE0B｡\\uD803\\uDE66\\u200D\\uDA8B\\uDDBFႵ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2608\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{1059}\x{2CA0B}｡\x{10E66}\x{200D}\x{B2DBF}Ⴕ", %p)},	undef,	"to_unicode\(\'⒈\\u1059\\uD872\\uDE0B｡\\uD803\\uDE66\\u200D\\uDA8B\\uDDBFႵ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2609\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{1059}\x{2CA0B}。\x{10E66}\x{200D}\x{B2DBF}Ⴕ", %p)},	undef,	"to_unicode\(\'1\.\\u1059\\uD872\\uDE0B。\\uD803\\uDE66\\u200D\\uDA8B\\uDDBFႵ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2610\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{1059}\x{2CA0B}。\x{10E66}\x{200D}\x{B2DBF}Ⴕ", %p)},	undef,	"to_unicode\(\'1\.\\u1059\\uD872\\uDE0B。\\uD803\\uDE66\\u200D\\uDA8B\\uDDBFႵ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2611\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{1059}\x{2CA0B}。\x{10E66}\x{200D}\x{B2DBF}ⴕ", %p)},	undef,	"to_unicode\(\'1\.\\u1059\\uD872\\uDE0B。\\uD803\\uDE66\\u200D\\uDA8B\\uDDBFⴕ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2612\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{1059}\x{2CA0B}。\x{10E66}\x{200D}\x{B2DBF}ⴕ", %p)},	undef,	"to_unicode\(\'1\.\\u1059\\uD872\\uDE0B。\\uD803\\uDE66\\u200D\\uDA8B\\uDDBFⴕ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2613\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{1059}\x{2CA0B}｡\x{10E66}\x{200D}\x{B2DBF}ⴕ", %p)},	undef,	"to_unicode\(\'⒈\\u1059\\uD872\\uDE0B｡\\uD803\\uDE66\\u200D\\uDA8B\\uDDBFⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2614\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{1059}\x{2CA0B}｡\x{10E66}\x{200D}\x{B2DBF}ⴕ", %p)},	undef,	"to_unicode\(\'⒈\\u1059\\uD872\\uDE0B｡\\uD803\\uDE66\\u200D\\uDA8B\\uDDBFⴕ\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2615\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF8C}\x{0847}-ß｡\x{17D3}効\x{10E67}\x{CF20F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF8C\\u0847\-ß｡\\u17D3効\\uD803\\uDE67\\uDAFC\\uDE0F\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2616\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF8C}\x{0847}-ß。\x{17D3}効\x{10E67}\x{CF20F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF8C\\u0847\-ß。\\u17D3効\\uD803\\uDE67\\uDAFC\\uDE0F\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2617\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF8C}\x{0847}-SS。\x{17D3}効\x{10E67}\x{CF20F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF8C\\u0847\-SS。\\u17D3効\\uD803\\uDE67\\uDAFC\\uDE0F\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2618\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF8C}\x{0847}-ss。\x{17D3}効\x{10E67}\x{CF20F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF8C\\u0847\-ss。\\u17D3効\\uD803\\uDE67\\uDAFC\\uDE0F\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2619\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF8C}\x{0847}-Ss。\x{17D3}効\x{10E67}\x{CF20F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF8C\\u0847\-Ss。\\u17D3効\\uD803\\uDE67\\uDAFC\\uDE0F\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2620\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF8C}\x{0847}-SS｡\x{17D3}効\x{10E67}\x{CF20F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF8C\\u0847\-SS｡\\u17D3効\\uD803\\uDE67\\uDAFC\\uDE0F\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2621\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF8C}\x{0847}-ss｡\x{17D3}効\x{10E67}\x{CF20F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF8C\\u0847\-ss｡\\u17D3効\\uD803\\uDE67\\uDAFC\\uDE0F\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2622\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF8C}\x{0847}-Ss｡\x{17D3}効\x{10E67}\x{CF20F}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF8C\\u0847\-Ss｡\\u17D3効\\uD803\\uDE67\\uDAFC\\uDE0F\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ \[data\/IdnaTest\.txt\:2623\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{AAF6}.\x{E0560}", %p)},	undef,	"to_unicode\(\'\\uAAF6\.\\uDB41\\uDD60\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2624\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0911}６\x{1E886}｡𝟹\x{11134}\x{10B70}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD11６\\uD83A\\uDC86｡𝟹\\uD804\\uDD34\\uD802\\uDF70\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2625\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0911}6\x{1E886}。3\x{11134}\x{10B70}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDD116\\uD83A\\uDC86。3\\uD804\\uDD34\\uD802\\uDF70\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2626\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᢢ𝟴\x{A92C}ꡝ。\x{1D17E}", %p)},	undef,	"to_unicode\(\'ᢢ𝟴\\uA92Cꡝ。\\uD834\\uDD7E\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2627\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᢢ8\x{A92C}ꡝ。\x{1D17E}", %p)},	undef,	"to_unicode\(\'ᢢ8\\uA92Cꡝ。\\uD834\\uDD7E\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2628\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{066C}-\x{92486}Ⴂ。\x{A0992}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u066C\-\\uDA09\\uDC86Ⴂ。\\uDA42\\uDD92\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2629\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{066C}-\x{92486}Ⴂ。\x{A0992}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u066C\-\\uDA09\\uDC86Ⴂ。\\uDA42\\uDD92\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2630\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{066C}-\x{92486}ⴂ。\x{A0992}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u066C\-\\uDA09\\uDC86ⴂ。\\uDA42\\uDD92\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2631\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{066C}-\x{92486}ⴂ。\x{A0992}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u066C\-\\uDA09\\uDC86ⴂ。\\uDA42\\uDD92\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2632\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⾆．\x{0723}0≯ß", %p)},	undef,	"to_unicode\(\'⾆．\\u07230≯ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2633\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0723}0>\x{0338}ß", %p)},	undef,	"to_unicode\(\'⾆．\\u07230\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2634\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0723}0≯ß", %p)},	undef,	"to_unicode\(\'舌\.\\u07230≯ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0723}0>\x{0338}ß", %p)},	undef,	"to_unicode\(\'舌\.\\u07230\>\\u0338ß\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0723}0>\x{0338}SS", %p)},	undef,	"to_unicode\(\'舌\.\\u07230\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0723}0≯SS", %p)},	undef,	"to_unicode\(\'舌\.\\u07230≯SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0723}0≯ss", %p)},	undef,	"to_unicode\(\'舌\.\\u07230≯ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0723}0>\x{0338}ss", %p)},	undef,	"to_unicode\(\'舌\.\\u07230\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0723}0>\x{0338}Ss", %p)},	undef,	"to_unicode\(\'舌\.\\u07230\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌.\x{0723}0≯Ss", %p)},	undef,	"to_unicode\(\'舌\.\\u07230≯Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2642\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0723}0>\x{0338}SS", %p)},	undef,	"to_unicode\(\'⾆．\\u07230\>\\u0338SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2643\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0723}0≯SS", %p)},	undef,	"to_unicode\(\'⾆．\\u07230≯SS\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2644\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0723}0≯ss", %p)},	undef,	"to_unicode\(\'⾆．\\u07230≯ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2645\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0723}0>\x{0338}ss", %p)},	undef,	"to_unicode\(\'⾆．\\u07230\>\\u0338ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2646\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0723}0>\x{0338}Ss", %p)},	undef,	"to_unicode\(\'⾆．\\u07230\>\\u0338Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2647\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⾆．\x{0723}0≯Ss", %p)},	undef,	"to_unicode\(\'⾆．\\u07230≯Ss\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2648\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{11134}8\x{200D}．\x{EE437}ᢊ", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD348\\u200D．\\uDB79\\uDC37ᢊ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2649\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{11134}8\x{200D}．\x{EE437}ᢊ", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD348\\u200D．\\uDB79\\uDC37ᢊ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2650\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{11134}8\x{200D}.\x{EE437}ᢊ", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD348\\u200D\.\\uDB79\\uDC37ᢊ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2651\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{11134}8\x{200D}.\x{EE437}ᢊ", %p)},	undef,	"to_unicode\(\'\\uD804\\uDD348\\u200D\.\\uDB79\\uDC37ᢊ\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2652\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{923C8}\x{10A06}≮\x{82828}．\x{B20AB}4˹\x{06B5}", %p)},	undef,	"to_unicode\(\'\\uDA08\\uDFC8\\uD802\\uDE06≮\\uD9CA\\uDC28．\\uDA88\\uDCAB4˹\\u06B5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2653\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{923C8}\x{10A06}<\x{0338}\x{82828}．\x{B20AB}4˹\x{06B5}", %p)},	undef,	"to_unicode\(\'\\uDA08\\uDFC8\\uD802\\uDE06\<\\u0338\\uD9CA\\uDC28．\\uDA88\\uDCAB4˹\\u06B5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2654\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{923C8}\x{10A06}≮\x{82828}.\x{B20AB}4˹\x{06B5}", %p)},	undef,	"to_unicode\(\'\\uDA08\\uDFC8\\uD802\\uDE06≮\\uD9CA\\uDC28\.\\uDA88\\uDCAB4˹\\u06B5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2655\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{923C8}\x{10A06}<\x{0338}\x{82828}.\x{B20AB}4˹\x{06B5}", %p)},	undef,	"to_unicode\(\'\\uDA08\\uDFC8\\uD802\\uDE06\<\\u0338\\uD9CA\\uDC28\.\\uDA88\\uDCAB4˹\\u06B5\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2656\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0842}.ς", %p)},	"\x{0842}.ς",	"to_unicode\(\'\\u0842\.ς\'\)\ \[data\/IdnaTest\.txt\:2657\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0842}.ς", %p)},	"\x{0842}.ς",	"to_unicode\(\'\\u0842\.ς\'\)\ \[data\/IdnaTest\.txt\:2658\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0842}.Σ", %p)},	"\x{0842}.σ",	"to_unicode\(\'\\u0842\.Σ\'\)\ \[data\/IdnaTest\.txt\:2659\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0842}.σ", %p)},	"\x{0842}.σ",	"to_unicode\(\'\\u0842\.σ\'\)\ \[data\/IdnaTest\.txt\:2660\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--0vb.xn--4xa", %p)},	"\x{0842}.σ",	"to_unicode\(\'xn\-\-0vb\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2661\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--0vb.xn--3xa", %p)},	"\x{0842}.ς",	"to_unicode\(\'xn\-\-0vb\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2662\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ。ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2665\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200CႺ。ς\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2666\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ。ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2667\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴚ。ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ。ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2668\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ。Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2669\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ。Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ。Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴚ。σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ。σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴚ。σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ。σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ilj.xn--4xa", %p)},	"ⴚ.σ",	"to_unicode\(\'xn\-\-ilj\.xn\-\-4xa\'\)\ \[data\/IdnaTest\.txt\:2673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴚ.σ", %p)},	"ⴚ.σ",	"to_unicode\(\'ⴚ\.σ\'\)\ \[data\/IdnaTest\.txt\:2674\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴚ.Σ", %p)},	undef,	"to_unicode\(\'Ⴚ\.Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2675\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴚ.ς", %p)},	"ⴚ.ς",	"to_unicode\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2676\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴚ.ς", %p)},	"ⴚ.ς",	"to_unicode\(\'ⴚ\.ς\'\)\ \[data\/IdnaTest\.txt\:2677\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴚ.ς", %p)},	undef,	"to_unicode\(\'Ⴚ\.ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2678\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ilj.xn--3xa", %p)},	"ⴚ.ς",	"to_unicode\(\'xn\-\-ilj\.xn\-\-3xa\'\)\ \[data\/IdnaTest\.txt\:2679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴚ.σ", %p)},	undef,	"to_unicode\(\'Ⴚ\.σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴚ｡ς", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡ς\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴚ｡Σ", %p)},	undef,	"to_unicode\(\'\\u200CႺ｡Σ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴚ｡σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴚ｡σ", %p)},	undef,	"to_unicode\(\'\\u200Cⴚ｡σ\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E3}．\x{0663}", %p)},	undef,	"to_unicode\(\'\\u07E3．\\u0663\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{07E3}.\x{0663}", %p)},	undef,	"to_unicode\(\'\\u07E3\.\\u0663\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2688\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{0981}\x{111C0}ꡏ", %p)},	undef,	"to_unicode\(\'\\u200D⾕。\\u200C\\u0981\\uD804\\uDDC0ꡏ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2689\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}⾕。\x{200C}\x{0981}\x{111C0}ꡏ", %p)},	undef,	"to_unicode\(\'\\u200D⾕。\\u200C\\u0981\\uD804\\uDDC0ꡏ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2690\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}谷。\x{200C}\x{0981}\x{111C0}ꡏ", %p)},	undef,	"to_unicode\(\'\\u200D谷。\\u200C\\u0981\\uD804\\uDDC0ꡏ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2691\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}谷。\x{200C}\x{0981}\x{111C0}ꡏ", %p)},	undef,	"to_unicode\(\'\\u200D谷。\\u200C\\u0981\\uD804\\uDDC0ꡏ\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2692\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᠴ-뉔．\x{0726}\x{200C}", %p)},	undef,	"to_unicode\(\'ᠴ\-뉔．\\u0726\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:2693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔．\x{0726}\x{200C}", %p)},	undef,	"to_unicode\(\'ᠴ\-뉔．\\u0726\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:2694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔．\x{0726}\x{200C}", %p)},	undef,	"to_unicode\(\'ᠴ\-뉔．\\u0726\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:2695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔．\x{0726}\x{200C}", %p)},	undef,	"to_unicode\(\'ᠴ\-뉔．\\u0726\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:2696\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔.\x{0726}\x{200C}", %p)},	undef,	"to_unicode\(\'ᠴ\-뉔\.\\u0726\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:2697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔.\x{0726}\x{200C}", %p)},	undef,	"to_unicode\(\'ᠴ\-뉔\.\\u0726\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:2698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔.\x{0726}\x{200C}", %p)},	undef,	"to_unicode\(\'ᠴ\-뉔\.\\u0726\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:2699\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔.\x{0726}\x{200C}", %p)},	undef,	"to_unicode\(\'ᠴ\-뉔\.\\u0726\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:2700\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn----05j1765f.xn--wnb", %p)},	"ᠴ-뉔.\x{0726}",	"to_unicode\(\'xn\-\-\-\-05j1765f\.xn\-\-wnb\'\)\ \[data\/IdnaTest\.txt\:2701\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔.\x{0726}", %p)},	"ᠴ-뉔.\x{0726}",	"to_unicode\(\'ᠴ\-뉔\.\\u0726\'\)\ \[data\/IdnaTest\.txt\:2702\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠴ-뉔.\x{0726}", %p)},	"ᠴ-뉔.\x{0726}",	"to_unicode\(\'ᠴ\-뉔\.\\u0726\'\)\ \[data\/IdnaTest\.txt\:2703\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0E47}𝟴ᦛς.\x{1714}\x{067D}\x{0C3E}\x{1A68}", %p)},	undef,	"to_unicode\(\'\\uDAC3\\uDE47𝟴ᦛς\.\\u1714\\u067D\\u0C3E\\u1A68\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2704\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0E47}8ᦛς.\x{1714}\x{067D}\x{0C3E}\x{1A68}", %p)},	undef,	"to_unicode\(\'\\uDAC3\\uDE478ᦛς\.\\u1714\\u067D\\u0C3E\\u1A68\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2705\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0E47}8ᦛΣ.\x{1714}\x{067D}\x{0C3E}\x{1A68}", %p)},	undef,	"to_unicode\(\'\\uDAC3\\uDE478ᦛΣ\.\\u1714\\u067D\\u0C3E\\u1A68\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2706\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0E47}8ᦛσ.\x{1714}\x{067D}\x{0C3E}\x{1A68}", %p)},	undef,	"to_unicode\(\'\\uDAC3\\uDE478ᦛσ\.\\u1714\\u067D\\u0C3E\\u1A68\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2707\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0E47}𝟴ᦛΣ.\x{1714}\x{067D}\x{0C3E}\x{1A68}", %p)},	undef,	"to_unicode\(\'\\uDAC3\\uDE47𝟴ᦛΣ\.\\u1714\\u067D\\u0C3E\\u1A68\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2708\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C0E47}𝟴ᦛσ.\x{1714}\x{067D}\x{0C3E}\x{1A68}", %p)},	undef,	"to_unicode\(\'\\uDAC3\\uDE47𝟴ᦛσ\.\\u1714\\u067D\\u0C3E\\u1A68\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:2709\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("淽。\x{08A6}", %p)},	"淽.\x{08A6}",	"to_unicode\(\'淽。\\u08A6\'\)\ \[data\/IdnaTest\.txt\:2710\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--34w.xn--vyb", %p)},	"淽.\x{08A6}",	"to_unicode\(\'xn\-\-34w\.xn\-\-vyb\'\)\ \[data\/IdnaTest\.txt\:2711\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("淽.\x{08A6}", %p)},	"淽.\x{08A6}",	"to_unicode\(\'淽\.\\u08A6\'\)\ \[data\/IdnaTest\.txt\:2712\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E66}\x{E01B7}。-", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE66\\uDB40\\uDDB7。\-\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2713\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D46C7}Ⴓ\x{E06F0}｡\x{059A}", %p)},	undef,	"to_unicode\(\'\\uDB11\\uDEC7Ⴓ\\uDB41\\uDEF0｡\\u059A\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2714\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D46C7}Ⴓ\x{E06F0}。\x{059A}", %p)},	undef,	"to_unicode\(\'\\uDB11\\uDEC7Ⴓ\\uDB41\\uDEF0。\\u059A\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2715\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D46C7}ⴓ\x{E06F0}。\x{059A}", %p)},	undef,	"to_unicode\(\'\\uDB11\\uDEC7ⴓ\\uDB41\\uDEF0。\\u059A\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2716\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D46C7}ⴓ\x{E06F0}｡\x{059A}", %p)},	undef,	"to_unicode\(\'\\uDB11\\uDEC7ⴓ\\uDB41\\uDEF0｡\\u059A\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2717\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ｡ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2718\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ｡ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ｡ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ。ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2720\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ。ßႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ。ßႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2721\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}ⴇ。ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641ⴇ。ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2722\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}ⴇ。ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641ⴇ。ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2723\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ。SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2724\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ。SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ。SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2725\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}ⴇ。ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641ⴇ。ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2726\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}ⴇ。ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641ⴇ。ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2727\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ。Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2728\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ。Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ。Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2729\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}ⴇ｡ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641ⴇ｡ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2730\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}ⴇ｡ßⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641ⴇ｡ßⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2731\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ｡SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2732\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ｡SSႣ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ｡SSႣ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}ⴇ｡ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641ⴇ｡ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}ⴇ｡ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641ⴇ｡ssⴃ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:2735\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ｡Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2736\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{10E72}\x{0641}Ⴇ｡Ssⴃ", %p)},	undef,	"to_unicode\(\'\\u200C\\uD803\\uDE72\\u0641Ⴇ｡Ssⴃ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:2737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1024D0}｡\x{FDF1}", %p)},	undef,	"to_unicode\(\'\\uDBC9\\uDCD0｡\\uFDF1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1024D0}。\x{0642}\x{0644}\x{06D2}", %p)},	undef,	"to_unicode\(\'\\uDBC9\\uDCD0。\\u0642\\u0644\\u06D2\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A66}\x{200D}｡\x{1039}\x{20D8}", %p)},	undef,	"to_unicode\(\'\\u1A66\\u200D｡\\u1039\\u20D8\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A66}\x{200D}｡\x{1039}\x{20D8}", %p)},	undef,	"to_unicode\(\'\\u1A66\\u200D｡\\u1039\\u20D8\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A66}\x{200D}｡\x{20D8}\x{1039}", %p)},	undef,	"to_unicode\(\'\\u1A66\\u200D｡\\u20D8\\u1039\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A66}\x{200D}｡\x{20D8}\x{1039}", %p)},	undef,	"to_unicode\(\'\\u1A66\\u200D｡\\u20D8\\u1039\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A66}\x{200D}。\x{20D8}\x{1039}", %p)},	undef,	"to_unicode\(\'\\u1A66\\u200D。\\u20D8\\u1039\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1A66}\x{200D}。\x{20D8}\x{1039}", %p)},	undef,	"to_unicode\(\'\\u1A66\\u200D。\\u20D8\\u1039\'\)\ throws\ error\ V5\ C2\ \[data\/IdnaTest\.txt\:2745\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-≠\x{0850}．\x{071B}\x{0751}≮\x{B1709}", %p)},	undef,	"to_unicode\(\'\-≠\\u0850．\\u071B\\u0751≮\\uDA85\\uDF09\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2746\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-=\x{0338}\x{0850}．\x{071B}\x{0751}<\x{0338}\x{B1709}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u0850．\\u071B\\u0751\<\\u0338\\uDA85\\uDF09\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2747\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-≠\x{0850}.\x{071B}\x{0751}≮\x{B1709}", %p)},	undef,	"to_unicode\(\'\-≠\\u0850\.\\u071B\\u0751≮\\uDA85\\uDF09\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2748\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-=\x{0338}\x{0850}.\x{071B}\x{0751}<\x{0338}\x{B1709}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u0850\.\\u071B\\u0751\<\\u0338\\uDA85\\uDF09\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:2749\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䷘≯\x{08C5}\x{084E}．\x{ED7CD}≮\x{A9C0}\x{06BA}", %p)},	undef,	"to_unicode\(\'䷘≯\\u08C5\\u084E．\\uDB75\\uDFCD≮\\uA9C0\\u06BA\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2750\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䷘>\x{0338}\x{08C5}\x{084E}．\x{ED7CD}<\x{0338}\x{A9C0}\x{06BA}", %p)},	undef,	"to_unicode\(\'䷘\>\\u0338\\u08C5\\u084E．\\uDB75\\uDFCD\<\\u0338\\uA9C0\\u06BA\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2751\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䷘≯\x{08C5}\x{084E}.\x{ED7CD}≮\x{A9C0}\x{06BA}", %p)},	undef,	"to_unicode\(\'䷘≯\\u08C5\\u084E\.\\uDB75\\uDFCD≮\\uA9C0\\u06BA\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2752\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䷘>\x{0338}\x{08C5}\x{084E}.\x{ED7CD}<\x{0338}\x{A9C0}\x{06BA}", %p)},	undef,	"to_unicode\(\'䷘\>\\u0338\\u08C5\\u084E\.\\uDB75\\uDFCD\<\\u0338\\uA9C0\\u06BA\'\)\ throws\ error\ P1\ V6\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:2753\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≠\x{86CAC}.\x{10E63}\x{0A4D}-\x{1ED77}", %p)},	undef,	"to_unicode\(\'≠\\uD9DB\\uDCAC\.\\uD803\\uDE63\\u0A4D\-\\uD83B\\uDD77\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2754\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("=\x{0338}\x{86CAC}.\x{10E63}\x{0A4D}-\x{1ED77}", %p)},	undef,	"to_unicode\(\'\=\\u0338\\uD9DB\\uDCAC\.\\uD803\\uDE63\\u0A4D\-\\uD83B\\uDD77\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2755\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06E4}\x{0A81}≠｡\x{10E73}𝟝", %p)},	undef,	"to_unicode\(\'\\u06E4\\u0A81≠｡\\uD803\\uDE73𝟝\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2756\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06E4}\x{0A81}=\x{0338}｡\x{10E73}𝟝", %p)},	undef,	"to_unicode\(\'\\u06E4\\u0A81\=\\u0338｡\\uD803\\uDE73𝟝\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2757\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06E4}\x{0A81}≠。\x{10E73}5", %p)},	undef,	"to_unicode\(\'\\u06E4\\u0A81≠。\\uD803\\uDE735\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2758\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06E4}\x{0A81}=\x{0338}。\x{10E73}5", %p)},	undef,	"to_unicode\(\'\\u06E4\\u0A81\=\\u0338。\\uD803\\uDE735\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2759\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{AF6B7}\x{550BA}｡\x{1A62}🃕ß", %p)},	undef,	"to_unicode\(\'ß\\uDA7D\\uDEB7\\uD914\\uDCBA｡\\u1A62🃕ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2760\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{AF6B7}\x{550BA}。\x{1A62}🃕ß", %p)},	undef,	"to_unicode\(\'ß\\uDA7D\\uDEB7\\uD914\\uDCBA。\\u1A62🃕ß\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2761\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{AF6B7}\x{550BA}。\x{1A62}🃕SS", %p)},	undef,	"to_unicode\(\'SS\\uDA7D\\uDEB7\\uD914\\uDCBA。\\u1A62🃕SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2762\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{AF6B7}\x{550BA}。\x{1A62}🃕ss", %p)},	undef,	"to_unicode\(\'ss\\uDA7D\\uDEB7\\uD914\\uDCBA。\\u1A62🃕ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2763\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{AF6B7}\x{550BA}。\x{1A62}🃕Ss", %p)},	undef,	"to_unicode\(\'Ss\\uDA7D\\uDEB7\\uD914\\uDCBA。\\u1A62🃕Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2764\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{AF6B7}\x{550BA}｡\x{1A62}🃕SS", %p)},	undef,	"to_unicode\(\'SS\\uDA7D\\uDEB7\\uD914\\uDCBA｡\\u1A62🃕SS\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2765\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{AF6B7}\x{550BA}｡\x{1A62}🃕ss", %p)},	undef,	"to_unicode\(\'ss\\uDA7D\\uDEB7\\uD914\\uDCBA｡\\u1A62🃕ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2766\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{AF6B7}\x{550BA}｡\x{1A62}🃕Ss", %p)},	undef,	"to_unicode\(\'Ss\\uDA7D\\uDEB7\\uD914\\uDCBA｡\\u1A62🃕Ss\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2767\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D。\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2768\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。\x{200C}", %p)},	undef,	"to_unicode\(\'\\u200D。\\u200C\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:2769\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E49}\x{FDA9}\x{200D}.\x{E01D1}\x{1EF9C}\x{9B50A}", %p)},	undef,	"to_unicode\(\'\\u0E49\\uFDA9\\u200D\.\\uDB40\\uDDD1\\uD83B\\uDF9C\\uDA2D\\uDD0A\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:2770\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E49}\x{FDA9}\x{200D}.\x{E01D1}\x{1EF9C}\x{9B50A}", %p)},	undef,	"to_unicode\(\'\\u0E49\\uFDA9\\u200D\.\\uDB40\\uDDD1\\uD83B\\uDF9C\\uDA2D\\uDD0A\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:2771\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E49}\x{0635}\x{062D}\x{064A}\x{200D}.\x{E01D1}\x{1EF9C}\x{9B50A}", %p)},	undef,	"to_unicode\(\'\\u0E49\\u0635\\u062D\\u064A\\u200D\.\\uDB40\\uDDD1\\uD83B\\uDF9C\\uDA2D\\uDD0A\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:2772\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E49}\x{0635}\x{062D}\x{064A}\x{200D}.\x{E01D1}\x{1EF9C}\x{9B50A}", %p)},	undef,	"to_unicode\(\'\\u0E49\\u0635\\u062D\\u064A\\u200D\.\\uDB40\\uDDD1\\uD83B\\uDF9C\\uDA2D\\uDD0A\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:2773\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1EE26}\x{200C}临。ᢜ\x{6FE12}ⶏ\x{10E72}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD83B\\uDE26\\u200C临。ᢜ\\uD97F\\uDE12ⶏ\\uD803\\uDE72\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2774\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1EE26}\x{200C}临。ᢜ\x{6FE12}ⶏ\x{10E72}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD83B\\uDE26\\u200C临。ᢜ\\uD97F\\uDE12ⶏ\\uD803\\uDE72\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2775\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DFA}．\x{0739}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDFA．\\u0739\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2776\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0DFA}.\x{0739}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDDFA\.\\u0739\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2777\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{068A}\x{0ACD}．\x{AAF6}", %p)},	undef,	"to_unicode\(\'\\u068A\\u0ACD．\\uAAF6\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2778\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{068A}\x{0ACD}.\x{AAF6}", %p)},	undef,	"to_unicode\(\'\\u068A\\u0ACD\.\\uAAF6\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:2779\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0A75}\x{AF3A7}멹。𝟑\x{E0ED8}", %p)},	undef,	"to_unicode\(\'\\u0A75\\uDA7C\\uDFA7멹。𝟑\\uDB43\\uDED8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2780\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0A75}\x{AF3A7}멹。𝟑\x{E0ED8}", %p)},	undef,	"to_unicode\(\'\\u0A75\\uDA7C\\uDFA7멹。𝟑\\uDB43\\uDED8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2781\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0A75}\x{AF3A7}멹。3\x{E0ED8}", %p)},	undef,	"to_unicode\(\'\\u0A75\\uDA7C\\uDFA7멹。3\\uDB43\\uDED8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2782\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0A75}\x{AF3A7}멹。3\x{E0ED8}", %p)},	undef,	"to_unicode\(\'\\u0A75\\uDA7C\\uDFA7멹。3\\uDB43\\uDED8\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:2783\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴅ\x{56FF5}릖\x{E03F8}.\x{0626}\x{10E6E}₄", %p)},	undef,	"to_unicode\(\'Ⴅ\\uD91B\\uDFF5릖\\uDB40\\uDFF8\.\\u0626\\uD803\\uDE6E₄\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2784\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴅ\x{56FF5}릖\x{E03F8}.\x{064A}\x{0654}\x{10E6E}₄", %p)},	undef,	"to_unicode\(\'Ⴅ\\uD91B\\uDFF5릖\\uDB40\\uDFF8\.\\u064A\\u0654\\uD803\\uDE6E₄\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2785\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴅ\x{56FF5}릖\x{E03F8}.\x{0626}\x{10E6E}4", %p)},	undef,	"to_unicode\(\'Ⴅ\\uD91B\\uDFF5릖\\uDB40\\uDFF8\.\\u0626\\uD803\\uDE6E4\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2786\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴅ\x{56FF5}릖\x{E03F8}.\x{064A}\x{0654}\x{10E6E}4", %p)},	undef,	"to_unicode\(\'Ⴅ\\uD91B\\uDFF5릖\\uDB40\\uDFF8\.\\u064A\\u0654\\uD803\\uDE6E4\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2787\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴅ\x{56FF5}릖\x{E03F8}.\x{064A}\x{0654}\x{10E6E}4", %p)},	undef,	"to_unicode\(\'ⴅ\\uD91B\\uDFF5릖\\uDB40\\uDFF8\.\\u064A\\u0654\\uD803\\uDE6E4\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2788\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴅ\x{56FF5}릖\x{E03F8}.\x{0626}\x{10E6E}4", %p)},	undef,	"to_unicode\(\'ⴅ\\uD91B\\uDFF5릖\\uDB40\\uDFF8\.\\u0626\\uD803\\uDE6E4\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2789\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴅ\x{56FF5}릖\x{E03F8}.\x{064A}\x{0654}\x{10E6E}₄", %p)},	undef,	"to_unicode\(\'ⴅ\\uD91B\\uDFF5릖\\uDB40\\uDFF8\.\\u064A\\u0654\\uD803\\uDE6E₄\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2790\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴅ\x{56FF5}릖\x{E03F8}.\x{0626}\x{10E6E}₄", %p)},	undef,	"to_unicode\(\'ⴅ\\uD91B\\uDFF5릖\\uDB40\\uDFF8\.\\u0626\\uD803\\uDE6E₄\'\)\ throws\ error\ P1\ V6\ B4\ \[data\/IdnaTest\.txt\:2791\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}｡︒", %p)},	undef,	"to_unicode\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2792\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}｡︒", %p)},	undef,	"to_unicode\(\'\\u200C｡︒\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2793\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。。", %p)},	undef,	"to_unicode\(\'\\u200C。。\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2794\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}。。", %p)},	undef,	"to_unicode\(\'\\u200C。。\'\)\ throws\ error\ C1\ A4_2\ \[data\/IdnaTest\.txt\:2795\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯ꡙ．⒍", %p)},	undef,	"to_unicode\(\'≯ꡙ．⒍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2796\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}ꡙ．⒍", %p)},	undef,	"to_unicode\(\'\>\\u0338ꡙ．⒍\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2797\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≯ꡙ.6.", %p)},	undef,	"to_unicode\(\'≯ꡙ\.6\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2798\]") or ($@ and diag($@));
is(eval{uts46_to_unicode(">\x{0338}ꡙ.6.", %p)},	undef,	"to_unicode\(\'\>\\u0338ꡙ\.6\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2799\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-８.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-８\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2800\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-８.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-８\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2801\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-8.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-8\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2802\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-8.ß-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-8\.ß\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2803\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-8.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-8\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2804\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-8.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-8\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2805\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-8.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-8\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2806\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-8.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-8\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2807\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-8.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-8\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2808\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-8.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-8\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2809\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-８.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-８\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2810\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-８.SS-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-８\.SS\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2811\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-８.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-８\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2812\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-８.ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-８\.ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2813\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-８.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-８\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2814\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{062B}-８.Ss-\x{200C}-", %p)},	undef,	"to_unicode\(\'\\u062B\-８\.Ss\-\\u200C\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:2815\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EDBA}𝟥\x{06FC}\x{5AC7C}｡Ӏ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDBA𝟥\\u06FC\\uD92B\\uDC7C｡Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2816\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EDBA}3\x{06FC}\x{5AC7C}。Ӏ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDBA3\\u06FC\\uD92B\\uDC7C。Ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2817\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EDBA}3\x{06FC}\x{5AC7C}。ӏ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDBA3\\u06FC\\uD92B\\uDC7C。ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2818\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EDBA}𝟥\x{06FC}\x{5AC7C}｡ӏ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDDBA𝟥\\u06FC\\uD92B\\uDC7C｡ӏ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:2819\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.\x{10E79}\x{1EC95}\x{A6F1}⸟", %p)},	undef,	"to_unicode\(\'\-\.\\uD803\\uDE79\\uD83B\\uDC95\\uA6F1⸟\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:2820\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10B492}ᡰ。\x{1CF4}₺", %p)},	undef,	"to_unicode\(\'\\uDBED\\uDC92ᡰ。\\u1CF4₺\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:2821\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≠ႷᡔႫ｡\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'≠ႷᡔႫ｡\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2822\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ႷᡔႫ｡\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ႷᡔႫ｡\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2823\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ႷᡔႫ。\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'≠ႷᡔႫ。\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2824\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ႷᡔႫ。\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ႷᡔႫ。\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2825\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ⴗᡔⴋ。\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ⴗᡔⴋ。\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2826\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ⴗᡔⴋ。\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'≠ⴗᡔⴋ。\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠Ⴗᡔⴋ。\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'≠Ⴗᡔⴋ。\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2828\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}Ⴗᡔⴋ。\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338Ⴗᡔⴋ。\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2829\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}ⴗᡔⴋ｡\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338ⴗᡔⴋ｡\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2830\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠ⴗᡔⴋ｡\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'≠ⴗᡔⴋ｡\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2831\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≠Ⴗᡔⴋ｡\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'≠Ⴗᡔⴋ｡\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2832\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("=\x{0338}Ⴗᡔⴋ｡\x{D907}\x{1D18A}\x{0776}觴", %p)},	undef,	"to_unicode\(\'\=\\u0338Ⴗᡔⴋ｡\\uD907\\uD834\\uDD8A\\u0776觴\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:2833\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0600}.\x{10FA3}", %p)},	undef,	"to_unicode\(\'\\u0600\.\\uD803\\uDFA3\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2834\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0CCD}🄈｡\x{200D}\x{6962F}\x{066B}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u0CCD🄈｡\\u200D\\uD965\\uDE2F\\u066B\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2835\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0CCD}🄈｡\x{200D}\x{6962F}\x{066B}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u0CCD🄈｡\\u200D\\uD965\\uDE2F\\u066B\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2836\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0CCD}7,。\x{200D}\x{6962F}\x{066B}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u0CCD7\,。\\u200D\\uD965\\uDE2F\\u066B\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2837\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0CCD}7,。\x{200D}\x{6962F}\x{066B}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\u0CCD7\,。\\u200D\\uD965\\uDE2F\\u066B\\u0E3A\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2838\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E8122}4\x{410B1}.≯\x{10E74}\x{135E}\x{E0E0C}", %p)},	undef,	"to_unicode\(\'\\uDB60\\uDD224\\uD8C4\\uDCB1\.≯\\uD803\\uDE74\\u135E\\uDB43\\uDE0C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2839\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E8122}4\x{410B1}.>\x{0338}\x{10E74}\x{135E}\x{E0E0C}", %p)},	undef,	"to_unicode\(\'\\uDB60\\uDD224\\uD8C4\\uDCB1\.\>\\u0338\\uD803\\uDE74\\u135E\\uDB43\\uDE0C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2840\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{57237}🄉。𝟕\x{1A5A}⒉\x{79447}", %p)},	undef,	"to_unicode\(\'\\uD91C\\uDE37🄉。𝟕\\u1A5A⒉\\uD9A5\\uDC47\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2841\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{57237}8,。7\x{1A5A}2.\x{79447}", %p)},	undef,	"to_unicode\(\'\\uD91C\\uDE378\,。7\\u1A5A2\.\\uD9A5\\uDC47\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2842\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}⒈⒈。≯🄆\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D⒈⒈。≯🄆\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2843\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}⒈⒈。≯🄆\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D⒈⒈。≯🄆\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2844\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}⒈⒈。>\x{0338}🄆\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D⒈⒈。\>\\u0338🄆\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2845\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}⒈⒈。>\x{0338}🄆\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D⒈⒈。\>\\u0338🄆\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2846\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}1.1.。≯5,\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D1\.1\.。≯5\,\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2847\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}1.1.。≯5,\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D1\.1\.。≯5\,\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2848\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}1.1.。>\x{0338}5,\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D1\.1\.。\>\\u03385\,\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2849\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}1.1.。>\x{0338}5,\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200D1\.1\.。\>\\u03385\,\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ A4_2\ \[data\/IdnaTest\.txt\:2850\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0755}\x{06CF}\x{A927}．\x{8C2E1}ᡚ≠\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0755\\u06CF\\uA927．\\uD9F0\\uDEE1ᡚ≠\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2851\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0755}\x{06CF}\x{A927}．\x{8C2E1}ᡚ≠\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0755\\u06CF\\uA927．\\uD9F0\\uDEE1ᡚ≠\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2852\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0755}\x{06CF}\x{A927}．\x{8C2E1}ᡚ=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0755\\u06CF\\uA927．\\uD9F0\\uDEE1ᡚ\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2853\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0755}\x{06CF}\x{A927}．\x{8C2E1}ᡚ=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0755\\u06CF\\uA927．\\uD9F0\\uDEE1ᡚ\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2854\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0755}\x{06CF}\x{A927}.\x{8C2E1}ᡚ≠\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0755\\u06CF\\uA927\.\\uD9F0\\uDEE1ᡚ≠\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2855\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0755}\x{06CF}\x{A927}.\x{8C2E1}ᡚ≠\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0755\\u06CF\\uA927\.\\uD9F0\\uDEE1ᡚ≠\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2856\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0755}\x{06CF}\x{A927}.\x{8C2E1}ᡚ=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0755\\u06CF\\uA927\.\\uD9F0\\uDEE1ᡚ\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2857\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0755}\x{06CF}\x{A927}.\x{8C2E1}ᡚ=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u0755\\u06CF\\uA927\.\\uD9F0\\uDEE1ᡚ\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2858\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF1}｡\x{BBE4D}\x{066B}", %p)},	undef,	"to_unicode\(\'\\u1BF1｡\\uDAAF\\uDE4D\\u066B\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2859\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF1}。\x{BBE4D}\x{066B}", %p)},	undef,	"to_unicode\(\'\\u1BF1。\\uDAAF\\uDE4D\\u066B\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2860\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("３\x{10E78}。\x{E0123}", %p)},	undef,	"to_unicode\(\'３\\uD803\\uDE78。\\uDB40\\uDD23\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2861\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("3\x{10E78}。\x{E0123}", %p)},	undef,	"to_unicode\(\'3\\uD803\\uDE78。\\uDB40\\uDD23\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:2862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠬ\x{10E77}\x{10E73}.ꡟ긷", %p)},	undef,	"to_unicode\(\'ᠬ\\uD803\\uDE77\\uD803\\uDE73\.ꡟ긷\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᠬ\x{10E77}\x{10E73}.ꡟ긷", %p)},	undef,	"to_unicode\(\'ᠬ\\uD803\\uDE77\\uD803\\uDE73\.ꡟ긷\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:2864\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︒Ↄ\x{1732}\x{95B0F}．Ⴗ\x{1E890}", %p)},	undef,	"to_unicode\(\'︒Ↄ\\u1732\\uDA16\\uDF0F．Ⴗ\\uD83A\\uDC90\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2865\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("。Ↄ\x{1732}\x{95B0F}.Ⴗ\x{1E890}", %p)},	undef,	"to_unicode\(\'。Ↄ\\u1732\\uDA16\\uDF0F\.Ⴗ\\uD83A\\uDC90\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2866\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("。ↄ\x{1732}\x{95B0F}.ⴗ\x{1E890}", %p)},	undef,	"to_unicode\(\'。ↄ\\u1732\\uDA16\\uDF0F\.ⴗ\\uD83A\\uDC90\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2867\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("︒ↄ\x{1732}\x{95B0F}．ⴗ\x{1E890}", %p)},	undef,	"to_unicode\(\'︒ↄ\\u1732\\uDA16\\uDF0F．ⴗ\\uD83A\\uDC90\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:2868\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E6F}.\x{0948}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6F\.\\u0948\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2869\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς≯｡\x{10E65}", %p)},	undef,	"to_unicode\(\'ς≯｡\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2870\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς>\x{0338}｡\x{10E65}", %p)},	undef,	"to_unicode\(\'ς\>\\u0338｡\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2871\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς≯。\x{10E65}", %p)},	undef,	"to_unicode\(\'ς≯。\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2872\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς>\x{0338}。\x{10E65}", %p)},	undef,	"to_unicode\(\'ς\>\\u0338。\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2873\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ>\x{0338}。\x{10E65}", %p)},	undef,	"to_unicode\(\'Σ\>\\u0338。\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2874\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ≯。\x{10E65}", %p)},	undef,	"to_unicode\(\'Σ≯。\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2875\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ≯。\x{10E65}", %p)},	undef,	"to_unicode\(\'σ≯。\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ>\x{0338}。\x{10E65}", %p)},	undef,	"to_unicode\(\'σ\>\\u0338。\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ>\x{0338}｡\x{10E65}", %p)},	undef,	"to_unicode\(\'Σ\>\\u0338｡\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ≯｡\x{10E65}", %p)},	undef,	"to_unicode\(\'Σ≯｡\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2879\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ≯｡\x{10E65}", %p)},	undef,	"to_unicode\(\'σ≯｡\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2880\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ>\x{0338}｡\x{10E65}", %p)},	undef,	"to_unicode\(\'σ\>\\u0338｡\\uD803\\uDE65\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2881\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A9C0}\x{200D}ꡀ。\x{10E78}", %p)},	undef,	"to_unicode\(\'\\uA9C0\\u200Dꡀ。\\uD803\\uDE78\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2882\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9B886}\x{0A42}Ⴊ\x{5EF94}.≮", %p)},	undef,	"to_unicode\(\'\\uDA2E\\uDC86\\u0A42Ⴊ\\uD93B\\uDF94\.≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2883\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9B886}\x{0A42}Ⴊ\x{5EF94}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDA2E\\uDC86\\u0A42Ⴊ\\uD93B\\uDF94\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2884\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9B886}\x{0A42}ⴊ\x{5EF94}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDA2E\\uDC86\\u0A42ⴊ\\uD93B\\uDF94\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2885\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9B886}\x{0A42}ⴊ\x{5EF94}.≮", %p)},	undef,	"to_unicode\(\'\\uDA2E\\uDC86\\u0A42ⴊ\\uD93B\\uDF94\.≮\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2886\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0843}．𝟻", %p)},	"\x{0843}.5",	"to_unicode\(\'\\u0843．𝟻\'\)\ \[data\/IdnaTest\.txt\:2887\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0843}.5", %p)},	"\x{0843}.5",	"to_unicode\(\'\\u0843\.5\'\)\ \[data\/IdnaTest\.txt\:2888\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--1vb.5", %p)},	"\x{0843}.5",	"to_unicode\(\'xn\-\-1vb\.5\'\)\ \[data\/IdnaTest\.txt\:2889\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0603}\x{2DD9A}｡\x{06CE}𝟢", %p)},	undef,	"to_unicode\(\'\\u0603\\uD877\\uDD9A｡\\u06CE𝟢\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2890\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0603}\x{2DD9A}。\x{06CE}0", %p)},	undef,	"to_unicode\(\'\\u0603\\uD877\\uDD9A。\\u06CE0\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:2891\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{111C0}\x{FCEC}\x{1B6D}｡\x{200D}\x{0F84}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDDC0\\uFCEC\\u1B6D｡\\u200D\\u0F84\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:2892\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{111C0}\x{FCEC}\x{1B6D}｡\x{200D}\x{0F84}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDDC0\\uFCEC\\u1B6D｡\\u200D\\u0F84\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:2893\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{111C0}\x{0643}\x{0645}\x{1B6D}。\x{200D}\x{0F84}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDDC0\\u0643\\u0645\\u1B6D。\\u200D\\u0F84\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:2894\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{111C0}\x{0643}\x{0645}\x{1B6D}。\x{200D}\x{0F84}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDDC0\\u0643\\u0645\\u1B6D。\\u200D\\u0F84\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:2895\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE0F}\x{200C}\x{8C6E1}𝟏｡\x{200C}\x{A950}\x{0351}", %p)},	undef,	"to_unicode\(\'\\uFE0F\\u200C\\uD9F1\\uDEE1𝟏｡\\u200C\\uA950\\u0351\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2896\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE0F}\x{200C}\x{8C6E1}𝟏｡\x{200C}\x{A950}\x{0351}", %p)},	undef,	"to_unicode\(\'\\uFE0F\\u200C\\uD9F1\\uDEE1𝟏｡\\u200C\\uA950\\u0351\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2897\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE0F}\x{200C}\x{8C6E1}1。\x{200C}\x{A950}\x{0351}", %p)},	undef,	"to_unicode\(\'\\uFE0F\\u200C\\uD9F1\\uDEE11。\\u200C\\uA950\\u0351\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2898\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FE0F}\x{200C}\x{8C6E1}1。\x{200C}\x{A950}\x{0351}", %p)},	undef,	"to_unicode\(\'\\uFE0F\\u200C\\uD9F1\\uDEE11。\\u200C\\uA950\\u0351\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2899\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("兎｡\x{071B}\x{E0D1C}\x{1734}\x{0F84}", %p)},	undef,	"to_unicode\(\'兎｡\\u071B\\uDB43\\uDD1C\\u1734\\u0F84\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2900\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("兎。\x{071B}\x{E0D1C}\x{1734}\x{0F84}", %p)},	undef,	"to_unicode\(\'兎。\\u071B\\uDB43\\uDD1C\\u1734\\u0F84\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:2901\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒙｡\x{200D}5\x{200D}⒕", %p)},	undef,	"to_unicode\(\'⒙｡\\u200D5\\u200D⒕\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2902\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒙｡\x{200D}5\x{200D}⒕", %p)},	undef,	"to_unicode\(\'⒙｡\\u200D5\\u200D⒕\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:2903\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("18.。\x{200D}5\x{200D}14.", %p)},	undef,	"to_unicode\(\'18\.。\\u200D5\\u200D14\.\'\)\ throws\ error\ A4_2\ C2\ \[data\/IdnaTest\.txt\:2904\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("18.。\x{200D}5\x{200D}14.", %p)},	undef,	"to_unicode\(\'18\.。\\u200D5\\u200D14\.\'\)\ throws\ error\ A4_2\ C2\ \[data\/IdnaTest\.txt\:2905\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0849}-｡\x{E09FA}⒔", %p)},	undef,	"to_unicode\(\'\\u0849\-｡\\uDB42\\uDDFA⒔\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:2906\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0849}-。\x{E09FA}13.", %p)},	undef,	"to_unicode\(\'\\u0849\-。\\uDB42\\uDDFA13\.\'\)\ throws\ error\ P1\ V3\ V6\ B3\ \[data\/IdnaTest\.txt\:2907\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2DED}\x{7CF6C}\x{FC08}．\x{10E60}۸", %p)},	undef,	"to_unicode\(\'\\u2DED\\uD9B3\\uDF6C\\uFC08．\\uD803\\uDE60۸\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2908\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2DED}\x{7CF6C}\x{0628}\x{0645}.\x{10E60}۸", %p)},	undef,	"to_unicode\(\'\\u2DED\\uD9B3\\uDF6C\\u0628\\u0645\.\\uD803\\uDE60۸\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:2909\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴜ𤮹\x{1CE8}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ𤮹\\u1CE8⾇。Ⴏ♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2910\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ𤮹\x{1CE8}⾇。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ𤮹\\u1CE8⾇。Ⴏ♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2911\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ𤮹\x{1CE8}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ𤮹\\u1CE8舛。Ⴏ♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2912\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ𤮹\x{1CE8}舛。Ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'Ⴜ𤮹\\u1CE8舛。Ⴏ♀\\u200C\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:2913\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ𤮹\x{1CE8}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ𤮹\\u1CE8舛。ⴏ♀\\u200C\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2914\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ𤮹\x{1CE8}舛。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ𤮹\\u1CE8舛。ⴏ♀\\u200C\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--16f130edj8dsszv.xn--e5h11w", %p)},	"ⴜ𤮹\x{1CE8}舛.ⴏ♀",	"to_unicode\(\'xn\-\-16f130edj8dsszv\.xn\-\-e5h11w\'\)\ \[data\/IdnaTest\.txt\:2916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ𤮹\x{1CE8}舛.ⴏ♀", %p)},	"ⴜ𤮹\x{1CE8}舛.ⴏ♀",	"to_unicode\(\'ⴜ𤮹\\u1CE8舛\.ⴏ♀\'\)\ \[data\/IdnaTest\.txt\:2917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴜ𤮹\x{1CE8}舛.Ⴏ♀", %p)},	undef,	"to_unicode\(\'Ⴜ𤮹\\u1CE8舛\.Ⴏ♀\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ𤮹\x{1CE8}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ𤮹\\u1CE8⾇。ⴏ♀\\u200C\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴜ𤮹\x{1CE8}⾇。ⴏ♀\x{200C}\x{200C}", %p)},	undef,	"to_unicode\(\'ⴜ𤮹\\u1CE8⾇。ⴏ♀\\u200C\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:2920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0D4D}🄈.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0D4D🄈\.\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0D4D}🄈.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0D4D🄈\.\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0D4D}7,.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0D4D7\,\.\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2923\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0D4D}7,.\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0D4D7\,\.\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2924\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}Ⴞ癀｡\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2AႾ癀｡\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2925\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}Ⴞ癀｡\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2AႾ癀｡\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2926\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}Ⴞ癀｡\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2AႾ癀｡\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2927\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}Ⴞ癀｡\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2AႾ癀｡\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2928\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}Ⴞ癀。\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2AႾ癀。\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2929\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}Ⴞ癀。\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2AႾ癀。\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2930\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}Ⴞ癀。\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2AႾ癀。\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2931\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}Ⴞ癀。\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2AႾ癀。\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2932\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}ⴞ癀。\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2Aⴞ癀。\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2933\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}ⴞ癀。\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2Aⴞ癀。\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2934\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}ⴞ癀。\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2Aⴞ癀。\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2935\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}ⴞ癀。\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2Aⴞ癀。\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2936\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}ⴞ癀｡\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2Aⴞ癀｡\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2937\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}ⴞ癀｡\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2Aⴞ癀｡\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2938\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}ⴞ癀｡\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2Aⴞ癀｡\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2939\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{C512A}ⴞ癀｡\x{0BCD}\x{200D}\x{200C}붼", %p)},	undef,	"to_unicode\(\'\\uDAD4\\uDD2Aⴞ癀｡\\u0BCD\\u200D\\u200C붼\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:2940\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D79A5}-\x{110B9}。\x{08A6}", %p)},	undef,	"to_unicode\(\'\\uDB1E\\uDDA5\-\\uD804\\uDCB9。\\u08A6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2941\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A4}𝟥≯\x{06BB}．氁\x{2BF95}ꁫ", %p)},	undef,	"to_unicode\(\'\\u08A4𝟥≯\\u06BB．氁\\uD86F\\uDF95ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2942\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A4}𝟥>\x{0338}\x{06BB}．氁\x{2BF95}ꁫ", %p)},	undef,	"to_unicode\(\'\\u08A4𝟥\>\\u0338\\u06BB．氁\\uD86F\\uDF95ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2943\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A4}3≯\x{06BB}.氁\x{2BF95}ꁫ", %p)},	undef,	"to_unicode\(\'\\u08A43≯\\u06BB\.氁\\uD86F\\uDF95ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2944\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A4}3>\x{0338}\x{06BB}.氁\x{2BF95}ꁫ", %p)},	undef,	"to_unicode\(\'\\u08A43\>\\u0338\\u06BB\.氁\\uD86F\\uDF95ꁫ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:2945\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0664}\x{116B0}．\x{0369}", %p)},	undef,	"to_unicode\(\'\\u0664\\uD805\\uDEB0．\\u0369\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2946\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0664}\x{116B0}.\x{0369}", %p)},	undef,	"to_unicode\(\'\\u0664\\uD805\\uDEB0\.\\u0369\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:2947\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{1112D}𝟮．₅\x{EDAD1}\x{E03AD}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDD2D𝟮．₅\\uDB76\\uDED1\\uDB40\\uDFAD\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2948\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{1112D}2.5\x{EDAD1}\x{E03AD}", %p)},	undef,	"to_unicode\(\'\-\\uD804\\uDD2D2\.5\\uDB76\\uDED1\\uDB40\\uDFAD\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2949\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2950\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2951\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2952\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2953\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2954\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2955\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2956\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}Ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200CႡ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2957\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2958\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2959\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2960\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}.≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D\.≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2961\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2962\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．\<\\u0338\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2963\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2964\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}ⴁ畝\x{200D}．≮", %p)},	undef,	"to_unicode\(\'\\u200Cⴁ畝\\u200D．≮\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:2965\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("歷｡\x{10E62}≯\x{A5AF3}\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\uD803\\uDE62≯\\uDA56\\uDEF3\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2966\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("歷｡\x{10E62}≯\x{A5AF3}\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\uD803\\uDE62≯\\uDA56\\uDEF3\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2967\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("歷｡\x{10E62}>\x{0338}\x{A5AF3}\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\uD803\\uDE62\>\\u0338\\uDA56\\uDEF3\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2968\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("歷｡\x{10E62}>\x{0338}\x{A5AF3}\x{200D}", %p)},	undef,	"to_unicode\(\'歷｡\\uD803\\uDE62\>\\u0338\\uDA56\\uDEF3\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2969\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("歷。\x{10E62}≯\x{A5AF3}\x{200D}", %p)},	undef,	"to_unicode\(\'歷。\\uD803\\uDE62≯\\uDA56\\uDEF3\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2970\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("歷。\x{10E62}≯\x{A5AF3}\x{200D}", %p)},	undef,	"to_unicode\(\'歷。\\uD803\\uDE62≯\\uDA56\\uDEF3\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2971\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("歷。\x{10E62}>\x{0338}\x{A5AF3}\x{200D}", %p)},	undef,	"to_unicode\(\'歷。\\uD803\\uDE62\>\\u0338\\uDA56\\uDEF3\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2972\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("歷。\x{10E62}>\x{0338}\x{A5AF3}\x{200D}", %p)},	undef,	"to_unicode\(\'歷。\\uD803\\uDE62\>\\u0338\\uDA56\\uDEF3\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:2973\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0962}\x{200D}．𠸔\x{E0C11}", %p)},	undef,	"to_unicode\(\'\\u0962\\u200D．𠸔\\uDB43\\uDC11\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2974\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0962}\x{200D}．𠸔\x{E0C11}", %p)},	undef,	"to_unicode\(\'\\u0962\\u200D．𠸔\\uDB43\\uDC11\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2975\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0962}\x{200D}.𠸔\x{E0C11}", %p)},	undef,	"to_unicode\(\'\\u0962\\u200D\.𠸔\\uDB43\\uDC11\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2976\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0962}\x{200D}.𠸔\x{E0C11}", %p)},	undef,	"to_unicode\(\'\\u0962\\u200D\.𠸔\\uDB43\\uDC11\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:2977\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{0756}｡\x{E9AA5}\x{FD1E}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u0756｡\\uDB66\\uDEA5\\uFD1E\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2978\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{0756}｡\x{E9AA5}\x{FD1E}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u0756｡\\uDB66\\uDEA5\\uFD1E\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2979\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{0756}。\x{E9AA5}\x{062C}\x{064A}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u0756。\\uDB66\\uDEA5\\u062C\\u064A\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2980\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{200C}\x{0756}。\x{E9AA5}\x{062C}\x{064A}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C\\u0756。\\uDB66\\uDEA5\\u062C\\u064A\'\)\ throws\ error\ P1\ V6\ B1\ C2\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:2981\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0641}≠𝟶-.ς⒓\x{10E7E}≠", %p)},	undef,	"to_unicode\(\'\\u0641≠𝟶\-\.ς⒓\\uD803\\uDE7E≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2982\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}=\x{0338}𝟶-.ς⒓\x{10E7E}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\=\\u0338𝟶\-\.ς⒓\\uD803\\uDE7E\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2983\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}≠0-.ς12.\x{10E7E}≠", %p)},	undef,	"to_unicode\(\'\\u0641≠0\-\.ς12\.\\uD803\\uDE7E≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:2984\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}=\x{0338}0-.ς12.\x{10E7E}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\=\\u03380\-\.ς12\.\\uD803\\uDE7E\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:2985\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}=\x{0338}0-.Σ12.\x{10E7E}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\=\\u03380\-\.Σ12\.\\uD803\\uDE7E\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:2986\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}≠0-.Σ12.\x{10E7E}≠", %p)},	undef,	"to_unicode\(\'\\u0641≠0\-\.Σ12\.\\uD803\\uDE7E≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:2987\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}≠0-.σ12.\x{10E7E}≠", %p)},	undef,	"to_unicode\(\'\\u0641≠0\-\.σ12\.\\uD803\\uDE7E≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:2988\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}=\x{0338}0-.σ12.\x{10E7E}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\=\\u03380\-\.σ12\.\\uD803\\uDE7E\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:2989\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}=\x{0338}𝟶-.Σ⒓\x{10E7E}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\=\\u0338𝟶\-\.Σ⒓\\uD803\\uDE7E\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2990\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}≠𝟶-.Σ⒓\x{10E7E}≠", %p)},	undef,	"to_unicode\(\'\\u0641≠𝟶\-\.Σ⒓\\uD803\\uDE7E≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2991\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}≠𝟶-.σ⒓\x{10E7E}≠", %p)},	undef,	"to_unicode\(\'\\u0641≠𝟶\-\.σ⒓\\uD803\\uDE7E≠\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2992\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0641}=\x{0338}𝟶-.σ⒓\x{10E7E}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\u0641\=\\u0338𝟶\-\.σ⒓\\uD803\\uDE7E\=\\u0338\'\)\ throws\ error\ P1\ V3\ V6\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:2993\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꊉ.-\x{0623}\x{17CD}\x{11042}", %p)},	undef,	"to_unicode\(\'ꊉ\.\-\\u0623\\u17CD\\uD804\\uDC42\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2994\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꊉ.-\x{0627}\x{0654}\x{17CD}\x{11042}", %p)},	undef,	"to_unicode\(\'ꊉ\.\-\\u0627\\u0654\\u17CD\\uD804\\uDC42\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:2995\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢚ⒈ß\x{05B0}。\x{83F0F}-", %p)},	undef,	"to_unicode\(\'ᢚ⒈ß\\u05B0。\\uD9CF\\uDF0F\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:2996\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢚ1.ß\x{05B0}。\x{83F0F}-", %p)},	undef,	"to_unicode\(\'ᢚ1\.ß\\u05B0。\\uD9CF\\uDF0F\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2997\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢚ1.SS\x{05B0}。\x{83F0F}-", %p)},	undef,	"to_unicode\(\'ᢚ1\.SS\\u05B0。\\uD9CF\\uDF0F\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2998\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢚ1.ss\x{05B0}。\x{83F0F}-", %p)},	undef,	"to_unicode\(\'ᢚ1\.ss\\u05B0。\\uD9CF\\uDF0F\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:2999\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢚ1.Ss\x{05B0}。\x{83F0F}-", %p)},	undef,	"to_unicode\(\'ᢚ1\.Ss\\u05B0。\\uD9CF\\uDF0F\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3000\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢚ⒈SS\x{05B0}。\x{83F0F}-", %p)},	undef,	"to_unicode\(\'ᢚ⒈SS\\u05B0。\\uD9CF\\uDF0F\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3001\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢚ⒈ss\x{05B0}。\x{83F0F}-", %p)},	undef,	"to_unicode\(\'ᢚ⒈ss\\u05B0。\\uD9CF\\uDF0F\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3002\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᢚ⒈Ss\x{05B0}。\x{83F0F}-", %p)},	undef,	"to_unicode\(\'ᢚ⒈Ss\\u05B0。\\uD9CF\\uDF0F\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3003\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039ςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3004\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039ςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3005\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039ςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3006\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}ςႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039ςႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3007\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039ςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3008\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039ςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3009\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039ΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3010\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039ΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3011\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3012\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3013\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039Σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3014\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}.\x{1039}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99\.\\u1039Σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3015\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039ςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3016\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}ςⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039ςⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3017\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039ΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3018\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}ΣႦ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039ΣႦ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3019\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3020\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3021\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039Σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3022\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{68D99}．\x{1039}Σⴆ\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD963\\uDD99．\\u1039Σⴆ\\u200D\'\)\ throws\ error\ P1\ V6\ V5\ C2\ \[data\/IdnaTest\.txt\:3023\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⾆\x{10E70}.\x{302A}", %p)},	undef,	"to_unicode\(\'⾆\\uD803\\uDE70\.\\u302A\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3024\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("舌\x{10E70}.\x{302A}", %p)},	undef,	"to_unicode\(\'舌\\uD803\\uDE70\.\\u302A\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3025\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🝧\x{10E6F}\x{E01BA}。⸠⒈", %p)},	undef,	"to_unicode\(\'🝧\\uD803\\uDE6F\\uDB40\\uDDBA。⸠⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3026\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🝧\x{10E6F}\x{E01BA}。⸠1.", %p)},	undef,	"to_unicode\(\'🝧\\uD803\\uDE6F\\uDB40\\uDDBA。⸠1\.\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3027\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒈\x{200C}\x{0946}︒．\x{10A3F}", %p)},	undef,	"to_unicode\(\'⒈\\u200C\\u0946︒．\\uD802\\uDE3F\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3028\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈\x{200C}\x{0946}︒．\x{10A3F}", %p)},	undef,	"to_unicode\(\'⒈\\u200C\\u0946︒．\\uD802\\uDE3F\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3029\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}\x{0946}。.\x{10A3F}", %p)},	undef,	"to_unicode\(\'1\.\\u200C\\u0946。\.\\uD802\\uDE3F\'\)\ throws\ error\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3030\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.\x{200C}\x{0946}。.\x{10A3F}", %p)},	undef,	"to_unicode\(\'1\.\\u200C\\u0946。\.\\uD802\\uDE3F\'\)\ throws\ error\ V5\ C1\ A4_2\ \[data\/IdnaTest\.txt\:3031\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BAB}。䰀\x{10E65}\x{FC7B}\x{0829}", %p)},	undef,	"to_unicode\(\'\\u1BAB。䰀\\uD803\\uDE65\\uFC7B\\u0829\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3032\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BAB}。䰀\x{10E65}\x{062B}\x{064A}\x{0829}", %p)},	undef,	"to_unicode\(\'\\u1BAB。䰀\\uD803\\uDE65\\u062B\\u064A\\u0829\'\)\ throws\ error\ V5\ B5\ B6\ \[data\/IdnaTest\.txt\:3033\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200D}.\x{1BAB}\x{C9110}", %p)},	undef,	"to_unicode\(\'ß\\u200D\.\\u1BAB\\uDAE4\\uDD10\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3034\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{200D}.\x{1BAB}\x{C9110}", %p)},	undef,	"to_unicode\(\'ß\\u200D\.\\u1BAB\\uDAE4\\uDD10\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3035\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{200D}.\x{1BAB}\x{C9110}", %p)},	undef,	"to_unicode\(\'SS\\u200D\.\\u1BAB\\uDAE4\\uDD10\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3036\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{200D}.\x{1BAB}\x{C9110}", %p)},	undef,	"to_unicode\(\'SS\\u200D\.\\u1BAB\\uDAE4\\uDD10\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3037\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{200D}.\x{1BAB}\x{C9110}", %p)},	undef,	"to_unicode\(\'ss\\u200D\.\\u1BAB\\uDAE4\\uDD10\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3038\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{200D}.\x{1BAB}\x{C9110}", %p)},	undef,	"to_unicode\(\'ss\\u200D\.\\u1BAB\\uDAE4\\uDD10\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3039\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{200D}.\x{1BAB}\x{C9110}", %p)},	undef,	"to_unicode\(\'Ss\\u200D\.\\u1BAB\\uDAE4\\uDD10\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3040\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{200D}.\x{1BAB}\x{C9110}", %p)},	undef,	"to_unicode\(\'Ss\\u200D\.\\u1BAB\\uDAE4\\uDD10\'\)\ throws\ error\ P1\ V5\ V6\ C2\ \[data\/IdnaTest\.txt\:3041\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{103A}\x{200C}≮.≮", %p)},	undef,	"to_unicode\(\'\\u103A\\u200C≮\.≮\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3042\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{103A}\x{200C}<\x{0338}.<\x{0338}", %p)},	undef,	"to_unicode\(\'\\u103A\\u200C\<\\u0338\.\<\\u0338\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3043\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("℈．\x{FFA0}", %p)},	undef,	"to_unicode\(\'℈．\\uFFA0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3044\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("℈.\x{1160}", %p)},	undef,	"to_unicode\(\'℈\.\\u1160\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3045\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0721}\x{10F06}。\x{CEF44}", %p)},	undef,	"to_unicode\(\'\\u0721\\uD803\\uDF06。\\uDAFB\\uDF44\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3046\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("爕\x{91BA2}．5気", %p)},	undef,	"to_unicode\(\'爕\\uDA06\\uDFA2．5気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3047\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("爕\x{91BA2}.5気", %p)},	undef,	"to_unicode\(\'爕\\uDA06\\uDFA2\.5気\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3048\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷\x{11134}Ⴝ-．\x{0801}\x{10A3F}\x{0DD6}", %p)},	undef,	"to_unicode\(\'۷\\uD804\\uDD34Ⴝ\-．\\u0801\\uD802\\uDE3F\\u0DD6\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3049\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷\x{11134}Ⴝ-.\x{0801}\x{10A3F}\x{0DD6}", %p)},	undef,	"to_unicode\(\'۷\\uD804\\uDD34Ⴝ\-\.\\u0801\\uD802\\uDE3F\\u0DD6\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3050\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷\x{11134}ⴝ-.\x{0801}\x{10A3F}\x{0DD6}", %p)},	undef,	"to_unicode\(\'۷\\uD804\\uDD34ⴝ\-\.\\u0801\\uD802\\uDE3F\\u0DD6\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3051\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷\x{11134}ⴝ-．\x{0801}\x{10A3F}\x{0DD6}", %p)},	undef,	"to_unicode\(\'۷\\uD804\\uDD34ⴝ\-．\\u0801\\uD802\\uDE3F\\u0DD6\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3052\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7D0D3}。\x{102DAD}\x{E27E2}--", %p)},	undef,	"to_unicode\(\'\\uD9B4\\uDCD3。\\uDBCB\\uDDAD\\uDB49\\uDFE2\-\-\'\)\ throws\ error\ P1\ V6\ V2\ V3\ \[data\/IdnaTest\.txt\:3053\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}ꡪ｡\x{200C}\x{1039}", %p)},	undef,	"to_unicode\(\'\\u200Dꡪ｡\\u200C\\u1039\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3054\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡪ｡\x{200C}\x{1039}", %p)},	undef,	"to_unicode\(\'\\u200Dꡪ｡\\u200C\\u1039\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3055\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡪ。\x{200C}\x{1039}", %p)},	undef,	"to_unicode\(\'\\u200Dꡪ。\\u200C\\u1039\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3056\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}ꡪ。\x{200C}\x{1039}", %p)},	undef,	"to_unicode\(\'\\u200Dꡪ。\\u200C\\u1039\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3057\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EA31}\x{FEF4}\x{06C9}｡ᡔ𪻗ꡠ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE31\\uFEF4\\u06C9｡ᡔ𪻗ꡠ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3058\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EA31}\x{064A}\x{06C9}。ᡔ𪻗ꡠ", %p)},	undef,	"to_unicode\(\'\\uD83A\\uDE31\\u064A\\u06C9。ᡔ𪻗ꡠ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3059\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1C2E}\x{1EEE0}\x{B47DA}\x{A806}.\x{0717}ᡌ", %p)},	undef,	"to_unicode\(\'\\u1C2E\\uD83B\\uDEE0\\uDA91\\uDFDA\\uA806\.\\u0717ᡌ\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:3060\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡ς\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡ς\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3061\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡ς\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡ς\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3062\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。ς\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。ς\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3063\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。ς\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。ς\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3064\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。Σ\x{06CE}Σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。Σ\\u06CEΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3065\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。Σ\x{06CE}Σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。Σ\\u06CEΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3066\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。σ\x{06CE}σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。σ\\u06CEσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3067\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。σ\x{06CE}σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。σ\\u06CEσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3068\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。Σ\x{06CE}σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。Σ\\u06CEσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3069\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。Σ\x{06CE}σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。Σ\\u06CEσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3070\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。Σ\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。Σ\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3071\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。Σ\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。Σ\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3072\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。σ\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。σ\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3073\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ。σ\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ。σ\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3074\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡Σ\x{06CE}Σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡Σ\\u06CEΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3075\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡Σ\x{06CE}Σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡Σ\\u06CEΣ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3076\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡σ\x{06CE}σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡σ\\u06CEσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3077\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡σ\x{06CE}σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡σ\\u06CEσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3078\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡Σ\x{06CE}σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡Σ\\u06CEσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3079\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡Σ\x{06CE}σ", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡Σ\\u06CEσ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3080\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡Σ\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡Σ\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3081\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡Σ\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡Σ\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3082\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡σ\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡σ\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3083\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{82E2B}킃\x{E0104}ᡖ｡σ\x{06CE}ς", %p)},	undef,	"to_unicode\(\'\\uD9CB\\uDE2B킃\\uDB40\\uDD04ᡖ｡σ\\u06CEς\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3084\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("蔰。\x{059F}\x{036E}-\x{11133}", %p)},	undef,	"to_unicode\(\'蔰。\\u059F\\u036E\-\\uD804\\uDD33\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3085\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ςჅ。\x{08A5}", %p)},	undef,	"to_unicode\(\'ςჅ。\\u08A5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3086\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ςⴥ。\x{08A5}", %p)},	"ςⴥ.\x{08A5}",	"to_unicode\(\'ςⴥ。\\u08A5\'\)\ \[data\/IdnaTest\.txt\:3087\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ςⴥ。\x{08A5}", %p)},	"ςⴥ.\x{08A5}",	"to_unicode\(\'ςⴥ。\\u08A5\'\)\ \[data\/IdnaTest\.txt\:3088\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ΣჅ。\x{08A5}", %p)},	undef,	"to_unicode\(\'ΣჅ。\\u08A5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3089\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σⴥ。\x{08A5}", %p)},	"σⴥ.\x{08A5}",	"to_unicode\(\'σⴥ。\\u08A5\'\)\ \[data\/IdnaTest\.txt\:3090\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σⴥ。\x{08A5}", %p)},	"σⴥ.\x{08A5}",	"to_unicode\(\'Σⴥ。\\u08A5\'\)\ \[data\/IdnaTest\.txt\:3091\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--4xa203s.xn--uyb", %p)},	"σⴥ.\x{08A5}",	"to_unicode\(\'xn\-\-4xa203s\.xn\-\-uyb\'\)\ \[data\/IdnaTest\.txt\:3092\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σⴥ.\x{08A5}", %p)},	"σⴥ.\x{08A5}",	"to_unicode\(\'σⴥ\.\\u08A5\'\)\ \[data\/IdnaTest\.txt\:3093\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ΣჅ.\x{08A5}", %p)},	undef,	"to_unicode\(\'ΣჅ\.\\u08A5\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3094\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σⴥ.\x{08A5}", %p)},	"σⴥ.\x{08A5}",	"to_unicode\(\'Σⴥ\.\\u08A5\'\)\ \[data\/IdnaTest\.txt\:3095\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--3xa403s.xn--uyb", %p)},	"ςⴥ.\x{08A5}",	"to_unicode\(\'xn\-\-3xa403s\.xn\-\-uyb\'\)\ \[data\/IdnaTest\.txt\:3096\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ςⴥ.\x{08A5}", %p)},	"ςⴥ.\x{08A5}",	"to_unicode\(\'ςⴥ\.\\u08A5\'\)\ \[data\/IdnaTest\.txt\:3097\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ςⴥ.\x{08A5}", %p)},	"ςⴥ.\x{08A5}",	"to_unicode\(\'ςⴥ\.\\u08A5\'\)\ \[data\/IdnaTest\.txt\:3098\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}Ⴉ\x{FB22}．\x{08E9}", %p)},	undef,	"to_unicode\(\'\\u0BCDႩ\\uFB22．\\u08E9\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3099\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}Ⴉ\x{05D3}.\x{08E9}", %p)},	undef,	"to_unicode\(\'\\u0BCDႩ\\u05D3\.\\u08E9\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3100\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}ⴉ\x{05D3}.\x{08E9}", %p)},	undef,	"to_unicode\(\'\\u0BCDⴉ\\u05D3\.\\u08E9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3101\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0BCD}ⴉ\x{FB22}．\x{08E9}", %p)},	undef,	"to_unicode\(\'\\u0BCDⴉ\\uFB22．\\u08E9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3102\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0F21}≮\x{4CBE5}\x{085A}。\x{10CDF}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDF21≮\\uD8F2\\uDFE5\\u085A。\\uD803\\uDCDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3103\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0F21}<\x{0338}\x{4CBE5}\x{085A}。\x{10CDF}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDF21\<\\u0338\\uD8F2\\uDFE5\\u085A。\\uD803\\uDCDF\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3104\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06C5}｡\x{200D}ẏ\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5｡\\u200Dẏ\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3105\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}｡\x{200D}ẏ\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5｡\\u200Dẏ\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3106\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}｡\x{200D}y\x{0307}\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5｡\\u200Dy\\u0307\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3107\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}｡\x{200D}y\x{0307}\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5｡\\u200Dy\\u0307\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3108\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}。\x{200D}ẏ\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5。\\u200Dẏ\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3109\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}。\x{200D}ẏ\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5。\\u200Dẏ\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3110\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}。\x{200D}y\x{0307}\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5。\\u200Dy\\u0307\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3111\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}。\x{200D}y\x{0307}\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5。\\u200Dy\\u0307\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3112\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}。\x{200D}Y\x{0307}\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5。\\u200DY\\u0307\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3113\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}。\x{200D}Y\x{0307}\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5。\\u200DY\\u0307\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3114\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}。\x{200D}Ẏ\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5。\\u200DẎ\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3115\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}。\x{200D}Ẏ\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5。\\u200DẎ\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3116\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}｡\x{200D}Y\x{0307}\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5｡\\u200DY\\u0307\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3117\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}｡\x{200D}Y\x{0307}\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5｡\\u200DY\\u0307\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3118\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}｡\x{200D}Ẏ\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5｡\\u200DẎ\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3119\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06C5}｡\x{200D}Ẏ\x{200C}\x{0633}", %p)},	undef,	"to_unicode\(\'\\u06C5｡\\u200DẎ\\u200C\\u0633\'\)\ throws\ error\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:3120\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E67}\x{0353}。\x{92CF6}\x{0F84}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE67\\u0353。\\uDA0B\\uDCF6\\u0F84\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3121\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-≠\x{1BAA}｡嵕\x{1097F}𝟷\x{2D7F}", %p)},	undef,	"to_unicode\(\'\-≠\\u1BAA｡嵕\\uD802\\uDD7F𝟷\\u2D7F\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3122\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-=\x{0338}\x{1BAA}｡嵕\x{1097F}𝟷\x{2D7F}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u1BAA｡嵕\\uD802\\uDD7F𝟷\\u2D7F\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3123\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-≠\x{1BAA}。嵕\x{1097F}1\x{2D7F}", %p)},	undef,	"to_unicode\(\'\-≠\\u1BAA。嵕\\uD802\\uDD7F1\\u2D7F\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3124\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-=\x{0338}\x{1BAA}。嵕\x{1097F}1\x{2D7F}", %p)},	undef,	"to_unicode\(\'\-\=\\u0338\\u1BAA。嵕\\uD802\\uDD7F1\\u2D7F\'\)\ throws\ error\ P1\ V3\ V6\ B5\ \[data\/IdnaTest\.txt\:3125\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{16736}\x{10E7D}\x{06AD}．\x{0693}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD819\\uDF36\\uD803\\uDE7D\\u06AD．\\u0693\\u200D≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3126\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{16736}\x{10E7D}\x{06AD}．\x{0693}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD819\\uDF36\\uD803\\uDE7D\\u06AD．\\u0693\\u200D≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3127\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{16736}\x{10E7D}\x{06AD}．\x{0693}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD819\\uDF36\\uD803\\uDE7D\\u06AD．\\u0693\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3128\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{16736}\x{10E7D}\x{06AD}．\x{0693}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD819\\uDF36\\uD803\\uDE7D\\u06AD．\\u0693\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3129\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{16736}\x{10E7D}\x{06AD}.\x{0693}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD819\\uDF36\\uD803\\uDE7D\\u06AD\.\\u0693\\u200D≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3130\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{16736}\x{10E7D}\x{06AD}.\x{0693}\x{200D}≯\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD819\\uDF36\\uD803\\uDE7D\\u06AD\.\\u0693\\u200D≯\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3131\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{16736}\x{10E7D}\x{06AD}.\x{0693}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD819\\uDF36\\uD803\\uDE7D\\u06AD\.\\u0693\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3132\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{16736}\x{10E7D}\x{06AD}.\x{0693}\x{200D}>\x{0338}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u200C\\uD819\\uDF36\\uD803\\uDE7D\\u06AD\.\\u0693\\u200D\>\\u0338\\u200D\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B3\ C2\ \[data\/IdnaTest\.txt\:3133\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮．\x{17B5}ᢨ\x{07E8}", %p)},	undef,	"to_unicode\(\'≮．\\u17B5ᢨ\\u07E8\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3134\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}．\x{17B5}ᢨ\x{07E8}", %p)},	undef,	"to_unicode\(\'\<\\u0338．\\u17B5ᢨ\\u07E8\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3135\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮.\x{17B5}ᢨ\x{07E8}", %p)},	undef,	"to_unicode\(\'≮\.\\u17B5ᢨ\\u07E8\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3136\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}.\x{17B5}ᢨ\x{07E8}", %p)},	undef,	"to_unicode\(\'\<\\u0338\.\\u17B5ᢨ\\u07E8\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3137\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}｡ႩႵ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3138\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}｡ႩႵ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D｡ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3139\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}。ႩႵ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D。ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3140\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}。ႩႵ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D。ႩႵ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3141\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}。ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D。ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3142\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}。ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D。ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3143\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}。Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3144\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}。Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D。Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3145\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}｡ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D｡ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3146\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}｡ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D｡ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3147\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3148\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EC59}\x{200D}｡Ⴉⴕ", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDC59\\u200D｡Ⴉⴕ\'\)\ throws\ error\ P1\ V6\ B3\ C2\ \[data\/IdnaTest\.txt\:3149\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ．\x{1DD9}\x{4484F}\x{A92A}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ．\\u1DD9\\uD8D2\\uDC4F\\uA92A\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3150\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ．\x{1DD9}\x{4484F}\x{A92A}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ．\\u1DD9\\uD8D2\\uDC4F\\uA92A\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3151\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ.\x{1DD9}\x{4484F}\x{A92A}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ\.\\u1DD9\\uD8D2\\uDC4F\\uA92A\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3152\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{200C}ㄤ.\x{1DD9}\x{4484F}\x{A92A}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200Cㄤ\.\\u1DD9\\uD8D2\\uDC4F\\uA92A\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3153\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒓｡-\x{200C}ᠶႷ", %p)},	undef,	"to_unicode\(\'⒓｡\-\\u200CᠶႷ\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:3154\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒓｡-\x{200C}ᠶႷ", %p)},	undef,	"to_unicode\(\'⒓｡\-\\u200CᠶႷ\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:3155\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("12.。-\x{200C}ᠶႷ", %p)},	undef,	"to_unicode\(\'12\.。\-\\u200CᠶႷ\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ C1\ \[data\/IdnaTest\.txt\:3156\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("12.。-\x{200C}ᠶႷ", %p)},	undef,	"to_unicode\(\'12\.。\-\\u200CᠶႷ\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ C1\ \[data\/IdnaTest\.txt\:3157\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("12.。-\x{200C}ᠶⴗ", %p)},	undef,	"to_unicode\(\'12\.。\-\\u200Cᠶⴗ\'\)\ throws\ error\ V3\ A4_2\ C1\ \[data\/IdnaTest\.txt\:3158\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("12.。-\x{200C}ᠶⴗ", %p)},	undef,	"to_unicode\(\'12\.。\-\\u200Cᠶⴗ\'\)\ throws\ error\ V3\ A4_2\ C1\ \[data\/IdnaTest\.txt\:3159\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒓｡-\x{200C}ᠶⴗ", %p)},	undef,	"to_unicode\(\'⒓｡\-\\u200Cᠶⴗ\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:3160\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒓｡-\x{200C}ᠶⴗ", %p)},	undef,	"to_unicode\(\'⒓｡\-\\u200Cᠶⴗ\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:3161\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐚\x{1E87B}．≠\x{200C}", %p)},	undef,	"to_unicode\(\'🐚\\uD83A\\uDC7B．≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3162\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐚\x{1E87B}．≠\x{200C}", %p)},	undef,	"to_unicode\(\'🐚\\uD83A\\uDC7B．≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3163\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐚\x{1E87B}．=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'🐚\\uD83A\\uDC7B．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3164\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐚\x{1E87B}．=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'🐚\\uD83A\\uDC7B．\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3165\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐚\x{1E87B}.≠\x{200C}", %p)},	undef,	"to_unicode\(\'🐚\\uD83A\\uDC7B\.≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3166\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐚\x{1E87B}.≠\x{200C}", %p)},	undef,	"to_unicode\(\'🐚\\uD83A\\uDC7B\.≠\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3167\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐚\x{1E87B}.=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'🐚\\uD83A\\uDC7B\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3168\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐚\x{1E87B}.=\x{0338}\x{200C}", %p)},	undef,	"to_unicode\(\'🐚\\uD83A\\uDC7B\.\=\\u0338\\u200C\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3169\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A672}\x{0F74}｡\x{1EF16}\x{0B4D}\x{FE25}", %p)},	undef,	"to_unicode\(\'\\uA672\\u0F74｡\\uD83B\\uDF16\\u0B4D\\uFE25\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3170\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A672}\x{0F74}。\x{1EF16}\x{0B4D}\x{FE25}", %p)},	undef,	"to_unicode\(\'\\uA672\\u0F74。\\uD83B\\uDF16\\u0B4D\\uFE25\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3171\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴔ\x{07F2}۰\x{05C5}．⒕\x{1037}\x{08FD}", %p)},	undef,	"to_unicode\(\'Ⴔ\\u07F2۰\\u05C5．⒕\\u1037\\u08FD\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3172\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴔ\x{07F2}۰\x{05C5}.14.\x{1037}\x{08FD}", %p)},	undef,	"to_unicode\(\'Ⴔ\\u07F2۰\\u05C5\.14\.\\u1037\\u08FD\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3173\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴔ\x{07F2}۰\x{05C5}.14.\x{1037}\x{08FD}", %p)},	undef,	"to_unicode\(\'ⴔ\\u07F2۰\\u05C5\.14\.\\u1037\\u08FD\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3174\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴔ\x{07F2}۰\x{05C5}．⒕\x{1037}\x{08FD}", %p)},	undef,	"to_unicode\(\'ⴔ\\u07F2۰\\u05C5．⒕\\u1037\\u08FD\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3175\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}⒈\x{FDAE1}", %p)},	undef,	"to_unicode\(\'䏈\\u200C。\\u200C⒈\\uDBB6\\uDEE1\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3176\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}⒈\x{FDAE1}", %p)},	undef,	"to_unicode\(\'䏈\\u200C。\\u200C⒈\\uDBB6\\uDEE1\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3177\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}1.\x{FDAE1}", %p)},	undef,	"to_unicode\(\'䏈\\u200C。\\u200C1\.\\uDBB6\\uDEE1\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3178\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("䏈\x{200C}。\x{200C}1.\x{FDAE1}", %p)},	undef,	"to_unicode\(\'䏈\\u200C。\\u200C1\.\\uDBB6\\uDEE1\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3179\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟑\x{0F7E}ß\x{1CDB}｡\x{E0A8F}", %p)},	undef,	"to_unicode\(\'𝟑\\u0F7Eß\\u1CDB｡\\uDB42\\uDE8F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3180\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{0F7E}ß\x{1CDB}。\x{E0A8F}", %p)},	undef,	"to_unicode\(\'3\\u0F7Eß\\u1CDB。\\uDB42\\uDE8F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3181\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{0F7E}SS\x{1CDB}。\x{E0A8F}", %p)},	undef,	"to_unicode\(\'3\\u0F7ESS\\u1CDB。\\uDB42\\uDE8F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3182\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{0F7E}ss\x{1CDB}。\x{E0A8F}", %p)},	undef,	"to_unicode\(\'3\\u0F7Ess\\u1CDB。\\uDB42\\uDE8F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3183\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3\x{0F7E}Ss\x{1CDB}。\x{E0A8F}", %p)},	undef,	"to_unicode\(\'3\\u0F7ESs\\u1CDB。\\uDB42\\uDE8F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3184\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟑\x{0F7E}SS\x{1CDB}｡\x{E0A8F}", %p)},	undef,	"to_unicode\(\'𝟑\\u0F7ESS\\u1CDB｡\\uDB42\\uDE8F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3185\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟑\x{0F7E}ss\x{1CDB}｡\x{E0A8F}", %p)},	undef,	"to_unicode\(\'𝟑\\u0F7Ess\\u1CDB｡\\uDB42\\uDE8F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3186\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟑\x{0F7E}Ss\x{1CDB}｡\x{E0A8F}", %p)},	undef,	"to_unicode\(\'𝟑\\u0F7ESs\\u1CDB｡\\uDB42\\uDE8F\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3187\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{4B0FF}\x{10EBF}\x{17D2}｡ᡌ⒈", %p)},	undef,	"to_unicode\(\'\\u200D\\uD8EC\\uDCFF\\uD803\\uDEBF\\u17D2｡ᡌ⒈\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3188\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{4B0FF}\x{10EBF}\x{17D2}｡ᡌ⒈", %p)},	undef,	"to_unicode\(\'\\u200D\\uD8EC\\uDCFF\\uD803\\uDEBF\\u17D2｡ᡌ⒈\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3189\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{4B0FF}\x{10EBF}\x{17D2}。ᡌ1.", %p)},	undef,	"to_unicode\(\'\\u200D\\uD8EC\\uDCFF\\uD803\\uDEBF\\u17D2。ᡌ1\.\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3190\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{4B0FF}\x{10EBF}\x{17D2}。ᡌ1.", %p)},	undef,	"to_unicode\(\'\\u200D\\uD8EC\\uDCFF\\uD803\\uDEBF\\u17D2。ᡌ1\.\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3191\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0135}．\x{10D6D}\x{9700D}\x{1065D4}\x{08A6}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD35．\\uD803\\uDD6D\\uDA1C\\uDC0D\\uDBD9\\uDDD4\\u08A6\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:3192\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0135}.\x{10D6D}\x{9700D}\x{1065D4}\x{08A6}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD35\.\\uD803\\uDD6D\\uDA1C\\uDC0D\\uDBD9\\uDDD4\\u08A6\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:3193\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0642}\x{108B0}⒈．\x{20C4}🄅\x{2C433}\x{075B}", %p)},	undef,	"to_unicode\(\'\\u0642\\uD802\\uDCB0⒈．\\u20C4🄅\\uD871\\uDC33\\u075B\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3194\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0642}\x{108B0}1..\x{20C4}4,\x{2C433}\x{075B}", %p)},	undef,	"to_unicode\(\'\\u0642\\uD802\\uDCB01\.\.\\u20C44\,\\uD871\\uDC33\\u075B\'\)\ throws\ error\ P1\ V6\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3195\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0ECB}\x{07E9}\x{0944}\x{08A3}。-≀\x{9B07D}", %p)},	undef,	"to_unicode\(\'\\u0ECB\\u07E9\\u0944\\u08A3。\-≀\\uDA2C\\uDC7D\'\)\ throws\ error\ P1\ V5\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3196\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.\x{111C0}剘ßᢔ", %p)},	undef,	"to_unicode\(\'\-\.\\uD804\\uDDC0剘ßᢔ\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3197\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.\x{111C0}剘SSᢔ", %p)},	undef,	"to_unicode\(\'\-\.\\uD804\\uDDC0剘SSᢔ\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3198\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.\x{111C0}剘ssᢔ", %p)},	undef,	"to_unicode\(\'\-\.\\uD804\\uDDC0剘ssᢔ\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3199\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.\x{111C0}剘Ssᢔ", %p)},	undef,	"to_unicode\(\'\-\.\\uD804\\uDDC0剘Ssᢔ\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3200\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🕟\x{10FC0}｡-", %p)},	undef,	"to_unicode\(\'🕟\\uD803\\uDFC0｡\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3201\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🕟\x{10FC0}。-", %p)},	undef,	"to_unicode\(\'🕟\\uD803\\uDFC0。\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:3202\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{E070C}\x{10E69}｡≠\x{0664}\x{10E6C}", %p)},	undef,	"to_unicode\(\'⒈\\uDB41\\uDF0C\\uD803\\uDE69｡≠\\u0664\\uD803\\uDE6C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3203\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈\x{E070C}\x{10E69}｡=\x{0338}\x{0664}\x{10E6C}", %p)},	undef,	"to_unicode\(\'⒈\\uDB41\\uDF0C\\uD803\\uDE69｡\=\\u0338\\u0664\\uD803\\uDE6C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3204\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{E070C}\x{10E69}。≠\x{0664}\x{10E6C}", %p)},	undef,	"to_unicode\(\'1\.\\uDB41\\uDF0C\\uD803\\uDE69。≠\\u0664\\uD803\\uDE6C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3205\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.\x{E070C}\x{10E69}。=\x{0338}\x{0664}\x{10E6C}", %p)},	undef,	"to_unicode\(\'1\.\\uDB41\\uDF0C\\uD803\\uDE69。\=\\u0338\\u0664\\uD803\\uDE6C\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3206\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0661}㇡Ⴎ\x{200C}.㖾\x{0666}", %p)},	undef,	"to_unicode\(\'\\u0661㇡Ⴎ\\u200C\.㖾\\u0666\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3207\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0661}㇡Ⴎ\x{200C}.㖾\x{0666}", %p)},	undef,	"to_unicode\(\'\\u0661㇡Ⴎ\\u200C\.㖾\\u0666\'\)\ throws\ error\ P1\ V6\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3208\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0661}㇡ⴎ\x{200C}.㖾\x{0666}", %p)},	undef,	"to_unicode\(\'\\u0661㇡ⴎ\\u200C\.㖾\\u0666\'\)\ throws\ error\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3209\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0661}㇡ⴎ\x{200C}.㖾\x{0666}", %p)},	undef,	"to_unicode\(\'\\u0661㇡ⴎ\\u200C\.㖾\\u0666\'\)\ throws\ error\ B1\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3210\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5A22C}．\x{07C7}\x{06B8}ႳႧ", %p)},	undef,	"to_unicode\(\'\\uD928\\uDE2C．\\u07C7\\u06B8ႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3211\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5A22C}.\x{07C7}\x{06B8}ႳႧ", %p)},	undef,	"to_unicode\(\'\\uD928\\uDE2C\.\\u07C7\\u06B8ႳႧ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3212\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5A22C}.\x{07C7}\x{06B8}ⴓⴇ", %p)},	undef,	"to_unicode\(\'\\uD928\\uDE2C\.\\u07C7\\u06B8ⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3213\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5A22C}.\x{07C7}\x{06B8}Ⴓⴇ", %p)},	undef,	"to_unicode\(\'\\uD928\\uDE2C\.\\u07C7\\u06B8Ⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3214\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5A22C}．\x{07C7}\x{06B8}ⴓⴇ", %p)},	undef,	"to_unicode\(\'\\uD928\\uDE2C．\\u07C7\\u06B8ⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3215\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5A22C}．\x{07C7}\x{06B8}Ⴓⴇ", %p)},	undef,	"to_unicode\(\'\\uD928\\uDE2C．\\u07C7\\u06B8Ⴓⴇ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3216\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{A2EE5}.\x{1092E}\x{1EAE9}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDA4B\\uDEE5\.\\uD802\\uDD2E\\uD83A\\uDEE9\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3217\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200D}\x{A2EE5}.\x{1092E}\x{1EAE9}", %p)},	undef,	"to_unicode\(\'\\u200D\\uDA4B\\uDEE5\.\\uD802\\uDD2E\\uD83A\\uDEE9\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3218\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{62467}⒒\x{E0C07}．ꡎ⒈", %p)},	undef,	"to_unicode\(\'\\uD949\\uDC67⒒\\uDB43\\uDC07．ꡎ⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3219\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{62467}11.\x{E0C07}.ꡎ1.", %p)},	undef,	"to_unicode\(\'\\uD949\\uDC6711\.\\uDB43\\uDC07\.ꡎ1\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3220\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06D0}𝟝\x{1CE92}-｡\x{4459A}\x{1039}\x{FC39}\x{AAF6}", %p)},	undef,	"to_unicode\(\'\\u06D0𝟝\\uD833\\uDE92\-｡\\uD8D1\\uDD9A\\u1039\\uFC39\\uAAF6\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3221\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06D0}5\x{1CE92}-。\x{4459A}\x{1039}\x{0643}\x{062D}\x{AAF6}", %p)},	undef,	"to_unicode\(\'\\u06D05\\uD833\\uDE92\-。\\uD8D1\\uDD9A\\u1039\\u0643\\u062D\\uAAF6\'\)\ throws\ error\ P1\ V3\ V6\ B2\ B3\ B5\ B6\ \[data\/IdnaTest\.txt\:3222\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("Ⴕ。⒖≮ß\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。⒖≮ß\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3223\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。⒖<\x{0338}ß\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。⒖\<\\u0338ß\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3224\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。15.≮ß\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。15\.≮ß\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3225\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。15.<\x{0338}ß\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。15\.\<\\u0338ß\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3226\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。15.<\x{0338}ß\x{E01E1}", %p)},	undef,	"to_unicode\(\'ⴕ。15\.\<\\u0338ß\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3227\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。15.≮ß\x{E01E1}", %p)},	undef,	"to_unicode\(\'ⴕ。15\.≮ß\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3228\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。15.≮SS\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。15\.≮SS\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3229\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。15.<\x{0338}SS\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。15\.\<\\u0338SS\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3230\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。15.<\x{0338}ss\x{E01E1}", %p)},	undef,	"to_unicode\(\'ⴕ。15\.\<\\u0338ss\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3231\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。15.≮ss\x{E01E1}", %p)},	undef,	"to_unicode\(\'ⴕ。15\.≮ss\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3232\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。15.≮Ss\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。15\.≮Ss\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3233\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。15.<\x{0338}Ss\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。15\.\<\\u0338Ss\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3234\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。⒖<\x{0338}ß\x{E01E1}", %p)},	undef,	"to_unicode\(\'ⴕ。⒖\<\\u0338ß\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3235\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。⒖≮ß\x{E01E1}", %p)},	undef,	"to_unicode\(\'ⴕ。⒖≮ß\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3236\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。⒖≮SS\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。⒖≮SS\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3237\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。⒖<\x{0338}SS\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。⒖\<\\u0338SS\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3238\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。⒖<\x{0338}ss\x{E01E1}", %p)},	undef,	"to_unicode\(\'ⴕ。⒖\<\\u0338ss\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3239\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴕ。⒖≮ss\x{E01E1}", %p)},	undef,	"to_unicode\(\'ⴕ。⒖≮ss\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3240\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。⒖≮Ss\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。⒖≮Ss\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3241\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴕ。⒖<\x{0338}Ss\x{E01E1}", %p)},	undef,	"to_unicode\(\'Ⴕ。⒖\<\\u0338Ss\\uDB40\\uDDE1\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3242\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡧ-.\x{08F5}꒱\x{E01AB}", %p)},	undef,	"to_unicode\(\'ᡧ\-\.\\u08F5꒱\\uDB40\\uDDAB\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3243\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10B65}\x{200C}.≯䕵⬯", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF65\\u200C\.≯䕵⬯\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3244\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B65}\x{200C}.≯䕵⬯", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF65\\u200C\.≯䕵⬯\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3245\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B65}\x{200C}.>\x{0338}䕵⬯", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF65\\u200C\.\>\\u0338䕵⬯\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3246\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10B65}\x{200C}.>\x{0338}䕵⬯", %p)},	undef,	"to_unicode\(\'\\uD802\\uDF65\\u200C\.\>\\u0338䕵⬯\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3247\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F18}ß\x{0643}.ᡄ⁷︒", %p)},	undef,	"to_unicode\(\'\\u0F18ß\\u0643\.ᡄ⁷︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3248\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F18}ß\x{0643}.ᡄ7。", %p)},	undef,	"to_unicode\(\'\\u0F18ß\\u0643\.ᡄ7。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3249\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F18}SS\x{0643}.ᡄ7。", %p)},	undef,	"to_unicode\(\'\\u0F18SS\\u0643\.ᡄ7。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3250\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F18}ss\x{0643}.ᡄ7。", %p)},	undef,	"to_unicode\(\'\\u0F18ss\\u0643\.ᡄ7。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3251\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F18}Ss\x{0643}.ᡄ7。", %p)},	undef,	"to_unicode\(\'\\u0F18Ss\\u0643\.ᡄ7。\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3252\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F18}SS\x{0643}.ᡄ⁷︒", %p)},	undef,	"to_unicode\(\'\\u0F18SS\\u0643\.ᡄ⁷︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3253\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F18}ss\x{0643}.ᡄ⁷︒", %p)},	undef,	"to_unicode\(\'\\u0F18ss\\u0643\.ᡄ⁷︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3254\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0F18}Ss\x{0643}.ᡄ⁷︒", %p)},	undef,	"to_unicode\(\'\\u0F18Ss\\u0643\.ᡄ⁷︒\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3255\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-≮\x{E08E8}\x{E0101}.\x{E0E5F}Ⴁꡋ", %p)},	undef,	"to_unicode\(\'\-≮\\uDB42\\uDCE8\\uDB40\\uDD01\.\\uDB43\\uDE5FႡꡋ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3256\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-<\x{0338}\x{E08E8}\x{E0101}.\x{E0E5F}Ⴁꡋ", %p)},	undef,	"to_unicode\(\'\-\<\\u0338\\uDB42\\uDCE8\\uDB40\\uDD01\.\\uDB43\\uDE5FႡꡋ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3257\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-<\x{0338}\x{E08E8}\x{E0101}.\x{E0E5F}ⴁꡋ", %p)},	undef,	"to_unicode\(\'\-\<\\u0338\\uDB42\\uDCE8\\uDB40\\uDD01\.\\uDB43\\uDE5Fⴁꡋ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3258\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-≮\x{E08E8}\x{E0101}.\x{E0E5F}ⴁꡋ", %p)},	undef,	"to_unicode\(\'\-≮\\uDB42\\uDCE8\\uDB40\\uDD01\.\\uDB43\\uDE5Fⴁꡋ\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3259\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᡒ｡\x{0693}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡒ｡\\u0693\\u200D\\u200C\'\)\ throws\ error\ B3\ C2\ C1\ \[data\/IdnaTest\.txt\:3260\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡒ｡\x{0693}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡒ｡\\u0693\\u200D\\u200C\'\)\ throws\ error\ B3\ C2\ C1\ \[data\/IdnaTest\.txt\:3261\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡒ。\x{0693}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡒ。\\u0693\\u200D\\u200C\'\)\ throws\ error\ B3\ C2\ C1\ \[data\/IdnaTest\.txt\:3262\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡒ。\x{0693}\x{200D}\x{200C}", %p)},	undef,	"to_unicode\(\'ᡒ。\\u0693\\u200D\\u200C\'\)\ throws\ error\ B3\ C2\ C1\ \[data\/IdnaTest\.txt\:3263\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--i8e.xn--pjb", %p)},	"ᡒ.\x{0693}",	"to_unicode\(\'xn\-\-i8e\.xn\-\-pjb\'\)\ \[data\/IdnaTest\.txt\:3264\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡒ.\x{0693}", %p)},	"ᡒ.\x{0693}",	"to_unicode\(\'ᡒ\.\\u0693\'\)\ \[data\/IdnaTest\.txt\:3265\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B80}\x{07AE}．\x{0672}\x{06D9}\x{0660}", %p)},	undef,	"to_unicode\(\'\\u1B80\\u07AE．\\u0672\\u06D9\\u0660\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3266\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1B80}\x{07AE}.\x{0672}\x{06D9}\x{0660}", %p)},	undef,	"to_unicode\(\'\\u1B80\\u07AE\.\\u0672\\u06D9\\u0660\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3267\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⅎ\x{033D}\x{98A47}。≯⾑", %p)},	undef,	"to_unicode\(\'Ⅎ\\u033D\\uDA22\\uDE47。≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3268\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⅎ\x{033D}\x{98A47}。>\x{0338}⾑", %p)},	undef,	"to_unicode\(\'Ⅎ\\u033D\\uDA22\\uDE47。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3269\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⅎ\x{033D}\x{98A47}。≯襾", %p)},	undef,	"to_unicode\(\'Ⅎ\\u033D\\uDA22\\uDE47。≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3270\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⅎ\x{033D}\x{98A47}。>\x{0338}襾", %p)},	undef,	"to_unicode\(\'Ⅎ\\u033D\\uDA22\\uDE47。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3271\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⅎ\x{033D}\x{98A47}。>\x{0338}襾", %p)},	undef,	"to_unicode\(\'ⅎ\\u033D\\uDA22\\uDE47。\>\\u0338襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3272\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⅎ\x{033D}\x{98A47}。≯襾", %p)},	undef,	"to_unicode\(\'ⅎ\\u033D\\uDA22\\uDE47。≯襾\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3273\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⅎ\x{033D}\x{98A47}。>\x{0338}⾑", %p)},	undef,	"to_unicode\(\'ⅎ\\u033D\\uDA22\\uDE47。\>\\u0338⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3274\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⅎ\x{033D}\x{98A47}。≯⾑", %p)},	undef,	"to_unicode\(\'ⅎ\\u033D\\uDA22\\uDE47。≯⾑\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3275\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς\x{200D}\x{1A18}\x{10E7B}｡-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u1A18\\uD803\\uDE7B｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3276\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}\x{1A18}\x{10E7B}｡-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u1A18\\uD803\\uDE7B｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3277\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}\x{1A18}\x{10E7B}。-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u1A18\\uD803\\uDE7B。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3278\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς\x{200D}\x{1A18}\x{10E7B}。-", %p)},	undef,	"to_unicode\(\'ς\\u200D\\u1A18\\uD803\\uDE7B。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3279\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}\x{1A18}\x{10E7B}。-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u1A18\\uD803\\uDE7B。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3280\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}\x{1A18}\x{10E7B}。-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u1A18\\uD803\\uDE7B。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3281\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}\x{1A18}\x{10E7B}。-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u1A18\\uD803\\uDE7B。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3282\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}\x{1A18}\x{10E7B}。-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u1A18\\uD803\\uDE7B。\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3283\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}\x{1A18}\x{10E7B}｡-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u1A18\\uD803\\uDE7B｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3284\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ\x{200D}\x{1A18}\x{10E7B}｡-", %p)},	undef,	"to_unicode\(\'Σ\\u200D\\u1A18\\uD803\\uDE7B｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3285\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}\x{1A18}\x{10E7B}｡-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u1A18\\uD803\\uDE7B｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3286\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ\x{200D}\x{1A18}\x{10E7B}｡-", %p)},	undef,	"to_unicode\(\'σ\\u200D\\u1A18\\uD803\\uDE7B｡\-\'\)\ throws\ error\ V3\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3287\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ßႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3288\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ßႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3289\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ßⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3290\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ßⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ßⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3291\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.SSႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3292\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.SSႩ-", %p)},	undef,	"to_unicode\(\'\\u200C\.SSႩ\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:3293\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3294\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3295\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3296\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}.Ssⴉ-", %p)},	undef,	"to_unicode\(\'\\u200C\.Ssⴉ\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:3297\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9E584}\x{07E1}㓱。⾑", %p)},	undef,	"to_unicode\(\'\\uDA39\\uDD84\\u07E1㓱。⾑\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3298\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9E584}\x{07E1}㓱。襾", %p)},	undef,	"to_unicode\(\'\\uDA39\\uDD84\\u07E1㓱。襾\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3299\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0724}ꡗ\x{10E66}≮。≯\x{8FFFF}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0724ꡗ\\uD803\\uDE66≮。≯\\uD9FF\\uDFFF\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3300\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0724}ꡗ\x{10E66}≮。≯\x{8FFFF}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0724ꡗ\\uD803\\uDE66≮。≯\\uD9FF\\uDFFF\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3301\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0724}ꡗ\x{10E66}<\x{0338}。>\x{0338}\x{8FFFF}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0724ꡗ\\uD803\\uDE66\<\\u0338。\>\\u0338\\uD9FF\\uDFFF\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3302\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0724}ꡗ\x{10E66}<\x{0338}。>\x{0338}\x{8FFFF}\x{200D}", %p)},	undef,	"to_unicode\(\'\\u0724ꡗ\\uD803\\uDE66\<\\u0338。\>\\u0338\\uD9FF\\uDFFF\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3303\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟯｡\x{BB642}\x{0766}ᠣ⩋", %p)},	undef,	"to_unicode\(\'𝟯｡\\uDAAD\\uDE42\\u0766ᠣ⩋\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3304\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("3。\x{BB642}\x{0766}ᠣ⩋", %p)},	undef,	"to_unicode\(\'3。\\uDAAD\\uDE42\\u0766ᠣ⩋\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3305\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{1E935}。\x{0FB4}\x{0E3A}", %p)},	undef,	"to_unicode\(\'\-\\uD83A\\uDD35。\\u0FB4\\u0E3A\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3306\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{0484}⒏.\x{1B03}\x{C6173}\x{0665}\x{4F80E}", %p)},	undef,	"to_unicode\(\'\\u200C\\u0484⒏\.\\u1B03\\uDAD8\\uDD73\\u0665\\uD8FE\\uDC0E\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3307\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{0484}⒏.\x{1B03}\x{C6173}\x{0665}\x{4F80E}", %p)},	undef,	"to_unicode\(\'\\u200C\\u0484⒏\.\\u1B03\\uDAD8\\uDD73\\u0665\\uD8FE\\uDC0E\'\)\ throws\ error\ P1\ V6\ V5\ C1\ B1\ \[data\/IdnaTest\.txt\:3308\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{0484}8..\x{1B03}\x{C6173}\x{0665}\x{4F80E}", %p)},	undef,	"to_unicode\(\'\\u200C\\u04848\.\.\\u1B03\\uDAD8\\uDD73\\u0665\\uD8FE\\uDC0E\'\)\ throws\ error\ P1\ V5\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3309\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{0484}8..\x{1B03}\x{C6173}\x{0665}\x{4F80E}", %p)},	undef,	"to_unicode\(\'\\u200C\\u04848\.\.\\u1B03\\uDAD8\\uDD73\\u0665\\uD8FE\\uDC0E\'\)\ throws\ error\ P1\ V5\ V6\ C1\ A4_2\ B1\ \[data\/IdnaTest\.txt\:3310\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("齙--۴.ß", %p)},	"齙--۴.ß",	"to_unicode\(\'齙\-\-۴\.ß\'\)\ \[data\/IdnaTest\.txt\:3311\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--۴.ß", %p)},	"齙--۴.ß",	"to_unicode\(\'齙\-\-۴\.ß\'\)\ \[data\/IdnaTest\.txt\:3312\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("齙--۴.SS", %p)},	"齙--۴.ss",	"to_unicode\(\'齙\-\-۴\.SS\'\)\ \[data\/IdnaTest\.txt\:3313\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn-----xbe3617m.ss", %p)},	"齙--۴.ss",	"to_unicode\(\'xn\-\-\-\-\-xbe3617m\.ss\'\)\ \[data\/IdnaTest\.txt\:3314\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn-----xbe3617m.xn--zca", %p)},	"齙--۴.ß",	"to_unicode\(\'xn\-\-\-\-\-xbe3617m\.xn\-\-zca\'\)\ \[data\/IdnaTest\.txt\:3315\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2D7F}.\x{0665}\x{1CE5}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u2D7F\.\\u0665\\u1CE5\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3316\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{2D7F}.\x{0665}\x{1CE5}\x{200C}", %p)},	undef,	"to_unicode\(\'\\u2D7F\.\\u0665\\u1CE5\\u200C\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3317\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3C3F2}\x{A6F0}｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD8B0\\uDFF2\\uA6F0｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3318\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3C3F2}\x{A6F0}｡\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD8B0\\uDFF2\\uA6F0｡\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3319\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3C3F2}\x{A6F0}。\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD8B0\\uDFF2\\uA6F0。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3320\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3C3F2}\x{A6F0}。\x{DEDE}-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD8B0\\uDFF2\\uA6F0。\\uDEDE\-\\u200D\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3321\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{3C3F2}\x{A6F0}", %p)},	undef,	"to_unicode\(\'\\uD8B0\\uDFF2\\uA6F0\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3322\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF3}．\x{1E8AB}-\x{FE0A}悎", %p)},	undef,	"to_unicode\(\'\\u1BF3．\\uD83A\\uDCAB\-\\uFE0A悎\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3323\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BF3}.\x{1E8AB}-\x{FE0A}悎", %p)},	undef,	"to_unicode\(\'\\u1BF3\.\\uD83A\\uDCAB\-\\uFE0A悎\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3324\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5F299}\x{E076C}．\x{077F}\x{46A12}", %p)},	undef,	"to_unicode\(\'\\uD93C\\uDE99\\uDB41\\uDF6C．\\u077F\\uD8DA\\uDE12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3325\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5F299}\x{E076C}.\x{077F}\x{46A12}", %p)},	undef,	"to_unicode\(\'\\uD93C\\uDE99\\uDB41\\uDF6C\.\\u077F\\uD8DA\\uDE12\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3326\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡭ\x{1096B}ᠹ.4", %p)},	undef,	"to_unicode\(\'ᡭ\\uD802\\uDD6Bᠹ\.4\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3327\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10AE3}\x{0852}\x{084C}\x{066C}.\x{DF56}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEE3\\u0852\\u084C\\u066C\.\\uDF56\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3328\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10AE3}\x{0852}\x{084C}\x{066C}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDEE3\\u0852\\u084C\\u066C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3329\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ↄ。\x{1A60}\x{11180}\x{1E83D}", %p)},	undef,	"to_unicode\(\'Ↄ。\\u1A60\\uD804\\uDD80\\uD83A\\uDC3D\'\)\ throws\ error\ P1\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3330\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ↄ。\x{1A60}\x{11180}\x{1E83D}", %p)},	undef,	"to_unicode\(\'ↄ。\\u1A60\\uD804\\uDD80\\uD83A\\uDC3D\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3331\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0100}-。\x{47672}≮\x{11046}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD00\-。\\uD8DD\\uDE72≮\\uD804\\uDC46\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3332\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0100}-。\x{47672}<\x{0338}\x{11046}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD00\-。\\uD8DD\\uDE72\<\\u0338\\uD804\\uDC46\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3333\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}䷭\x{200D}。\x{9ADC3}≮Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C䷭\\u200D。\\uDA2B\\uDDC3≮Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3334\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}䷭\x{200D}。\x{9ADC3}≮Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C䷭\\u200D。\\uDA2B\\uDDC3≮Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3335\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}䷭\x{200D}。\x{9ADC3}<\x{0338}Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C䷭\\u200D。\\uDA2B\\uDDC3\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3336\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}䷭\x{200D}。\x{9ADC3}<\x{0338}Ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C䷭\\u200D。\\uDA2B\\uDDC3\<\\u0338Ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3337\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}䷭\x{200D}。\x{9ADC3}<\x{0338}ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C䷭\\u200D。\\uDA2B\\uDDC3\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3338\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}䷭\x{200D}。\x{9ADC3}<\x{0338}ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C䷭\\u200D。\\uDA2B\\uDDC3\<\\u0338ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3339\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}䷭\x{200D}。\x{9ADC3}≮ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C䷭\\u200D。\\uDA2B\\uDDC3≮ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3340\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}䷭\x{200D}。\x{9ADC3}≮ⴉ", %p)},	undef,	"to_unicode\(\'\\u200C䷭\\u200D。\\uDA2B\\uDDC3≮ⴉ\'\)\ throws\ error\ P1\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:3341\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E64}-\x{1BF3}ᡓ。︒䖐⾆", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE64\-\\u1BF3ᡓ。︒䖐⾆\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3342\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E64}-\x{1BF3}ᡓ。。䖐舌", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE64\-\\u1BF3ᡓ。。䖐舌\'\)\ throws\ error\ B1\ A4_2\ \[data\/IdnaTest\.txt\:3343\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0981}Ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0981Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3344\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0981}Ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0981Ⴐ｡쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3345\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0981}Ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0981Ⴐ。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3346\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0981}Ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0981Ⴐ。쪡\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3347\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0981}ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0981ⴐ。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3348\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0981}ⴐ。쪡", %p)},	undef,	"to_unicode\(\'\\u0981ⴐ。쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3349\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0981}ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0981ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3350\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0981}ⴐ｡쪡", %p)},	undef,	"to_unicode\(\'\\u0981ⴐ｡쪡\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3351\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0C4D}쩁\x{0604}.\x{BE999}", %p)},	undef,	"to_unicode\(\'\\u0C4D쩁\\u0604\.\\uDABA\\uDD99\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3352\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0C4D}쩁\x{0604}.\x{BE999}", %p)},	undef,	"to_unicode\(\'\\u0C4D쩁\\u0604\.\\uDABA\\uDD99\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:3353\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BD}⒒\x{200C}｡😠\x{66C9E}", %p)},	undef,	"to_unicode\(\'\\u06BD⒒\\u200C｡😠\\uD95B\\uDC9E\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3354\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BD}⒒\x{200C}｡😠\x{66C9E}", %p)},	undef,	"to_unicode\(\'\\u06BD⒒\\u200C｡😠\\uD95B\\uDC9E\'\)\ throws\ error\ P1\ V6\ B3\ C1\ \[data\/IdnaTest\.txt\:3355\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BD}11.\x{200C}。😠\x{66C9E}", %p)},	undef,	"to_unicode\(\'\\u06BD11\.\\u200C。😠\\uD95B\\uDC9E\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3356\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06BD}11.\x{200C}。😠\x{66C9E}", %p)},	undef,	"to_unicode\(\'\\u06BD11\.\\u200C。😠\\uD95B\\uDC9E\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3357\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3358\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3359\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3360\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}ß", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3361\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.\x{200D}ß", %p)},	undef,	"to_unicode\(\'羕5ꍩ\\u0F9E\.\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3362\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.\x{200D}ß", %p)},	undef,	"to_unicode\(\'羕5ꍩ\\u0F9E\.\\u200Dß\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3363\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.\x{200D}SS", %p)},	undef,	"to_unicode\(\'羕5ꍩ\\u0F9E\.\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3364\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.\x{200D}SS", %p)},	undef,	"to_unicode\(\'羕5ꍩ\\u0F9E\.\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3365\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.\x{200D}ss", %p)},	undef,	"to_unicode\(\'羕5ꍩ\\u0F9E\.\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3366\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.\x{200D}ss", %p)},	undef,	"to_unicode\(\'羕5ꍩ\\u0F9E\.\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3367\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.\x{200D}Ss", %p)},	undef,	"to_unicode\(\'羕5ꍩ\\u0F9E\.\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3368\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.\x{200D}Ss", %p)},	undef,	"to_unicode\(\'羕5ꍩ\\u0F9E\.\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3369\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--5-glg1017fj73a.ss", %p)},	"羕5ꍩ\x{0F9E}.ss",	"to_unicode\(\'xn\-\-5\-glg1017fj73a\.ss\'\)\ \[data\/IdnaTest\.txt\:3370\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕5ꍩ\x{0F9E}.ss", %p)},	"羕5ꍩ\x{0F9E}.ss",	"to_unicode\(\'羕5ꍩ\\u0F9E\.ss\'\)\ \[data\/IdnaTest\.txt\:3371\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3372\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3373\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3374\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3375\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3376\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3377\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3378\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}SS", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200DSS\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3379\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3380\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}ss", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200Dss\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3381\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3382\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羕𝟝ꍩ\x{0F9E}．\x{200D}Ss", %p)},	undef,	"to_unicode\(\'羕𝟝ꍩ\\u0F9E．\\u200DSs\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3383\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ꗷ\x{0EB5}.\x{08A0}\x{10A14}", %p)},	undef,	"to_unicode\(\'ꗷ\\u0EB5\.\\u08A0\\uD802\\uDE14\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3384\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("６≯-。︒蚴-\x{FFB20}", %p)},	undef,	"to_unicode\(\'６≯\-。︒蚴\-\\uDBBE\\uDF20\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3385\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("６>\x{0338}-。︒蚴-\x{FFB20}", %p)},	undef,	"to_unicode\(\'６\>\\u0338\-。︒蚴\-\\uDBBE\\uDF20\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3386\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6≯-。。蚴-\x{FFB20}", %p)},	undef,	"to_unicode\(\'6≯\-。。蚴\-\\uDBBE\\uDF20\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3387\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6>\x{0338}-。。蚴-\x{FFB20}", %p)},	undef,	"to_unicode\(\'6\>\\u0338\-。。蚴\-\\uDBBE\\uDF20\'\)\ throws\ error\ P1\ V3\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3388\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A72F0}\x{E012A}Ⴡ﹒．\x{10FCA}", %p)},	undef,	"to_unicode\(\'\\uDA5C\\uDEF0\\uDB40\\uDD2AჁ﹒．\\uD803\\uDFCA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3389\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A72F0}\x{E012A}Ⴡ..\x{10FCA}", %p)},	undef,	"to_unicode\(\'\\uDA5C\\uDEF0\\uDB40\\uDD2AჁ\.\.\\uD803\\uDFCA\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3390\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A72F0}\x{E012A}ⴡ..\x{10FCA}", %p)},	undef,	"to_unicode\(\'\\uDA5C\\uDEF0\\uDB40\\uDD2Aⴡ\.\.\\uD803\\uDFCA\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3391\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A72F0}\x{E012A}ⴡ﹒．\x{10FCA}", %p)},	undef,	"to_unicode\(\'\\uDA5C\\uDEF0\\uDB40\\uDD2Aⴡ﹒．\\uD803\\uDFCA\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3392\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FB7}。𝟠ᢉ-\x{084A}", %p)},	undef,	"to_unicode\(\'\\u0FB7。𝟠ᢉ\-\\u084A\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3393\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FB7}。8ᢉ-\x{084A}", %p)},	undef,	"to_unicode\(\'\\u0FB7。8ᢉ\-\\u084A\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3394\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("싇。⾇\x{1EEE6}Ⴝ", %p)},	undef,	"to_unicode\(\'싇。⾇\\uD83B\\uDEE6Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3395\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("싇。⾇\x{1EEE6}Ⴝ", %p)},	undef,	"to_unicode\(\'싇。⾇\\uD83B\\uDEE6Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3396\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("싇。舛\x{1EEE6}Ⴝ", %p)},	undef,	"to_unicode\(\'싇。舛\\uD83B\\uDEE6Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3397\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("싇。舛\x{1EEE6}Ⴝ", %p)},	undef,	"to_unicode\(\'싇。舛\\uD83B\\uDEE6Ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3398\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("싇。舛\x{1EEE6}ⴝ", %p)},	undef,	"to_unicode\(\'싇。舛\\uD83B\\uDEE6ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3399\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("싇。舛\x{1EEE6}ⴝ", %p)},	undef,	"to_unicode\(\'싇。舛\\uD83B\\uDEE6ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3400\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("싇。⾇\x{1EEE6}ⴝ", %p)},	undef,	"to_unicode\(\'싇。⾇\\uD83B\\uDEE6ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3401\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("싇。⾇\x{1EEE6}ⴝ", %p)},	undef,	"to_unicode\(\'싇。⾇\\uD83B\\uDEE6ⴝ\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3402\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0660}ς。\x{200C}ᡣჀ", %p)},	undef,	"to_unicode\(\'\\u0660ς。\\u200CᡣჀ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3403\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}ς。\x{200C}ᡣჀ", %p)},	undef,	"to_unicode\(\'\\u0660ς。\\u200CᡣჀ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3404\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}ς。\x{200C}ᡣⴠ", %p)},	undef,	"to_unicode\(\'\\u0660ς。\\u200Cᡣⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3405\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}ς。\x{200C}ᡣⴠ", %p)},	undef,	"to_unicode\(\'\\u0660ς。\\u200Cᡣⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3406\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}Σ。\x{200C}ᡣჀ", %p)},	undef,	"to_unicode\(\'\\u0660Σ。\\u200CᡣჀ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3407\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}Σ。\x{200C}ᡣჀ", %p)},	undef,	"to_unicode\(\'\\u0660Σ。\\u200CᡣჀ\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3408\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}σ。\x{200C}ᡣⴠ", %p)},	undef,	"to_unicode\(\'\\u0660σ。\\u200Cᡣⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3409\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0660}σ。\x{200C}ᡣⴠ", %p)},	undef,	"to_unicode\(\'\\u0660σ。\\u200Cᡣⴠ\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:3410\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{72D67}\x{200C}\x{10E73}.ꡝ-ß", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDD67\\u200C\\uD803\\uDE73\.ꡝ\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3411\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{72D67}\x{200C}\x{10E73}.ꡝ-ß", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDD67\\u200C\\uD803\\uDE73\.ꡝ\-ß\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3412\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{72D67}\x{200C}\x{10E73}.ꡝ-SS", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDD67\\u200C\\uD803\\uDE73\.ꡝ\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3413\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{72D67}\x{200C}\x{10E73}.ꡝ-SS", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDD67\\u200C\\uD803\\uDE73\.ꡝ\-SS\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3414\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{72D67}\x{200C}\x{10E73}.ꡝ-ss", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDD67\\u200C\\uD803\\uDE73\.ꡝ\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3415\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{72D67}\x{200C}\x{10E73}.ꡝ-ss", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDD67\\u200C\\uD803\\uDE73\.ꡝ\-ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3416\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{72D67}\x{200C}\x{10E73}.ꡝ-Ss", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDD67\\u200C\\uD803\\uDE73\.ꡝ\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3417\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{72D67}\x{200C}\x{10E73}.ꡝ-Ss", %p)},	undef,	"to_unicode\(\'\\uD98B\\uDD67\\u200C\\uD803\\uDE73\.ꡝ\-Ss\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3418\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{0759}.-\x{1EEA2}\x{B5E7C}\x{1ECB9}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u0759\.\-\\uD83B\\uDEA2\\uDA97\\uDE7C\\uD83B\\uDCB9\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3419\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{0759}.-\x{1EEA2}\x{B5E7C}\x{1ECB9}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u0759\.\-\\uD83B\\uDEA2\\uDA97\\uDE7C\\uD83B\\uDCB9\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3420\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{0759}.-\x{062C}\x{B5E7C}\x{1ECB9}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u0759\.\-\\u062C\\uDA97\\uDE7C\\uD83B\\uDCB9\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3421\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{200D}\x{17B5}\x{0759}.-\x{062C}\x{B5E7C}\x{1ECB9}", %p)},	undef,	"to_unicode\(\'\\u200C\\u200D\\u17B5\\u0759\.\-\\u062C\\uDA97\\uDE7C\\uD83B\\uDCB9\'\)\ throws\ error\ P1\ V6\ V3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:3422\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{B102F}｡\x{06B3}≠", %p)},	undef,	"to_unicode\(\'\\uDA84\\uDC2F｡\\u06B3≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3423\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{B102F}｡\x{06B3}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDA84\\uDC2F｡\\u06B3\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3424\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{B102F}。\x{06B3}≠", %p)},	undef,	"to_unicode\(\'\\uDA84\\uDC2F。\\u06B3≠\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3425\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{B102F}。\x{06B3}=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uDA84\\uDC2F。\\u06B3\=\\u0338\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3426\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{1039}\x{0680}｡\x{10E79}\x{0666}덝４", %p)},	undef,	"to_unicode\(\'\\u1039\\u0680｡\\uD803\\uDE79\\u0666덝４\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3427\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}\x{0680}｡\x{10E79}\x{0666}덝４", %p)},	undef,	"to_unicode\(\'\\u1039\\u0680｡\\uD803\\uDE79\\u0666덝４\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3428\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}\x{0680}。\x{10E79}\x{0666}덝4", %p)},	undef,	"to_unicode\(\'\\u1039\\u0680。\\uD803\\uDE79\\u0666덝4\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3429\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{1039}\x{0680}。\x{10E79}\x{0666}덝4", %p)},	undef,	"to_unicode\(\'\\u1039\\u0680。\\uD803\\uDE79\\u0666덝4\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3430\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ\x{1B02}-．\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\\u1B02\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3431\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ\x{1B02}-．\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\\u1B02\-．\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3432\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ\x{1B02}-.\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\\u1B02\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3433\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴏ\x{1B02}-.\x{200D}Ⴉ", %p)},	undef,	"to_unicode\(\'Ⴏ\\u1B02\-\.\\u200DႩ\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3434\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴏ\x{1B02}-.\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\\u1B02\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3435\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴏ\x{1B02}-.\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\\u1B02\-\.\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3436\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴏ\x{1B02}-．\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\\u1B02\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3437\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴏ\x{1B02}-．\x{200D}ⴉ", %p)},	undef,	"to_unicode\(\'ⴏ\\u1B02\-．\\u200Dⴉ\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:3438\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🐄\x{1037}\x{E0AB7}\x{A858C}。\x{066B}➱\x{0F19}", %p)},	undef,	"to_unicode\(\'🐄\\u1037\\uDB42\\uDEB7\\uDA61\\uDD8C。\\u066B➱\\u0F19\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3439\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≠\x{0849}.➂⒎⒈", %p)},	undef,	"to_unicode\(\'≠\\u0849\.➂⒎⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3440\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("=\x{0338}\x{0849}.➂⒎⒈", %p)},	undef,	"to_unicode\(\'\=\\u0338\\u0849\.➂⒎⒈\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3441\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("≠\x{0849}.➂7.1.", %p)},	undef,	"to_unicode\(\'≠\\u0849\.➂7\.1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3442\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("=\x{0338}\x{0849}.➂7.1.", %p)},	undef,	"to_unicode\(\'\=\\u0338\\u0849\.➂7\.1\.\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3443\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A0D}\x{E0C89}ß.ᠩ\x{1F653}\x{200C}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE0D\\uDB43\\uDC89ß\.ᠩ\\uD83D\\uDE53\\u200C\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3444\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A0D}\x{E0C89}ß.ᠩ\x{1F653}\x{200C}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE0D\\uDB43\\uDC89ß\.ᠩ\\uD83D\\uDE53\\u200C\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3445\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A0D}\x{E0C89}SS.ᠩ\x{1F653}\x{200C}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE0D\\uDB43\\uDC89SS\.ᠩ\\uD83D\\uDE53\\u200C\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3446\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A0D}\x{E0C89}SS.ᠩ\x{1F653}\x{200C}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE0D\\uDB43\\uDC89SS\.ᠩ\\uD83D\\uDE53\\u200C\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3447\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A0D}\x{E0C89}ss.ᠩ\x{1F653}\x{200C}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE0D\\uDB43\\uDC89ss\.ᠩ\\uD83D\\uDE53\\u200C\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3448\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A0D}\x{E0C89}ss.ᠩ\x{1F653}\x{200C}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE0D\\uDB43\\uDC89ss\.ᠩ\\uD83D\\uDE53\\u200C\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3449\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A0D}\x{E0C89}Ss.ᠩ\x{1F653}\x{200C}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE0D\\uDB43\\uDC89Ss\.ᠩ\\uD83D\\uDE53\\u200C\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3450\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A0D}\x{E0C89}Ss.ᠩ\x{1F653}\x{200C}\x{10E75}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE0D\\uDB43\\uDC89Ss\.ᠩ\\uD83D\\uDE53\\u200C\\uD803\\uDE75\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3451\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{1EDA8}\x{5FA29}Ⴇ｡\x{E0179}", %p)},	undef,	"to_unicode\(\'ß\\uD83B\\uDDA8\\uD93E\\uDE29Ⴇ｡\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3452\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{1EDA8}\x{5FA29}Ⴇ。\x{E0179}", %p)},	undef,	"to_unicode\(\'ß\\uD83B\\uDDA8\\uD93E\\uDE29Ⴇ。\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3453\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{1EDA8}\x{5FA29}ⴇ。\x{E0179}", %p)},	undef,	"to_unicode\(\'ß\\uD83B\\uDDA8\\uD93E\\uDE29ⴇ。\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3454\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{1EDA8}\x{5FA29}Ⴇ。\x{E0179}", %p)},	undef,	"to_unicode\(\'SS\\uD83B\\uDDA8\\uD93E\\uDE29Ⴇ。\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3455\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{1EDA8}\x{5FA29}ⴇ。\x{E0179}", %p)},	undef,	"to_unicode\(\'ss\\uD83B\\uDDA8\\uD93E\\uDE29ⴇ。\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3456\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{1EDA8}\x{5FA29}Ⴇ。\x{E0179}", %p)},	undef,	"to_unicode\(\'Ss\\uD83B\\uDDA8\\uD93E\\uDE29Ⴇ。\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3457\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ß\x{1EDA8}\x{5FA29}ⴇ｡\x{E0179}", %p)},	undef,	"to_unicode\(\'ß\\uD83B\\uDDA8\\uD93E\\uDE29ⴇ｡\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3458\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("SS\x{1EDA8}\x{5FA29}Ⴇ｡\x{E0179}", %p)},	undef,	"to_unicode\(\'SS\\uD83B\\uDDA8\\uD93E\\uDE29Ⴇ｡\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3459\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ss\x{1EDA8}\x{5FA29}ⴇ｡\x{E0179}", %p)},	undef,	"to_unicode\(\'ss\\uD83B\\uDDA8\\uD93E\\uDE29ⴇ｡\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3460\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ss\x{1EDA8}\x{5FA29}Ⴇ｡\x{E0179}", %p)},	undef,	"to_unicode\(\'Ss\\uD83B\\uDDA8\\uD93E\\uDE29Ⴇ｡\\uDB40\\uDD79\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:3461\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1BAB}。\x{11131}-\x{A9C0}", %p)},	undef,	"to_unicode\(\'\\u1BAB。\\uD804\\uDD31\-\\uA9C0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3462\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E4D}-．\x{2FEDD}\x{0AC5}ß", %p)},	undef,	"to_unicode\(\'\\u0E4D\-．\\uD87F\\uDEDD\\u0AC5ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3463\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E4D}-.\x{2FEDD}\x{0AC5}ß", %p)},	undef,	"to_unicode\(\'\\u0E4D\-\.\\uD87F\\uDEDD\\u0AC5ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3464\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E4D}-.\x{2FEDD}\x{0AC5}SS", %p)},	undef,	"to_unicode\(\'\\u0E4D\-\.\\uD87F\\uDEDD\\u0AC5SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3465\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E4D}-.\x{2FEDD}\x{0AC5}ss", %p)},	undef,	"to_unicode\(\'\\u0E4D\-\.\\uD87F\\uDEDD\\u0AC5ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3466\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E4D}-.\x{2FEDD}\x{0AC5}Ss", %p)},	undef,	"to_unicode\(\'\\u0E4D\-\.\\uD87F\\uDEDD\\u0AC5Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3467\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E4D}-．\x{2FEDD}\x{0AC5}SS", %p)},	undef,	"to_unicode\(\'\\u0E4D\-．\\uD87F\\uDEDD\\u0AC5SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3468\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E4D}-．\x{2FEDD}\x{0AC5}ss", %p)},	undef,	"to_unicode\(\'\\u0E4D\-．\\uD87F\\uDEDD\\u0AC5ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3469\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0E4D}-．\x{2FEDD}\x{0AC5}Ss", %p)},	undef,	"to_unicode\(\'\\u0E4D\-．\\uD87F\\uDEDD\\u0AC5Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3470\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0775}-≮。\x{10E7E}\x{05A5}ꡃ", %p)},	undef,	"to_unicode\(\'\\u0775\-≮。\\uD803\\uDE7E\\u05A5ꡃ\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3471\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0775}-<\x{0338}。\x{10E7E}\x{05A5}ꡃ", %p)},	undef,	"to_unicode\(\'\\u0775\-\<\\u0338。\\uD803\\uDE7E\\u05A5ꡃ\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:3472\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🄇\x{E060C}\x{09CD}\x{E01A8}．\x{103A}\x{1BF2}8\x{1752}", %p)},	undef,	"to_unicode\(\'🄇\\uDB41\\uDE0C\\u09CD\\uDB40\\uDDA8．\\u103A\\u1BF28\\u1752\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3473\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("6,\x{E060C}\x{09CD}\x{E01A8}.\x{103A}\x{1BF2}8\x{1752}", %p)},	undef,	"to_unicode\(\'6\,\\uDB41\\uDE0C\\u09CD\\uDB40\\uDDA8\.\\u103A\\u1BF28\\u1752\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3474\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-｡\x{887C4}\x{200D}\x{E0BCF}", %p)},	undef,	"to_unicode\(\'\-｡\\uD9E1\\uDFC4\\u200D\\uDB42\\uDFCF\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3475\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-｡\x{887C4}\x{200D}\x{E0BCF}", %p)},	undef,	"to_unicode\(\'\-｡\\uD9E1\\uDFC4\\u200D\\uDB42\\uDFCF\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3476\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-。\x{887C4}\x{200D}\x{E0BCF}", %p)},	undef,	"to_unicode\(\'\-。\\uD9E1\\uDFC4\\u200D\\uDB42\\uDFCF\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3477\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-。\x{887C4}\x{200D}\x{E0BCF}", %p)},	undef,	"to_unicode\(\'\-。\\uD9E1\\uDFC4\\u200D\\uDB42\\uDFCF\'\)\ throws\ error\ P1\ V3\ V6\ C2\ \[data\/IdnaTest\.txt\:3478\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟒…𝟫\x{142F1}｡\x{0737}\x{773FA}", %p)},	undef,	"to_unicode\(\'𝟒…𝟫\\uD810\\uDEF1｡\\u0737\\uD99C\\uDFFA\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3479\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("4...9\x{142F1}。\x{0737}\x{773FA}", %p)},	undef,	"to_unicode\(\'4\.\.\.9\\uD810\\uDEF1。\\u0737\\uD99C\\uDFFA\'\)\ throws\ error\ P1\ V6\ V5\ A4_2\ \[data\/IdnaTest\.txt\:3480\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.-├\x{DC52F}", %p)},	undef,	"to_unicode\(\'\-\.\-├\\uDB31\\uDD2F\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3481\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E01B1}ᡬ｡\x{200D}⳾", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDB1ᡬ｡\\u200D⳾\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3482\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01B1}ᡬ｡\x{200D}⳾", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDB1ᡬ｡\\u200D⳾\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3483\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01B1}ᡬ。\x{200D}⳾", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDB1ᡬ。\\u200D⳾\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3484\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01B1}ᡬ。\x{200D}⳾", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDB1ᡬ。\\u200D⳾\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3485\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--88e.xn--pkj", %p)},	"ᡬ.⳾",	"to_unicode\(\'xn\-\-88e\.xn\-\-pkj\'\)\ \[data\/IdnaTest\.txt\:3486\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡬ.⳾", %p)},	"ᡬ.⳾",	"to_unicode\(\'ᡬ\.⳾\'\)\ \[data\/IdnaTest\.txt\:3487\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}Ⴎ．\x{200C}⒈⒈ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABႮ．\\u200C⒈⒈ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3488\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}Ⴎ．\x{200C}⒈⒈ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABႮ．\\u200C⒈⒈ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3489\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}Ⴎ．\x{200C}⒈⒈ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABႮ．\\u200C⒈⒈ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3490\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}Ⴎ．\x{200C}⒈⒈ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABႮ．\\u200C⒈⒈ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3491\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}Ⴎ.\x{200C}1.1.ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABႮ\.\\u200C1\.1\.ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3492\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}Ⴎ.\x{200C}1.1.ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABႮ\.\\u200C1\.1\.ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3493\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}Ⴎ.\x{200C}1.1.ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABႮ\.\\u200C1\.1\.ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3494\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}Ⴎ.\x{200C}1.1.ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABႮ\.\\u200C1\.1\.ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3495\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}ⴎ.\x{200C}1.1.ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABⴎ\.\\u200C1\.1\.ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3496\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}ⴎ.\x{200C}1.1.ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABⴎ\.\\u200C1\.1\.ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3497\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}ⴎ.\x{200C}1.1.ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABⴎ\.\\u200C1\.1\.ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3498\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}ⴎ.\x{200C}1.1.ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABⴎ\.\\u200C1\.1\.ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3499\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}ⴎ．\x{200C}⒈⒈ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABⴎ．\\u200C⒈⒈ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3500\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}ⴎ．\x{200C}⒈⒈ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABⴎ．\\u200C⒈⒈ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3501\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}ⴎ．\x{200C}⒈⒈ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABⴎ．\\u200C⒈⒈ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3502\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("쥥\x{671AB}ⴎ．\x{200C}⒈⒈ᢝ", %p)},	undef,	"to_unicode\(\'쥥\\uD95C\\uDDABⴎ．\\u200C⒈⒈ᢝ\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3503\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A8E7}𝟼ᡵ-。\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\uA8E7𝟼ᡵ\-。\\u0E3A\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3504\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8E7}6ᡵ-。\x{0E3A}", %p)},	undef,	"to_unicode\(\'\\uA8E76ᡵ\-。\\u0E3A\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3505\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς．\x{069A}\x{E0868}⒈", %p)},	undef,	"to_unicode\(\'ς．\\u069A\\uDB42\\uDC68⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3506\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς.\x{069A}\x{E0868}1.", %p)},	undef,	"to_unicode\(\'ς\.\\u069A\\uDB42\\uDC681\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3507\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ.\x{069A}\x{E0868}1.", %p)},	undef,	"to_unicode\(\'Σ\.\\u069A\\uDB42\\uDC681\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3508\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ.\x{069A}\x{E0868}1.", %p)},	undef,	"to_unicode\(\'σ\.\\u069A\\uDB42\\uDC681\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3509\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ．\x{069A}\x{E0868}⒈", %p)},	undef,	"to_unicode\(\'Σ．\\u069A\\uDB42\\uDC68⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3510\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ．\x{069A}\x{E0868}⒈", %p)},	undef,	"to_unicode\(\'σ．\\u069A\\uDB42\\uDC68⒈\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3511\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0BAC}-｡\x{0669}\x{4F3FA}\x{3E232}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDFAC\-｡\\u0669\\uD8FC\\uDFFA\\uD8B8\\uDE32\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3512\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0BAC}-。\x{0669}\x{4F3FA}\x{3E232}", %p)},	undef,	"to_unicode\(\'\\uDB42\\uDFAC\-。\\u0669\\uD8FC\\uDFFA\\uD8B8\\uDE32\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3513\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10816}-\x{E061C}｡⒓\x{200C}\x{10AD0}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC16\-\\uDB41\\uDE1C｡⒓\\u200C\\uD802\\uDED0\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3514\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10816}-\x{E061C}｡⒓\x{200C}\x{10AD0}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC16\-\\uDB41\\uDE1C｡⒓\\u200C\\uD802\\uDED0\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3515\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10816}-\x{E061C}。12.\x{200C}\x{10AD0}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC16\-\\uDB41\\uDE1C。12\.\\u200C\\uD802\\uDED0\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3516\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10816}-\x{E061C}。12.\x{200C}\x{10AD0}", %p)},	undef,	"to_unicode\(\'\\uD802\\uDC16\-\\uDB41\\uDE1C。12\.\\u200C\\uD802\\uDED0\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C1\ \[data\/IdnaTest\.txt\:3517\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ß．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dß．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3518\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ß．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dß．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3519\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ß．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dß．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3520\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ß．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dß．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3521\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ß.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dß\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3522\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ß.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dß\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3523\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ß.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dß\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3524\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ß.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dß\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3525\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}SS.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSS\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3526\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}SS.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSS\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3527\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}SS.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSS\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3528\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}SS.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSS\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3529\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ss.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dss\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3530\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ss.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dss\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3531\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ss.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dss\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3532\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ss.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dss\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3533\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}Ss.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSs\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3534\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}Ss.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSs\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3535\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}Ss.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSs\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3536\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}Ss.ᠱ3\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSs\.ᠱ3\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3537\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}SS．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSS．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3538\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}SS．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSS．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3539\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}SS．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSS．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3540\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}SS．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSS．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3541\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ss．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dss．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3542\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ss．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dss．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3543\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ss．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dss．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3544\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}ss．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200Dss．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3545\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}Ss．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSs．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3546\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}Ss．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSs．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3547\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}Ss．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSs．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3548\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E6C}늿\x{200D}Ss．ᠱ₃\x{E012B}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C늿\\u200DSs．ᠱ₃\\uDB40\\uDD2B\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:3549\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟷\x{0941}．\x{341F5}ꡁ", %p)},	undef,	"to_unicode\(\'𝟷\\u0941．\\uD890\\uDDF5ꡁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3550\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1\x{0941}.\x{341F5}ꡁ", %p)},	undef,	"to_unicode\(\'1\\u0941\.\\uD890\\uDDF5ꡁ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3551\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{05C3}😳ßˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\u05C3😳ßˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3552\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{05C3}😳ßˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\u05C3😳ßˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3553\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{05C3}😳ßˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\u05C3😳ßˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3554\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{05C3}😳ßˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\u05C3😳ßˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3555\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{05C3}😳SSˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\u05C3😳SSˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3556\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{05C3}😳SSˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\u05C3😳SSˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3557\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{05C3}😳ssˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\u05C3😳ssˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3558\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{05C3}😳ssˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\u05C3😳ssˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3559\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{05C3}😳Ssˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\u05C3😳Ssˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3560\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{1160}.\x{05C3}😳Ssˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\u1160\.\\u05C3😳Ssˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3561\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{05C3}😳SSˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\u05C3😳SSˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3562\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{05C3}😳SSˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\u05C3😳SSˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3563\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{05C3}😳ssˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\u05C3😳ssˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3564\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{05C3}😳ssˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\u05C3😳ssˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3565\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{05C3}😳Ssˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\u05C3😳Ssˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3566\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}\x{FFA0}.\x{05C3}😳Ssˋ", %p)},	undef,	"to_unicode\(\'\\u200C\\uFFA0\.\\u05C3😳Ssˋ\'\)\ throws\ error\ P1\ V6\ C1\ B2\ B3\ \[data\/IdnaTest\.txt\:3567\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("︒Ⴖ\x{05BC}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒Ⴖ\\u05BC．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3568\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒Ⴖ\x{05BC}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒Ⴖ\\u05BC．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3569\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ⴖ\x{05BC}.\x{200C}", %p)},	undef,	"to_unicode\(\'。Ⴖ\\u05BC\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3570\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。Ⴖ\x{05BC}.\x{200C}", %p)},	undef,	"to_unicode\(\'。Ⴖ\\u05BC\.\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3571\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。ⴖ\x{05BC}.\x{200C}", %p)},	undef,	"to_unicode\(\'。ⴖ\\u05BC\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3572\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("。ⴖ\x{05BC}.\x{200C}", %p)},	undef,	"to_unicode\(\'。ⴖ\\u05BC\.\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3573\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--kdb162r.", %p)},	"ⴖ\x{05BC}.",	"to_unicode\(\'xn\-\-kdb162r\.\'\)\ \[data\/IdnaTest\.txt\:3574\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ⴖ\x{05BC}.", %p)},	"ⴖ\x{05BC}.",	"to_unicode\(\'ⴖ\\u05BC\.\'\)\ \[data\/IdnaTest\.txt\:3575\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ⴖ\x{05BC}.", %p)},	undef,	"to_unicode\(\'Ⴖ\\u05BC\.\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3576\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ⴖ\x{05BC}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒ⴖ\\u05BC．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3577\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("︒ⴖ\x{05BC}．\x{200C}", %p)},	undef,	"to_unicode\(\'︒ⴖ\\u05BC．\\u200C\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3578\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}．\x{200C}Ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0．\\u200CႣ\\uAA31\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3579\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}．\x{200C}Ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0．\\u200CႣ\\uAA31\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3580\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}.\x{200C}Ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0\.\\u200CႣ\\uAA31\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3581\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}.\x{200C}Ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0\.\\u200CႣ\\uAA31\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3582\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}.\x{200C}ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0\.\\u200Cⴃ\\uAA31\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3583\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}.\x{200C}ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0\.\\u200Cⴃ\\uAA31\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3584\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--pyb.xn--ukj2811b", %p)},	"\x{08A0}.ⴃ\x{AA31}",	"to_unicode\(\'xn\-\-pyb\.xn\-\-ukj2811b\'\)\ \[data\/IdnaTest\.txt\:3585\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}.ⴃ\x{AA31}", %p)},	"\x{08A0}.ⴃ\x{AA31}",	"to_unicode\(\'\\u08A0\.ⴃ\\uAA31\'\)\ \[data\/IdnaTest\.txt\:3586\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}.Ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0\.Ⴃ\\uAA31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3587\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}．\x{200C}ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0．\\u200Cⴃ\\uAA31\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3588\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{08A0}．\x{200C}ⴃ\x{AA31}", %p)},	undef,	"to_unicode\(\'\\u08A0．\\u200Cⴃ\\uAA31\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:3589\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}\x{200C}。0䫷\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C。0䫷\\u1A6A\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3590\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{200C}。0䫷\x{1A6A}", %p)},	undef,	"to_unicode\(\'\\u200D\\u200C。0䫷\\u1A6A\'\)\ throws\ error\ C2\ C1\ \[data\/IdnaTest\.txt\:3591\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--0-e3k657x", %p)},	"0䫷\x{1A6A}",	"to_unicode\(\'xn\-\-0\-e3k657x\'\)\ \[data\/IdnaTest\.txt\:3592\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("0䫷\x{1A6A}", %p)},	"0䫷\x{1A6A}",	"to_unicode\(\'0䫷\\u1A6A\'\)\ \[data\/IdnaTest\.txt\:3593\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{08EF}\x{2EB97}。\x{5EAA7}", %p)},	undef,	"to_unicode\(\'\-\\u08EF\\uD87A\\uDF97。\\uD93A\\uDEA7\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3594\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{709A6}︒\x{200C}㟀．ꡛ⒈", %p)},	undef,	"to_unicode\(\'\\uD982\\uDDA6︒\\u200C㟀．ꡛ⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3595\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{709A6}︒\x{200C}㟀．ꡛ⒈", %p)},	undef,	"to_unicode\(\'\\uD982\\uDDA6︒\\u200C㟀．ꡛ⒈\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3596\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{709A6}。\x{200C}㟀.ꡛ1.", %p)},	undef,	"to_unicode\(\'\\uD982\\uDDA6。\\u200C㟀\.ꡛ1\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3597\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{709A6}。\x{200C}㟀.ꡛ1.", %p)},	undef,	"to_unicode\(\'\\uD982\\uDDA6。\\u200C㟀\.ꡛ1\.\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3598\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{A8EA}\x{06C4}\x{0483}。-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uA8EA\\u06C4\\u0483。\-\\u200D\'\)\ throws\ error\ V5\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3599\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{A8EA}\x{06C4}\x{0483}。-\x{200D}", %p)},	undef,	"to_unicode\(\'\\uA8EA\\u06C4\\u0483。\-\\u200D\'\)\ throws\ error\ V5\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3600\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}．Ⴉ≠\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ≠\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3601\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}．Ⴉ≠\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ≠\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3602\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}．Ⴉ=\x{0338}\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\=\\u0338\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3603\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}．Ⴉ=\x{0338}\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C．Ⴉ\=\\u0338\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3604\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}.Ⴉ≠\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ≠\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3605\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}.Ⴉ≠\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ≠\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3606\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}.Ⴉ=\x{0338}\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\=\\u0338\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3607\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}.Ⴉ=\x{0338}\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C\.Ⴉ\=\\u0338\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3608\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}.ⴉ=\x{0338}\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\=\\u0338\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3609\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}.ⴉ=\x{0338}\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ\=\\u0338\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3610\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}.ⴉ≠\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ≠\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3611\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}.ⴉ≠\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C\.ⴉ≠\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3612\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}．ⴉ=\x{0338}\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\=\\u0338\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3613\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}．ⴉ=\x{0338}\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ\=\\u0338\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3614\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}．ⴉ≠\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ≠\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3615\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}．ⴉ≠\x{1E8F2}", %p)},	undef,	"to_unicode\(\'\\u200C．ⴉ≠\\uD83A\\uDCF2\'\)\ throws\ error\ P1\ V6\ C1\ B5\ B6\ \[data\/IdnaTest\.txt\:3616\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{06CD}。≯ς", %p)},	undef,	"to_unicode\(\'\\u06CD。≯ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3617\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}。>\x{0338}ς", %p)},	undef,	"to_unicode\(\'\\u06CD。\>\\u0338ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3618\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}。>\x{0338}Σ", %p)},	undef,	"to_unicode\(\'\\u06CD。\>\\u0338Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3619\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}。≯Σ", %p)},	undef,	"to_unicode\(\'\\u06CD。≯Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3620\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}。≯σ", %p)},	undef,	"to_unicode\(\'\\u06CD。≯σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3621\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{06CD}。>\x{0338}σ", %p)},	undef,	"to_unicode\(\'\\u06CD。\>\\u0338σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3622\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FCA6}\x{0776}.\x{B78F2}︒\x{8A5EA}Ⴐ", %p)},	undef,	"to_unicode\(\'\\uFCA6\\u0776\.\\uDA9E\\uDCF2︒\\uD9E9\\uDDEAႰ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3623\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{062B}\x{0645}\x{0776}.\x{B78F2}。\x{8A5EA}Ⴐ", %p)},	undef,	"to_unicode\(\'\\u062B\\u0645\\u0776\.\\uDA9E\\uDCF2。\\uD9E9\\uDDEAႰ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3624\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{062B}\x{0645}\x{0776}.\x{B78F2}。\x{8A5EA}ⴐ", %p)},	undef,	"to_unicode\(\'\\u062B\\u0645\\u0776\.\\uDA9E\\uDCF2。\\uD9E9\\uDDEAⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3625\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FCA6}\x{0776}.\x{B78F2}︒\x{8A5EA}ⴐ", %p)},	undef,	"to_unicode\(\'\\uFCA6\\u0776\.\\uDA9E\\uDCF2︒\\uD9E9\\uDDEAⴐ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3626\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴥ⾏\x{E05AB}\x{A9B8}｡\x{0599}", %p)},	undef,	"to_unicode\(\'Ⴥ⾏\\uDB41\\uDDAB\\uA9B8｡\\u0599\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3627\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴥ行\x{E05AB}\x{A9B8}。\x{0599}", %p)},	undef,	"to_unicode\(\'Ⴥ行\\uDB41\\uDDAB\\uA9B8。\\u0599\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3628\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴥ行\x{E05AB}\x{A9B8}。\x{0599}", %p)},	undef,	"to_unicode\(\'ⴥ行\\uDB41\\uDDAB\\uA9B8。\\u0599\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3629\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴥ⾏\x{E05AB}\x{A9B8}｡\x{0599}", %p)},	undef,	"to_unicode\(\'ⴥ⾏\\uDB41\\uDDAB\\uA9B8｡\\u0599\'\)\ throws\ error\ P1\ V6\ V5\ \[data\/IdnaTest\.txt\:3630\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("𝟱。🜎ᢧ", %p)},	"5.🜎ᢧ",	"to_unicode\(\'𝟱。🜎ᢧ\'\)\ \[data\/IdnaTest\.txt\:3631\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("5。🜎ᢧ", %p)},	"5.🜎ᢧ",	"to_unicode\(\'5。🜎ᢧ\'\)\ \[data\/IdnaTest\.txt\:3632\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("5.xn--xbf5506v", %p)},	"5.🜎ᢧ",	"to_unicode\(\'5\.xn\-\-xbf5506v\'\)\ \[data\/IdnaTest\.txt\:3633\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("5.🜎ᢧ", %p)},	"5.🜎ᢧ",	"to_unicode\(\'5\.🜎ᢧ\'\)\ \[data\/IdnaTest\.txt\:3634\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("≮ꡌ。섖쮖ß", %p)},	undef,	"to_unicode\(\'≮ꡌ。섖쮖ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3635\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ꡌ。섖쮖ß", %p)},	undef,	"to_unicode\(\'\<\\u0338ꡌ。섖쮖ß\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3636\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ꡌ。섖쮖SS", %p)},	undef,	"to_unicode\(\'\<\\u0338ꡌ。섖쮖SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3637\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ꡌ。섖쮖SS", %p)},	undef,	"to_unicode\(\'≮ꡌ。섖쮖SS\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3638\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ꡌ。섖쮖ss", %p)},	undef,	"to_unicode\(\'≮ꡌ。섖쮖ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3639\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ꡌ。섖쮖ss", %p)},	undef,	"to_unicode\(\'\<\\u0338ꡌ。섖쮖ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3640\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("<\x{0338}ꡌ。섖쮖Ss", %p)},	undef,	"to_unicode\(\'\<\\u0338ꡌ。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3641\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("≮ꡌ。섖쮖Ss", %p)},	undef,	"to_unicode\(\'≮ꡌ。섖쮖Ss\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3642\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0365}\x{E066C}-。ᠾ", %p)},	undef,	"to_unicode\(\'\\u0365\\uDB41\\uDE6C\-。ᠾ\'\)\ throws\ error\ P1\ V3\ V5\ V6\ \[data\/IdnaTest\.txt\:3643\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EEB6}\x{0669}ꡊ\x{1BAB}。\x{07DA}ᡴ\x{200C}\x{067C}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDEB6\\u0669ꡊ\\u1BAB。\\u07DAᡴ\\u200C\\u067C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3644\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{062B}\x{0669}ꡊ\x{1BAB}。\x{07DA}ᡴ\x{200C}\x{067C}", %p)},	undef,	"to_unicode\(\'\\u062B\\u0669ꡊ\\u1BAB。\\u07DAᡴ\\u200C\\u067C\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:3645\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{A92D}.\x{10F81}\x{58BF1}", %p)},	undef,	"to_unicode\(\'\\uA92D\.\\uD803\\uDF81\\uD922\\uDFF1\'\)\ throws\ error\ P1\ V5\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3646\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("--。\x{41AF8}\x{06A0}\x{109A4}\x{1E868}", %p)},	undef,	"to_unicode\(\'\-\-。\\uD8C6\\uDEF8\\u06A0\\uD802\\uDDA4\\uD83A\\uDC68\'\)\ throws\ error\ P1\ V3\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3647\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9461E}𝟐\x{87B22}.≯ᢜᢗ\x{8C130}", %p)},	undef,	"to_unicode\(\'\\uDA11\\uDE1E𝟐\\uD9DE\\uDF22\.≯ᢜᢗ\\uD9F0\\uDD30\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3648\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9461E}𝟐\x{87B22}.>\x{0338}ᢜᢗ\x{8C130}", %p)},	undef,	"to_unicode\(\'\\uDA11\\uDE1E𝟐\\uD9DE\\uDF22\.\>\\u0338ᢜᢗ\\uD9F0\\uDD30\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3649\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9461E}2\x{87B22}.≯ᢜᢗ\x{8C130}", %p)},	undef,	"to_unicode\(\'\\uDA11\\uDE1E2\\uD9DE\\uDF22\.≯ᢜᢗ\\uD9F0\\uDD30\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3650\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{9461E}2\x{87B22}.>\x{0338}ᢜᢗ\x{8C130}", %p)},	undef,	"to_unicode\(\'\\uDA11\\uDE1E2\\uD9DE\\uDF22\.\>\\u0338ᢜᢗ\\uD9F0\\uDD30\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3651\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䔛\x{E010E}\x{D4626}\x{0668}．-䤷", %p)},	undef,	"to_unicode\(\'䔛\\uDB40\\uDD0E\\uDB11\\uDE26\\u0668．\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3652\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䔛\x{E010E}\x{D4626}\x{0668}.-䤷", %p)},	undef,	"to_unicode\(\'䔛\\uDB40\\uDD0E\\uDB11\\uDE26\\u0668\.\-䤷\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ \[data\/IdnaTest\.txt\:3653\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{0666}．\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0666．\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3654\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0666}．\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0666．\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3655\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0666}.\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0666\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3656\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0666}.\x{200D}-", %p)},	undef,	"to_unicode\(\'\\u0666\.\\u200D\-\'\)\ throws\ error\ V3\ B1\ C2\ \[data\/IdnaTest\.txt\:3657\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DFF6F}帷｡≯萺\x{E0F50}-", %p)},	undef,	"to_unicode\(\'\\uDB3F\\uDF6F帷｡≯萺\\uDB43\\uDF50\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3658\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DFF6F}帷｡>\x{0338}萺\x{E0F50}-", %p)},	undef,	"to_unicode\(\'\\uDB3F\\uDF6F帷｡\>\\u0338萺\\uDB43\\uDF50\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3659\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DFF6F}帷。≯萺\x{E0F50}-", %p)},	undef,	"to_unicode\(\'\\uDB3F\\uDF6F帷。≯萺\\uDB43\\uDF50\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3660\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{DFF6F}帷。>\x{0338}萺\x{E0F50}-", %p)},	undef,	"to_unicode\(\'\\uDB3F\\uDF6F帷。\>\\u0338萺\\uDB43\\uDF50\-\'\)\ throws\ error\ P1\ V6\ V3\ \[data\/IdnaTest\.txt\:3661\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}攌\x{A806}。\x{0723}-Ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\uA806。\\u0723\-Ⴘ\'\)\ throws\ error\ P1\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3662\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{A806}。\x{0723}-Ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\uA806。\\u0723\-Ⴘ\'\)\ throws\ error\ P1\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3663\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{A806}。\x{0723}-ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\uA806。\\u0723\-ⴘ\'\)\ throws\ error\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3664\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}攌\x{A806}。\x{0723}-ⴘ", %p)},	undef,	"to_unicode\(\'\\u200D攌\\uA806。\\u0723\-ⴘ\'\)\ throws\ error\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3665\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ꖨ．𝟪₀\x{93F89}𝟱", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．𝟪₀\\uDA0F\\uDF89𝟱\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3666\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ꖨ．𝟪₀\x{93F89}𝟱", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ．𝟪₀\\uDA0F\\uDF89𝟱\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3667\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ꖨ.80\x{93F89}5", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.80\\uDA0F\\uDF895\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3668\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ꖨ.80\x{93F89}5", %p)},	undef,	"to_unicode\(\'\\u200Cꖨ\.80\\uDA0F\\uDF895\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3669\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⒈걾2.\x{FD96}\x{0767}", %p)},	undef,	"to_unicode\(\'⒈걾2\.\\uFD96\\u0767\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3670\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⒈걾2.\x{FD96}\x{0767}", %p)},	undef,	"to_unicode\(\'⒈걾2\.\\uFD96\\u0767\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3671\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.걾2.\x{0646}\x{062D}\x{0649}\x{0767}", %p)},	"1.걾2.\x{0646}\x{062D}\x{0649}\x{0767}",	"to_unicode\(\'1\.걾2\.\\u0646\\u062D\\u0649\\u0767\'\)\ \[data\/IdnaTest\.txt\:3672\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.걾2.\x{0646}\x{062D}\x{0649}\x{0767}", %p)},	"1.걾2.\x{0646}\x{062D}\x{0649}\x{0767}",	"to_unicode\(\'1\.걾2\.\\u0646\\u062D\\u0649\\u0767\'\)\ \[data\/IdnaTest\.txt\:3673\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("1.xn--2-945e.xn--sgb3ck85i", %p)},	"1.걾2.\x{0646}\x{062D}\x{0649}\x{0767}",	"to_unicode\(\'1\.xn\-\-2\-945e\.xn\-\-sgb3ck85i\'\)\ \[data\/IdnaTest\.txt\:3674\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{109C4}𝟻≮≮.\x{2DFB}ᢣ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDDC4𝟻≮≮\.\\u2DFBᢣ\'\)\ throws\ error\ P1\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:3675\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{109C4}𝟻<\x{0338}<\x{0338}.\x{2DFB}ᢣ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDDC4𝟻\<\\u0338\<\\u0338\.\\u2DFBᢣ\'\)\ throws\ error\ P1\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:3676\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{109C4}5≮≮.\x{2DFB}ᢣ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDDC45≮≮\.\\u2DFBᢣ\'\)\ throws\ error\ P1\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:3677\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{109C4}5<\x{0338}<\x{0338}.\x{2DFB}ᢣ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDDC45\<\\u0338\<\\u0338\.\\u2DFBᢣ\'\)\ throws\ error\ P1\ V6\ V5\ B3\ \[data\/IdnaTest\.txt\:3678\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0043}.\x{10E7A}\x{115F}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDC43\.\\uD803\\uDE7A\\u115F\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3679\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟨\x{1BA5}\x{E0110}.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟨\\u1BA5\\uDB40\\uDD10\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3680\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("𝟨\x{1BA5}\x{E0110}.\x{200D}", %p)},	undef,	"to_unicode\(\'𝟨\\u1BA5\\uDB40\\uDD10\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3681\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6\x{1BA5}\x{E0110}.\x{200D}", %p)},	undef,	"to_unicode\(\'6\\u1BA5\\uDB40\\uDD10\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3682\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6\x{1BA5}\x{E0110}.\x{200D}", %p)},	undef,	"to_unicode\(\'6\\u1BA5\\uDB40\\uDD10\.\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3683\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--6-eml.", %p)},	"6\x{1BA5}.",	"to_unicode\(\'xn\-\-6\-eml\.\'\)\ \[data\/IdnaTest\.txt\:3684\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6\x{1BA5}.", %p)},	"6\x{1BA5}.",	"to_unicode\(\'6\\u1BA5\.\'\)\ \[data\/IdnaTest\.txt\:3685\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ≠\x{06A3}\x{0C4D}｡-\x{200C}ꡠ", %p)},	undef,	"to_unicode\(\'ᡭ≠\\u06A3\\u0C4D｡\-\\u200Cꡠ\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3686\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ≠\x{06A3}\x{0C4D}｡-\x{200C}ꡠ", %p)},	undef,	"to_unicode\(\'ᡭ≠\\u06A3\\u0C4D｡\-\\u200Cꡠ\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3687\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ=\x{0338}\x{06A3}\x{0C4D}｡-\x{200C}ꡠ", %p)},	undef,	"to_unicode\(\'ᡭ\=\\u0338\\u06A3\\u0C4D｡\-\\u200Cꡠ\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3688\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ=\x{0338}\x{06A3}\x{0C4D}｡-\x{200C}ꡠ", %p)},	undef,	"to_unicode\(\'ᡭ\=\\u0338\\u06A3\\u0C4D｡\-\\u200Cꡠ\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3689\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ≠\x{06A3}\x{0C4D}。-\x{200C}ꡠ", %p)},	undef,	"to_unicode\(\'ᡭ≠\\u06A3\\u0C4D。\-\\u200Cꡠ\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3690\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ≠\x{06A3}\x{0C4D}。-\x{200C}ꡠ", %p)},	undef,	"to_unicode\(\'ᡭ≠\\u06A3\\u0C4D。\-\\u200Cꡠ\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3691\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ=\x{0338}\x{06A3}\x{0C4D}。-\x{200C}ꡠ", %p)},	undef,	"to_unicode\(\'ᡭ\=\\u0338\\u06A3\\u0C4D。\-\\u200Cꡠ\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3692\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ᡭ=\x{0338}\x{06A3}\x{0C4D}。-\x{200C}ꡠ", %p)},	undef,	"to_unicode\(\'ᡭ\=\\u0338\\u06A3\\u0C4D。\-\\u200Cꡠ\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:3693\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7C}\x{1CE7}-\x{0628}｡\x{06A8}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7C\\u1CE7\-\\u0628｡\\u06A8\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3694\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{10E7C}\x{1CE7}-\x{0628}。\x{06A8}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE7C\\u1CE7\-\\u0628。\\u06A8\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3695\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("F\x{1CD0}｡\x{1090D1}⁖", %p)},	undef,	"to_unicode\(\'F\\u1CD0｡\\uDBE4\\uDCD1⁖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3696\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("F\x{1CD0}。\x{1090D1}⁖", %p)},	undef,	"to_unicode\(\'F\\u1CD0。\\uDBE4\\uDCD1⁖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3697\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f\x{1CD0}。\x{1090D1}⁖", %p)},	undef,	"to_unicode\(\'f\\u1CD0。\\uDBE4\\uDCD1⁖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3698\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("f\x{1CD0}｡\x{1090D1}⁖", %p)},	undef,	"to_unicode\(\'f\\u1CD0｡\\uDBE4\\uDCD1⁖\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3699\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1734}\x{1734}\x{1A7B}。۰Ⴘ\x{135E}\x{AF13F}", %p)},	undef,	"to_unicode\(\'\\u1734\\u1734\\u1A7B。۰Ⴘ\\u135E\\uDA7C\\uDD3F\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3700\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1734}\x{1734}\x{1A7B}。۰ⴘ\x{135E}\x{AF13F}", %p)},	undef,	"to_unicode\(\'\\u1734\\u1734\\u1A7B。۰ⴘ\\u135E\\uDA7C\\uDD3F\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3701\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{30A68}\x{200C}\x{200C}５。勉\x{E0078}", %p)},	undef,	"to_unicode\(\'\\uD882\\uDE68\\u200C\\u200C５。勉\\uDB40\\uDC78\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3702\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{30A68}\x{200C}\x{200C}５。勉\x{E0078}", %p)},	undef,	"to_unicode\(\'\\uD882\\uDE68\\u200C\\u200C５。勉\\uDB40\\uDC78\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3703\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{30A68}\x{200C}\x{200C}5。勉\x{E0078}", %p)},	undef,	"to_unicode\(\'\\uD882\\uDE68\\u200C\\u200C5。勉\\uDB40\\uDC78\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3704\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{30A68}\x{200C}\x{200C}5。勉\x{E0078}", %p)},	undef,	"to_unicode\(\'\\uD882\\uDE68\\u200C\\u200C5。勉\\uDB40\\uDC78\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3705\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("᠇.\x{D3154}\x{5CF08}\x{6C1A6}", %p)},	undef,	"to_unicode\(\'᠇\.\\uDB0C\\uDD54\\uD933\\uDF08\\uD970\\uDDA6\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3706\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈≯８", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈≯８\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3707\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈≯８", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈≯８\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3708\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈>\x{0338}８", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\>\\u0338８\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3709\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}｡⒈>\x{0338}８", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C｡⒈\>\\u0338８\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3710\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.≯8", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C。1\.≯8\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3711\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.≯8", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C。1\.≯8\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3712\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.>\x{0338}8", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C。1\.\>\\u03388\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3713\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200C}\x{200C}。1.>\x{0338}8", %p)},	undef,	"to_unicode\(\'\\u200C\\u200C。1\.\>\\u03388\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:3714\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{115F}\x{102D}\x{564A6}.\x{472BE}≯ᡞ", %p)},	undef,	"to_unicode\(\'\\u115F\\u102D\\uD919\\uDCA6\.\\uD8DC\\uDEBE≯ᡞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3715\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{115F}\x{102D}\x{564A6}.\x{472BE}>\x{0338}ᡞ", %p)},	undef,	"to_unicode\(\'\\u115F\\u102D\\uD919\\uDCA6\.\\uD8DC\\uDEBE\>\\u0338ᡞ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3716\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🁠\x{0948}\x{200D}\x{0713}.\x{0356}-\x{1B71}\x{58169}", %p)},	undef,	"to_unicode\(\'🁠\\u0948\\u200D\\u0713\.\\u0356\-\\u1B71\\uD920\\uDD69\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3717\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🁠\x{0948}\x{200D}\x{0713}.\x{0356}-\x{1B71}\x{58169}", %p)},	undef,	"to_unicode\(\'🁠\\u0948\\u200D\\u0713\.\\u0356\-\\u1B71\\uD920\\uDD69\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:3718\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E01CD}．\x{0B4D}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDCD．\\u0B4D\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3719\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01CD}.\x{0B4D}-", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDDCD\.\\u0B4D\-\'\)\ throws\ error\ V3\ V5\ \[data\/IdnaTest\.txt\:3720\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䮸ß.\x{E0D5F}℮紙\x{0770}", %p)},	undef,	"to_unicode\(\'䮸ß\.\\uDB43\\uDD5F℮紙\\u0770\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3721\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䮸SS.\x{E0D5F}℮紙\x{0770}", %p)},	undef,	"to_unicode\(\'䮸SS\.\\uDB43\\uDD5F℮紙\\u0770\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3722\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䮸ss.\x{E0D5F}℮紙\x{0770}", %p)},	undef,	"to_unicode\(\'䮸ss\.\\uDB43\\uDD5F℮紙\\u0770\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3723\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("䮸Ss.\x{E0D5F}℮紙\x{0770}", %p)},	undef,	"to_unicode\(\'䮸Ss\.\\uDB43\\uDD5F℮紙\\u0770\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3724\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-Ⴞ.-\x{E0C5D}\x{E0B98}\x{1E99C}", %p)},	undef,	"to_unicode\(\'\-Ⴞ\.\-\\uDB43\\uDC5D\\uDB42\\uDF98\\uD83A\\uDD9C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3725\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-ⴞ.-\x{E0C5D}\x{E0B98}\x{1E99C}", %p)},	undef,	"to_unicode\(\'\-ⴞ\.\-\\uDB43\\uDC5D\\uDB42\\uDF98\\uD83A\\uDD9C\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:3726\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{37585}\x{0662}\x{036E}｡\x{CB7C6}ꡌ\x{3D03C}ᠪ", %p)},	undef,	"to_unicode\(\'\\uD89D\\uDD85\\u0662\\u036E｡\\uDAED\\uDFC6ꡌ\\uD8B4\\uDC3Cᠪ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3727\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{37585}\x{0662}\x{036E}。\x{CB7C6}ꡌ\x{3D03C}ᠪ", %p)},	undef,	"to_unicode\(\'\\uD89D\\uDD85\\u0662\\u036E。\\uDAED\\uDFC6ꡌ\\uD8B4\\uDC3Cᠪ\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3728\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FAA}-\x{200D}\x{1D188}．\x{06B3}\x{200D}\x{75647}", %p)},	undef,	"to_unicode\(\'\\u0FAA\-\\u200D\\uD834\\uDD88．\\u06B3\\u200D\\uD995\\uDE47\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3729\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FAA}-\x{200D}\x{1D188}．\x{06B3}\x{200D}\x{75647}", %p)},	undef,	"to_unicode\(\'\\u0FAA\-\\u200D\\uD834\\uDD88．\\u06B3\\u200D\\uD995\\uDE47\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3730\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FAA}-\x{200D}\x{1D188}.\x{06B3}\x{200D}\x{75647}", %p)},	undef,	"to_unicode\(\'\\u0FAA\-\\u200D\\uD834\\uDD88\.\\u06B3\\u200D\\uD995\\uDE47\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3731\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FAA}-\x{200D}\x{1D188}.\x{06B3}\x{200D}\x{75647}", %p)},	undef,	"to_unicode\(\'\\u0FAA\-\\u200D\\uD834\\uDD88\.\\u06B3\\u200D\\uD995\\uDE47\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B2\ B3\ \[data\/IdnaTest\.txt\:3732\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("⁶。≠\x{10E78}", %p)},	undef,	"to_unicode\(\'⁶。≠\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3733\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("⁶。=\x{0338}\x{10E78}", %p)},	undef,	"to_unicode\(\'⁶。\=\\u0338\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3734\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6。≠\x{10E78}", %p)},	undef,	"to_unicode\(\'6。≠\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3735\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("6。=\x{0338}\x{10E78}", %p)},	undef,	"to_unicode\(\'6。\=\\u0338\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3736\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{ABED}廊.\x{07A0}", %p)},	undef,	"to_unicode\(\'\\uABED廊\.\\u07A0\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3737\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{05B5}-．-Ⴐ\x{0666}", %p)},	undef,	"to_unicode\(\'\\u200D\\u05B5\-．\-Ⴐ\\u0666\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3738\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{05B5}-．-Ⴐ\x{0666}", %p)},	undef,	"to_unicode\(\'\\u200D\\u05B5\-．\-Ⴐ\\u0666\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3739\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{05B5}-.-Ⴐ\x{0666}", %p)},	undef,	"to_unicode\(\'\\u200D\\u05B5\-\.\-Ⴐ\\u0666\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3740\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{05B5}-.-Ⴐ\x{0666}", %p)},	undef,	"to_unicode\(\'\\u200D\\u05B5\-\.\-Ⴐ\\u0666\'\)\ throws\ error\ P1\ V3\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3741\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{05B5}-.-ⴐ\x{0666}", %p)},	undef,	"to_unicode\(\'\\u200D\\u05B5\-\.\-ⴐ\\u0666\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3742\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{05B5}-.-ⴐ\x{0666}", %p)},	undef,	"to_unicode\(\'\\u200D\\u05B5\-\.\-ⴐ\\u0666\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3743\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{05B5}-．-ⴐ\x{0666}", %p)},	undef,	"to_unicode\(\'\\u200D\\u05B5\-．\-ⴐ\\u0666\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3744\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}\x{05B5}-．-ⴐ\x{0666}", %p)},	undef,	"to_unicode\(\'\\u200D\\u05B5\-．\-ⴐ\\u0666\'\)\ throws\ error\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3745\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{0721}\x{0661}挏\x{F9128}.-", %p)},	undef,	"to_unicode\(\'\\u0721\\u0661挏\\uDBA4\\uDD28\.\-\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B3\ \[data\/IdnaTest\.txt\:3746\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{FD0B}｡\x{0604}ꡎ", %p)},	undef,	"to_unicode\(\'\\uFD0B｡\\u0604ꡎ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3747\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0634}\x{062E}。\x{0604}ꡎ", %p)},	undef,	"to_unicode\(\'\\u0634\\u062E。\\u0604ꡎ\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3748\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴞ\x{3987C}\x{AFC19}．ᡒ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD8A6\\uDC7C\\uDA7F\\uDC19．ᡒ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3749\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴞ\x{3987C}\x{AFC19}．ᡒ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD8A6\\uDC7C\\uDA7F\\uDC19．ᡒ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3750\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴞ\x{3987C}\x{AFC19}.ᡒ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD8A6\\uDC7C\\uDA7F\\uDC19\.ᡒ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3751\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Ⴞ\x{3987C}\x{AFC19}.ᡒ릫", %p)},	undef,	"to_unicode\(\'Ⴞ\\uD8A6\\uDC7C\\uDA7F\\uDC19\.ᡒ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3752\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴞ\x{3987C}\x{AFC19}.ᡒ릫", %p)},	undef,	"to_unicode\(\'ⴞ\\uD8A6\\uDC7C\\uDA7F\\uDC19\.ᡒ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3753\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴞ\x{3987C}\x{AFC19}.ᡒ릫", %p)},	undef,	"to_unicode\(\'ⴞ\\uD8A6\\uDC7C\\uDA7F\\uDC19\.ᡒ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3754\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴞ\x{3987C}\x{AFC19}．ᡒ릫", %p)},	undef,	"to_unicode\(\'ⴞ\\uD8A6\\uDC7C\\uDA7F\\uDC19．ᡒ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3755\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ⴞ\x{3987C}\x{AFC19}．ᡒ릫", %p)},	undef,	"to_unicode\(\'ⴞ\\uD8A6\\uDC7C\\uDA7F\\uDC19．ᡒ릫\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3756\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🔱\x{6B20D}\x{06B7}\x{0668}｡≯\x{200C}\x{AAB3}", %p)},	undef,	"to_unicode\(\'🔱\\uD96C\\uDE0D\\u06B7\\u0668｡≯\\u200C\\uAAB3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3757\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🔱\x{6B20D}\x{06B7}\x{0668}｡≯\x{200C}\x{AAB3}", %p)},	undef,	"to_unicode\(\'🔱\\uD96C\\uDE0D\\u06B7\\u0668｡≯\\u200C\\uAAB3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3758\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🔱\x{6B20D}\x{06B7}\x{0668}｡>\x{0338}\x{200C}\x{AAB3}", %p)},	undef,	"to_unicode\(\'🔱\\uD96C\\uDE0D\\u06B7\\u0668｡\>\\u0338\\u200C\\uAAB3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3759\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🔱\x{6B20D}\x{06B7}\x{0668}｡>\x{0338}\x{200C}\x{AAB3}", %p)},	undef,	"to_unicode\(\'🔱\\uD96C\\uDE0D\\u06B7\\u0668｡\>\\u0338\\u200C\\uAAB3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3760\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🔱\x{6B20D}\x{06B7}\x{0668}。≯\x{200C}\x{AAB3}", %p)},	undef,	"to_unicode\(\'🔱\\uD96C\\uDE0D\\u06B7\\u0668。≯\\u200C\\uAAB3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3761\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🔱\x{6B20D}\x{06B7}\x{0668}。≯\x{200C}\x{AAB3}", %p)},	undef,	"to_unicode\(\'🔱\\uD96C\\uDE0D\\u06B7\\u0668。≯\\u200C\\uAAB3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3762\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🔱\x{6B20D}\x{06B7}\x{0668}。>\x{0338}\x{200C}\x{AAB3}", %p)},	undef,	"to_unicode\(\'🔱\\uD96C\\uDE0D\\u06B7\\u0668。\>\\u0338\\u200C\\uAAB3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3763\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🔱\x{6B20D}\x{06B7}\x{0668}。>\x{0338}\x{200C}\x{AAB3}", %p)},	undef,	"to_unicode\(\'🔱\\uD96C\\uDE0D\\u06B7\\u0668。\>\\u0338\\u200C\\uAAB3\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:3764\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᛎ\x{05A0}\x{FFF9}\x{200D}｡\x{0603}\x{10E77}\x{1E817}-", %p)},	undef,	"to_unicode\(\'ᛎ\\u05A0\\uFFF9\\u200D｡\\u0603\\uD803\\uDE77\\uD83A\\uDC17\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3765\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᛎ\x{05A0}\x{FFF9}\x{200D}｡\x{0603}\x{10E77}\x{1E817}-", %p)},	undef,	"to_unicode\(\'ᛎ\\u05A0\\uFFF9\\u200D｡\\u0603\\uD803\\uDE77\\uD83A\\uDC17\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3766\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᛎ\x{05A0}\x{FFF9}\x{200D}。\x{0603}\x{10E77}\x{1E817}-", %p)},	undef,	"to_unicode\(\'ᛎ\\u05A0\\uFFF9\\u200D。\\u0603\\uD803\\uDE77\\uD83A\\uDC17\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3767\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᛎ\x{05A0}\x{FFF9}\x{200D}。\x{0603}\x{10E77}\x{1E817}-", %p)},	undef,	"to_unicode\(\'ᛎ\\u05A0\\uFFF9\\u200D。\\u0603\\uD803\\uDE77\\uD83A\\uDC17\-\'\)\ throws\ error\ P1\ V6\ V3\ C2\ B1\ \[data\/IdnaTest\.txt\:3768\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{10E69}.\x{07E4}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE69\.\\u07E4\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3769\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{0E3A}｡⒈", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u0E3A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3770\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{0E3A}｡⒈", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u0E3A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3771\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{0E3A}。1.", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u0E3A。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3772\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ß\x{200D}\x{0E3A}。1.", %p)},	undef,	"to_unicode\(\'ß\\u200D\\u0E3A。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3773\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{0E3A}。1.", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u0E3A。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3774\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{0E3A}。1.", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u0E3A。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3775\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{0E3A}。1.", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u0E3A。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3776\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{0E3A}。1.", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u0E3A。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3777\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{0E3A}。1.", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u0E3A。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3778\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{0E3A}。1.", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u0E3A。1\.\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3779\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ss-jvi.1.", %p)},	"ss\x{0E3A}.1.",	"to_unicode\(\'xn\-\-ss\-jvi\.1\.\'\)\ \[data\/IdnaTest\.txt\:3780\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{0E3A}.1.", %p)},	"ss\x{0E3A}.1.",	"to_unicode\(\'ss\\u0E3A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3781\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{0E3A}.1.", %p)},	"ss\x{0E3A}.1.",	"to_unicode\(\'SS\\u0E3A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3782\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{0E3A}.1.", %p)},	"ss\x{0E3A}.1.",	"to_unicode\(\'Ss\\u0E3A\.1\.\'\)\ \[data\/IdnaTest\.txt\:3783\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{0E3A}｡⒈", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u0E3A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3784\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("SS\x{200D}\x{0E3A}｡⒈", %p)},	undef,	"to_unicode\(\'SS\\u200D\\u0E3A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3785\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{0E3A}｡⒈", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u0E3A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3786\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ss\x{200D}\x{0E3A}｡⒈", %p)},	undef,	"to_unicode\(\'ss\\u200D\\u0E3A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3787\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{0E3A}｡⒈", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u0E3A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3788\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Ss\x{200D}\x{0E3A}｡⒈", %p)},	undef,	"to_unicode\(\'Ss\\u200D\\u0E3A｡⒈\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:3789\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{111C0}\x{200C}\x{9475B}\x{1EAA0}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDDC0\\u200C\\uDA11\\uDF5B\\uD83A\\uDEA0。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3790\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{111C0}\x{200C}\x{9475B}\x{1EAA0}。\x{200D}", %p)},	undef,	"to_unicode\(\'\\uD804\\uDDC0\\u200C\\uDA11\\uDF5B\\uD83A\\uDEA0。\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:3791\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0777}｡\x{067A}🔋", %p)},	undef,	"to_unicode\(\'\\u0777｡\\u067A🔋\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:3792\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0777}。\x{067A}🔋", %p)},	undef,	"to_unicode\(\'\\u0777。\\u067A🔋\'\)\ throws\ error\ B3\ \[data\/IdnaTest\.txt\:3793\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07DC}\x{1BF2}。\x{0677}\x{1A1B}\x{200C}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u07DC\\u1BF2。\\u0677\\u1A1B\\u200C\\u0D4D\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:3794\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07DC}\x{1BF2}。\x{0677}\x{1A1B}\x{200C}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u07DC\\u1BF2。\\u0677\\u1A1B\\u200C\\u0D4D\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:3795\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07DC}\x{1BF2}。\x{06C7}\x{0674}\x{1A1B}\x{200C}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u07DC\\u1BF2。\\u06C7\\u0674\\u1A1B\\u200C\\u0D4D\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:3796\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{07DC}\x{1BF2}。\x{06C7}\x{0674}\x{1A1B}\x{200C}\x{0D4D}", %p)},	undef,	"to_unicode\(\'\\u07DC\\u1BF2。\\u06C7\\u0674\\u1A1B\\u200C\\u0D4D\'\)\ throws\ error\ B2\ B3\ C1\ \[data\/IdnaTest\.txt\:3797\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{D4CA7}.\x{E017E}ꡑ", %p)},	undef,	"to_unicode\(\'\\uDB13\\uDCA7\.\\uDB40\\uDD7Eꡑ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3798\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}．ß\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ß\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3．ß\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3799\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}．ß\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ß\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3．ß\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3800\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}.ß\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ß\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3\.ß\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3801\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}.ß\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ß\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3\.ß\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3802\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}.SS\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ss\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3\.SS\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3803\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}.ss\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ss\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3\.ss\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3804\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}.Ss\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ss\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3\.Ss\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3805\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--88e02p.xn--ss-efg876c", %p)},	"ᡬ\x{1BF3}.ss\x{0A4D}\x{0FBC}",	"to_unicode\(\'xn\-\-88e02p\.xn\-\-ss\-efg876c\'\)\ \[data\/IdnaTest\.txt\:3806\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("xn--88e02p.xn--zca249bipe", %p)},	"ᡬ\x{1BF3}.ß\x{0A4D}\x{0FBC}",	"to_unicode\(\'xn\-\-88e02p\.xn\-\-zca249bipe\'\)\ \[data\/IdnaTest\.txt\:3807\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}．SS\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ss\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3．SS\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3808\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}．ss\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ss\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3．ss\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3809\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᡬ\x{1BF3}．Ss\x{0A4D}\x{0FBC}", %p)},	"ᡬ\x{1BF3}.ss\x{0A4D}\x{0FBC}",	"to_unicode\(\'ᡬ\\u1BF3．Ss\\u0A4D\\u0FBC\'\)\ \[data\/IdnaTest\.txt\:3810\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۴≮\x{200C}｡\x{116B2}\x{17B4}", %p)},	undef,	"to_unicode\(\'۴≮\\u200C｡\\uD805\\uDEB2\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3811\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۴≮\x{200C}｡\x{116B2}\x{17B4}", %p)},	undef,	"to_unicode\(\'۴≮\\u200C｡\\uD805\\uDEB2\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3812\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۴<\x{0338}\x{200C}｡\x{116B2}\x{17B4}", %p)},	undef,	"to_unicode\(\'۴\<\\u0338\\u200C｡\\uD805\\uDEB2\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3813\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۴<\x{0338}\x{200C}｡\x{116B2}\x{17B4}", %p)},	undef,	"to_unicode\(\'۴\<\\u0338\\u200C｡\\uD805\\uDEB2\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3814\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۴≮\x{200C}。\x{116B2}\x{17B4}", %p)},	undef,	"to_unicode\(\'۴≮\\u200C。\\uD805\\uDEB2\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3815\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۴≮\x{200C}。\x{116B2}\x{17B4}", %p)},	undef,	"to_unicode\(\'۴≮\\u200C。\\uD805\\uDEB2\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3816\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۴<\x{0338}\x{200C}。\x{116B2}\x{17B4}", %p)},	undef,	"to_unicode\(\'۴\<\\u0338\\u200C。\\uD805\\uDEB2\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3817\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۴<\x{0338}\x{200C}。\x{116B2}\x{17B4}", %p)},	undef,	"to_unicode\(\'۴\<\\u0338\\u200C。\\uD805\\uDEB2\\u17B4\'\)\ throws\ error\ P1\ V6\ V5\ C1\ \[data\/IdnaTest\.txt\:3818\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}≯︒\x{B23D5}．Ⴀ", %p)},	undef,	"to_unicode\(\'\\u06C5≯︒\\uDA88\\uDFD5．Ⴀ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3819\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}>\x{0338}︒\x{B23D5}．Ⴀ", %p)},	undef,	"to_unicode\(\'\\u06C5\>\\u0338︒\\uDA88\\uDFD5．Ⴀ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3820\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}≯。\x{B23D5}.Ⴀ", %p)},	undef,	"to_unicode\(\'\\u06C5≯。\\uDA88\\uDFD5\.Ⴀ\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3821\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}>\x{0338}。\x{B23D5}.Ⴀ", %p)},	undef,	"to_unicode\(\'\\u06C5\>\\u0338。\\uDA88\\uDFD5\.Ⴀ\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3822\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}>\x{0338}。\x{B23D5}.ⴀ", %p)},	undef,	"to_unicode\(\'\\u06C5\>\\u0338。\\uDA88\\uDFD5\.ⴀ\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3823\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}≯。\x{B23D5}.ⴀ", %p)},	undef,	"to_unicode\(\'\\u06C5≯。\\uDA88\\uDFD5\.ⴀ\'\)\ throws\ error\ P1\ V6\ B3\ \[data\/IdnaTest\.txt\:3824\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}>\x{0338}︒\x{B23D5}．ⴀ", %p)},	undef,	"to_unicode\(\'\\u06C5\>\\u0338︒\\uDA88\\uDFD5．ⴀ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3825\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{06C5}≯︒\x{B23D5}．ⴀ", %p)},	undef,	"to_unicode\(\'\\u06C5≯︒\\uDA88\\uDFD5．ⴀ\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3826\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{E0121}．-\x{2DF9}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD21．\-\\u2DF9\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3827\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E0121}.-\x{2DF9}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD21\.\-\\u2DF9\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:3828\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᵬ\x{0DD3}．핒🄃⒈\x{A74BE}", %p)},	undef,	"to_unicode\(\'ᵬ\\u0DD3．핒🄃⒈\\uDA5D\\uDCBE\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3829\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᵬ\x{0DD3}．핒🄃⒈\x{A74BE}", %p)},	undef,	"to_unicode\(\'ᵬ\\u0DD3．핒🄃⒈\\uDA5D\\uDCBE\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3830\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᵬ\x{0DD3}.핒2,1.\x{A74BE}", %p)},	undef,	"to_unicode\(\'ᵬ\\u0DD3\.핒2\,1\.\\uDA5D\\uDCBE\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3831\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ᵬ\x{0DD3}.핒2,1.\x{A74BE}", %p)},	undef,	"to_unicode\(\'ᵬ\\u0DD3\.핒2\,1\.\\uDA5D\\uDCBE\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3832\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς\x{111C0}₆．\x{10E61}", %p)},	undef,	"to_unicode\(\'ς\\uD804\\uDDC0₆．\\uD803\\uDE61\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3833\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("ς\x{111C0}6.\x{10E61}", %p)},	undef,	"to_unicode\(\'ς\\uD804\\uDDC06\.\\uD803\\uDE61\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3834\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ\x{111C0}6.\x{10E61}", %p)},	undef,	"to_unicode\(\'Σ\\uD804\\uDDC06\.\\uD803\\uDE61\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3835\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ\x{111C0}6.\x{10E61}", %p)},	undef,	"to_unicode\(\'σ\\uD804\\uDDC06\.\\uD803\\uDE61\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3836\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("Σ\x{111C0}₆．\x{10E61}", %p)},	undef,	"to_unicode\(\'Σ\\uD804\\uDDC0₆．\\uD803\\uDE61\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3837\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("σ\x{111C0}₆．\x{10E61}", %p)},	undef,	"to_unicode\(\'σ\\uD804\\uDDC0₆．\\uD803\\uDE61\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3838\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1039}\x{200C}₇\x{200D}.\x{1D169}\x{1E902}\x{0602}", %p)},	undef,	"to_unicode\(\'\\u1039\\u200C₇\\u200D\.\\uD834\\uDD69\\uD83A\\uDD02\\u0602\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3839\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1039}\x{200C}₇\x{200D}.\x{1D169}\x{1E902}\x{0602}", %p)},	undef,	"to_unicode\(\'\\u1039\\u200C₇\\u200D\.\\uD834\\uDD69\\uD83A\\uDD02\\u0602\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3840\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1039}\x{200C}7\x{200D}.\x{1D169}\x{1E902}\x{0602}", %p)},	undef,	"to_unicode\(\'\\u1039\\u200C7\\u200D\.\\uD834\\uDD69\\uD83A\\uDD02\\u0602\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3841\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1039}\x{200C}7\x{200D}.\x{1D169}\x{1E902}\x{0602}", %p)},	undef,	"to_unicode\(\'\\u1039\\u200C7\\u200D\.\\uD834\\uDD69\\uD83A\\uDD02\\u0602\'\)\ throws\ error\ P1\ V5\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3842\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E0CD3}。\x{3C4F0}\x{07CD}", %p)},	undef,	"to_unicode\(\'\\uDB43\\uDCD3。\\uD8B1\\uDCF0\\u07CD\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:3843\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1EF33}𥂚。\x{9FCF1}", %p)},	undef,	"to_unicode\(\'\\uD83B\\uDF33𥂚。\\uDA3F\\uDCF1\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:3844\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6C}\x{0902}\x{0849}。ς\x{BE839}\x{E0CCC}\x{17B5}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C\\u0902\\u0849。ς\\uDABA\\uDC39\\uDB43\\uDCCC\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3845\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6C}\x{0902}\x{0849}。Σ\x{BE839}\x{E0CCC}\x{17B5}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C\\u0902\\u0849。Σ\\uDABA\\uDC39\\uDB43\\uDCCC\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3846\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E6C}\x{0902}\x{0849}。σ\x{BE839}\x{E0CCC}\x{17B5}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE6C\\u0902\\u0849。σ\\uDABA\\uDC39\\uDB43\\uDCCC\\u17B5\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3847\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{1EA1B}\x{0683}\x{193B}。\x{11046}⒕", %p)},	undef,	"to_unicode\(\'\-\\uD83A\\uDE1B\\u0683\\u193B。\\uD804\\uDC46⒕\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3848\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-\x{1EA1B}\x{0683}\x{193B}。\x{11046}14.", %p)},	undef,	"to_unicode\(\'\-\\uD83A\\uDE1B\\u0683\\u193B。\\uD804\\uDC4614\.\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ \[data\/IdnaTest\.txt\:3849\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}🔲｡\x{E0757}≮\x{10C84}", %p)},	undef,	"to_unicode\(\'\\u200C🔲｡\\uDB41\\uDF57≮\\uD803\\uDC84\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3850\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}🔲｡\x{E0757}≮\x{10C84}", %p)},	undef,	"to_unicode\(\'\\u200C🔲｡\\uDB41\\uDF57≮\\uD803\\uDC84\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3851\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}🔲｡\x{E0757}<\x{0338}\x{10C84}", %p)},	undef,	"to_unicode\(\'\\u200C🔲｡\\uDB41\\uDF57\<\\u0338\\uD803\\uDC84\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3852\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}🔲｡\x{E0757}<\x{0338}\x{10C84}", %p)},	undef,	"to_unicode\(\'\\u200C🔲｡\\uDB41\\uDF57\<\\u0338\\uD803\\uDC84\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3853\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}🔲。\x{E0757}≮\x{10C84}", %p)},	undef,	"to_unicode\(\'\\u200C🔲。\\uDB41\\uDF57≮\\uD803\\uDC84\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3854\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}🔲。\x{E0757}≮\x{10C84}", %p)},	undef,	"to_unicode\(\'\\u200C🔲。\\uDB41\\uDF57≮\\uD803\\uDC84\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3855\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}🔲。\x{E0757}<\x{0338}\x{10C84}", %p)},	undef,	"to_unicode\(\'\\u200C🔲。\\uDB41\\uDF57\<\\u0338\\uD803\\uDC84\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3856\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}🔲。\x{E0757}<\x{0338}\x{10C84}", %p)},	undef,	"to_unicode\(\'\\u200C🔲。\\uDB41\\uDF57\<\\u0338\\uD803\\uDC84\'\)\ throws\ error\ P1\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3857\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("⒈【\x{A2308}．𝟲\x{95459}", %p)},	undef,	"to_unicode\(\'⒈【\\uDA48\\uDF08．𝟲\\uDA15\\uDC59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3858\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("1.【\x{A2308}.6\x{95459}", %p)},	undef,	"to_unicode\(\'1\.【\\uDA48\\uDF08\.6\\uDA15\\uDC59\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3859\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B71}\x{08A2}\x{FBE5}.\x{0667}\x{2DFB}", %p)},	undef,	"to_unicode\(\'\\u1B71\\u08A2\\uFBE5\.\\u0667\\u2DFB\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3860\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B71}\x{08A2}\x{06D0}.\x{0667}\x{2DFB}", %p)},	undef,	"to_unicode\(\'\\u1B71\\u08A2\\u06D0\.\\u0667\\u2DFB\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:3861\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ς．\x{A9C0}\x{103A}", %p)},	undef,	"to_unicode\(\'ς．\\uA9C0\\u103A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3862\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ς.\x{A9C0}\x{103A}", %p)},	undef,	"to_unicode\(\'ς\.\\uA9C0\\u103A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3863\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ.\x{A9C0}\x{103A}", %p)},	undef,	"to_unicode\(\'Σ\.\\uA9C0\\u103A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3864\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ.\x{A9C0}\x{103A}", %p)},	undef,	"to_unicode\(\'σ\.\\uA9C0\\u103A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3865\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("Σ．\x{A9C0}\x{103A}", %p)},	undef,	"to_unicode\(\'Σ．\\uA9C0\\u103A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3866\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("σ．\x{A9C0}\x{103A}", %p)},	undef,	"to_unicode\(\'σ．\\uA9C0\\u103A\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:3867\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E013D}\x{200C}≯\x{10EC3}．\x{081B}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD3D\\u200C≯\\uD803\\uDEC3．\\u081B\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3868\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E013D}\x{200C}≯\x{10EC3}．\x{081B}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD3D\\u200C≯\\uD803\\uDEC3．\\u081B\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3869\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E013D}\x{200C}>\x{0338}\x{10EC3}．\x{081B}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD3D\\u200C\>\\u0338\\uD803\\uDEC3．\\u081B\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3870\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E013D}\x{200C}>\x{0338}\x{10EC3}．\x{081B}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD3D\\u200C\>\\u0338\\uD803\\uDEC3．\\u081B\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3871\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E013D}\x{200C}≯\x{10EC3}.\x{081B}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD3D\\u200C≯\\uD803\\uDEC3\.\\u081B\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3872\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E013D}\x{200C}≯\x{10EC3}.\x{081B}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD3D\\u200C≯\\uD803\\uDEC3\.\\u081B\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3873\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E013D}\x{200C}>\x{0338}\x{10EC3}.\x{081B}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD3D\\u200C\>\\u0338\\uD803\\uDEC3\.\\u081B\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3874\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{E013D}\x{200C}>\x{0338}\x{10EC3}.\x{081B}", %p)},	undef,	"to_unicode\(\'\\uDB40\\uDD3D\\u200C\>\\u0338\\uD803\\uDEC3\.\\u081B\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:3875\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("羚｡≯", %p)},	undef,	"to_unicode\(\'羚｡≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3876\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚｡>\x{0338}", %p)},	undef,	"to_unicode\(\'羚｡\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3877\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚。≯", %p)},	undef,	"to_unicode\(\'羚。≯\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3878\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("羚。>\x{0338}", %p)},	undef,	"to_unicode\(\'羚。\>\\u0338\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3879\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A3F}\x{1759}．ꡦ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE3F\\u1759．ꡦ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3880\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10A3F}\x{1759}.ꡦ", %p)},	undef,	"to_unicode\(\'\\uD802\\uDE3F\\u1759\.ꡦ\'\)\ throws\ error\ P1\ V5\ V6\ \[data\/IdnaTest\.txt\:3881\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}｡\x{10E6D}ҠჀ²", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D｡\\uD803\\uDE6DҠჀ²\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3882\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}｡\x{10E6D}ҠჀ²", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D｡\\uD803\\uDE6DҠჀ²\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3883\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}。\x{10E6D}ҠჀ2", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D。\\uD803\\uDE6DҠჀ2\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3884\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}。\x{10E6D}ҠჀ2", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D。\\uD803\\uDE6DҠჀ2\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3885\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}。\x{10E6D}ҡⴠ2", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D。\\uD803\\uDE6Dҡⴠ2\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3886\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}。\x{10E6D}ҡⴠ2", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D。\\uD803\\uDE6Dҡⴠ2\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3887\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}。\x{10E6D}Ҡⴠ2", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D。\\uD803\\uDE6DҠⴠ2\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3888\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}。\x{10E6D}Ҡⴠ2", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D。\\uD803\\uDE6DҠⴠ2\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3889\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}｡\x{10E6D}ҡⴠ²", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D｡\\uD803\\uDE6Dҡⴠ²\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3890\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}｡\x{10E6D}ҡⴠ²", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D｡\\uD803\\uDE6Dҡⴠ²\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3891\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}｡\x{10E6D}Ҡⴠ²", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D｡\\uD803\\uDE6DҠⴠ²\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3892\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{7ADC9}\x{0FAE}\x{200D}｡\x{10E6D}Ҡⴠ²", %p)},	undef,	"to_unicode\(\'\\uD9AB\\uDDC9\\u0FAE\\u200D｡\\uD803\\uDE6DҠⴠ²\'\)\ throws\ error\ P1\ V6\ C2\ B1\ \[data\/IdnaTest\.txt\:3893\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("ᠴ。\x{10E6D}\x{A6F1}", %p)},	undef,	"to_unicode\(\'ᠴ。\\uD803\\uDE6D\\uA6F1\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:3894\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{45121}\x{0B4D}｡\x{10E7A}\x{C1512}\x{0CCD}ß", %p)},	undef,	"to_unicode\(\'\\uD8D4\\uDD21\\u0B4D｡\\uD803\\uDE7A\\uDAC5\\uDD12\\u0CCDß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3895\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{45121}\x{0B4D}。\x{10E7A}\x{C1512}\x{0CCD}ß", %p)},	undef,	"to_unicode\(\'\\uD8D4\\uDD21\\u0B4D。\\uD803\\uDE7A\\uDAC5\\uDD12\\u0CCDß\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3896\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{45121}\x{0B4D}。\x{10E7A}\x{C1512}\x{0CCD}SS", %p)},	undef,	"to_unicode\(\'\\uD8D4\\uDD21\\u0B4D。\\uD803\\uDE7A\\uDAC5\\uDD12\\u0CCDSS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3897\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{45121}\x{0B4D}。\x{10E7A}\x{C1512}\x{0CCD}ss", %p)},	undef,	"to_unicode\(\'\\uD8D4\\uDD21\\u0B4D。\\uD803\\uDE7A\\uDAC5\\uDD12\\u0CCDss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3898\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{45121}\x{0B4D}。\x{10E7A}\x{C1512}\x{0CCD}Ss", %p)},	undef,	"to_unicode\(\'\\uD8D4\\uDD21\\u0B4D。\\uD803\\uDE7A\\uDAC5\\uDD12\\u0CCDSs\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3899\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{45121}\x{0B4D}｡\x{10E7A}\x{C1512}\x{0CCD}SS", %p)},	undef,	"to_unicode\(\'\\uD8D4\\uDD21\\u0B4D｡\\uD803\\uDE7A\\uDAC5\\uDD12\\u0CCDSS\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3900\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{45121}\x{0B4D}｡\x{10E7A}\x{C1512}\x{0CCD}ss", %p)},	undef,	"to_unicode\(\'\\uD8D4\\uDD21\\u0B4D｡\\uD803\\uDE7A\\uDAC5\\uDD12\\u0CCDss\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3901\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{45121}\x{0B4D}｡\x{10E7A}\x{C1512}\x{0CCD}Ss", %p)},	undef,	"to_unicode\(\'\\uD8D4\\uDD21\\u0B4D｡\\uD803\\uDE7A\\uDAC5\\uDD12\\u0CCDSs\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3902\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E72}\x{9D467}\x{036C}.⸖︒≠", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE72\\uDA35\\uDC67\\u036C\.⸖︒≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3903\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E72}\x{9D467}\x{036C}.⸖︒=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE72\\uDA35\\uDC67\\u036C\.⸖︒\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3904\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E72}\x{9D467}\x{036C}.⸖。≠", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE72\\uDA35\\uDC67\\u036C\.⸖。≠\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3905\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{10E72}\x{9D467}\x{036C}.⸖。=\x{0338}", %p)},	undef,	"to_unicode\(\'\\uD803\\uDE72\\uDA35\\uDC67\\u036C\.⸖。\=\\u0338\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3906\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏫\x{CEDF8}ỗ⒈．\x{37B57}\x{B8390}⧸⒌", %p)},	undef,	"to_unicode\(\'🏫\\uDAFB\\uDDF8ỗ⒈．\\uD89E\\uDF57\\uDAA0\\uDF90⧸⒌\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3907\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏫\x{CEDF8}o\x{0302}\x{0303}⒈．\x{37B57}\x{B8390}⧸⒌", %p)},	undef,	"to_unicode\(\'🏫\\uDAFB\\uDDF8o\\u0302\\u0303⒈．\\uD89E\\uDF57\\uDAA0\\uDF90⧸⒌\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3908\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏫\x{CEDF8}ỗ1..\x{37B57}\x{B8390}⧸5.", %p)},	undef,	"to_unicode\(\'🏫\\uDAFB\\uDDF8ỗ1\.\.\\uD89E\\uDF57\\uDAA0\\uDF90⧸5\.\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3909\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏫\x{CEDF8}o\x{0302}\x{0303}1..\x{37B57}\x{B8390}⧸5.", %p)},	undef,	"to_unicode\(\'🏫\\uDAFB\\uDDF8o\\u0302\\u03031\.\.\\uD89E\\uDF57\\uDAA0\\uDF90⧸5\.\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3910\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏫\x{CEDF8}O\x{0302}\x{0303}1..\x{37B57}\x{B8390}⧸5.", %p)},	undef,	"to_unicode\(\'🏫\\uDAFB\\uDDF8O\\u0302\\u03031\.\.\\uD89E\\uDF57\\uDAA0\\uDF90⧸5\.\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3911\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏫\x{CEDF8}Ỗ1..\x{37B57}\x{B8390}⧸5.", %p)},	undef,	"to_unicode\(\'🏫\\uDAFB\\uDDF8Ỗ1\.\.\\uD89E\\uDF57\\uDAA0\\uDF90⧸5\.\'\)\ throws\ error\ P1\ V6\ A4_2\ \[data\/IdnaTest\.txt\:3912\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏫\x{CEDF8}O\x{0302}\x{0303}⒈．\x{37B57}\x{B8390}⧸⒌", %p)},	undef,	"to_unicode\(\'🏫\\uDAFB\\uDDF8O\\u0302\\u0303⒈．\\uD89E\\uDF57\\uDAA0\\uDF90⧸⒌\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3913\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("🏫\x{CEDF8}Ỗ⒈．\x{37B57}\x{B8390}⧸⒌", %p)},	undef,	"to_unicode\(\'🏫\\uDAFB\\uDDF8Ỗ⒈．\\uD89E\\uDF57\\uDAA0\\uDF90⧸⒌\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3914\]") or ($@ and diag($@)); }
is(eval{uts46_to_unicode("\x{200D}｡ꡏ", %p)},	undef,	"to_unicode\(\'\\u200D｡ꡏ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3915\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}｡ꡏ", %p)},	undef,	"to_unicode\(\'\\u200D｡ꡏ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3916\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ꡏ", %p)},	undef,	"to_unicode\(\'\\u200D。ꡏ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3917\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{200D}。ꡏ", %p)},	undef,	"to_unicode\(\'\\u200D。ꡏ\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:3918\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--oc9a", %p)},	"ꡏ",	"to_unicode\(\'xn\-\-oc9a\'\)\ \[data\/IdnaTest\.txt\:3919\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡏ", %p)},	"ꡏ",	"to_unicode\(\'ꡏ\'\)\ \[data\/IdnaTest\.txt\:3920\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("\x{E01C5}ꡉ.\x{06FA}", %p)},	"ꡉ.\x{06FA}",	"to_unicode\(\'\\uDB40\\uDDC5ꡉ\.\\u06FA\'\)\ \[data\/IdnaTest\.txt\:3921\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("xn--ic9a.xn--nmb", %p)},	"ꡉ.\x{06FA}",	"to_unicode\(\'xn\-\-ic9a\.xn\-\-nmb\'\)\ \[data\/IdnaTest\.txt\:3922\]") or ($@ and diag($@));
is(eval{uts46_to_unicode("ꡉ.\x{06FA}", %p)},	"ꡉ.\x{06FA}",	"to_unicode\(\'ꡉ\.\\u06FA\'\)\ \[data\/IdnaTest\.txt\:3923\]") or ($@ and diag($@));
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B80}\x{200C}-。\x{7CC35}ß", %p)},	undef,	"to_unicode\(\'\\u1B80\\u200C\-。\\uD9B3\\uDC35ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3924\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B80}\x{200C}-。\x{7CC35}ß", %p)},	undef,	"to_unicode\(\'\\u1B80\\u200C\-。\\uD9B3\\uDC35ß\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3925\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B80}\x{200C}-。\x{7CC35}SS", %p)},	undef,	"to_unicode\(\'\\u1B80\\u200C\-。\\uD9B3\\uDC35SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3926\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B80}\x{200C}-。\x{7CC35}SS", %p)},	undef,	"to_unicode\(\'\\u1B80\\u200C\-。\\uD9B3\\uDC35SS\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3927\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B80}\x{200C}-。\x{7CC35}ss", %p)},	undef,	"to_unicode\(\'\\u1B80\\u200C\-。\\uD9B3\\uDC35ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3928\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B80}\x{200C}-。\x{7CC35}ss", %p)},	undef,	"to_unicode\(\'\\u1B80\\u200C\-。\\uD9B3\\uDC35ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3929\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B80}\x{200C}-。\x{7CC35}Ss", %p)},	undef,	"to_unicode\(\'\\u1B80\\u200C\-。\\uD9B3\\uDC35Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3930\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{1B80}\x{200C}-。\x{7CC35}Ss", %p)},	undef,	"to_unicode\(\'\\u1B80\\u200C\-。\\uD9B3\\uDC35Ss\'\)\ throws\ error\ P1\ V3\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:3931\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ς⩕𝟶.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200Cς⩕𝟶\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3932\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ς⩕𝟶.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200Cς⩕𝟶\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3933\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ς⩕0.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200Cς⩕0\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3934\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}ς⩕0.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200Cς⩕0\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3935\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}Σ⩕0.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200CΣ⩕0\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3936\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}Σ⩕0.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200CΣ⩕0\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3937\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}σ⩕0.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200Cσ⩕0\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3938\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}σ⩕0.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200Cσ⩕0\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3939\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}Σ⩕𝟶.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200CΣ⩕𝟶\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3940\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}Σ⩕𝟶.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200CΣ⩕𝟶\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3941\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}σ⩕𝟶.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200Cσ⩕𝟶\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3942\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{200C}σ⩕𝟶.\x{06E2}\x{A767E}\x{0729}", %p)},	undef,	"to_unicode\(\'\\u200Cσ⩕𝟶\.\\u06E2\\uDA5D\\uDE7E\\u0729\'\)\ throws\ error\ P1\ V5\ V6\ C1\ B1\ \[data\/IdnaTest\.txt\:3943\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("-.\x{1E888}", %p)},	undef,	"to_unicode\(\'\-\.\\uD83A\\uDC88\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:3944\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{5B1FD}\x{0773}.\x{302D}\x{07D3}", %p)},	undef,	"to_unicode\(\'\\uD92C\\uDDFD\\u0773\.\\u302D\\u07D3\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:3945\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("\x{0FE6}ꡲ\x{182D3}.ᠤ", %p)},	undef,	"to_unicode\(\'\\u0FE6ꡲ\\uD820\\uDED3\.ᠤ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:3946\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷\x{89430}\x{077B}ß。\x{0766}", %p)},	undef,	"to_unicode\(\'۷\\uD9E5\\uDC30\\u077Bß。\\u0766\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3947\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷\x{89430}\x{077B}SS。\x{0766}", %p)},	undef,	"to_unicode\(\'۷\\uD9E5\\uDC30\\u077BSS。\\u0766\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3948\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷\x{89430}\x{077B}ss。\x{0766}", %p)},	undef,	"to_unicode\(\'۷\\uD9E5\\uDC30\\u077Bss。\\u0766\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3949\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("۷\x{89430}\x{077B}Ss。\x{0766}", %p)},	undef,	"to_unicode\(\'۷\\uD9E5\\uDC30\\u077BSs。\\u0766\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:3950\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ≮．\x{08A4}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ≮．\\u08A4ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3951\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ≮．\x{08A4}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ≮．\\u08A4ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3952\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ<\x{0338}．\x{08A4}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ\<\\u0338．\\u08A4ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3953\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ<\x{0338}．\x{08A4}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ\<\\u0338．\\u08A4ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3954\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ≮.\x{08A4}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ≮\.\\u08A4ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3955\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ≮.\x{08A4}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ≮\.\\u08A4ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3956\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ<\x{0338}.\x{08A4}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ\<\\u0338\.\\u08A4ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3957\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ<\x{0338}.\x{08A4}ß-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ\<\\u0338\.\\u08A4ß\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3958\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ<\x{0338}.\x{08A4}SS-\x{200D}", %p)},	undef,	"to_unicode\(\'㸳ꡡ\<\\u0338\.\\u08A4SS\-\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:3959\]") or ($@ and diag($@)); }
TODO: { local $TODO = "test file was generated on perl 5.012004, which is too old"; is(eval{uts46_to_unicode("㸳ꡡ<\x{0338}.\x{08A4}SS-\x{200D}", %p)},	undef