package Bundle::MetaSyntactic;

our $VERSION = '1.025';

'whack_eth';

__END__

=head1 NAME

Bundle::MetaSyntactic - All Acme::MetaSyntactic themes

=head1 SYNOPSIS

    perl -MCPAN -e 'install Bundle::MetaSyntactic'

=head1 DESCRIPTION

L<Acme::MetaSyntactic> is a module designed to fill all your metasyntactic
needs. There was a weekly update with new themes on CPAN between January
15, 2005 and November 6, 2006.

Since version 0.99, the weekly uploads of the module have stopped,
while I took some rest. I've also been looking for a better way to distribute
the core modules and the themes themselves.

However, some users of L<Acme::MetaSyntactic> desperately needed new
themes to be added, and grew tired of waiting for me. So, in a JFDI way,
they started to upload their own themes on CPAN.

On May 7, 2012, after a hiatus of five and a half years,
L<Acme::MetaSyntactic> is back, in a shiny version 1.000.
The main C<Acme-MetaSyntactic> distribution contains the core modules
and a single theme, while all "historical" themes now live in the
C<Acme-MetaSyntactic-Themes> distribution.

The L<Test::MetaSyntactic> module included in the main distribution
aims at simplifying the test and distribution of new themes by
individual authors.

This bundle brings you all the official and not-so-official
L<Acme::MetaSyntactic> themes, in a single command (see the L<SYNOPSIS>).

=head1 CONTENTS

Acme::MetaSyntactic 1.000 - Themed metasyntactic variables names

Acme::MetaSyntactic::Themes 1.000 - The original Acme::MetaSyntactic themes

Acme::MetaSyntactic::Themes::Abigail - More themes by Abigail (ABIGAIL)

Acme::MetaSyntactic::buzzwords - Pointy-haired boss lingo (JQUELIN)

Acme::MetaSyntactic::daleks - EXTERMINATE! EXTERMINATE! EXTERMINATE! (SAPER)

Acme::MetaSyntactic::errno - The Errno theme (BOOK)

Acme::MetaSyntactic::morning_musume - The Mumusu theme (ELBEHO)

Acme::MetaSyntactic::nethack - The largest time waster in the world of *nix (ELLIOTJS)

Acme::MetaSyntactic::soviet - NATO codenames for Soviet-designed equipment (JFORGET)

Acme::MetaSyntactic::vim - The vim theme (ELLIOTJS)

=head1 AUTHOR

Philippe Bruhat (BooK), <book@cpan.org>

=head1 COPYRIGHT

Copyright 2005-2012 Philippe Bruhat (BooK), All Rights Reserved.

=head1 LICENSE

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

