package Acme::MetaSyntactic::currency;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::currency - The currency theme

=head1 DESCRIPTION

The official three-letter currency codes, as defined by ISO 4217.

The list was taken from the ISO web site:
L<http://www.iso.org/iso/en/prods-services/popstds/currencycodeslist.html>.

=head1 CONTRIBUTOR

Philippe "BooK" Bruhat.

Introduced in version 0.36, published (one day late) on August 23, 2005.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
AED
AFN
ALL
AMD
ANG
AOA
ARS
AUD
AWG
AZM
BAM
BBD
BDT
BGN
BHD
BIF
BMD
BRL
BSD
BWP
BYR
BZD
CAD
CDF
CHF
CNY
CRC
CUP
CVE
CYP
CZK
DJF
DKK
DOP
DZD
EEK
EGP
ERN
ETB
EUR
FJD
FKP
GBP
GEL
GHC
GIP
GMD
GNF
GTQ
GYD
HKD
HNL
HRK
HUF
IDR
ILS
INR
IQD
IRR
ISK
JMD
JOD
JPY
KES
KGS
KHR
KMF
KPW
KRW
KWD
KYD
KZT
LAK
LBP
LKR
LRD
LTL
LVL
LYD
MAD
MDL
MKD
MMK
MNT
MOP
MTL
MUR
MWK
MYR
MZM
NGN
NIO
NOK
NPR
NZD
OMR
PEN
PGK
PHP
PKR
PLN
PYG
QAR
RUB
RWF
SAR
SBD
SCR
SDD
SEK
SGD
SHP
SIT
SKK
SLL
SOS
SRD
STD
SYP
SZL
THB
TJS
TMM
TND
TOP
TTD
TWD
TZS
UAH
UGX
USD
UYU
UZS
VEB
VND
VUV
WST
XAF
XAG
XAU
XBA
XBB
XBC
XBD
XCD
XDR
XFO
XFU
XOF
XPD
XPF
XPT
XTS
XXX
YER
ZAR
ZMK
ZWD
