#!/usr/bin/env perl

use strict;
use warnings;

use utf8;

use lib 'blib/lib';

use Test::More;
use Test2::Plugin::UTF8;

use File::Temp;
use Cwd;
use FindBin;
use File::Basename;
use Encode;
use Data::Roundtrip qw/perl2dump no-unicode-escape-permanently/;

use Automate::Animate::FFmpeg;

our $VERSION = '0.06';

my $curdir = Cwd::abs_path($FindBin::Bin);

my $anim_outfile = 'abc';
my $VERBOSITY = 10;

my @inpimages = (
	File::Spec->catfile($curdir, 't-data', 'images', 'blue.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'κίτρινο.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'red.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'green.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'Περισσότερα', 'πράσινο.png'),
	File::Spec->catfile($curdir, 't-data', 'images', 'Περισσότερα', 'Κόκκινο.png'),
);
my $aaFF = Automate::Animate::FFmpeg->new({
	'verbosity' => $VERBOSITY
});
ok(defined $aaFF, 'Automate::Animate::FFmpeg->new()'." : called and got defined result.") or BAIL_OUT;

is($aaFF->input_pattern(['*.png']), 1, 'input_pattern()'." : called and got good result.");
is_deeply(
	{ map { $_ => 1 } @{ $aaFF->input_images() } },
	{ map { $_ => 1 } @inpimages },
	'input_pattern()'." : called and got the images expected."
);
$aaFF->clear_input_images();

is($aaFF->input_pattern(['*.png', File::Spec->catdir($curdir, 't-data')]), 1, 'input_pattern()'." : called and got good result.");
is_deeply(
	{ map { $_ => 1 } @{ $aaFF->input_images() } },
	{ map { $_ => 1 } @inpimages },
	'input_pattern()'." : called and got the images expected."
);
$aaFF->clear_input_images();

is($aaFF->input_pattern([qw!regex(/.+?\.PNG$/i)!, File::Spec->catdir($curdir, 't-data')]), 1, 'input_pattern()'." : called and got good result.");
is_deeply(
	{ map { $_ => 1 } @{ $aaFF->input_images() } },
	{ map { $_ => 1 } @inpimages },
	'input_pattern()'." : called and got the images expected."
);
$aaFF->clear_input_images();

is($aaFF->input_patterns([
  [qw!regex(/.+?\.PNG$/i)!, File::Spec->catdir($curdir, 't-data')],
  [qw!regex(/.+?\.JPG$/i)!, File::Spec->catdir($curdir, 't-data')],
]), 1, 'input_pattern()'." : called and got good result.");
is_deeply(
	{ map { $_ => 1 } @{ $aaFF->input_images() } },
	{ map { $_ => 1 } (@inpimages,File::Spec->catfile($curdir, 't-data', 'images', 'green.jpg')) },
	'input_pattern()'." : called and got the images expected."
);
$aaFF->clear_input_images();

# END
done_testing;
