package Catalyst::Helper::Controller::ADVEL::Multi;

# ADVEL.pm
# Copyright(c) 2005 Shota Takayama. All rights reserved.
# Written by Shota Takayama <takayama@shanon.co.jp>.
# First cut on 2005-11-17 17:46:36 JST.
# Time-stamp: "2005-12-12 19:49:20 takayama" last modified.

my ($Revision) = '$Id: Multi.pm,v 1.3 2006/01/07 09:56:21 shimizu Exp $';
($VERSION) = $Revision =~ /v ([0-9.]+)/;
use vars qw($VERSION);
use strict;
use warnings;

use Path::Class;

=head1 NAME

Catalyst::Helper::Controller::ADVEL - Helper for Support Multi Class ADVEL for One Page (Scaffolding)

=head1 SYNOPSIS

    # Imagine you want to generate a scaffolding controller MyApp::C::SomeTable
    # for a CDBI table class MyApp::M::CDBI::SomeTable
    script/myapp_create.pl controller SomeTable ADVEL::Multi CDBI::SomeTable

=head1 DESCRIPTION

Helper for Support Multi Class ADVEL for One Page (Scaffolding).

Templates area TT so you'll need a TT View Component and forward in
your end action too.

Note that you have to add these lines to your CDBI class...

    use Class::DBI::AsForm;
    use Class::DBI::FromForm;

for L<Catalyst::Model::CDBI> you can do that  by adding this

    additional_base_classes => [qw/Class::DBI::AsForm Class::DBI::FromForm/],   

to the component config. Also, change your application class like this:

    use Catalyst qw/-Debug FormValidator/;

Also, note that the scaffolding uses L<Template::Plugin::Class>, so it will
be a requirement for you application as well.

This Helper's template does'nt output <HTML> tag.
set PRE_PROCESS and POST_PROCESS for your Catalyst config.

ex)
    MyApp->config({
        name     => 'MyApp',
        root     => MyApp->path_to('root');,
    });
=head1 METHODS

=over 4

=item mk_compclass

=cut

sub mk_compclass {
    my ( $self, $helper, $table_class ) = @_;
    $helper->{table_class} = $helper->{app} . '::Model::' . $table_class;
    my $file = $helper->{file};
    my $dir  = dir( $helper->{base}, 'root', $helper->{prefix} );

    #$helper->mk_dir($dir);
    $helper->render_file( 'compclass', $file );
}

=back

=head1 AUTHOR

Shota Takayama

=head1 LICENSE

This library is free software . You can redistribute it and/or modify
it under the same terms as perl itself.

=cut

1;

__DATA__

__compclass__
package [% class %];

use strict;
use warnings;
use base 'Catalyst::Controller::ADVEL::Multi';

=head1 NAME

[% class %] - Scaffolding Controller Component

=head1 SYNOPSIS

See L<[% app %]>

=head1 DESCRIPTION

Scaffolding Controller Component.

=head1 METHODS

=cut

############################################################
# 󥹥åѥХå
# $actions ARRAY REFǥޤ
# ɸΥؤȤ˻ѤƤ
############################################################
# __PACKAGE__->add_trigger(set_actions => \&set_actions);
# sub set_actions {
#     my $self = shift;
#     my $c = shift;
#     my $actions = shift;
# }

############################################################
# ѥХå
############################################################

# ֺǽ˸ƤФȥꥬ
# inputäľ˽򶴤ߤˡ
# __PACKAGE__->add_trigger(input_before => \&input_before);
# sub input_before {
#     my $self = shift;
#     my $c = shift;
# }

# ե˥ǡͤȤ˸ƤФȥꥬ
# __PACKAGE__->add_trigger(input_after_gen_first_data => \&input_after_gen_first_data);
# sub input_after_gen_first_data {
#     my $self = shift;
#     my $c = shift;
# }

# 顼åľ˸ƤФȥꥬ
# check_all_errorsǤ$hashȤåޤ
# __PACKAGE__->add_trigger(input_before_check_errors => \&input_before_check_errors);
# sub input_before_check_errors {
#     my $self = shift;
#     my $c = shift;
#     my $hash = shift;
# }

# Υ˰ܤäƤɤȽꤷ˸ƤФȥꥬ
# ɸǤϥ顼å̤ä鼡˹ԤΤǡ
# εưѤ
# __PACKAGE__->add_trigger(input_check => \&input_check);
# sub input_check {
#     my $self = shift;
#     my $c = shift;
#     # 򵶤ˤȼβ̤عԤʤ
#     $c->session->{'ADVEL'}->{$c->namespace()}->{'input'} = 0;
# }

# modelretrieve˸ƤФȥꥬ
# retrieveȤؤ
# $c->stash->{'model'}$c->stash->{'form_data'}񤭴Ƥ
# __PACKAGE__->add_trigger(input_after_retrieve => \&input_after_retrieve);
# sub input_after_retrieve {
#     my $self = shift;
#     my $c = shift;
# }

# reqͤ˸ƤФȥꥬ
# $c->stash->{'form_data'}񤭴Ƥ
# __PACKAGE__->add_trigger(input_after_get_from_req => \&input_after_get_from_req);
# sub input_after_get_from_req {
#     my $self = shift;
#     my $c = shift;
# }

# retrieverequest¸ߤʤäȤˡ
# ͤͤ᤿˸ƤФȥꥬ
# __PACKAGE__->add_trigger('input_after_gen_first_data' => \&input_after_gen_first_data);
# sub input_after_gen_first_data {
#     my $self = shift;
#     my $c = $c;
# }

# View˸ƤФȥꥬ
# Viewѹ䡢
# ŪĤinput̤ꤳä̤actionforward
# __PACKAGE__->add_trigger(input_view => \&input_view);
# sub input_view {
#     my $self = shift;
#     my $c = shift;
#     my $next_view = shift;
#     # $next_viewARRAYREF
#     # $next_view->[0]forwardΥ饹̾
#     # $next_view->[1]forwardΥ᥽å̾
#     # $next_view->[1]άprocessforwardޤ
#     $next_view->[0] = 'MyApp::View::MyView';
#     $next_view->[1] = 'input';
# }

# Ǹ˸ƤФȥꥬ
# Ǹ˽򶴤ߤ
# __PACKAGE__->add_trigger(input_after => \&input_after);
# sub input_after {
#     my $self = shift;
#     my $c = shift;
# }


##################################################
# ǧѥХå
##################################################

# ֺǽ˸ƤФȥꥬ
# confirmäľ˽򶴤ߤˡ
# __PACKAGE__->add_trigger(confirm_before => \&confirm_before);
# sub confirm_before {
#     my $self = shift;
#     my $c = shift;
# }

# 顼åľ˸ƤФȥꥬ
# check_all_errorsǤ$hashȤåޤ
# __PACKAGE__->add_trigger(confirm_before_check_errors => \&confirm_before_check_errors);
# sub confirm_before_check_errors {
#     my $self = shift;
#     my $c = shift;
#     my $hash = shift;
# }

# Υ˰ܤäƤɤȽꤷ˸ƤФȥꥬ
# ɸǤϥ顼å̤ä鼡˹ԤΤǡ
# εưѤ
# __PACKAGE__->add_trigger(confirm_check => \&confirm_check);
# sub confirm_check {
#     my $self = shift;
#     my $c = shift;
#     # 򵶤ˤȼβ̤عԤʤ
#     $c->session()->{'ADVEL'}->{'confirm'} = 0;
# }

# View˸ƤФȥꥬ
# Viewѹ䡢
# ŪĤconfirm̤ꤳä̤actionforward
# __PACKAGE__->add_trigger(confirm_view => \&confirm_view);
# sub confirm_view {
#     my $self = shift;
#     my $c = shift;
#     my $next_view = shift;
#     # $next_viewARRAYREF
#     # $next_view->[0]forwardΥ饹̾
#     # $next_view->[1]forwardΥ᥽å̾
#     # $next_view->[1]άprocessforwardޤ
#     $next_view->[0] = 'MyApp::View::MyView';
#     $next_view->[1] = 'confirm';
# }

# Ǹ˸ƤФȥꥬ
# Ǹ˽򶴤ߤ
# __PACKAGE__->add_trigger(confirm_after => \&confirm_after);
# sub confirm_after {
#     my $self = shift;
#     my $c = shift;
# }


##################################################
# ϿѥХå
##################################################

# ֺǽ˸ƤФȥꥬ
# do_addäľ˽򶴤ߤˡ
# __PACKAGE__->add_trigger(do_add_before => \&do_add_before);
# sub do_add_before {
#     my $self = shift;
#     my $c = shift;
# }

# Υ˰ܤäƤɤȽꤷ˸ƤФȥꥬ
# ɸǤϥ顼å̤ä鼡˹ԤΤǡ
# εưѤ
# __PACKAGE__->add_trigger(do_add_check => \&do_add_check);
# sub do_add_check {
#     my $self = shift;
#     my $c = shift;
#     # 򵶤ˤȼβ̤عԤʤ
#     $c->session()->{'ADVEL'}->{'do_add'} = 0;
# }

# create or update˸ƤФȥꥬ
# commit餻ʤ
# __PACKAGE__->add_trigger(do_add_commit_flg => \&do_add_commit_flg);
# sub do_add_commit_flg {
#     my $self = shift;
#     my $c = shift;
#     # 򿿤ˤcommitʤ
#     $c->stash->{'ADVEL'}->{$c->namespace}->{'not_commit'} = 1;
# }

# sessionflgflush뤫ɤѤ뤿Υȥꥬ
# flushʤ
# __PACKAGE__->add_trigger(do_add_flush_flg => \&do_add_flush_flg);
# sub do_add_flush_flg {
#     my $self = shift;
#     my $c = shift;
#     # 򿿤ˤflushʤ
#     $c->stash->{'ADVEL'}->{$c->namespace}->{'not_flush'} = 1;
# }

# View˸ƤФȥꥬ
# Viewѹ䡢
# ŪĤdo_add̤ꤳä̤actionforward
# __PACKAGE__->add_trigger(do_add_view => \&do_add_view);
# sub do_add_view {
#     my $self = shift;
#     my $c = shift;
#     my $next_view = shift;
#     # $next_viewARRAYREF
#     # $next_view->[0]forwardΥ饹̾
#     # $next_view->[1]forwardΥ᥽å̾
#     # $next_view->[1]άprocessforwardޤ
#     $next_view->[0] = 'MyApp::View::MyView';
#     $next_view->[1] = 'do_add';
# }

# Ǹ˸ƤФȥꥬ
# Ǹ˽򶴤ߤ
# __PACKAGE__->add_trigger(do_add_after => \&do_add_after);
# sub do_add_after {
#     my $self = shift;
#     my $c = shift;
# }


##################################################
# ̵ǧѥХå
##################################################

# ֺǽ˸ƤФȥꥬ
# pre_disableäľ˽򶴤ߤˡ
# __PACKAGE__->add_trigger(pre_disable_before => \&pre_disable_before);
# sub pre_disable_before {
#     my $self = shift;
#     my $c = shift;
# }

# Υ˰ܤäƤɤȽꤷ˸ƤФȥꥬ
# ɸǤϥ顼å̤ä鼡˹ԤΤǡ
# εưѤ
# __PACKAGE__->add_trigger(pre_disable_check => \&pre_disable_check);
# sub pre_disable_check {
#     my $self = shift;
#     my $c = shift;
#     # 򵶤ˤȼβ̤عԤʤ
#     $c->session()->{'ADVEL'}->{'pre_disable'} = 0;
# }

# View˸ƤФȥꥬ
# Viewѹ䡢
# ŪĤpre_disable̤ꤳä̤actionforward
# __PACKAGE__->add_trigger(pre_disable_view => \&pre_disable_view);
# sub pre_disable_view  {
#     my $self = shift;
#     my $c = shift;
#     my $next_view = shift;
#     # $next_viewARRAYREF
#     # $next_view->[0]forwardΥ饹̾
#     # $next_view->[1]forwardΥ᥽å̾
#     # $next_view->[1]άprocessforwardޤ
#     $next_view->[0] = 'MyApp::View::MyView';
#     $next_view->[1] = 'pre_disable';
# }

# Ǹ˸ƤФȥꥬ
# Ǹ˽򶴤ߤ
# __PACKAGE__->add_trigger(pre_disable_after => \&pre_disable_after);
# sub pre_disable_after {
#     my $self = shift;
#     my $c = shift;
# }


##################################################
# ̵¹ѥХå
##################################################

# ֺǽ˸ƤФȥꥬ
# do_addäľ˽򶴤ߤˡ
# __PACKAGE__->add_trigger(do_disable_before => \&do_disable_before);
# sub do_disable_before  {
#     my $self = shift;
#     my $c = shift;
# }

# Υ˰ܤäƤɤȽꤷ˸ƤФȥꥬ
# ɸǤϥ顼å̤ä鼡˹ԤΤǡ
# εưѤ
# __PACKAGE__->add_trigger(do_disable_check => \&do_disable_check);
# sub do_disable_check {
#     my $self = shift;
#     my $c = shift;
#     # 򵶤ˤȼβ̤عԤʤ
#     $c->session()->{'ADVEL'}->{'do_disable'} = 0;
# }

# create or update˸ƤФȥꥬ
# commit餻ʤ
# __PACKAGE__->add_trigger(do_disable_commit_flg => \&do_disable_commit_flg);
# sub do_disable_commit_flg {
#     my $self = shift;
#     my $c = shift;
#     # 򿿤ˤcommitʤ
#     $c->stash->{'ADVEL'}->{$c->namespace}->{'not_commit'} = 1;
# }

# sessionflgflush뤫ɤѤ뤿Υȥꥬ
# flushʤ
# __PACKAGE__->add_trigger(do_disable_flush_flg => \&do_disable_flush_flg);
# sub do_disable_flush_flg {
#     my $self = shift;
#     my $c = shift;
#     # 򿿤ˤflushʤ
#     $c->stash->{'ADVEL'}->{$c->namespace}->{'not_flush'} = 1;
# }

# View˸ƤФȥꥬ
# Viewѹ䡢
# ŪĤdo_disable̤ꤳä̤actionforward
# __PACKAGE__->add_trigger(do_disable_view => \&do_disable_view);
# sub do_disable_view  {
#     my $self = shift;
#     my $c = shift;
#     my $next_view = shift;
#     # $next_viewARRAYREF
#     # $next_view->[0]forwardΥ饹̾
#     # $next_view->[1]forwardΥ᥽å̾
#     # $next_view->[1]άprocessforwardޤ
#     $next_view->[0] = 'MyApp::View::MyView';
#     $next_view->[1] = 'do_disable';
# }

# Ǹ˸ƤФȥꥬ
# Ǹ˽򶴤ߤ
# __PACKAGE__->add_trigger(do_disable_after => \&do_disable_after);
# sub do_disable_after  {
#     my $self = shift;
#     my $c = shift;
# }

##################################################
# ǧѥХå
##################################################

# ֺǽ˸ƤФȥꥬ
# pre_deleteäľ˽򶴤ߤˡ
# __PACKAGE__->add_trigger(pre_delete_before => \&pre_delete_before);
# sub  pre_delete_before {
#     my $self = shift;
#     my $c = shift;
# }

# Υ˰ܤäƤɤȽꤷ˸ƤФȥꥬ
# ɸǤϥ顼å̤ä鼡˹ԤΤǡ
# εưѤ
# __PACKAGE__->add_trigger(pre_delete_check => \&pre_delete_check);
# sub pre_delete_check {
#     my $self = shift;
#     my $c = shift;
#     # 򵶤ˤȼβ̤عԤʤ
#     $c->session()->{'ADVEL'}->{'pre_delete'} = 0;
# }

# View˸ƤФȥꥬ
# Viewѹ䡢
# ŪĤpre_delete̤ꤳä̤actionforward
# __PACKAGE__->add_trigger(pre_delete_view => \&pre_delete_view);
# sub pre_delete_view  {
#     my $self = shift;
#     my $c = shift;
#     my $next_view = shift;
#     # $next_viewARRAYREF
#     # $next_view->[0]forwardΥ饹̾
#     # $next_view->[1]forwardΥ᥽å̾
#     # $next_view->[1]άprocessforwardޤ
#     $next_view->[0] = 'MyApp::View::MyView';
#     $next_view->[1] = 'pre_delete';
# }

# Ǹ˸ƤФȥꥬ
# Ǹ˽򶴤ߤ
# __PACKAGE__->add_trigger(pre_delete_after => \&pre_delete_after);
# sub pre_delete_after  {
#     my $self = shift;
#     my $c = shift;
# }

##################################################
# ϿѥХå
##################################################

# ֺǽ˸ƤФȥꥬ
# do_addäľ˽򶴤ߤˡ
# __PACKAGE__->add_trigger(do_delete_before => \&do_delete_before);
# sub do_delete_before  {
#     my $self = shift;
#     my $c = shift;
# }

# Υ˰ܤäƤɤȽꤷ˸ƤФȥꥬ
# ɸǤϥ顼å̤ä鼡˹ԤΤǡ
# εưѤ
# __PACKAGE__->add_trigger(do_delete_check => \&do_delete_check);
# sub do_delete_check {
#     my $self = shift;
#     my $c = shift;
#     # 򵶤ˤȼβ̤عԤʤ
#     $c->session()->{'ADVEL'}->{'do_delete'} = 0;
# }

# create or update˸ƤФȥꥬ
# commit餻ʤ
# __PACKAGE__->add_trigger(do_delete_commit_flg => \&do_delete_commit_flg);
# sub do_delete_commit_flg {
#     my $self = shift;
#     my $c = shift;
#     # 򿿤ˤcommitʤ
#     $c->stash->{'ADVEL'}->{$c->namespace}->{'not_commit'} = 1;
# }

# sessionflgflush뤫ɤѤ뤿Υȥꥬ
# flushʤ
# __PACKAGE__->add_trigger(do_delete_flush_flg => \&do_delete_flush_flg);
# sub do_disable_flush_flg {
#     my $self = shift;
#     my $c = shift;
#     # 򿿤ˤflushʤ
#     $c->stash->{'ADVEL'}->{$c->namespace}->{'not_flush'} = 1;
# }

# View˸ƤФȥꥬ
# Viewѹ䡢
# ŪĤdo_delete̤ꤳä̤actionforward
# __PACKAGE__->add_trigger(do_delete_view => \&do_delete_view);
# sub do_delete_view  {
#     my $self = shift;
#     my $c = shift;
#     my $next_view = shift;
#     # $next_viewARRAYREF
#     # $next_view->[0]forwardΥ饹̾
#     # $next_view->[1]forwardΥ᥽å̾
#     # $next_view->[1]άprocessforward
#     $next_view->[0] = 'MyApp::View::MyView';
#     $next_view->[1] = 'do_delete';
# }

# Ǹ˸ƤФȥꥬ
# Ǹ˽򶴤ߤ
# __PACKAGE__->add_trigger(do_delete_after => \&do_delete_after);
# sub do_delete_after  {
#     my $self = shift;
#     my $c = shift;
# }

##################################################
# ץӥ塼Хå
##################################################

# __PACKAGE__->add_trigger(preview_before => \&preview_before);
# ֺǽ˸ƤФȥꥬ
# previewäľ˽򶴤ߤˡ
# sub preview_before($c) {
#     my $self = shift;
#     my $c = shift;
# }

# __PACKAGE__->add_trigger(preview_check => \&preview_check);
# Υ˰ܤäƤɤȽꤷ˸ƤФȥꥬ
# ɸǤϥ顼å̤ä鼡˹ԤΤǡ
# εưѤ
# sub preview_check($c) {
#     my $self = shift;
#     my $c = shift;
# }

# __PACKAGE__->add_trigger(preview_view => \&preview_view);
# View˸ƤФȥꥬ
# Viewѹ䡢
# ŪĤpreview̤ꤳä̤actionforward
# sub preview_view($c) {
#     my $self = shift;
#     my $c = shift;
#     my $next_view = shift;
# }

# __PACKAGE__->add_trigger(preview_after => \&preview_after);
# Ǹ˸ƤФȥꥬ
# Ǹ˽򶴤ߤ
# sub preview_after($c) {
#     my $self = shift;
#     my $c = shift;
# }

##################################################
# ѥХå
##################################################
# __PACKAGE__->add_trigger(list_before => \&list_before);
# sub list_before  {
#     my $self = shift;
#     my $c = shift;
# }

# __PACKAGE__->add_trigger(list_data => \&list_data);
# sub list_data  {
#     my $self = shift;
#     my $c = shift;
#     my $data = shift;
# }

# __PACKAGE__->add_trigger(list_after => \&list_after);
# sub list_after  {
#     my $self = shift;
#     my $c = shift;
# }

=head1 AUTHOR

[% author %]

=head1 LICENSE

This library is free software . You can redistribute it and/or modify
it under the same terms as perl itself.

=cut

1;
