package Data::Object::Autobox::Undef;

use 5.014;

use strict;
use warnings;

use Data::Object ();

sub new {
  Data::Object->undef(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::Undef

=cut

=head1 ABSTRACT

Data-Object Autoboxing for Undef Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::Undef;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::Undef> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(Maybe[Undef] $arg1) : UndefObject

Construct a new object.

=over 4

=item new example

  my $undef = Data::Object::Autobox::Undef->new;

=back

=cut
