package Data::Object::Autobox::Float;

use 5.014;

use strict;
use warnings;

use Data::Object ();

sub new {
  Data::Object->float(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::Float

=cut

=head1 ABSTRACT

Data-Object Autoboxing for Float Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::Float;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::Float> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(Float $arg1) : FloatObject

Construct a new object.

=over 4

=item new example

  my $float = Data::Object::Autobox::Float->new(1.23);

=back

=cut
