package Data::Object::Autobox::Integer;

use 5.014;

use strict;
use warnings;

use Data::Object ();

sub new {
  Data::Object->integer(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::Integer

=cut

=head1 ABSTRACT

Data-Object Autoboxing for Integer Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::Integer;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::Integer> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(Int $arg1) : IntegerObject

Construct a new object.

=over 4

=item new example

  my $integer = Data::Object::Autobox::Integer->new(1_000);

=back

=cut
