package Data::Object::Autobox::Hash;

use 5.014;

use strict;
use warnings;

use Data::Object ();

sub new {
  Data::Object->hash(pop);
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox::Hash

=cut

=head1 ABSTRACT

Data-Object Autoboxing for Hash Objects

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox::Hash;

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<Data::Object::Autobox> for
L<Data::Object::Hash> objects.

=cut

=head1 METHODS

This package implements the following methods.

=cut

=head2 new

  new(HashRef $arg1) : HashObject

Construct a new object.

=over 4

=item new example

  my $hash = Data::Object::Autobox::Hash->new({1..4});

=back

=cut
