use Evo::Base -strict;
use Test::More;
use Evo::Manager;

my $m = Evo::Manager->singleton;

my $train = $m->build_train;
my @passed;
$train->asap(
  sub {
    push @passed, 1;
    $train->asap(sub { push @passed, 3 }, sub { push @passed, 4 });
  },
  sub { push @passed, 2 }
);

$train->asap(sub { push @passed, 5 });
is_deeply \@passed, [1, 2, 3, 4, 5], 'right order';

done_testing;
