# -*- perl -*-
##----------------------------------------------------------------------------
## Telegram API - ~/lib/Net/API/Telegram/ReplyKeyboardMarkup.pm
## Version 0.1
## Copyright(c) 2019 Jacques Deguest
## Author: Jacques Deguest <jack@deguest.jp>
## Created 2019/05/29
## Modified 2019/11/01
## All rights reserved
## 
## This program is free software; you can redistribute  it  and/or  modify  it
## under the same terms as Perl itself.
##----------------------------------------------------------------------------
package Net::API::Telegram::ReplyKeyboardMarkup;
BEGIN
{
	use strict;
	use parent qw( Net::API::Telegram::Generic );
    our( $VERSION ) = '0.1';
};

sub keyboard { return( shift->_set_get_object_array2( 'keyboard', 'Net::API::Telegram::KeyboardButton', @_ ) ); }

sub one_time_keyboard { return( shift->_set_get_scalar( 'one_time_keyboard', @_ ) ); }

sub resize_keyboard { return( shift->_set_get_scalar( 'resize_keyboard', @_ ) ); }

sub selective { return( shift->_set_get_scalar( 'selective', @_ ) ); }

sub _is_boolean { return( grep( /^$_[1]$/, qw( one_time_keyboard resize_keyboard selective ) ) ); }

1;

__END__

=encoding utf-8

=head1 NAME

Net::API::Telegram::ReplyKeyboardMarkup - A custom keyboard with reply options (see Introduction to bots for details and examples)

=head1 SYNOPSIS

	my $msg = Net::API::Telegram::ReplyKeyboardMarkup->new( %data ) || 
	die( Net::API::Telegram::ReplyKeyboardMarkup->error, "\n" );

=head1 DESCRIPTION

L<Net::API::Telegram::ReplyKeyboardMarkup> is a Telegram Message Object as defined here L<https://core.telegram.org/bots/api#replykeyboardmarkup>

This module has been automatically generated from Telegram API documentation by the script scripts/telegram-doc2perl-methods.pl.

=head1 METHODS

=over 4

=item B<new>( {INIT HASH REF}, %PARAMETERS )

B<new>() will create a new object for the package, pass any argument it might receive
to the special standard routine B<init> that I<must> exist. 
Then it returns what returns B<init>().

The valid parameters are as follow. Methods available here are also parameters to the B<new> method.

=over 8

=item * I<verbose>

=item * I<debug>

=back

=item B<keyboard>( Array of Array of KeyboardButton )

Array of button rows, each represented by an Array of KeyboardButton objects

=item B<one_time_keyboard>( Boolean )

Optional. Requests clients to hide the keyboard as soon as it's been used. The keyboard will still be available, but clients will automatically display the usual letter-keyboard in the chat – the user can press a special button in the input field to see the custom keyboard again. Defaults to false.

=item B<resize_keyboard>( Boolean )

Optional. Requests clients to resize the keyboard vertically for optimal fit (e.g., make the keyboard smaller if there are just two rows of buttons). Defaults to false, in which case the custom keyboard is always of the same height as the app's standard keyboard.

=item B<selective>( Boolean )

Optional. Use this parameter if you want to show the keyboard to specific users only. Targets: 1) users that are @mentioned in the text of the Message object; 2) if the bot's message is a reply (has reply_to_message_id), sender of the original message.Example: A user requests to change the bot‘s language, bot replies to the request with a keyboard to select the new language. Other users in the group don’t see the keyboard.

=back

=head1 COPYRIGHT

Copyright (c) 2000-2019 DEGUEST Pte. Ltd.

=head1 AUTHOR

Jacques Deguest E<lt>F<jack@deguest.jp>E<gt>

=head1 SEE ALSO

L<Net::API::Telegram>

=head1 COPYRIGHT & LICENSE

Copyright (c) 2018-2019 DEGUEST Pte. Ltd.

You can use, copy, modify and redistribute this package and associated
files under the same terms as Perl itself.

=cut

