
use strict;
use warnings;

use 5.008001;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Configurable URIs for Catalyst",
  "AUTHOR" => "Rafael Kitover <rkitover\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Catalyst-Plugin-SmartURI",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Catalyst::Plugin::SmartURI",
  "PREREQ_PM" => {
    "Catalyst::Exception" => 0,
    "Catalyst::Request" => 0,
    "Class::C3::Componentised" => 0,
    "Moose" => 0,
    "Scalar::Util" => 0,
    "mro" => 0,
    "namespace::clean" => 0
  },
  "TEST_REQUIRES" => {
    "Catalyst" => 0,
    "Catalyst::Action::REST" => 0,
    "Catalyst::Controller" => 0,
    "Catalyst::Test" => 0,
    "File::Spec" => 0,
    "FindBin" => 0,
    "HTTP::Request" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => 0,
    "URI::SmartURI" => 0,
    "lib" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "VERSION" => "0.038",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Catalyst" => 0,
  "Catalyst::Action::REST" => 0,
  "Catalyst::Controller" => 0,
  "Catalyst::Exception" => 0,
  "Catalyst::Request" => 0,
  "Catalyst::Test" => 0,
  "Class::C3::Componentised" => 0,
  "File::Spec" => 0,
  "FindBin" => 0,
  "HTTP::Request" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Moose" => 0,
  "Scalar::Util" => 0,
  "Test::More" => 0,
  "URI::SmartURI" => 0,
  "lib" => 0,
  "mro" => 0,
  "namespace::clean" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



