#
#	A widget with two listboxes. Selecting an item in the left one
#	copies or moves it over to the other. Selecting an item from
#	the right one deletes it. The action is applied to the list
#	of strings remaining in the right listbox.
#
#	Juergen Wagner, J_Wagner@iao.fhg.de, June 1993
#

defwidget Clickover

defmethod Clickover new {name args} {

  args	init initmethod init2 initmethod2 copy {layout center} \
	title title1 title2 {titlefont bold} {textfont text} \
	{help Library/clickover} action

  set stuff1 [app(get) $initmethod $init]
  if { $initmethod2 == {} } {
    set stuff2 {}
  } {
    set stuff2 [app(get) $initmethod2 $init2]
  }

  Toplevel new $name -title ${title} \
	-resizable true \
	-buttons {Add Remove {} Ok} \
	-handler $name \
	-actions [list \
		[concat {Help {}} $help] \
		{Dismiss {}} \
		[concat {Ok {}} $action] \
		{Add {}} {Remove {}}]
  defsuper $name Clickover

  $name slot _copy [expr {$copy == "true"}]

  Corner new $name.cl -layout {left}
  Corner new $name.cr -layout {right}
  Corner new $name.cb -layout {bottom}

  Listbox new $name.sel1 -layout {left expand fill} \
	-double [list $name _copymove] \
	-title $title1 -titlefont $titlefont -textfont $textfont
  $name.sel1 set $stuff1

  Bitmap new *$name \
	-bitmap @[the(image) large_arrow_right] \
	-layout {left frame center}

  Listbox new $name.sel2 -layout {left expand fill} \
	-double [list $name _movedelete] \
	-title $title2 -titlefont $titlefont -textfont $textfont
  $name.sel2 set $stuff2

  $name layout $layout
}

#---------------------------------------------------------------------------

defmethod Clickover Ok {action} {

  if { $action != {} } {
    set result [eval [concat $action [list [$self.sel2 get]]]]
    if { $result != {} } {
      return
    }
  }

  $self Dismiss
}

defmethod Clickover Add {action} {

  set isel [$self.sel1.list! curselection]
  if { $isel != {} } {
    $self _copymove {} $isel [$self.sel1.list! get $isel]
  }
}

defmethod Clickover Remove {action} {

  set isel [$self.sel2.list! curselection]
  if { $isel != {} } {
    $self _movedelete {} $isel [$self.sel2.list! get $isel]
  }
}

#---------------------------------------------------------------------------

defmethod Clickover _movedelete {listbox isel sel} {

  if { $sel != {} } {
    $self.sel2.list! delete $isel
    if { ! [$self slot _copy] } {
      $self.sel1.list! insert end $sel
    }
  }
}

defmethod Clickover _copymove {listbox isel sel} {

  if { $sel != {} } {
    $self.sel2.list! insert end $sel
    if { ! [$self slot _copy] } {
      $self.sel1.list! delete $isel
    }
  }
}

#---------------------------------------------------------------------------

Window addDemo Clickover

defmethod Clickover demo {} {

  Clickover new * \
	-initmethod list -init {foo bar baz mumble fie fum umu omo} \
	-initmethod2 list -init2 {} \
	-title "Sample ClickOver Box" \
	-title1 "Source" \
	-title2 "Destination" \
	-action {action clickbox}
}
