.HS dp_DistributeObject tcldp
.BS
.SH NAME
dp_DistributeObject, dp_UndistributeObject dp_setf, dp_getf
.sp
dp_SetTrigger, dp_AppendTrigger, dp_AppendTriggerUnique, dp_ReleaseTrigger,
dp_ClearTrigger, dp_GetTriggers
.sp
  \- Tcl-DP support for replicated, distributed objects 
.BE
.LP

The distributed object commands described here are part of the
Tcl-DP (Tcl Distributed Programming) extension to Tcl/Tk.  These
Tcl/Tk commands are used to manage objects which are distributed
among several Tcl/Tk processes.  The Tcl/Tk processes must be
linked by Tcl-DP remote procedure call (RPC) connections.

An object in Tcl-DP is a procedure, just like a widget instance
of Tk is a procedure.  A procedural object must take as its first
argument a method selector.  In other words, if \fIobject\fR is
the name of a procedural object:

\fIobject\fB \fImethod\fR ?\fIargs ...\fR?

Objects can have slots.  Objects which are to be distributed
using Tcl-DP must handle three methods, \fBconfigure\fR and
\fBslot-value\fR, which access the slots of the object, and
\fBdestroy\fR, which destroys the object.

The configure method must handle three different forms of
arguments, which makes it very much like the configure
option for Tk widgets:

\fIobject\fB \fBconfigure\fR ?\fI-slot\fR?
.br
\fIobject\fB \fBconfigure\fR ?\fI-slot value ...\fR?
.br
\fIobject\fB \fBconfigure\fR

When the Tcl/Tk expression "\fIobject\fB configure\fR" is
evaluated, the return value is a list of triplets of the form
\fI{-slot default current}\fR, one triplet for each slot of the
object.  The \fIslot\fR gives the name of the slot, \fIdefault\fR
gives the default value of the slot when the object is created,
and \fIcurrent\fR gives the current value of the slot within the
object.  Furthermore, when the command "\fIobject\fB configure\fI
-slot\fR" is evaluated, the return value should be the triplet
associated with the given \fIslot\fR.  The command "\fIobject\fB
configure\fI -slot value\fR" will set the value of the \fIslot\fP
of the \fIobject\fP to the given \fIvalue\fP.

The slot-value method must take one argument:

\fIobject\fB \fBslot-value\fR ?\fIslot\fR?

The slot-value method returns the current value of a
\fIslot\fR of an \fIobject\fR.

The destroy method takes no arguments:

\fIobject\fB \fBdestroy\fR

The destroy method frees up all memory associated with the
\fIobject\fR, and deletes the command "\fIobject\fP" from the
interpreter.

Objects are usually defined in C for speed, with a Tcl access
interface, just like Tk widgets are defined in C but have Tcl
access interfaces.  Objects can also be defined using Tcl/Tk
scripting only, as Tcl-DP supplies several utility procedures for
creating objects with Tcl/Tk scripting only.  (See dp_object(n).)

Each object to be distributed must also support a creator command
or \fImakeCmd\fR.  This is the command used to create an object.
It should be of the form "\fImakeCmd objName ?-slot1 value1
-slot2 value2 ...?\fR".  This command should create a procedural
object called \fIobjName\fR and initialize the slots the of new
object.

For example, suppose a point object named \fIp1\fR has two slots,
\fIx\fR and \fIy\fR, and the default value for each slot is
\fI0\fR.  Suppose the current value of \fIx\fR is \fI1\fR and the
current value of \fIy\fR is \fI2\fR.  If the \fImakeCmd\fR is
called \fIpoint\fR, then to create such an object, evaluate the
command "\fIpoint p1 -x 1 -y 2\fR".  Then the command "\fIp1
config\fR" will have the return value of \fI{{-x 0 1} {-y 0
2}}\fR, the command "\fIp1 config -x\fR" will have the return
value of \fI-x 0 1\fR, and the command "\fIp1 slot-value x\fR"
will have the return value of \fI1\fR.

Several assumptions were made in the development of the
distributed object system.  First, the graph of RPC connected
processes is assumed to be acyclic.  If this assumption is
violated, deadlock could result.  Second, each slot of an object
has an owner process.  Although the value of a slot can be set in
any process, it is most efficient to do so in the owner process.

.SH COMMANDS
.TP
\fBdp_setf \fIobject slot value\fR

The dp_setf command is used to set the \fIvalue\fR of a
\fIslot\fR in a distributed object.  The side effect of this
command includes replicating the new \fIvalue\fR of the
\fIslot\fR to all processes where the object is distributed.

.TP
\fBdp_getf \fIobject slot\fR

The dp_getf command is used to get the current value of a
\fIslot\fR in a distributed object.  It is the counterpart of
the dp_setf command.

.TP
\fBdp_DistributeObject \fIobject processes makeCmd\fR

Dp_DistributeObject arranges for \fIobject\fR to be
distributed to the given \fIprocesses\fR.  The argument
\fIobject\fR should be the name of the object to be distributed,
\fIprocesses\fR should be a list of \fIsockId\fR's (which we can
use with dp_RPC) which represent connections to remote
processes, and \fImakeCmd\fR should be the creator command for
the object, as described above.

.TP
\fBdp_UndistributeObject \fIobject processes\fR

Dp_UndistributeObject arranges for the slots of \fIobject\fR
to not be shared anymore with remote \fIprocesses\fR.  The
\fIprocesses\fR (which should be a list of \fIsockId\fR's which
represent dp_RPC connections to remote processes) supplied
should be the same as or a subset of the \fIprocesses\fR
originally passed into dp_DistributeObject.  The \fIobject\fR
still exists in all processes, but its slots are no longer
shared.

.TP
\fBdp_SetTrigger \fIwhen object slot trigger-list\fR

Dp_SetTrigger is used to cause each Tcl command in \fItrigger-list\fR
to be evaluated whenever a call to \fBdp_setf\fR causes the \fIslot\fR
of \fIobject\fR to change value.  If \fIwhen\fP is "before," each
command in \fItrigger-list\fP will be evaluated before the slot is
updated.  If \fIwhen\fP is "after," each command in \fItrigger-list\fP will
be evaluated after the slot is set.  The following commands can also be used
to manipulate this \fItrigger-list\fP.

.TP
\fBdp_GetTriggers \fIwhen object slot cmd\fR

Dp_GetTriggers returns the trigger list associated with
\fIslot\fP of \fIobject\fP.

.TP
\fBdp_AppendTrigger \fIwhen object slot cmd\fR

Dp_AppendTrigger is used to add \fIcmd\fP to the trigger list
associated with \fIslot\fP of \fIobject\fP.

.TP
\fBdp_AppendTriggerUnique \fIwhen object slot cmd\fR

Dp_AppendTriggerUnique is used to add \fIcmd\fP to the trigger list
associated with \fIslot\fP of \fIobject\fP only if \fIcmd\fP is not
already part of the trigger list.

.TP
\fBdp_ReleaseTrigger \fIwhen object slot cmd\fR

Dp_ReleaseTrigger deletes \fIcmd\fP from the trigger list
associated with \fIslot\fP of \fIobject\fP.

.TP
\fBdp_ClearTrigger \fIwhen object slot\fR

Dp_ClearTrigger clears the trigger list associated with
\fIslot\fP of \fIobject\fP.
.SH "SEE ALSO"
.PP
dp_connect, dp_rpc, Tcl-DP, object
.SH AUTHOR
Brian Smith (bsmith@cs.berkeley.edu)
.br
Steve Yen (syen@cs.berkeley.edu)
.br
Stephen Tu (tus@roger-rabbit.cs.berkeley.edu)
