(in-package 'user)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Functions I define to get triggered from test.tcl

(wish-code-register
 "dispmsg"
 #'(lambda ()
     (display-message "You wanted to see me?")))

(wish-code-register
 "chgmsg"
 #'(lambda ()
     (format t "What would you like it to say? ")
     (tellwish (concatenate 'string
			    "{.msg configure -text {"
			    (read-line)
			    "}}"))))

(wish-code-register
 "buildproc"
 #'(lambda ()
     (let (wind-name buttext (more t) (i 0))
	   (format t "Enter the name of the procedure to create: ")
	   (setq wind-name (read-line))
	   (tellwish (concatenate 'string
				  "{proc " wind-name " {} {"))
	   (tellwish (concatenate 'string
				  "catch {destroy ." wind-name "}"))
	   (tellwish (concatenate 'string
				  "toplevel ." wind-name " -border 4"))

	   ;; build window with buttons user supplies
	   (tellwish (concatenate 'string
				  "pack append ." wind-name " \\"))

	   (loop while more
		 do
		 (format t "Enter text for a button: ")
		 (setq buttext (read-line))

		 (format t "Another (T/NIL)?")
		 (setq more (read))

		 (tellwish (concatenate 'string
					"[button ." wind-name
					".b~D -text {" buttext "}] top ~A")

			   i

			   ;; if end of buttons, send close bracket for proc.
			   ;;        and for enclosing brace
			   ;; if more buttons, send line continuation
			   (if more "\\" "}}"))

		 (setq i (1+ i)))

	   ;; Let's see window we built
	   (tellwish (concatenate 'string
				  "{" wind-name "}")))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Main function

(defun main ()
  (init-interface)
  (interface-interact))
