/* Copyright (c) 1993 by Sanjay Ghemawat */
#ifndef _UNPARSED_H
#define _UNPARSED_H

#include <stdio.h>

class Lexer;
class charArray;
class UnparsedItemList;

/*
 * List of unparsed items in file.
 */
class UnparsedItems {
  public:
    UnparsedItems();
    ~UnparsedItems();

    int Read(char const* id, Lexer* lexer);
    /*
     * modifies - this
     * requires - id is a string just read from lexer.
     *		  The following whitespace and opener have also been read.
     *		  The lexer is positioned right after the opener.
     * effects  - Reads the corresponding value (up to but not including the
     *		  closer character) and stores it away.  A closer character is
     *		  not considered to end the value if it is escaped by
     *		  a backslash character.  Returns true iff successful.
     *		  For example, if the lexer contains the following text,
     *		  and is positioned right after the '[',
     *
     *			id [string \[with\] brackets],
     *
     *		  the value stashed away will be
     *
     *			"string \[with\] brackets"
     */

    void Write(FILE* out) const;
    /*
     * modifies - out
     * effects  - Writes previously stored <id, value> pairs to out
     *		  in the format "<id> [<value>]".
     */
  private:
    charArray* buffer;
    UnparsedItemList* list;
};

#endif /* _UNPARSED_H */
