#include "options.h"

OptionMap::~OptionMap() {
    for (OptionMap_Bindings b = rep; b.ok(); b.next()) {
	delete [] ((char*) b.key());
	delete [] ((char*) b.val());
    }
    delete rep;
}

void OptionMap::store(char const* key, char const* value) {
    char* copy = new char[strlen(value)+1];
    strcpy(copy, value);

    char const* old_value;
    if (rep->fetch(key, old_value)) {
	// Replace old value with new
	rep->store(key, copy);
	delete [] ((char*) old_value);
    }
    else {
	// Insert new value
	char* copy_key = new char[strlen(key)+1];
	strcpy(copy_key, key);
	rep->store(copy_key, copy);
    }
}

implementOpenHashMap(OptionMapRep,char const*,char const*,hash_string,eq_opt)
