;; ============================B O F============================= ;;
;;FILE:		"unscanned.scm"
;;
;;IMPLEMENTS:	Test implementation of unscanned vectors for the
;;		Gambit1.51 runtime system -- in order to hold binary
;;		objects (such as 'C' pointers) which should not be 
;;		scanned by the collector.
;;
;;AUTHOR:	Kenneth Dickey
;;DATE:		1991 September 24
;;LAST UPDATED:
;;NOTES:        


(define UNSCANNED-VECTOR-TAG 19)

(define (MAKE-UNSCANNED-VECTOR vsize)
  (let ( (v (##make-vector vsize 0)) )
     (##subtype-set! v unscanned-vector-tag)
     v
) )

(define (UNSCANNED-VECTOR? v)
  (and (##subtyped? v) (= (##subtype v) unscanned-vector-tag))
)

(define (UNSCANNED-VECTOR-SET! v index val)
  (if (unscanned-vector? v)
      (##vector-set! v index val)
      (##error "Set!: Bad unsigned vector" v)
) )

(define (UNSCANNED-VECTOR-REF v index)
  (if (unscanned-vector? v)
      (##vector-ref v index)
      (##error "Ref: Bad unsigned vector" v)
) )

(define (UNSCANNED-VECTOR-LENGTH v)
  (if (unscanned-vector? v)
      (##vector-length v)
      (##error "Length: Bad unsigned vector" v)
) )

;; ============================E O F============================= ;;

