#include "../../LOADER/params.h"
#include "../../LOADER/gambit.h"
#include "../../LOADER/struct.h"
#include "../../LOADER/os.h"
#include "../../LOADER/mem.h"
#include "../../LOADER/strings.h"


/*---------------------------------------------------------------------------*/

/*
 * This file contains C procedures that are to be made available to
 * Scheme programs.  A special naming convention is used for the procedure
 * names so that any Scheme identifier can be written out (including
 * identifiers with '#' characters).
 *
 * The arguments and results of these procedures are of type 'SCM_obj'.
 * Macros exist to convert from Scheme data representation to C data
 * representation.
 *
 * As an example, we define the procedure '##shell-command' that
 * behaves like the UNIX call 'system', and '##exit' that behaves
 * like the UNIX call 'exit'.
 *
 */


SCM_obj X23X23shellDcommand( str )
SCM_obj str;
{ SCM_obj result;
  char *mark = local_mark();              /* put mark on local C heap    */
  char *command = string_to_c_str( str ); /* convert Scheme string to C  */
  if (command == NULL)
    result = SCM_false;
  else
    result = SCM_int_to_obj( system( command ) );
  local_release( mark );                  /* get rid of converted string */
  return result;
}


SCM_obj X23X23exit( status )
SCM_obj status;
{ exit( SCM_obj_to_int( status ) );
  return SCM_false;  /* ##exit should never return... */
}


/*---------------------------------------------------------------------------*/

/*
 * This section defines the list of procedures to export to the Scheme
 * world.  It must contain: a link initialization procedure and a flag
 * that indicates that this is a C file (as opposed to a Scheme object file).
 * The name of the (long) flag is the name of this file, prefixed with
 * 'link_sizeof_ofile_'.  The name of the (void) init procedure is the
 * name of this file, prefixed with 'link_ofile_'.
 *
 */


long link_sizeof_ofile_tools = -1; /* indicate this is a C file */


void link_ofile_tools()
{
  DEFINE_C_PROC(X23X23shellDcommand);
  DEFINE_C_PROC(X23X23exit);
}


/*---------------------------------------------------------------------------*/
