use v6.d;
use Test;

# ok 1-4 
  
ok !  MY::<&Bin>     , 'Bin not installed before use.';
ok !  MY::<&Script>  , 'Script not installed before use.';

ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not true before use.';
ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose not true before use.';

do
{
    # ok 5-8

    note '# FindBin';
   
    use FindBin;

    ok   MY::<&Bin>     , 'Bin installed by default.';
    ok   MY::<&Script>  , 'Script installed by default.';

    ok ! MY::<_FindBin_RESOLVE-DEF>, 'Resolve not true by default.';
    ok ! MY::<_FindBin_VERBOSE-DEF>, 'Verbose not true by default.';

    note '# Bin is:    ' ~ Bin;
    note '# Script is: ' ~ Script;
};

# ok 9-12

ok ! MY::<&Bin>     , 'Bin is lexicaly scoped.';
ok ! MY::<&Script>  , 'Script is lexicaly scoped.';

ok ! MY::<_FindBin_RESOLVE-DEF>, 'Resolve not true outside block.';
ok ! MY::<_FindBin_VERBOSE-DEF>, 'Verbose not true outside block.';

do
{
    # ok 13-16

    note '# FindBin :resolve, :verbose';
   
    use FindBin :resolve, :verbose;

    ok   MY::<&Bin>     , 'Bin installed by default.';
    ok   MY::<&Script>  , 'Script installed by default.';

    ok   MY::<_FindBin_RESOLVE-DEF>, 'Resolve is true.';
    ok   MY::<_FindBin_VERBOSE-DEF>, 'Verbose is true.';

    note '# Bin is:    ' ~ Bin;
    note '# Script is: ' ~ Script;
};

# ok 17-20

ok ! MY::<&Bin>     , 'Bin is lexicaly scoped.';
ok ! MY::<&Script>  , 'Script is lexicaly scoped.';

ok ! MY::<_FindBin_RESOLVE-DEF>, 'Resolve not true outside block.';
ok ! MY::<_FindBin_VERBOSE-DEF>, 'Verbose not true outside block.';

#do
#{
#    # ok 9-12 
#
#    use FindBin :Bin;
#
#    ok   MY::<&Bin>     , 'Bin installed.';
#    ok ! MY::<&Script>  , 'Script not installed.';
#
#    ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed';
#    ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose not installed';
#
#    note '# Bin is:    ' ~ Bin;
#};
#
#do
#{
#    # ok 13-16
#
#    use FindBin :Script;
#
#    ok ! MY::<&Bin>     , 'Bin not installed.';
#    ok   MY::<&Script>  , 'Script installed.';
#
#    ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed';
#    ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose not installed';
#
#    note '# Script is: ' ~ Script;
#};
#
#do
#{
#    # ok 17-20
#
#    use FindBin :Bin :verbose;
#
#    ok   MY::<&Bin>     , 'Bin installed.';
#    ok ! MY::<&Script>  , 'Script not installed.';
#
#    ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed';
#    ok   MY::<_FindBin_VERBOSE-DEF>,   'Verbose installed';
#};
#
#do
#{
#    # ok 21-24
#
#    use FindBin :Bin :resolve;
#
#    ok   MY::<&Bin>     , 'Bin installed.';
#    ok ! MY::<&Script>  , 'Script not installed.';
#
#    ok   MY::<_FindBin_RESOLVE-DEF>,   'Resolve installed';
#    ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose not installed';
#};
#
#do
#{
#    # ok 25-28
#
#    use FindBin :Bin :verbose :resolve;
#
#    ok   MY::<&Bin>     , 'Bin installed.';
#    ok ! MY::<&Script>  , 'Script installed.';
#
#    ok   MY::<_FindBin_RESOLVE-DEF>,   'Resolve installed';
#    ok   MY::<_FindBin_VERBOSE-DEF>,   'Verbose installed';
#};
#
#ok ! MY::<&Bin>     , 'Bin is lexicaly scoped.';
#ok ! MY::<&Script>  , 'Script is lexicaly scoped.';
#
#ok ! MY::<_FindBin_RESOLVE-DEF>,   'Resolve not installed globally';
#ok ! MY::<_FindBin_VERBOSE-DEF>,   'Verbose not installed globally';

done-testing;
