use utf8;
use strict;
use warnings;
use Test::More qw(no_plan);
use lib 'lib';
use aliased 'Javonet::Core::Protocol::TypeSerializer' => 'TypeSerializer', qw(serializeInt);

my @expected_int = (2,4,89,8,0,0);
my @expected_double = (8,8,102,102,102,102,102,102,54,64);
my @expected_float = (4, 4, 44, 212, 90, 62);
my @expected_string = (1, 1, 7, 0, 0, 0, 74, 65, 86, 79, 78, 69, 84);
my @expected_string2 = (1, 1, 14, 0, 0, 0, 197, 164, 194, 191, 207, 187, 195, 144, 195, 159, 196, 166, 197, 129);

is_deeply(test_typeserializer_int_2137_correctbytearray(), \@expected_int, 'Integer serialization test');
is_deeply(test_typeserializer_double_22dot4_correctbytearray(), \@expected_double, 'Double serialization test');
is_deeply(test_typeserializer_float_0dot2137_correctbytearray(), \@expected_float, 'Float serialization test');
is_deeply(test_typeserializer_string_JAVONET_correctbytearray(), \@expected_string, 'String serialization test');
is_deeply(test_typeserializer_string_nonasciistring_correctbytearray(), \@expected_string2, 'String non-ascii serialization test');



sub test_typeserializer_int_2137_correctbytearray{
    my $integer = 2137;
    my @result = TypeSerializer->serializeInt($integer);
    return \@result;
}

sub test_typeserializer_double_22dot4_correctbytearray{
    my $double = 22.4;
    my @result = TypeSerializer->serializeDouble($double);
    return \@result;
}

sub test_typeserializer_float_0dot2137_correctbytearray{
    my $float = 0.2137;
    my @result = TypeSerializer->serializeFloat($float);
    return \@result;
}

sub test_typeserializer_string_JAVONET_correctbytearray{
    my $string = "JAVONET";
    my @result = TypeSerializer->serializeString($string);
    return \@result;
}

sub test_typeserializer_string_nonasciistring_correctbytearray{
    my $string = "Ť¿ϻÐßĦŁ";
    my @result = TypeSerializer->serializeString($string);
    return \@result;
}

done_testing();
