package Locales::DB::Language::ur;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::ur::VERSION = '0.09';

$Locales::DB::Language::ur::cldr_version = '2.0';

%Locales::DB::Language::ur::misc_info = (
    'characters'   => { 'more_information' => '؟' },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "زبان\:\{0\}",
        'list'     => {
            2        => "\{0\}\ اور\ \{1\}",
            'end'    => "\{0\}،\ اور\ \{1\}",
            'middle' => "\{0\}،\ \{1\}",
            'start'  => "\{0\}،\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "خطہ\:\{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\'",
        'alternate_quotation_start' => "\'",
        'quotation_end'             => "\"",
        'quotation_start'           => "\""
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "ہاں\:ہاں"
    },
);

%Locales::DB::Language::ur::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'ابقازیان',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'ايفريکانز',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'امہاری',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'عربی',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'آسامی',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'ایمارا',
    'az'    => 'ازیری',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'بيلاروسی',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'بلغاری',
    'bh'    => 'بِہاری',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'بنگالی',
    'bnt'   => 'Bantu',
    'bo'    => 'تبتی',
    'br'    => 'برِیٹن',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'بوسنی',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'کاٹالانين',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'چيک',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'ویلش',
    'da'    => 'ڈينش',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'جرمن',
    'de_at' => "آسٹریائی\ جرمن",
    'de_ch' => "سوئس\ ہائی\ جرمن",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'ڈیویہی',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'ژونگکھا',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'ایفِک',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'يونانی',
    'elx'   => 'Elamite',
    'en'    => 'انگريزی',
    'en_au' => "آسٹریلیائی\ انگریزی",
    'en_ca' => "کینیڈین\ انگریزی",
    'en_gb' => "برطانوی\ انگریزی",
    'en_us' => "امریکی\ انگریزی",
    'enm'   => "Middle\ English",
    'eo'    => 'ايسپرانٹو',
    'es'    => 'ہسپانوی',
    'es_es' => "آئبریائی\ ہسپانوی",
    'et'    => 'اسٹونين',
    'eu'    => 'باسکی',
    'ewo'   => 'Ewondo',
    'fa'    => 'فارسی',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'فنّنِش',
    'fil'   => 'ٹيگالاگی',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => "فجی\ کا\ باشندہ",
    'fo'    => 'فیروئیز',
    'fon'   => 'Fon',
    'fr'    => 'فرانسيسی',
    'fr_ca' => "کینیڈین\ فرانسیسی",
    'fr_ch' => "سوئس\ فرینچ",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "مغربی\ فریسیئن",
    'ga'    => 'آئيرِش',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "سکاٹ\ گيلِک",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'گاليشيائی',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'گُارانی',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "سوئس\ جرمن",
    'gu'    => 'گجراتی',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'ہؤسا',
    'hai'   => 'Haida',
    'haw'   => "ہوائی\ کا\ باشندہ",
    'he'    => 'عبرانی',
    'hi'    => 'ہندی',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'کراتی',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'ہیتی',
    'hu'    => 'ہنگیرین',
    'hup'   => 'Hupa',
    'hy'    => 'ارمینی',
    'hz'    => 'Herero',
    'ia'    => 'انٹرلنگوی',
    'iba'   => 'Iban',
    'id'    => 'انڈونيثيائی',
    'ie'    => 'Interlingue',
    'ig'    => 'اِگبو',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => "آئس\ لینڈ\ کا\ باشندہ",
    'it'    => 'اطالوی',
    'iu'    => 'Inuktitut',
    'ja'    => 'جاپانی',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'جاوی',
    'ka'    => 'جارجی',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'قزاخ',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'کمبوڈیَن',
    'kmb'   => 'Kimbundu',
    'kn'    => 'کنّاڈا',
    'ko'    => 'کورين',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'کشمیری',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'کردش',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'کرغیزی',
    'la'    => 'لاطينی',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => "لگژمبرگ\ کا\ باشندہ",
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'لِنگَلا',
    'lo'    => 'لاؤشِیَن',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'لتھُواینین',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'ليٹوين',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'ملاگاسی',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'ماؤری',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'مقدونيائی',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'مالايالم',
    'mn'    => 'منگؤلی',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'مراٹهی',
    'ms'    => 'مالائی',
    'mt'    => 'مالٹی',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'برمی',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "نارویجین\ بوکمل",
    'nd'    => "شمالی\ دبیل",
    'nds'   => "Low\ German",
    'ne'    => 'نيپالی',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ڈچ',
    'nl_be' => 'فلیمِش',
    'nmg'   => 'Kwasio',
    'nn'    => "نورویجینی\ \(نینورسک\)",
    'no'    => 'نارويجين',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "شمالی\ سوتھو",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'نیانجا',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'آکيٹانی',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'اورِیا',
    'os'    => 'اوسیٹک',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'پنجابی',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'پولستانی',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'پشتو',
    'pt'    => 'پُرتگالی',
    'pt_br' => "برازیلی\ پرتگالی",
    'pt_pt' => "پرتگالی\ \(پرتگال\)",
    'qu'    => 'کویچوآ',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'رومانش',
    'rn'    => 'رونڈی',
    'ro'    => 'رومنی',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'روسی',
    'rup'   => 'Aromanian',
    'rw'    => 'کینیاروانڈا',
    'rwk'   => 'Rwa',
    'sa'    => 'سَنسکرِت',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'سندھی',
    'se'    => "شمالی\ سامی",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'سانگو',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "سربو\-کروئیشین",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'سنہالا',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'سلوواک',
    'sl'    => 'سلووینیائی',
    'sla'   => "Slavic\ Language",
    'sm'    => 'ساموآن',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'شونا',
    'snk'   => 'Soninke',
    'so'    => 'صومالی',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'البانی',
    'sr'    => 'صربی',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'سواتی',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "جنوبی\ سوتھو",
    'su'    => 'سنڈانیز',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'سویڈش',
    'sw'    => 'سواحلی',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'تمل',
    'tai'   => "Tai\ Language",
    'te'    => 'تیلگو',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'ٹیٹم',
    'tg'    => 'تاجک',
    'th'    => 'تھائی',
    'ti'    => 'ٹگرینیا',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'ترکمان',
    'tkl'   => 'Tokelau',
    'tl'    => "ٹیگا\ لوگ",
    'tlh'   => 'کلنگان',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'سوانا',
    'to'    => 'ٹونگا',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "ٹوک\ پِسِن",
    'tr'    => 'ترکی',
    'trv'   => 'Taroko',
    'ts'    => 'زونگا',
    'tsi'   => 'Tsimshian',
    'tt'    => 'تاتار',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'توی',
    'twq'   => 'Tasawaq',
    'ty'    => 'تاہیتی',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'ییگہر',
    'uga'   => 'Ugaritic',
    'uk'    => 'یوکرینیائی',
    'umb'   => 'Umbundu',
    'und'   => "نامعلوم\ زبان",
    'ur'    => 'اردو',
    'uz'    => 'ازبیک',
    'vai'   => 'Vai',
    've'    => 'وینڈا',
    'vi'    => 'ویتنامی',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'وولوف',
    'xal'   => 'Kalmyk',
    'xh'    => 'ژوسا',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'يادش',
    'yo'    => 'یوروبا',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'چینی',
    'znd'   => 'Zande',
    'zu'    => 'زولو',
    'zun'   => 'Zuni',
    'zxx'   => "کوئی\ لسانی\ مواد\ نہیں",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ur::name_to_code = (
    'achinese'                           => 'ace',
    'acoli'                              => 'ach',
    'adangme'                            => 'ada',
    'adyghe'                             => 'ady',
    'afar'                               => 'aa',
    'afrihili'                           => 'afh',
    'afroasiaticlanguage'                => 'afa',
    'aghem'                              => 'agq',
    'ainu'                               => 'ain',
    'akan'                               => 'ak',
    'akkadian'                           => 'akk',
    'aleut'                              => 'ale',
    'algonquianlanguage'                 => 'alg',
    'altaiclanguage'                     => 'tut',
    'ancientegyptian'                    => 'egy',
    'ancientgreek'                       => 'grc',
    'angika'                             => 'anp',
    'apachelanguage'                     => 'apa',
    'aragonese'                          => 'an',
    'aramaic'                            => 'arc',
    'arapaho'                            => 'arp',
    'araucanian'                         => 'arn',
    'arawak'                             => 'arw',
    'aromanian'                          => 'rup',
    'artificiallanguage'                 => 'art',
    'asturian'                           => 'ast',
    'asu'                                => 'asa',
    'athapascanlanguage'                 => 'ath',
    'atsam'                              => 'cch',
    'australianlanguage'                 => 'aus',
    'austronesianlanguage'               => 'map',
    'avaric'                             => 'av',
    'avestan'                            => 'ae',
    'awadhi'                             => 'awa',
    'bafia'                              => 'ksf',
    'balinese'                           => 'ban',
    'balticlanguage'                     => 'bat',
    'baluchi'                            => 'bal',
    'bambara'                            => 'bm',
    'bamilekelanguage'                   => 'bai',
    'banda'                              => 'bad',
    'bantu'                              => 'bnt',
    'basaa'                              => 'bas',
    'bashkir'                            => 'ba',
    'batak'                              => 'btk',
    'beja'                               => 'bej',
    'bemba'                              => 'bem',
    'bena'                               => 'bez',
    'berber'                             => 'ber',
    'bhojpuri'                           => 'bho',
    'bikol'                              => 'bik',
    'bini'                               => 'bin',
    'bislama'                            => 'bi',
    'blin'                               => 'byn',
    'blissymbols'                        => 'zbl',
    'bodo'                               => 'brx',
    'braj'                               => 'bra',
    'buginese'                           => 'bug',
    'buriat'                             => 'bua',
    'caddo'                              => 'cad',
    'cantonese'                          => 'yue',
    'carib'                              => 'car',
    'caucasianlanguage'                  => 'cau',
    'cayuga'                             => 'cay',
    'cebuano'                            => 'ceb',
    'celticlanguage'                     => 'cel',
    'centralamericanindianlanguage'      => 'cai',
    'centralmoroccotamazight'            => 'tzm',
    'chagatai'                           => 'chg',
    'chamiclanguage'                     => 'cmc',
    'chamorro'                           => 'ch',
    'chechen'                            => 'ce',
    'cherokee'                           => 'chr',
    'cheyenne'                           => 'chy',
    'chibcha'                            => 'chb',
    'chiga'                              => 'cgg',
    'chinookjargon'                      => 'chn',
    'chipewyan'                          => 'chp',
    'choctaw'                            => 'cho',
    'churchslavic'                       => 'cu',
    'chuukese'                           => 'chk',
    'chuvash'                            => 'cv',
    'classicalnewari'                    => 'nwc',
    'classicalsyriac'                    => 'syc',
    'colognian'                          => 'ksh',
    'comorian'                           => 'swb',
    'congoswahili'                       => 'swc',
    'coptic'                             => 'cop',
    'cornish'                            => 'kw',
    'corsican'                           => 'co',
    'cree'                               => 'cr',
    'creek'                              => 'mus',
    'creoleorpidgin'                     => 'crp',
    'crimeanturkish'                     => 'crh',
    'cushiticlanguage'                   => 'cus',
    'dakota'                             => 'dak',
    'dargwa'                             => 'dar',
    'dayak'                              => 'day',
    'delaware'                           => 'del',
    'dinka'                              => 'din',
    'dogri'                              => 'doi',
    'dogrib'                             => 'dgr',
    'dravidianlanguage'                  => 'dra',
    'duala'                              => 'dua',
    'dyula'                              => 'dyu',
    'easternfrisian'                     => 'frs',
    'ekajuk'                             => 'eka',
    'elamite'                            => 'elx',
    'embu'                               => 'ebu',
    'englishbasedcreoleorpidgin'         => 'cpe',
    'erzya'                              => 'myv',
    'ewe'                                => 'ee',
    'ewondo'                             => 'ewo',
    'fang'                               => 'fan',
    'fanti'                              => 'fat',
    'finnougrianlanguage'                => 'fiu',
    'fon'                                => 'fon',
    'frenchbasedcreoleorpidgin'          => 'cpf',
    'friulian'                           => 'fur',
    'fulah'                              => 'ff',
    'ga'                                 => 'gaa',
    'ganda'                              => 'lg',
    'gayo'                               => 'gay',
    'gbaya'                              => 'gba',
    'geez'                               => 'gez',
    'germaniclanguage'                   => 'gem',
    'gilbertese'                         => 'gil',
    'gondi'                              => 'gon',
    'gorontalo'                          => 'gor',
    'gothic'                             => 'got',
    'grebo'                              => 'grb',
    'gusii'                              => 'guz',
    "gwich\Ê\¼in"                      => 'gwi',
    'haida'                              => 'hai',
    'herero'                             => 'hz',
    'hiligaynon'                         => 'hil',
    'himachali'                          => 'him',
    'hirimotu'                           => 'ho',
    'hittite'                            => 'hit',
    'hmong'                              => 'hmn',
    'hupa'                               => 'hup',
    'iban'                               => 'iba',
    'ido'                                => 'io',
    'ijo'                                => 'ijo',
    'iloko'                              => 'ilo',
    'inarisami'                          => 'smn',
    'indiclanguage'                      => 'inc',
    'indoeuropeanlanguage'               => 'ine',
    'ingush'                             => 'inh',
    'interlingue'                        => 'ie',
    'inuktitut'                          => 'iu',
    'inupiaq'                            => 'ik',
    'iranianlanguage'                    => 'ira',
    'iroquoianlanguage'                  => 'iro',
    'jju'                                => 'kaj',
    'jolafonyi'                          => 'dyo',
    'judeoarabic'                        => 'jrb',
    'judeopersian'                       => 'jpr',
    'kabardian'                          => 'kbd',
    'kabuverdianu'                       => 'kea',
    'kabyle'                             => 'kab',
    'kachin'                             => 'kac',
    'kalaallisut'                        => 'kl',
    'kalenjin'                           => 'kln',
    'kalmyk'                             => 'xal',
    'kamba'                              => 'kam',
    'kanuri'                             => 'kr',
    'karachaybalkar'                     => 'krc',
    'karakalpak'                         => 'kaa',
    'karelian'                           => 'krl',
    'karen'                              => 'kar',
    'kashubian'                          => 'csb',
    'kawi'                               => 'kaw',
    'khasi'                              => 'kha',
    'khoisanlanguage'                    => 'khi',
    'khotanese'                          => 'kho',
    'kikuyu'                             => 'ki',
    'kimbundu'                           => 'kmb',
    'komi'                               => 'kv',
    'kongo'                              => 'kg',
    'konkani'                            => 'kok',
    'koro'                               => 'kfo',
    'kosraean'                           => 'kos',
    'koyraborosenni'                     => 'ses',
    'koyrachiini'                        => 'khq',
    'kpelle'                             => 'kpe',
    'kru'                                => 'kro',
    'kuanyama'                           => 'kj',
    'kumyk'                              => 'kum',
    'kurukh'                             => 'kru',
    'kutenai'                            => 'kut',
    'kwasio'                             => 'nmg',
    'ladino'                             => 'lad',
    'lahnda'                             => 'lah',
    'lamba'                              => 'lam',
    'langi'                              => 'lag',
    'lezghian'                           => 'lez',
    'limburgish'                         => 'li',
    'lojban'                             => 'jbo',
    'lowersorbian'                       => 'dsb',
    'lowgerman'                          => 'nds',
    'lozi'                               => 'loz',
    'lubakatanga'                        => 'lu',
    'lubalulua'                          => 'lua',
    'luiseno'                            => 'lui',
    'lulesami'                           => 'smj',
    'lunda'                              => 'lun',
    'luo'                                => 'luo',
    'lushai'                             => 'lus',
    'luyia'                              => 'luy',
    'machame'                            => 'jmc',
    'madurese'                           => 'mad',
    'magahi'                             => 'mag',
    'maithili'                           => 'mai',
    'makasar'                            => 'mak',
    'makhuwameetto'                      => 'mgh',
    'makonde'                            => 'kde',
    'manchu'                             => 'mnc',
    'mandar'                             => 'mdr',
    'mandingo'                           => 'man',
    'manipuri'                           => 'mni',
    'manobolanguage'                     => 'mno',
    'manx'                               => 'gv',
    'mari'                               => 'chm',
    'marshallese'                        => 'mh',
    'marwari'                            => 'mwr',
    'masai'                              => 'mas',
    'mayanlanguage'                      => 'myn',
    'mende'                              => 'men',
    'meru'                               => 'mer',
    'micmac'                             => 'mic',
    'middledutch'                        => 'dum',
    'middleenglish'                      => 'enm',
    'middlefrench'                       => 'frm',
    'middlehighgerman'                   => 'gmh',
    'middleirish'                        => 'mga',
    'minangkabau'                        => 'min',
    'mirandese'                          => 'mwl',
    'miscellaneouslanguage'              => 'mis',
    'mohawk'                             => 'moh',
    'moksha'                             => 'mdf',
    'moldavian'                          => 'mo',
    'mongo'                              => 'lol',
    'monkhmerlanguage'                   => 'mkh',
    'morisyen'                           => 'mfe',
    'mossi'                              => 'mos',
    'multiplelanguages'                  => 'mul',
    'mundalanguage'                      => 'mun',
    'mundang'                            => 'mua',
    'nahuatl'                            => 'nah',
    'nama'                               => 'naq',
    'nauru'                              => 'na',
    'navajo'                             => 'nv',
    'ndonga'                             => 'ng',
    'neapolitan'                         => 'nap',
    'newari'                             => 'new',
    'nias'                               => 'nia',
    'nigerkordofanianlanguage'           => 'nic',
    'nilosaharanlanguage'                => 'ssa',
    'niuean'                             => 'niu',
    'nogai'                              => 'nog',
    'northamericanindianlanguage'        => 'nai',
    'northernfrisian'                    => 'frr',
    'nubianlanguage'                     => 'nub',
    'nuer'                               => 'nus',
    'nyamwezi'                           => 'nym',
    'nyankole'                           => 'nyn',
    'nyasatonga'                         => 'tog',
    'nyoro'                              => 'nyo',
    'nzima'                              => 'nzi',
    "n\â\\ko"                       => 'nqo',
    'ojibwa'                             => 'oj',
    'oldenglish'                         => 'ang',
    'oldfrench'                          => 'fro',
    'oldhighgerman'                      => 'goh',
    'oldirish'                           => 'sga',
    'oldnorse'                           => 'non',
    'oldpersian'                         => 'peo',
    "oldproven\Ã\§al"                  => 'pro',
    'oromo'                              => 'om',
    'osage'                              => 'osa',
    'otomianlanguage'                    => 'oto',
    'ottomanturkish'                     => 'ota',
    'pahlavi'                            => 'pal',
    'palauan'                            => 'pau',
    'pali'                               => 'pi',
    'pampanga'                           => 'pam',
    'pangasinan'                         => 'pag',
    'papiamento'                         => 'pap',
    'papuanlanguage'                     => 'paa',
    'philippinelanguage'                 => 'phi',
    'phoenician'                         => 'phn',
    'pohnpeian'                          => 'pon',
    'portuguesebasedcreoleorpidgin'      => 'cpp',
    'prakritlanguage'                    => 'pra',
    'rajasthani'                         => 'raj',
    'rapanui'                            => 'rap',
    'rarotongan'                         => 'rar',
    'romancelanguage'                    => 'roa',
    'romany'                             => 'rom',
    'rombo'                              => 'rof',
    'rwa'                                => 'rwk',
    'saho'                               => 'ssy',
    'sakha'                              => 'sah',
    'salishanlanguage'                   => 'sal',
    'samaritanaramaic'                   => 'sam',
    'samburu'                            => 'saq',
    'samilanguage'                       => 'smi',
    'sandawe'                            => 'sad',
    'sangu'                              => 'sbp',
    'santali'                            => 'sat',
    'sardinian'                          => 'sc',
    'sasak'                              => 'sas',
    'scots'                              => 'sco',
    'selkup'                             => 'sel',
    'semiticlanguage'                    => 'sem',
    'sena'                               => 'seh',
    'seneca'                             => 'see',
    'serer'                              => 'srr',
    'shambala'                           => 'ksb',
    'shan'                               => 'shn',
    'sichuanyi'                          => 'ii',
    'sicilian'                           => 'scn',
    'sidamo'                             => 'sid',
    'signlanguage'                       => 'sgn',
    'siksika'                            => 'bla',
    'sinotibetanlanguage'                => 'sit',
    'siouanlanguage'                     => 'sio',
    'skoltsami'                          => 'sms',
    'slave'                              => 'den',
    'slaviclanguage'                     => 'sla',
    'soga'                               => 'xog',
    'sogdien'                            => 'sog',
    'songhai'                            => 'son',
    'soninke'                            => 'snk',
    'sorbianlanguage'                    => 'wen',
    'southamericanindianlanguage'        => 'sai',
    'southernaltai'                      => 'alt',
    'southernsami'                       => 'sma',
    'southndebele'                       => 'nr',
    'sranantongo'                        => 'srn',
    'sukuma'                             => 'suk',
    'sumerian'                           => 'sux',
    'susu'                               => 'sus',
    'syriac'                             => 'syr',
    'tachelhit'                          => 'shi',
    'tailanguage'                        => 'tai',
    'taita'                              => 'dav',
    'tamashek'                           => 'tmh',
    'taroko'                             => 'trv',
    'tasawaq'                            => 'twq',
    'tereno'                             => 'ter',
    'teso'                               => 'teo',
    'tigre'                              => 'tig',
    'timne'                              => 'tem',
    'tiv'                                => 'tiv',
    'tlingit'                            => 'tli',
    'tokelau'                            => 'tkl',
    'tsimshian'                          => 'tsi',
    'tumbuka'                            => 'tum',
    'tupilanguage'                       => 'tup',
    'tuvalu'                             => 'tvl',
    'tuvinian'                           => 'tyv',
    'tyap'                               => 'kcg',
    'udmurt'                             => 'udm',
    'ugaritic'                           => 'uga',
    'umbundu'                            => 'umb',
    'uppersorbian'                       => 'hsb',
    'vai'                                => 'vai',
    "volap\Ã\¼k"                       => 'vo',
    'votic'                              => 'vot',
    'vunjo'                              => 'vun',
    'wakashanlanguage'                   => 'wak',
    'walamo'                             => 'wal',
    'walloon'                            => 'wa',
    'walser'                             => 'wae',
    'waray'                              => 'war',
    'washo'                              => 'was',
    'yangben'                            => 'yav',
    'yao'                                => 'yao',
    'yapese'                             => 'yap',
    'yupiklanguage'                      => 'ypk',
    'zande'                              => 'znd',
    'zapotec'                            => 'zap',
    'zarma'                              => 'dje',
    'zaza'                               => 'zza',
    'zenaga'                             => 'zen',
    'zhuang'                             => 'za',
    'zuni'                               => 'zun',
    'آئبریائیہسپانوی'     => 'es_es',
    'آئسلینڈکاباشندہ'     => 'is',
    'آئيرِش'                       => 'ga',
    'آسامی'                         => 'as',
    'آسٹریائیجرمن'           => 'de_at',
    'آسٹریلیائیانگریزی' => 'en_au',
    'آکيٹانی'                     => 'oc',
    'ابقازیان'                   => 'ab',
    'اردو'                           => 'ur',
    'ارمینی'                       => 'hy',
    'ازبیک'                         => 'uz',
    'ازیری'                         => 'az',
    'اسٹونين'                     => 'et',
    'اطالوی'                       => 'it',
    'البانی'                       => 'sq',
    'امریکیانگریزی'         => 'en_us',
    'امہاری'                       => 'am',
    'انٹرلنگوی'                 => 'ia',
    'انڈونيثيائی'             => 'id',
    'انگريزی'                     => 'en',
    'اورِیا'                       => 'or',
    'اوسیٹک'                       => 'os',
    'ايسپرانٹو'                 => 'eo',
    'ايفريکانز'                 => 'af',
    'اِگبو'                         => 'ig',
    'ایفِک'                         => 'efi',
    'ایمارا'                       => 'ay',
    'باسکی'                         => 'eu',
    'برازیلیپرتگالی'       => 'pt_br',
    'برطانویانگریزی'       => 'en_gb',
    'برمی'                           => 'my',
    'برِیٹن'                       => 'br',
    'بلغاری'                       => 'bg',
    'بنگالی'                       => 'bn',
    'بوسنی'                         => 'bs',
    'بيلاروسی'                   => 'be',
    'بِہاری'                       => 'bh',
    'تاتار'                         => 'tt',
    'تاجک'                           => 'tg',
    'تاہیتی'                       => 'ty',
    'تبتی'                           => 'bo',
    'ترکمان'                       => 'tk',
    'ترکی'                           => 'tr',
    'تمل'                             => 'ta',
    'توی'                             => 'tw',
    'تھائی'                         => 'th',
    'تیلگو'                         => 'te',
    'جارجی'                         => 'ka',
    'جاوی'                           => 'jv',
    'جاپانی'                       => 'ja',
    'جرمن'                           => 'de',
    'جنوبیسوتھو'               => 'st',
    'روسی'                           => 'ru',
    'رومانش'                       => 'rm',
    'رومنی'                         => 'ro',
    'رونڈی'                         => 'rn',
    'زولو'                           => 'zu',
    'زونگا'                         => 'ts',
    'ساموآن'                       => 'sm',
    'سانگو'                         => 'sg',
    'سربوکروئیشین'           => 'sh',
    'سلوواک'                       => 'sk',
    'سلووینیائی'               => 'sl',
    'سندھی'                         => 'sd',
    'سنڈانیز'                     => 'su',
    'سنہالا'                       => 'si',
    'سوئسجرمن'                   => 'gsw',
    'سوئسفرینچ'                 => 'fr_ch',
    'سوئسہائیجرمن'           => 'de_ch',
    'سواتی'                         => 'ss',
    'سواحلی'                       => 'sw',
    'سوانا'                         => 'tn',
    'سویڈش'                         => 'sv',
    'سَنسکرِت'                   => 'sa',
    'سکاٹگيلِک'                 => 'gd',
    'شمالیدبیل'                 => 'nd',
    'شمالیسامی'                 => 'se',
    'شمالیسوتھو'               => 'nso',
    'شونا'                           => 'sn',
    'صربی'                           => 'sr',
    'صومالی'                       => 'so',
    'عبرانی'                       => 'he',
    'عربی'                           => 'ar',
    'فارسی'                         => 'fa',
    'فجیکاباشندہ'             => 'fj',
    'فرانسيسی'                   => 'fr',
    'فلیمِش'                       => 'nl_be',
    'فنّنِش'                       => 'fi',
    'فیروئیز'                     => 'fo',
    'قزاخ'                           => 'kk',
    'لاؤشِیَن'                   => 'lo',
    'لاطينی'                       => 'la',
    'لتھُواینین'               => 'lt',
    'ليٹوين'                       => 'lv',
    'لِنگَلا'                     => 'ln',
    'لگژمبرگکاباشندہ'     => 'lb',
    'ماؤری'                         => 'mi',
    'مالائی'                       => 'ms',
    'مالايالم'                   => 'ml',
    'مالٹی'                         => 'mt',
    'مراٹهی'                       => 'mr',
    'مغربیفریسیئن'           => 'fy',
    'مقدونيائی'                 => 'mk',
    'ملاگاسی'                     => 'mg',
    'منگؤلی'                       => 'mn',
    'نارويجين'                   => 'no',
    'نارویجینبوکمل'         => 'nb',
    'نامعلومزبان'             => 'und',
    'نورویجینینینورسک'   => 'nn',
    'نيپالی'                       => 'ne',
    'نیانجا'                       => 'ny',
    'وولوف'                         => 'wo',
    'ویتنامی'                     => 'vi',
    'ویلش'                           => 'cy',
    'وینڈا'                         => 've',
    'يادش'                           => 'yi',
    'يونانی'                       => 'el',
    'ٹونگا'                         => 'to',
    'ٹوکپِسِن'                   => 'tpi',
    'ٹيگالاگی'                   => 'fil',
    'ٹگرینیا'                     => 'ti',
    'ٹیٹم'                           => 'tet',
    'ٹیگالوگ'                     => 'tl',
    'پرتگالیپرتگال'         => 'pt_pt',
    'پشتو'                           => 'ps',
    'پنجابی'                       => 'pa',
    'پولستانی'                   => 'pl',
    'پُرتگالی'                   => 'pt',
    'چيک'                             => 'cs',
    'چینی'                           => 'zh',
    'ڈينش'                           => 'da',
    'ڈچ'                               => 'nl',
    'ڈیویہی'                       => 'dv',
    'ژوسا'                           => 'xh',
    'ژونگکھا'                     => 'dz',
    'کاٹالانين'                 => 'ca',
    'کراتی'                         => 'hr',
    'کردش'                           => 'ku',
    'کرغیزی'                       => 'ky',
    'کشمیری'                       => 'ks',
    'کلنگان'                       => 'tlh',
    'کمبوڈیَن'                   => 'km',
    'کنّاڈا'                       => 'kn',
    'کوئیلسانیموادنہیں' => 'zxx',
    'کورين'                         => 'ko',
    'کویچوآ'                       => 'qu',
    'کینیاروانڈا'             => 'rw',
    'کینیڈینانگریزی'       => 'en_ca',
    'کینیڈینفرانسیسی'     => 'fr_ca',
    'گاليشيائی'                 => 'gl',
    'گجراتی'                       => 'gu',
    'گُارانی'                     => 'gn',
    'ہؤسا'                           => 'ha',
    'ہسپانوی'                     => 'es',
    'ہندی'                           => 'hi',
    'ہنگیرین'                     => 'hu',
    'ہوائیکاباشندہ'         => 'haw',
    'ہیتی'                           => 'ht',
    'یوروبا'                       => 'yo',
    'یوکرینیائی'               => 'uk',
    'ییگہر'                         => 'ug',
);

1;
