package Locales::DB::Language::ru;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::ru::VERSION = '0.09';

$Locales::DB::Language::ru::cldr_version = '2.0';

%Locales::DB::Language::ru::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Язык\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ и\ \{1\}",
            'end'    => "\{0\}\ и\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Регион\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '“',
        'alternate_quotation_start' => '„',
        'quotation_end'             => '»',
        'quotation_start'           => '«'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'many',
            'other'
        ],
        'category_rules' => {
            'few'  => "n\ mod\ 10\ in\ 2\.\.4\ and\ n\ mod\ 100\ not\ in\ 12\.\.14",
            'many' => "n\ mod\ 10\ is\ 0\ or\ n\ mod\ 10\ in\ 5\.\.9\ or\ n\ mod\ 100\ in\ 11\.\.14",
            'one'  => "n\ mod\ 10\ is\ 1\ and\ n\ mod\ 100\ is\ not\ 11"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) >= 2 && ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) <= 4 ) && ( int( $_[0] ) != $_[0] || ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) < 12 || ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) > 14 ) ) ) { return 'few'; }
                return;
            },
            'many' => sub {
                if ( ( ( ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) == 0 ) ) || ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) >= 5 && ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) <= 9 ) ) || ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) >= 11 && ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) <= 14 ) ) ) { return 'many'; }
                return;
            },
            'one' => sub {
                if ( ( ( ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) == 1 ) && ( ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) != 11 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "нет\:н",
        'yesstr' => "да\:д"
    },
);

%Locales::DB::Language::ru::code_to_name = (
    'aa'    => 'афар',
    'ab'    => 'абхазский',
    'ace'   => 'ачехский',
    'ach'   => 'ачоли',
    'ada'   => 'адангме',
    'ady'   => 'адыгейский',
    'ae'    => 'авестийский',
    'af'    => 'африкаанс',
    'afa'   => "афразийский\ язык",
    'afh'   => 'африхили',
    'agq'   => 'Aghem',
    'ain'   => 'айну',
    'ak'    => 'акан',
    'akk'   => 'аккадский',
    'ale'   => 'алеутский',
    'alg'   => "алгонкинские\ языки",
    'alt'   => 'южноалтайский',
    'am'    => 'амхарский',
    'an'    => 'арагонский',
    'ang'   => 'староанглийский',
    'anp'   => 'ангика',
    'apa'   => "апачские\ языки",
    'ar'    => 'арабский',
    'arc'   => 'арамейский',
    'arn'   => 'арауканский',
    'arp'   => 'арапахо',
    'art'   => "искусственный\ язык",
    'arw'   => 'аравакский',
    'as'    => 'ассамский',
    'asa'   => 'Asu',
    'ast'   => 'астурийский',
    'ath'   => "атапачские\ языки",
    'aus'   => "австралийский\ язык",
    'av'    => 'аварский',
    'awa'   => 'авадхи',
    'ay'    => 'аймара',
    'az'    => 'азербайджанский',
    'ba'    => 'башкирский',
    'bad'   => 'банда',
    'bai'   => "бамилеке\ языки",
    'bal'   => 'белуджский',
    'ban'   => 'балийский',
    'bas'   => 'баса',
    'bat'   => "балтийский\ язык",
    'be'    => 'белорусский',
    'bej'   => 'беджа',
    'bem'   => 'бемба',
    'ber'   => 'берберский',
    'bez'   => 'Bena',
    'bg'    => 'болгарский',
    'bh'    => 'бихари',
    'bho'   => 'бходжпури',
    'bi'    => 'бислама',
    'bik'   => 'бикольский',
    'bin'   => 'бини',
    'bla'   => 'сиксика',
    'bm'    => 'бамбарийский',
    'bn'    => 'бенгальский',
    'bnt'   => 'банту',
    'bo'    => 'тибетский',
    'br'    => 'бретонский',
    'bra'   => 'брауи',
    'brx'   => 'Bodo',
    'bs'    => 'боснийский',
    'btk'   => 'батакский',
    'bua'   => 'бурятский',
    'bug'   => 'бугийский',
    'byn'   => "билин\ \(блин\)",
    'ca'    => 'каталанский',
    'cad'   => 'каддо',
    'cai'   => "язык\ индейцев\ Центральной\ Америки",
    'car'   => 'кариб',
    'cau'   => "кавказский\ язык",
    'cay'   => 'Cayuga',
    'cch'   => 'атсам',
    'ce'    => 'чеченский',
    'ceb'   => 'кебуано',
    'cel'   => "кельтские\ другие",
    'cgg'   => 'Chiga',
    'ch'    => 'чаморро',
    'chb'   => 'чибча',
    'chg'   => 'чагатайский',
    'chk'   => 'чукотский',
    'chm'   => "марийский\ \(черемисский\)",
    'chn'   => "чинук\ жаргон",
    'cho'   => 'чоктав',
    'chp'   => 'чипевайян',
    'chr'   => 'чероки',
    'chy'   => 'чейенн',
    'cmc'   => "чамский\ язык",
    'co'    => 'корсиканский',
    'cop'   => 'коптский',
    'cpe'   => "англо\-креольские\ и\ пиджин",
    'cpf'   => "франко\-креольские\ и\ пиджины",
    'cpp'   => "португало\-креольские\ и\ пиджины",
    'cr'    => 'криийский',
    'crh'   => "крымско\-татарский",
    'crp'   => "креольские\ и\ пиджины",
    'cs'    => 'чешский',
    'csb'   => 'кашубианский',
    'cu'    => 'церковнославянский',
    'cus'   => "кушитский\ язык",
    'cv'    => 'чувашский',
    'cy'    => 'валлийский',
    'da'    => 'датский',
    'dak'   => 'дакота',
    'dar'   => 'даргва',
    'dav'   => 'Taita',
    'day'   => 'даяк',
    'de'    => 'немецкий',
    'de_at' => "австрийский\ немецкий",
    'de_ch' => "швейцарский\ верхненемецкий",
    'del'   => 'делаварский',
    'den'   => 'славянский',
    'dgr'   => 'догриб',
    'din'   => 'динка',
    'dje'   => 'Zarma',
    'doi'   => 'догри',
    'dra'   => "дравидийский\ язык",
    'dsb'   => 'нижнелужицкий',
    'dua'   => 'дуала',
    'dum'   => 'средненидерландский',
    'dv'    => 'мальдивский',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => "диула\ \(дьюла\)",
    'dz'    => "дзонг\-кэ",
    'ebu'   => 'Embu',
    'ee'    => 'эве',
    'efi'   => 'эфик',
    'egy'   => 'древнеегипетский',
    'eka'   => 'экаджук',
    'el'    => 'греческий',
    'elx'   => 'эламский',
    'en'    => 'английский',
    'en_au' => "австралийский\ английский",
    'en_ca' => "канадский\ английский",
    'en_gb' => "британский\ английский",
    'en_us' => "американский\ английский",
    'enm'   => 'среднеанглийский',
    'eo'    => 'эсперанто',
    'es'    => 'испанский',
    'es_es' => "испанский\ иберийский",
    'et'    => 'эстонский',
    'eu'    => 'баскский',
    'ewo'   => 'эвондо',
    'fa'    => 'персидский',
    'fan'   => 'фанг',
    'fat'   => 'фанти',
    'ff'    => 'фулах',
    'fi'    => 'финский',
    'fil'   => 'филиппинский',
    'fiu'   => "финно\-угорский\ язык",
    'fj'    => 'фиджи',
    'fo'    => 'фарерский',
    'fon'   => 'фон',
    'fr'    => 'французский',
    'fr_ca' => "канадский\ французский",
    'fr_ch' => "швейцарский\ французский",
    'frm'   => 'среднефранцузский',
    'fro'   => 'старофранцузский',
    'frr'   => "фризский\ северный",
    'frs'   => "восточный\ фризский",
    'fur'   => 'фриульский',
    'fy'    => 'фризский',
    'ga'    => 'ирландский',
    'gaa'   => 'га',
    'gay'   => 'гайо',
    'gba'   => 'гбая',
    'gd'    => 'гэльский',
    'gem'   => "германский\ язык",
    'gez'   => 'геэз',
    'gil'   => 'гильбертский',
    'gl'    => 'галисийский',
    'gmh'   => 'средневерхненемецкий',
    'gn'    => 'гуарани',
    'goh'   => 'древневерхненемецкий',
    'gon'   => 'гонди',
    'gor'   => 'горонтало',
    'got'   => 'готский',
    'grb'   => 'гребо',
    'grc'   => 'древнегреческий',
    'gsw'   => "швейцарский\ немецкий",
    'gu'    => 'гуджарати',
    'guz'   => 'Gusii',
    'gv'    => 'мэнский',
    'gwi'   => 'гвичин',
    'ha'    => 'хауса',
    'hai'   => 'хайда',
    'haw'   => 'гавайский',
    'he'    => 'иврит',
    'hi'    => 'хинди',
    'hil'   => 'хилигайнон',
    'him'   => 'химачали',
    'hit'   => 'хеттский',
    'hmn'   => 'хмонг',
    'ho'    => 'хиримоту',
    'hr'    => 'хорватский',
    'hsb'   => 'верхнелужицкий',
    'ht'    => 'гаитянский',
    'hu'    => 'венгерский',
    'hup'   => 'хупа',
    'hy'    => 'армянский',
    'hz'    => 'гереро',
    'ia'    => 'интерлингва',
    'iba'   => 'ибанский',
    'id'    => 'индонезийский',
    'ie'    => 'интерлингве',
    'ig'    => 'игбо',
    'ii'    => 'сычуань',
    'ijo'   => 'иджо',
    'ik'    => 'инупиак',
    'ilo'   => 'илоко',
    'inc'   => "индийский\ язык",
    'ine'   => "индоевропейский\ язык",
    'inh'   => 'ингушский',
    'io'    => 'идо',
    'ira'   => "иранский\ язык",
    'iro'   => "ирокезские\ языки",
    'is'    => 'исландский',
    'it'    => 'итальянский',
    'iu'    => 'инуктитут',
    'ja'    => 'японский',
    'jbo'   => 'ложбан',
    'jmc'   => 'Machame',
    'jpr'   => "еврейско\-персидский",
    'jrb'   => "еврейско\-арабский",
    'jv'    => 'яванский',
    'ka'    => 'грузинский',
    'kaa'   => 'каракалпакский',
    'kab'   => 'кабильский',
    'kac'   => 'качинский',
    'kaj'   => 'каджи',
    'kam'   => 'камба',
    'kar'   => 'каренский',
    'kaw'   => 'кави',
    'kbd'   => 'кабардинский',
    'kcg'   => 'тьяп',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'коро',
    'kg'    => 'конго',
    'kha'   => 'кхаси',
    'khi'   => "койсанский\ язык",
    'kho'   => 'хотанский',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'кикуйю',
    'kj'    => 'кунама',
    'kk'    => 'казахский',
    'kl'    => 'гренландский',
    'kln'   => 'Kalenjin',
    'km'    => 'кхмерский',
    'kmb'   => 'кимбундийский',
    'kn'    => 'каннада',
    'ko'    => 'корейский',
    'kok'   => 'конкани',
    'kos'   => 'косраенский',
    'kpe'   => 'кпелле',
    'kr'    => 'канури',
    'krc'   => "карачаево\-балкарский",
    'krl'   => 'карельский',
    'kro'   => 'кру',
    'kru'   => 'курух',
    'ks'    => 'кашмири',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'курдский',
    'kum'   => 'кумыкский',
    'kut'   => 'кутенаи',
    'kv'    => 'коми',
    'kw'    => 'корнийский',
    'ky'    => 'киргизский',
    'la'    => 'латинский',
    'lad'   => 'ладино',
    'lag'   => 'Langi',
    'lah'   => 'лахнда',
    'lam'   => 'ламба',
    'lb'    => 'люксембургский',
    'lez'   => 'лезгинский',
    'lg'    => 'ганда',
    'li'    => 'лимбургский',
    'ln'    => 'лингала',
    'lo'    => 'лаосский',
    'lol'   => 'монго',
    'loz'   => 'лози',
    'lt'    => 'литовский',
    'lu'    => "луба\-катанга",
    'lua'   => "луба\-лулуа",
    'lui'   => 'луисеньо',
    'lun'   => 'лунда',
    'luo'   => "луо\ \(Кения\ и\ Танзания\)",
    'lus'   => 'лушай',
    'luy'   => 'Luyia',
    'lv'    => 'латышский',
    'mad'   => 'мадурский',
    'mag'   => 'магахи',
    'mai'   => 'майтхили',
    'mak'   => 'макассарский',
    'man'   => 'мандинго',
    'map'   => 'австронезийский',
    'mas'   => 'масаи',
    'mdf'   => 'мокшанский',
    'mdr'   => 'мандарский',
    'men'   => 'менде',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'малагасийский',
    'mga'   => 'среднеирландский',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'маршалльский',
    'mi'    => 'маори',
    'mic'   => 'микмак',
    'min'   => 'минангкабау',
    'mis'   => "смешанные\ языки",
    'mk'    => 'македонский',
    'mkh'   => "монкхмерский\ язык",
    'ml'    => 'малаялам',
    'mn'    => 'монгольский',
    'mnc'   => 'маньчжурский',
    'mni'   => 'манипурский',
    'mno'   => "манобо\ языки",
    'mo'    => 'молдавский',
    'moh'   => 'мохаук',
    'mos'   => 'моси',
    'mr'    => 'маратхи',
    'ms'    => 'малайский',
    'mt'    => 'мальтийский',
    'mua'   => 'Mundang',
    'mul'   => "несколько\ языков",
    'mun'   => "мунда\ языки",
    'mus'   => 'крик',
    'mwl'   => 'мирандийский',
    'mwr'   => 'марвари',
    'my'    => 'бирманский',
    'myn'   => "майя\ языки",
    'myv'   => 'эрзя',
    'na'    => 'науру',
    'nah'   => 'ацтекский',
    'nai'   => "язык\ индейцев\ Северной\ Америки",
    'nap'   => 'неаполитанский',
    'naq'   => 'Nama',
    'nb'    => "норвежский\ букмол",
    'nd'    => "северный\ ндебели",
    'nds'   => 'нижнегерманский',
    'ne'    => 'непальский',
    'new'   => 'неварский',
    'ng'    => 'ндонга',
    'nia'   => 'ниас',
    'nic'   => "нигер\-кордофанский\ язык",
    'niu'   => 'ниуэ',
    'nl'    => 'голландский',
    'nl_be' => "бельгийский\ фламандский",
    'nmg'   => 'Kwasio',
    'nn'    => "норвежский\ нюнорск",
    'no'    => 'норвежский',
    'nog'   => 'ногайский',
    'non'   => 'старонорвежский',
    'nqo'   => 'нко',
    'nr'    => "ндебели\ южный",
    'nso'   => "сото\ северный",
    'nub'   => "нубийские\ языки",
    'nus'   => 'Nuer',
    'nv'    => 'навахо',
    'nwc'   => "невари\ \(классический\)",
    'ny'    => 'ньянджа',
    'nym'   => 'ньямвези',
    'nyn'   => 'ньянколе',
    'nyo'   => 'ньоро',
    'nzi'   => 'нзима',
    'oc'    => 'окситанский',
    'oj'    => 'оджибва',
    'om'    => 'оромо',
    'or'    => 'ория',
    'os'    => 'осетинский',
    'osa'   => 'оседжи',
    'ota'   => 'старотурецкий',
    'oto'   => "отомангские\ языки",
    'pa'    => 'панджаби',
    'paa'   => "папуасский\ язык",
    'pag'   => 'пангасинан',
    'pal'   => 'пехлевийский',
    'pam'   => 'пампанга',
    'pap'   => 'папьяменто',
    'pau'   => 'палау',
    'peo'   => 'староперсидский',
    'phi'   => "филиппинский\ язык",
    'phn'   => 'финикийский',
    'pi'    => 'пали',
    'pl'    => 'польский',
    'pon'   => 'понапе',
    'pra'   => "пракриты\ языки",
    'pro'   => 'старопровансальский',
    'ps'    => 'пушту',
    'pt'    => 'португальский',
    'pt_br' => "бразильский\ португальский",
    'pt_pt' => "португальский\ иберийский",
    'qu'    => 'кечуа',
    'raj'   => 'раджастхани',
    'rap'   => 'рапануи',
    'rar'   => 'раротонганский',
    'rm'    => 'ретороманский',
    'rn'    => 'рунди',
    'ro'    => 'румынский',
    'roa'   => "романский\ язык",
    'rof'   => 'Rombo',
    'rom'   => 'цыганский',
    'ru'    => 'русский',
    'rup'   => 'арумынский',
    'rw'    => 'киньяруанда',
    'rwk'   => 'Rwa',
    'sa'    => 'санскрит',
    'sad'   => 'сандаве',
    'sah'   => 'якутский',
    'sai'   => "язык\ индейцев\ Южной\ Америки",
    'sal'   => "салишские\ языки",
    'sam'   => "самаритянский\ арамейский",
    'saq'   => 'Samburu',
    'sas'   => 'сасаки',
    'sat'   => 'сантали',
    'sbp'   => 'Sangu',
    'sc'    => 'сардинский',
    'scn'   => 'сицилийский',
    'sco'   => 'шотландский',
    'sd'    => 'синдхи',
    'se'    => 'северносаамский',
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'селькупский',
    'sem'   => "семитский\ язык",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'санго',
    'sga'   => 'староирландский',
    'sgn'   => "язык\ глухонемых",
    'sh'    => 'сербскохорватский',
    'shi'   => 'Tachelhit',
    'shn'   => 'шанский',
    'si'    => 'сингальский',
    'sid'   => 'сидама',
    'sio'   => "сиу\ языки",
    'sit'   => "синотибетский\ язык",
    'sk'    => 'словацкий',
    'sl'    => 'словенский',
    'sla'   => "славянский\ язык",
    'sm'    => 'самоанский',
    'sma'   => "саамский\ \(южный\)",
    'smi'   => "саамские\ языки",
    'smj'   => "луле\-саамский",
    'smn'   => "инари\-саамский",
    'sms'   => "скольт\-саамский",
    'sn'    => 'шона',
    'snk'   => 'сонинке',
    'so'    => 'сомали',
    'sog'   => 'согдийский',
    'son'   => 'сонгаи',
    'sq'    => 'албанский',
    'sr'    => 'сербский',
    'srn'   => "сранан\ тонго",
    'srr'   => 'серер',
    'ss'    => 'свази',
    'ssa'   => "нило\-сахарский\ язык",
    'ssy'   => 'Saho',
    'st'    => "сото\ южный",
    'su'    => 'сунданский',
    'suk'   => 'сукума',
    'sus'   => 'сусу',
    'sux'   => 'шумерский',
    'sv'    => 'шведский',
    'sw'    => 'суахили',
    'swb'   => 'коморский',
    'swc'   => "Congo\ Swahili",
    'syc'   => "классический\ сирийский",
    'syr'   => 'сирийский',
    'ta'    => 'тамильский',
    'tai'   => "тайский\ язык",
    'te'    => 'телугу',
    'tem'   => 'темне',
    'teo'   => 'Teso',
    'ter'   => 'терено',
    'tet'   => 'тетум',
    'tg'    => 'таджикский',
    'th'    => 'тайский',
    'ti'    => 'тигринья',
    'tig'   => 'тигре',
    'tiv'   => 'тиви',
    'tk'    => 'туркменский',
    'tkl'   => 'токелайский',
    'tl'    => 'тагалог',
    'tlh'   => 'клингонский',
    'tli'   => 'тлингит',
    'tmh'   => 'тамашек',
    'tn'    => 'тсвана',
    'to'    => 'тонга',
    'tog'   => "ньяса\ \(тонга\)",
    'tpi'   => "ток\-писин",
    'tr'    => 'турецкий',
    'trv'   => 'Taroko',
    'ts'    => 'тсонга',
    'tsi'   => 'цимшиан',
    'tt'    => 'татарский',
    'tum'   => 'тумбука',
    'tup'   => 'тупи',
    'tut'   => "алтайский\ язык",
    'tvl'   => 'тувалу',
    'tw'    => 'тви',
    'twq'   => 'Tasawaq',
    'ty'    => 'таитянский',
    'tyv'   => 'тувинский',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'удмуртский',
    'ug'    => 'уйгурский',
    'uga'   => 'угаритский',
    'uk'    => 'украинский',
    'umb'   => 'умбунду',
    'und'   => "неизвестный\ или\ недействительный\ язык",
    'ur'    => 'урду',
    'uz'    => 'узбекский',
    'vai'   => 'ваи',
    've'    => 'венда',
    'vi'    => 'вьетнамский',
    'vo'    => 'волапюк',
    'vot'   => 'водский',
    'vun'   => 'Vunjo',
    'wa'    => 'валлонский',
    'wae'   => 'Walser',
    'wak'   => "вакашские\ языки",
    'wal'   => 'воламо',
    'war'   => 'варай',
    'was'   => 'вашо',
    'wen'   => "лужицкие\ языки",
    'wo'    => 'волоф',
    'xal'   => 'калмыцкий',
    'xh'    => 'ксоза',
    'xog'   => 'Soga',
    'yao'   => 'яо',
    'yap'   => 'яп',
    'yav'   => 'Yangben',
    'yi'    => 'идиш',
    'yo'    => 'йоруба',
    'ypk'   => "юпикский\ язык",
    'yue'   => 'кантонский',
    'za'    => 'чжуань',
    'zap'   => 'сапотекский',
    'zbl'   => 'блиссимволика',
    'zen'   => 'зенагский',
    'zh'    => 'китайский',
    'znd'   => 'занде',
    'zu'    => 'зулу',
    'zun'   => 'зуньи',
    'zxx'   => "без\ языкового\ содержания",
    'zza'   => 'заза',
);

%Locales::DB::Language::ru::name_to_code = (
    'aghem'                                                                => 'agq',
    'asu'                                                                  => 'asa',
    'bafia'                                                                => 'ksf',
    'bena'                                                                 => 'bez',
    'bodo'                                                                 => 'brx',
    'cayuga'                                                               => 'cay',
    'centralmoroccotamazight'                                              => 'tzm',
    'chiga'                                                                => 'cgg',
    'colognian'                                                            => 'ksh',
    'congoswahili'                                                         => 'swc',
    'embu'                                                                 => 'ebu',
    'gusii'                                                                => 'guz',
    'jolafonyi'                                                            => 'dyo',
    'kabuverdianu'                                                         => 'kea',
    'kalenjin'                                                             => 'kln',
    'koyraborosenni'                                                       => 'ses',
    'koyrachiini'                                                          => 'khq',
    'kwasio'                                                               => 'nmg',
    'langi'                                                                => 'lag',
    'luyia'                                                                => 'luy',
    'machame'                                                              => 'jmc',
    'makhuwameetto'                                                        => 'mgh',
    'makonde'                                                              => 'kde',
    'meru'                                                                 => 'mer',
    'morisyen'                                                             => 'mfe',
    'mundang'                                                              => 'mua',
    'nama'                                                                 => 'naq',
    'nuer'                                                                 => 'nus',
    'rombo'                                                                => 'rof',
    'rwa'                                                                  => 'rwk',
    'saho'                                                                 => 'ssy',
    'samburu'                                                              => 'saq',
    'sangu'                                                                => 'sbp',
    'sena'                                                                 => 'seh',
    'seneca'                                                               => 'see',
    'shambala'                                                             => 'ksb',
    'soga'                                                                 => 'xog',
    'tachelhit'                                                            => 'shi',
    'taita'                                                                => 'dav',
    'taroko'                                                               => 'trv',
    'tasawaq'                                                              => 'twq',
    'teso'                                                                 => 'teo',
    'vunjo'                                                                => 'vun',
    'walser'                                                               => 'wae',
    'yangben'                                                              => 'yav',
    'zarma'                                                                => 'dje',
    'абхазский'                                                   => 'ab',
    'авадхи'                                                         => 'awa',
    'аварский'                                                     => 'av',
    'авестийский'                                               => 'ae',
    'австралийскийанглийский'                       => 'en_au',
    'австралийскийязык'                                   => 'aus',
    'австрийскийнемецкий'                               => 'de_at',
    'австронезийский'                                       => 'map',
    'адангме'                                                       => 'ada',
    'адыгейский'                                                 => 'ady',
    'азербайджанский'                                       => 'az',
    'аймара'                                                         => 'ay',
    'айну'                                                             => 'ain',
    'акан'                                                             => 'ak',
    'аккадский'                                                   => 'akk',
    'албанский'                                                   => 'sq',
    'алгонкинскиеязыки'                                   => 'alg',
    'алеутский'                                                   => 'ale',
    'алтайскийязык'                                           => 'tut',
    'американскийанглийский'                         => 'en_us',
    'амхарский'                                                   => 'am',
    'ангика'                                                         => 'anp',
    'английский'                                                 => 'en',
    'англокреольскиеипиджин'                         => 'cpe',
    'апачскиеязыки'                                           => 'apa',
    'арабский'                                                     => 'ar',
    'аравакский'                                                 => 'arw',
    'арагонский'                                                 => 'an',
    'арамейский'                                                 => 'arc',
    'арапахо'                                                       => 'arp',
    'арауканский'                                               => 'arn',
    'армянский'                                                   => 'hy',
    'арумынский'                                                 => 'rup',
    'ассамский'                                                   => 'as',
    'астурийский'                                               => 'ast',
    'атапачскиеязыки'                                       => 'ath',
    'атсам'                                                           => 'cch',
    'афар'                                                             => 'aa',
    'афразийскийязык'                                       => 'afa',
    'африкаанс'                                                   => 'af',
    'африхили'                                                     => 'afh',
    'ацтекский'                                                   => 'nah',
    'ачехский'                                                     => 'ace',
    'ачоли'                                                           => 'ach',
    'балийский'                                                   => 'ban',
    'балтийскийязык'                                         => 'bat',
    'бамбарийский'                                             => 'bm',
    'бамилекеязыки'                                           => 'bai',
    'банда'                                                           => 'bad',
    'банту'                                                           => 'bnt',
    'баса'                                                             => 'bas',
    'баскский'                                                     => 'eu',
    'батакский'                                                   => 'btk',
    'башкирский'                                                 => 'ba',
    'беджа'                                                           => 'bej',
    'безязыковогосодержания'                         => 'zxx',
    'белорусский'                                               => 'be',
    'белуджский'                                                 => 'bal',
    'бельгийскийфламандский'                         => 'nl_be',
    'бемба'                                                           => 'bem',
    'бенгальский'                                               => 'bn',
    'берберский'                                                 => 'ber',
    'бикольский'                                                 => 'bik',
    'билинблин'                                                   => 'byn',
    'бини'                                                             => 'bin',
    'бирманский'                                                 => 'my',
    'бислама'                                                       => 'bi',
    'бихари'                                                         => 'bh',
    'блиссимволика'                                           => 'zbl',
    'болгарский'                                                 => 'bg',
    'боснийский'                                                 => 'bs',
    'бразильскийпортугальский'                     => 'pt_br',
    'брауи'                                                           => 'bra',
    'бретонский'                                                 => 'br',
    'британскийанглийский'                             => 'en_gb',
    'бугийский'                                                   => 'bug',
    'бурятский'                                                   => 'bua',
    'бходжпури'                                                   => 'bho',
    'ваи'                                                               => 'vai',
    'вакашскиеязыки'                                         => 'wak',
    'валлийский'                                                 => 'cy',
    'валлонский'                                                 => 'wa',
    'варай'                                                           => 'war',
    'вашо'                                                             => 'was',
    'венгерский'                                                 => 'hu',
    'венда'                                                           => 've',
    'верхнелужицкий'                                         => 'hsb',
    'водский'                                                       => 'vot',
    'воламо'                                                         => 'wal',
    'волапюк'                                                       => 'vo',
    'волоф'                                                           => 'wo',
    'восточныйфризский'                                   => 'frs',
    'вьетнамский'                                               => 'vi',
    'га'                                                                 => 'gaa',
    'гавайский'                                                   => 'haw',
    'гаитянский'                                                 => 'ht',
    'гайо'                                                             => 'gay',
    'галисийский'                                               => 'gl',
    'ганда'                                                           => 'lg',
    'гбая'                                                             => 'gba',
    'гвичин'                                                         => 'gwi',
    'гереро'                                                         => 'hz',
    'германскийязык'                                         => 'gem',
    'геэз'                                                             => 'gez',
    'гильбертский'                                             => 'gil',
    'голландский'                                               => 'nl',
    'гонди'                                                           => 'gon',
    'горонтало'                                                   => 'gor',
    'готский'                                                       => 'got',
    'гребо'                                                           => 'grb',
    'гренландский'                                             => 'kl',
    'греческий'                                                   => 'el',
    'грузинский'                                                 => 'ka',
    'гуарани'                                                       => 'gn',
    'гуджарати'                                                   => 'gu',
    'гэльский'                                                     => 'gd',
    'дакота'                                                         => 'dak',
    'даргва'                                                         => 'dar',
    'датский'                                                       => 'da',
    'даяк'                                                             => 'day',
    'делаварский'                                               => 'del',
    'дзонгкэ'                                                       => 'dz',
    'динка'                                                           => 'din',
    'диуладьюла'                                                 => 'dyu',
    'догри'                                                           => 'doi',
    'догриб'                                                         => 'dgr',
    'дравидийскийязык'                                     => 'dra',
    'древневерхненемецкий'                             => 'goh',
    'древнегреческий'                                       => 'grc',
    'древнеегипетский'                                     => 'egy',
    'дуала'                                                           => 'dua',
    'еврейскоарабский'                                     => 'jrb',
    'еврейскоперсидский'                                 => 'jpr',
    'заза'                                                             => 'zza',
    'занде'                                                           => 'znd',
    'зенагский'                                                   => 'zen',
    'зулу'                                                             => 'zu',
    'зуньи'                                                           => 'zun',
    'ибанский'                                                     => 'iba',
    'иврит'                                                           => 'he',
    'игбо'                                                             => 'ig',
    'иджо'                                                             => 'ijo',
    'идиш'                                                             => 'yi',
    'идо'                                                               => 'io',
    'илоко'                                                           => 'ilo',
    'инарисаамский'                                           => 'smn',
    'ингушский'                                                   => 'inh',
    'индийскийязык'                                           => 'inc',
    'индоевропейскийязык'                               => 'ine',
    'индонезийский'                                           => 'id',
    'интерлингва'                                               => 'ia',
    'интерлингве'                                               => 'ie',
    'инуктитут'                                                   => 'iu',
    'инупиак'                                                       => 'ik',
    'иранскийязык'                                             => 'ira',
    'ирландский'                                                 => 'ga',
    'ирокезскиеязыки'                                       => 'iro',
    'искусственныйязык'                                   => 'art',
    'исландский'                                                 => 'is',
    'испанский'                                                   => 'es',
    'испанскийиберийский'                               => 'es_es',
    'итальянский'                                               => 'it',
    'йоруба'                                                         => 'yo',
    'кабардинский'                                             => 'kbd',
    'кабильский'                                                 => 'kab',
    'кави'                                                             => 'kaw',
    'кавказскийязык'                                         => 'cau',
    'каддо'                                                           => 'cad',
    'каджи'                                                           => 'kaj',
    'казахский'                                                   => 'kk',
    'калмыцкий'                                                   => 'xal',
    'камба'                                                           => 'kam',
    'канадскийанглийский'                               => 'en_ca',
    'канадскийфранцузский'                             => 'fr_ca',
    'каннада'                                                       => 'kn',
    'кантонский'                                                 => 'yue',
    'канури'                                                         => 'kr',
    'каракалпакский'                                         => 'kaa',
    'карачаевобалкарский'                               => 'krc',
    'карельский'                                                 => 'krl',
    'каренский'                                                   => 'kar',
    'кариб'                                                           => 'car',
    'каталанский'                                               => 'ca',
    'качинский'                                                   => 'kac',
    'кашмири'                                                       => 'ks',
    'кашубианский'                                             => 'csb',
    'кебуано'                                                       => 'ceb',
    'кельтскиедругие'                                       => 'cel',
    'кечуа'                                                           => 'qu',
    'кикуйю'                                                         => 'ki',
    'кимбундийский'                                           => 'kmb',
    'киньяруанда'                                               => 'rw',
    'киргизский'                                                 => 'ky',
    'китайский'                                                   => 'zh',
    'классическийсирийский'                           => 'syc',
    'клингонский'                                               => 'tlh',
    'койсанскийязык'                                         => 'khi',
    'коми'                                                             => 'kv',
    'коморский'                                                   => 'swb',
    'конго'                                                           => 'kg',
    'конкани'                                                       => 'kok',
    'коптский'                                                     => 'cop',
    'корейский'                                                   => 'ko',
    'корнийский'                                                 => 'kw',
    'коро'                                                             => 'kfo',
    'корсиканский'                                             => 'co',
    'косраенский'                                               => 'kos',
    'кпелле'                                                         => 'kpe',
    'креольскиеипиджины'                                 => 'crp',
    'криийский'                                                   => 'cr',
    'крик'                                                             => 'mus',
    'кру'                                                               => 'kro',
    'крымскотатарский'                                     => 'crh',
    'ксоза'                                                           => 'xh',
    'кумыкский'                                                   => 'kum',
    'кунама'                                                         => 'kj',
    'курдский'                                                     => 'ku',
    'курух'                                                           => 'kru',
    'кутенаи'                                                       => 'kut',
    'кушитскийязык'                                           => 'cus',
    'кхаси'                                                           => 'kha',
    'кхмерский'                                                   => 'km',
    'ладино'                                                         => 'lad',
    'ламба'                                                           => 'lam',
    'лаосский'                                                     => 'lo',
    'латинский'                                                   => 'la',
    'латышский'                                                   => 'lv',
    'лахнда'                                                         => 'lah',
    'лезгинский'                                                 => 'lez',
    'лимбургский'                                               => 'li',
    'лингала'                                                       => 'ln',
    'литовский'                                                   => 'lt',
    'ложбан'                                                         => 'jbo',
    'лози'                                                             => 'loz',
    'лубакатанга'                                               => 'lu',
    'лубалулуа'                                                   => 'lua',
    'лужицкиеязыки'                                           => 'wen',
    'луисеньо'                                                     => 'lui',
    'лулесаамский'                                             => 'smj',
    'лунда'                                                           => 'lun',
    'луоКенияиТанзания'                                   => 'luo',
    'лушай'                                                           => 'lus',
    'люксембургский'                                         => 'lb',
    'магахи'                                                         => 'mag',
    'мадурский'                                                   => 'mad',
    'майтхили'                                                     => 'mai',
    'майяязыки'                                                   => 'myn',
    'макассарский'                                             => 'mak',
    'македонский'                                               => 'mk',
    'малагасийский'                                           => 'mg',
    'малайский'                                                   => 'ms',
    'малаялам'                                                     => 'ml',
    'мальдивский'                                               => 'dv',
    'мальтийский'                                               => 'mt',
    'мандарский'                                                 => 'mdr',
    'мандинго'                                                     => 'man',
    'манипурский'                                               => 'mni',
    'манобоязыки'                                               => 'mno',
    'маньчжурский'                                             => 'mnc',
    'маори'                                                           => 'mi',
    'маратхи'                                                       => 'mr',
    'марвари'                                                       => 'mwr',
    'марийскийчеремисский'                             => 'chm',
    'маршалльский'                                             => 'mh',
    'масаи'                                                           => 'mas',
    'менде'                                                           => 'men',
    'микмак'                                                         => 'mic',
    'минангкабау'                                               => 'min',
    'мирандийский'                                             => 'mwl',
    'мокшанский'                                                 => 'mdf',
    'молдавский'                                                 => 'mo',
    'монго'                                                           => 'lol',
    'монгольский'                                               => 'mn',
    'монкхмерскийязык'                                     => 'mkh',
    'моси'                                                             => 'mos',
    'мохаук'                                                         => 'moh',
    'мундаязыки'                                                 => 'mun',
    'мэнский'                                                       => 'gv',
    'навахо'                                                         => 'nv',
    'науру'                                                           => 'na',
    'ндебелиюжный'                                             => 'nr',
    'ндонга'                                                         => 'ng',
    'неаполитанский'                                         => 'nap',
    'невариклассический'                                 => 'nwc',
    'неварский'                                                   => 'new',
    'неизвестныйилинедействительныйязык' => 'und',
    'немецкий'                                                     => 'de',
    'непальский'                                                 => 'ne',
    'несколькоязыков'                                       => 'mul',
    'нзима'                                                           => 'nzi',
    'ниас'                                                             => 'nia',
    'нигеркордофанскийязык'                           => 'nic',
    'нижнегерманский'                                       => 'nds',
    'нижнелужицкий'                                           => 'dsb',
    'нилосахарскийязык'                                   => 'ssa',
    'ниуэ'                                                             => 'niu',
    'нко'                                                               => 'nqo',
    'ногайский'                                                   => 'nog',
    'норвежский'                                                 => 'no',
    'норвежскийбукмол'                                     => 'nb',
    'норвежскийнюнорск'                                   => 'nn',
    'нубийскиеязыки'                                         => 'nub',
    'ньоро'                                                           => 'nyo',
    'ньямвези'                                                     => 'nym',
    'ньянджа'                                                       => 'ny',
    'ньянколе'                                                     => 'nyn',
    'ньясатонга'                                                 => 'tog',
    'оджибва'                                                       => 'oj',
    'окситанский'                                               => 'oc',
    'ория'                                                             => 'or',
    'оромо'                                                           => 'om',
    'оседжи'                                                         => 'osa',
    'осетинский'                                                 => 'os',
    'отомангскиеязыки'                                     => 'oto',
    'палау'                                                           => 'pau',
    'пали'                                                             => 'pi',
    'пампанга'                                                     => 'pam',
    'пангасинан'                                                 => 'pag',
    'панджаби'                                                     => 'pa',
    'папуасскийязык'                                         => 'paa',
    'папьяменто'                                                 => 'pap',
    'персидский'                                                 => 'fa',
    'пехлевийский'                                             => 'pal',
    'польский'                                                     => 'pl',
    'понапе'                                                         => 'pon',
    'португалокреольскиеипиджины'               => 'cpp',
    'португальский'                                           => 'pt',
    'португальскийиберийский'                       => 'pt_pt',
    'пракритыязыки'                                           => 'pra',
    'пушту'                                                           => 'ps',
    'раджастхани'                                               => 'raj',
    'рапануи'                                                       => 'rap',
    'раротонганский'                                         => 'rar',
    'ретороманский'                                           => 'rm',
    'романскийязык'                                           => 'roa',
    'румынский'                                                   => 'ro',
    'рунди'                                                           => 'rn',
    'русский'                                                       => 'ru',
    'саамскиеязыки'                                           => 'smi',
    'саамскийюжный'                                           => 'sma',
    'салишскиеязыки'                                         => 'sal',
    'самаритянскийарамейский'                       => 'sam',
    'самоанский'                                                 => 'sm',
    'санго'                                                           => 'sg',
    'сандаве'                                                       => 'sad',
    'санскрит'                                                     => 'sa',
    'сантали'                                                       => 'sat',
    'сапотекский'                                               => 'zap',
    'сардинский'                                                 => 'sc',
    'сасаки'                                                         => 'sas',
    'свази'                                                           => 'ss',
    'северносаамский'                                       => 'se',
    'северныйндебели'                                       => 'nd',
    'селькупский'                                               => 'sel',
    'семитскийязык'                                           => 'sem',
    'сербский'                                                     => 'sr',
    'сербскохорватский'                                   => 'sh',
    'серер'                                                           => 'srr',
    'сидама'                                                         => 'sid',
    'сиксика'                                                       => 'bla',
    'сингальский'                                               => 'si',
    'синдхи'                                                         => 'sd',
    'синотибетскийязык'                                   => 'sit',
    'сирийский'                                                   => 'syr',
    'сиуязыки'                                                     => 'sio',
    'сицилийский'                                               => 'scn',
    'скольтсаамский'                                         => 'sms',
    'славянский'                                                 => 'den',
    'славянскийязык'                                         => 'sla',
    'словацкий'                                                   => 'sk',
    'словенский'                                                 => 'sl',
    'смешанныеязыки'                                         => 'mis',
    'согдийский'                                                 => 'sog',
    'сомали'                                                         => 'so',
    'сонгаи'                                                         => 'son',
    'сонинке'                                                       => 'snk',
    'сотосеверный'                                             => 'nso',
    'сотоюжный'                                                   => 'st',
    'сранантонго'                                               => 'srn',
    'среднеанглийский'                                     => 'enm',
    'средневерхненемецкий'                             => 'gmh',
    'среднеирландский'                                     => 'mga',
    'средненидерландский'                               => 'dum',
    'среднефранцузский'                                   => 'frm',
    'староанглийский'                                       => 'ang',
    'староирландский'                                       => 'sga',
    'старонорвежский'                                       => 'non',
    'староперсидский'                                       => 'peo',
    'старопровансальский'                               => 'pro',
    'старотурецкий'                                           => 'ota',
    'старофранцузский'                                     => 'fro',
    'суахили'                                                       => 'sw',
    'сукума'                                                         => 'suk',
    'сунданский'                                                 => 'su',
    'сусу'                                                             => 'sus',
    'сычуань'                                                       => 'ii',
    'тагалог'                                                       => 'tl',
    'таджикский'                                                 => 'tg',
    'таитянский'                                                 => 'ty',
    'тайский'                                                       => 'th',
    'тайскийязык'                                               => 'tai',
    'тамашек'                                                       => 'tmh',
    'тамильский'                                                 => 'ta',
    'татарский'                                                   => 'tt',
    'тви'                                                               => 'tw',
    'телугу'                                                         => 'te',
    'темне'                                                           => 'tem',
    'терено'                                                         => 'ter',
    'тетум'                                                           => 'tet',
    'тибетский'                                                   => 'bo',
    'тиви'                                                             => 'tiv',
    'тигре'                                                           => 'tig',
    'тигринья'                                                     => 'ti',
    'тлингит'                                                       => 'tli',
    'токелайский'                                               => 'tkl',
    'токписин'                                                     => 'tpi',
    'тонга'                                                           => 'to',
    'тсвана'                                                         => 'tn',
    'тсонга'                                                         => 'ts',
    'тувалу'                                                         => 'tvl',
    'тувинский'                                                   => 'tyv',
    'тумбука'                                                       => 'tum',
    'тупи'                                                             => 'tup',
    'турецкий'                                                     => 'tr',
    'туркменский'                                               => 'tk',
    'тьяп'                                                             => 'kcg',
    'угаритский'                                                 => 'uga',
    'удмуртский'                                                 => 'udm',
    'узбекский'                                                   => 'uz',
    'уйгурский'                                                   => 'ug',
    'украинский'                                                 => 'uk',
    'умбунду'                                                       => 'umb',
    'урду'                                                             => 'ur',
    'фанг'                                                             => 'fan',
    'фанти'                                                           => 'fat',
    'фарерский'                                                   => 'fo',
    'фиджи'                                                           => 'fj',
    'филиппинский'                                             => 'fil',
    'филиппинскийязык'                                     => 'phi',
    'финикийский'                                               => 'phn',
    'финноугорскийязык'                                   => 'fiu',
    'финский'                                                       => 'fi',
    'фон'                                                               => 'fon',
    'франкокреольскиеипиджины'                     => 'cpf',
    'французский'                                               => 'fr',
    'фризский'                                                     => 'fy',
    'фризскийсеверный'                                     => 'frr',
    'фриульский'                                                 => 'fur',
    'фулах'                                                           => 'ff',
    'хайда'                                                           => 'hai',
    'хауса'                                                           => 'ha',
    'хеттский'                                                     => 'hit',
    'хилигайнон'                                                 => 'hil',
    'химачали'                                                     => 'him',
    'хинди'                                                           => 'hi',
    'хиримоту'                                                     => 'ho',
    'хмонг'                                                           => 'hmn',
    'хорватский'                                                 => 'hr',
    'хотанский'                                                   => 'kho',
    'хупа'                                                             => 'hup',
    'церковнославянский'                                 => 'cu',
    'цимшиан'                                                       => 'tsi',
    'цыганский'                                                   => 'rom',
    'чагатайский'                                               => 'chg',
    'чаморро'                                                       => 'ch',
    'чамскийязык'                                               => 'cmc',
    'чейенн'                                                         => 'chy',
    'чероки'                                                         => 'chr',
    'чеченский'                                                   => 'ce',
    'чешский'                                                       => 'cs',
    'чжуань'                                                         => 'za',
    'чибча'                                                           => 'chb',
    'чинукжаргон'                                               => 'chn',
    'чипевайян'                                                   => 'chp',
    'чоктав'                                                         => 'cho',
    'чувашский'                                                   => 'cv',
    'чукотский'                                                   => 'chk',
    'шанский'                                                       => 'shn',
    'шведский'                                                     => 'sv',
    'швейцарскийверхненемецкий'                   => 'de_ch',
    'швейцарскийнемецкий'                               => 'gsw',
    'швейцарскийфранцузский'                         => 'fr_ch',
    'шона'                                                             => 'sn',
    'шотландский'                                               => 'sco',
    'шумерский'                                                   => 'sux',
    'эве'                                                               => 'ee',
    'эвондо'                                                         => 'ewo',
    'экаджук'                                                       => 'eka',
    'эламский'                                                     => 'elx',
    'эрзя'                                                             => 'myv',
    'эсперанто'                                                   => 'eo',
    'эстонский'                                                   => 'et',
    'эфик'                                                             => 'efi',
    'южноалтайский'                                           => 'alt',
    'юпикскийязык'                                             => 'ypk',
    'яванский'                                                     => 'jv',
    'языкглухонемых'                                         => 'sgn',
    'языкиндейцевСевернойАмерики'               => 'nai',
    'языкиндейцевЦентральнойАмерики'         => 'cai',
    'языкиндейцевЮжнойАмерики'                     => 'sai',
    'якутский'                                                     => 'sah',
    'яо'                                                                 => 'yao',
    'яп'                                                                 => 'yap',
    'японский'                                                     => 'ja',
);

1;
