package Locales::DB::Language::mk;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::mk::VERSION = '0.09';

$Locales::DB::Language::mk::cldr_version = '2.0';

%Locales::DB::Language::mk::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Јазик\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Регион\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\â\\",
        'alternate_quotation_start' => "\â\\",
        'quotation_end'             => "\â\\",
        'quotation_start'           => "\â\\"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ mod\ 10\ is\ 1\ and\ n\ is\ not\ 11" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) == 1 ) && ( $_[0] != 11 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "не\:н",
        'yesstr' => "да\:д"
    },
);

%Locales::DB::Language::mk::code_to_name = (
    'aa'    => 'афар',
    'ab'    => 'абхазиски',
    'ace'   => 'акинески',
    'ach'   => 'аколи',
    'ada'   => 'адангме',
    'ady'   => 'адиге',
    'ae'    => 'авестан',
    'af'    => 'африкански',
    'afa'   => 'афроазијатски',
    'afh'   => 'африхили',
    'agq'   => 'Aghem',
    'ain'   => 'аину',
    'ak'    => 'акан',
    'akk'   => 'акадијски',
    'ale'   => 'алеут',
    'alg'   => 'алгонквијански',
    'alt'   => "јужен\ алтај",
    'am'    => 'амхариски',
    'an'    => 'арагонески',
    'ang'   => "стар\ англиски",
    'anp'   => 'ангика',
    'apa'   => 'апачи',
    'ar'    => 'арапски',
    'arc'   => 'арамејски',
    'arn'   => 'арокенски',
    'arp'   => 'арапахо',
    'art'   => 'вештачки',
    'arw'   => 'аравак',
    'as'    => 'асамски',
    'asa'   => 'Asu',
    'ast'   => 'астуриски',
    'ath'   => 'атапаски',
    'aus'   => 'австралиски',
    'av'    => 'аварски',
    'awa'   => 'авади',
    'ay'    => 'ајмара',
    'az'    => 'азербејџански',
    'ba'    => 'башкирски',
    'bad'   => 'банда',
    'bai'   => 'бамилеке',
    'bal'   => 'балучи',
    'ban'   => 'балинезе',
    'bas'   => 'баса',
    'bat'   => 'балтички',
    'be'    => 'белоруски',
    'bej'   => 'беха',
    'bem'   => 'бемба',
    'ber'   => 'бербер',
    'bez'   => 'Bena',
    'bg'    => 'бугарски',
    'bh'    => 'бихари',
    'bho'   => 'бојпури',
    'bi'    => 'бислама',
    'bik'   => 'бикол',
    'bin'   => 'бини',
    'bla'   => 'сиксика',
    'bm'    => 'бамбара',
    'bn'    => 'бенгалски',
    'bnt'   => 'банту',
    'bo'    => 'тибетски',
    'br'    => 'бретонски',
    'bra'   => 'брај',
    'brx'   => 'Bodo',
    'bs'    => 'босански',
    'btk'   => 'батак',
    'bua'   => 'буријат',
    'bug'   => 'буџински',
    'byn'   => 'блин',
    'ca'    => 'каталонски',
    'cad'   => 'кадо',
    'cai'   => "централноамерикански\ индијански",
    'car'   => 'кариб',
    'cau'   => 'кавкаски',
    'cay'   => 'Cayuga',
    'cch'   => 'ацам',
    'ce'    => 'чеченски',
    'ceb'   => 'себуано',
    'cel'   => 'селтички',
    'cgg'   => 'Chiga',
    'ch'    => 'чаморо',
    'chb'   => 'чибча',
    'chg'   => 'чагатај',
    'chk'   => 'чуук',
    'chm'   => 'мари',
    'chn'   => "жаргон\ чинук",
    'cho'   => 'чокто',
    'chp'   => 'чипујан',
    'chr'   => 'чироки',
    'chy'   => 'чејенски',
    'cmc'   => 'чамски',
    'co'    => 'корзикански',
    'cop'   => 'коптски',
    'cpe'   => "англиски\ креолски",
    'cpf'   => "француски\ креолски",
    'cpp'   => "португалски\ креолски",
    'cr'    => 'кри',
    'crh'   => "кримско\ турски",
    'crp'   => 'креолски',
    'cs'    => 'чешки',
    'csb'   => 'кашубиски',
    'cu'    => 'црковнословенски',
    'cus'   => 'кушитски',
    'cv'    => 'чувашки',
    'cy'    => 'велшки',
    'da'    => 'дански',
    'dak'   => 'дакота',
    'dar'   => 'даргва',
    'dav'   => 'Taita',
    'day'   => 'дајак',
    'de'    => 'германски',
    'de_at' => "германски\ \(во\ Австрија\)",
    'de_ch' => "германски\ \(во\ Швајцарија\)",
    'del'   => 'делавер',
    'den'   => 'славски',
    'dgr'   => 'догриб',
    'din'   => 'динка',
    'dje'   => 'Zarma',
    'doi'   => 'догри',
    'dra'   => 'дравидијски',
    'dsb'   => 'долносорбиски',
    'dua'   => 'дуала',
    'dum'   => 'среднохоландски',
    'dv'    => 'дивехи',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'џула',
    'dz'    => 'џонга',
    'ebu'   => 'Embu',
    'ee'    => 'еве',
    'efi'   => 'ефик',
    'egy'   => 'староегипетски',
    'eka'   => 'екајук',
    'el'    => 'грчки',
    'elx'   => 'еламит',
    'en'    => 'англиски',
    'en_au' => "англиски\ \(во\ Австралија\)",
    'en_ca' => "англиски\ \(во\ Канада\)",
    'en_gb' => "англиски\ \(во\ Велика\ Британија\)",
    'en_us' => "американски\ англиски",
    'enm'   => 'средноанглиски',
    'eo'    => 'есперанто',
    'es'    => 'шпански',
    'es_es' => "шпански\ \(во\ Португалија\)",
    'et'    => 'естонски',
    'eu'    => 'баскиски',
    'ewo'   => 'евондо',
    'fa'    => 'персиски',
    'fan'   => 'фанг',
    'fat'   => 'фанти',
    'ff'    => 'фула',
    'fi'    => 'фински',
    'fil'   => 'филипински',
    'fiu'   => 'финоугриски',
    'fj'    => 'фиџиски',
    'fo'    => 'фарски',
    'fon'   => 'фон',
    'fr'    => 'француски',
    'fr_ca' => "француски\ \(во\ Канада\)",
    'fr_ch' => "француски\ \(во\ Швајцарија\)",
    'frm'   => 'среднофранцуски',
    'fro'   => "стар\ француски",
    'frr'   => "северен\ фризиски",
    'frs'   => "источен\ фризиски",
    'fur'   => 'фрулијански',
    'fy'    => 'фризиски',
    'ga'    => 'ирски',
    'gaa'   => 'га',
    'gay'   => 'гајо',
    'gba'   => 'гбаја',
    'gd'    => "шкотско\ галски",
    'gem'   => "германски\ јазици",
    'gez'   => 'гиз',
    'gil'   => 'гилбертански',
    'gl'    => 'галициски',
    'gmh'   => "среден\ горногермански",
    'gn'    => 'гуарани',
    'goh'   => "стар\ високогермански",
    'gon'   => 'гонди',
    'gor'   => 'горонтало',
    'got'   => 'готски',
    'grb'   => 'гребо',
    'grc'   => 'старогрчки',
    'gsw'   => "швајцарско\ германски",
    'gu'    => 'гуџарати',
    'guz'   => 'Gusii',
    'gv'    => 'манкс',
    'gwi'   => 'гвишин',
    'ha'    => 'хауза',
    'hai'   => 'хајда',
    'haw'   => 'хавајски',
    'he'    => 'хебрејски',
    'hi'    => 'хинди',
    'hil'   => 'хилигајнон',
    'him'   => 'химашали',
    'hit'   => 'хитите',
    'hmn'   => 'хмонг',
    'ho'    => "хири\ моту",
    'hr'    => 'хрватски',
    'hsb'   => 'горносорбиски',
    'ht'    => 'хаитски',
    'hu'    => 'унгарски',
    'hup'   => 'хупа',
    'hy'    => 'ерменски',
    'hz'    => 'хереро',
    'ia'    => 'интерлингва',
    'iba'   => 'ибан',
    'id'    => 'индонезиски',
    'ie'    => 'интерлинг',
    'ig'    => 'игбо',
    'ii'    => "сичуан\ ји",
    'ijo'   => 'ихо',
    'ik'    => 'инупијак',
    'ilo'   => 'илоко',
    'inc'   => "индиски\ јазици",
    'ine'   => 'индоевропски',
    'inh'   => 'ингуш',
    'io'    => 'идо',
    'ira'   => 'ирански',
    'iro'   => "ироквијански\ јазици",
    'is'    => 'исландски',
    'it'    => 'италијански',
    'iu'    => 'инуктитут',
    'ja'    => 'јапонски',
    'jbo'   => 'лојбански',
    'jmc'   => 'Machame',
    'jpr'   => "еврејско\ персиски",
    'jrb'   => "еврејско\ арапски",
    'jv'    => 'јавански',
    'ka'    => 'грузиски',
    'kaa'   => "кара\ калпак",
    'kab'   => 'кабиле',
    'kac'   => 'кашин',
    'kaj'   => 'жжи',
    'kam'   => 'камба',
    'kar'   => 'карен',
    'kaw'   => 'кави',
    'kbd'   => 'кабардиски',
    'kcg'   => 'тјап',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'коро',
    'kg'    => 'конго',
    'kha'   => 'каси',
    'khi'   => "којсански\ јазици",
    'kho'   => 'котанески',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'кикују',
    'kj'    => 'куањама',
    'kk'    => 'казакстански',
    'kl'    => 'калалисут',
    'kln'   => 'Kalenjin',
    'km'    => 'камбоџански',
    'kmb'   => 'кимбунду',
    'kn'    => 'каннада',
    'ko'    => 'корејски',
    'kok'   => 'конкани',
    'kos'   => 'козрејски',
    'kpe'   => 'кпеле',
    'kr'    => 'канури',
    'krc'   => "карашај\-балкар",
    'krl'   => 'карелијски',
    'kro'   => 'кру',
    'kru'   => 'курук',
    'ks'    => 'кашмирски',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'курдски',
    'kum'   => 'кумик',
    'kut'   => 'кутенајски',
    'kv'    => 'коми',
    'kw'    => "корнуолски\ келтски",
    'ky'    => 'киргистански',
    'la'    => 'латински',
    'lad'   => 'ладино',
    'lag'   => 'Langi',
    'lah'   => 'ланда',
    'lam'   => 'ламба',
    'lb'    => 'луксембуршки',
    'lez'   => 'лежгијски',
    'lg'    => 'ганда',
    'li'    => 'лимбуршки',
    'ln'    => 'лингала',
    'lo'    => 'лао',
    'lol'   => 'монго',
    'loz'   => 'лози',
    'lt'    => 'литвански',
    'lu'    => "луба\-катанга",
    'lua'   => "луба\-лулуа",
    'lui'   => 'луизено',
    'lun'   => 'лунда',
    'luo'   => 'луо',
    'lus'   => 'лушајски',
    'luy'   => 'Luyia',
    'lv'    => 'латвиски',
    'mad'   => 'мадурески',
    'mag'   => 'магахи',
    'mai'   => 'маитхили',
    'mak'   => 'макасарски',
    'man'   => 'мандинго',
    'map'   => 'австронезиски',
    'mas'   => 'масаи',
    'mdf'   => 'мокша',
    'mdr'   => 'мандар',
    'men'   => 'мендески',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'малгашки',
    'mga'   => 'средноирски',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'маршалски',
    'mi'    => 'маорски',
    'mic'   => 'микмек',
    'min'   => 'минанкабау',
    'mis'   => "други\ јазици",
    'mk'    => 'македонски',
    'mkh'   => "мон\-кмерски\ јазици",
    'ml'    => 'малајалам',
    'mn'    => 'монголски',
    'mnc'   => 'манчу',
    'mni'   => 'манипури',
    'mno'   => 'манобо',
    'mo'    => 'молдавски',
    'moh'   => 'мохак',
    'mos'   => 'моси',
    'mr'    => 'марати',
    'ms'    => 'малезиски',
    'mt'    => 'малтешки',
    'mua'   => 'Mundang',
    'mul'   => "повеќе\ јазици",
    'mun'   => "мунда\ јазици",
    'mus'   => 'крик',
    'mwl'   => 'мирандески',
    'mwr'   => 'марвари',
    'my'    => 'бурмански',
    'myn'   => "мајански\ јазици",
    'myv'   => 'ержа',
    'na'    => 'науру',
    'nah'   => 'нахуатл',
    'nai'   => "северноамерикански\ индијански\ јазици",
    'nap'   => 'неаполски',
    'naq'   => 'Nama',
    'nb'    => "норвешки\ бокмал",
    'nd'    => "северен\ ндебеле",
    'nds'   => 'долногермански',
    'ne'    => 'непалски',
    'new'   => 'невари',
    'ng'    => 'ндонга',
    'nia'   => 'нијас',
    'nic'   => "нигер\-кордофаниски\ јазици",
    'niu'   => 'најуан',
    'nl'    => 'холандски',
    'nl_be' => "холандски\ \(во\ Белгија\)",
    'nmg'   => 'Kwasio',
    'nn'    => "норвешки\ ниноршк",
    'no'    => 'норвешки',
    'nog'   => 'ногај',
    'non'   => "стар\ норски",
    'nqo'   => 'нко',
    'nr'    => "јужен\ ндебелески",
    'nso'   => "северен\ сото",
    'nub'   => "нубијски\ јазици",
    'nus'   => 'Nuer',
    'nv'    => 'навахо',
    'nwc'   => "класичен\ невари",
    'ny'    => 'њања',
    'nym'   => 'њамвези',
    'nyn'   => 'њанколе',
    'nyo'   => 'њоро',
    'nzi'   => 'нзима',
    'oc'    => 'окситански',
    'oj'    => 'оџибва',
    'om'    => 'оромо',
    'or'    => 'орија',
    'os'    => 'осетиски',
    'osa'   => 'осаж',
    'ota'   => "отомански\ турски",
    'oto'   => "отомиски\ јазици",
    'pa'    => 'пунџаби',
    'paa'   => 'папуански',
    'pag'   => 'пангасинан',
    'pal'   => 'палависки',
    'pam'   => 'пампанга',
    'pap'   => 'папиаменто',
    'pau'   => 'палауански',
    'peo'   => "стар\ персиски",
    'phi'   => "филипински\ јазик",
    'phn'   => 'феникиски',
    'pi'    => 'пали',
    'pl'    => 'полски',
    'pon'   => 'понпејански',
    'pra'   => "пракритски\ јазици",
    'pro'   => "стар\ провенчал",
    'ps'    => 'пашто',
    'pt'    => 'португалски',
    'pt_br' => "португалски\ \(во\ Бразил\)",
    'pt_pt' => "португалски\ \(во\ Португалија\)",
    'qu'    => 'кечуа',
    'raj'   => 'раџастански',
    'rap'   => 'рапануи',
    'rar'   => 'раротонган',
    'rm'    => 'реторомански',
    'rn'    => 'рундиски',
    'ro'    => 'романски',
    'roa'   => "романски\ јазици",
    'rof'   => 'Rombo',
    'rom'   => 'ромски',
    'ru'    => 'руски',
    'rup'   => 'влашки',
    'rw'    => 'кињарванда',
    'rwk'   => 'Rwa',
    'sa'    => 'санскрит',
    'sad'   => 'сандаве',
    'sah'   => 'јакутски',
    'sai'   => "јужноамерикански\ индијански",
    'sal'   => "салишански\ јазици",
    'sam'   => "самариќански\ арамејски",
    'saq'   => 'Samburu',
    'sas'   => 'сасак',
    'sat'   => 'сантали',
    'sbp'   => 'Sangu',
    'sc'    => 'сардиниски',
    'scn'   => 'сицилијански',
    'sco'   => 'скоц',
    'sd'    => 'синди',
    'se'    => "северен\ самиски",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'селкап',
    'sem'   => 'семитски',
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'санго',
    'sga'   => "стар\ ирски",
    'sgn'   => "знаковни\ јазици",
    'sh'    => "српско\-хрватски",
    'shi'   => 'Tachelhit',
    'shn'   => 'шан',
    'si'    => 'синхалиски',
    'sid'   => 'сидамо',
    'sio'   => "сијуски\ јазици",
    'sit'   => 'синотибетански',
    'sk'    => 'словачки',
    'sl'    => "словенечки\ јазик",
    'sla'   => "словенски\ јазици",
    'sm'    => 'самоански',
    'sma'   => "јужен\ сами",
    'smi'   => "самиски\ јазици",
    'smj'   => "луле\ сами",
    'smn'   => "инари\ сами",
    'sms'   => "сколт\ сами",
    'sn'    => 'шона',
    'snk'   => 'сонинке',
    'so'    => 'сомалиски',
    'sog'   => 'согдијен',
    'son'   => 'сонгај',
    'sq'    => 'албански',
    'sr'    => 'српски',
    'srn'   => "срански\ тонго",
    'srr'   => 'серер',
    'ss'    => 'свати',
    'ssa'   => "нилско\-сахарски\ јазици",
    'ssy'   => 'Saho',
    'st'    => 'сесото',
    'su'    => 'сунданески',
    'suk'   => 'сукума',
    'sus'   => 'сусу',
    'sux'   => 'сумериски',
    'sv'    => 'шведски',
    'sw'    => 'свахили',
    'swb'   => 'коморијански',
    'swc'   => "Congo\ Swahili",
    'syc'   => "класичен\ сиријак",
    'syr'   => 'сиријак',
    'ta'    => 'тамилски',
    'tai'   => 'таи',
    'te'    => 'телугу',
    'tem'   => 'тимне',
    'teo'   => 'Teso',
    'ter'   => 'терено',
    'tet'   => 'тетум',
    'tg'    => 'таџикистански',
    'th'    => 'тајландски',
    'ti'    => 'тигрејски',
    'tig'   => 'тигре',
    'tiv'   => 'тив',
    'tk'    => 'туркменистански',
    'tkl'   => 'токелау',
    'tl'    => 'тагалог',
    'tlh'   => 'клингонски',
    'tli'   => 'тлингит',
    'tmh'   => 'тамашек',
    'tn'    => 'цвана',
    'to'    => 'тонга',
    'tog'   => "њаса\ тонга",
    'tpi'   => "ток\ писин",
    'tr'    => 'турски',
    'trv'   => 'Taroko',
    'ts'    => 'цонга',
    'tsi'   => 'цимшијански',
    'tt'    => 'татарски',
    'tum'   => 'тумбука',
    'tup'   => "туписки\ јазици",
    'tut'   => 'алтајски',
    'tvl'   => 'тувалу',
    'tw'    => 'тви',
    'twq'   => 'Tasawaq',
    'ty'    => 'тахитски',
    'tyv'   => 'тувинијански',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'удмурт',
    'ug'    => 'ујгурски',
    'uga'   => 'угаритски',
    'uk'    => 'украински',
    'umb'   => 'умбунду',
    'und'   => "непознат\ или\ неважечки\ јазик",
    'ur'    => 'урду',
    'uz'    => 'узбекистански',
    'vai'   => 'ваи',
    've'    => 'венда',
    'vi'    => 'виетнамски',
    'vo'    => 'волапјок',
    'vot'   => 'вотски',
    'vun'   => 'Vunjo',
    'wa'    => 'валунски',
    'wae'   => 'Walser',
    'wak'   => 'вакашански',
    'wal'   => 'валамо',
    'war'   => 'вареј',
    'was'   => 'вашо',
    'wen'   => 'сорбиски',
    'wo'    => 'волофски',
    'xal'   => 'калмик',
    'xh'    => 'хауса',
    'xog'   => 'Soga',
    'yao'   => 'јао',
    'yap'   => 'јапезе',
    'yav'   => 'Yangben',
    'yi'    => 'јидски',
    'yo'    => 'јоруба',
    'ypk'   => "јуписки\ јазици",
    'yue'   => 'кантонски',
    'za'    => 'жуанг',
    'zap'   => 'запотек',
    'zbl'   => 'блисимболс',
    'zen'   => 'зенага',
    'zh'    => 'кинески',
    'znd'   => 'зандиски',
    'zu'    => 'зулу',
    'zun'   => 'зуни',
    'zxx'   => "без\ лингвистичка\ содржина",
    'zza'   => 'заза',
);

%Locales::DB::Language::mk::name_to_code = (
    'aghem'                                                                => 'agq',
    'asu'                                                                  => 'asa',
    'bafia'                                                                => 'ksf',
    'bena'                                                                 => 'bez',
    'bodo'                                                                 => 'brx',
    'cayuga'                                                               => 'cay',
    'centralmoroccotamazight'                                              => 'tzm',
    'chiga'                                                                => 'cgg',
    'colognian'                                                            => 'ksh',
    'congoswahili'                                                         => 'swc',
    'embu'                                                                 => 'ebu',
    'gusii'                                                                => 'guz',
    'jolafonyi'                                                            => 'dyo',
    'kabuverdianu'                                                         => 'kea',
    'kalenjin'                                                             => 'kln',
    'koyraborosenni'                                                       => 'ses',
    'koyrachiini'                                                          => 'khq',
    'kwasio'                                                               => 'nmg',
    'langi'                                                                => 'lag',
    'luyia'                                                                => 'luy',
    'machame'                                                              => 'jmc',
    'makhuwameetto'                                                        => 'mgh',
    'makonde'                                                              => 'kde',
    'meru'                                                                 => 'mer',
    'morisyen'                                                             => 'mfe',
    'mundang'                                                              => 'mua',
    'nama'                                                                 => 'naq',
    'nuer'                                                                 => 'nus',
    'rombo'                                                                => 'rof',
    'rwa'                                                                  => 'rwk',
    'saho'                                                                 => 'ssy',
    'samburu'                                                              => 'saq',
    'sangu'                                                                => 'sbp',
    'sena'                                                                 => 'seh',
    'seneca'                                                               => 'see',
    'shambala'                                                             => 'ksb',
    'soga'                                                                 => 'xog',
    'tachelhit'                                                            => 'shi',
    'taita'                                                                => 'dav',
    'taroko'                                                               => 'trv',
    'tasawaq'                                                              => 'twq',
    'teso'                                                                 => 'teo',
    'vunjo'                                                                => 'vun',
    'walser'                                                               => 'wae',
    'yangben'                                                              => 'yav',
    'zarma'                                                                => 'dje',
    'абхазиски'                                                   => 'ab',
    'авади'                                                           => 'awa',
    'аварски'                                                       => 'av',
    'авестан'                                                       => 'ae',
    'австралиски'                                               => 'aus',
    'австронезиски'                                           => 'map',
    'адангме'                                                       => 'ada',
    'адиге'                                                           => 'ady',
    'азербејџански'                                           => 'az',
    'аину'                                                             => 'ain',
    'акадијски'                                                   => 'akk',
    'акан'                                                             => 'ak',
    'акинески'                                                     => 'ace',
    'аколи'                                                           => 'ach',
    'албански'                                                     => 'sq',
    'алгонквијански'                                         => 'alg',
    'алеут'                                                           => 'ale',
    'алтајски'                                                     => 'tut',
    'американскианглиски'                               => 'en_us',
    'амхариски'                                                   => 'am',
    'ангика'                                                         => 'anp',
    'англиски'                                                     => 'en',
    'англискивоАвстралија'                             => 'en_au',
    'англискивоВеликаБританија'                   => 'en_gb',
    'англискивоКанада'                                     => 'en_ca',
    'англискикреолски'                                     => 'cpe',
    'апачи'                                                           => 'apa',
    'аравак'                                                         => 'arw',
    'арагонески'                                                 => 'an',
    'арамејски'                                                   => 'arc',
    'арапахо'                                                       => 'arp',
    'арапски'                                                       => 'ar',
    'арокенски'                                                   => 'arn',
    'асамски'                                                       => 'as',
    'астуриски'                                                   => 'ast',
    'атапаски'                                                     => 'ath',
    'афар'                                                             => 'aa',
    'африкански'                                                 => 'af',
    'африхили'                                                     => 'afh',
    'афроазијатски'                                           => 'afa',
    'ацам'                                                             => 'cch',
    'ајмара'                                                         => 'ay',
    'балинезе'                                                     => 'ban',
    'балтички'                                                     => 'bat',
    'балучи'                                                         => 'bal',
    'бамбара'                                                       => 'bm',
    'бамилеке'                                                     => 'bai',
    'банда'                                                           => 'bad',
    'банту'                                                           => 'bnt',
    'баса'                                                             => 'bas',
    'баскиски'                                                     => 'eu',
    'батак'                                                           => 'btk',
    'башкирски'                                                   => 'ba',
    'безлингвистичкасодржина'                       => 'zxx',
    'белоруски'                                                   => 'be',
    'бемба'                                                           => 'bem',
    'бенгалски'                                                   => 'bn',
    'бербер'                                                         => 'ber',
    'беха'                                                             => 'bej',
    'бикол'                                                           => 'bik',
    'бини'                                                             => 'bin',
    'бислама'                                                       => 'bi',
    'бихари'                                                         => 'bh',
    'блин'                                                             => 'byn',
    'блисимболс'                                                 => 'zbl',
    'босански'                                                     => 'bs',
    'бојпури'                                                       => 'bho',
    'брај'                                                             => 'bra',
    'бретонски'                                                   => 'br',
    'бугарски'                                                     => 'bg',
    'буријат'                                                       => 'bua',
    'бурмански'                                                   => 'my',
    'буџински'                                                     => 'bug',
    'ваи'                                                               => 'vai',
    'вакашански'                                                 => 'wak',
    'валамо'                                                         => 'wal',
    'валунски'                                                     => 'wa',
    'вареј'                                                           => 'war',
    'вашо'                                                             => 'was',
    'велшки'                                                         => 'cy',
    'венда'                                                           => 've',
    'вештачки'                                                     => 'art',
    'виетнамски'                                                 => 'vi',
    'влашки'                                                         => 'rup',
    'волапјок'                                                     => 'vo',
    'волофски'                                                     => 'wo',
    'вотски'                                                         => 'vot',
    'га'                                                                 => 'gaa',
    'галициски'                                                   => 'gl',
    'ганда'                                                           => 'lg',
    'гајо'                                                             => 'gay',
    'гбаја'                                                           => 'gba',
    'гвишин'                                                         => 'gwi',
    'германски'                                                   => 'de',
    'германскивоАвстрија'                               => 'de_at',
    'германскивоШвајцарија'                           => 'de_ch',
    'германскијазици'                                       => 'gem',
    'гиз'                                                               => 'gez',
    'гилбертански'                                             => 'gil',
    'гонди'                                                           => 'gon',
    'горносорбиски'                                           => 'hsb',
    'горонтало'                                                   => 'gor',
    'готски'                                                         => 'got',
    'гребо'                                                           => 'grb',
    'грузиски'                                                     => 'ka',
    'грчки'                                                           => 'el',
    'гуарани'                                                       => 'gn',
    'гуџарати'                                                     => 'gu',
    'дакота'                                                         => 'dak',
    'дански'                                                         => 'da',
    'даргва'                                                         => 'dar',
    'дајак'                                                           => 'day',
    'делавер'                                                       => 'del',
    'дивехи'                                                         => 'dv',
    'динка'                                                           => 'din',
    'догри'                                                           => 'doi',
    'догриб'                                                         => 'dgr',
    'долногермански'                                         => 'nds',
    'долносорбиски'                                           => 'dsb',
    'дравидијски'                                               => 'dra',
    'другијазици'                                               => 'mis',
    'дуала'                                                           => 'dua',
    'еве'                                                               => 'ee',
    'евондо'                                                         => 'ewo',
    'еврејскоарапски'                                       => 'jrb',
    'еврејскоперсиски'                                     => 'jpr',
    'екајук'                                                         => 'eka',
    'еламит'                                                         => 'elx',
    'ержа'                                                             => 'myv',
    'ерменски'                                                     => 'hy',
    'есперанто'                                                   => 'eo',
    'естонски'                                                     => 'et',
    'ефик'                                                             => 'efi',
    'жаргончинук'                                               => 'chn',
    'жжи'                                                               => 'kaj',
    'жуанг'                                                           => 'za',
    'заза'                                                             => 'zza',
    'зандиски'                                                     => 'znd',
    'запотек'                                                       => 'zap',
    'зенага'                                                         => 'zen',
    'знаковнијазици'                                         => 'sgn',
    'зулу'                                                             => 'zu',
    'зуни'                                                             => 'zun',
    'ибан'                                                             => 'iba',
    'игбо'                                                             => 'ig',
    'идо'                                                               => 'io',
    'илоко'                                                           => 'ilo',
    'инарисами'                                                   => 'smn',
    'ингуш'                                                           => 'inh',
    'индискијазици'                                           => 'inc',
    'индоевропски'                                             => 'ine',
    'индонезиски'                                               => 'id',
    'интерлинг'                                                   => 'ie',
    'интерлингва'                                               => 'ia',
    'инуктитут'                                                   => 'iu',
    'инупијак'                                                     => 'ik',
    'ирански'                                                       => 'ira',
    'ироквијанскијазици'                                 => 'iro',
    'ирски'                                                           => 'ga',
    'исландски'                                                   => 'is',
    'источенфризиски'                                       => 'frs',
    'италијански'                                               => 'it',
    'ихо'                                                               => 'ijo',
    'кабардиски'                                                 => 'kbd',
    'кабиле'                                                         => 'kab',
    'кави'                                                             => 'kaw',
    'кавкаски'                                                     => 'cau',
    'кадо'                                                             => 'cad',
    'казакстански'                                             => 'kk',
    'калалисут'                                                   => 'kl',
    'калмик'                                                         => 'xal',
    'камба'                                                           => 'kam',
    'камбоџански'                                               => 'km',
    'каннада'                                                       => 'kn',
    'кантонски'                                                   => 'yue',
    'канури'                                                         => 'kr',
    'каракалпак'                                                 => 'kaa',
    'карашајбалкар'                                           => 'krc',
    'карелијски'                                                 => 'krl',
    'карен'                                                           => 'kar',
    'кариб'                                                           => 'car',
    'каси'                                                             => 'kha',
    'каталонски'                                                 => 'ca',
    'кашин'                                                           => 'kac',
    'кашмирски'                                                   => 'ks',
    'кашубиски'                                                   => 'csb',
    'кечуа'                                                           => 'qu',
    'кикују'                                                         => 'ki',
    'кимбунду'                                                     => 'kmb',
    'кинески'                                                       => 'zh',
    'киргистански'                                             => 'ky',
    'кињарванда'                                                 => 'rw',
    'класиченневари'                                         => 'nwc',
    'класиченсиријак'                                       => 'syc',
    'клингонски'                                                 => 'tlh',
    'козрејски'                                                   => 'kos',
    'коми'                                                             => 'kv',
    'коморијански'                                             => 'swb',
    'конго'                                                           => 'kg',
    'конкани'                                                       => 'kok',
    'коптски'                                                       => 'cop',
    'корејски'                                                     => 'ko',
    'корзикански'                                               => 'co',
    'корнуолскикелтски'                                   => 'kw',
    'коро'                                                             => 'kfo',
    'котанески'                                                   => 'kho',
    'којсанскијазици'                                       => 'khi',
    'кпеле'                                                           => 'kpe',
    'креолски'                                                     => 'crp',
    'кри'                                                               => 'cr',
    'крик'                                                             => 'mus',
    'кримскотурски'                                           => 'crh',
    'кру'                                                               => 'kro',
    'куањама'                                                       => 'kj',
    'кумик'                                                           => 'kum',
    'курдски'                                                       => 'ku',
    'курук'                                                           => 'kru',
    'кутенајски'                                                 => 'kut',
    'кушитски'                                                     => 'cus',
    'ладино'                                                         => 'lad',
    'ламба'                                                           => 'lam',
    'ланда'                                                           => 'lah',
    'лао'                                                               => 'lo',
    'латвиски'                                                     => 'lv',
    'латински'                                                     => 'la',
    'лежгијски'                                                   => 'lez',
    'лимбуршки'                                                   => 'li',
    'лингала'                                                       => 'ln',
    'литвански'                                                   => 'lt',
    'лози'                                                             => 'loz',
    'лојбански'                                                   => 'jbo',
    'лубакатанга'                                               => 'lu',
    'лубалулуа'                                                   => 'lua',
    'луизено'                                                       => 'lui',
    'луксембуршки'                                             => 'lb',
    'лулесами'                                                     => 'smj',
    'лунда'                                                           => 'lun',
    'луо'                                                               => 'luo',
    'лушајски'                                                     => 'lus',
    'магахи'                                                         => 'mag',
    'мадурески'                                                   => 'mad',
    'маитхили'                                                     => 'mai',
    'макасарски'                                                 => 'mak',
    'македонски'                                                 => 'mk',
    'малајалам'                                                   => 'ml',
    'малгашки'                                                     => 'mg',
    'малезиски'                                                   => 'ms',
    'малтешки'                                                     => 'mt',
    'мандар'                                                         => 'mdr',
    'мандинго'                                                     => 'man',
    'манипури'                                                     => 'mni',
    'манкс'                                                           => 'gv',
    'манобо'                                                         => 'mno',
    'манчу'                                                           => 'mnc',
    'маорски'                                                       => 'mi',
    'марати'                                                         => 'mr',
    'марвари'                                                       => 'mwr',
    'мари'                                                             => 'chm',
    'маршалски'                                                   => 'mh',
    'масаи'                                                           => 'mas',
    'мајанскијазици'                                         => 'myn',
    'мендески'                                                     => 'men',
    'микмек'                                                         => 'mic',
    'минанкабау'                                                 => 'min',
    'мирандески'                                                 => 'mwl',
    'мокша'                                                           => 'mdf',
    'молдавски'                                                   => 'mo',
    'монго'                                                           => 'lol',
    'монголски'                                                   => 'mn',
    'монкмерскијазици'                                     => 'mkh',
    'моси'                                                             => 'mos',
    'мохак'                                                           => 'moh',
    'мундајазици'                                               => 'mun',
    'навахо'                                                         => 'nv',
    'науру'                                                           => 'na',
    'нахуатл'                                                       => 'nah',
    'најуан'                                                         => 'niu',
    'ндонга'                                                         => 'ng',
    'неаполски'                                                   => 'nap',
    'невари'                                                         => 'new',
    'непалски'                                                     => 'ne',
    'непознатилиневажечкијазик'                   => 'und',
    'нзима'                                                           => 'nzi',
    'нигеркордофанискијазици'                       => 'nic',
    'нилскосахарскијазици'                             => 'ssa',
    'нијас'                                                           => 'nia',
    'нко'                                                               => 'nqo',
    'ногај'                                                           => 'nog',
    'норвешки'                                                     => 'no',
    'норвешкибокмал'                                         => 'nb',
    'норвешкининоршк'                                       => 'nn',
    'нубијскијазици'                                         => 'nub',
    'окситански'                                                 => 'oc',
    'орија'                                                           => 'or',
    'оромо'                                                           => 'om',
    'осаж'                                                             => 'osa',
    'осетиски'                                                     => 'os',
    'отоманскитурски'                                       => 'ota',
    'отомискијазици'                                         => 'oto',
    'оџибва'                                                         => 'oj',
    'палависки'                                                   => 'pal',
    'палауански'                                                 => 'pau',
    'пали'                                                             => 'pi',
    'пампанга'                                                     => 'pam',
    'пангасинан'                                                 => 'pag',
    'папиаменто'                                                 => 'pap',
    'папуански'                                                   => 'paa',
    'пашто'                                                           => 'ps',
    'персиски'                                                     => 'fa',
    'повеќејазици'                                             => 'mul',
    'полски'                                                         => 'pl',
    'понпејански'                                               => 'pon',
    'португалски'                                               => 'pt',
    'португалскивоБразил'                               => 'pt_br',
    'португалскивоПортугалија'                     => 'pt_pt',
    'португалскикреолски'                               => 'cpp',
    'пракритскијазици'                                     => 'pra',
    'пунџаби'                                                       => 'pa',
    'рапануи'                                                       => 'rap',
    'раротонган'                                                 => 'rar',
    'раџастански'                                               => 'raj',
    'реторомански'                                             => 'rm',
    'романски'                                                     => 'ro',
    'романскијазици'                                         => 'roa',
    'ромски'                                                         => 'rom',
    'рундиски'                                                     => 'rn',
    'руски'                                                           => 'ru',
    'салишанскијазици'                                     => 'sal',
    'самариќанскиарамејски'                           => 'sam',
    'самискијазици'                                           => 'smi',
    'самоански'                                                   => 'sm',
    'санго'                                                           => 'sg',
    'сандаве'                                                       => 'sad',
    'санскрит'                                                     => 'sa',
    'сантали'                                                       => 'sat',
    'сардиниски'                                                 => 'sc',
    'сасак'                                                           => 'sas',
    'свати'                                                           => 'ss',
    'свахили'                                                       => 'sw',
    'себуано'                                                       => 'ceb',
    'северенндебеле'                                         => 'nd',
    'северенсамиски'                                         => 'se',
    'северенсото'                                               => 'nso',
    'северенфризиски'                                       => 'frr',
    'северноамериканскииндијанскијазици' => 'nai',
    'селкап'                                                         => 'sel',
    'селтички'                                                     => 'cel',
    'семитски'                                                     => 'sem',
    'серер'                                                           => 'srr',
    'сесото'                                                         => 'st',
    'сидамо'                                                         => 'sid',
    'сиксика'                                                       => 'bla',
    'синди'                                                           => 'sd',
    'синотибетански'                                         => 'sit',
    'синхалиски'                                                 => 'si',
    'сиријак'                                                       => 'syr',
    'сицилијански'                                             => 'scn',
    'сичуанји'                                                     => 'ii',
    'сијускијазици'                                           => 'sio',
    'сколтсами'                                                   => 'sms',
    'скоц'                                                             => 'sco',
    'славски'                                                       => 'den',
    'словачки'                                                     => 'sk',
    'словенечкијазик'                                       => 'sl',
    'словенскијазици'                                       => 'sla',
    'согдијен'                                                     => 'sog',
    'сомалиски'                                                   => 'so',
    'сонгај'                                                         => 'son',
    'сонинке'                                                       => 'snk',
    'сорбиски'                                                     => 'wen',
    'сранскитонго'                                             => 'srn',
    'среденгорногермански'                             => 'gmh',
    'средноанглиски'                                         => 'enm',
    'средноирски'                                               => 'mga',
    'среднофранцуски'                                       => 'frm',
    'среднохоландски'                                       => 'dum',
    'српски'                                                         => 'sr',
    'српскохрватски'                                         => 'sh',
    'старанглиски'                                             => 'ang',
    'старвисокогермански'                               => 'goh',
    'старирски'                                                   => 'sga',
    'старнорски'                                                 => 'non',
    'старогрчки'                                                 => 'grc',
    'староегипетски'                                         => 'egy',
    'старперсиски'                                             => 'peo',
    'старпровенчал'                                           => 'pro',
    'старфранцуски'                                           => 'fro',
    'сукума'                                                         => 'suk',
    'сумериски'                                                   => 'sux',
    'сунданески'                                                 => 'su',
    'сусу'                                                             => 'sus',
    'тагалог'                                                       => 'tl',
    'таи'                                                               => 'tai',
    'тамашек'                                                       => 'tmh',
    'тамилски'                                                     => 'ta',
    'татарски'                                                     => 'tt',
    'тахитски'                                                     => 'ty',
    'тајландски'                                                 => 'th',
    'таџикистански'                                           => 'tg',
    'тви'                                                               => 'tw',
    'телугу'                                                         => 'te',
    'терено'                                                         => 'ter',
    'тетум'                                                           => 'tet',
    'тибетски'                                                     => 'bo',
    'тив'                                                               => 'tiv',
    'тигре'                                                           => 'tig',
    'тигрејски'                                                   => 'ti',
    'тимне'                                                           => 'tem',
    'тлингит'                                                       => 'tli',
    'токелау'                                                       => 'tkl',
    'токписин'                                                     => 'tpi',
    'тонга'                                                           => 'to',
    'тувалу'                                                         => 'tvl',
    'тувинијански'                                             => 'tyv',
    'тумбука'                                                       => 'tum',
    'тупискијазици'                                           => 'tup',
    'туркменистански'                                       => 'tk',
    'турски'                                                         => 'tr',
    'тјап'                                                             => 'kcg',
    'угаритски'                                                   => 'uga',
    'удмурт'                                                         => 'udm',
    'узбекистански'                                           => 'uz',
    'украински'                                                   => 'uk',
    'умбунду'                                                       => 'umb',
    'унгарски'                                                     => 'hu',
    'урду'                                                             => 'ur',
    'ујгурски'                                                     => 'ug',
    'фанг'                                                             => 'fan',
    'фанти'                                                           => 'fat',
    'фарски'                                                         => 'fo',
    'феникиски'                                                   => 'phn',
    'филипински'                                                 => 'fil',
    'филипинскијазик'                                       => 'phi',
    'финоугриски'                                               => 'fiu',
    'фински'                                                         => 'fi',
    'фиџиски'                                                       => 'fj',
    'фон'                                                               => 'fon',
    'француски'                                                   => 'fr',
    'францускивоКанада'                                   => 'fr_ca',
    'францускивоШвајцарија'                           => 'fr_ch',
    'францускикреолски'                                   => 'cpf',
    'фризиски'                                                     => 'fy',
    'фрулијански'                                               => 'fur',
    'фула'                                                             => 'ff',
    'хавајски'                                                     => 'haw',
    'хаитски'                                                       => 'ht',
    'хауза'                                                           => 'ha',
    'хауса'                                                           => 'xh',
    'хајда'                                                           => 'hai',
    'хебрејски'                                                   => 'he',
    'хереро'                                                         => 'hz',
    'хилигајнон'                                                 => 'hil',
    'химашали'                                                     => 'him',
    'хинди'                                                           => 'hi',
    'хиримоту'                                                     => 'ho',
    'хитите'                                                         => 'hit',
    'хмонг'                                                           => 'hmn',
    'холандски'                                                   => 'nl',
    'холандскивоБелгија'                                 => 'nl_be',
    'хрватски'                                                     => 'hr',
    'хупа'                                                             => 'hup',
    'цвана'                                                           => 'tn',
    'централноамериканскииндијански'         => 'cai',
    'цимшијански'                                               => 'tsi',
    'цонга'                                                           => 'ts',
    'црковнословенски'                                     => 'cu',
    'чагатај'                                                       => 'chg',
    'чаморо'                                                         => 'ch',
    'чамски'                                                         => 'cmc',
    'чеченски'                                                     => 'ce',
    'чешки'                                                           => 'cs',
    'чејенски'                                                     => 'chy',
    'чибча'                                                           => 'chb',
    'чипујан'                                                       => 'chp',
    'чироки'                                                         => 'chr',
    'чокто'                                                           => 'cho',
    'чувашки'                                                       => 'cv',
    'чуук'                                                             => 'chk',
    'шан'                                                               => 'shn',
    'швајцарскогермански'                               => 'gsw',
    'шведски'                                                       => 'sv',
    'шкотскогалски'                                           => 'gd',
    'шона'                                                             => 'sn',
    'шпански'                                                       => 'es',
    'шпанскивоПортугалија'                             => 'es_es',
    'јавански'                                                     => 'jv',
    'јакутски'                                                     => 'sah',
    'јао'                                                               => 'yao',
    'јапезе'                                                         => 'yap',
    'јапонски'                                                     => 'ja',
    'јидски'                                                         => 'yi',
    'јоруба'                                                         => 'yo',
    'јуженалтај'                                                 => 'alt',
    'јуженндебелески'                                       => 'nr',
    'јуженсами'                                                   => 'sma',
    'јужноамериканскииндијански'                 => 'sai',
    'јупискијазици'                                           => 'ypk',
    'њамвези'                                                       => 'nym',
    'њанколе'                                                       => 'nyn',
    'њасатонга'                                                   => 'tog',
    'њања'                                                             => 'ny',
    'њоро'                                                             => 'nyo',
    'џонга'                                                           => 'dz',
    'џула'                                                             => 'dyu',
);

1;
