package Catan::Map::Tile;
$Catan::Map::Tile::VERSION = '0.03';
use strict;
use warnings;
use parent 'Math::HexGrid::Hex';

use overload
  '""' => 'uuid',
  fallback => 1;

sub new
{
  my ($class, $q, $r, $number) = @_;

  my $self = $class->SUPER::new($q, $r);

  # yielding tiles need a number
  die 'new() requires a number' if $class->yields && ! $number;

  # non resource-producing yield nothing
  $self->{number} = $number || 0;
  return $self;
}

sub uuid   { $_[0]->{id} }
sub number { $_[0]->{number} }
sub yields { undef }
sub name   { $_[0]->{name} }
sub code   { $_[0]->{code} }

sub tile_neighbor_uuid
{
  my ($self, $direction) = @_;
  return $self->SUPER::hex_neighbor($direction)->id;
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Catan::Map::Tile

=head1 VERSION

version 0.03

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
