package MooseX::StrictAttributes::Meta::Attribute::Trait::Builder;
use Moose::Role;
use Scope::Upper ();

after 'attach_to_class' => sub {
    my ($attr, $class) = @_;
    return unless $attr->has_builder;
    Scope::Upper::reap(sub {
        return if $class->has_method($attr->builder);
        confess(sprintf("No %s method defined for attribute %s", $attr->builder, $attr->name));
    }, Scope::Upper::SCOPE(9)); # FIXME - Hideous and fragile.
};

package # Hide from PAUSE
    Moose::Meta::Attribute::Custom::Trait::StrictBuilder;

sub register_implementation { 'MooseX::StrictAttributes::Meta::Attribute::Trait::Builder' }

1;

__END__

=head1 NAME

MooseX::StrictAttributes::Meta::Attribute::Trait::Builder - An attribute metaclass trait which
composes a number of strictness traits into all attributes generated by the metaclass.

=head1 SYNOPSIS

    package My::Class
    use Moose;
    
    # Ok
    has foo ( isa => 'Bar', builder => '_build_foo', traits => [qw/ StrictBuilder /] );
    sub _build_foo { 'some foo' }

    # Throws exception
    has bar ( isa => 'Foo', builder => '_build_bar', traits => [qw/ StrictBuilder /] );

=head1 DESCRIPTION

Performs a check that the appropriate builder method is present for an attribute at the time
the attribute is added. This is used to ensure that all of your classes are 'whole' and do not
produce runtime errors.

Note: If you are building roles, and other roles will provide the C<_build> methods for some
of your attributes, then this trait is unsuitable. However in normal use, it is a good safety
net against mistyping method names.

=head1 BUGS AND SOURCE CODE

This software probably contains bugs somewhere, and the way in which some components
are implemented is not optimal.

Patches welcome. 

=head1 AUTHORS

Tomas Doran <bobtfish@bobtfish.net> (t0m on #moose)

=head1 COPYRIGHT AND LICENSE

Copyright 2008 Tomas Doran.

This library is free software; you can redistribute it and/or modify it under the same terms as Perl itself.
