package Dua::Parser;
use strict;
use warnings;
use Module::Pluggable::Object;

Module::Pluggable::Object->new(
    search_path => [ __PACKAGE__ ],
    require     => 1,
)->plugins;

my $BLANK_UA = {
    name       => 'UNKNOWN',
    is_bot     => 0,
    is_android => 0,
    is_ios     => 0,
    is_linux   => 0,
    is_windows => 0,
};

sub parse {
    my ($class, $dua) = @_;

    # Blank or '-'
    if ($dua->ua eq '' || $dua->ua eq '-') {
        return $BLANK_UA;
    }

    # Googlebot
    if ( my $googlebot = Dua::Parser::Googlebot->try($dua) ) {
        return $googlebot;
    }

    # Bingbot
    if ( my $bingbot = Dua::Parser::Bingbot->try($dua) ) {
        return $bingbot;
    }

    # AdIdxBot
    if ( my $adidxbot = Dua::Parser::AdIdxBot->try($dua) ) {
        return $adidxbot;
    }

    # BingPreview
    if ( my $bingpreview = Dua::Parser::BingPreview->try($dua) ) {
        return $bingpreview;
    }

    return $BLANK_UA;
}

1;

__END__

=encoding UTF-8

=head1 NAME

Dua::Parser - Parser of Dua


=head1 METHODS

=head2 parse($dua_obj)

Do parse


=head1 AUTHOR

Dai Okabayashi E<lt>bayashi@cpan.orgE<gt>


=head1 LICENSE

C<Dua> is free software; you can redistribute it and/or modify it under the terms of the Artistic License 2.0. (Note that, unlike the Artistic License 1.0, version 2.0 is GPL compatible by itself, hence there is no benefit to having an Artistic 2.0 / GPL disjunction.) See the file LICENSE for details.

=cut
