use Evo -modern;
use Test::More;
use Promises6 'deferred';

my ($d, @results);

sub store : prototype() {
  sub($v) { push @results, $v };
}

# notify && fulfill
$d = deferred;
$d->promise

  # pass all
  ->then(undef, undef, undef)

  # add -f1/p1
  ->then(sub($v) {"$v-f1"}, undef, sub($v) {"$v-p1"})

  # add -f1, pass progress
  ->then(sub($v) {"$v-f2"})

  # add -p1, pass fulfill
  ->then(undef, undef, sub($v) {"$v-p2"})

  # pass all
  ->then(undef, undef, undef)

  # store
  ->then(store, undef, store);

$d->notify(1);
$d->notify(2);
$d->resolve('val');
$d->resolve('bad');

is_deeply \@results, [qw(1-p1-p2 2-p1-p2 val-f1-f2 )];

# notify && rejection
@results = ();
$d       = deferred;
$d->promise

  # pass all
  ->then(undef, undef, undef)

  # rereject with -r1, add /p1, pass fulfill
  ->then(
  undef,
  sub($v) { deferred->reject("$v-r1")->promise },
  sub($v) {"$v-p1"}
  )

  # pass all
  ->then(undef, undef, undef)

  # store
  ->then(sub {fail}, store, store);

$d->notify(1);
$d->notify(2);
$d->reject('reason');
$d->reject('bad');
$d->resolve('bad');

is_deeply \@results, [qw(1-p1 2-p1 reason-r1 )];

done_testing;

1;
