package main;
use Evo::Base -strict;
use Evo;
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 80_000 * $ENV{TEST_EVO_PERF};
my $N      = 200_000;
my $COUNTER;

my $sender = Evo::Base->new;

my $t = timeit(
  $N,
  sub {
    my $me = Foo->new;
    Evo::mdn_subscribe $me,     $sender;
    Evo::mdn_broadcast $sender, 'foo';
    Evo::mdn_unsubscribe $me,   $sender;
  }
);

die unless $COUNTER == $N;
diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

{

  package Foo;
  use Evo::Base -base;
  sub when_message { $COUNTER++ }
}
done_testing;
