use Evo::Base -strict;
use Evo::Manager;
use Evo;
use Benchmark ':all';
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};


my $EXPECT = 4.5 * $ENV{TEST_EVO_PERF};
my $N      = 10;
my $L      = 10_000;

my $t = timeit(
  $N,
  sub {
    my $train = Evo::Manager->singleton->build_train;
    my $depth;
    $train->way->add(sub { }) for 1 .. $L;
    $train->way->add(sub { $depth = Evo::dsl_depth });
    $train->start();
    ok $depth == 1, "depth $depth is 1";
  }
);

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
